<?php
/*======================================================================*\
|| #################################################################### ||
|| # Yet Another Rank System v4.1.4 by TheLastSuperman                # ||
|| # Copyright  2011 by Innovation by Instinct, LLC.                 # ||
|| # ---------------------------------------------------------------- # ||
|| # For use with vBulletin Version 4.0.x                             # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| # Discussion and support available at                              # ||
|| # http://www.innovationbyinstinct.com                              # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'rank.php');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array();
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/class_bbcode.php');
$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

$this_script = 'rank';

// ######################## CHECK ADMIN PERMISSIONS #######################
/*
if (!can_administer('canadminusers'))
{
	print_cp_no_permission();
}
*/

if (!$vbulletin->options['ra_modcp'])
{
	print_stop_message('no_permission');
}

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header($vbphrase['ranks']);

// ************************************************************
// start functions

// ###################### Start showimage #######################
function construct_img_html($imagepath, $align = 'middle')
{
	// returns an image based on imagepath
	return '<img src="' . iif(substr($imagepath, 0, 7) != 'http://' AND substr($imagepath, 0, 1) != '/', '../', '') . "$imagepath\" alt=\"$imagepath\" align=\"$align\" border=\"0\"/>";
}

// ###################### Start getRankCategoryParentOptions #######################

function fetch_rank_parent_options($thisitem = '', $parentid = -1, $depth = 1)
{
	global $db, $iracache, $parentoptions;

	if (!is_array($iracache))
	{
	// check to see if we have already got the results from the database
		$iracache = array();
		$racats = $db->query_read("
			SELECT rank_cat_id, rank_cat_title, rank_cat_parentid
			FROM " . TABLE_PREFIX . "rank_cat
		");
		
		while ($racat = $db->fetch_array($racats))
		{
			$iracache["$racat[rank_cat_parentid]"]["$racat[rank_cat_id]"] = $racat;
		}
		$db->free_result($racats);
	}

	if (!is_array($parentoptions))
	{
		$parentoptions = array();
	}

	foreach($iracache["$parentid"] AS $cat)
	{
		if ($cat['rank_cat_id'] != $thisitem)
		{
			$parentoptions["$cat[rank_cat_id]"] = str_repeat('--', $depth) . ' ' . $cat['rank_cat_title'];
			if (is_array($iracache["$cat[rank_cat_id]"]))
			{
				fetch_rank_parent_options($thisitem, $cat['rank_cat_id'], $depth + 1);
			}
		}
	}
}

// ###################### Start get rank_cat_cache #######################

function cache_rank_cats($rank_cat_id = -1, $depth = 0, $display_rank_cat_id=0)
{
	// returns an array of rank cats with correct parenting and depth information

	global $db, $rank_cat_cache, $count;
	static $fcache, $i;
	
	if (!is_array($fcache))
	{
	// check to see if we have already got the results from the database
		$fcache = array();
		$rank_cats = $db->query_read("
			SELECT * FROM " . TABLE_PREFIX . "rank_cat
			" . iif($display_rank_cat_id, "WHERE rank_cat_id = $display_rank_cat_id", '') . "
			ORDER BY rank_cat_displayorder
		");
		while ($rank_cat = $db->fetch_array($rank_cats))
		{
			if ($display_rank_cat_id)
			{
			$rank_cat[rank_cat_parentid] = -1;
			}
			$fcache["$rank_cat[rank_cat_parentid]"]["$rank_cat[rank_cat_displayorder]"]["$rank_cat[rank_cat_id]"] = $rank_cat;
		}
	}

	// database has already been queried
	if (is_array($fcache["$rank_cat_id"]))
	{
		foreach ($fcache["$rank_cat_id"] AS $holder)
		{
			foreach ($holder AS $rank_cat)
			{
				$rank_cat_cache["$rank_cat[rank_cat_id]"] = $rank_cat;
				$rank_cat_cache["$rank_cat[rank_cat_id]"]['depth'] = $depth;
				unset($fcache["$rank_cat_id"]);
				cache_rank_cats($rank_cat['rank_cat_id'], $depth + 1, $display_rank_cat_id);
			} // end foreach ($val1 AS $key2 => $forum)
		} // end foreach ($fcache["$forumid"] AS $key1 => $val1)
	} // end if (found $fcache["$forumid"])
}

// end functions
// ************************************************************

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'manage';
}

// ###################### Start do REMOVE rank #######################
if ($_POST['do'] == 'doremoveissuedrank')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'issue_id' => TYPE_INT,
		'rank_id' => TYPE_INT,
		'validate' => TYPE_ARRAY
	));
	if (!empty($vbulletin->GPC['validate']))
	{
		foreach($vbulletin->GPC['validate'] AS $vbulletin->GPC['issue_id'] => $status)
		{
			if ($status == -1)
			{
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "rank_user WHERE issue_id = ". $vbulletin->GPC['issue_id'] ."");
			}
		}
		define('CP_REDIRECT', "rank.php?do=rankusers&rank_id=" . $vbulletin->GPC['rank_id']);
		print_stop_message('removed_rank_from_users_successfully');
	}
	else if (!empty($vbulletin->GPC['issue_id']))
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "rank_user WHERE issue_id = ". $vbulletin->GPC['issue_id'] ."");
		define('CP_REDIRECT', "rank.php?do=rankusers&rank_id=" . $vbulletin->GPC['rank_id']);
		print_stop_message('removed_rank_from_users_successfully');
	}
}

// ###################### Start Remove #######################

if ($_REQUEST['do'] == 'removeissuedrank')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'issue_id' => TYPE_INT
	));

	if (!empty($vbulletin->GPC['issue_id']))
	{
		$rank = $db->query_first("
			SELECT ra.rank_name, ra.rank_desc, ru.*, u.username
			FROM " . TABLE_PREFIX . "rank_user AS ru
			LEFT JOIN  " . TABLE_PREFIX . "rank AS ra ON (ra.rank_id = ru.rank_id)
			LEFT JOIN  " . TABLE_PREFIX . "user AS u ON (u.userid = ru.userid)
			WHERE ru.issue_id = ". $vbulletin->GPC['issue_id'] ."
		");
	}
	else
	{
		print_stop_message('no_ranks_defined');
	}
	if (empty($rank))
	{
		// no rank found!
		print_stop_message('no_ranks_defined');
	}

	print_form_header('rank', 'doremoveissuedrank');
	construct_hidden_code('issue_id', $vbulletin->GPC['issue_id']);
	construct_hidden_code('rank_id', $rank['rank_id']);
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row($vbphrase['are_you_sure_you_want_to_delete_this_rank']);
	print_description_row('<blockquote>' . construct_phrase($vbphrase["are_you_sure_you_want_to_remove_this_rank_1_2_from_3_reason_4"], $rank['rank_name'], $rank['rank_desc'],$rank['username'],$rank['issue_reason']) . '</blockquote>');
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}
// ###################### Start do edit rank #######################
if ($_POST['do'] == 'doeditissuedrank')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'issue_id' => TYPE_INT,
		'rank_id' => TYPE_INT,
		'rankuserid' => TYPE_INT,
		'rankusername' => TYPE_STR,
		'issue_reason' => TYPE_STR,
		'issue_time'	=> TYPE_ARRAY_INT
	));

	if (!empty($vbulletin->GPC['rankuserid']))
	{
		$user = $db->query_first("
			SELECT userid, username
			FROM " . TABLE_PREFIX . "user
			WHERE userid = ". $vbulletin->GPC['rankuserid'] ."
		");
	}
	else if (!empty($vbulletin->GPC['rankusername']))
	{
		$user = $db->query_first("
			SELECT userid, username
			FROM " . TABLE_PREFIX . "user
			WHERE username = '". $vbulletin->GPC['rankusername'] ."'
		");
	}
	else
	{
		print_stop_message('please_complete_required_fields');
	}

	if (empty($user))
	{
		// no users found!
		print_stop_message('no_users_matched_your_query');
	}
		require_once(DIR . '/includes/functions_misc.php');
		$vbulletin->GPC['issue_time'] = vbmktime(intval($vbulletin->GPC['issue_time']['hour']), intval($vbulletin->GPC['issue_time']['minute']), 0, intval($vbulletin->GPC['issue_time']['month']), intval($vbulletin->GPC['issue_time']['day']), intval($vbulletin->GPC['issue_time']['year']));


	$db->query_write("
		UPDATE " . TABLE_PREFIX . "rank_user
		SET 
			userid =  '". $user['userid'] ."',
			issue_reason = '" . addslashes($vbulletin->GPC['issue_reason']) . "',
			issue_time = '" . addslashes($vbulletin->GPC['issue_time']) . "'
		WHERE issue_id = ". $vbulletin->GPC['issue_id'] ."
	");

	define('CP_REDIRECT', 'rank.php?do=rankusers&amp;rank_id=' . $vbulletin->GPC['rank_id']);
	print_stop_message('give_rank_to_user_x_successfully', $user['username']);
}
// ###################### Start edit #######################
if ($_REQUEST['do'] == 'editissuedrank')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'issue_id' => TYPE_INT
	));

	if (empty($vbulletin->GPC['issue_id']))
	{
		print_stop_message('no_ranks_defined');
	}
		
	$rank = $db->query_first("
		SELECT ru.*, ra.* 
		FROM " . TABLE_PREFIX . "rank_user AS ru
		LEFT JOIN  " . TABLE_PREFIX . "rank AS ra ON (ra.rank_id = ru.rank_id)
		WHERE ru.issue_id = ". $vbulletin->GPC['issue_id'] ."
	");

   print_form_header();
   print_table_header(construct_phrase($vbphrase['x_y_id_z'], $vbphrase['rank_name'], $rank['rank_name'], $rank['rank_id']), 4, 0);

   echo "
   <col align=\"center\" style=\"white-space:nowrap\"></col>
   <col width=\"50%\" align=\"$stylevar[left]\"></col>
   <col align=\"center\" style=\"white-space:nowrap\"></col>
   <col align=\"center\" style=\"white-space:nowrap\"></col>
   ";

   print_cells_row(array(
           $vbphrase['rank_name'],
           $vbphrase['rank_description'],
           $vbphrase['rank_icon'],
           $vbphrase['rank_image'],
   ), 1, '', -1);
   
  echo "
  <tr>
		<td class=\"$bgclass\"><strong>$rank[rank_name]</strong></td>
		<td class=\"$bgclass\"><dfn>{$rank[rank_desc]}</dfn></td>
		<td class=\"$bgclass\" align=\"center\"><img src=\"" . iif(substr($rank[rank_icon_url], 0, 7) != 'http://' AND substr($rank[rank_icon_url], 0, 1) != '/', '../', '') . "$rank[rank_icon_url]\" border=\"0\"></td>
		<td class=\"$bgclass\" align=\"center\"><img src=\"" . iif(substr($rank[rank_img_url], 0, 7) != 'http://' AND substr($rank[rank_img_url], 0, 1) != '/', '../', '') . "$rank[rank_img_url]\" border=\"0\"></td>
  </tr>";
	print_table_footer();

	print_form_header('rank', 'doeditissuedrank');
	construct_hidden_code('issue_id', $vbulletin->GPC['issue_id']);
	construct_hidden_code('rank_id', $rank['rank_id']);
	print_table_header("$vbphrase[edit] $vbphrase[user_ranks]", 2, 0);
	print_input_row($vbphrase['userid'], 'rankuserid', $rank['userid']);
	print_input_row($vbphrase['username'], 'rankusername',$rank['username']);	
	print_textarea_row($vbphrase['rank_reason'], 'issue_reason', $rank['issue_reason'], 3, 33);
	print_time_row($vbphrase['rank_time'],'issue_time',$rank['issue_time']);
	print_submit_row($vbphrase['save']);
}

// ###################### Start do give rank #######################
if ($_POST['do'] == 'dogiverank')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'rank_id' => TYPE_INT,
		'rank_name' => TYPE_STR,
		'rank_img_url' => TYPE_STR,
		'rankuserid' => TYPE_INT,
		'rankusername' => TYPE_STR,
		'issue_reason' => TYPE_STR,
		'rank_sendpm' => TYPE_INT,
		'rank_sendemail' => TYPE_INT,
	));

	if (!empty($vbulletin->GPC['rankuserid']))
	{
		$user = $db->query_first("
			SELECT userid, username, email
			FROM " . TABLE_PREFIX . "user
			WHERE userid = ". $vbulletin->GPC['rankuserid'] ."
		");
	}
	else if (!empty($vbulletin->GPC['rankusername']))
	{
		$user = $db->query_first("
			SELECT userid, username
			FROM " . TABLE_PREFIX . "user
			WHERE username = '". $vbulletin->GPC['rankusername'] ."'
		");
	}
	else
	{
		print_stop_message('please_complete_required_fields');
	}

	if (empty($user))
	{
		// no users found!
		print_stop_message('no_users_matched_your_query');
	}

	if (empty($vbulletin->GPC['rank_id']))
	{
		// no users found!
		print_stop_message('no_ranks_defined');
	}

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "rank_user
		(rank_id, userid, issue_reason, issue_time) 
		VALUES ( '". $vbulletin->GPC['rank_id'] ."', '". $user['userid'] ."', '" . addslashes($vbulletin->GPC['issue_reason']) . "', " . time() . ")
	");
	$issue_id = mysql_insert_id(); 
	if ($vbulletin->GPC['rank_sendpm'])
	{
		if ($vbulletin->options['rank_pm_fromuserid'] != 0)
		{
//		    $fromuser = fetch_userinfo($vbulletin->options['rank_pm_fromuserid']);
		    $fromuser = verify_id('user', $vbulletin->options['rank_pm_fromuserid']);
		}
		else
		{
			$fromuser['userid'] = $vbulletin->userinfo['userid'];
			$fromuser['username'] = $vbulletin->userinfo['username'];
		}

		$username = unhtmlspecialchars($user['username']);
		$rank_id = $vbulletin->GPC['rank_id'];
		$rank_name = $vbulletin->GPC['rank_name'];
		$rank_img_url = $vbulletin->GPC['rank_img_url'];
		$issue_reason = $vbulletin->GPC['issue_reason'];
		eval(fetch_email_phrases('rank_pm'));
		$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
		$pmdm->set('fromuserid', $fromuser['userid']);
		$pmdm->set('fromusername', $fromuser['username']); 
		$pmdm->set('title', $subject);
		$pmdm->set('message', $message);
		$pmdm->set_recipients($user['username'], $null);
		$pmdm->set('dateline', TIMENOW);
		$pmdm->pre_save();
		
		// process errors if there are any
		$errors = $pmdm->errors;
		
		if (!empty($errors))
		{
			require_once(DIR . '/includes/functions_newpost.php');
			$error = construct_errors($errors); // this will take the preview's place
			eval(standard_error($error));
		}
		else
		{
			// everything's good!
			$pmdm->save();
			unset($pmdm);
		}
	}

	if ($vbulletin->GPC['rank_sendemail'])
	{
		if ($vbulletin->options['rank_pm_fromuserid'] != 0)
		{
		    $fromuser = verify_id('user', $vbulletin->options['rank_pm_fromuserid'],'true','true');
		}
		else
		{
			$fromuser['email'] = $vbulletin->userinfo['email'];
		}

		$username = unhtmlspecialchars($user['username']);
		$rank_id = $vbulletin->GPC['rank_id'];
		$rank_name = $vbulletin->GPC['rank_name'];
		$rank_img_url = $vbulletin->GPC['rank_img_url'];
		$issue_reason = $vbulletin->GPC['issue_reason'];
		eval(fetch_email_phrases('rank_pm'));

		vbmail($user['email'], $subject, $message, true, $fromuser['email']);
	}

	define('CP_REDIRECT', 'rank.php?do=rankusers&amp;rank_id=' . $vbulletin->GPC['rank_id']);
	print_stop_message('give_rank_to_user_x_successfully', $user['username']);
}

// ###################### Start issue rank #######################
if ($_REQUEST['do'] == 'rankusers')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'rank_id' => TYPE_INT
	));
	
	if (!$vbulletin->GPC['rank_id'])
	{
		print_stop_message('no_ranks_defined');
	}
	else
	{
		$rank = $db->query_first("
			SELECT rank_name, rank_desc, rank_icon_url, rank_img_url 
			FROM " . TABLE_PREFIX . "rank 
			WHERE rank_id = ". $vbulletin->GPC['rank_id'] ."
		");
	}
	$rank['rank_desc'] = $bbcode_parser->parse($rank['rank_desc']);

	if (empty($rank['rank_name']))
	{
		print_stop_message('no_ranks_defined');
	}
	// print rank information
	
	   print_form_header();
	   print_table_header(construct_phrase($vbphrase['x_y_id_z'], $vbphrase['rank_name'], $rank['rank_name'], $vbulletin->GPC['rank_id']), 4, 0);
	
	   echo "
	   <col align=\"center\" style=\"white-space:nowrap\"></col>
	   <col width=\"50%\" align=\"$stylevar[left]\"></col>
	   <col align=\"center\" style=\"white-space:nowrap\"></col>
	   <col align=\"center\" style=\"white-space:nowrap\"></col>
	   ";
	
		print_cells_row(array(
			$vbphrase['rank_name'],
			$vbphrase['rank_description'],
			$vbphrase['rank_icon'],
			$vbphrase['rank_image']
	   ), 1, '', -1);
	   
	  echo "
	  <tr>
			<td class=\"$bgclass\"><strong>$rank[rank_name]</strong></td>
			<td class=\"$bgclass\"><dfn>{$rank[rank_desc]}</dfn></td>
			<td class=\"$bgclass\" align=\"center\"><img src=\"" . iif(substr($rank[rank_icon_url], 0, 7) != 'http://' AND substr($rank[rank_icon_url], 0, 1) != '/', '../', '') . "$rank[rank_icon_url]\" border=\"0\"></td>
			<td class=\"$bgclass\" align=\"center\"><img src=\"" . iif(substr($rank[rank_img_url], 0, 7) != 'http://' AND substr($rank[rank_img_url], 0, 1) != '/', '../', '') . "$rank[rank_img_url]\" border=\"0\"></td>
	
	  </tr>";
		print_table_footer();



// print give rank to user block
	print_form_header('rank', 'dogiverank');
	construct_hidden_code('rank_id', $vbulletin->GPC['rank_id']);
	construct_hidden_code('rank_name', $rank['rank_name']);
	construct_hidden_code('rank_img_url', $rank['rank_img_url']);

	print_table_header("$vbphrase[add] $vbphrase[user_ranks]", 2, 0);
	print_description_row($vbphrase[give_user_rank_desc]);
	print_input_row($vbphrase['userid'], 'rankuserid');
	print_input_row($vbphrase['username'], 'rankusername');
	print_textarea_row($vbphrase['rank_reason'], 'issue_reason', '', 3, 33);
	print_checkbox_row($vbphrase['rank_sendpm'], 'rank_sendpm');
	print_checkbox_row($vbphrase['rank_sendemail'], 'rank_sendemail',0);

	print_submit_row($vbphrase['save']);
	
// print remove user's rank block
	print_form_header('rank', 'doremoveissuedrank');
	construct_hidden_code('rank_id', $vbulletin->GPC['rank_id']);
	print_table_header($vbphrase['users_with_ranks'], 5, 0);
   echo "
   <col align=\"center\" style=\"white-space:nowrap\"></col>
   <col width=\"50%\" align=\"$stylevar[left]\"></col>
   <col align=\"center\" style=\"white-space:nowrap\"></col>
   <col align=\"center\" style=\"white-space:nowrap\"></col>
   <col align=\"center\" style=\"white-space:nowrap\"></col>
   ";
	print_cells_row(array(
		$vbphrase['member'],
		$vbphrase['rank_reason'],
		$vbphrase['rank_time'],
		$vbphrase['controls'],
		$vbphrase['remove']
		), 1, '', -1);

		$rankusers = $db->query_read("
			SELECT ru.*, u.username
			FROM " . TABLE_PREFIX . "rank_user AS ru
			LEFT JOIN " . TABLE_PREFIX . "user AS u USING (userid)
			WHERE ru.rank_id=". $vbulletin->GPC['rank_id'] ."
		");
		while ($rankuser = $db->fetch_array($rankusers))
		{
				$rankuser['issue_reason'] = $bbcode_parser->parse($rankuser['issue_reason']);
		construct_hidden_code('issue_id', $rankuser[issueid]);
			$cell = array();
			$cell[] = "<b>$rankuser[username]</b>";
			$cell[] = "$rankuser[issue_reason]";
			$cell[] = '<span class="smallfont">' . vbdate($vbulletin->options['dateformat'], $rankuser['issue_time']) . ' ' . vbdate($vbulletin->options['timeformat'], $rankuser['issue_time']) . '</span>';
			$cell[] = "
				<a href=\"rank.php?$session[sessionurl]do=editissuedrank&issue_id=$rankuser[issue_id]\">$vbphrase[edit]</a>
				<a href=\"rank.php?$session[sessionurl]do=removeissuedrank&issue_id=$rankuser[issue_id]\">$vbphrase[remove]</a>
			";
			$cell[] = "
				<label for=\"d_$rankuser[issue_id]\"><input type=\"checkbox\" name=\"validate[$rankuser[issue_id]]\" id=\"d_$user[userid]\" value=\"-1\" tabindex=\"1\"/></label>
			";

//		managethread[{$thread[threadid]}][{$thread[forumid]}]	
//				<label for=\"d_$rankuser[issue_id]\"><input type=\"radio\" name=\"validate[$rankuser[issue_id]]\" value=\"-1\" id=\"d_$user[userid]\" tabindex=\"1\" />$vbphrase[delete]</label>
//				<label for=\"i_$rankuser[issue_id]\"><input type=\"radio\" name=\"validate[$rankuser[issue_id]]\" value=\"0\" id=\"i_$user[userid]\" tabindex=\"1\" checked=\"checked\" />$vbphrase[ignore]</label>


			print_cells_row($cell, 0, '', -4);
		}

    print_submit_row($vbphrase['remove'],0,5);
}


// ###################### Start manage ranks #######################
if ($_REQUEST['do'] == 'manage')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'rank_cat_id' => TYPE_INT,
		'massmove' => TYPE_INT
	));

// check rank_cat_id
	if ($vbulletin->GPC['rank_cat_id'])
	{
				if (!$check = $db->query_first("
					SELECT rank_cat_id 
					FROM " . TABLE_PREFIX . "rank_cat 
					WHERE rank_cat_id=". $vbulletin->GPC['rank_cat_id'] ."
				"))
			{
					print_stop_message('no_ranks_defined');
			}
	}
	
	$getranks = $db->query_read("
		SELECT ra.*, ra_c.rank_cat_title
		FROM " . TABLE_PREFIX . "rank AS ra
		LEFT JOIN " . TABLE_PREFIX . "rank_cat AS ra_c USING (rank_cat_id)
		" . iif($vbulletin->GPC['rank_cat_id'], "WHERE ra.rank_cat_id = ".$vbulletin->GPC['rank_cat_id']."", '') . "
		ORDER BY ra_c.rank_cat_displayorder,ra.rank_displayorder
	");
		
	while ($ra = $db->fetch_array($getranks))
	{
		if ($ra['rank_cat_id'] == -1)
		{
			$globalrank[] = $ra;
		}
		else
		{
			$rankcache[$ra['rank_cat_id']][$ra['rank_id']] = $ra;
		}
	}
	$db->free_result($getranks);

	// Obtain list of users of each rank
	$allrankusers =  $db->query_read("
		SELECT u.userid, u.username, ru.rank_id
		FROM " . TABLE_PREFIX . "rank_user AS ru
		LEFT JOIN " . TABLE_PREFIX . "user AS u ON (u.userid = ru.userid)
		GROUP BY u.userid, u.username, ru.rank_id
		ORDER BY u.userid
	");
	while( $ru = $db->fetch_array($allrankusers))
	{
		$rankuserscache[$ru['rank_id']][$ru['userid']] = $ru;
	}
	$db->free_result($allrankusers);
	
	cache_rank_cats(-1,0,$vbulletin->GPC['rank_cat_id']);

	// display category-specific ranks
	print_form_header('rank');
	construct_hidden_code('rank_catid', $rank_catid);
//	construct_hidden_code('massmove', $vbulletin->GPC['massmove']);
	
	print_table_header($vbphrase['rank_manager'], 6);

	// display global ranks (ranks has category -1)
	if (is_array($globalrank))
	{
		$rank_cat_info =	"\t\t<b>$vbphrase[unclassified_ranks]</b>";
		print_description_row($rank_cat_info, 0, 6);

		print_cells_row(array(
			$vbphrase['rank_icon'],
			$vbphrase['rank_image'],
			$vbphrase['rank_name'],
			$vbphrase['users_with_ranks'],
			$vbphrase['display_order'],
			$vbphrase['controls']
			), 1, '', -1);

		foreach($globalrank AS $rank_id => $rank)
		{
			$cell = array();

				$rankuserslist = '';
				if (is_array($rankuserscache[$rank['rank_id']]))
				{
					foreach($rankuserscache[$rank['rank_id']] AS $userid => $rankusers)
					{
						$rankuserslist .= ", $rankusers[username]";
					}
				}
				$rankuserslist = substr($rankuserslist , 2); // get rid of initial comma
				$rank['rank_desc'] = $bbcode_parser->parse($rank['rank_desc']);

		$cell[] = construct_img_html($rank['rank_icon_url']);
		$cell[] = construct_img_html($rank['rank_img_url']);
		$cell[] = "<strong>$rank[rank_name]<dfn>{$rank[rank_desc]}</dfn></strong>";
		$cell[] = "$rankuserslist";
		$cell[] = "$rank[rank_displayorder]";
		$cell[] = construct_link_code($vbphrase['give_user_rank'], "rank.php?$session[sessionurl]do=rankusers&rank_id=$rank[rank_id]");
		print_cells_row($cell, 0, '', 1);
		}
		print_table_footer();
		print_table_break();
	}

	foreach($rank_cat_cache AS $key => $rank_cat)
	{
		$rank_cat_info = "<b>" . 
			construct_depth_mark($rank_cat['depth'], '- - ', '- - ') 
			. "<a href=\"rank.php?$session[sessionurl]do=manage&rank_cat_id=$rank_cat[rank_cat_id]\">$rank_cat[rank_cat_title]</a></b>";

		print_table_header($rank_cat_info, 6, 0,'','center');
		if (!empty($rank_cat[rank_cat_desc]))
		{
			print_description_row($rank_cat[rank_cat_desc], 0, 6,'','center');
		}
			if (!$vbulletin->GPC['massmove'])
			{
				$action_title = $vbphrase['display_order'];
			} else {
				$action_title = $vbphrase['mass_move'];
			}		
		print_cells_row(array(
			$vbphrase['rank_icon'],
			$vbphrase['rank_image'],
			$vbphrase['rank_name'],
			$vbphrase['users_with_ranks'],
			$action_title,
			$vbphrase['controls']
			), 1, '', -1);

		if (is_array($rankcache[$rank_cat['rank_cat_id']]))
		{
			foreach($rankcache[$rank_cat['rank_cat_id']] AS $rank_id => $rank)
			{
				{
					$cell = array();
				$rank['rank_desc'] = $bbcode_parser->parse($rank['rank_desc']);
				$rankuserslist = '';
				if (is_array($rankuserscache[$rank['rank_id']]))
				{
					foreach($rankuserscache[$rank['rank_id']] AS $userid => $rankusers)
					{
						$rankuserslist .= ", $rankusers[username]";
					}
				}
				$rankuserslist = substr($rankuserslist , 2); // get rid of initial comma
				
				$cell[] = construct_img_html($rank['rank_icon_url']);
				$cell[] = construct_img_html($rank['rank_img_url']);
				if ($rank['rank_active'] == 1)
				{
					$cell[] = "<strong>$rank[rank_name]<dfn>{$rank[rank_desc]}</dfn></strong>";
				}
				else
				{
					$cell[] = "<strike><font color=red>$rank[rank_name]<dfn>{$rank[rank_desc]}</dfn></font></strike>";
				}
				$cell[] = "$rankuserslist";
				if (!$vbulletin->GPC['massmove'])
				{
							$cell[] = "$rank[rank_displayorder]";
				}
					else
				{
					if (!$options)
					{
						$parentoptions = array('-1' => $vbphrase["no_one"]);
						fetch_rank_parent_options();
						$options = construct_select_options($parentoptions);
			 		}
					$cell[] = '
						<select name="category[' . $rank[rank_id] . ']" class="bginput">' . $options . '</select>
					';
				}
				$cell[] = construct_link_code($vbphrase['give_user_rank'], "rank.php?$session[sessionurl]do=rankusers&rank_id=$rank[rank_id]");
				print_cells_row($cell, 0, '', 1);
				}
			}
		}
		else {
			print_description_row($vbphrase['no_ranks_in_this_category'], 0, 6);
		}
		print_description_row(' ', 0, 6);
	}

	print_table_footer();
}

// #############################################################################

print_cp_footer();

?>