<?php
/*======================================================================*\
|| #################################################################### ||
|| # Yet Another Rank System v4.1.4 by TheLastSuperman                # ||
|| # Copyright  2011 by Innovation by Instinct, LLC.                 # ||
|| # ---------------------------------------------------------------- # ||
|| # For use with vBulletin Version 4.0.x                             # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| # Discussion and support available at                              # ||
|| # http://www.innovationbyinstinct.com                              # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'rank_cat.php');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array();
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
// require_once('./includes/adminfunctions_profilefield.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminusers'))
{
	print_cp_no_permission();
}

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

// make sure we are dealing with avatars,smilies or icons

print_cp_header($vbphrase['ranks']);

// ************************************************************
// start functions

// ###################### Start getRankCategoryParentOptions #######################

function fetch_rank_parent_options($thisitem = '', $parentid = -1, $depth = 1)
{
	global $db, $iracache, $parentoptions;

	if (!is_array($iracache))
	{
	// check to see if we have already got the results from the database
		$iracache = array();
		$racats = $db->query_read("
			SELECT rank_cat_id, rank_cat_title, rank_cat_parentid
			FROM " . TABLE_PREFIX . "rank_cat
		");
		
		while ($racat = $db->fetch_array($racats))
		{
			$iracache["$racat[rank_cat_parentid]"]["$racat[rank_cat_id]"] = $racat;
		}
		$db->free_result($racats);
	}

	if (!is_array($parentoptions))
	{
		$parentoptions = array();
	}

	foreach($iracache["$parentid"] AS $cat)
	{
		if ($cat['rank_cat_id'] != $thisitem)
		{
			$parentoptions["$cat[rank_cat_id]"] = str_repeat('--', $depth) . ' ' . $cat['rank_cat_title'];
			if (is_array($iracache["$cat[rank_cat_id]"]))
			{
				fetch_rank_parent_options($thisitem, $cat['rank_cat_id'], $depth + 1);
			}
		}
	}
}

// ###################### Start get rank_cat_cache #######################

function cache_rank_cats($rank_cat_id = -1, $depth = 0)
{
	// returns an array of rank cats with correct parenting and depth information

	global $db, $rank_cat_cache, $count;
	static $racache, $i;
	
	if (!is_array($racache))
	{
	// check to see if we have already got the results from the database
		$racache = array();
		$rank_cats = $db->query_read("
			SELECT ra_c.*, COUNT(ra.rank_id) AS items
			FROM " . TABLE_PREFIX . "rank_cat AS ra_c
			LEFT JOIN " . TABLE_PREFIX . "rank AS ra USING(rank_cat_id)
			GROUP BY rank_cat_id
			ORDER BY rank_cat_displayorder
		");	
		while ($rank_cat = $db->fetch_array($rank_cats))
		{
			$racache["$rank_cat[rank_cat_parentid]"]["$rank_cat[rank_cat_displayorder]"]["$rank_cat[rank_cat_id]"] = $rank_cat;
		}
		$db->free_result($rank_cats);
	}

	// database has already been queried
	if (is_array($racache["$rank_cat_id"]))
	{
		foreach ($racache["$rank_cat_id"] AS $holder)
		{
			foreach ($holder AS $rank_cat)
			{
				$rank_cat_cache["$rank_cat[rank_cat_id]"] = $rank_cat;
				$rank_cat_cache["$rank_cat[rank_cat_id]"]['depth'] = $depth;
				unset($racache["$rank_cat_id"]);
				cache_rank_cats($rank_cat['rank_cat_id'], $depth + 1);
			} // end foreach ($val1 AS $key2 => $rank_cat)
		} // end foreach ($racache["$rank_cat_id"] AS $key1 => $val1)
	} // end if (found $racache["$rank_cat_id"])
}

// end functions
// ************************************************************

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'modifycat';
}

// #############################################################################

// ###################### Start Kill Category #######################
if ($_POST['do'] == 'killcat')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'rank_cat_id' => TYPE_INT,
		'destinationid' => TYPE_INT,
		'deleteitems' => TYPE_INT
	));

	if ($vbulletin->GPC['deleteitems'] == 1)
	{
			// get ranks belong to the category
		$ranks =  $db->query_read("
			SELECT rank_id
			FROM " . TABLE_PREFIX . "rank
			WHERE rank_cat_id = ". $vbulletin->GPC['rank_cat_id'] ."
		");
			while( $ra = $db->fetch_array($ranks))
			{
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "rank_user WHERE rank_id = $ra[rank_id]");
			}
	
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "rank WHERE rank_cat_id = ". $vbulletin->GPC['rank_cat_id'] ."");
		$extra = "vbphrase[ranks_deleted]";
	}
	else
	{
		$dest = $db->query_first("
			SELECT rank_cat_title
			FROM " . TABLE_PREFIX . "rank_cat
			WHERE rank_cat_id = ". $vbulletin->GPC['rank_cat_id'] ."
		");
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "rank
			SET rank_cat_id = ". $vbulletin->GPC['destinationid'] ."
			WHERE rank_cat_id = ". $vbulletin->GPC['rank_cat_id'] ."
		");
		$extra = "vbphrase[ranks_deleted]";
	}

	$db->query_write("
			UPDATE " . TABLE_PREFIX . "rank_cat
			SET rank_cat_parentid = '-1'
			WHERE rank_cat_parentid = ". $vbulletin->GPC['rank_cat_id'] ."
		");
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "rank_cat WHERE rank_cat_id = ". $vbulletin->GPC['rank_cat_id'] ."");

	define('CP_REDIRECT', "rank_cat.php?do=modifycat");
	print_stop_message('deleted_category_successfully');
}

// ###################### Start Remove Category #######################
if ($_REQUEST['do'] == 'removecat')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'rank_cat_id' => TYPE_INT
	));

	$categories = $db->query_read("
		SELECT * FROM " . TABLE_PREFIX . "rank_cat
		ORDER BY rank_cat_displayorder
	");
	if ($db->num_rows($categories) < 2)
	{
		print_stop_message('cant_remove_last_x_category',$vbphrase['ranks']);
	}
	else
	{
		$category = array();
		$destcats = array();
		$destcats[-1] = "$vbphrase[no_one]";
		while ($tmp = $db->fetch_array($categories))
		{
			if ($tmp['rank_cat_id'] == $vbulletin->GPC['rank_cat_id'])
			{
				$category = $tmp;
			}
			else
			{
				$destcats[$tmp['rank_cat_id']] = $tmp['rank_cat_title'];
			}
		}
		unset($tmp);
		$db->free_result($categories);

		echo "<p>&nbsp;</p><p>&nbsp;</p>\n";

		print_form_header('rank_cat', 'killcat');
		construct_hidden_code('rank_cat_id', $category['rank_cat_id']);
		print_table_header(construct_phrase($vbphrase['confirm_deletion_of_x_y'],$vbphrase['ranks'], $category['rank_cat_title']));
		print_description_row('<blockquote>' . construct_phrase($vbphrase["are_you_sure_you_want_to_delete_the_rank_category_called_x"], $category['rank_cat_title'], construct_select_options($destcats)) . '</blockquote>');
		print_submit_row($vbphrase['delete'], '', 2, $vbphrase['go_back']);
	}
}

// ###################### Start Update Category #######################
if ($_POST['do'] == 'insertcat')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'rank_cat_title' => TYPE_NOHTML,
		'rank_cat_desc' => TYPE_NOHTML,
		'rank_cat_displayorder' => TYPE_INT,
		'rank_cat_parentid' => TYPE_INT
	));

	$db->query_write("INSERT INTO " . TABLE_PREFIX . "rank_cat (
		rank_cat_id,rank_cat_title,rank_cat_desc,rank_cat_displayorder, rank_cat_parentid
	) VALUES (
		NULL, '" . addslashes($vbulletin->GPC['rank_cat_title']) . "','" . addslashes($vbulletin->GPC['rank_cat_desc']) . "','". intval($vbulletin->GPC['rank_cat_displayorder']) ."', '". intval($vbulletin->GPC['rank_cat_parentid']) ."'
	)");

	define('CP_REDIRECT', "rank_cat.php?do=modifycat");
	print_stop_message('saved_category_x_successfully', $vbulletin->GPC['rank_cat_title']);
}

// ###################### Start Add Category #######################
if ($_REQUEST['do'] == 'addcat')
{
	print_form_header('rank_cat', 'insertcat');
	print_table_header($vbphrase["add_new_rank_category"]);
	print_input_row($vbphrase['title'], 'rank_cat_title');
	print_input_row($vbphrase['description'],'rank_cat_desc');

	$parentoptions = array('-1' => $vbphrase["no_one"]);
	fetch_rank_parent_options($category['rank_cat_id']);

	print_select_row($vbphrase['rank_cat_parent'], 'rank_cat_parentid', $parentoptions,'-1');
	print_input_row($vbphrase['display_order'], 'rank_cat_displayorder',1);
	print_submit_row($vbphrase['save']);
}

// ###################### Start Update Category #######################
if ($_POST['do'] == 'updatecat')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'rank_cat_id' => TYPE_INT,
		'rank_cat_title' => TYPE_NOHTML,
		'rank_cat_desc' => TYPE_NOHTML,
		'rank_cat_displayorder' => TYPE_INT,
		'rank_cat_parentid' => TYPE_INT
	));

	if ($vbulletin->GPC['rank_cat_id'] == $vbulletin->GPC['rank_cat_parentid'])
	{
		print_stop_message('cant_parent_x_to_self', $vbulletin->GPC['rank_cat_title']);
	}
	else
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "rank_cat SET
			rank_cat_title = '" . addslashes($vbulletin->GPC['rank_cat_title']) . "',
			rank_cat_desc = '" . addslashes($vbulletin->GPC['rank_cat_desc']) . "',
			rank_cat_displayorder = ". $vbulletin->GPC['rank_cat_displayorder'] .",
			rank_cat_parentid = ". $vbulletin->GPC['rank_cat_parentid'] ."
			WHERE rank_cat_id = ". $vbulletin->GPC['rank_cat_id'] ."
		");
		define('CP_REDIRECT', "rank_cat.php?do=modifycat");
		print_stop_message('saved_category_x_successfully', $vbulletin->GPC['rank_cat_title']);
	}

}

// ###################### Start Edit Category #######################
if ($_REQUEST['do'] == 'editcat')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'rank_cat_id' => TYPE_INT
	));

	$category = $db->query_first("
		SELECT * FROM " . TABLE_PREFIX . "rank_cat
		WHERE rank_cat_id = ". $vbulletin->GPC['rank_cat_id'] ."
	");

	print_form_header('rank_cat', 'updatecat');
	construct_hidden_code('rank_cat_id', $category['rank_cat_id']);
	print_table_header(construct_phrase($vbphrase['x_y_id_z'], $vbphrase['rank_category'], $category['rank_cat_title'], $category['rank_cat_id']));
	print_input_row($vbphrase['rank_cat_title'], 'rank_cat_title', $category['rank_cat_title'], 0);
	print_input_row($vbphrase['description'],'rank_cat_desc',$category['rank_cat_desc']);

	$parentoptions = array('-1' => $vbphrase["no_one"]);
	fetch_rank_parent_options($category['rank_cat_id']);

	print_select_row($vbphrase["rank_cat_parent"], 'rank_cat_parentid', $parentoptions, $category['rank_cat_parentid']);
	print_input_row($vbphrase['display_order'], 'rank_cat_displayorder', $category['rank_cat_displayorder']);
	print_submit_row();
}

// ###################### Start Update Rank Category Display Order #######################
if ($_REQUEST['do'] == 'updateorder')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'order' => TYPE_NOCLEAN,
	));

	if (is_array($vbulletin->GPC['order']))
	{
		$categories = $db->query_read("
			SELECT rank_cat_id,rank_cat_displayorder
			FROM " . TABLE_PREFIX . "rank_cat
		");
		while ($category = $db->fetch_array($categories))
		{
			$rank_cat_displayorder = intval($vbulletin->GPC['order']["$category[rank_cat_id]"]);
			if ($category['rank_cat_displayorder'] != $rank_cat_displayorder)
			{
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "rank_cat
					SET rank_cat_displayorder = $rank_cat_displayorder
					WHERE rank_cat_id = $category[rank_cat_id]
				");
			}
		}
	}

	define('CP_REDIRECT', "rank_cat.php?do=modifycat");
	print_stop_message('saved_display_order_successfully');
}


// ###################### Start Modify Categories #######################
if ($_REQUEST['do'] == 'modifycat')
{

// ============================ 
 	cache_rank_cats();
 	if (empty($rank_cat_cache))
 	{
		print_stop_message("no_x_categories_found","$vbphrase[ranks]", "rank_cat.php?$session[sessionurl]do=addcat");
	}
	print_form_header('rank_cat', 'updateorder');
	print_table_header($vbphrase['rank_cat_manager'], 4);
	print_cells_row(array($vbphrase['title'], $vbphrase['ranks'], $vbphrase['display_order'], $vbphrase['controls']), 1, '', -1);

	// display individual category ranks
	foreach($rank_cat_cache AS $key => $rank_cat)
	{

		$cell = array();
		$cell[] = "<strong>" . construct_depth_mark($rank_cat['depth'], '- - ', '- - ') . "<a href=\"rank.php?$session[sessionurl]do=manage&amp;rank_cat_id=$rank_cat[rank_cat_id]\">$rank_cat[rank_cat_title]</a></strong><div style=\"padding-left: 16px\">{$rank_cat[rank_cat_desc]}</div>";

			$cell[] = vb_number_format($rank_cat['items']) . ' ' . "$vbphrase[ranks]";
			$cell[] = "<input type=\"text\" class=\"bginput\" name=\"order[$rank_cat[rank_cat_id]]\" value=\"$rank_cat[rank_cat_displayorder]\" tabindex=\"1\" size=\"3\" />";
			$cell[] =
				construct_link_code($vbphrase['mass_move'], "rank.php?$session[sessionurl]do=manage&amp;massmove=1&amp;rank_cat_id=$rank_cat[rank_cat_id]") .
				construct_link_code($vbphrase['view'], "rank.php?$session[sessionurl]do=manage&amp;rank_cat_id=$rank_cat[rank_cat_id]") .
				construct_link_code($vbphrase['edit'], "rank_cat.php?$session[sessionurl]do=editcat&amp;rank_cat_id=$rank_cat[rank_cat_id]").
				construct_link_code($vbphrase['delete'], "rank_cat.php?$session[sessionurl]do=removecat&amp;rank_cat_id=$rank_cat[rank_cat_id]");
				
		print_cells_row($cell, 0, '', -1);
	}
		print_submit_row($vbphrase['save_display_order'], NULL, 4);
		echo "<p align=\"center\">" . construct_link_code($vbphrase['add_new_rank_category'], "rank_cat.php?$session[sessionurl]do=addcat") . construct_link_code($vbphrase['show_all_ranks'], "rank.php?$session[sessionurl]do=manage")."</p>";
		
	print_table_footer();
}


// #############################################################################
print_cp_footer();

?>