/**
 *      SteamProfile.
 *
 *  : Nico Bergemann <barracuda415@yahoo.de>
 * Copyright 2009 Nico Bergemann
 *
 *         : Gl0BuZ
 *      <globuz@no-steam.ru>
 *      Copyright 2009 Gl0BuZ
 *
 *       : Alex 'Gl0BuZ' Shchepilov
 *      <globuz@no-steam.ru>
 *      Copyright 2010 Gl0BuZ
 *
 */

jQuery.fn.attrAppend = function(name, value) {
	var elem;
	return this.each(function(){
		elem = $(this);
		
		// ,   
		if(elem.attr(name) !== undefined && elem.attr(name) != "") {
			elem.attr(name, value + elem.attr(name));
		}
	});
};

function SteamProfile() {
	var basePath;
	var themePath;
	var showGameBanner;
	var showSliderMenu;
	var showTF2ItemsIcon;
	var profiles = [];
	var profileCache = {};
	var loadLock = false;
	var configLoaded = false;
	var configData;
	var profileTpl;
	var loadingTpl;
	var errorTpl;
	var lang = "russian";
	var langLocal = "russian";
	var langData = {
		english : {
			loading : "Loading...",
			no_profile : "This user has not yet set up their Steam Community profile.",
			private_profile : "This profile is private.",
			invalid_data : "Invalid profile data.",
			join_game : "Join Game",
			add_friend : "Add to Friends",
			view_tf2items : "View TF2 Backpack"
		},
		russian : {
			loading : "...",
			no_profile : "      Steam Community .",
			private_profile : "  .",
			invalid_data : "  .",
			join_game : "  ",
			add_friend : "  ",
			view_tf2items : " TF2 "
		},
		german : {
			loading : "Lade",
			no_profile : "Dieser Benutzer hat bisher kein Steam Community Profil angelegt.",
			private_profile : "Dieses Profil is privat.",
			invalid_data : "Ungultige Profildaten.",
			join_game : "Spiel beitreten",
			add_friend : "Als Freund hinzufugen",
			view_tf2items : "TF2 Rucksack ansehen"
		},
		portuguese : {
			loading : "Carregando",
			no_profile : "This user has not yet set up their Steam Community profile.",
			private_profile : "This profile is private.",
			invalid_data : "Invalid profile data.",
			join_game : "Entrar",
			add_friend : "Adicionar a sua lista de amigos",
			view_tf2items : "Ver Itens do TF2"
		}
	};

	this.init = function() {
		  //    <script>
		var scriptElement = $('script[src$=\'steamprofile.js\']');
		
		  //         <script>
		if(scriptElement.length === 0) {
			return;
		}
		
		 //     src
		basePath = scriptElement.attr('src').replace('steamprofile.js', '');
		
		 //  xml 
		jQuery.ajax({
			type: 'GET',
			url: basePath + 'steamprofile.xml',
			dataType: 'html',
			complete: function(request, status) {
				configData = $(request.responseXML);
				loadConfig();
			}
		});
	};
	
	this.refresh = function() {
		 // ,   
                 //    ds
		if(!configLoaded || loadLock) {
			return;
		}
		
		 //  
		loadLock = true;
		
		//    
		profiles = $('.steamprofile[title]');
		
		//    ?
		if(profiles.length === 0) {
			return;
		}

		//  id    
		profiles.each(function() {
			var profile = $(this);
			profile.data('profileID', $.trim(profile.attr('title')));
			profile.removeAttr('title');
		});

		//          
		profiles.empty().append(loadingTpl);
		
		//   
		loadProfile(0);
	};
	
	this.load = function(profileID) {
		// ,   
                //    
		if(!configLoaded || loadLock) {
			return;
		}
		
		//   
		profile = $('<div class="steamprofile"></div>');
		
		//  
		profile.append(loadingTpl);
		
		//  xml 
		jQuery.ajax({
			type: 'GET',
			url: getXMLProxyURL(profileID),
			dataType: 'xml',
			complete: function(request, status) {
				//        
				profile.empty().append(createProfile($(request.responseXML)));
			}
		});
		
		return profile;
	};
	
	this.isLocked = function() {
		return loadLock;
	};
	
	function getXMLProxyURL(profileID) {
		return basePath + 'xmlproxy.php?id=' + escape(profileID) + '&lang=' + escape(lang);
	}
	
	function getConfigString(name) {
		return configData.find('vars > var[name="' + name + '"]').text();
	}
	
	function getConfigBool(name) {
		return getConfigString(name).toLowerCase() == 'true';
	}
	
	function loadConfig() {
		showSliderMenu = getConfigBool('slidermenu');
		showGameBanner = getConfigBool('gamebanner');
		showTF2ItemsIcon = getConfigBool('tf2items');
		lang = getConfigString('language');
		langLocal = lang;
		
		//    ,     
		if(langData[langLocal] == null) {
			langLocal = "russian";
		}
	
		//   
		themePath = basePath + 'themes/' + getConfigString('theme') + '/';
		$('head').append('<link rel="stylesheet" type="text/css" href="' + themePath + 'style.css">');
		
		//  
		profileTpl = $(configData.find('templates > profile').text());
		loadingTpl = $(configData.find('templates > loading').text());
		errorTpl   = $(configData.find('templates > error').text());
		
		//      
		profileTpl.find('img').attrAppend('src', themePath);
		loadingTpl.find('img').attrAppend('src', themePath);
		errorTpl.find('img').attrAppend('src', themePath);
		
		 //  
		profileTpl.find('.sp-joingame').attr('title', langData[langLocal].join_game);
		profileTpl.find('.sp-addfriend').attr('title', langData[langLocal].add_friend);
		profileTpl.find('.sp-viewitems').attr('title', langData[langLocal].view_tf2items);
		loadingTpl.append(langData[langLocal].loading);
		
		//      
		configLoaded = true;
		
		//   
		SteamProfile.refresh();
	}

	function loadProfile(profileIndex) {
		// ,    
		if(profileIndex >= profiles.length) {
			//  
			loadLock = false;
			return;
		}
		
		var profile = $(profiles[profileIndex++]);
		var profileID = profile.data('profileID');
		
		if(profileCache[profileID] == null) {
			//   xml 
			jQuery.ajax({
				type: 'GET',
				url: getXMLProxyURL(profileID),
				dataType: 'xml',
				complete: function(request, status) {
					//     DOM   ID
					profileCache[profileID] = createProfile($(request.responseXML));
					//     
					profile.empty().append(profileCache[profileID]);
					//   
					loadProfile(profileIndex);
				}
			});
		} else {
			//    ,   
			var profileCopy = profileCache[profileID].clone();
			createEvents(profileCopy);
			profile.empty().append(profileCopy);
			//   
			loadProfile(profileIndex);
		}
	}

	function createProfile(profileData) {
		if (profileData.find('profile').length !== 0) {
			var profile;
		
			if (profileData.find('profile > steamID').text() == '') {
				//    
				return createError(langData[langLocal].no_profile);
			} else {
				//   
				profile = profileTpl.clone();
				var onlineState = profileData.find('profile > onlineState').text();
				
				//   ,    
				profile.find('.sp-badge').addClass('sp-' + onlineState);
				profile.find('.sp-avatar img').attr('src', profileData.find('profile > avatarIcon').text());
				profile.find('.sp-info a').append(profileData.find('profile > steamID').text());
				
				//    
				if (profileData.find('profile > visibilityState').text() == '1') {
					profile.find('.sp-info').append(langData[langLocal].private_profile);
				} else {
					profile.find('.sp-info').append(profileData.find('profile > stateMessage').text());
				}
				
				//   
				if (showGameBanner && profileData.find('profile > inGameInfo > gameLogoSmall').length !== 0) {
					profile.css('background-image', 'url(' + profileData.find('profile > inGameInfo > gameLogoSmall').text() + ')');
				} else {
					profile.removeClass('sp-bg-game');
					profile.find('.sp-bg-fade').removeClass('sp-bg-fade');
				}
				
				if(showSliderMenu) {
					if (profileData.find('profile > inGameInfo > gameJoinLink').length !== 0) {
						//   '' 
						profile.find('.sp-joingame').attr('href', profileData.find('profile > inGameInfo > gameJoinLink').text());
					} else {
						 //     ,   ''
						profile.find('.sp-joingame').remove();
					}
				
					if(showTF2ItemsIcon) {
						//   ' '
						profile.find('.sp-viewitems')
							.attr('href', 'http://tf2items.com/profiles/' + profileData.find('profile > steamID64').text());
					} else {
						profile.find('.sp-viewitems').remove();
					}
					
					//   '  ' 
					profile.find('.sp-addfriend')
						.attr('href', 'steam://friends/add/' + profileData.find('profile > steamID64').text());
					
					//   
					profile.find('.sp-avatar a, .sp-info a.sp-name')
						.attr('href', 'http://steamcommunity.com/profiles/' + profileData.find('profile > steamID64').text());
					
					createEvents(profile);
				} else {
					profile.find('.sp-extra').remove();
				}
			}
			
			return profile;
		} else if (profileData.find('response').length !== 0) {
			// steam community  
			return createError(profileData.find('response > error').text());
		} else {
			//     xml
			return createError(langData[langLocal].invalid_data);
		}
	}
	
	function createEvents(profile) {
		//    
		profile.find('.sp-handle').click(function() {
			profile.find('.sp-content').toggle(200);
		});
	}

	function createError(message) {
		var errorTmp = errorTpl.clone();
		errorTmp.append(message);	
		return errorTmp;
	}
}

$(document).ready(function() {
	SteamProfile = new SteamProfile();
	SteamProfile.init();
});