<?php
/**
 *	     SteamProfile.
 *
 *	 : Nico Bergemann <barracuda415@yahoo.de>
 *	Copyright 2009 Nico Bergemann
 *
 *         : Gl0BuZ
 *      <globuz@no-steam.ru>
 *      Copyright 2009 Gl0BuZ
 *
 *       : Alex 'Gl0BuZ' Shchepilov
 *      <globuz@no-steam.ru>
 *      Copyright 2010 Gl0BuZ
 *
 */

class SteamProfileDownloader extends CURL {
	public function __construct($sUrl, $sVariant) {
		parent::__construct($sUrl);
		
		$aCURLVersion = curl_version();
		$this->setUserAgent('SteamProfile/2.0.4 ('.$sVariant.'; PHP '.PHP_VERSION.'; cURL '.$aCURLVersion['version'].')');
		
		
		if(ini_get('safe_mode') == 'Off' || ini_get('safe_mode') === 0) {
			$this->setOption(CURLOPT_FOLLOWLOCATION, true);
			$this->setOption(CURLOPT_MAXREDIRS, 3);
		}
	}
	
	public function start() {
		$content = parent::start();
		
	
		if($content === false) {
			throw new Exception('cURL error ('.$this->getErrorMessage().')');
		}

		$iHTTPCode = $this->getHTTPCode();
		if($iHTTPCode < 200 || $iHTTPCode > 299) {
			throw new Exception("Steam Community server error (HTTP $iHTTPCode)");
		}
		
		return $content;
	}
}
?>
