<?php
/**
 *	     SteamProfile.
 *
 *	 : Nico Bergemann <barracuda415@yahoo.de>
 *	Copyright 2009 Nico Bergemann
 *
 *         : Gl0BuZ
 *      <globuz@no-steam.ru>
 *      Copyright 2009 Gl0BuZ
 *
 *       : Alex 'Gl0BuZ' Shchepilov
 *      <globuz@no-steam.ru>
 *      Copyright 2010 Gl0BuZ
 *
 */

class SteamID {
	private $sSteamID = '';
	private $sSteamComID = '';

	const STEAMID64_BASE = '76561197960265728';

	public function __construct($sID) {

		if(!extension_loaded('bcmath')) {
			throw new RuntimeException("  BCMath");
		}

		if($this->isValidSteamID($sID)) {
			$this->sSteamID = $sID;
			$this->sSteamComID = $this->convertToSteamComID($sID);
		} elseif($this->isValidComID($sID)) {
			$this->sSteamID = $this->convertToSteamID($sID);
			$this->sSteamComID = $sID;
		} else {
			$this->sSteamID = '';
			$this->sSteamComID = '';
		}
	}

	public function getSteamID() {
		return $this->sSteamID;
	}
	
	public function getSteamComID() {
		return $this->sSteamComID;
	}
	
	public function isValid() {
		return $this->sSteamID != '';
	}

	private function isValidSteamID($sSteamID) {
		return preg_match('/^(STEAM_)?[0-5]:[0-9]:\d+$/i', $sSteamID);
	}

	private function isValidComID($sSteamComID) {

		if(!preg_match('/^\d+$/i', $sSteamComID)) {
			return false;
		}

		if(bccomp(self::STEAMID64_BASE, $sSteamComID) == 1) {
			return false;
		}


		return true;
	}

	private function convertToSteamComID($sSteamID) {
		$aTMP = explode(':', $sSteamID);

		$sServer = $aTMP[1];
		$sAuth = $aTMP[2];

		if(count($aTMP) == 3 && $sAuth != '0' && is_numeric($sServer) && is_numeric($sAuth)) {
			$sComID = bcmul($sAuth, "2"); 
			$sComID = bcadd($sComID, $sServer); 
			$sComID = bcadd($sComID, self::STEAMID64_BASE); 
			
			
			$sComID = str_replace('.0000000000', '', $sComID);
			
			return $sComID;
		} else {
			throw new RuntimeException("Unable to convert Steam-ID");
		}
	}

	private function convertToSteamID($sSteamComID) {
		$sServer = bcmod($sSteamComID, '2') == '0' ? '0' : '1';
		$sCommID = bcsub($sSteamComID, $sServer);
		$sCommID = bcsub($sCommID, self::STEAMID64_BASE);
		$sAuth = bcdiv($sCommID, '2');

		return "STEAM_0:$sServer:$sAuth";
	}
}
?>
