<?php
/**
 *	Этот файл является частью модификации SteamProfile.
 *
 *	Автор скрипта: Nico Bergemann <barracuda415@yahoo.de>
 *	Copyright 2009 Nico Bergemann
 *
 *      Перевод на русский язык: Gl0BuZ
 *      <globuz@no-steam.ru>
 *      Copyright 2009 Gl0BuZ
 *
 *      Автор модификации: Alex 'Gl0BuZ' Shchepilov
 *      <globuz@no-steam.ru>
 *      Copyright 2010 Gl0BuZ
 *
 */

class CacheFile extends File {
	private $iLifetime = -1;

	public function __construct($sPath, $iLifetime = -1) {
		parent::__construct($sPath);
		$this->setLifetime($iLifetime);
	}
	
	public function getLifetime() {
		return $this->iLifetime;
	}

	public function setLifetime($iLifetime = -1) {
		$this->iLifetime = (int)$iLifetime;
	}
	
	public function isCached() {
		return $this->exists() && ($this->iLifetime == -1 || time() - $this->lastModified() <= $this->iLifetime);
	}
}
?>
