<?php
/**
 *	Этот файл является частью модификации SteamProfile.
 *
 *	Автор скрипта: Nico Bergemann <barracuda415@yahoo.de>
 *	Copyright 2009 Nico Bergemann
 *
 *      Перевод на русский язык: Gl0BuZ
 *      <globuz@no-steam.ru>
 *      Copyright 2009 Gl0BuZ
 *
 *      Автор модификации: Alex 'Gl0BuZ' Shchepilov
 *      <globuz@no-steam.ru>
 *      Copyright 2010 Gl0BuZ
 *
 */

class Cache {
	private $CacheDir = '';
	private $iLifetime = -1;
	private $sExtension = -1;

	public function __construct($CacheDir, $iLifetime = -1, $sExtension = 'dat') {
		$this->setCacheDir($CacheDir);
		$this->setLifetime($iLifetime);
		$this->setExtension($sExtension);
	}

	public function getCacheDir() {
		return $this->CacheDir;
	}
	
	public function setCacheDir($CacheDir) {
		if(!($CacheDir instanceof File)) {
			$CacheDir = new File($CacheDir);
		}
	
		if(!$CacheDir->exists()) {
			throw new RuntimeException("Cache directory \"$CacheDir\" does not exist.");
		}

		if(!$CacheDir->canWrite()) {
			throw new RuntimeException("Cache directory \"$CacheDir\" is not writable.");
		}
		
		$this->CacheDir = $CacheDir;
	}

	public function getLifetime() {
		return $this->iLifetime;
	}
	
	public function setLifetime($iLifetime) {
		$this->iLifetime = $iLifetime;
	}

	public function getExtension() {
		return $this->sExtension;
	}
	
	public function setExtension($sExtension) {
		$this->sExtension = $sExtension;
	}

	public function getFile($sIdentifier) {
		$sHash = function_exists('hash')? hash('md5', $sIdentifier) : md5($sIdentifier);
		$sFile = $sHash.'.'.$this->sExtension;
		$sPath = $this->CacheDir->getPath().'/'.$sFile;
		return new CacheFile($sPath, $this->iLifetime);
	}
}
?>
