<?php
/**
 *	     SteamProfile.
 *
 *	 : Nico Bergemann <barracuda415@yahoo.de>
 *	Copyright 2009 Nico Bergemann
 *
 *         : Gl0BuZ
 *      <globuz@no-steam.ru>
 *      Copyright 2009 Gl0BuZ
 *
 *       : Alex 'Gl0BuZ' Shchepilov
 *      <globuz@no-steam.ru>
 *      Copyright 2010 Gl0BuZ
 *
 */
class SteamProfileXMLProxyApp {
	public function run() {
		try {

			$Config = Config::load('xmlproxy.cfg');
			
			$iCacheLifetime = $Config->getInteger('cache.lifetime', 600);
			$sCacheDir= $Config->getString('cache.dir', 'cache');
			$bXMLHttpRequestOnly = $Config->getBoolean('proxy.check_header', true);
			$iDownloaderTimeout	= $Config->getInteger('downloader.timeout', 10);
			
			$Headers = new HTTPHeaders();
			
			if($bXMLHttpRequestOnly && $Headers->getRequest('X-Requested-With') != 'XMLHttpRequest') {
				$Headers->setResponseCode(204);
				return;
			}
		
			if(isset($_GET['id']) && !empty($_GET['id'])) {
				$sID = $_GET['id'];
			} else {
				throw new Exception('No profile ID assigned');
			}
			
			$SteamID = new SteamID($sID);
			$sXmlUrl = 'http://steamcommunity.com/';

			if(!$SteamID->isValid()) {
				if(!preg_match('/^[a-zA-Z0-9-_]+$/', $sID)) {
					throw new RuntimeException("Invalid profile alias");
				}
				
				$sXmlUrl .= 'id/'.$sID;
			} else {
				$sXmlUrl .= 'profiles/'.$SteamID->getSteamComID();
			}

			$sXmlUrl .= '?xml=1';
			
			if(isset($_GET['lang']) && !empty($_GET['lang'])) {
				$sLang = strtolower($_GET['lang']);
				$aValidLang = array(
					'danish',
					'czech',
					'dutch',
					'english',
					'finnish',
					'french',
					'german',
					'hungarian',
					'italian',
					'japanese',
					'norwegian',
					'polish',
					'portuguese',
					'romanian',
					'russian',
					'schinese',
					'spanish',
					'swedish',
					'tchinese',
					'thai'
				);
				
				if(in_array($sLang, $aValidLang)) {

					$sXmlUrl .= '&l='.$sLang;
				}
			}
			
			$XmlCache = new Cache($sCacheDir, $iCacheLifetime, 'xml');
			$XmlFile = $XmlCache->getFile($sXmlUrl);

			if(!$XmlFile->isCached()) {
				try {

					$Downloader = new SteamProfileXMLDownloader($sXmlUrl, 'Ajax');
					$Downloader->setTimeout($iDownloaderTimeout);
					$Downloader->setTrimExtra(true);
					$Downloader->setFilterCtlChars(true);
					
					$sXml = '';
					
					try {
						$sXml = $Downloader->start();
					} catch(Exception $e) {

						$Downloader->close();
						throw $e;
					}
					
					$Downloader->close();

					$XmlFile->writeString($sXml);

					clearstatcache();
				} catch(Exception $e) {
					if(!$XmlFile->exists()) {
						throw $e;
					}
				}
			}
			
			if(!$Headers->isModifiedSince($XmlFile->lastModified())) {
				$Headers->setResponseCode(304);
				return;
			} else {
				$Headers->setResponse('Content-Type', 'application/xml');
				$XmlFile->readStdOut();
			}
		} catch(Exception $e) {
			$Headers = new HTTPHeaders();
			$Headers->setResponse('Content-Type', 'application/xml');

			echo '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>';
			echo '<response><error><![CDATA['.$e->getMessage().']]></error></response>';
		}
	}
}
?>
