<?php
/**
 *	     SteamProfile.
 *
 *	 : Nico Bergemann <barracuda415@yahoo.de>
 *	Copyright 2009 Nico Bergemann
 *
 *         : Gl0BuZ
 *      <globuz@no-steam.ru>
 *      Copyright 2009 Gl0BuZ
 *
 *       : Alex 'Gl0BuZ' Shchepilov
 *      <globuz@no-steam.ru>
 *      Copyright 2010 Gl0BuZ
 *
 */

class SteamProfileXMLDownloader extends SteamProfileDownloader {
	private $bTrimExtra = false;
	private $bFilterCtlChars = false;

	public function __construct($sUrl, $sAppId) {
		parent::__construct($sUrl, $sAppId);
		$this->setReturnTransfer(true);
	}

	public function setTrimExtra($bTrimExtra) {
		$this->bTrimExtra = $bTrimExtra;
	}
	
	public function isTrimExtra() {
		return $this->bTrimExtra;
	}
	
	public function setFilterCtlChars($bFilterCtlChars) {
		$this->bFilterCtlChars = $bFilterCtlChars;
	}
	
	public function isFilterCtlChars() {
		return $this->bFilterCtlChars;
	}
	
	public function start() {
		$content = parent::start();
		
		if(strlen($content) == 0) {
			throw new Exception('Empty Steam Community data');
		}
		

		if($this->bTrimExtra) {
			$sEndToken = '</summary>';
			$iEndPos = strpos($content, $sEndToken);

			if($iEndPos !== false) {
				$content = substr($content, 0, $iEndPos + strlen($sEndToken));
				$content.= "\n</profile>";
			}
		}
		
		if($this->bFilterCtlChars) {
			$aCtlChr = array();

			for($i = 0; $i < 32; $i++) {
	
				if($i == 9 || $i == 10 || $i == 13) continue;
				$aCtlChr[] = chr($i);
			}

			$content = str_replace($aCtlChr, '', $content);
		}
		
		return $content;
	}
}
?>
