<?php
/**
 *	Этот файл является частью модификации SteamProfile.
 *
 *	Автор скрипта: Nico Bergemann <barracuda415@yahoo.de>
 *	Copyright 2009 Nico Bergemann
 *
 *      Перевод на русский язык: Gl0BuZ
 *      <globuz@no-steam.ru>
 *      Copyright 2009 Gl0BuZ
 *
 *      Автор модификации: Alex 'Gl0BuZ' Shchepilov
 *      <globuz@no-steam.ru>
 *      Copyright 2010 Gl0BuZ
 *
 */

class Classpath {
	private static $aPaths = array();

	public static function add($sPath) {
		self::$aPaths[] = $sPath;
	}

	public static function remove($sPath) {
		for($i = 0; $i < count(self::$aPaths); $i++) {
			if(self::$aPaths[$i] === $sPath) {
				unset(self::$aPaths[$i]);
				break;
			}
		}
	}

	public static function getPaths() {
		return self::$aPaths;
	}
}

function __autoload($sClassName) {
	$aPaths = Classpath::getPaths();

	foreach($aPaths as $sPath) {
		$sPath .= "/$sClassName.class.php";
		if(file_exists($sPath)) {
			require_once $sPath;
		}
	}
}
?>
