<?php
/**
 *	     SteamProfile.
 *
 *	 : Nico Bergemann <barracuda415@yahoo.de>
 *	Copyright 2009 Nico Bergemann
 *
 *         : Gl0BuZ
 *      <globuz@no-steam.ru>
 *      Copyright 2009 Gl0BuZ
 *
 *       : Alex 'Gl0BuZ' Shchepilov
 *      <globuz@no-steam.ru>
 *      Copyright 2010 Gl0BuZ
 *
 */

class CURL {
	private $cURLSession;
	private $rOutputFile;

	public function __construct($sURL) {
		if(!extension_loaded('curl') || !function_exists('curl_init')) {
			throw new RuntimeException('  cURL');
		}
	
		$this->cURLSession = curl_init($sURL);
	}
	
	protected function setOption($iOpt, $value) {
		curl_setopt($this->cURLSession, $iOpt , $value);
	}

	protected function getInfo($iOpt) {
		return curl_getinfo($this->cURLSession, $iOpt);
	}

	public function setOutputFile($file) {
		if(is_resource($file)) {
		$this->rOutputFile = $file;
			$this->setOption(CURLOPT_FILE, $file);
		} else {
			$this->rOutputFile = fopen($file, 'w+b');
			$this->setOption(CURLOPT_FILE, $this->rOutputFile);
		}
	}

	public function setReturnTransfer($bReturn) {
		$this->setOption(CURLOPT_RETURNTRANSFER, $bReturn);
	}

	public function setUserAgent($sUA) {
		$this->setOption(CURLOPT_USERAGENT, $sUA);
	}

	public function setTimeout($iTimeout) {
		$this->setOption(CURLOPT_TIMEOUT, $iTimeout);
	}

	public function setConnectTimeout($iTimeout) {
		$this->setOption(CURLOPT_CONNECTTIMEOUT, $iTimeout);
	}

	public function getHTTPCode() {
		return $this->getInfo(CURLINFO_HTTP_CODE);
	}

	public function getErrorMessage() {
		return curl_error($this->cURLSession);
	}

	public function start() {
		return curl_exec($this->cURLSession);
	}

	public function close() {
		curl_close($this->cURLSession);

		if(is_resource($this->rOutputFile)) {
			rewind($this->rOutputFile);
			fclose($this->rOutputFile);
		}
	}
}
?>
