#include <amxmodx>
#include <amxmisc>
#include <fun>

#define PLUGIN_NAME "Vampire Weapons"
#define PLUGIN_AUTHOR "Hafner"
#define PLUGIN_VERSION "1.2"

new cvar_vampire_weapons, cvar_maxHP, cvar_bonusHS, cvar_hudON, cvar_fadeON
new Trie:g_tWeaponsData, gmsgFade

public plugin_init()
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR)

	cvar_vampire_weapons = register_cvar("vw_on", "1")
	cvar_maxHP = register_cvar("vw_max_hp", "100")
	cvar_bonusHS = register_cvar("vw_bonus_hs", "2.0")
	cvar_fadeON = register_cvar("vw_fade_on", "1")
	cvar_hudON = register_cvar("vw_hud_on", "1")

	gmsgFade = get_user_msgid("ScreenFade");
	register_event("DeathMsg", "hook_death", "a", "1>0") 

	g_tWeaponsData = TrieCreate()

	LoadData()	
}

public plugin_end() {
    TrieDestroy( g_tWeaponsData )
}

LoadData()
{
	new szFilename[ 128 ]
	get_configsdir( szFilename, 127 )
	add( szFilename, 127, "/vampire_weapons.ini" )

	if( !file_exists( szFilename) )
	{
		server_print("[ERROR] vampire_weapons.ini file does not exist!")
		return
	}
    
	new iFile = fopen( szFilename, "rt" )
	if( !iFile )
	{
		server_print("[ERROR] vampire_weapons.ini file not readable!")
		return
	}

	new szData[ 512 ], szWeaponName[ 20 ], szHP[ 4 ], iHPvalue
	while( !feof( iFile ) )
	{
		fgets( iFile, szData, 511 )

		if( !szData[ 0 ] || szData[ 0 ] == '^n' || szData[ 0 ] == ';' || szData[ 0 ] == '/' && szData[ 1 ] == '/' )
		{
			continue
		}

		parse( szData, szWeaponName, 19, szHP, 3)
		strtolower( szWeaponName )
		iHPvalue = str_to_num( szHP )
		TrieSetCell( g_tWeaponsData, szWeaponName, iHPvalue )
	}

	fclose( iFile )
}

public hook_death()
{
	new Killer = read_data( 1 )
	new Victim = read_data( 2 )
	new szWeapon[20], vampireHP, iHPbonus
	read_data(4, szWeapon, 19)
	new Health = get_user_health(Killer)

	if( (Killer != Victim) && get_pcvar_num(cvar_vampire_weapons) )
    {
		if( TrieGetCell( g_tWeaponsData, szWeapon, iHPbonus ) )
		{
			if( 1 <= Health < get_pcvar_num(cvar_maxHP) )
			{
				if( (read_data(3) == 1) && !equali(szWeapon, "grenade") )
					vampireHP = floatround(iHPbonus*get_pcvar_float(cvar_bonusHS))
				else
					vampireHP = iHPbonus

				set_user_health( Killer, min( Health + vampireHP, get_pcvar_num(cvar_maxHP) ) )

				if( get_pcvar_num(cvar_hudON) )
				{
					set_hudmessage(0, 255, 0, -1.0, 0.15, 0, 1.0, 1.0, 0.1, 0.1, -1)
					show_hudmessage(Killer, "Healed +%d hp", vampireHP)
				}

				if( get_pcvar_num(cvar_fadeON) )
				{				
					message_begin(MSG_ONE, gmsgFade, {0,0,0}, Killer)
					write_short(1<<12) 
					write_short(1<<12)
					write_short(0x0000)
					write_byte(0)
					write_byte(0) 
					write_byte(200)  
					write_byte(75)  
					message_end()
				}
			}
		}
    }
}