<?php
/*-------------------------------------------------------+
| PHP-Fusion Content Management System
| Copyright  2002 - 2011 Nick Jones
| http://www.php-fusion.co.uk/
+--------------------------------------------------------+
| Type:  Panel
| Name: Basic Center News Page
| Version: 1.03
| File Name: basic_center_news_page.php
| Author: Fangree Productions
| Site: http://www.fangree.co.uk
| Contact: admin@fangree.co.uk
| Developers: Fangree_Craig
+--------------------------------------------------------+
| This program is released as free software under the
| Affero GPL license. You can redistribute it and/or
| modify it under the terms of this license which you
| can read by viewing the included agpl.txt or online
| at www.gnu.org/licenses/agpl.html. Removal of this
| copyright header is strictly prohibited without
| written permission from the original author(s).
+--------------------------------------------------------*/
require_once "../../maincore.php";
require_once THEMES."templates/header.php";

	if (file_exists(INFUSIONS."basic_center_news_panel/locale/".$settings['locale'].".php")) {
		include INFUSIONS."basic_center_news_panel/locale/".$settings['locale'].".php";
	} else {
		include INFUSIONS."basic_center_news_panel/locale/English.php";
	}
	include LOCALE.LOCALESET."news_cats.php";
	
	//Number of news  displayed 
	$min = 5;  //Minimum news to show for top level
    $max = 10; // Maximumnewsto show for lower level toggle
	
	/// Basic Center News panel Begins
	opentable($locale['cnp106']);
	if (!isset($_GET['rowstart']) OR !isnum($_GET['rowstart'])) { $_GET['rowstart'] = 0; }
	$rows = dbcount("(news_id)", DB_NEWS, "news_id!=''");
	$result = dbquery("SELECT tn.*, 
		tc.*, 
		tu.user_id, 
		tu.user_name, 
		tu.user_status 
		FROM ".DB_NEWS." 
		tn
		LEFT JOIN ".DB_USERS." tu ON tn.news_name=tu.user_id
		LEFT JOIN ".DB_NEWS_CATS." tc ON tn.news_cat=tc.news_cat_id
		WHERE ".groupaccess('news_visibility')." 
		AND (news_start='0'||news_start<=".time().") 
		AND (news_end='0'||news_end>=".time().") 
		AND news_draft='0' ORDER BY news_sticky DESC, news_datestamp DESC LIMIT ".($min + $max));

	if (dbrows($result)) {
		$news_count = 0;
	$i = 0;
	echo "<table cellpadding='0' cellspacing='1' width='100%' class='tbl-border'>\n<tr>\n";
	echo "<td width='5%' class='tbl2' style='text-align:center;white-space:nowrap'></td>\n";
	echo "<td width='5%' class='tbl2' style='text-align:center;white-space:nowrap'><strong>".$locale['cnp101']."</strong></td>\n";
	echo "<td width='5' class='tbl2' style='text-align:center;white-space:nowrap'><strong>".$locale['cnp105']."</strong></td>\n";
	echo "<td width='5' class='tbl2' style='text-align:center;white-space:nowrap'><strong>".$locale['cnp102']."</strong></td>\n";
	echo "</tr>\n";

	while($data = dbarray($result)) {
	if ($news_count == $min) {
	echo "</table><br /><div align='center'>&raquo; <a href=\"javascript:void(0)\" onClick=\"toggle_news();\"><span id='show_more_news_text'>".$locale['cnp107']."</span></a> &laquo;</div><div id='show_more_news' style='display: none;'><br />
	<table cellpadding='0' cellspacing='1' width='100%' class='tbl-border'>"; }
	
	//Get Table row colours
	$row_color = ($i % 2 == 0 ? "tbl1" : "tbl2");
	echo "<tr>\n";
	echo "<td width='20%' class='".$row_color."'>";
	//News Subject
	$itemsubject = trimlink($data['news_subject'], 40);
	echo "<strong><a href='".BASEDIR."news.php?readmore=".$data['news_id']."' class='small'>$itemsubject</a></strong><br />\n";
	echo "</td>\n";
	//News Date
	echo "<td width='10%' align='center' class='".$row_color."'>";
	echo"<span class='side' style='text-align: center;'> ".showdate("shortdate", $data['news_datestamp'])."</span>";
	//News Author
	echo "<td width='1%' class='".$row_color."' style='text-align:center;white-space:nowrap'>".profile_link($data['user_id'], $data['user_name'], $data['user_status'])."</span></td>";
	//News Reads
	echo "<td width='2%' class='".$row_color."' style='text-align:center;white-space:nowrap'>".$data['news_reads']."</td>\n";
	echo "</tr>\n";
	
	$i++;
	$news_count ++;
	}
	echo "</table>\n";
	 if ($news_count > $min) { echo "</div>\n"; }
	   add_to_footer("<script type='text/javascript'>
<!--
function toggle_news() {
	var smu = document.getElementById('show_more_news');
	  var smutxt = document.getElementById('show_more_news_text');
	   if (smu.style.display == 'none') {
		  smu.style.display = 'block';
		  smutxt.innerHTML = '".$locale['cnp108']."';
	     } else {
       smu.style.display = 'none';
	 smutxt.innerHTML = '".$locale['cnp107']."';
	}
  }
//-->
</script>");
	} 
	// If No News do this
	else {
	echo "<div style='text-align:left'>".$locale['cnp104']."</div>\n";
	}

	closetable();
	
require_once THEMES."templates/footer.php";
?>