<?php




/*======================================================================*\
|| #################################################################### ||
|| # vBExperience 3.8                                                 # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2006-2009 Marius Czyz. All Rights Reserved.           # ||
|| #################################################################### ||
\*======================================================================*/

error_reporting(E_ALL & ~E_NOTICE);
define('THIS_SCRIPT', 'xperience');

$gap_notallowed = array("points_user_infractions", "points_thread_tnc", "points_user_activity", "points_post_den", "points_xperience", "points_thread", "points_user", "points_post", "points_misc");

$phrasegroups = array('xperience', 'user', 'cpoption', 'socialgroups', 'cppermission');


$specialtemplates = array(
	'xperience_singleaward'
);

$globaltemplates = array(
	'headinclude',
	'navbar',		
	'xperience_ranking',
	'xperience_ranking_bit',
	'xperience_awards',
	'xperience_singleaward',
	'xperience_award_bit',
	'xperience_awards_awardbit',
	'xperience_awards_awardbit_legacy',
	'xperience_awards_awardbit_empty',
	'xperience_awards_bit',
	'xperience_awards_awardbit_category',
	'xperience_navbar',
	'xperience_shop',
	'xperience_shop_cat',
	'xperience_shop_item_c',
	'xperience_shop_item_p',
	'xperience_shop_item',
	'xperience_shop_item_own',
	'xperience_stats',
	'xperience_stats_entries',
	'xperience_stats_entry',
	'xperience_stats_header',
	'xperience_stats_entries_empty',
	'xperience_stats_entry_empty',
	'xperience_navbar_css',
	'xperience_promotion_entry',
	'xperience_promotion_overview_entry',
	'xperience_promotions',
	'xperience_promotion_overview',
	'xperience_promotion_overview_entry_header',
	'xperience_promotion_overview_heighest',
	'xperience_promotion_overview_benefits_per',
	'xperience_promotion_overview_benefits_set',
	'xperience_earn',
	'xperience_earn_entry',
	'xperience_shop_ga_choose',
	'xperience_shop_ta',
	'xperience_shop_ta_entry',	
	'xperience_groups_ranking',
	'xperience_groups_ranking_bit',
	'xperience_gap_choose',
	'xperience_gap_choose_fields',
	'xperience_gap_entry',
	'xperience_activities',
	'xperience_activities_dateentry',
	'xperience_activities_entry',
	'xperience_awards_logbit',
	'xperience_shop_ta_ga_entry',
	'xperience_achievements',
	'xperience_achievements_bit',
	'xperience_achievements_bit_category',
	'xperience_achievements_field',
	'xperience_achievements_logbit',
);

$actiontemplates = array();

require_once('./global.php');


if (!$vbulletin->options['xperience_enabled']) 
{
	eval('standard_error($vbphrase[xperience_disabled]);');

	exit;
}

// permissions check
if (!($permissions['forumpermissions'] & $vbulletin->bf_ugp_forumpermissions['canview']) OR !($permissions['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canviewmembers']))
{
	print_no_permission();
}

// ######################### CLEAN GPC ############################
	$go = $vbulletin->input->clean_gpc('r', 'go', TYPE_NOHTML);
	$do = $vbulletin->input->clean_gpc('r', 'do', TYPE_NOHTML);
	$perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_UINT);
	$pagenumber = $vbulletin->input->clean_gpc('r', 'page', TYPE_UINT);
	$userid = $vbulletin->input->clean_gpc('r', 'userid', TYPE_UINT);
	$username = unhtmlspecialchars($vbulletin->input->clean_gpc('r', 'username', TYPE_STR));
	$sortfield = unhtmlspecialchars($vbulletin->input->clean_gpc('r', 'sortfield', TYPE_NOHTML));
	$sortorder = unhtmlspecialchars($vbulletin->input->clean_gpc('r', 'sortorder', TYPE_NOHTML));

	$navbits = array();
	$navbits[$parent] = $vbphrase['xperience_ranking'];

	$xperience_version = $vbphrase['xperience_name']." 3.8.5 Beta 4";

	require_once('./includes/functions_xperience.php');
	require_once('./includes/class_xperience.php');

if ($go == "promotions")
{
	$xperience_tabs['xperience_promotions'] = 'class="selected"';
	$navbits[$parent] = $vbphrase['xperience_promotions'];
	if (!$vbulletin->options['xperience_use_promotions'])
	{
		eval('standard_error($vbphrase[xperience_disabled]);');
		exit;
	}


	require_once(DIR . '/includes/class_bitfield_builder.php');
	$BFBo =& vB_Bitfield_Builder::init(); 
	vB_Bitfield_Builder::build(false);


	$data = fetch_xperience($vbulletin->userinfo['userid']);

	$promotionq = $vbulletin->db->query_read("SELECT
		p.from_ug,
		p.comment,
		u_fr.*,
		u_fr.title as fr_title
		FROM " . TABLE_PREFIX . "xperience_promotion AS p
		LEFT JOIN " . TABLE_PREFIX . "usergroup AS u_fr ON u_fr.usergroupid=p.from_ug
		GROUP BY from_ug
		ORDER BY u_fr.title, p.sortorder, p.field		
	");
	
	$foundpromotion = 1;
	$oldusergrouparray = array();
				
	if ($vbulletin->db->num_rows($promotionq) > 0)
	{
		while ($promotion = $vbulletin->db->fetch_array($promotionq))
		{
			
			$ingroup = false;
			if (is_member_of($vbulletin->userinfo, $promotion['from_ug']))
			{
				$ingroup = true;
			}
			
			$groupcountsq = $db->query_read("SELECT
				COUNT(userid) AS total
				FROM " . TABLE_PREFIX . "user AS user
				WHERE usergroupid = ".$promotion['from_ug']."
			");
			if ($vbulletin->db->num_rows($groupcountsq) > 0)
			{	
				$groupcounts = $vbulletin->db->fetch_array($groupcountsq);
			}
			
			$count_users = vb_number_format($groupcounts['total']);


			if ($vbulletin->options['xperience_promotions_show_benefits'] AND count($oldusergrouparray) > 0)
			{
				$promotion_benefits_revoked = "";
				$promotion_benefits_assigned = "";
				$promotion_benefits_allowances = "";
				$promotion_benefits = 1;
				FetchBenefits($oldusergrouparray, $promotion, $BFBo);
			}

			if ($vbulletin->options['xperience_promotions_show_jumps'])
			{
	
				$promotionsubq = $vbulletin->db->query_read("SELECT
					p.*,
					u_to.*,
					u_to.title as to_title,
					u_fr.title as fr_title
					FROM " . TABLE_PREFIX . "xperience_promotion AS p
					LEFT JOIN " . TABLE_PREFIX . "usergroup AS u_to ON u_to.usergroupid=p.to_ug
					LEFT JOIN " . TABLE_PREFIX . "usergroup AS u_fr ON u_fr.usergroupid=p.from_ug
					WHERE from_ug=".$promotion['from_ug']."
					ORDER BY u_fr.title, p.sortorder, p.field		
					LIMIT 0,50
				");
				
				if ($vbulletin->db->num_rows($promotionsubq) > 0)
				{	
					while ($promotionsub = $vbulletin->db->fetch_array($promotionsubq))
					{

						$field = $vbphrase['xperience_'.$promotionsub[field]]; 
						if (strlen($field)<1)
						{
							$field = $promotionsub["field"];
						}
						
						$value = vb_number_format($promotionsub['value']);
					
						$compare = $vbphrase['xperience_achievements_'.$promotionsub['compare']];
						
						$yours = vb_number_format($data[$promotionsub[field]]);
										
						$state_image = "icon_state_no.png";
						switch ($promotionsub['compare'])
						{
							case "-1":
								if ($data[$promotionsub[field]] < $promotionsub['value'])
								{
									$state_image = "icon_state_yes.png";
								}
								break;
							case "1":
								if ($data[$promotionsub[field]] > $promotionsub['value'])
								{
									$state_image = "icon_state_yes.png";
								}
								break;
							default:
								if ($data[$promotionsub[field]] == $promotionsub['value'])
								{
									$state_image = "icon_state_yes.png";
								}
								break;
						}
	
						eval('$promotion_conditions .= "' . fetch_template('xperience_promotion_overview_entry_header') . '";');
						eval('$promotion_conditions .= "' . fetch_template('xperience_promotion_overview_entry') . '";');
					}
				}
			}
			exec_switch_bg();
			eval('$promotions .= "' . fetch_template('xperience_promotion_overview') . '";');
			
			$promotion_conditions = "";
			$oldusergrouparray = $promotion;
		}

		$promotion_benefits = "";
		$ingroup = false;
		if (is_member_of($vbulletin->userinfo, $vbulletin->options['xperience_promotions_uug']))
		{
			$ingroup = true;

		}

			
		$promotionq = $vbulletin->db->query_read("SELECT
			p.to_ug,
			p.comment,
			u_to.*,
			u_to.title as fr_title
			FROM " . TABLE_PREFIX . "xperience_promotion AS p
			LEFT JOIN " . TABLE_PREFIX . "usergroup AS u_to ON u_to.usergroupid=p.to_ug
			WHERE to_ug=".$vbulletin->options['xperience_promotions_uug']."
			ORDER BY p.sortorder, p.field		
			LIMIT 0,50
		");
		$uug = $vbulletin->options['xperience_promotions_uug'];
		

		
		if ($vbulletin->db->num_rows($promotionq) > 0)
		{
			$promotion = $vbulletin->db->fetch_array($promotionq);
			
			

			if ($vbulletin->options['xperience_promotions_show_benefits'] AND count($oldusergrouparray) > 0)
			{
				$promotion_benefits_revoked = "";
				$promotion_benefits_assigned = "";
				$promotion_benefits_allowances = "";
				$promotion_benefits = 1;
				FetchBenefits($oldusergrouparray, $promotion, $BFBo);
			}

			$groupcountsq = $db->query_read("SELECT
				COUNT(userid) AS total
				FROM " . TABLE_PREFIX . "user AS user
				WHERE usergroupid = ".$promotion['to_ug']."
			");
			if ($vbulletin->db->num_rows($groupcountsq) > 0)
			{	
				$groupcounts = $vbulletin->db->fetch_array($groupcountsq);
			}
			
			$count_users = vb_number_format($groupcounts['total']);

			exec_switch_bg();

			eval('$promotions .= "' . fetch_template('xperience_promotion_overview') . '";');

		}
		$promotion_conditions = "";
	}
	
	
	$date_start = mktime(0, 0, 0, date("m"), date("d") - 21, date("Y"));
	$date_end = mktime(23, 59, 59, date("m"), date("d"), date("Y"));
		
	$all = array();
	$all = GetActivityPromotions($date_start, $date_end, 0, $vbulletin->options['xperience_activities_limit']);

	if (count($all) > 0)
	{
		arsort($all); 
		$foundactivity = 1;

		foreach ($all AS $key => $item)
		{
			
			$activities['date'] = vbdate($vbulletin->options['dateformat'], $item[0]);
			if ($currentdate <> $activities['date'])
			{
				if ($currentdate <> "")
				{
					$promotionslogbits .="<br/>";
				}
				eval('$promotionslogbits .= "' . fetch_template('xperience_activities_dateentry') . '";');
			}
			$currentdate = $activities['date'];
		
			$promotionslogbits .= $item[1];
			
		}
		$promotionslogbits .= "<br/>";
	}

	$template = 'xperience_promotions';

}
elseif ($go == "activities")
{
	$xperience_tabs['xperience_activities'] = 'class="selected"';
	$navbits[$parent] = $vbphrase['xperience_activities'];
	if (!$vbulletin->options['xperience_use_activities'])
	{
		eval('standard_error($vbphrase[xperience_disabled]);');
		exit;
	}


	$year = $vbulletin->input->clean_gpc('r', 'year', TYPE_INT);
	$month = $vbulletin->input->clean_gpc('r', 'month', TYPE_INT);
	$day = $vbulletin->input->clean_gpc('r', 'day', TYPE_INT);
	$name = "";
	
	if ($year > 0 AND $month > 0 AND $day > 0)
	{
		$date_start = mktime(0, 0, 0, $month, $day, $year);
		$date_end = mktime(23, 59, 59, $month, $day, $year);
		GetActivityAll($date_start, $date_end, $do, 999);
	}
	else
	{
		$date_start = mktime(0, 0, 0, date("m"), date("d") - 7, date("Y"));
		$date_end = mktime(23, 59, 59, date("m"), date("d"), date("Y"));
		GetActivityAll($date_start, $date_end, $do, $vbulletin->options['xperience_activities_limit']);
	}
	
	if (strlen($activity) > 0)
	{
		$foundactivity = 1;
	}

	$template = 'xperience_activities';


		
		
} 
elseif ($go == "stats")
{
	$xperience_tabs['xperience_stats'] = 'class="selected"';
	$navbits[$parent] = $vbphrase['xperience_stats'];
	if (!$vbulletin->options['xperience_use_stats'])
	{
		eval('standard_error($vbphrase[xperience_disabled]);');
		exit;
	}

	switch ($do) 
	{
		case "thread":
			$stats = fetch_statistics("thread");
			$statsname = $vbphrase['xperience_points_thread'];
			break;
		case "post":
			$stats = fetch_statistics("post");
			$statsname = $vbphrase['xperience_points_post'];
			break;
		case "misc":
			$stats = fetch_statistics("misc");
			$statsname = $vbphrase['xperience_points_misc'];
			break;
		default:
			$stats = fetch_statistics("user");
			$statsname = $vbphrase['xperience_points_user'];
	}
	$template = 'xperience_stats';



}
elseif ($go == "earn")
{
$xperience_tabs['xperience_earn'] = 'class="selected"';
$navbits[$parent] = $vbphrase['xperience_earn'];
	if (!$vbulletin->options['xperience_use_earn'])
	{
		eval('standard_error($vbphrase[xperience_disabled]);');
		exit;
	}



	$settingphrase = array();
	$phrases = $db->query_read("
		SELECT varname, text
		FROM " . TABLE_PREFIX . "phrase
		WHERE fieldname = 'vbsettings' AND
			languageid=-1 OR languageid=" . LANGUAGEID . "
			ORDER BY languageid ASC
	");
	while($phrase = $db->fetch_array($phrases))
	{
		$settingphrase["$phrase[varname]"] = $phrase['text'];
	}

	switch ($do)
	{
		case "thread":
			$name = $vbphrase['xperience_points_for_thread'];
			$earnpoints .= ResolveAssociation("xperience_points_pt", "", "points_threads");
			$earnpoints .= ResolveAssociation("xperience_points_psgt", "","points_threads_sg");
			$earnpoints .= ResolveAssociation("xperience_points_pb", "", "points_thread_tags");
			$earnpoints .= ResolveAssociation("xperience_points_po", "", "points_thread_votes");
			$earnpoints .= ResolveAssociation("xperience_points_pr", "", "points_thread_replycount");
			$earnpoints .= ResolveAssociation("xperience_points_pv", "", "points_thread_views");
			$earnpoints .= ResolveAssociation("xperience_points_ps", "", "points_thread_stickies");
			
			($hook = vBulletinHook::fetch_hook('xperience_earn_thread')) ? eval($hook) : false;
			
			break;
		case "post":
			$name = $vbphrase['xperience_points_for_post'];
			$earnpoints .= ResolveAssociation("xperience_points_pp", "", "points_posts");
			$earnpoints .= ResolveAssociation("xperience_points_psgp", "", "points_posts_sg");
			$earnpoints .= ResolveAssociation("xperience_points_pa", "", "points_post_attachment");
			$earnpoints .= ResolveAssociation("xperience_points_pav", "attachmentviewslog", "points_post_attachment_views");
			$earnpoints .= ResolveAssociation("xperience_points_ph", "thanks", "points_post_thanks");
			$earnpoints .= ResolveAssociation("xperience_points_phu", "thanks", "points_post_thanks_use");
			
			($hook = vBulletinHook::fetch_hook('xperience_earn_post')) ? eval($hook) : false;
			
			break;
		case "misc":
			$name = $vbphrase['xperience_points_for_misc'];
			$earnpoints .= ResolveAssociation("xperience_points_pw", "local_linkslink", "points_misc_ldm");
			$earnpoints .= ResolveAssociation("xperience_points_pw", "dl_files", "points_misc_dl2");
			$earnpoints .= ResolveAssociation("xperience_points_py", "cybppdonate", "points_misc_ppd");
			$earnpoints .= ResolveAssociation("xperience_points_pn", "blog", "points_misc_vbblog");
			$earnpoints .= ResolveAssociation("xperience_points_events", "", "points_misc_events");
			
			($hook = vBulletinHook::fetch_hook('xperience_earn_misc')) ? eval($hook) : false;

			$name = $vbphrase['xperience_points_misc_custom'];
			$description = $vbphrase['xperience_points_misc_custom_desc'];
			
			global $bgclass, $altbgclass;
			exec_switch_bg();
			eval('$earnpoints .= "' . fetch_template('xperience_earn_entry') . '";');
			
			break;
		default:
			$name = $vbphrase['xperience_points_for_user'];
			$earnpoints .= ResolveAssociation("xperience_points_pi", "", "points_user_infractions");
			$earnpoints .= ResolveAssociation("xperience_points_pu", "", "points_user_reputation");
			$earnpoints .= ResolveAssociation("xperience_points_puu", "", "points_user_reputation_use");
			$earnpoints .= ResolveAssociation("xperience_points_pd", "", "points_user_online");
			$earnpoints .= ResolveAssociation("xperience_points_pg", "", "points_user_socialgroup");
			$earnpoints .= ResolveAssociation("xperience_points_pe", "", "points_user_friends");
			$earnpoints .= ResolveAssociation("xperience_points_pm", "", "points_user_visitormessages");
			$earnpoints .= ResolveAssociation("xperience_points_pc", "", "points_user_albumpictures");
			$earnpoints .= ResolveAssociation("xperience_points_pf", "", "points_user_referrals");
			$earnpoints .= ResolveAssociation("xperience_points_upr", "", "points_user_profile");			
			($hook = vBulletinHook::fetch_hook('xperience_earn_user')) ? eval($hook) : false;		


	}


	$template = 'xperience_earn';



}
elseif ($go == "shop")
{
	$xperience_tabs['xperience_shop'] = 'class="selected"';
	$navbits[$parent] = $vbphrase['xperience_shop'];
	if (!$vbulletin->options['xperience_use_shop'])
	{
		eval('standard_error($vbphrase[xperience_disabled]);');
		exit;
	}
	
	$cat = $vbulletin->input->clean_gpc('r', 'cat', TYPE_UINT);
	
	if ($vbulletin->userinfo['userid'] > 0)
	{
		$ownitemsq=$vbulletin->db->query_read("SELECT COUNT(*) as cnt_items FROM " . TABLE_PREFIX . "xperience_shop_ta WHERE sell=0 AND ((buyer=".$vbulletin->userinfo['userid']." AND userid=0) OR (userid=".$vbulletin->userinfo['userid']."))  ORDER BY dateline");
		if ($vbulletin->db->num_rows($ownitemsq) > 0)
		{	
			$ownitems = $vbulletin->db->fetch_array($ownitemsq);	
		}
	}

	if ($do == "own" AND $vbulletin->userinfo['userid'] > 0)
	{
		$userstats = fetch_xperience($vbulletin->userinfo['userid']);
		
		$itemsaq =$vbulletin->db->query_read("SELECT
			COUNT(t.itemid) as cnt_items, t.*, s.* 
			FROM " . TABLE_PREFIX . "xperience_shop_ta as t
			INNER JOIN " . TABLE_PREFIX . "xperience_shop as s ON s.itemid=t.itemid
			WHERE
			sell=0 AND
			((t.buyer=".$vbulletin->userinfo['userid']." AND t.userid=0) OR t.userid=".$vbulletin->userinfo['userid'].")
			GROUP BY t.itemid");

		if ($vbulletin->db->num_rows($itemsaq) > 0)
		{	
			while ($itemsa = $vbulletin->db->fetch_array($itemsaq))
				{
					global $bgclass, $altbgclass;
					exec_switch_bg();
					
					require_once(DIR . '/includes/class_bbcode.php');
					$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
					$itemsa['itemdesc'] = $bbcode_parser->do_parse($itemsa['itemdesc'], true);
			
					if (strlen($itemsa['itempicture']) < 3)
					{
						$item['itempicture'] = $stylevar[imgdir_misc]."/level/icon_item.png";
					}
			
					$itemsa['available'] = true;
					$itemsa['buyable'] = false;
					if ($vbulletin->options['xperience_shop_sell_rate'] > 0)
					{
						$itemsa['sellcosts'] = number_format(($itemsa['costs'] / 100) * $vbulletin->options['xperience_shop_sell_rate'], 0);
					}
					$buyphrase = "xperience_shop_err_own";
					$itemsa['costs'] = vb_number_format($itemsa['costs']);
					$itemsa['costfield'] = $vbphrase['xperience_'.$itemsa[costfield]];
					$ga = false;
					if ($itemsa['userid'] == $vbulletin->userinfo['userid'])
					{
						$dateline_ga = vbdate($vbulletin->options['dateformat'] . ' ' .  $vbulletin->options['timeformat'], $itemsa['dateline_ga']); 
						$gauser = fetch_userinfo($itemsa['buyer']);
						$ga = true;
					}
					
					$dateline = vbdate($vbulletin->options['dateformat'] . ' ' .  $vbulletin->options['timeformat'], $itemsa['dateline']); 
					$cols = 2;
					eval('$items .= "' . fetch_template('xperience_shop_item_own') . '";');
				}
		}
		$template = 'xperience_shop';

	}
	elseif ($do == "ta" AND $vbulletin->userinfo['userid'] > 0)
	{
		global $bgclass, $altbgclass;
					
		$date_start = mktime(0, 0, 0, date("m"), date("d"), date("Y") - 2);
		$date_end = mktime(23, 59, 59, date("m"), date("d"), date("Y"));
			
		$all = array();
		$all = GetActivityShop($date_start, $date_end, $vbulletin->userinfo['userid'], "50");

		if (count($all) > 0)
		{
			arsort($all); 
			$foundactivity = 1;
			$activities['date'] = vbdate($vbulletin->options['dateformat'], $date_start);
			eval('$transactions .= "' . fetch_template('xperience_activities_dateentry') . '";');
			
			foreach ($all AS $key => $item)
			{
				$transactions .= $item[1];
			}
			$transactions .= "<br/>";
		}
				
		$template = 'xperience_shop_ta';
	}
	elseif ($do == "giveaway" AND $vbulletin->userinfo['userid'] > 0)
	{
		$taid = $vbulletin->input->clean_gpc('r', 'taid', TYPE_INT);
		$template = 'xperience_shop_ga_choose';
	}
	elseif ($do == "dogiveaway" AND $vbulletin->userinfo['userid'] > 0)
	{
		
		if (!$vbulletin->options['xperience_shop_gift'])
		{
			$vbulletin->url = $vbulletin->options['bburl']."/xperience.php?go=shop";
			eval(print_standard_redirect('xperience_shop_ga_failed', true, true));
		}
		
		$taid = $vbulletin->input->clean_gpc('r', 'taid', TYPE_INT);
		$username = $vbulletin->input->clean_gpc('p', 'choose_ga_user', TYPE_STR);
		$username = htmlspecialchars_uni($username);

		$getuseridq = $vbulletin->db->query_read("SELECT userid, username FROM " . TABLE_PREFIX . "user WHERE username='".$username."'");
		if ($db->num_rows($getuseridq) > 0)
		{
			$userinfo = $vbulletin->db->fetch_array($getuseridq);
		
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "xperience_shop_ta
				SET userid=".$userinfo['userid'].", dateline_ga=".mktime(date("H"), date("i"), 0, date("m"), date("d"), date("Y"))."
				WHERE taid=".$taid);

			WriteShopItems($userinfo);
			WriteShopItems($vbulletin->userinfo['userid']);


			if ($vbulletin->options['xperience_shop_write_pm_ga'])
			{
				
				$itemsaq = $vbulletin->db->query_read("SELECT
					c.catname, s.itemname
					FROM " . TABLE_PREFIX . "xperience_shop_ta AS t
					INNER JOIN " . TABLE_PREFIX . "xperience_shop as s ON t.itemid=s.itemid
					INNER JOIN " . TABLE_PREFIX . "xperience_shop_cat as c ON c.catid = s.catid
					WHERE t.taid=".$taid);
				
				if ($db->num_rows($itemsaq) > 0)
				{
				
					$itemsa = $vbulletin->db->fetch_array($itemsaq);
					
					$message = construct_phrase($vbphrase['xperience_shop_ga_text'], $vbulletin->options['bburl']."/member.php?u=".$vbulletin->userinfo['userid'], $vbulletin->userinfo['username'], $itemsa['itemname'], $itemsa['catname']);
					$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_SILENT);
					$pmdm->overridequota = true;
					$pmdm->set_info('is_automated', true);
					$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
					$pmdm->set('fromusername', $vbulletin->userinfo['username']);
					$pmdm->setr('title', $vbphrase['xperience_shop_ga_title']);
					$pmdm->setr('message', $message);
				 	$pmdm->set_recipients($userinfo['username'], $botpermissions, 'cc');
					$pmdm->set('dateline', TIMENOW);
					$pmdm->save(); 
				}
			}

			$vbulletin->url = $vbulletin->options['bburl']."/xperience.php?go=shop";
			eval(print_standard_redirect('xperience_shop_ga_successfully', true, true));
		}
		else
		{
			eval(print_standard_redirect('xperience_shop_ga_failed', true, true));
			
		}


	}
	elseif ($do == "sell")
	{
		
		$vbulletin->url = $vbulletin->options['bburl']."/xperience.php?go=shop";
				
		if ($vbulletin->options['xperience_shop_sell_rate'] == 0)
		{
			eval(print_standard_redirect('xperience_sell_failed', true, true));
		}
				
		$itemid = $vbulletin->input->clean_gpc('r', 'itemid', TYPE_INT);
		$userstats = fetch_xperience($vbulletin->userinfo['userid']);
		
		$itemsaq =$vbulletin->db->query_read("SELECT
			*
			FROM " . TABLE_PREFIX . "xperience_shop_ta as t
			INNER JOIN " . TABLE_PREFIX . "xperience_shop as s ON t.itemid = s.itemid
			INNER JOIN " . TABLE_PREFIX . "xperience_shop_cat as c ON c.catid = s.catid
			WHERE t.itemid=".$itemid."
			AND t.sell=0
			AND t.userid=0
			AND t.buyer=".$vbulletin->userinfo['userid']."
			ORDER BY t.dateline ASC
			LIMIT 1"
			);
		
		if ($vbulletin->db->num_rows($itemsaq) > 0)
		{
			$itemsa = $vbulletin->db->fetch_array($itemsaq);
			$sellcosts = number_format(($itemsa['costs'] / 100) * $vbulletin->options['xperience_shop_sell_rate'], 0);
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "xperience_shop_ta
				SET sell='".$sellcosts."', dateline_sell=".mktime(date("H"), date("i"), 0, date("m"), date("d"), date("Y"))."
				WHERE taid=".$itemsa['taid']);
			
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "xperience_shop
				SET quantity=quantity+1
				WHERE itemid=".$itemid);
		 		 
		 		 
			if ($vbulletin->options['xperience_shop_write_pm_sell'])
			{
				$message = construct_phrase($vbphrase['xperience_shop_sell_text'], $vbulletin->options['bburl']."/member.php?u=".$vbulletin->userinfo['userid'], $vbulletin->userinfo['username'], $itemsa['itemname'], $itemsa['catname']);
				$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_SILENT);
				$pmdm->overridequota = true;
				$pmdm->set_info('is_automated', true);
				$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
				$pmdm->set('fromusername', $vbulletin->userinfo['username']);
				$pmdm->setr('title', $vbphrase['xperience_shop_sell_title']);
				$pmdm->setr('message', $message);
			 	$pmdm->set_recipients(unhtmlspecialchars($vbulletin->options['xperience_shop_pm_rec']), $botpermissions, 'cc');
				$pmdm->set('dateline', TIMENOW);
				$pmdm->save(); 
			}
		 		 
		 	WriteShopItems($vbulletin->userinfo);
		 		 
		 	$xPerience =& new xPerience;
		 	$xPerience->CalculateXP($vbulletin->userinfo, 0);
		

			eval(print_standard_redirect('xperience_sell_successfully', true, true));
		}
		else
		{
			eval(print_standard_redirect('xperience_sell_failed', true, true));
		}

	}
	elseif ($do == "confirm_buy")
	{
		
		$itemid = $vbulletin->input->clean_gpc('r', 'item', TYPE_INT);
		$userstats = fetch_xperience($vbulletin->userinfo['userid']);
		
		$itemsaq =$vbulletin->db->query_read("SELECT
		*
		FROM " . TABLE_PREFIX . "xperience_shop as s
		INNER JOIN " . TABLE_PREFIX . "xperience_shop_cat as c ON c.catid = s.catid
		WHERE s.itemstatus>0 AND s.itemid=".$itemid);
		
		if ($vbulletin->db->num_rows($itemsaq) > 0)
		{	
			$itemsa = $vbulletin->db->fetch_array($itemsaq);
		}
	
		$vbulletin->url = $vbulletin->options['bburl']."/xperience.php?go=shop";
		if (CheckBuyConditions($itemsa, $userstats))
		{
			$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_shop_ta
				(itemid, buyer, dateline, costs, costfield) VALUES (
				".$itemsa['itemid'].",
				".$vbulletin->userinfo['userid'].",
				".mktime(date("H"), date("i"), 0, date("m"), date("d"), date("Y")).",
				".$itemsa['costs'].",
				'".$itemsa['costfield']."'		
				)");
	
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "xperience_shop
				SET quantity=quantity-1
				WHERE itemid=".$itemid);
			
			if ($vbulletin->options['xperience_shop_write_pm'])
			{
				$message = construct_phrase($vbphrase['xperience_shop_buy_text'], $vbulletin->options['bburl']."/member.php?u=".$vbulletin->userinfo['userid'], $vbulletin->userinfo['username'], $itemsa['itemname'], $itemsa['catname']);
				$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_SILENT);
				$pmdm->overridequota = true;
				$pmdm->set_info('is_automated', true);
				$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
				$pmdm->set('fromusername', $vbulletin->userinfo['username']);
				$pmdm->setr('title', $vbphrase['xperience_shop_buy_title']);
				$pmdm->setr('message', $message);
			 	$pmdm->set_recipients(unhtmlspecialchars($vbulletin->options['xperience_shop_pm_rec']), $botpermissions, 'cc');
				$pmdm->set('dateline', TIMENOW);
				$pmdm->save(); 
			}
		 		 
		 	$xPerience =& new xPerience;
		 	$xPerience->CalculateXP($vbulletin->userinfo, 0);
			
			eval(print_standard_redirect('xperience_sale_successfully', true, true));
		} else {
			eval(print_standard_redirect('xperience_sale_failed', true, true));		
		}
	
	}
	elseif ($do == "details")
	{
		$itemid = $vbulletin->input->clean_gpc('r', 'item', TYPE_INT);
		$userstats = fetch_xperience($vbulletin->userinfo['userid']);
		
		$itemsaq =$vbulletin->db->query_read("SELECT
		*
		FROM " . TABLE_PREFIX . "xperience_shop as s
		INNER JOIN " . TABLE_PREFIX . "xperience_shop_cat as c ON c.catid = s.catid
		WHERE s.itemstatus>0 AND s.itemid=".$itemid);
		
		if ($vbulletin->db->num_rows($itemsaq) > 0)
		{	
			$itemsa = $vbulletin->db->fetch_array($itemsaq);
			
			$categories = construct_xp_categories(0, $cat);
			
			require_once(DIR . '/includes/class_bbcode.php');
			$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
			$itemsa['itemdesc'] = $bbcode_parser->do_parse($itemsa['itemdesc'], true);
			
			if (strlen($itemsa['itempicture']) < 3)
			{
				$itemsa['itempicture'] = $stylevar[imgdir_misc]."/level/icon_item.png";
			}
			
			$itemsa['buyable'] = CheckBuyConditions($itemsa, $userstats);
			$buyphrase = CheckBuyConditions($itemsa, $userstats, true);
			$owncredits = vb_number_format($userstats["$itemsa[costfield]"]);
			$itemsa['costs'] = vb_number_format($itemsa['costs']);
			$itemsa['costfield'] = $vbphrase['xperience_'.$itemsa[costfield]];
			$itemsa['quantity'] = vb_number_format($itemsa['quantity']);
			$cols = 2;
			eval('$items .= "' . fetch_template('xperience_shop_item') . '";');
			
		}
		$template = 'xperience_shop';
		
		
		
	}
	else
	{
	
			
		$categories = construct_xp_categories(0, $cat);
		
		if ($cat > 0)
		{
			$userstats = fetch_xperience($vbulletin->userinfo['userid']);
			
			$itemsaq =$vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "xperience_shop WHERE itemstatus>0 AND catid=".$cat." ORDER BY itemstatus, itemname");
			if ($vbulletin->db->num_rows($itemsaq) > 0)
			{	
				while ($itemsa = $vbulletin->db->fetch_array($itemsaq))
				{

					
					$itemsa['available'] = true;
					
					
					if (strlen($itemsa['itemthumb']) < 3)
					{
						$itemsa['itemthumb'] = $stylevar[imgdir_misc]."/level/icon_item.png";
					}

					$owncredits = vb_number_format($userstats["$itemsa[costfield]"]);
					$itemsa['costs'] = vb_number_format($itemsa['costs']);
					$itemsa['costfield'] = $vbphrase['xperience_'.$itemsa[costfield]];
					$itemsa['quantity'] = vb_number_format($itemsa['quantity']);
					$cols = 3;
					global $bgclass, $altbgclass;
					exec_switch_bg();
					eval('$items .= "' . fetch_template('xperience_shop_item_c') . '";');
					$printeditem++;
					if ($printeditem > 2)
					{
						$cols = 3;
						$printeditem=0;

						$items.='</tr><tr class="'.$bgclass.'">';
					}
				}
			} else {
				$cols = 2;
			
				eval('$items .= "' . fetch_template('xperience_shop_item_no') . '";');
			}
		}

		if ($printeditem == 1)
		{
			
			exec_switch_bg();			
			$items.='<td width="33%" class="'.$bgclass.'">&nbsp;</td>';

			exec_switch_bg();			
			$items.='<td width="33%" class="'.$bgclass.'">&nbsp;</td>';
		}
		if ($printeditem == 2)
		{
			exec_switch_bg();
			$items.='<td width="33%" class="'.$bgclass.'">&nbsp;</td>';
		}

		$template = 'xperience_shop';
	}
	


}
elseif ($go == "awards") 
{
	$xperience_tabs['xperience_awards'] = 'class="selected"';
	global $bgclass, $altbgclass, $vbphrase;
	$navbits[$parent] = $vbphrase['xperience_awards'];
	
	if (!$vbulletin->options['xperience_use_awards'])
	{
		eval('standard_error($vbphrase[xperience_disabled]);');
		exit;
	}


	if ($vbulletin->options['xperience_award_bit'] == 0)
	{
		$count_awards=0;
		$foundaward=0;
		require_once(DIR . '/includes/functions_user.php');
		$awardsq =$vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "xperience_awards WHERE awardstatus>0 ORDER BY awardstatus");
		if ($vbulletin->db->num_rows($awardsq) > 0)
		{
	
			$count_awards=$vbulletin->db->num_rows($awardsq);
			$width_awards=ceil(100/$vbulletin->db->num_rows($awardsq));
			if ($count_awards>3) $count_awards=3;		
	
			while ($myawards = $vbulletin->db->fetch_array($awardsq))
			{
	
				$myrows = $vbulletin->db->query_read("SELECT
					u.userid,
					u.username,
					u.xperience_awards
					" . ($vbulletin->options['avatarenabled'] ? ",u.avatarrevision, avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline,customavatar.width AS avwidth,customavatar.height AS avheight" : "") . "
					FROM " . TABLE_PREFIX . "user AS u
					" . ($vbulletin->options['avatarenabled'] ? "LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON(avatar.avatarid = u.avatarid) LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON(customavatar.userid = u.userid)" : "") . "
					WHERE u.xperience_awards LIKE '%".$myawards['awardid']."|".addslashes($myawards['awardname'])."|".addslashes($myawards['awardtitle'])."%'");  
	
				if ($vbulletin->db->num_rows($myrows) > 0)
				{
					$foundaward=1;
					while ($myrow = $vbulletin->db->fetch_array($myrows))
					{
	
						fetch_avatar_from_userinfo($myrow, true, true);
						$avatarurl = GetAvatar($myrow);
	
						if (strlen($myawards['awardurl']) > 0)
						{
							$showaward = '<img class="inlineimg" border="0" src="'.$myawards['awardurl'].'" title="'.$myawards['awardtitle'].'" />';
						}
						else
						{
							$showaward = '<img border="0" src="'.$vbulletin->options['bburl'].'/xperience/icons/default_16.png" title="'.$myawards['awardtitle'].'" />';
						}		
						eval('$awardbit.= "' . fetch_template('xperience_awards_awardbit_legacy') . '";');
						$printedaward++;
						if ($printedaward>2)
						{
							$printedaward=0;
							$awardbit.='</tr><tr class="alt1">';
						}
					}
				}
			}
			if ($printedaward > 0 AND $printedaward < 3 )
			{
				for($i=$printedaward; $i <= 2; $i++)
				{
					eval('$awardbit .= "' . fetch_template('xperience_awards_awardbit_empty') . '";');
				}
			}
		}
	
		$template = 'xperience_awards';
	}
	else
	{
		
		$awardcatq =$vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "xperience_award_categories WHERE categoryorder>0 ORDER BY categoryorder");
		if ($vbulletin->db->num_rows($awardcatq) > 0)
		{
			while ($awardcat = $vbulletin->db->fetch_array($awardcatq))
			{
		
				eval('$awardbit.= "' . fetch_template('xperience_awards_awardbit_category') . '";');
				
				$awardsq =$vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "xperience_awards WHERE awardstatus > 0 AND awardcategory=".$awardcat['categoryid']." ORDER BY awardstatus");
				if ($vbulletin->db->num_rows($awardsq) > 0)
				{
					while ($myawards = $vbulletin->db->fetch_array($awardsq))
					{
			
						$myrows = $vbulletin->db->query_read("SELECT
							u.userid,
							u.username,
							u.xperience_awards
							FROM " . TABLE_PREFIX . "user AS u
							WHERE u.xperience_awards LIKE '%".$myawards['awardid']."|".addslashes($myawards['awardname'])."|".addslashes($myawards['awardtitle'])."%'");  
			
						if ($vbulletin->db->num_rows($myrows) > 0)
						{
							$foundaward=1;
							while ($myrow = $vbulletin->db->fetch_array($myrows))
							{
								$useidentificator = true;
								if (strlen($myawards['awardurl']) > 0)
								{
									$showaward = '<img class="inlineimg" width="16" height="16" border="0" src="'.$myawards['awardurl'].'" title="'.$myawards['awardtitle'].'" />';
									$useidentificator = false;
								}
								if (strlen($myawards['awardbigurl']) > 0)
								{
									$showaward = '<img class="inlineimg" width="32" height="32" border="0" src="'.$myawards['awardbigurl'].'" title="'.$myawards['awardtitle'].'" />';
									$useidentificator = false;
								}
								if ($useidentificator)
								{
									$showaward = '<img class="inlineimg" border="0" src="'.$vbulletin->options['bburl'].'/xperience/icons/default_32.png" title="'.$myawards['awardtitle'].'" />';
								}
								$awardissues = $vbulletin->db->query_read("SELECT
									*
									FROM " . TABLE_PREFIX . "xperience_award_issues
									WHERE dateline_out=0 AND userid=".$myrow['userid']." AND awardid=".$myawards['awardid']);  
								$awardissued = "?";
								if ($vbulletin->db->num_rows($awardissues) > 0)
								{
									$awardissue = $vbulletin->db->fetch_array($awardissues);
									$awardissued = vbdate($vbulletin->options['dateformat'], $awardissue['dateline_in'])." ".vbdate($vbulletin->options['timeformat'], $awardissue['dateline_in']);	
								}
														
								$fields_raw = explode("+", $myawards['awardfields']);
								$fields = "";
								foreach ($fields_raw AS $field)
								{
									$phrase = $vbphrase['xperience_'.$field];
									if (strlen($phrase) == 0)
									{
										$phrase = $field;
									}
									$fields .= $phrase.", "; 
								}
								if (strlen($fields) == 0)
								{
									$fields = "-, ";
								}
								$fields = substr($fields, 0, strlen($fields)-2);
																
														
								exec_switch_bg();
								eval('$awardbit.= "' . fetch_template('xperience_awards_awardbit') . '";');
								
							}
						}
					}
				}
			}
		}
		
		$date_start = mktime(0, 0, 0, date("m"), date("d") - 21, date("Y"));
		$date_end = mktime(23, 59, 59, date("m"), date("d"), date("Y"));
			
		$all = array();
		$all = GetActivityAwards($date_start, $date_end, 0, $vbulletin->options['xperience_activities_limit']);

		if (count($all) > 0)
		{
			arsort($all); 
			$foundactivity = 1;
			
			foreach ($all AS $key => $item)
			{
				
				$activities['date'] = vbdate($vbulletin->options['dateformat'], $item[0]);
				if ($currentdate <> $activities['date'])
				{
					if ($currentdate <> "")
					{
						$awardlogbits .="<br/>";
					}
					eval('$awardlogbits .= "' . fetch_template('xperience_activities_dateentry') . '";');
				}
				$currentdate = $activities['date'];
			
				$awardlogbits .= $item[1];
				
			}

			
			$awardlogbits .= "<br/>";
		}
	
		$template = 'xperience_awards';
	}

} 
elseif ($go == "achievements") 
{
	$xperience_tabs['xperience_achievements'] = 'class="selected"';
	global $bgclass, $altbgclass, $vbphrase;
	$navbits[$parent] = $vbphrase['xperience_achievements'];
	
	if (!$vbulletin->options['xperience_use_achievements'])
	{
		eval('standard_error($vbphrase[xperience_disabled]);');
		exit;
	}
	
	$data = fetch_xperience($vbulletin->userinfo['userid']);
	
	$achievementcatq =$vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "xperience_achievements_categories WHERE categoryorder>0 ORDER BY categoryorder");
	if ($vbulletin->db->num_rows($achievementcatq) > 0)
	{
		while ($achievementcat = $vbulletin->db->fetch_array($achievementcatq))
		{
	
			eval('$achievementsbits.= "' . fetch_template('xperience_achievements_bit_category') . '";');
			
			if ($vbulletin->userinfo['userid'] > 0)
			{
				$usersql = " AND i.userid=".$vbulletin->userinfo['userid'];
			}
			
			$achievementsq =$vbulletin->db->query_read("SELECT *, a.achievementid as achievementid, i.dateline as issuedate FROM " . TABLE_PREFIX . "xperience_achievements AS a
				LEFT JOIN " . TABLE_PREFIX . "xperience_achievements_issues AS i ON i.achievementid=a.achievementid ".$usersql."
				WHERE sortorder > 0 AND categoryid=".$achievementcat['categoryid']."
				GROUP BY a.achievementid
				ORDER BY sortorder");


			if ($vbulletin->db->num_rows($achievementsq) > 0)
			{
				$foundachievements = 1;
				while ($achievements = $vbulletin->db->fetch_array($achievementsq))
				{
					
					$users = vb_number_format(GetAchievementUsersCount($achievements['achievementid']));
					
					$class = "inlineimg_disabled";
					if ($achievements['issuedate'] > 0)
					{
						$class = "inlineimg";
					}
				
					$showimage = '<img class="'.$class.'" width="32" height="32" border="0" src="'.$vbulletin->options['bburl'].'/xperience/images/icon_achievements.png" title="'.$achievements['title'].'" />';
					if (strlen($achievements['imagesmall']) > 0)
					{
						$showimage = '<img class="'.$class.'" width="16" height="16" border="0" src="'.$achievements['imagesmall'].'" title="'.$achievements['title'].'" />';
					}
					if (strlen($achievements['imagebig']) > 0)
					{
						$showimage = '<img class="'.$class.'" width="32" height="32" border="0" src="'.$achievements['imagebig'].'" title="'.$achievements['title'].'" />';
					}
					
					$title = $achievements['title'];
					
					$achievementsfieldsq = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "xperience_achievements_fields WHERE achievementid=".$achievements['achievementid']." ORDER BY field");
					$fields = "";
					if ($vbulletin->db->num_rows($achievementsfieldsq) > 0)
					{
						$foundachievements = 1;

						while ($achievementsfields = $vbulletin->db->fetch_array($achievementsfieldsq))
						{
							$fieldname = $vbphrase['xperience_'.$achievementsfields['field']];
							if (strlen($fieldname) == 0)
							{
								$fieldname = $field;
							}
							$fieldvalue = vb_number_format($achievementsfields['value']);
							$compare = $vbphrase['xperience_achievements_'.$achievementsfields['compare']];
							$yours = vb_number_format($data[$achievementsfields[field]]);
							
							$state_image = "icon_state_no.png";
							switch ($achievementsfields['compare'])
							{
								case "-1":
									if ($data[$achievementsfields[field]] < $achievementsfields['value'])
									{
										$state_image = "icon_state_yes.png";
									}
									break;
								case "1":
									if ($data[$achievementsfields[field]] > $achievementsfields['value'])
									{
										$state_image = "icon_state_yes.png";
									}
									break;
									break;
								default:
									if ($data[$achievementsfields[field]] == $achievementsfields['value'])
									{
										$state_image = "icon_state_yes.png";
									}
									break;
							}
							
							eval('$fields .= "' . fetch_template('xperience_achievements_field') . '";');
						}
					}
						
					exec_switch_bg();
					eval('$achievementsbits.= "' . fetch_template('xperience_achievements_bit') . '";');
							
				}
			}
		}
	}

	
	$date_start = mktime(0, 0, 0, date("m"), date("d") - 21, date("Y"));
	$date_end = mktime(23, 59, 59, date("m"), date("d"), date("Y"));
		
	$all = array();
	$all = GetActivityAchievements($date_start, $date_end, 0, $vbulletin->options['xperience_activities_limit']);

	if (count($all) > 0)
	{
		arsort($all); 
		$foundactivity = 1;

		foreach ($all AS $key => $item)
		{
			
			$activities['date'] = vbdate($vbulletin->options['dateformat'], $item[0]);
			if ($currentdate <> $activities['date'])
			{
				if ($currentdate <> "")
				{
					$achievementslogbits .="<br/>";
				}
				eval('$achievementslogbits .= "' . fetch_template('xperience_activities_dateentry') . '";');
			}
			$currentdate = $activities['date'];
		
			$achievementslogbits .= $item[1];
			
		}
		$achievementslogbits .= "<br/>";
	}

	$template = 'xperience_achievements';

}
elseif ($go == "groups")
{
	$xperience_tabs['xperience_groups'] = 'class="selected"';
	
	if (!$vbulletin->options['xperience_use_groups'])
	{
		eval('standard_error($vbphrase[xperience_disabled]);');
		exit;
	}


	$vbulletin->input->clean_array_gpc('r', array(
		'agroupname'      => TYPE_NOHTML,
	));

	$search_username = $vbulletin->GPC['agroupname'];

	$condition = '1=1';
	if (strlen($vbulletin->GPC['agroupname']) > 0)
	{
		$condition  .=  " AND name LIKE '%" . $db->escape_string_like(htmlspecialchars_uni($vbulletin->GPC['agroupname'])) . "%' ";
	}

	$groups = $vbulletin->db->query_first("SELECT
		COUNT(*) AS groups
		FROM " . TABLE_PREFIX . "xperience_groups as x
		INNER JOIN " . TABLE_PREFIX . "socialgroup AS g ON g.groupid=x.groupid
		WHERE ".$condition); 
	$groupcount = $groups['groups'];


	sanitize_pageresults($groupcount, $pagenumber, $perpage, 100, $vbulletin->options['memberlistperpage']);

	$limitlower = ($pagenumber - 1) * $perpage + 1;
	$limitupper = $pagenumber * $perpage;
	if ($limitupper > $groupcount)
	{
		$limitupper = $groupcount;
		if ($limitlower > $groupcount)
		{
			$limitlower = $groupcount - $perpage;
		}
	}
	if ($limitlower <= 0)
	{
		$limitlower = 1;
	}

	$oppositesort = iif($sortorder == 'desc', 'asc', 'desc');

	if ($sortorder != '') 
	{
		$switchOrder = ($sortorder)?$sortorder:"";
	} else {
		$switchOrder = "";
	}

	switch ($switchOrder) 
	{
		case "asc":
			$deasc = " ASC";
			break;
		case "desc":
			$deasc = " DESC";
			break;
		default:
			$deasc = " DESC";
	}

	
	if ($sortfield != '') 
	{
		$switchSort = ($sortfield)?$sortfield:"";
	} else {
		$switchSort = "";
	}

	switch ($switchSort) 
	{
		case "xp":
		default :
			$sort_query = "x.points " . $deasc; 
			break;
		case "groupname":
			$sort_query = "g.name " . $deasc;
			break;
		case "members":
			$sort_query = "x.members " . $deasc. ", x.points DESC"; 
			break;
		case "pmin":
			$sort_query = "x.points_min " . $deasc. ", x.points DESC"; 
			break;
		case "pmax":
			$sort_query = "x.points_max " . $deasc. ", x.points DESC"; 
			break;
	}


	//construct_page_nav($pagenumber, $perpage, $results, $address, $address2 = '', $anchor = '')
	// 
	$sortstring = "sortfield=".$switchSort."&amp;sortorder=".$sortorder."&amp;agroupname=".urlencode($search_username);	
	$pagenav = construct_page_nav($pagenumber, $perpage, $userscount, 'xperience.php?do=groups' . $vbulletin->session->vars['sessionurl'], $sortstring);


global $bgclass, $altbgclass;
	$myquery="SELECT 
		x.*,
		g.name
		" . ($vbulletin->options['sg_enablesocialgroupicons'] ? ', socialgroupicon.dateline AS icondateline, socialgroupicon.width AS iconwidth, socialgroupicon.height AS iconheight, socialgroupicon.thumbnail_width AS iconthumb_width, socialgroupicon.thumbnail_height AS iconthumb_height' : '') . " 
		FROM " . TABLE_PREFIX . "xperience_groups AS x
		INNER JOIN " . TABLE_PREFIX . "socialgroup AS g ON g.groupid=x.groupid
		".($vbulletin->options['sg_enablesocialgroupicons'] ?
			"LEFT JOIN " . TABLE_PREFIX . "socialgroupicon AS socialgroupicon ON
				(socialgroupicon.groupid = g.groupid)" : '')." 
		WHERE ".$condition." 
		ORDER BY " . $sort_query . "
		LIMIT " . ($limitlower - 1) . "," . $perpage;

	$myrows = $vbulletin->db->query_read($myquery);
	
	if ($vbulletin->db->num_rows($myrows) > 0)
	{
		$groupcount = 0;
		if (function_exists(fetch_socialgroupicon_url))
		{
			require_once('./includes/functions_socialgroup.php');
		}
		
		while ($myrow = $vbulletin->db->fetch_array ($myrows)) 
		{

				$xperience['members']=vb_number_format($myrow['members']);
				$xperience['points']=vb_number_format($myrow['points']);
				$xperience['points_max']=vb_number_format($myrow['points_max']);
				$xperience['points_min']=vb_number_format($myrow['points_min']);
				
				$groupcount++;
				$xperience['groupiconurl'] = '';
				if (function_exists(fetch_socialgroupicon_url))
				{
					if ($groupcount < 4)
					{
						$xperience['groupiconurl'] = fetch_socialgroupicon_url($myrow, true);
					}
				}	
				
				exec_switch_bg(); 
				eval('$xperience_ranking_bit.= "' . fetch_template('xperience_groups_ranking_bit') . '";');
			}
		}
	
	$template = 'xperience_groups_ranking';
}
	elseif ($go == "gap")
	{
		$xperience_tabs['xperience_gap'] = 'class="selected"';
		if (!$vbulletin->options['xperience_use_gap'])
		{
				eval('standard_error($vbphrase[xperience_disabled]);');
		}
		
		
		$receiveusername = $username;

		
		$data = fetch_xperience($vbulletin->userinfo['userid']);
		
		$optionsq =$vbulletin->db->query_read("SHOW COLUMNS
			FROM " . TABLE_PREFIX . "xperience_stats LIKE 'points_%'");
					
			if ($vbulletin->db->num_rows($optionsq) > 0)
			{
				while ($options = $vbulletin->db->fetch_array($optionsq)) 
				{
					
					if (!in_array($options['Field'], $gap_notallowed))
					{
						$fielddescription = $vbphrase['xperience_'.$options[Field]]; 
						if (strlen($fielddescription) < 1)
						{
							$fielddescription = $options["Field"];
						}
	
						$fieldvalue = $options['Field'];
						$fieldamount = vb_number_format($data[$options[Field]]);
						if ($fieldamount > 0)
						{
							eval('$fields.= "' . fetch_template('xperience_gap_choose_fields') . '";');
						}
					}
				}
			}
	
		$template = 'xperience_gap_choose';
	}
	elseif ($go == "dogap")
	{
		$xperience_tabs['xperience_gap'] = 'class="selected"';
		if (!$vbulletin->options['xperience_use_gap'])
		{
			eval('standard_error($vbphrase[xperience_disabled]);');
		}
		
		$username = htmlspecialchars_uni($vbulletin->input->clean_gpc('p', 'choose_gap_user', TYPE_STR));
		$fieldamount = $vbulletin->input->clean_gpc('p', 'fieldamount', TYPE_ARRAY);
		$data = fetch_xperience($vbulletin->userinfo['userid']);


		
		$getuseridq = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "user WHERE username='".$username."'");
		if ($db->num_rows($getuseridq) > 0)
		{
			$userinfo = $vbulletin->db->fetch_array($getuseridq);


			foreach ($fieldamount AS $fieldkey => $fieldvalue)
			{
				if ($fieldvalue > 0)
				{
					if ($fieldvalue <= $data[$fieldkey])
					{
						if (!in_array($fieldkey, $gap_notallowed))
						{
							$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_gap
								(userid, toid, field, amount, dateline) VALUES (
								".$vbulletin->userinfo['userid'].",
								".$userinfo['userid'].",
								'".$fieldkey."',
								".$fieldvalue.",
								".mktime(date("H"), date("i"), 0, date("m"), date("d"), date("Y"))."
								)");
							$fieldkeyfriendly = $vbphrase['xperience_'.$fieldkey]; 
							
							$fieldamounttext .= $fieldkeyfriendly.": ".$fieldvalue.", ";
						}
					}
				}
			}

			if (strlen($fieldamounttext) < 2)
			{
				eval(print_standard_redirect('xperience_gap_failed', true, true));
			}

			
			$fieldamounttext = substr($fieldamounttext, 0, strlen($fieldamounttext) - 2);

			if ($vbulletin->options['xperience_gap_write_pm'])
			{
				$message = construct_phrase($vbphrase['xperience_gap_text'], $vbulletin->options['bburl']."/member.php?u=".$vbulletin->userinfo['userid'], $vbulletin->userinfo['username'], $fieldamounttext);
				$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_SILENT);
				$pmdm->overridequota = true;
				$pmdm->set_info('is_automated', true);
				$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
				$pmdm->set('fromusername', $vbulletin->userinfo['username']);
				$pmdm->setr('title', $vbphrase['xperience_gap_title']);
				$pmdm->setr('message', $message);
			 	$pmdm->set_recipients($userinfo['username'], $botpermissions, 'cc');
				$pmdm->set('dateline', TIMENOW);
				$pmdm->save(); 
			}

 			$xPerience =& new xPerience;
 			$xPerience->CalculateXP($userinfo, 0);
 			$xPerience->CalculateXP($vbulletin->userinfo, 0);
			$xPerience->CalculateAwards();

			$vbulletin->url = $vbulletin->options['bburl']."/xperience.php";
			eval(print_standard_redirect('xperience_gap_successfully', true, true));
		}
		else
		{
			eval(print_standard_redirect('xperience_gap_failed', true, true));
			
		}

} else {

	$xperience_tabs['xperience_ranking'] = 'class="selected"';

	$vbulletin->input->clean_array_gpc('r', array(
		'ausername'      => TYPE_NOHTML,
	));

	$search_username = $vbulletin->GPC['ausername'];

	$condition = '1=1';
	if (strlen($vbulletin->GPC['ausername']) > 0)
	{
		$condition  .=  " AND username LIKE '%" . $db->escape_string_like(htmlspecialchars_uni($vbulletin->GPC['ausername'])) . "%' ";
	}

	if (strlen($vbulletin->options['xperience_ignore_users']) > 0)
	{
		$condition .= " AND u.userid NOT IN(".$vbulletin->options['xperience_ignore_users'].") ";
	}
	
	
	$members = $vbulletin->db->query_first("SELECT
		COUNT(*) AS users
		FROM " . TABLE_PREFIX . "xperience_stats AS x
		INNER JOIN " . TABLE_PREFIX . "user AS u
		ON u.userid=x.userid 
		WHERE ".$condition); 
	$userscount = $members['users'];


	sanitize_pageresults($userscount, $pagenumber, $perpage, 100, $vbulletin->options['memberlistperpage']);

	$limitlower = ($pagenumber - 1) * $perpage + 1;
	$limitupper = $pagenumber * $perpage;
	if ($limitupper > $userscount)
	{
		$limitupper = $userscount;
		if ($limitlower > $userscount)
		{
			$limitlower = $userscount - $perpage;
		}
	}
	if ($limitlower <= 0)
	{
		$limitlower = 1;
	}

	$oppositesort = iif($sortorder == 'desc', 'asc', 'desc');

	if ($sortorder != '') 
	{
		$switchOrder = ($sortorder)?$sortorder:"";
	} else {
		$switchOrder = "";
	}

	switch ($switchOrder) 
	{
		case "asc":
			$deasc = " ASC";
			break;
		case "desc":
			$deasc = " DESC";
			break;
		default:
			$deasc = " DESC";
	}

	
	if ($sortfield != '') 
	{
		$switchSort = ($sortfield)?$sortfield:"";
	} else {
		$switchSort = "";
	}

	switch ($switchSort) 
	{
		case "xp":
		default : $sort_query = "u.xperience " . $deasc;
			break;
		case "xu":
			$sort_query = "s.points_user " . $deasc. ", u.xperience DESC"; 
			break;
		case "xt":
			$sort_query = "s.points_thread " . $deasc. ", u.xperience DESC"; 
			break;
		case "xo":
			$sort_query = "s.points_post " . $deasc. ", u.xperience DESC"; 
			break;
		case "xn":
			$sort_query = "u.username " . $deasc;
			break;
		case "xl":
			$sort_query = "u.xperience_level " . $deasc. ", u.xperience DESC"; 
			break;
		case "xm":
			$sort_query = "s.points_misc " . $deasc. ", u.xperience DESC"; 
			break;
		case "xd":
			$sort_query = "u.xperience_ppd " . $deasc. ", s.points_post_avg DESC"; 
			break;
		case "xr":
			$sort_query = "u.reputation " . $deasc. ", u.xperience ASC"; 
			break;
	}


	//construct_page_nav($pagenumber, $perpage, $results, $address, $address2 = '', $anchor = '')
	// 
	$sortstring = "sortfield=".$switchSort."&amp;sortorder=".$sortorder."&amp;ausername=".urlencode($search_username);	
	$pagenav = construct_page_nav($pagenumber, $perpage, $userscount, 'xperience.php?' . $vbulletin->session->vars['sessionurl'], $sortstring);


global $bgclass, $altbgclass;
	$myquery="SELECT 
		u.userid,
		u.usergroupid,
		u.membergroupids,
		u.username,
		u.xperience_level,
		u.xperience,
		u.xperience_ppd,
		u.xperience_awards,
		u.reputation,
		s.points_user,
		s.points_thread,
		s.points_post,
		s.points_misc
		FROM " . TABLE_PREFIX . "xperience_stats AS s
		INNER JOIN " . TABLE_PREFIX . "user AS u ON u.userid=s.userid
		WHERE ".$condition." 
		ORDER BY " . $sort_query . "
		LIMIT " . ($limitlower - 1) . "," . $perpage;

	$myrows = $vbulletin->db->query_read($myquery);

	if ($vbulletin->db->num_rows($myrows) > 0)
	{
		while ($myrow = $vbulletin->db->fetch_array ($myrows)) 
		{
		
			$DisplayUser=1;
			if (strlen($vbulletin->options['xperience_ignore_usergroupsids']) > 0) 
			{
				$usergroups=explode(",", $vbulletin->options['xperience_ignore_usergroupsids']);
				for ($i = 0; $i < count($usergroups); $i ++) 
				{
					if (is_member_of($myrow, $usergroups[$i])) 
					{
						$DisplayUser = 0;
					}
				}
			}
		
		
			if ($DisplayUser == 1) 
			{
				$xperience['xperience'] = vb_number_format($myrow['xperience']);
				$xperience['points_user'] = vb_number_format($myrow['points_user']);
				$xperience['points_thread'] = vb_number_format($myrow['points_thread']);
				$xperience['points_post'] = vb_number_format($myrow['points_post']);
				$xperience['points_misc'] = vb_number_format($myrow['points_misc']);
				$xperience['xperience_ppd'] = vb_number_format($myrow['xperience_ppd'], 1);
				
				$awards = GetAwards($myrow['xperience_awards']);
				
							
				
				exec_switch_bg(); 
				eval('$xperience_ranking_bit.= "' . fetch_template('xperience_ranking_bit') . '";');
			}
		}
	}
	$template = 'xperience_ranking';
	
}


	$csstemplatesq = $db->query_read("SELECT
		title, template
		FROM " . TABLE_PREFIX . "template
		WHERE templateid=".$templateassoc['.thead']." OR templateid=".$templateassoc['.tcat']."
		ORDER BY styleid ASC
	");
	
	while ($csstemplate = $vbulletin->db->fetch_array($csstemplatesq))
	{
		$stylecsscolors = unserialize($csstemplate['template']);
		if ($csstemplate['title']==".thead")
		{

			$xperience_css['background'] = $stylecsscolors['background'];
			$xperience_css['front'] = $stylecsscolors['color'];

		}
		elseif ($csstemplate['title']==".tcat")
		{
			$xperience_css['hov_background'] = $stylecsscolors['background'];
			$xperience_css['hov_front'] = $stylecsscolors['color'];
			
			$xperience_css['sel_background'] = $stylecsscolors['background'];
			$xperience_css['sel_front'] = $stylecsscolors['color'];
		}
	}

	eval('$xperience_bar_css = "' . fetch_template('xperience_navbar_css') . '";');
	eval('$xperience_bar = "' . fetch_template('xperience_navbar') . '";');

	$navbits[$parent] = $vbphrase['xperience_vbnav']." ".$navbits[$parent];
	$navbits = construct_navbits($navbits); 
	eval('$navbar = "' . fetch_template('navbar') . '";');
	eval ('print_output("' . fetch_template($template) . '");');



	
?>
