<?php

class DBTech_xFShout_Install_Install
{
	/**
	 * Instance manager.
	 *
	 * @var Dark_TaigaChat_Install
	 */
	private static $_instance;

	/**
	 * Database object
	 *
	 * @var Zend_Db_Adapter_Abstract
	 */
	protected $_db;

	/**
	 * Gets the installer instance.
	 *
	 * @return Dark_TaigaChat_Install
	 */
	public static final function getInstance()
	{
		if (!self::$_instance)
		{
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * Helper method to get the database object.
	 *
	 * @return Zend_Db_Adapter_Abstract
	 */
	protected function _getDb()
	{
		if ($this->_db === null)
		{
			$this->_db = XenForo_Application::get('db');
		}

		return $this->_db;
	}

	/**
	 * Begins the installation process and picks the proper install routine.
	 *
	 * See see XenForo_Model_Addon::installAddOnXml() for more details about
	 * the arguments passed to this method.
	 *
	 * @param array Information about the existing version (if upgrading)
	 * @param array Information about the current version being installed
	 *
	 * @return void
	 */
	public static function install($existingAddOn, $addOnData)
	{
		// the version IDs from which we should start/end the install process
		$startVersionId = 100;
		$endVersionId = $addOnData['version_id'];

		if ($existingAddOn)
		{
			// we are upgrading, run every install method since last upgrade
			$startVersionId = $existingAddOn['version_id'] + 1;
		}

		// create our install object
		$install = self::getInstance();

		for ($i = $startVersionId; $i <= $endVersionId; $i++)
		{
			$method = '_installVersion' . $i;
			if (method_exists($install, $method) === false)
			{
				continue;
			}

			$install->$method();
		}

	}
	

	/**
	 * Begins the installation process and picks the proper install routine.
	 *
	 * See see XenForo_Model_Addon::installAddOnXml() for more details about
	 * the arguments passed to this method.
	 *
	 * @param array Information about the existing version (if upgrading)
	 * @param array Information about the current version being installed
	 *
	 * @return void
	 */
	public static function uninstall($addOnData)
	{
		// create our uninstall object
		$uninstall = self::getInstance();
		$uninstall->_uninstall();
	}	

	/**
	 * Install routine for version ID 100
	 *
	 * @return void
	 */
	protected function _installVersion100()
	{
		$this->_getDb()->query("
			CREATE TABLE IF NOT EXISTS `xf_dbtech_xfshout_instance`
			(
				`instance_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
			 	`title` varchar(50) NOT NULL,
				`description` text NOT NULL,
				`sticky` text NOT NULL,
				`sticky_parsed` text NOT NULL,
				`bbcode` MEDIUMTEXT NULL DEFAULT NULL,
				`options` MEDIUMTEXT NULL DEFAULT NULL,
				PRIMARY KEY (`instance_id`)
			) ENGINE=MyISAM
		");
		$this->_getDb()->query("
			REPLACE INTO `xf_dbtech_xfshout_instance` 
				(`instance_id`, `title`, `description`, `sticky`, `sticky_parsed`, `options`, `bbcode`) 
			VALUES (
				1,
				'xFShout',
				'This is the default instance!',
				'Welcome to xFShout! Type [i]/sticky New sticky note[/i] to set the new sticky note.',
				'Welcome to xFShout! Type <i>/sticky New sticky note</i> to set the new sticky note.',
				0x613a343a7b733a31313a227265667265736874696d65223b733a313a2235223b733a363a22686569676874223b733a333a22313530223b733a393a226e756d73686f757473223b733a323a223230223b733a393a226d61786c656e677468223b733a333a22323536223b7d,
				0x613a32323a7b733a313a2262223b733a313a2231223b733a313a2269223b733a313a2231223b733a313a2275223b733a313a2231223b733a313a2273223b733a313a2231223b733a353a22636f6c6f72223b733a313a2231223b733a343a22666f6e74223b733a313a2231223b733a343a2273697a65223b733a313a2230223b733a343a226c656674223b733a313a2230223b733a363a2263656e746572223b733a313a2230223b733a353a227269676874223b733a313a2230223b733a363a22696e64656e74223b733a313a2230223b733a333a2275726c223b733a313a2231223b733a353a22656d61696c223b733a313a2231223b733a333a22696d67223b733a313a2230223b733a353a2271756f7465223b733a313a2230223b733a343a22636f6465223b733a313a2230223b733a333a22706870223b733a313a2230223b733a343a2268746d6c223b733a313a2230223b733a343a226c697374223b733a313a2230223b733a353a22706c61696e223b733a313a2231223b733a353a226d65646961223b733a313a2230223b733a363a22617474616368223b733a313a2230223b7d
			)
		");
		
		$this->_getDb()->query("
			CREATE TABLE IF NOT EXISTS `xf_dbtech_xfshout_log`
			(
				`logid` int(10) unsigned NOT NULL AUTO_INCREMENT,
				`userid` int(10) unsigned NOT NULL DEFAULT '0',
				`username` varchar(100) NOT NULL,
				`dateline` int(10) unsigned NOT NULL DEFAULT '0',
				`ipaddress` char(15) NOT NULL,
				`command` varchar(50) NOT NULL,
				`comment` mediumtext,
				PRIMARY KEY (`logid`)
			) ENGINE=MyISAM
		");
		
		$this->_getDb()->query("
			CREATE TABLE IF NOT EXISTS `xf_dbtech_xfshout_permission` (
				`permission_id` varchar(25) NOT NULL,
				`display_order` int(10) unsigned NOT NULL,
				`default_value` tinyint(1) unsigned NOT NULL,
				PRIMARY KEY (`permission_id`),
				KEY `display_order` (`display_order`)
			) ENGINE=MyISAM
		");
		$this->_getDb()->query("
			REPLACE INTO `xf_dbtech_xfshout_permission` 
				(`permission_id`, `display_order`, `default_value`) 
			VALUES
				('canview', 10, 1),
				('canshout', 20, 1),
				('canviewarchive', 11, 1),
				('caneditown', 30, 1),
				('caneditothers', 40, 0),
				('canprune', 50, 0),
				('canban', 60, 0),
				('cansetsticky', '70', '0')
		");
		
		$this->_getDb()->query("
			CREATE TABLE IF NOT EXISTS `xf_dbtech_xfshout_permission_entry` (
				`user_group_id` int(10) NOT NULL,
				`permission_id` varchar(25) NOT NULL,
				`instance_id` int(10) unsigned NOT NULL DEFAULT '0',
				`permission_value` tinyint(1) NOT NULL,
				PRIMARY KEY (`user_group_id`,`permission_id`,`instance_id`)
			) ENGINE=MyISAM
		");
		$this->_getDb()->query("
			REPLACE INTO `xf_dbtech_xfshout_permission_entry`
				(`user_group_id`, `permission_id`, `instance_id`, `permission_value`)
			VALUES
				(1, 'canview', 1, 1),
				(1, 'canviewarchive', 1, 1),
				(1, 'canshout', 1, 0),
				(1, 'caneditown', 1, 0),
				(1, 'caneditothers', 1, 0),
				(1, 'cansetsticky', 1, 0),
				(1, 'canban', 1, 0),
				(1, 'canprune', 1, 0),
				(2, 'canview', 1, 1),
				(2, 'canviewarchive', 1, 1),
				(2, 'canshout', 1, 1),
				(2, 'caneditown', 1, 1),
				(2, 'caneditothers', 1, 0),
				(2, 'cansetsticky', 1, 0),
				(2, 'canban', 1, 0),
				(2, 'canprune', 1, 0),
				(3, 'canview', 1, 1),
				(3, 'canviewarchive', 1, 1),
				(3, 'canshout', 1, 1),
				(3, 'caneditown', 1, 1),
				(3, 'caneditothers', 1, 1),
				(3, 'cansetsticky', 1, 1),
				(3, 'canban', 1, 1),
				(3, 'canprune', 1, 1),
				(4, 'canview', 1, 1),
				(4, 'canviewarchive', 1, 1),
				(4, 'canshout', 1, 1),
				(4, 'caneditown', 1, 1),
				(4, 'caneditothers', 1, 1),
				(4, 'cansetsticky', 1, 1),
				(4, 'canban', 1, 1),
				(4, 'canprune', 1, 0)
		");
		
		$this->_getDb()->query("
			CREATE TABLE IF NOT EXISTS `xf_dbtech_xfshout_shout`
			(
				`shoutid` int(10) unsigned NOT NULL AUTO_INCREMENT,
				`userid` int(10) NOT NULL DEFAULT '0',
				`dateline` int(10) unsigned NOT NULL DEFAULT '0',
				`message` mediumtext,
				`message_parsed` mediumtext,
				`type` tinyint(1) unsigned NOT NULL DEFAULT '1',
				`pmuserid` int(10) unsigned NOT NULL DEFAULT '0',
				`notification` enum('','thread','reply') NOT NULL DEFAULT '',
				`forumid` int(10) NOT NULL DEFAULT '0',
				`instanceid` int(10) NOT NULL DEFAULT '0',
				`chatroomid` int(10) unsigned NOT NULL DEFAULT '0',
				PRIMARY KEY (`shoutid`),
				KEY `type` (`type`,`pmuserid`),
				KEY `userid` (`userid`),
				KEY `dateline` (`dateline`)
			) ENGINE=MyISAM
		");
		$this->_getDb()->query("
			REPLACE INTO `xf_dbtech_xfshout_shout` 
				(`shoutid`, `userid`, `dateline`, `message`, `message_parsed`, `type`, `pmuserid`, `notification`, `forumid`, `instanceid`, `chatroomid`)
			VALUES (
				1,
				-1,
				UNIX_TIMESTAMP(),
				'Thank you for installing [DragonByte] xFShout! Type /prune to get rid of this message, or double-click to delete it.',
				'Thank you for installing [DragonByte] xFShout! Type /prune to get rid of this message, or double-click to delete it.',
				32,
				0,
				'',
				0,
				1,
				0
			)
		");
		
		$this->_getDb()->query("
			REPLACE INTO `xf_data_registry`
				(`data_key`, `data_value`)
			VALUES
				('dbtech_xfshout_instance', 0x613a313a7b693a313b613a373a7b733a31313a22696e7374616e63655f6964223b693a313b733a353a227469746c65223b733a373a22784653686f7574223b733a31313a226465736372697074696f6e223b733a32393a2254686973206973207468652064656661756c7420696e7374616e636521223b733a363a22737469636b79223b733a32333a225b425d746573745b2f425d206e657720737469636b792e223b733a31333a22737469636b795f706172736564223b733a32333a223c623e746573743c2f623e206e657720737469636b792e223b733a373a226f7074696f6e73223b733a3130373a22613a343a7b733a31313a227265667265736874696d65223b733a313a2235223b733a363a22686569676874223b733a333a22313530223b733a393a226e756d73686f757473223b733a323a223230223b733a393a226d61786c656e677468223b733a333a22323536223b7d223b733a363a226262636f6465223b733a3432323a22613a32323a7b733a313a2262223b733a313a2231223b733a313a2269223b733a313a2231223b733a313a2275223b733a313a2231223b733a313a2273223b733a313a2231223b733a353a22636f6c6f72223b733a313a2231223b733a343a22666f6e74223b733a313a2231223b733a343a2273697a65223b733a313a2230223b733a343a226c656674223b733a313a2230223b733a363a2263656e746572223b733a313a2230223b733a353a227269676874223b733a313a2230223b733a363a22696e64656e74223b733a313a2230223b733a333a2275726c223b733a313a2231223b733a353a22656d61696c223b733a313a2231223b733a333a22696d67223b733a313a2230223b733a353a2271756f7465223b733a313a2230223b733a343a22636f6465223b733a313a2230223b733a333a22706870223b733a313a2230223b733a343a2268746d6c223b733a313a2230223b733a343a226c697374223b733a313a2230223b733a353a22706c61696e223b733a313a2231223b733a353a226d65646961223b733a313a2230223b733a363a22617474616368223b733a313a2230223b7d223b7d7d),
				('dbtech_xfshout_instperms', 0x613a313a7b693a313b613a343a7b693a313b613a383a7b733a373a2263616e76696577223b733a313a2231223b733a31343a2263616e7669657761726368697665223b733a313a2231223b733a383a2263616e73686f7574223b733a313a2230223b733a31303a2263616e656469746f776e223b733a313a2230223b733a31333a2263616e656469746f7468657273223b733a313a2230223b733a383a2263616e7072756e65223b733a313a2230223b733a363a2263616e62616e223b733a313a2230223b733a31323a2263616e736574737469636b79223b733a313a2230223b7d693a343b613a383a7b733a373a2263616e76696577223b733a313a2231223b733a31343a2263616e7669657761726368697665223b733a313a2231223b733a383a2263616e73686f7574223b733a313a2231223b733a31303a2263616e656469746f776e223b733a313a2231223b733a31333a2263616e656469746f7468657273223b733a313a2231223b733a383a2263616e7072756e65223b733a313a2230223b733a363a2263616e62616e223b733a313a2231223b733a31323a2263616e736574737469636b79223b733a313a2231223b7d693a333b613a383a7b733a373a2263616e76696577223b733a313a2231223b733a31343a2263616e7669657761726368697665223b733a313a2231223b733a383a2263616e73686f7574223b733a313a2231223b733a31303a2263616e656469746f776e223b733a313a2231223b733a31333a2263616e656469746f7468657273223b733a313a2231223b733a383a2263616e7072756e65223b733a313a2231223b733a363a2263616e62616e223b733a313a2231223b733a31323a2263616e736574737469636b79223b733a313a2231223b7d693a323b613a383a7b733a373a2263616e76696577223b733a313a2231223b733a31343a2263616e7669657761726368697665223b733a313a2231223b733a383a2263616e73686f7574223b733a313a2231223b733a31303a2263616e656469746f776e223b733a313a2231223b733a31333a2263616e656469746f7468657273223b733a313a2230223b733a383a2263616e7072756e65223b733a313a2230223b733a363a2263616e62616e223b733a313a2230223b733a31323a2263616e736574737469636b79223b733a313a2230223b7d7d7d)
		");
		
		
		$usercols = $this->_getTableColumns('user');
		if (!isset($usercols['dbtech_xfshout_shouts']))
		{
			$this->_getDb()->query("ALTER TABLE `xf_user` ADD `dbtech_xfshout_shouts` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0'");
		}
		if (!isset($usercols['dbtech_xfshout_banned']))
		{
			$this->_getDb()->query("ALTER TABLE `xf_user` ADD `dbtech_xfshout_banned` ENUM( '0', '1' ) NOT NULL DEFAULT '0'");
		}
	}
	
	
	/**
	 * Uninstall routine for all versions
	 *
	 * @return void
	 */
	protected function _uninstall()
	{
		foreach (array(
			'instance',
			'log',
			'shout',
			'permission',
			'permission_entry',
		) as $table)
		{
			// Quickly drop all tables
			$this->_getDb()->query("DROP TABLE xf_dbtech_xfshout_{$table}");
		}
		
		$this->_getDb()->query("
			ALTER TABLE `xf_user`
			DROP `dbtech_xfshout_shouts`,
			DROP `dbtech_xfshout_banned`
		");	
			
		$this->_getDb()->query("
			DELETE FROM `xf_data_registry`
			WHERE data_key LIKE 'dbtech_xfshout_%'
		");			
	}
	
	/**
	 * Grabs all columns from a table
	 *
	 * @return array Table columns
	 */
	protected function _getTableColumns($table)
	{
		$col = $this->_getDb()->fetchRow($this->_getDb()->limit("SELECT * FROM xf_{$table}", 1));
	}
}
