<?php
class DBTech_xFShout_EventListener_FrontControllerPostView
{
    public static function listen(
    	XenForo_FrontController $fc,
    	&$output
    )
    {
    	$options = XenForo_Application::get('options');
    	
    	if (!$options->dbtech_xfshout_enable)
    	{
    		// SB isn't even on!
    		return false;
    	}
    	
    	$visitor = XenForo_Visitor::getInstance()->toArray();    	
    	if ($visitor['dbtech_xfshout_banned'])
    	{
    		// Bunned.
    		return false;
    	} 	
    	
    	$headers = $fc->getResponse()->getHeaders();
		$isText = false;
		foreach ($headers AS $header)
		{
			if ($header['name'] == 'Content-Type')
			{
				if (strpos($header['value'], 'text/') === 0)
				{
					$isText = true;
				}
				break;
			}
		}
			    	
    	if (!$isText)
    	{
    		// We only want to do this when it's text we're dealing with
    		return false;
    	}
    		
    	// This is text output
    	if (strpos($output, '<!--XFSHOUT.') !== false)
    	{
    		// Create some needed arrays
    		$cache = XenForo_Model::create('XenForo_Model_DataRegistry');
    		$instances 		= $cache->get('dbtech_xfshout_instance');
    		$permissions 	= $cache->get('dbtech_xfshout_instperms');

			// Create Shout model
			$shout = XenForo_Model::create('DBTech_xFShout_Model_Shout');
			
			// Get effective permissions
			$shout->getEffectivePermissions($visitor, $permissions);		
			
    		foreach ($instances as $instanceid => $instance)
    		{
    			// Shorthand
    			$effectivePermissions = $visitor['permissions']['dbtech_xfshout'][$instanceid];
    			
    			if (!$effectivePermissions['canview'])
    			{
    				// We can't view this SB
    				continue;
    			}
    			
				$instance['options'] = @unserialize($instance['options']);
				
	    		// We have the XFSHOUT tag
	    		$output = str_replace('<!--XFSHOUT.' . $instanceid . '-->', 
		   			$fc->getDependencies()->createTemplateObject('dbtech_xfshout_box_wrapper', array(
		   				'instance' => $instance,
		   				'visitor' => $visitor,
		   				'permissions' => $effectivePermissions
		   			))->render(),
		   			$output
		   		);    				
    		}
    	}
    }
    
	/**
	 * Grabs effective permissions for the selected user
	 *
	 * @return array Effective permissions for this visitor
	 */    
    protected static function getEffectivePermissions($visitor, $permissions)
    {
    }
}