<?php
class DBTech_xFShout_DataWriter_Shout extends XenForo_DataWriter
{
	const TABLE_NAME = 'xf_dbtech_xfshout_shout';
	const TABLE_ID = 'shoutid';
	
	/**
	* Database object
	*
	* @var Zend_Db_Adapter_Abstract
	*/
	protected $_db = null;	
	
	/**
	* Gets the fields that are defined for the table. See parent for explanation.
	*
	* @return array
	*/
	protected function _getFields()
	{
		return array(
			self::TABLE_NAME => array(
				self::TABLE_ID	=> array(
					'type'			=> self::TYPE_UINT,
					'default'		=> array(
						self::TABLE_NAME,
						self::TABLE_ID
					),
					'autoIncrement' => true
				),
				'userid'		=> array(
					'type'			=> self::TYPE_UINT,
					'default'		=> 0,
					'verification' 	=> array('XenForo_DataWriter_Helper_User', 'verifyUserid')
				),
				'dateline'		=> array(
					'type'		=> self::TYPE_UINT,
					'default'	=> XenForo_Application::$time
				),
				'message'		=> array(
					'type' 		=> self::TYPE_STRING,
					'required'	=> true
				),
				'message_parsed'	=> array(
					'type'		=> self::TYPE_STRING,
					'required'	=> true
				),
				'type'			=> array(
					'type'		=> self::TYPE_UINT,
					'default'	=> 1
				),
				'pmuserid'		=> array(
					'type'			=> self::TYPE_UINT,
					'default'		=> 0,
					'verification' 	=> array('XenForo_DataWriter_Helper_User', 'verifyUserid')
				),
				'notification'		=> array(
					'type'			=> self::TYPE_STRING,
					'default'		=> '',
				),
				'forumid'		=> array(
					'type'			=> self::TYPE_UINT,
					'default'		=> 0,
				),
				'instanceid'	=> array(
					'type'			=> self::TYPE_UINT,
					'default'		=> 0,
				),
				'chatroomid'	=> array(
					'type'			=> self::TYPE_UINT,
					'default'		=> 0,
				),
			)
		);
	}

	/**
	* Checks for various chat commands that may interrupt saving
	*
	* @return	boolean
	*/
	protected function _parseActionCodes()
	{
		$shouttypes = $this->_getShoutModel()->getShoutTypes();
		
		if ($this->get('type') != $shouttypes['shout'])
		{
			// We're not doing anything with a non-shout type
			// Notifications / PMs are already parsed and ready
			return true;
		}
		
		// Shorthand
		$permissions = $this->getOption('effectivePermissions');
		
		// The PM command is special and can't be prettified.
		// It's also the only 3-stage command we have, so it doesn't matter
		/*if (preg_match("#^(\/pm)\s+?(.+?);\s+?(.+?)$#i", $this->get('message'), $matches))
		{
			if ($matches[2] == $this->registry->userinfo['username'])
			{
				// We has an error
				$this->error(new XenForo_Phrase('dbtech_xfshout_cannot_pm_self'));
				return false;
			}
			
			if (!$exists = $this->registry->db->query_first_slave("
				SELECT userid, dbtech_xfshout_settings
				FROM user
				WHERE username = " . $this->registry->db->sql_prepare($matches[2])
			))
			{
				// We has an error
				$this->error(new XenForo_Phrase('dbtech_xfshout_invalid_user'));
				return false;
			}
			
			$return_value = true;
			($hook = vBulletinHook::fetch_hook('dbtech_xfshout_parsecommand_pm')) ? eval($hook) : false;
	
			if (!$return_value)
			{
				// We're ending it early
				return $return_value;
			}
			
			// Override some values
			$this->_setInternal(self::TABLE_NAME, 	'id', 		$exists['userid']);
			$this->_setInternal(self::TABLE_NAME, 	'type', 		$shouttypes['pm']);
			$this->_setInternal(self::TABLE_NAME, 	'message', 		$matches[3]);
			$this->_setInternal(self::TABLE_NAME, 	'chatroomid', 	0);
		}
		else */if (preg_match("#^(\/[a-z]*?)$#i", $this->get('message'), $matches))
		{
			// 1-stage command
			switch ($matches[1])
			{
				case '/prune':
					
					if (!$this->get('chatroomid'))
					{
						if (!$permissions['canprune'])
						{
							// We has an error
							$this->error(new XenForo_Phrase('dbtech_xfshout_cannot_prune'));
							return false;
						}
					}
					else
					{
						/*
						if ($this->vbshout->cache['chatroom'][$this->get('chatroomid')]['creator'] != $this->registry->userinfo['userid'] AND !$this->vbshout->permissions['canprune'])
						{
							// Only chat room creators can prune
							$this->error(new XenForo_Phrase('dbtech_xfshout_cannot_prune'));
							return false;
						}
						*/
					}
					
					// Now get rid of the shouts
					$this->_getDb()->delete(self::TABLE_NAME, 
						"`instanceid` = " . intval($this->get('instanceid')) . "
							AND `chatroomid` = " . intval($this->get('chatroomid'))
					);
					
					// Rebuild shout counts
					$this->_getShoutModel()->buildShoutCounter();
					
					// Log the prune command
					$this->_getShoutModel()->logCommand('prune');
					
					// Create the new phrase object
					$newmsg = new XenForo_Phrase('dbtech_xfshout_shoutbox_pruned');
					
					// Blank out the message and change type
					$this->_setInternal(self::TABLE_NAME, 	'type', 			$shouttypes['system']);
					$this->_setInternal(self::TABLE_NAME, 	'message', 			$newmsg->render());
					$this->_setInternal(self::TABLE_NAME, 	'message_parsed', 	$newmsg->render());
					$this->_setInternal(self::TABLE_NAME, 	'userid', 			-1);
					break;
				
				/*
				case '/editsticky':
					if (!$permissions['cansetsticky'])
					{
						$this->error(new XenForo_Phrase('dbtech_xfshout_cannot_sticky'));
						return false;
					}
					
					// What we need to put in the editor
					$this->vbshout->fetched['editor'] = '/sticky ' . $this->vbshout->instance['sticky_raw'];
					
					// We're not continuing
					return false;
					break;
				*/
				/*
				case '/createchat':
					$this->error(new XenForo_Phrase('dbtech_xfshout_invalid_chatroom_name'));
					return false;
					break;
				
				*/
				case '/removenotice':
				case '/removesticky':
				case '/sticky':
					if (!$permissions['cansetsticky'])
					{
						$this->error(new XenForo_Phrase('dbtech_xfshout_cannot_sticky'));
						return false;
					}
					
					// Remove the sticky note
					$dw = XenForo_DataWriter::create('DBTech_xFShout_DataWriter_Instance');
						$dw->setExistingData($this->get('instanceid'));
						$dw->set('sticky', '');
					$dw->save();

					// Log the prune command
					$this->_getShoutModel()->logCommand('removesticky');
					
					// Create the new phrase object
					$newmsg = new XenForo_Phrase('dbtech_xfshout_sticky_note_removed');					
						
					// Blank out the message
					$this->_setInternal(self::TABLE_NAME, 	'type', 			$shouttypes['system']);
					$this->_setInternal(self::TABLE_NAME, 	'message', 			$newmsg->render());
					$this->_setInternal(self::TABLE_NAME, 	'message_parsed', 	$newmsg->render());					
					$this->_setInternal(self::TABLE_NAME, 	'userid', 			-1);
					break;
				
				default:
					$return_value = false;
					$handled = false;
					
					//($hook = vBulletinHook::fetch_hook('dbtech_xfshout_command_1')) ? eval($hook) : false;
					
					if (!$handled)
					{
						// We didn't have any errors, we just returned false
						$this->error(new XenForo_Phrase('dbtech_xfshout_invalid_command'));
						return false;
					}
					return $return_value;
					break;
			}
		}
		else if (preg_match("#^(\/[a-z]*?)\s(.+?)$#i", $this->get('message'), $matches))
		{
			// 2-stage command
			switch ($matches[1])
			{
				case '/me':
					// ZE ME COMMAND, IT DOEZ NOZING
					break;

				/*
				case '/invite':
				case '/chatinvite':
					// Invite an user to chat
					$chatroomid = $this->get('chatroomid');
					
					if (!$title = $this->vbshout->cache['chatroom'][$chatroomid]['title'] OR $this->vbshout->cache['chatroom'][$chatroomid]['membergroupids'])
					{
						$this->error(new XenForo_Phrase('dbtech_xfshout_invalid_chat_room'));
						return false;
					}
					
					if (!$userid = $this->registry->db->query_first_slave("SELECT userid FROM user WHERE username = " . $this->registry->db->sql_prepare($matches[2])))
					{
						$this->error(new XenForo_Phrase('dbtech_xfshout_invalid_user'));
						return false;
					}
					
					// Invite to join the chat room
					$this->vbshout->invite_chatroom($this->vbshout->cache['chatroom']["$chatroomid"], $userid['userid'], $this->registry->userinfo['userid']);

					//$this->fetched['success'] = $vbphrase['dbtech_xfshout_chat_invited_successfully'];
					
					return false;
					break;
					
				case '/ignore':
				case '/unignore':				
					// Ignore an user
					if (!$exists = $this->registry->db->query_first_slave("
						SELECT userid, username, usergroupid, membergroupids
						FROM user
						WHERE username = " . $this->registry->db->sql_prepare($matches[2])
					))
					{
						// We has an error
						$this->error(new XenForo_Phrase('dbtech_xfshout_invalid_user'));
						return false;
					}
					
					if ($exists['userid'] == $this->registry->userinfo['userid'])
					{
						// Ourselves, duh
						$this->error(new XenForo_Phrase('dbtech_xfshout_cannot_ignore_self'));
						return false;
					}
					
					if ($this->vbshout->check_protected_usergroup($exists, true))
					{
						// We had an error
						$this->error(new XenForo_Phrase('dbtech_xfshout_protected_usergroup'));
						return false;
					}
					
					if ($matches[1] == '/ignore')
					{
						// Ignore the user
						$this->_getDb()->query("
							REPLACE INTO dbtech_xfshout_ignorelist
								(userid, ignoreuserid)
							VALUES (
								" . intval($this->registry->userinfo['userid']) . ",
								" . intval($exists['userid']) . "
							)
						");
					}
					else
					{
						// Unignore the user
						$this->_getDb()->delete('xf_dbtech_xfshout_ignorelist', 
							"`instanceid` = " . intval($this->get('instanceid')) . "
								AND `chatroomid` = " . intval($this->get('chatroomid'))
						);
						$this->_getDb()->query("
							DELETE FROM 
							WHERE userid = " . intval($this->registry->userinfo['userid']) . "
								AND ignoreuserid = " . intval($exists['userid']) . "
						");
					}
					
					// Print success message
					//$this->fetched['success'] = construct_phrase($vbphrase['dbtech_xfshout_ignored_successfully'], $matches[2]);
					//$this->fetched['success'] = construct_phrase($vbphrase['dbtech_xfshout_unignored_successfully'], $matches[2]);					
					//$message = false;
					return false;
					break;
				*/
				case '/notice':
				case '/setnotice':
				case '/sticky':
				case '/setsticky':
					if (!$permissions['cansetsticky'])
					{
						$this->error(new XenForo_Phrase('dbtech_xfshout_cannot_sticky'));
						return false;
					}
					
					// Remove the sticky note
					$dw = XenForo_DataWriter::create('DBTech_xFShout_DataWriter_Instance');
						$dw->setExistingData($this->get('instanceid'));
						$dw->set('sticky', $matches[2]);
					$dw->save();

					// Log the prune command
					$this->_getShoutModel()->logCommand('setsticky', $matches[2]);
					
					// Create the new phrase object
					$newmsg = new XenForo_Phrase('dbtech_xfshout_sticky_note_set');					
						
					// Blank out the message
					$this->_setInternal(self::TABLE_NAME, 	'type', 			$shouttypes['system']);
					$this->_setInternal(self::TABLE_NAME, 	'message', 			$newmsg->render());
					$this->_setInternal(self::TABLE_NAME, 	'message_parsed', 	$newmsg->render());					
					$this->_setInternal(self::TABLE_NAME, 	'userid', 			-1);
					break;					
				
				case '/ban':
				case '/unban':				
					if (!$permissions['canban'])
					{
						$this->error(new XenForo_Phrase('dbtech_xfshout_cannot_ban'));
						return false;
					}
						
					// Banning an user
					if (!$exists = $this->_getDb()->fetchRow($this->_getDb()->limit("SELECT * FROM xf_user WHERE username = ?", 1), $matches[2]))
					{
						// We has an error
						$this->error(new XenForo_Phrase('invalid_username'));
						return false;
					}
					
					if ($exists['user_id'] == XenForo_Visitor::getUserId())
					{
						// Ourselves, duh
						$this->error(new XenForo_Phrase('dbtech_xfshout_cannot_ban_self'));
						return false;
					}
					
					
					//if ($this->vbshout->check_protected_usergroup($exists, true))
					if ($exists['is_moderator'] OR $exists['is_admin'])
					{
						// We had an error
						$this->error(new XenForo_Phrase('dbtech_xfshout_protected_usergroup'));
						return false;
					}
					
					// Log the ban command
					$this->_getShoutModel()->logCommand(($matches[1] == '/ban' ? 'ban' : 'unban'), $exists['user_id']);
					
					// Ban the user
					$this->_getDb()->update('xf_user', array('dbtech_xfshout_banned' => ($matches[1] == '/ban' ? '1' : '0')), 'user_id = ' . $this->_getDb()->quote($exists['user_id']));
					
					// Create the new phrase object
					$newmsg = new XenForo_Phrase('dbtech_xfshout_user_' . ($matches[1] == '/ban' ? 'banned' : 'unbanned'), array('username' => $matches[2]));
					
					// Blank out the message and change type
					$this->_setInternal(self::TABLE_NAME, 	'type', 			$shouttypes['system']);
					$this->_setInternal(self::TABLE_NAME, 	'message', 			$newmsg->render());
					$this->_setInternal(self::TABLE_NAME, 	'message_parsed', 	$newmsg->render());
					$this->_setInternal(self::TABLE_NAME, 	'userid', 			-1);
					return false;					
					break;
					
				/*	
				case '/createchat':
					if (!$this->vbshout->permissions['cancreatechat'])
					{
						$this->error(new XenForo_Phrase('dbtech_xfshout_cant_create_chat'));
						return false;
					}
					
					if ($this->registry->options['dbtech_xfshout_maxchats'])
					{
						$i = 0;
						foreach ((array)$this->vbshout->cache['chatroom'] as $chatroomid => $chatroom)
						{
							if (!$chatroom['active'])
							{
								// Don't count closed rooms
								continue;
							}
							
							if ($chatroom['creator'] == $this->registry->userinfo['userid'])
							{
								// We're the creator
								$i++;
							}
						}
						
						if ($i >= $this->registry->options['dbtech_xfshout_maxchats'])
						{
							// Waaaay too many chats, slow down tiger!
							$this->error(new XenForo_Phrase('dbtech_xfshout_too_many_chats'));							
							return false;
						}
					}
					
					// Grab the title
					$title = $matches[2];
					
					// Add the chat room
					$this->_getDb()->query("
						INSERT INTO dbtech_xfshout_chatroom
							(title, instanceid, creator, members)
						VALUES (
							" . $this->registry->db->sql_prepare($title) . ",
							" . $this->registry->db->sql_prepare($this->vbshout->instance['instanceid']) . ",
							" . $this->registry->db->sql_prepare($this->registry->userinfo['userid']) . ",
							" . $this->registry->db->sql_prepare(trim(serialize(array($this->registry->userinfo['userid'] => '1')))) . "
						)
					");
					$chatroomid = $this->registry->db->insert_id();
					
					// Insert the chat member
					$this->_getDb()->query("
						INSERT INTO dbtech_xfshout_chatroommember
							(chatroomid, userid, status)
						VALUES (
							" . $this->registry->db->sql_prepare($chatroomid) . ",
							" . $this->registry->db->sql_prepare($this->registry->userinfo['userid']) . ",
							1
						)
					");
					
					// Build the cache
					$this->vbshout->build_cache('dbtech_xfshout_chatroom');
					
					// Set chat room info
					$this->vbshout->fetched['chatroomid'] 	= $chatroomid;
					$this->vbshout->fetched['roomname'] 	= $title;
					
					return false;
					break;
				*/
				default:
					$return_value = false;
					$handled = false;
					
					//($hook = vBulletinHook::fetch_hook('dbtech_xfshout_command_2')) ? eval($hook) : false;
					
					if (!$handled)
					{
						$this->error(new XenForo_Phrase('dbtech_xfshout_invalid_command'));
						return false;
					}
					return $return_value;
					break;
			}
		}
		
		return true;
	}
	
	/**
	* Gets the actual existing data out of data that was passed in. See parent for explanation.
	*
	* @param mixed
	*
	* @return array|false
	*/
	protected function _getExistingData($data)
	{
		if (!$id = $this->_getExistingPrimaryKey($data, self::TABLE_ID))
		{
			return false;
		}
		
		if (!$shout = $this->_getShoutModel()->getShoutById($id))
		{
			return false;
		}
		
		$returnData = $this->getTablesDataFromArray($shout);
		
		return $returnData;
	}

	/**
	* Gets SQL condition to update the existing record.
	*
	* @return string
	*/
	protected function _getUpdateCondition($tableName)
	{
		return self::TABLE_ID . ' = ' . $this->_db->quote($this->getExisting(self::TABLE_ID));
	}
	
	/**
	* Public facing handler for final verification before a save. Any verification
	* or complex defaults may be set by this.
	*
	* It is generally not advisable to override this function. If you just want to
	* add pre-save behaviors, override {@link _preSave()}.
	*/
	public function preSave()
	{
		// Call parent's presave
		parent::preSave();
		
		// Parse action codes
		$this->_parseActionCodes();
	}	
	
	/**
	* Saves the changes to the data. This either updates an existing record or inserts
	* a new one, depending whether {@link setExistingData} was called.
	*
	* After a successful insert with an auto_increment field, the value will be stored
	* into the new data array with a field marked as autoIncrement. Use {@link get()}
	* to get access to it.
	*
	* @return integer Value that changed / inserted
	*/
	public function save()
	{
		parent::save();
		
		return $this->get(self::TABLE_ID);
	}
	
	/**
	* Performs post-save actions
	*/
	protected function _postSave()
	{
		if ($this->isInsert() AND $this->get('userid') == XenForo_Visitor::getUserId())
		{
			$userId = intval(XenForo_Visitor::getUserId());
			if (!$userId)
			{
				// We're not doin shit
				return false;
			}
	
			$db = $this->_getDb();
	
			$postCount = $db->fetchOne('
				SELECT dbtech_xfshout_shouts
				FROM xf_user
				WHERE user_id = ?
			', $userId);
	
			// update
			$finalValue = $postCount + 1;

			if ($finalValue < 0)
			{
				$finalValue = 0;
			}
			
			$db->update('xf_user', array('dbtech_xfshout_shouts' => $finalValue), 'user_id = ' . $db->quote($userId));
			return true;
		}
	}
	
	/**
	* Performs post-delete actions
	*/
	protected function _postDelete()
	{
		$userId = intval($this->get('userid'));
		if ($userId <= 0)
		{
			// We're not doin shit
			return false;
		}

		$db = $this->_getDb();

		$postCount = $db->fetchOne('
			SELECT dbtech_xfshout_shouts
			FROM xf_user
			WHERE user_id = ?
		', $userId);

		// update
		$finalValue = $postCount - 1;

		if ($finalValue < 0)
		{
			$finalValue = 0;
		}
		
		$db->update('xf_user', array('dbtech_xfshout_shouts' => $finalValue), 'user_id = ' . $db->quote($userId));	
		return true;
	}
	
	/**
	* Helper method to get the database object.
	*
	* @return Zend_Db_Adapter_Abstract
	*/
	protected function _getDb()
	{
		if ($this->_db === null)
		{
			$this->_db = XenForo_Application::get('db');
		}

		return $this->_db;
	}
	
	/**
	 * Grabs the xFShout model from the cache.
	 * 
	 * @return DBTech_xFShout_Model_Shout
	 */
	protected function _getShoutModel()
	{
		return $this->getModelFromCache('DBTech_xFShout_Model_Shout');
	}
	
	/**
	* Gets the default set of options for this data writer. This is automatically
	* called in the constructor.
	*
	* @return array
	*/
	protected function _getDefaultOptions()
	{
		return array(
			'effectivePermissions' => array()
		);
	}	
}