<?php

/**
* Data writer for Instances.
*
* @package DBTech_xFShout
*/
class DBTech_xFShout_DataWriter_Instance extends XenForo_DataWriter
{
	const TABLE_NAME = 'xf_dbtech_xfshout_instance';
	const TABLE_ID = 'instance_id';
		
	/**
	 * Title of the phrase that will be created when a call to set the
	 * existing data fails (when the data doesn't exist).
	 *
	 * @var string
	 */
	protected $_existingDataErrorPhrase = 'dbtech_xfshout_requested_instance_not_found';

	/**
	* Gets the fields that are defined for the table. See parent for explanation.
	*
	* @return array
	*/
	protected function _getFields()
	{
		return array(
			self::TABLE_NAME => array(
				self::TABLE_ID	=> array(
					'type'			=> self::TYPE_UINT,
					'default'		=> array(
						self::TABLE_NAME,
						self::TABLE_ID
					),
					'autoIncrement' => true
				),
				'title' => array(
					'type' 				=> self::TYPE_STRING,
					'required' 			=> true,
					'maxLength' 		=> 50,
					'requiredError' 	=> 'please_enter_valid_title'
				),
				'description' => array(
					'type' 				=> self::TYPE_STRING,
					'required' 			=> false
				),
				'sticky' => array(
					'type' 				=> self::TYPE_STRING,
					'required' 			=> false
				),
				'sticky_parsed' => array(
					'type' 				=> self::TYPE_STRING,
					'required' 			=> false
				),
				'options' => array(
					'type' 				=> self::TYPE_SERIALIZED,
					'required' 			=> true
				),
				'bbcode' => array(
					'type' 				=> self::TYPE_SERIALIZED,
					'required' 			=> true
				),
				/*				
				'supported'    => array(
					'type' => self::TYPE_BOOLEAN,
					'default' => 1
				),
				'instance_id' => array(
					'type' => self::TYPE_STRING,
					'required' => true,
					'maxLength' => 25,
					'verification' => array('$this', '_verifyMediaSiteId'),
					'requiredError' => 'please_enter_valid_instance_id'
				),
				*/
			)
		);
	}

	/**
	* Gets the actual existing data out of data that was passed in. See parent for explanation.
	*
	* @param mixed
	*
	* @return array|false
	*/
	protected function _getExistingData($data)
	{
		if (!$id = $this->_getExistingPrimaryKey($data, 'instance_id'))
		{
			return false;
		}

		return array('xf_dbtech_xfshout_instance' => $this->_getInstanceModel()->getInstanceById($id));
	}

	/**
	* Gets SQL condition to update the existing record.
	*
	* @return string
	*/
	protected function _getUpdateCondition($tableName)
	{
		return 'instance_id = ' . $this->_db->quote($this->getExisting('instance_id'));
	}

	/**
	 * Verifies that the instance ID is valid.
	 *
	 * @param string $instanceId
	 *
	 * @return boolean
	 */
	/*
	protected function _verifyInstanceId(&$instanceId)
	{
		$instanceId = strtolower($instanceId);

		if ($this->isInsert() || $instanceId != $this->getExisting('instance_id'))
		{
			$existing = $this->_getInstanceModel()->getInstanceById($instanceId);
			if ($existing)
			{
				$this->error(new XenForo_Phrase('instance_ids_must_be_unique'), 'instance_id');
				return false;
			}
		}

		return true;
	}
	*/
	
	/**
	* Public facing handler for final verification before a save. Any verification
	* or complex defaults may be set by this.
	*
	* It is generally not advisable to override this function. If you just want to
	* add pre-save behaviors, override {@link _preSave()}.
	*/
	public function preSave()
	{
		if (isset($this->_newData[self::TABLE_NAME]['sticky']))
		{
			// Create the new BBCode Formatter object
			$formatter = XenForo_BbCode_Formatter_Base::create('DBTech_xFShout_BbCode_Shout');
			
			// Create the BBCode Parser
			$parser = new XenForo_BbCode_Parser($formatter);
						
			// We have a new sticky note, parse it
			$bbcodeOptions = @unserialize($this->get('bbcode'));
			
			$bbcode = array();
			foreach ($bbcodeOptions as $bbcodeid => $onoff)
			{
				if (!$onoff)
				{
					// Disabled BBCode
					continue;
				}
				
				// Add this to allowed tags
				$bbcode[] = $bbcodeid;
			}
			
			// Override the list of BBCode Tags allowed based on per-instance options
			$formatter->setTags($bbcode);    			
    		
			// Construct a dummy array to keep the wrapper happy
			$messages = array(0 => array('message' => $this->get('sticky')));
			
			// Do BBCode conversion
			$messages[0]['message'] = XenForo_Helper_String::autoLinkBbCode($messages[0]['message']);
			XenForo_ViewPublic_Helper_Message::bbCodeWrapMessages($messages, $parser);
    		
			// Grab the parsed sticky
			$this->set('sticky_parsed', $messages[0]['messageHtml']->__toString());			
		}
		
		// Call parent's presave
		parent::preSave();
	}
		
	/**
	* Saves the changes to the data. This either updates an existing record or inserts
	* a new one, depending whether {@link setExistingData} was called.
	*
	* After a successful insert with an auto_increment field, the value will be stored
	* into the new data array with a field marked as autoIncrement. Use {@link get()}
	* to get access to it.
	*
	* @return integer Value that changed / inserted
	*/
	public function save()
	{
		parent::save();
		
		return $this->get(self::TABLE_ID);
	}
	
	/**
	 * Post-save handling.
	 */
	protected function _postSave()
	{
		$this->_getInstanceModel()->rebuildInstanceCache();
	}

	/**
	 * Post-delete handling.
	 */
	protected function _postDelete()
	{
		// Remove the permissions entries
		$this->_db->delete('xf_dbtech_xfshout_permission_entry', $this->_getUpdateCondition(''));
				
		$this->_getInstanceModel()->rebuildInstanceCache();
	}

	/**
	 * @return DBTech_xFShout_Model_Instance
	 */
	protected function _getInstanceModel()
	{
		return $this->getModelFromCache('DBTech_xFShout_Model_Instance');
	}
}