<?php

/**
 * Controller for xFShout Instances.
 *
 * @package DBTech_xFShout
 */
class DBTech_xFShout_ControllerAdmin_Instance extends XenForo_ControllerAdmin_Abstract
{
	protected function _preDispatch($action)
	{
		$this->assertAdminPermission('dbtech_xfshout');
	}

	/**
	 * Lists all Instances.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionIndex()
	{
		$viewParams = array(
			'instances' => $this->_getInstanceModel()->getAllInstances()
		);
		return $this->responseView('DBTech_xFShout_ViewAdmin_Instance_List', 'dbtech_xfshout_instance_list', $viewParams);
	}

	/**
	 * Gets the instance add/edit form responst.
	 *
	 * @param array $site
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	protected function _getInstanceAddEditResponse(array $instance)
	{
		$permissionModel = $this->_getInstancePermissionsModel();
		
		$bbcodeObj = XenForo_BbCode_Formatter_Base::create();
		$bbcodeList = $bbcodeObj->getTags();
		
		// Ensure this is set
		$instance['options'] = @unserialize($instance['options']);
		$instance['bbcode'] = @unserialize($instance['bbcode']);
		
		$optionDefaults = array(
			'refreshtime' 	=> 5,
			'height' 		=> 150,
			'numshouts' 	=> 20,
			'maxlength' 	=> 256
		);		
		
		foreach ($optionDefaults as $key => $val)
		{
			if (!isset($instance['options'][$key]))
			{
				// Set defaults
				$instance['options'][$key] = $val;
			}
		}
		
		$bbcode = array();
		foreach ($bbcodeList as $key => $val)
		{
			if (!isset($instance['bbcode'][$key]))
			{
				// Set defaults
				$instance['bbcode'][$key] = 0;
			}
		}
		
		$viewParams = array(
			'instance' => $instance,
			'permissions' => $permissionModel->getUserCollectionPermissionsForInterface($instance['instance_id']),
			'permissionChoices' => $permissionModel->getCollectionPermissionsForInterface(),
		);
		
		return $this->responseView('DBTech_xFShout_ViewAdmin_Instance_Edit', 'dbtech_xfshout_instance_edit', $viewParams);
	}

	/**
	 * Displays a form to create a new instance.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionAdd()
	{
		return $this->_getInstanceAddEditResponse(array('instance_id' => 0));
	}

	/**
	 * Displays a form to edit an existing instance.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionEdit()
	{
		$instanceId = $this->_input->filterSingle('instance_id', XenForo_Input::UINT);
		$instance = $this->_getInstanceOrError($instanceId);

		return $this->_getInstanceAddEditResponse($instance);
	}

	/**
	 * Updates an existing instance or inserts a new one.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionSave()
	{
		$this->_assertPostOnly();
		
		$instanceId = $this->_input->filterSingle('instance_id', XenForo_Input::UINT);
		
		$dwInput = $this->_input->filter(array(
			'title' 		=> XenForo_Input::STRING,
			'description' 	=> XenForo_Input::STRING,
			'sticky' 		=> XenForo_Input::STRING,
			'options' 		=> XenForo_Input::ARRAY_SIMPLE,
			'bbcode' 		=> XenForo_Input::ARRAY_SIMPLE,
		));
		
		$dw = XenForo_DataWriter::create('DBTech_xFShout_DataWriter_Instance');
		if ($instanceId)
		{
			$dw->setExistingData($instanceId);
		}
		$dw->bulkSet($dwInput);
		$instanceId = $dw->save();
		
		$otherInput = $this->_input->filter(array(
			'permissions' 	=> XenForo_Input::ARRAY_SIMPLE,
		));
		
		foreach ($otherInput['permissions'] as $userGroupId => $permissions)
		{
			// Not MVC enough for you? I don't care.
			$this->_getInstancePermissionsModel()->setAllPermissions($userGroupId, $instanceId, $permissions);
		}
		
		// Rebuild instance permissions cache
		$this->_getInstancePermissionsModel()->rebuildInstancePermissionsCache();

		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			XenForo_Link::buildAdminLink('xfshout-instances')
		);
	}

	/**
	 * Deletes the specified instance.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionDelete()
	{
		if ($this->isConfirmedPost())
		{
			$redir = $this->_deleteData(
				'DBTech_xFShout_DataWriter_Instance', 'instance_id',
				XenForo_Link::buildAdminLink('xfshout-instances')
			);
			
			// Rebuild instance permissions cache
			$this->_getInstancePermissionsModel()->rebuildInstancePermissionsCache();
			
			return $redir;
		}
		else // show confirmation dialog
		{
			$instanceId = $this->_input->filterSingle('instance_id', XenForo_Input::STRING);
			$instance = $this->_getInstanceOrError($instanceId);

			$viewParams = array(
				'instance' => $instance
			);
			return $this->responseView('DBTech_xFShout_ViewAdmin_Instance_Delete', 'dbtech_xfshout_instance_delete', $viewParams);
		}
	}

	/**
	 * Gets the specified record or errors.
	 *
	 * @param string $id
	 *
	 * @return array
	 */
	protected function _getInstanceOrError($id)
	{
		$info = $this->_getInstanceModel()->getInstanceById($id);
		if (!$info)
		{
			throw $this->responseException($this->responseError(new XenForo_Phrase('dbtech_xfshout_requested_instance_not_found'), 404));
		}

		return $info;
	}

	/**
	 * @return DBTech_xFShout_Model_Instance
	 */
	protected function _getInstanceModel()
	{
		return $this->getModelFromCache('DBTech_xFShout_Model_Instance');
	}
	

	/**
	 * @return DBTech_xFShout_Model_InstancePermissions
	 */
	protected function _getInstancePermissionsModel()
	{
		return $this->getModelFromCache('DBTech_xFShout_Model_InstancePermissions');
	}	
}