<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class DBTech_xFShout_BbCode_Shout extends XenForo_BbCode_Formatter_Base
{
	/**
	 * List of tags which should be displayed
	 *
	 * @var boolean|array 	True = all | false = none | array = list of tags
	 */
	protected $_allowedTags = null;
	
	/**
	 * Sets the list of allowed tags and refreshes the formatter's tag list
	 * if needed.
	 *
	 * @var boolean|array True = all | false = none | array = list of tags
	 */
	public function setTags($allowedTags)
	{
		if ($this->_allowedTags === $allowedTags)
		{
			// Nothing's changed...
			return;
		}
					
		// Sets the allowed tags
		$this->_allowedTags = $allowedTags;
		
		// Refresh the old list's tags
		$this->_overrideTagList();
	}
	
	/**
	 * Overrides the formatter's tag list
	 */	
	protected function _overrideTagList()
	{
		// Erase the old tag list
		$this->_tags = null;
		
		// Grab the new tags
		$this->_tags = parent::getTags();
		
		foreach ($this->_tags AS $tagName => $tag)
		{
			if (in_array($tagName, (array)$this->_allowedTags) OR $this->_allowedTags === true)
			{
				// This was in the allowed tag list
				continue;
			}
			
			// Git rid of it
			unset($this->_tags[$tagName]);
		}
		
		// Ensure the data is reloaded
		$this->preLoadData();
	}
}