<?php
class DBTech_xFShout_Model_Shout extends XenForo_Model
{
	/**
	* List of shout types
	*
	* @var array All possible shout types
	*/	
	protected $_shouttypes = array(
		'shout'		=> 1,
		'pm'		=> 2,
		'me'		=> 4,
		'notif'		=> 8,
		'custom'	=> 16,
		'system'	=> 32,
		'mention'	=> 64,
		'tag'		=> 128,
		'thanks'	=> 256,	
	);
	
	/**
	 * Fetches effective permissions for the current visitor
	 * 
	 * @param array Visitor who's viewing it
	 * @param array All available permissions
	 * 
	 * @return void
	 */	
	public function getEffectivePermissions(array &$visitor, array $permissions)
	{
    	$visitor['permissions']['dbtech_xfshout'] = array();
    	
    	$usergroups = array($visitor['user_group_id']);
    	if ($visitor['secondary_group_ids'])
    	{
    		// Only do this if we actually have 2ndary I guess
    		$usergroups = array_merge($usergroups, explode(',', $visitor['secondary_group_ids']));
    	}
    	
    	foreach ($usergroups as $usergroupid)
		{
			foreach ($permissions as $instanceid => $perms)
			{
				if (!isset($visitor['permissions']['dbtech_xfshout'][$instanceid]))
				{
					// Init this array
					$visitor['permissions']['dbtech_xfshout'][$instanceid] = array();
				}
				
				foreach ($perms[$usergroupid] as $varname => $yesno)
				{
					// Shorthand this
					$val =& $visitor['permissions']['dbtech_xfshout'][$instanceid][$varname];
					
					// infraction group permissions override normal permissions
					if (!isset($val))
					{
						// Ensure it's set
						$val = 0;
					}
					
					// Ensure this is an int
					$yesno = intval($yesno);
					
					if ($val < $yesno)
					{
						// Just ensure it's 1 when we need it to be
						$val = $yesno;
					}
				}
			}
		}		
	}
	
	/**
	 * Fetches Shouts from the database, default limit is 20
	 * 
	 * @param int Instance ID we are viewing
	 * @param int Chatroom ID we are viewing
	 * @param int Number of shouts to fetch
	 * 
	 * @return array Array of shouts
	 */
	public function getShouts($instanceid, $chatroomid, $limit = 20)
	{
		$guestname = new XenForo_Phrase('guest');
		$systemname = new XenForo_Phrase('dbtech_xfshout_system');
		return $this->_getDb()->fetchAll($this->limitQueryResults(
			'
				SELECT 
					dbtech_xfshout_shout.*,
					user.*,
					IF(dbtech_xfshout_shout.userid = -1,
						"' . $systemname->render() . '",
						COALESCE(user.username, "' . $guestname->render() . '")
					) AS username
				FROM xf_dbtech_xfshout_shout AS dbtech_xfshout_shout
				LEFT JOIN xf_user AS user ON(user.user_id = dbtech_xfshout_shout.userid)
				WHERE dbtech_xfshout_shout.instanceid IN(0, ' . intval($instanceid) . ')
					' . ($chatroomid ? 'AND dbtech_xfshout_shout.chatroomid = ' . intval($chatroomid) : '') . '
				ORDER BY dbtech_xfshout_shout.dateline DESC
			', $limit, 0)
		);
	}

	/**
	 * Fetches a single shout based on shoutid
	 * 
	 * @param int Shout ID to fetch
	 * 
	 * @return array Array of shout info
	 */
	public function getShoutById($shoutid)
	{
		return $this->_getDb()->fetchRow('SELECT * FROM xf_dbtech_xfshout_shout WHERE shoutid = ?', $shoutid);
	}

	/**
	 * Fetches the shout types
	 * 
	 * @return array Array of shout types
	 */
	public function getShoutTypes()
	{
		return $this->_shouttypes;
	}
	

	/**
	 * Fetches the specified shout type
	 * 
	 * @param string The shout type to get
	 * 
	 * @return array Array of shout types
	 */
	public function getShoutType($type)
	{
		return (isset($this->_shouttypes[$type]) ? $this->_shouttypes[$type] : 1);
	}
	
	/**
	* Rebuilds the shout counter for every user.
	*/
	public function buildShoutCounter()
	{
		// Begin shout counter
		$cases = array();
		
		// Grab all shouts
		$shouts = $this->_getDb()->fetchAll("
			SELECT userid, COUNT(shoutid) AS numshouts
			FROM xf_dbtech_xfshout_shout
			WHERE userid NOT IN(0, -1)
			GROUP BY userid
		");
		foreach ($shouts as $shout)
		{
			// Build shout counters
			$cases[] = "WHEN $shout[userid] THEN $shout[numshouts]";
		}
		
		if (count($cases))
		{
			// Finally update the user table
			$tthis->_getDb()->query("
				UPDATE xf_user
				SET dbtech_xfshout_shouts = CASE userid
				" . implode(' ', $cases) . "
				ELSE 0 END
			");
		}
	}
	
	/**
	* Logs a specified command.
	*
	* @param	string	The executed command.
	* @param	mixed	(Optional) Additional comments.
	*/
	public function logCommand($command, $comment = NULL)
	{
		$bit = 0;
		switch ($command)
		{
			case 'shoutedit':
			case 'shoutdelete':
				$bit = 8;
				break;
			
			case 'prune':
				$bit = 1;
				break;
			
			case 'setsticky':
			case 'removesticky':
				$bit = 2;
				break;
				
			case 'ban':
			case 'unban':
				$bit = 4;
				break;
		}
		
		//($hook = vBulletinHook::fetch_hook('dbtech_vbshout_log_process')) ? eval($hook) : false;
		
		/*
		if (!$bit OR !($this->registry->options['dbtech_vbshout_logging'] & $bit))
		{
			// We didn't have this option on
			return;
		}
		*/
		
		$visitor = XenForo_Visitor::getInstance()->toArray();
		
		$this->_getDb()->query("
			INSERT INTO xf_dbtech_xfshout_log
				(userid, username, dateline, ipaddress, command, comment)
			VALUES (
				" . $this->_getDb()->quote($visitor['user_id']) . ",
				" . $this->_getDb()->quote($visitor['username']) . ",
				" . $this->_getDb()->quote(XenForo_Application::$time) . ",
				" . $this->_getDb()->quote((isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : '')) . ",
				" . $this->_getDb()->quote($command) . ",
				" . $this->_getDb()->quote($comment) . "
			)
		");
	}
}