<?php

/**
 * Model for Instance related behaviors.
 *
 * @package DBtech_xFShout
 */
class DBtech_xFShout_Model_Instance extends XenForo_Model
{
	/**
	 * Gets the specified instance.
	 *
	 * @param string $id
	 *
	 * @return array|false
	 */
	public function getInstanceById($id)
	{
		return $this->_getDb()->fetchRow('
			SELECT *
			FROM xf_dbtech_xfshout_instance
			WHERE instance_id = ?
		', $id);
	}

	/**
	 * Gets all instances, ordered by title.
	 *
	 * @return array [instance id] => info
	 */
	public function getAllInstances()
	{
		return $this->fetchAllKeyed('
			SELECT *
			FROM xf_dbtech_xfshout_instance
			ORDER BY title
		', 'instance_id');
	}

	/**
	 * Gets the instance data for the cache.
	 *
	 * @return array
	 */
	public function getInstancesForCache()
	{
		return $this->getAllInstances();
	}

	/**
	 * Gets the instance cache data.
	 *
	 * @return array
	 */
	public function getInstanceCache()
	{
		return $this->getInstancesForCache();
	}

	/**
	 * Rebuilds the instance cache.
	 *
	 * @return array
	 */
	public function rebuildInstanceCache()
	{
		$cache = $this->getInstanceCache();

		$this->_getDataRegistryModel()->set('dbtech_xfshout_instance', $cache);
		return $cache;
	}
}