<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class DBTech_xFShout_ControllerPublic_Shout extends XenForo_ControllerPublic_Abstract
{
	/** 
	 * View top x stats
	 * @return XenForo_ControllerResponse_View
	 */
	public function actionIndex()
	{    			
		$input = $this->_input->filter(array(
			'instanceid' 	=> XenForo_Input::UINT,
			'chatroomid' 	=> XenForo_Input::UINT,
		));
		
    	// Create some needed arrays
    	$instances 		= $this->_getCacheModel()->get('dbtech_xfshout_instance');
    	$permissions 	= $this->_getCacheModel()->get('dbtech_xfshout_instperms');
    	$visitor 		= XenForo_Visitor::getInstance()->toArray();

    	// Assert whether we are banned
       	$this->_assertBanned($visitor);
		
		// Assert instance id
		$this->_assertInstanceId($input['instanceid']);        	
    	
		// Get effective permissions
		$this->_getShoutModel()->getEffectivePermissions($visitor, $permissions);
		
		// Grab effective permissions
		$effectivePermissions = $visitor['permissions']['dbtech_xfshout'][$input['instanceid']];

		// Assert if we can post shouts
		$this->_assertPermissions($effectivePermissions, 'canview');
		
		// Ensure this is set
		$instance = $instances[$input['instanceid']];
		$instance['options'] = @unserialize($instance['options']);		
		
		// Get all shouts
		$shouts = $this->_getShoutModel()->getShouts($input['instanceid'], $input['chatroomid'], $instance['options']['numshouts']);
		
		foreach ($shouts as &$shout)
		{
			// Parse the dateline properly -.-
			$shout['dateline_parsed'] = XenForo_Locale::dateTime($shout['dateline'], 'relative');
			
			if (preg_match("#^(\/[a-z]*?)\s(.+?)$#i", $shout['message_parsed'], $matches))
			{
				// 2-stage command
				switch ($matches[1])
				{
					case '/me':
						// A slash me
						$shout['message_parsed'] 	= trim($matches[2]);
						$shout['type'] 				= $this->_getShoutModel()->getShoutType('me');
						break;
						
					default:
						//($hook = vBulletinHook::fetch_hook('dbtech_vbshout_parsecommand_2')) ? eval($hook) : false;
						break;				
				}
			}
		}

		//XenForo_Application::get('options')->dbtech_xfshout_limit
		$viewParams = array(
			'shouts'		=> $shouts,
			'sticky'		=> $instance['sticky'],
			'stickyParsed'	=> $instance['sticky_parsed'],
			'instanceid'	=> $input['instanceid'],
			'permissions'	=> $effectivePermissions,
			'visitor'		=> $visitor
		);
		
		return $this->responseView('DBTech_xFShout_ViewPublic_Shout', 'dbtech_xfshout_shouts', $viewParams);
	}
	
	/**
	 * Submits a new shout or returns current shouts
	 * @return XenForo_ControllerResponse_View
	 */
	public function actionAdd()
	{
		$input = $this->_input->filter(array(
			'shout' 		=> XenForo_Input::STRING,
			'shoutid' 		=> XenForo_Input::UINT,
			'instanceid' 	=> XenForo_Input::UINT,
			'chatroomid' 	=> XenForo_Input::UINT,
			'onlyadd'		=> XenForo_Input::UINT,
		));
		
		if (!empty($input['shout']))
		{
			// Actually adding a shout can only come from POST
			$this->_assertPostOnly();
			
	    	// Create some needed arrays
	    	$instances 		= $this->_getCacheModel()->get('dbtech_xfshout_instance');
	    	$permissions 	= $this->_getCacheModel()->get('dbtech_xfshout_instperms');
	    	$visitor 		= XenForo_Visitor::getInstance()->toArray();

	    	// Assert whether we are banned
	       	$this->_assertBanned($visitor);
			
			// Assert instance id
			$this->_assertInstanceId($input['instanceid']);	       	
	    	
			// Get effective permissions
			$this->_getShoutModel()->getEffectivePermissions($visitor, $permissions);
			
			// Grab effective permissions
			$effectivePermissions = $visitor['permissions']['dbtech_xfshout'][$input['instanceid']];		
			
			// Pass the string through various helpers
			$input['shout'] = XenForo_Helper_String::censorString($input['shout']);
			
			// Create the new BBCode Formatter object
			$formatter = XenForo_BbCode_Formatter_Base::create('DBTech_xFShout_BbCode_Shout');
			
			$instance = $instances[$input['instanceid']];
			$instance['options'] = @unserialize($instance['options']);
			$instance['bbcode'] = @unserialize($instance['bbcode']);
			
			$bbcode = array();
			foreach ($instance['bbcode'] as $bbcodeid => $onoff)
			{
				if (!$onoff)
				{
					// Disabled BBCode
					continue;
				}
				
				// Add this to allowed tags
				$bbcode[] = $bbcodeid;
			}
			
			// Override the list of BBCode Tags allowed based on per-instance options
			$formatter->setTags($bbcode);
			
			// Create the BBCode Parser
			$parser = new XenForo_BbCode_Parser($formatter);
			
			// Construct a dummy array to keep the wrapper happy
			$messages = array(0 => array('message' => $input['shout']));
			
			// Do BBCode conversion
			$messages[0]['message'] = XenForo_Helper_String::autoLinkBbCode($messages[0]['message']);
			XenForo_ViewPublic_Helper_Message::bbCodeWrapMessages($messages, $parser);			
			
			// Init the datawriter
			$dw = XenForo_DataWriter::create('DBTech_xFShout_DataWriter_Shout');			
				$dw->setOption('effectivePermissions', $effectivePermissions);
				$dw->setErrorHandler(XenForo_DataWriter::ERROR_ARRAY);
							
			if (!$input['shoutid'])
			{
				// Assert if we can post shouts
				$this->_assertPermissions($effectivePermissions, 'canshout');
				
				// Set some new-only values
				$dw->set('userid', XenForo_Visitor::getUserId());
				$dw->set('instanceid', $input['instanceid']);
				$dw->set('chatroomid', $input['chatroomid']);
			}
			else
			{
				// We're potentially editing a shout
				$dw->setExistingData($input['shoutid']);
				
				if ($dw->get('userid') == $visitor['user_id'])
				{
					// Assert if we can edit own shouts
					$this->_assertPermissions($effectivePermissions, 'caneditown');
				}
				else
				{
					// Assert if we can post shouts
					$this->_assertPermissions($effectivePermissions, 'caneditothers');
				}
			}
			
			// Set the rest of the (always changed) data
				$dw->set('message', $input['shout']);
				$dw->set('message_parsed', $messages[0]['messageHtml']->__toString());
			$shoutid = $dw->save();
			
			if (!$shoutid)
			{
				// Fling me sum error
				throw $this->responseException(
					$this->responseError(implode('<br />', $dw->getErrors()), 500)
				);				
			}
		}
		
		return ($input['onlyadd'] ? true : $this->actionIndex());
	}
	
	/**
	 * Deletes a shout.
	 * @return XenForo_ControllerResponse_View
	 */
	public function actionDelete()
	{
		$input = $this->_input->filter(array(
			'shoutid' 		=> XenForo_Input::UINT,
			'instanceid' 	=> XenForo_Input::UINT,
			'chatroomid' 	=> XenForo_Input::UINT,
			'onlydelete'	=> XenForo_Input::UINT,
		));
		
		// Actually adding a shout can only come from POST
		$this->_assertPostOnly();
		
    	// Create some needed arrays
    	$instances 		= $this->_getCacheModel()->get('dbtech_xfshout_instance');
    	$permissions 	= $this->_getCacheModel()->get('dbtech_xfshout_instperms');
    	$visitor 		= XenForo_Visitor::getInstance()->toArray();

    	// Assert whether we are banned
       	$this->_assertBanned($visitor);
		
		// Assert instance id
		$this->_assertInstanceId($input['instanceid']);	       	
    	
		// Get effective permissions
		$this->_getShoutModel()->getEffectivePermissions($visitor, $permissions);
		
		// Grab effective permissions
		$effectivePermissions = $visitor['permissions']['dbtech_xfshout'][$input['instanceid']];
		
		// Init the datawriter
		$dw = XenForo_DataWriter::create('DBTech_xFShout_DataWriter_Shout');			
			$dw->setOption('effectivePermissions', $effectivePermissions);
			$dw->setErrorHandler(XenForo_DataWriter::ERROR_ARRAY);
			$dw->setExistingData($input['shoutid']);
			
			if ($dw->get('userid') == $visitor['user_id'])
			{
				// Assert if we can edit own shouts
				$this->_assertPermissions($effectivePermissions, 'caneditown');
			}
			else
			{
				// Assert if we can post shouts
				$this->_assertPermissions($effectivePermissions, 'caneditothers');
			}
		$dw->delete();
		
		return ($input['onlydelete'] ? true : $this->actionIndex());
	}	
	
	/**
	 * Helper to assert that this action is available with a valid instance id. 
	 * Throws an exception if the request doesn't carry an instance id or it's invalid
	 * 
	 * @param integer The instance ID to check.
	 */
	protected function _assertInstanceId($instance_id)
	{
		$instances = $this->_getCacheModel()->get('dbtech_xfshout_instance');
		if (!isset($instances[$instance_id]))
		{
			throw $this->responseException(
				$this->responseError(new XenForo_Phrase('dbtech_xfshout_invalid_instanceid'), 500)
			);
		}
	}
	
	/**
	 * Helper to assert that this action is unavailable if banned. 
	 * Throws an exception if the user is banned
	 * 
	 * @param integer The visitor to check.
	 */
	protected function _assertBanned($visitor)
	{
		if ($visitor['dbtech_xfshout_banned'])
		{
			throw $this->responseException(
				$this->responseError(new XenForo_Phrase('dbtech_xfshout_banned'), 500)
			);
		}
	}

	/**
	 * Helper to assert that this action is available with a valid permission. 
	 * Throws an exception if the visitor doesn't have the required permissions.
	 * 
	 * @param array The visitor's permissions
	 * @param string The type of action we're doing
	 */
	protected function _assertPermissions($permissions, $type)
	{
		if (!$permissions[$type])
		{
			throw $this->responseException(
				$this->responseError(new XenForo_Phrase('dbtech_xfshout_no_permissions_' . $type), 500)
			);
		}
	}	

	/**
	 * Grabs the xFShout model from the cache.
	 * 
	 * @return DBTech_xFShout_Model_Shout
	 */
	protected function _getShoutModel()
	{
		return $this->getModelFromCache('DBTech_xFShout_Model_Shout');
	}
	/**
	 * Grabs the Cache model from the cache.
	 * 
	 * @return XenForo_Model_DataRegistry
	 */
	protected function _getCacheModel()
	{
		return $this->getModelFromCache('XenForo_Model_DataRegistry');
	}
}