/**
 * @author Belazor
 */

/** @param {jQuery} $ jQuery Object */
!function($, window, document, _undefined)
{
	// Preset vars
	pauseCountdown: false;
	timeout: 0;
	shoutid: 0;
	chatroomid: 0;

	/**
	 * Sets up the main object, passing a couple of important variables to set some context.
	 *
	 * @param jQuery The form we're working with
	 * @param integer The time between shoutbox refreshes
	 * @param integer The instance ID we're setting up
	 */
	XenForo.xFShout = function($form, refreshtime, instanceid)
	{
		// Variables needed
		this.refreshtime = refreshtime;
		this.instanceid = instanceid;
		
		// Objects
		this.label = $('#dbtech_xfshout_status' + instanceid);
		this.content = $('#dbtech_xfshout_content' + instanceid);
		
		// Finally construct it
		this.__construct($form);
	};
	
	// The main object
	XenForo.xFShout.prototype =
	{		
		/**
		 * Constructor for the Prototype object.
		 *
		 * @param jQuery The form we're working with
		 */
		__construct: function($form)
		{
			// Set where we're coming from
			this.href = $form.attr('action');
			
			// Initial shouts fetcing
			this.get = setInterval($.context(this, 'countdown'), 1000);	
			
			// Binds the submit and reset buttons
			$form.bind('submit', $.context(this, 'sendShout'));
			$('#xFShout' + this.instanceid + ' :input[name=submit]').bind('click', $.context(this, 'sendShout'));
			$('#xFShout' + this.instanceid + ' :input[name=cancel]').bind('click', $.context(this, 'cancelEditShout'));
			$('#xFShout' + this.instanceid + ' :input[name=delete]').bind('click', $.context(this, 'deleteShout'));
		},
		
		/**
		 * Countdown function for refresh time.
		 */
		countdown: function()
		{
			if (this.pauseCountdown)
			{
				// We're not doing shit atm
				return;
			}
			
			if (--this.timeout > 0)
			{
				// Still not fetching :(
				this.label.text(XenForo.phrases.dbtech_xfshout_fetching_shouts_in_x_seconds
					.replace('%seconds%', this.timeout)
				);
			}
			else
			{
				// Fetch shouts nao
				this.getShouts();
			}			
		},		
		
		/**
		 * Begins editing a shout
		 */
		editShout: function(shoutid)
		{
			// We're now fetching shouts! yay
			this.label.text(XenForo.phrases.dbtech_xfshout_editing_shout);
			
			// Reset the timeout
			this.pauseCountdown = true;
			
			// Set the working shout id
			this.shoutid = shoutid;
			
			// Set the contents of the textarea
			$('#xFShout' + this.instanceid + ' :input[name=shout]').val($('#xFShout' + this.instanceid + ' :input[name=message_raw' + shoutid + ']').val()).removeClass('prompt').focus();
			
			// Unhide the cancel button
			$('#xFShout' + this.instanceid + ' :input[name=cancel]').show();
			$('#xFShout' + this.instanceid + ' :input[name=delete]').show();
		},
		
		/**
		 * Begins editing the sticky notice
		 */
		editSticky: function()
		{
			// We're now fetching shouts! yay
			this.label.text(XenForo.phrases.dbtech_xfshout_editing_sticky);
			
			// Reset the timeout
			this.pauseCountdown = true;
			
			// Set the contents of the textarea
			$('#xFShout' + this.instanceid + ' :input[name=shout]').val('/sticky ' + $('#xFShout' + this.instanceid + ' :input[name=_sticky]').val()).removeClass('prompt').focus();
			
			// Unhide the cancel button
			$('#xFShout' + this.instanceid + ' :input[name=cancel]').show();
		},
		
		/**
		 * Cancels editing shout
		 */
		cancelEditShout: function()
		{
			// cancel the timeout
			this.pauseCountdown = false;
			
			// Set the working shout id
			this.shoutid = 0;
			
			// Set the contents of the textarea
			$('#xFShout' + this.instanceid + ' :input[name=shout]').val('').removeClass('prompt').focus();
			
			// Unhide the cancel button
			$('#xFShout' + this.instanceid + ' :input[name=cancel]').hide();
			$('#xFShout' + this.instanceid + ' :input[name=delete]').hide();
		},
		
		/**
		 * Fetches shouts from the database based on the context we're in.
		 */
		getShouts: function()
		{
			// We're now fetching shouts! yay
			this.label.text(XenForo.phrases.dbtech_xfshout_fetching_shouts);
			
			// Reset the timeout
			this.pauseCountdown = true;
			
			// AJAX call
			this.xhr = XenForo.ajax(
				this.href, 
				{
					'instanceid' : this.instanceid,
					'chatroomid' : this.chatroomid
				},
				$.context(this, 'gotShouts'), { type: 'GET' }
			);
		},
		
		/**
		 * The callback for the completed AJAX request.
		 *
		 * @param object The AJAX Data object
		 * @param string The text status of the AJAX request
		 */
		gotShouts: function(ajaxData, textStatus)
		{
			delete(this.xhr);
			
			// Also reset the timeout here
			this.pauseCountdown = false;
			this.timeout = this.refreshtime;			
			
			if (XenForo.hasResponseError(ajaxData))
			{
				// There was an error
				return false;
			}
			
			// Insert the content
			this.content.empty().append(ajaxData.templateHtml);
			$('#dbtech_xfshout_sticky' + this.instanceid).empty().append(ajaxData.stickyParsed);
			$('#xFShout' + this.instanceid + ' :input[name=_sticky]').val(ajaxData.sticky);
		},
		
		/**
		 * Submits a new shout to the database based on the context we're in.
		 */
		sendShout: function()
		{	
			if ($('#xFShout' + this.instanceid + ' :input[name=shout]').val().length == 0 || 
				$('#xFShout' + this.instanceid + ' :input[name=shout]').val() == $('#xFShout' + this.instanceid + ' :input[name=shout]').attr('placeholder'))
			{
				// We're not shouting.
				return false;
			}
			
			// We're now fetching shouts! yay
			this.label.text(XenForo.phrases.dbtech_xfshout_saving_shout);
			
			// Reset the timeout
			this.pauseCountdown = true;
			
			// AJAX call
			this.xhr = XenForo.ajax(
				this.href,
				{
					'shout'			: $('#xFShout' + this.instanceid + ' :input[name=shout]').val(),
					'shoutid'		: this.shoutid,
					'instanceid' 	: this.instanceid,
					'chatroomid' 	: this.chatroomid
				},
				$.context(this, 'gotShouts'), { type: 'POST' }
			);
			
			if (this.shoutid)
			{
				// We were editing a shout
				this.cancelEditShout();
			}			
			
			$('#xFShout' + this.instanceid + ' :input[name=shout]').val('').focus();
			
			return false;
		},
		
		/**
		 * Deletes a shout
		 */
		deleteShout: function()
		{
			if (!this.shoutid)
			{
				// We weren't editing O.o
				return;
			}
			
			// We're now fetching shouts! yay
			this.label.text(XenForo.phrases.dbtech_xfshout_deleting_shout);
			
			// Reset the timeout
			this.pauseCountdown = true;
			
			// AJAX call
			this.xhr = XenForo.ajax(
				'index.php?xfshout/delete',
				{
					'shout'			: $('#xFShout' + this.instanceid + ' :input[name=shout]').val(),
					'shoutid'		: this.shoutid,
					'instanceid' 	: this.instanceid,
					'chatroomid' 	: this.chatroomid
				},
				$.context(this, 'gotShouts'), { type: 'POST' }
			);
			
			// We were editing a shout
			this.cancelEditShout();
						
			$('#xFShout' + this.instanceid + ' :input[name=shout]').val('').focus();
			
			return false;
		}		
	};
}
(jQuery, this, document);