<?php
/* 
Paul Marsden
Importer for vBulletin 4 forums.
Based on vB 3.x Importer supplied by XenForo Team.
$Date: 2011-07-07 21:31:01 +0100 (Thu, 07 Jul 2011) $ 
$HeadURL: http://www.neptune.com/svn/pem/trunk/Xenforo/vBulletin4.php $ 
*/
class XenForo_Importer_vBulletin4 extends XenForo_Importer_Abstract
{
	protected static function getVersion()
	{
 		return '1.' . substr('$Revision: 66 $',11,-2);
	}

	protected $_sourceDb;

	protected $_prefix;

	protected $_charset = 'windows-1252';

	protected $_config;

	protected $_groupMap = null;

	public static function getName()
	{
		$rev = self::getVersion();
		return "vBulletin 4 Importer (Version : $rev)";
	}

	public function configure(XenForo_ControllerAdmin_Abstract $controller, array &$config)
	{
		$rev = self::getVersion();
		$xfrev = XenForo_Application::$version;
		if (XenForo_Application::$versionId < 1000370)
		{
			throw new XenForo_Exception("vBulletin 4 Importer v$rev is not compatible with Xenforo $xfrev, please upgrade Xenforo to the latest version.",true);
		}
		
		if ($config)
		{
			$errors = $this->validateConfiguration($config);
			if ($errors)
			{
				return $controller->responseError($errors);
			}

			if (isset($config['attachmentPath']) || isset($config['avatarPath']))
			{
				return true;
			}

			$this->_bootstrap($config);

			$settings = $this->_sourceDb->fetchPairs('
				SELECT varname, value
				FROM ' . $this->_prefix . 'setting
				WHERE varname IN (\'attachpath\', \'attachfile\', \'avatarpath\', \'usefileavatar\')
			');
			if (($settings['attachfile'] && $settings['attachpath'])
				|| ($settings['usefileavatar'] && $settings['avatarpath']))
			{
				return $controller->responseView('XenForo_ViewAdmin_Import_vBulletin_Config', 'import_vbulletin_config', array(
					'config' => $config,
					'attachmentPath' => ($settings['attachfile'] ? $settings['attachpath'] : ''),
					'avatarPath' => ($settings['usefileavatar'] ? $settings['avatarpath'] : ''),
				));
			}

			return true;
		}
		else
		{
			$configPath = getcwd() . '/includes/config.php';
			if (file_exists($configPath) && is_readable($configPath))
			{
				$config = array();
				include($configPath);

				$viewParams = array('input' => $config);
			}
			else
			{
				$viewParams = array('input' => array
				(
					'MasterServer' => array
					(
						'servername' => 'localhost',
						'port' => 3306,
						'username' => ' ',
						'password' => ' ',
					),
					'Database' => array
					(
						'dbname' => ' ',
						'tableprefix' => ' '
					),
					'Mysqli' => array
					(
						'charset' => ' '
					),
				));
			}

			return $controller->responseView('XenForo_ViewAdmin_Import_vBulletin_Config', 'import_vbulletin_config', $viewParams);
		}
	}

	public function validateConfiguration(array &$config)
	{
		$errors = array();

		$config['db']['prefix'] = trim(preg_replace('/[^a-z0-9_]/i', '', $config['db']['prefix']));

		try
		{
			$db = Zend_Db::factory('mysqli',
				array(
					'host' => trim($config['db']['host']),
					'port' => trim($config['db']['port']),
					'username' => trim($config['db']['username']),
					'password' => trim($config['db']['password']),
					'dbname' => trim($config['db']['dbname']),
					'charset' => trim($config['db']['charset'])
				)
			);
			$db->getConnection();
		}
		catch (Zend_Db_Exception $e)
		{
			$errors[] = new XenForo_Phrase('source_database_connection_details_not_correct_x', array('error' => $e->getMessage()));
		}

		if ($errors)
		{
			return $errors;
		}

		try
		{
			$db->query('
				SELECT userid
				FROM ' . $config['db']['prefix'] . 'user
				LIMIT 1
			');
		}
		catch (Zend_Db_Exception $e)
		{
			if ($config['db']['dbname'] === '')
			{
				$errors[] = new XenForo_Phrase('please_enter_database_name');
			}
			else
			{
				$errors[] = new XenForo_Phrase('table_prefix_or_database_name_is_not_correct');
			}
		}

		if (!empty($config['attachmentPath']))
		{
			if (!file_exists($config['attachmentPath']) || !is_dir($config['attachmentPath']))
			{
				$errors[] = new XenForo_Phrase('attachments_directory_not_found');
			}
		}

		if (!empty($config['avatarPath']))
		{
			if (!file_exists($config['avatarPath']) || !is_dir($config['avatarPath']))
			{
				$errors[] = new XenForo_Phrase('avatars_directory_not_found');
			}
		}

		if (!$errors)
		{
			$defaultLanguageId = $db->fetchOne('
				SELECT value
				FROM ' . $config['db']['prefix'] . 'setting
				WHERE varname = \'languageid\'
			');
			$defaultCharset = $db->fetchOne('
				SELECT charset
				FROM ' . $config['db']['prefix'] . 'language
				WHERE languageid = ?
			', $defaultLanguageId);
			if (!$defaultCharset || str_replace('-', '', strtolower($defaultCharset)) == 'iso88591')
			{
				$config['charset'] = 'windows-1252';
			}
			else
			{
				$config['charset'] = strtolower($defaultCharset);
			}
		}

		return $errors;
	}

	public function getSteps()
	{
		return array(
			'userGroups' => array(
				'title' => new XenForo_Phrase('import_user_groups')
			),
			'users' => array(
				'title' => new XenForo_Phrase('import_users'),
				'depends' => array('userGroups')
			),
			'avatars' => array(
				'title' => new XenForo_Phrase('import_custom_avatars'),
				'depends' => array('users')
			),
			'privateMessages' => array(
				'title' => new XenForo_Phrase('import_private_messages'),
				'depends' => array('users')
			),
			'visitorMessages' => array(
				'title' => new XenForo_Phrase('import_profile_comments'),
				'depends' => array('users')
			),
			'forums' => array(
				'title' => new XenForo_Phrase('import_forums'),
				'depends' => array('userGroups')
			),
			'moderators' => array(
				'title' => new XenForo_Phrase('import_moderators'),
				'depends' => array('forums', 'users')
			),
			'threads' => array(
				'title' => new XenForo_Phrase('import_threads_and_posts'),
				'depends' => array('forums', 'users')
			),
			'polls' => array(
				'title' => new XenForo_Phrase('import_polls'),
				'depends' => array('threads')
			),
			'reputation' => array(
				'title' => new XenForo_Phrase('import_positive_reputation'),
				'depends' => array('threads')
			),
			'social' => array(
				'title' => 'Import Social Groups',
				'depends' => array('threads')
			),
			'sgimages' => array(
				'title' => 'Import Social Group Images',
				'depends' => array('social')
			),
			'albums' => array(
				'title' => 'Import Albums',
				'depends' => array('threads')
			),
			'blogs' => array(
				'title' => 'Import Blogs',
				'depends' => array('threads')
			),
			'articles' => array(
				'title' => 'Import CMS Articles',
				'depends' => array('threads')
			),
			'attachments' => array(
				'title' => new XenForo_Phrase('import_attached_files'),
				'depends' => array('threads','blogs','articles')
			),
		);
	}

	protected function _bootstrap(array $config)
	{
		if ($this->_sourceDb)
		{
			return;
		}

		@set_time_limit(0);

		$this->_config = $config;

		$this->_sourceDb = Zend_Db::factory('mysqli',
			array(
				'host' => trim($config['db']['host']),
				'port' => trim($config['db']['port']),
				'username' => trim($config['db']['username']),
				'password' => trim($config['db']['password']),
				'dbname' => trim($config['db']['dbname']),
				'charset' => trim($config['db']['charset'])
			)
		);

		$this->_prefix = trim(preg_replace('/[^a-z0-9_]/i', '', $config['db']['prefix']));

		if (!empty($config['charset']))
		{
			$this->_charset = $config['charset'];
		}
	}

	public function stepUserGroups($start, array $options)
	{
		$sDb = $this->_sourceDb;
		$prefix = $this->_prefix;
		$model = $this->_importModel;

		// All usergroups are done in one go
		$userGroups = $sDb->fetchAll('
			SELECT *
			FROM ' . $prefix . 'usergroup
			ORDER BY usergroupid
		');

		$total = 0;

		XenForo_Db::beginTransaction();

		foreach ($userGroups AS $userGroup)
		{
			$titlePriority = 5;
			switch ($userGroup['usergroupid'])
			{
				case 1: // guests
					$model->logImportData('userGroup', $userGroup['usergroupid'], XenForo_Model_User::$defaultGuestGroupId);
					break;

				case 2: // registered users
				case 3: // email confirm
				case 4: // moderation
					$model->logImportData('userGroup', $userGroup['usergroupid'], XenForo_Model_User::$defaultRegisteredGroupId);
					break;

				case 6: // admins
					$model->logImportData('userGroup', $userGroup['usergroupid'], XenForo_Model_User::$defaultAdminGroupId);
					continue;

				case 7: // mods
					$model->logImportData('userGroup', $userGroup['usergroupid'], XenForo_Model_User::$defaultModeratorGroupId);
					continue;

				case 5: // super mods
					$titlePriority = 910;

				default:
					$import = array(
						'title' => $this->_convertToUtf8($userGroup['title']),
						'user_title' => $this->_convertToUtf8($userGroup['usertitle']),
						'display_style_priority' => $titlePriority,
						'permissions' => $this->_calculateUserGroupPermissions($userGroup)
					);

					if ($model->importUserGroup($userGroup['usergroupid'], $import))
					{
						$total++;
					}
			}
		}

		XenForo_Model::create('XenForo_Model_UserGroup')->rebuildDisplayStyleCache();

		XenForo_Db::commit();

		$this->_session->incrementStepImportTotal($total);

		return true;
	}

	protected function _calculateUserGroupPermissions(array $userGroup)
	{
		$perms = array();

		$userGroup['forumpermissions'] = intval($userGroup['forumpermissions']);
		$userGroup['genericpermissions'] = intval($userGroup['genericpermissions']);
		$userGroup['adminpermissions'] = intval($userGroup['adminpermissions']);
		$userGroup['visitormessagepermissions'] = intval($userGroup['visitormessagepermissions']);

		if ($userGroup['forumpermissions'] & 1)
		{
			$perms['general']['view'] = 'allow';
			$perms['general']['viewNode'] = 'allow';
			$perms['forum']['like'] = 'allow';
		}

		if ($userGroup['genericpermissions'] & 1)
		{
			$perms['general']['viewProfile'] = 'allow';
		}

		if (($userGroup['adminpermissions'] & 1) || ($userGroup['adminpermissions'] & 2))
		{
			$perms['general']['bypassFloodCheck'] = 'allow';
		}

		if ($userGroup['forumpermissions'] & 4)
		{
			$perms['general']['search'] = 'allow';
		}

		if ($userGroup['forumpermissions'] & 131072)
		{
			$perms['general']['followModerationRules'] = 'allow';
		}

		if ($userGroup['forumpermissions'] & 16)
		{
			$perms['forum']['postThread'] = 'allow';
		}
		if ($userGroup['forumpermissions'] & 32)
		{
			$perms['forum']['postReply'] = 'allow';
		}
		if ($userGroup['forumpermissions'] & 256)
		{
			$perms['forum']['deleteOwnPost'] = 'allow';
		}
		if ($userGroup['forumpermissions'] & 512)
		{
			$perms['forum']['deleteOwnThread'] = 'allow';
		}
		if ($userGroup['forumpermissions'] & 128)
		{
			$perms['forum']['editOwnPost'] = 'allow';
		}
		if ($userGroup['forumpermissions'] & 4096)
		{
			$perms['forum']['viewAttachment'] = 'allow';
		}
		if ($userGroup['forumpermissions'] & 8192)
		{
			$perms['forum']['uploadAttachment'] = 'allow';
		}
		if ($userGroup['forumpermissions'] & 32768)
		{
			$perms['forum']['votePoll'] = 'allow';
		}

		if ($userGroup['pmsendmax'])
		{
			$perms['conversation']['start'] = 'allow';
			$perms['conversation']['maxRecipients'] = $userGroup['pmsendmax'];
			if ($perms['conversation']['maxRecipients'] > 2147483647)
			{
				$perms['conversation']['maxRecipients'] = -1;
			}
		}

		if ($userGroup['genericpermissions'] & 512)
		{
			$perms['avatar']['allowed'] = 'allow';
			$perms['avatar']['maxFileSize'] = ($userGroup['avatarmaxsize'] > 0 ? $userGroup['avatarmaxsize'] : -1);
			if ($perms['avatar']['maxFileSize'] > 2147483647)
			{
				$perms['avatar']['maxFileSize'] = -1;
			}
		}

		if ($userGroup['visitormessagepermissions'] & 1)
		{
			$perms['profilePost']['view'] = 'allow'; // this checks against "can message own", which isn't perfect
			$perms['profilePost']['like'] = 'allow';
		}
		if ($userGroup['visitormessagepermissions'] & 2)
		{
			$perms['profilePost']['post'] = 'allow'; // this checks against "can message others"
		}
		if ($userGroup['visitormessagepermissions'] & 4)
		{
			$perms['profilePost']['editOwn'] = 'allow';
		}
		if ($userGroup['visitormessagepermissions'] & 8)
		{
			$perms['profilePost']['deleteOwn'] = 'allow';
		}
		if ($userGroup['visitormessagepermissions'] & 32)
		{
			$perms['profilePost']['manageOwn'] = 'allow';
		}

		return $perms;
	}

	public function configStepUsers(array $options)
	{
		if ($options)
		{
			return false;
		}

		return $this->_controller->responseView('XenForo_ViewAdmin_Import_vBulletin_ConfigUsers', 'import_config_users');
	}

	public function stepUsers($start, array $options)
	{
		$options = array_merge(array(
			'limit' => 100,
			'processed' => 0,
			'max' => false,
			// all checkbox options must default to false as they may not be submitted
			'mergeEmail' => false,
			'mergeName' => false,
			'gravatar' => false
		), $options);

		$sDb = $this->_sourceDb;
		$prefix = $this->_prefix;
		$model = $this->_importModel;

		if ($options['max'] === false)
		{
			$data = $sDb->fetchRow('
				SELECT MAX(userid) AS max, COUNT(userid) AS rows
				FROM ' . $prefix . 'user
			');

			$options = array_merge($options,$data);
		}

		$users = $sDb->fetchAll(
			$sDb->limit($this->_getSelectUserSql('user.userid > ' . $sDb->quote($start)), $options['limit'])
		);

		if (!$users)
		{
			return $this->_getNextUserStep();
		}

		XenForo_Db::beginTransaction();

		$next = 0;
		$total = 0;
		foreach ($users AS $user)
		{
			$next = $user['userid'];
			$options['processed'] += 1; 
			$imported = $this->_importOrMergeUser($user, $options);
			if ($imported)
			{
				$total++;
			}
		}

		XenForo_Db::commit();

		$this->_session->incrementStepImportTotal($total);
		return array($next, $options, $this->_getProgressOutput($options['processed'], $options['rows']));
	}

	public function stepUsersMerge($start, array $options)
	{
		$sDb = $this->_sourceDb;

		$manual = $this->_session->getExtraData('userMerge');

		if ($manual)
		{
			$merge = $sDb->fetchAll($this->_getSelectUserSql('user.userid IN (' . $sDb->quote(array_keys($manual)) . ')'));

			$resolve = $this->_controller->getInput()->filterSingle('resolve', XenForo_Input::ARRAY_SIMPLE);
			if ($resolve && !empty($options['shownForm']))
			{
				$this->_session->unsetExtraData('userMerge');
				$this->_resolveUserConflicts($merge, $resolve);
			}
			else
			{
				// prevents infinite loop if redirected back to step
				$options['shownForm'] = true;
				$this->_session->setStepInfo(0, $options);

				$users = array();
				foreach ($merge AS $user)
				{
					$users[$user['userid']] = array(
						'username' => $this->_convertToUtf8($user['username'], true),
						'email' => $this->_convertToUtf8($user['email']),
						'message_count' => $user['posts'],
						'register_date' => $user['joindate'],
						'conflict' => $manual[$user['userid']]
					);
				}

				return $this->_controller->responseView(
					'XenForo_ViewAdmin_Import_MergeUsers', 'import_merge_users', array('users' => $users)
				);
			}
		}

		return $this->_getNextUserStep();
	}

	public function stepUsersFailed($start, array $options)
	{
		$sDb = $this->_sourceDb;

		$manual = $this->_session->getExtraData('userFailed');

		if ($manual)
		{
			$users = $this->_sourceDb->fetchAll($this->_getSelectUserSql('user.userid IN (' . $sDb->quote(array_keys($manual)) . ')'));

			$resolve = $this->_controller->getInput()->filterSingle('resolve', XenForo_Input::ARRAY_SIMPLE);

			if ($resolve && !empty($options['shownForm']))
			{
				$this->_session->unsetExtraData('userFailed');
				$this->_resolveUserConflicts($users, $resolve);
			}
			else
			{
				// prevents infinite loop if redirected back to step
				$options['shownForm'] = true;
				$this->_session->setStepInfo(0, $options);

				$failedUsers = array();
				foreach ($users AS $user)
				{
					$failedUsers[$user['userid']] = array(
						'username' => $this->_convertToUtf8($user['username'], true),
						'email' => $this->_convertToUtf8($user['email']),
						'message_count' => $user['posts'],
						'register_date' => $user['joindate'],
						'failure' => $manual[$user['userid']]
					);
				}

				return $this->_controller->responseView(
					'XenForo_ViewAdmin_Import_FailedUsers', 'import_failed_users', array('users' => $failedUsers)
				);
			}
		}

		return $this->_getNextUserStep();
	}

	protected function _resolveUserConflicts(array $users, array $resolve)
	{
		$model = $this->_importModel;

		$total = 0;

		XenForo_Db::beginTransaction();

		foreach ($users AS $user)
		{
			if (empty($resolve[$user['userid']]))
			{
				continue;
			}

			$info = $resolve[$user['userid']];

			if (empty($info['action']) || $info['action'] == 'change')
			{
				if (isset($info['email']))
				{
					$user['email'] = $info['email'];
				}
				if (isset($info['username']))
				{
					$user['username'] = $info['username'];
				}

				$imported = $this->_importOrMergeUser($user);
				if ($imported)
				{
					$total++;
				}
			}
			else if ($info['action'] == 'merge')
			{
				$im = $this->_importModel;

				if ($match = $im->getUserIdByEmail($this->_convertToUtf8($user['email'])))
				{
					$this->_mergeUser($user, $match);
				}
				else if ($match = $im->getUserIdByUserName($this->_convertToUtf8($user['username'], true)))
				{
					$this->_mergeUser($user, $match);
				}

				$total++;
			}
		}

		XenForo_Db::commit();

		$this->_session->incrementStepImportTotal($total, 'users');
	}

	protected function _getNextUserStep()
	{
		if ($this->_session->getExtraData('userMerge'))
		{
			return 'usersMerge';
		}

		if ($this->_session->getExtraData('userFailed'))
		{
			return 'usersFailed';
		}

		return true;
	}

	protected function _importOrMergeUser(array $user, array $options = array())
	{
		$im = $this->_importModel;

		if ($user['email'] && $emailMatch = $im->getUserIdByEmail($this->_convertToUtf8($user['email'])))
		{
			if (!empty($options['mergeEmail']))
			{
				return $this->_mergeUser($user, $emailMatch);
			}
			else
			{
				if ($im->getUserIdByUserName($this->_convertToUtf8($user['username'], true)))
				{
					$this->_session->setExtraData('userMerge', $user['userid'], 'both');
				}
				else
				{
					$this->_session->setExtraData('userMerge', $user['userid'], 'email');
				}
				return false;
			}
		}

		$name = $this->mbTrim($user['username'],50,$user['userid']);

		if ($nameMatch = $im->getUserIdByUserName($name))
		{
			if (!empty($options['mergeName']))
			{
				return $this->_mergeUser($user, $nameMatch);
			}
			else
			{
				$this->_session->setExtraData('userMerge', $user['userid'], 'name');
				return false;
			}
		}

		return $this->_importUser($user, $options);
	}

	protected function _importUser(array $user, array $options)
	{
		if ($this->_groupMap === null)
		{
			$this->_groupMap = $this->_importModel->getImportContentMap('userGroup');
		}

		$user['options'] = intval($user['options']);

		$import = array(
			'username' => $this->_convertToUtf8($user['username'], true),
			'email' => $this->_convertToUtf8($user['email']),
			'user_group_id' => $this->_mapLookUp($this->_groupMap, $user['usergroupid'], XenForo_Model_User::$defaultRegisteredGroupId),
			'secondary_group_ids' => $this->_mapLookUpList($this->_groupMap, explode(',', $user['membergroupids'])),
			'authentication' => array(
				'scheme_class' => 'XenForo_Authentication_vBulletin',
				'data' => array(
					'hash' => $user['password'],
					'salt' => $user['salt']
				)
			),
			'homepage' => $this->_convertToUtf8($user['homepage']),
			'last_activity' => $user['lastactivity'],
			'register_date' => $user['joindate'],
			'ip' => $user['ipaddress'],
			'message_count' => $user['posts'],
			'is_admin' => $user['is_admin'],
			'is_banned' => $user['is_banned'],
			'signature' => $this->_convertToUtf8($user['signature']),
			'timezone' => $this->_importModel->resolveTimeZoneOffset($user['timezoneoffset'], $user['options'] & 64), // 64 = dstauto
			'content_show_signature' => (($user['options'] & 1) ? 1 : 0), // 1 = showsignatures
			'receive_admin_email' => (($user['options'] & 16) ? 1 : 0), // 16 = adminemail
		);

		// Prefix and trim huge usernames to stop duplicate key errors.
		$import['username'] = $this->mbTrim($import['username'],50,$user['userid']);

		if ($user['customtitle'])
		{
			$import['custom_title'] = $this->_convertToUtf8($user['usertitle']);
			if ($user['customtitle'] == 2) // admin set
			{
				$import['custom_title'] = htmlspecialchars_decode($import['custom_title']);
				$import['custom_title'] = preg_replace('#<br\s*/?>#i', ', ', $import['custom_title']);
				$import['custom_title'] = strip_tags($import['custom_title']);
			}
		}

		if (!($user['options'] & 2048)) // 2048 = receivepm
		{
			$import['allow_send_personal_conversation'] = 'none';
		}
		else if ($user['options'] & 131072) // 131072 = receivepmbuddies
		{
			$import['allow_send_personal_conversation'] = 'followed';
		}

		if (!($user['options'] & 8388608)) // 8388608 = vm_enable
		{
			$import['allow_post_profile'] = 'none';
		}
		else if ($user['options'] & 16777216) // 16777216 = vm_contactonly
		{
			$import['allow_post_profile'] = 'followed';
		}

		if ($user['birthday'])
		{
			$parts = explode('-', $user['birthday']);
			if (count($parts) == 3)
			{
				$import['dob_day'] = $parts[1];
				$import['dob_month'] = $parts[0];
				$import['dob_year'] = $parts[2];
			}
		}

		// try to give users without an avatar that have actually posted a gravatar
		if (!empty($options['gravatar']))
		{
			if (!$user['has_custom_avatar'] && $user['email'] && $user['lastpost'] && XenForo_Model_Avatar::gravatarExists($user['email']))
			{
				$import['gravatar'] = $import['email'];
			}
		}

		$import['about'] = '';
		if (isset($user['field1']))
		{
			$import['about'] .= $this->_convertToUtf8($user['field1']) . "\n\n";
		}
		if (isset($user['field3']))
		{
			$import['about'] .= $this->_convertToUtf8($user['field3']) . "\n\n";
		}
		$import['about'] = trim($import['about']);

		if (isset($user['field2']))
		{
			$import['location'] = $this->_convertToUtf8($user['field2']);
		}
		if (isset($user['field4']))
		{
			$import['occupation'] = $this->_convertToUtf8($user['field4']);
		}

		switch ($user['usergroupid'])
		{
			case 3: $import['user_state'] = 'email_confirm'; break;
			case 4: $import['user_state'] = 'moderated'; break;
			default: $import['user_state'] = 'valid';
		}

		switch ($user['autosubscribe'])
		{
			case -1: $import['default_watch_state'] = ''; break;
			case 0: $import['default_watch_state'] = 'watch_no_email'; break;
			default: $import['default_watch_state'] = 'watch_email';
		}

		switch ($user['showbirthday'])
		{
			case 0: $import['show_dob_year'] = 0; $import['show_dob_date'] = 0; break;
			case 1: $import['show_dob_year'] = 1; $import['show_dob_date'] = 0; break;
			case 2: $import['show_dob_year'] = 1; $import['show_dob_date'] = 1; break;
			case 3: $import['show_dob_year'] = 0; $import['show_dob_date'] = 1; break;
		}

		$import['identities'] = array();
		if ($user['icq'])
		{
			$import['identities']['icq'] = $this->_convertToUtf8($user['icq']);
		}
		if ($user['aim'])
		{
			$import['identities']['aim'] = $this->_convertToUtf8($user['aim']);
		}
		if ($user['yahoo'])
		{
			$import['identities']['yahoo'] = $this->_convertToUtf8($user['yahoo']);
		}
		if ($user['msn'])
		{
			$import['identities']['msn'] = $this->_convertToUtf8($user['msn']);
		}
		if ($user['skype'])
		{
			$import['identities']['skype'] = $this->_convertToUtf8($user['skype']);
		}

		if ($user['is_admin'] && $user['admin_permissions'])
		{
			$user['admin_permissions'] = intval($user['admin_permissions']);

			$aPerms = array();
			if ($user['admin_permissions'] & 4) { $aPerms[] = 'option'; }
			if ($user['admin_permissions'] & 8) { $aPerms[] = 'style'; }
			if ($user['admin_permissions'] & 16) { $aPerms[] = 'language'; }
			if ($user['admin_permissions'] & 32) { $aPerms[] = 'node'; }
			if ($user['admin_permissions'] & 256)
			{
				$aPerms[] = 'user';
				$aPerms[] = 'ban';
				$aPerms[] = 'identityService';
				$aPerms[] = 'trophy';
				$aPerms[] = 'userUpgrade';
			}
			if ($user['admin_permissions'] & 512) { $aPerms[] = 'userGroup'; } // actually, user permissions
			if ($user['admin_permissions'] & 4096) { $aPerms[] = 'bbCodeSmilie'; }
			if ($user['admin_permissions'] & 8192) { $aPerms[] = 'cron'; }
			if ($user['admin_permissions'] & 16384)
			{
				$aPerms[] = 'import';
				$aPerms[] = 'upgradeXenForo';
			}
			if ($user['admin_permissions'] & 65536) { $aPerms[] = 'addOn'; }

			$import['admin_permissions'] = $aPerms;
		}

		$usererror = '';
/*
		At some point we could set usererror and have the importer
		display failed usernames, the reason they failed, and request an
		alternative name. ATM, the reason is hard coded as "Commas not allowed"
		so to make use of it would need template changes.
*/
		if ($usererror)
		{
			$importedUserId = 0;
			$failedKey = $usererror;
		}
		else
		{
			$importedUserId = $this->_importModel->importUser($user['userid'], $import, $failedKey);
		}

		if ($importedUserId)
		{
			if ($user['is_banned'])
			{
				$this->_importModel->importBan(array(
					'user_id' => $importedUserId,
					'ban_user_id' => $this->_importModel->mapUserId($user['ban_user_id'], 0),
					'ban_date' => $user['ban_date'],
					'end_date' => $user['ban_end_date'],
					'user_reason' => $this->_convertToUtf8($user['ban_reason'])
				));
			}

			if ($user['is_super_moderator'])
			{
				$this->_session->setExtraData('superMods', $user['userid'], $importedUserId);
			}

			if ($user['buddylist'])
			{
				$buddyIds = array_slice(explode(' ', $user['buddylist']), 0, 1000);
				$buddyIds = $this->_importModel->getImportContentMap('user', $buddyIds);
				$this->_importModel->importFollowing($importedUserId, $buddyIds);
			}
		}
		else if ($failedKey)
		{
			$this->_session->setExtraData('userFailed', $user['userid'], $failedKey);
		}

		return $importedUserId;
	}

	protected function _getSelectUserSql($where)
	{
		return '
			SELECT user.*, userfield.*, usertextfield.*,
				IF(admin.userid IS NULL, 0, 1) AS is_admin,
				admin.adminpermissions AS admin_permissions,
				IF(userban.userid IS NULL, 0, 1) AS is_banned,
				userban.bandate AS ban_date,
				userban.liftdate AS ban_end_date,
				userban.reason AS ban_reason,
				userban.adminid AS ban_user_id,
				IF(usergroup.adminpermissions & 1, 1, 0) AS is_super_moderator,
				IF(customavatar.userid, 1, 0) AS has_custom_avatar
			FROM ' . $this->_prefix . 'user AS user
			INNER JOIN ' . $this->_prefix . 'usergroup AS usergroup USING (usergroupid)
			INNER JOIN ' . $this->_prefix . 'userfield AS userfield USING (userid)
			INNER JOIN ' . $this->_prefix . 'usertextfield AS usertextfield USING (userid)
			LEFT JOIN ' . $this->_prefix . 'administrator AS admin USING (userid)
			LEFT JOIN ' . $this->_prefix . 'userban AS userban USING (userid)
			LEFT JOIN ' . $this->_prefix . 'customavatar AS customavatar USING (userid)
			WHERE ' . $where . '
			ORDER BY user.userid
		';
	}

	protected function _mergeUser(array $user, $targetUserId)
	{
		$this->_db->query('
			UPDATE xf_user SET
				message_count = message_count + ?,
				register_date = IF(register_date > ?, ?, register_date)
			WHERE user_id = ?
		', array($user['posts'], $user['joindate'], $user['joindate'], $targetUserId));

		$this->_importModel->logImportData('user', $user['userid'], $targetUserId);

		return $targetUserId;
	}

	public function stepAvatars($start, array $options)
	{
		$options = array_merge(array(
			'path' => isset($this->_config['avatarPath']) ? trim($this->_config['avatarPath']) : '',
			'limit' => 50,
			'processed' => 0,
			'max' => false
		), $options);

		$sDb = $this->_sourceDb;
		$prefix = $this->_prefix;
		$model = $this->_importModel;

		if ($options['max'] === false)
		{
			$data = $sDb->fetchRow('
				SELECT MAX(userid) AS max, COUNT(userid) AS rows
				FROM ' . $prefix . 'customavatar
			');

			$options = array_merge($options,$data);
		}

		$avatars = $sDb->fetchAll($sDb->limit('
				SELECT customavatar.userid, user.avatarrevision
				FROM ' . $prefix . 'customavatar AS customavatar
				INNER JOIN ' . $prefix . 'user AS user USING (userid)
				WHERE customavatar.userid > ' . $sDb->quote($start) . '
				ORDER BY customavatar.userid
			', $options['limit']
		));
		if (!$avatars)
		{
			return true;
		}

		$userIdMap = $model->getUserIdsMapFromArray($avatars, 'userid');

		$next = 0;
		$total = 0;

		foreach ($avatars AS $avatar)
		{
			$next = $avatar['userid'];

			$newUserId = $this->_mapLookUp($userIdMap, $avatar['userid']);
			if (!$newUserId)
			{
				continue;
			}

			if (!$options['path'])
			{
				$fData = $sDb->fetchOne('
					SELECT filedata
					FROM ' . $prefix . 'customavatar
					WHERE userid = ' . $sDb->quote($avatar['userid'])
				);

				if ($fData === '')
				{
					continue;
				}

				$avatarFile = tempnam(XenForo_Helper_File::getTempDir(), 'xf');
				if (!$avatarFile || !@file_put_contents($avatarFile, $fData))
				{
					continue;
				}

				$isTemp = true;
			}
			else
			{
				$avatarFileOrig = "$options[path]/avatar$avatar[userid]_$avatar[avatarrevision].gif";
				if (!file_exists($avatarFileOrig))
				{
					continue;
				}

				$avatarFile = tempnam(XenForo_Helper_File::getTempDir(), 'xf');
				copy($avatarFileOrig, $avatarFile);

				$isTemp = true;
			}

			if ($this->_importModel->importAvatar($avatar['userid'], $newUserId, $avatarFile))
			{
				$total++;
			}

			if ($isTemp)
			{
				@unlink($avatarFile);
			}
		}

		$options['processed'] += $total; 
		$this->_session->incrementStepImportTotal($total);

		return array($next, $options, $this->_getProgressOutput($options['processed'], $options['rows']));
	}

	public function stepPrivateMessages($start, array $options)
	{
		$options = array_merge(array(
			'limit' => 300,
			'processed' => 0,
			'max' => false
		), $options);

		$sDb = $this->_sourceDb;
		$prefix = $this->_prefix;
		$model = $this->_importModel;

		if ($options['max'] === false)
		{
			$data = $sDb->fetchRow('
				SELECT MAX(pmtextid) AS max, COUNT(pmtextid) AS rows
				FROM ' . $prefix . 'pmtext
			');

			$options = array_merge($options,$data);
		}

		$pmTexts = $sDb->fetchAll($sDb->limit('
				SELECT *
				FROM ' . $prefix . 'pmtext
				WHERE pmtextid > ' . $sDb->quote($start) . '
				ORDER BY pmtextid
			', $options['limit']
		));
		if (!$pmTexts)
		{
			return true;
		}

		$next = 0;
		$total = 0;

		XenForo_Db::beginTransaction();

		foreach ($pmTexts AS $pmText)
		{
			$next = $pmText['pmtextid'];
			$readState = $sDb->fetchPairs('
				SELECT userid, IF(folderid >= 0, messageread, 1)
				FROM ' . $prefix . 'pm
				WHERE pmtextid = ' . $sDb->quote($pmText['pmtextid'])
			);

			try
			{
				$toUser = unserialize($pmText['touserarray']);
			}
			catch (Exception $e)
			{
				// this is either corrupted data or an invalid char set. The latter isn't something we can automatically detect
				continue;
			}

			if (!is_array($toUser))
			{
				continue;
			}

			$users = array(
				$pmText['fromuserid'] => $pmText['fromusername']
			);

			foreach ($toUser AS $key => $toUser)
			{
				if (is_array($toUser))
				{
					foreach ($toUser AS $subKey => $username)
					{
						$users[$subKey] = $username;
					}
				}
				else
				{
					$users[$key] = $toUser;
				}
			}

			$mapUserIds = $model->getImportContentMap('user', array_keys($users));

			$newFromUserId = $this->_mapLookUp($mapUserIds, $pmText['fromuserid']);
			if (!$newFromUserId)
			{
				continue;
			}

			$fromUserName = $this->_convertToUtf8($pmText['fromusername'], true);
			$fromUserName = $this->mbTrim($fromUserName,50,$pmText['fromuserid']);

			$recipients = array();
			foreach ($users AS $userId => $username)
			{
				$newUserId = $this->_mapLookUp($mapUserIds, $userId);
				if (!$newUserId)
				{
					continue;
				}

				if (isset($readState[$userId]))
				{
					$lastReadDate = ($readState[$userId] ? $pmText['dateline'] : 0);
					$deleted = false;
				}
				else
				{
					$lastReadDate = $pmText['dateline'];
					$deleted = true;
				}

				$recipients[$newUserId] = array(
					'username' => $this->_convertToUtf8($username, true),
					'last_read_date' => $lastReadDate,
					'recipient_state' => ($deleted ? 'deleted' : 'active')
				);

				$recipients[$newUserId]['username'] = $this->mbTrim($recipients[$newUserId]['username'],50,$userId);
			}

			$conversation = array(
				'title' => $this->_convertToUtf8($pmText['title'], true),
				'user_id' => $newFromUserId,
				'username' => $fromUserName,
				'start_date' => $pmText['dateline'],
				'open_invite' => 0,
				'conversation_open' => 1
			);

			$messages = array(
				array(
					'message_date' => $pmText['dateline'],
					'user_id' => $newFromUserId,
					'username' => $fromUserName,
					'message' => $this->_convertToUtf8($pmText['message'])
				)
			);

			if ($model->importConversation($pmText['pmtextid'], $conversation, $recipients, $messages))
			{
				$total++;
			}
		}

		XenForo_Db::commit();

		$options['processed'] += $total; 
		$this->_session->incrementStepImportTotal($total);

		return array($next, $options, $this->_getProgressOutput($options['processed'], $options['rows']));
	}

	public function stepVisitorMessages($start, array $options)
	{
		$options = array_merge(array(
			'limit' => 200,
			'processed' => 0,
			'max' => false
		), $options);

		$sDb = $this->_sourceDb;
		$prefix = $this->_prefix;
		$model = $this->_importModel;

		if ($options['max'] === false)
		{
			$data = $sDb->fetchRow('
				SELECT MAX(vmid) AS max, COUNT(vmid) AS rows
				FROM ' . $prefix . 'visitormessage
			');

			$options = array_merge($options,$data);
		}

		$vms = $sDb->fetchAll($sDb->limit('
				SELECT vm.*,
				IF(user.username IS NULL, vm.postusername, user.username) AS username
				FROM ' . $prefix . 'visitormessage AS vm
				LEFT JOIN ' . $prefix . 'user AS user ON (vm.postuserid = user.userid)
				WHERE vm.vmid > ' . $sDb->quote($start) . '
				ORDER BY vm.vmid
			', $options['limit']
		));
		if (!$vms)
		{
			return true;
		}

		$next = 0;
		$total = 0;

		$userIds = array();
		foreach ($vms AS $vm)
		{
			$userIds[] = $vm['userid'];
			$userIds[] = $vm['postuserid'];
		}
		$userIdMap = $model->getImportContentMap('user', $userIds);

		XenForo_Db::beginTransaction();

		$formatter = XenForo_BbCode_Formatter_Base::create('XenForo_BbCode_Formatter_Text');
		$parser = new XenForo_BbCode_Parser($formatter);

		foreach ($vms AS $vm)
		{
			if (trim($vm['postusername']) === '')
			{
				continue;
			}

			$next = $vm['vmid'];

			$profileUserId = $this->_mapLookUp($userIdMap, $vm['userid']);
			if (!$profileUserId)
			{
				continue;
			}

			$postUserId = $this->_mapLookUp($userIdMap, $vm['postuserid'], 0);

			$import = array(
				'profile_user_id' => $profileUserId,
				'user_id' => $postUserId,
				'username' => $this->_convertToUtf8($vm['postusername'], true),
				'post_date' => $vm['dateline'],
				'message' => $parser->render($this->_convertToUtf8($vm['pagetext'])),
				'ip' => $vm['ipaddress']
			);

			$import['username'] = $this->mbTrim($import['username'],50,$import['user_id']);

			switch ($vm['state'])
			{
				case 'deleted': $import['message_state'] = 'deleted'; break;
				case 'moderation': $import['message_state'] = 'moderated'; break;
				default: $import['message_state'] = 'visible';
			}

			if ($model->importProfilePost($vm['vmid'], $import))
			{
				$total++;
			}
		}

		XenForo_Db::commit();

		$options['processed'] += $total; 
		$this->_session->incrementStepImportTotal($total);

		return array($next, $options, $this->_getProgressOutput($options['processed'], $options['rows']));
	}

	public function stepForums($start, array $options)
	{
		$sDb = $this->_sourceDb;
		$prefix = $this->_prefix;
		$model = $this->_importModel;

		if ($start > 0)
		{
			// Rebuild the full permission cache so forums appear
			XenForo_Model::create('XenForo_Model_Node')->updateNestedSetInfo();
			XenForo_Model::create('XenForo_Model_Permission')->rebuildPermissionCache();
			return true;
		}

		// Get cms comments forum
		$cmsid = $sDb->fetchOne('
			SELECT value
			FROM ' . $prefix . 'setting
			WHERE varname = \'vbcmsforumid\'
		');

		$options['cmsid'] = intval($cmsid);

		// Exclude CMS comments forum
		// All forums are done in one go
		$forums = $sDb->fetchAll('
			SELECT *
			FROM ' . $prefix . 'forum
			WHERE forumid <> '.$sDb->quote($options['cmsid'])
		);
				
		if (!$forums)
		{
			return true;
		}

		$forumTree = array();
		foreach ($forums AS $forum)
		{
			$forumTree[$forum['parentid']][$forum['forumid']] = $forum;
		}

		$forumPermissions = array();
		$forumPermissionSql = $sDb->query('
			SELECT *
			FROM ' . $prefix . 'forumpermission
		');
		while ($forumPermission = $forumPermissionSql->fetch())
		{
			$forumPermissions[$forumPermission['forumid']][$forumPermission['usergroupid']] = $forumPermission['forumpermissions'];
		}

		XenForo_Db::beginTransaction();

		$total = $this->_importForumTree(-1, $forumTree, $forumPermissions);

		XenForo_Db::commit();

		$this->_session->incrementStepImportTotal($total);

		return array(1, array(), '');
	}

	protected function _importForumTree($parentId, array $forumTree, array $forumPermissions, array $forumIdMap = array())
	{
		if (!isset($forumTree[$parentId]))
		{
			return 0;
		}

		XenForo_Db::beginTransaction();

		$total = 0;

		foreach ($forumTree[$parentId] AS $forum)
		{
			$forum['options'] = intval($forum['options']);

			$import = array(
				'title' => $this->_convertToUtf8($forum['title'], true),
				'description' => $this->_convertToUtf8($forum['description'], true),
				'display_order' => $forum['displayorder'],
				'parent_node_id' => $this->_mapLookUp($forumIdMap, $forum['parentid'], 0),
				'display_in_list' => (($forum['options'] & 1) && $forum['displayorder'] > 0) // active
			);

			if ($forum['link'])
			{
				$import['node_type_id'] = 'LinkForum';
				$import['link_url'] = $forum['link'];

				$nodeId = $this->_importModel->importLinkForum($forum['forumid'], $import);
			}
			else if ($forum['options'] & 4) // cancontainthreads
			{
				$import['node_type_id'] = 'Forum';
				$import['discussion_count'] = $forum['threadcount'];
				$import['message_count'] = $forum['replycount'] + $forum['threadcount'];
				$import['last_post_date'] = $forum['lastpost'];
				$import['last_post_username'] = $this->_convertToUtf8($forum['lastposter'], true);
				$import['last_thread_title'] = $this->_convertToUtf8($forum['lastthread'], true);

				$nodeId = $this->_importModel->importForum($forum['forumid'], $import);
			}
			else
			{
				$import['node_type_id'] = 'Category';

				$nodeId = $this->_importModel->importCategory($forum['forumid'], $import);
			}

			if ($nodeId)
			{
				if (!empty($forumPermissions[$forum['forumid']]))
				{
					$this->_importForumPermissions($nodeId, $forumPermissions[$forum['forumid']]);
				}

				$forumIdMap[$forum['forumid']] = $nodeId;

				$total++;
				$total += $this->_importForumTree($forum['forumid'], $forumTree, $forumPermissions, $forumIdMap);
			}
		}

		XenForo_Db::commit();

		return $total;
	}

	protected function _importForumPermissions($nodeId, array $groupPerms)
	{
		if ($this->_groupMap === null)
		{
			$this->_groupMap = $this->_importModel->getImportContentMap('userGroup');
		}

		XenForo_Db::beginTransaction();

		foreach ($groupPerms AS $oldGroupId => $perms)
		{
			if ($oldGroupId == 3 || $oldGroupId == 4)
			{
				continue; // skip these. they'll be treated as guests
			}

			$newGroupId = $this->_mapLookUp($this->_groupMap, $oldGroupId);
			if (!$newGroupId)
			{
				continue;
			}

			$newPerms = $this->_calculateForumPermissions($perms);
			if ($newPerms)
			{
				$this->_importModel->insertNodePermissionEntries($nodeId, $newGroupId, 0, $newPerms);
			}
		}

		XenForo_Db::commit();
	}

	protected $_nodePermissionsGrouped = null;

	protected function _calculateForumPermissions($perms)
	{
		$output = array();

		if ($this->_nodePermissionsGrouped === null)
		{
			$this->_nodePermissionsGrouped = $this->_importModel->getNodePermissionsGrouped();
		}

		$perms = intval($perms);

		if ($perms & 1)
		{
			// viewable
			$output['general']['viewNode'] = 'content_allow';

			$output['forum']['postThread'] = ($perms & 16 ? 'content_allow' : 'reset');
			$output['forum']['postReply'] = ($perms & 32 ? 'content_allow' : 'reset');
			$output['forum']['editOwnPost'] = ($perms & 128 ? 'content_allow' : 'reset');
			$output['forum']['deleteOwnPost'] = ($perms & 256 ? 'content_allow' : 'reset');
			$output['forum']['deleteOwnThread'] = ($perms & 512 ? 'content_allow' : 'reset');
			$output['forum']['viewAttachment'] = ($perms & 4096 ? 'content_allow' : 'reset');
			$output['forum']['uploadAttachment'] = ($perms & 8192 ? 'content_allow' : 'reset');
			$output['forum']['votePoll'] = ($perms & 32768 ? 'content_allow' : 'reset');
		}
		else
		{
			// not viewable, reset all permissions
			$output['general']['viewNode'] = 'reset';

			foreach ($this->_nodePermissionsGrouped AS $groupId => $permissions)
			{
				foreach ($permissions AS $permissionId => $perm)
				{
					if ($perm['permission_type'] == 'flag')
					{
						$output[$groupId][$permissionId] = 'reset';
					}
				}
			}
		}

		return $output;
	}

	public function stepModerators($start, array $options)
	{
		$sDb = $this->_sourceDb;
		$prefix = $this->_prefix;
		$model = $this->_importModel;

		// All moderators are done in one go
		$moderators = $sDb->fetchAll('
			SELECT moderator.*,
			IF(usergroup.adminpermissions & 1, 1, 0) AS is_super_moderator
			FROM ' . $prefix . 'moderator AS moderator
			INNER JOIN ' . $prefix . 'user AS user USING (userid)
			LEFT JOIN ' . $prefix . 'usergroup AS usergroup USING (usergroupid)
		');

		if (!$moderators)
		{
			return true;
		}

		$modGrouped = array();
		foreach ($moderators AS $moderator)
		{
			$modGrouped[$moderator['userid']][$moderator['forumid']] = $moderator;
		}

		$superMods = $this->_session->getExtraData('superMods');
		if ($superMods)
		{
			foreach ($superMods AS $oldUserId => $newUserId)
			{
				if (!isset($modGrouped[$oldUserId]))
				{
					$modGrouped[$oldUserId][-1] = array(
						'userid' => $oldUserId,
						'is_super_moderator' => true,
						'forumid' => -1,
						'permissions' => -1, // bitwise, all 1s
						'permissions2' => -1 // bitwise, all 1s
					);
				}
			}
		}

		$nodeMap = $model->getImportContentMap('node');
		$userIdMap = $model->getImportContentMap('user', array_keys($modGrouped));

		$total = 0;

		XenForo_Db::beginTransaction();

		foreach ($modGrouped AS $userId => $forums)
		{
			$newUserId = $this->_mapLookUp($userIdMap, $userId);
			if (!$newUserId)
			{
				continue;
			}

			$globalModPermissions = array();
			$inserted = false;

			if (!empty($forums[-1]['is_super_moderator']))
			{
				$perms = $this->_calculateModeratorPermissions($forums[-1]['permissions'], $forums[-1]['permissions2']);
				$globalModPermissions += $perms['global'] + $perms['forum'];

				$isSuperMod = true;

				$total++;
				$inserted = true;
			}
			else
			{
				$isSuperMod = false;
			}

			unset($forums[-1]);

			foreach ($forums AS $forumId => $moderator)
			{
				$newNodeId = $this->_mapLookUp($nodeMap, $forumId);
				if (!$newNodeId)
				{
					continue;
				}

				$perms = $this->_calculateModeratorPermissions($moderator['permissions'], $moderator['permissions2']);
				$globalModPermissions += $perms['global'];

				$mod = array(
					'content_id' => $newNodeId,
					'user_id' => $newUserId,
					'moderator_permissions' => $perms['forum']
				);
				$model->importNodeModerator($forumId, $userId, $mod);

				$total++;
				$inserted = true;
			}

			if ($inserted)
			{
				$mod = array(
					'user_id' => $newUserId,
					'is_super_moderator' => $isSuperMod,
					'moderator_permissions' => $globalModPermissions
				);
				$model->importGlobalModerator($userId, $mod);
			}
		}

		$this->_session->incrementStepImportTotal($total);

		XenForo_Db::commit();

		return true;
	}

	protected function _calculateModeratorPermissions($perms1, $perms2)
	{
		$global = array();
		$forum = array();

		$perms1 = intval($perms1);
		$perms2 = intval($perms2);

		if ($perms2 & 1)
		{
			$global['profilePost']['editAny'] = true;
		}
		if ($perms2 & 2)
		{
			$global['profilePost']['deleteAny'] = true;
			$global['profilePost']['undelete'] = true;

			if ($perms2 & 4)
			{
				$global['profilePost']['hardDeleteAny'] = true;
			}
		}
		if ($perms2 & 8)
		{
			$global['profilePost']['approveUnapprove'] = true;
			$global['profilePost']['viewDeleted'] = true;
			$global['profilePost']['viewModerated'] = true;
		}

		if ($perms1 & 1)
		{
			$forum['forum']['editAnyPost'] = true;
		}
		if ($perms1 & 2)
		{
			$forum['forum']['deleteAnyPost'] = true;
			$forum['forum']['deleteAnyThread'] = true;
			$forum['forum']['undelete'] = true;

			if ($perms1 & 131072)
			{
				$forum['forum']['hardDeleteAnyPost'] = true;
				$forum['forum']['hardDeleteAnyThread'] = true;
			}

			// these don't really fit. give them to mods that can delete stuff
			$forum['general']['viewIps'] = true;
			$forum['general']['cleanSpam'] = true;
			$forum['general']['bypassUserPrivacy'] = true;
		}
		if ($perms1 & 4)
		{
			$forum['forum']['lockUnlockThread'] = true;
		}
		if ($perms1 & 16)
		{
			$forum['forum']['manageAnyThread'] = true;
			$forum['forum']['stickUnstickThread'] = true;
		}
		if ($perms1 & 64)
		{
			$forum['forum']['approveUnapprove'] = true;
			$forum['forum']['viewModerated'] = true;
		}

		$forum['forum']['viewDeleted'] = true; // this was given automatically to mods

		return array(
			'global' => $global,
			'forum' => $forum
		);
	}

	public function stepThreads($start, array $options)
	{
		$options = array_merge(array(
			'limit' => 100,
			'postDateStart' => 0,
			'postLimit' => 800,
			'processed' => 0,
			'max' => false
		), $options);

		$sDb = $this->_sourceDb;
		$prefix = $this->_prefix;
		$model = $this->_importModel;

		if ($options['max'] === false)
		{
			// Get CMS comments forum
			$cmsid = $sDb->fetchOne('
				SELECT value
				FROM ' . $prefix . 'setting
				WHERE varname = \'vbcmsforumid\'
			');

			$options['cmsid'] = intval($cmsid);

			$data = $sDb->fetchRow('
				SELECT MAX(threadid) AS max, COUNT(threadid) AS rows
				FROM ' . $prefix . 'thread
				WHERE open <> 10 
				AND forumid <> ' . $sDb->quote($options['cmsid'])
			);

			$options = array_merge($options,$data);

		}

		// pull threads from things we actually imported as forums // Exclude CMS comments forum
		$threads = $sDb->fetchAll($sDb->limit('
				SELECT thread.*,
					IF(user.username IS NULL, thread.postusername, user.username) AS postusername
				FROM ' . $prefix . 'thread AS thread
				LEFT JOIN ' . $prefix . 'user AS user ON (thread.postuserid = user.userid)
				INNER JOIN ' . $prefix . 'forum AS forum ON
					(thread.forumid = forum.forumid AND forum.link = \'\' AND forum.options & 4)
				WHERE thread.threadid >= ' . $sDb->quote($start) . '
					AND thread.open <> 10 AND forum.forumid <> ' . $sDb->quote($options['cmsid']) . '
				ORDER BY thread.threadid
			', $options['limit']
		));
		
		if (!$threads)
		{
			return true;
		}

		$next = 0;
		$total = 0;
		$totalPosts = 0;

		$nodeMap = $model->getImportContentMap('node');

		XenForo_Db::beginTransaction();

		foreach ($threads AS $thread)
		{
			if (trim($thread['title']) === '')
			{
				continue;
			}

			$postDateStart = $options['postDateStart'];

			$next = $thread['threadid'] + 1; // uses >=, will be moved back down if need to continue
			$options['postDateStart'] = 0;

			$maxPosts = $options['postLimit'] - $totalPosts;
			$posts = $sDb->fetchAll($sDb->limit(
				'
					SELECT post.*,
						IF(user.username IS NULL, post.username, user.username) AS username
					FROM ' . $prefix . 'post AS post
					LEFT JOIN ' . $prefix . 'user AS user USING (userid)
					WHERE post.threadid = ' . $sDb->quote($thread['threadid']) . '
						AND post.dateline > ' . $sDb->quote($postDateStart) . '
					ORDER BY post.dateline
				', $maxPosts
			));

			if (!$posts)
			{
				if ($postDateStart)
				{
					// continuing thread but it has no more posts
					$total++;
				}
				continue;
			}

			if ($postDateStart)
			{
				// continuing thread we already imported
				$threadId = $model->mapThreadId($thread['threadid']);

				$position = $this->_db->fetchOne('
					SELECT MAX(position)
					FROM xf_post
					WHERE thread_id = ?
				', $threadId);
			}
			else
			{
				$forumId = $this->_mapLookUp($nodeMap, $thread['forumid']);
				if (!$forumId)
				{
					continue;
				}

				if (trim($thread['postusername']) === '')
				{
					$thread['postusername'] = 'Guest';
				}

				$import = array(
					'title' => $this->_convertToUtf8($thread['title'], true),
					'node_id' => $forumId,
					'user_id' => $model->mapUserId($thread['postuserid'], 0),
					'username' => $this->_convertToUtf8($thread['postusername'], true),
					'discussion_open' => $thread['open'],
					'post_date' => $thread['dateline'],
					'reply_count' => $thread['replycount'],
					'view_count' => $thread['views'],
					'sticky' => $thread['sticky'],
					'last_post_date' => $thread['lastpost'],
					'last_post_username' => $this->_convertToUtf8($thread['lastposter'], true)
				);

				$import['username'] = $this->mbTrim($import['username'],50,$import['user_id']);

				switch ($thread['visible'])
				{
					case 0: $import['discussion_state'] = 'moderated'; break;
					case 2: $import['discussion_state'] = 'deleted'; break;
					default: $import['discussion_state'] = 'visible';
				}

				$threadId = $model->importThread($thread['threadid'], $import);
				if (!$threadId)
				{
					continue;
				}

				$position = -1;

				$subs = $sDb->fetchPairs('
					SELECT userid, emailupdate
					FROM ' . $prefix . 'subscribethread
					WHERE threadid = ' . $sDb->quote($thread['threadid'])
				);
				if ($subs)
				{
					$userIdMap = $model->getImportContentMap('user', array_keys($subs));
					foreach ($subs AS $userId => $emailUpdate)
					{
						$newUserId = $this->_mapLookUp($userIdMap, $userId);
						if (!$newUserId)
						{
							continue;
						}

						$model->importThreadWatch($newUserId, $threadId, ($emailUpdate ? 1 : 0));
					}
				}
			}

			if ($threadId)
			{
				$threadTitleRegex = '#^(re:\s*)?' . preg_quote($thread['title'], '#') . '$#i';

				$userIdMap = $model->getUserIdsMapFromArray($posts, 'userid');

				foreach ($posts AS $post)
				{
					if (strtoupper(utf8_substr($post['title'],0,3)) == 'RE:')
					{
						$post['title'] = ltrim(utf8_substr($post['title'],3));
					}

					if ($post['title'] !== '' && $thread['title'] != $post['title'] && !preg_match($threadTitleRegex, $post['title']))
					{
						$post['pagetext'] = '[b]' . htmlspecialchars_decode($post['title']) . "[/b]\n\n" . ltrim($post['pagetext']);
					}

					if (trim($post['username']) === '')
					{
						$post['username'] = 'Guest';
					}

					$post['pagetext'] = $this->_convertVideo($post['pagetext']);

					// Remap Quotes (Krochinzky)
					if (preg_match_all('/\[QUOTE=.+;(\d+)"?\]/i', $post['pagetext'], $matches))
					{
						$postIdMap = $model->getImportContentMap('post', $matches[1]);
						foreach($matches[1] as $key => $oldPostId)
						{
							$newPostId = $this->_mapLookUp($postIdMap, $oldPostId);
							$post['pagetext'] =  preg_replace('/\[QUOTE=(.+);(' . $oldPostId . ')\]/i', '[QUOTE="$1, post: ' . $newPostId . '"]', $post['pagetext']);
						}
					}

					$import = array(
						'thread_id' => $threadId,
						'user_id' => $this->_mapLookUp($userIdMap, $post['userid'], 0),
						'username' => $this->_convertToUtf8($post['username'], true),
						'post_date' => $post['dateline'],
						'message' => $this->_convertToUtf8($post['pagetext']),
						'attach_count' => $post['attach'],
						'ip' => $post['ipaddress']
					);

					$import['username'] = $this->mbTrim($import['username'],50,$import['user_id']);

					switch ($post['visible'])
					{
						case 0: $import['message_state'] = 'moderated'; $import['position'] = $position; break;
						case 2: $import['message_state'] = 'deleted'; $import['position'] = $position; break;
						default: $import['message_state'] = 'visible'; $import['position'] = ++$position; 
					}

					$model->importPost($post['postid'], $import);

					$options['postDateStart'] = $post['dateline'];
					$totalPosts++;
				}
			}

			if (count($posts) < $maxPosts)
			{
				// done this thread
				$total++;
				$options['postDateStart'] = 0;
			}
			else
			{
				// not necessarily done the thread; need to pick it up next page
				break;
			}
		}

		if ($options['postDateStart'])
		{
			// not done this thread, need to continue with it
			$next--;
		}

		XenForo_Db::commit();

		$options['processed'] += $total; 
		$this->_session->incrementStepImportTotal($total);

		return array($next, $options, $this->_getProgressOutput($options['processed'], $options['rows']));
	}

	public function stepPolls($start, array $options)
	{
		$options = array_merge(array(
			'limit' => 100,
			'processed' => 0,
			'max' => false
		), $options);

		$sDb = $this->_sourceDb;
		$prefix = $this->_prefix;
		$model = $this->_importModel;

		// Dont bother to exclude cms comments forum
		// as I dont believe they can ever have polls ..
		if ($options['max'] === false)
		{
			$data = $sDb->fetchRow('
				SELECT MAX(pollid) AS max, COUNT(pollid) AS rows
				FROM ' . $prefix . 'poll
			');

			$options = array_merge($options,$data);
		}

		$polls = $sDb->fetchAll($sDb->limit(
			'
				SELECT poll.*, thread.threadid
				FROM ' . $prefix . 'poll AS poll
				INNER JOIN ' . $prefix . 'thread AS thread USING (pollid)
				WHERE poll.pollid > ' . $sDb->quote($start) . '
				ORDER BY poll.pollid
			', $options['limit']
		));
		if (!$polls)
		{
			return true;
		}

		$next = 0;
		$total = 0;

		$threadIdMap = $model->getThreadIdsMapFromArray($polls, 'threadid');

		XenForo_Db::beginTransaction();

		foreach ($polls AS $poll)
		{
			$next = $poll['pollid'];

			$newThreadId = $this->_mapLookUp($threadIdMap, $poll['threadid']);
			if (!$newThreadId)
			{
				continue;
			}

			$import = array(
				'question' => $this->_convertToUtf8($poll['question']),
				'public_votes' => $poll['public'],
				'multiple' => $poll['multiple'],
				'close_date' => ($poll['timeout'] ? $poll['dateline'] + 86400 * $poll['timeout'] : 0)
			);
			$responses = explode('|||', $this->_convertToUtf8($poll['options']));

			$newPollId = $model->importThreadPoll($poll['pollid'], $newThreadId, $import, $responses, $responseIds);
			if ($newPollId)
			{
				$votes = $sDb->fetchAll('
					SELECT userid, votedate, voteoption
					FROM ' . $prefix . 'pollvote
					WHERE pollid = ' . $sDb->quote($poll['pollid'])
				);

				$userIdMap = $model->getUserIdsMapFromArray($votes, 'userid');
				foreach ($votes AS $vote)
				{
					$userId = $this->_mapLookUp($userIdMap, $vote['userid']);
					if (!$userId)
					{
						continue;
					}

					$voteOption = max(0, $vote['voteoption'] - 1);

					if (!isset($responseIds[$voteOption]))
					{
						continue;
					}

					$model->importPollVote($newPollId, $userId, $responseIds[$voteOption], $vote['votedate']);
				}
			}

			$total++;
		}

		XenForo_Db::commit();

		$options['processed'] += $total; 
		$this->_session->incrementStepImportTotal($total);

		return array($next, $options, $this->_getProgressOutput($options['processed'], $options['rows']));
	}

	public function stepAttachments($start, array $options)
	{
		$options = array_merge(array(
			'path' => isset($this->_config['attachmentPath']) ? trim($this->_config['attachmentPath']) : '',
			'limit' => 50,
			'processed' => 0,
			'max' => false
		), $options);

		$sDb = $this->_sourceDb;
		$prefix = $this->_prefix;
		$model = $this->_importModel;

		if ($options['max'] === false)
		{
			$content = $sDb->fetchAll('
				SELECT contenttypeid, class
				FROM ' . $prefix . 'contenttype
				WHERE class IN (\'Post\',\'BlogEntry\',\'Article\')
			');

			$temp = Array('0');

			foreach ($content AS $type)
			{
				$temp[] = $type['contenttypeid'];
				$options['attach'.$type['class']] = $type['contenttypeid'];
			}

			$options['allTypes'] = implode(',',$temp);

			$data = $sDb->fetchRow('
				SELECT MAX(attachmentid) AS max, COUNT(attachmentid) AS rows
				FROM ' . $prefix . 'attachment
				WHERE state = \'visible\'
				AND contenttypeid IN ('.$options['allTypes'].')
			');

			$options = array_merge($options,$data);
		}

		$attachments = $sDb->fetchAll($sDb->limit('
				SELECT attachmentid, attachment.userid, attachment.dateline, filedataid, 
				filename, counter, contentid as postid, filedata.userid as fileuserid, contenttypeid as typeid
				FROM ' . $prefix . 'attachment AS attachment
				INNER JOIN ' . $prefix . 'filedata AS filedata USING (filedataid)
				WHERE attachmentid > ' . $sDb->quote($start) . '
					AND state = \'visible\'
					AND contenttypeid IN ('.$options['allTypes'].')
				ORDER BY attachmentid
			', $options['limit']
		));

		if (!$attachments)
		{
			return true;
		}

		$next = 0;
		$total = 0;

		$cmsIdMap = $this->getCmsIdsMapFromArray($attachments, 'postid');
		$blogIdMap = $this->getBlogIdsMapFromArray($attachments, 'postid');
		$postIdMap = $model->getPostIdsMapFromArray($attachments, 'postid');

		$allPostids = array_unique(array_merge($postIdMap,$blogIdMap,$cmsIdMap)); // Keys are reset !
		$posts = $model->getModelFromCache('XenForo_Model_Post')->getPostsByIds($allPostids);

		$userIdMap = $model->getUserIdsMapFromArray($attachments, 'userid');

		foreach ($attachments AS $attachment)
		{
			$next = $attachment['attachmentid'];

			$attachment['userid'] = $this->_mapLookUp($userIdMap, $attachment['userid'],0);

			if ($attachment['typeid'] == $options['attachPost'])
			{ 
				$attachment['postid'] = $this->_mapLookUp($postIdMap, $attachment['postid'],0);
			}

			if (isset($options['attachArticle']) AND $attachment['typeid'] == $options['attachArticle'])
			{ 
				$attachment['postid'] = $this->_mapLookUp($cmsIdMap, $attachment['postid'],0);
			}

			if (isset($options['attachBlogEntry']) AND $attachment['typeid'] == $options['attachBlogEntry'])
			{ 
				$attachment['postid'] = $this->_mapLookUp($blogIdMap, $attachment['postid'],0);
			}

			if (!$attachment['postid'])
			{
				continue;
			}
			else
			{
				$attachment['message'] = &$posts[$attachment['postid']]['message'];
			}

			$success = $this->_makeAttachment($options, $attachment);

			if ($success)
			{
				$total++;
			}
		}

		$options['processed'] += $total; 
		$this->_session->incrementStepImportTotal($total);

		return array($next, $options, $this->_getProgressOutput($options['processed'], $options['rows']));
	}

	public function stepAlbums($start, array $options)
	{
		$options = array_merge(array(
			'path' => isset($this->_config['attachmentPath']) ? trim($this->_config['attachmentPath']) : '',
			'limit' => 50,
			'alimit' => 4, // images per post
			'processed' => 0,
			'max' => false
		), $options);

		$sDb = $this->_sourceDb;
		$prefix = $this->_prefix;
		$model = $this->_importModel;

		if ($options['max'] === false)
		{
			$content = $sDb->fetchOne('
				SELECT contenttypeid
				FROM ' . $prefix . 'contenttype
				WHERE class = \'Album\'
			');

			$options['albumType'] = intval($content);

			$data = $sDb->fetchRow('
				SELECT MAX(attachmentid) AS max, COUNT(attachmentid) AS rows
				FROM ' . $prefix . 'attachment
				WHERE state = \'visible\'
				AND contenttypeid = ' . $sDb->quote($options['albumType'])
			);

			$options = array_merge($options,$data);
			
			if ($options['max'])
			{
				// Get board name
				$board = $sDb->fetchOne('
					SELECT value
					FROM ' . $prefix . 'setting
					WHERE varname = \'bbtitle\'
				');

				XenForo_Db::beginTransaction();
				$options['forumid'] = $this->buildImportForum($this->_convertToUtf8('Albums ('.$board.')', true), 940);
				XenForo_Db::commit();
			}

			return array(0, $options, "Processing Albums ...");
		}

		$attachments = $sDb->fetchAll($sDb->limit('
				SELECT attachmentid, album.userid, attachment.dateline, title, username,
				filedataid, filename, counter, albumid, filedata.userid as fileuserid, album.state
				FROM ' . $prefix . 'attachment AS attachment
				INNER JOIN ' . $prefix . 'filedata AS filedata USING (filedataid)
				INNER JOIN ' . $prefix . 'album AS album ON (album.albumid = attachment.contentid)
				INNER JOIN ' . $prefix . 'user AS user ON (album.userid = user.userid)
				WHERE albumid > ' . $sDb->quote($start) . '
				AND attachment.state = \'visible\'
				AND contenttypeid = ' . $sDb->quote($options['albumType']) . '
				ORDER BY albumid, attachmentid
			', $options['limit']
		));

		if (!$attachments)
		{
			// Rebuild the permission cache
			XenForo_Model::create('XenForo_Model_Node')->updateNestedSetInfo();
			XenForo_Model::create('XenForo_Model_Permission')->rebuildPermissionCache();
			return true;
		}

		$next = 0;
		$last = 0;
		$total = 0;
		$position = 0;
		$userIdMap = $model->getUserIdsMapFromArray($attachments, 'userid');

		foreach ($attachments AS $attachment)
		{
			$next = $attachment['albumid'];

			if ($last <> $next)
			{
				$last = $next;
				$userid = $model->mapUserId($attachment['userid'], 0);
				$username = $this->_convertToUtf8($attachment['username'], true);
				$username = $this->mbTrim($username,50,$userid);
				
				$import = array(
					'title' => $this->_convertToUtf8('Album : '.$attachment['title'], true),
					'node_id' => $options['forumid'],
					'user_id' => $userid,
					'username' => $username,
					'discussion_open' => 1,
					'post_date' => $attachment['dateline'],
					'reply_count' => 0,
					'view_count' => 0,
					'sticky' => 0,
					'discussion_state' => $attachment['state'] == 'public' ? 'visible' : 'moderated',
					'last_post_date' => $attachment['dateline'],
					'last_post_username' => $username
				);

				$threadid = $model->importThread(0, $import);

				$position = 0;
				$acount = $options['alimit'];
				$model->logImportData('album', $attachment['albumid'], $threadid);
			}

			if ($acount >= $options['alimit'])
			{
				if ($position != 0)
				{
					$this->_db->query('
						UPDATE xf_thread
						SET reply_count = reply_count + 1
						WHERE thread_id = ?
					', $threadid);
				}
				
				$acount = 0;
				$position++;

				$import = array(
					'thread_id' => $threadid,
					'user_id' => $userid,
					'username' => $username,
					'post_date' => $attachment['dateline']+$position,
					'message' => "Album Images $position \n\n",
					'attach_count' => 0,
					'ip' => '0.0.0.0',
					'position' => $position,
					'message_state' => 'visible'
				);

				$postid = $model->importPost(0, $import);
			}

			$attachment['userid'] = $userid;
			$attachment['postid'] = $postid;

			unset($attachment['message']);
			$success = $this->_makeAttachment($options, $attachment);

			if ($success)
			{
				$total++;
				$acount++;
			}
		}

		$options['processed'] += $total; 
		$this->_session->incrementStepImportTotal($total);

		return array($next, $options, $this->_getProgressOutput($options['processed'], $options['rows']));
	}

	public function stepSocial($start, array $options)
	{
		$options = array_merge(array(
			'max' => false,
			'limit' => 100,
			'processed' => 0,
			'postLimit' => 500,
			'postDateStart' => 0,
		), $options);

		$sDb = $this->_sourceDb;
		$prefix = $this->_prefix;
		$model = $this->_importModel;

		if ($options['max'] === false)
		{
			$data = $sDb->fetchRow('
				SELECT MAX(discussionid) AS max, COUNT(discussionid) AS rows
				FROM ' . $prefix . 'discussion
			');

			$options = array_merge($options,$data);
	
			if ($options['max'])
			{
				// Get board name
				$board = $sDb->fetchOne('
					SELECT value
					FROM ' . $prefix . 'setting
					WHERE varname = \'bbtitle\'
				');

				XenForo_Db::beginTransaction();
				$options['forumid'] = $this->buildImportForum($this->_convertToUtf8('Social Groups ('.$board.')', true), 910);
				XenForo_Db::commit();
			}

			return array(0, $options, "Processing Social Groups ...");
		}

		$threads = $sDb->fetchAll($sDb->limit('
				SELECT discussion.*, groupmessage.*, socialgroup.name
				FROM ' . $prefix . 'discussion AS discussion
				INNER JOIN ' . $prefix . 'socialgroup AS socialgroup USING (groupid)
				INNER JOIN ' . $prefix . 'groupmessage AS groupmessage 
				ON (discussion.firstpostid = groupmessage.gmid)
				WHERE discussion.discussionid >= ' . $sDb->quote($start) . '
				ORDER BY discussion.discussionid
			', $options['limit']
		));

		if (!$threads)
		{
			// Rebuild the permission cache
			XenForo_Model::create('XenForo_Model_Node')->updateNestedSetInfo();
			XenForo_Model::create('XenForo_Model_Permission')->rebuildPermissionCache();
			return true; // All done.
		}

		$next = 0;
		$total = 0;
		$totalPosts = 0;

		XenForo_Db::beginTransaction();

		foreach ($threads AS $thread)
		{
			if (trim($thread['postusername']) === '' || trim($thread['title']) === '')
			{
				continue;
			}

			$postDateStart = $options['postDateStart'];

			$options['postDateStart'] = 0;
			$next = $thread['discussionid'] + 1; 

			$maxPosts = $options['postLimit'] - $totalPosts;

			$posts = $sDb->fetchAll($sDb->limit('
					SELECT groupmessage.* 
					FROM ' . $prefix . 'groupmessage AS groupmessage
					INNER JOIN ' . $prefix . 'user AS user 
					ON (groupmessage.postuserid = user.userid)
					WHERE groupmessage.discussionid = ' . $sDb->quote($thread['discussionid']) . '
					AND groupmessage.dateline > ' . $sDb->quote($postDateStart) . '
					ORDER BY groupmessage.dateline
				', $maxPosts
			));

			if (!$posts)
			{
				if ($postDateStart)
				{
					$total++;
				}
				continue;
			}

			if ($postDateStart)
			{
				$threadId = $options['threadid'];
				$position = $this->_db->fetchOne('
					SELECT MAX(position)
					FROM xf_post
					WHERE thread_id = ?
				', $threadId);
			}
			else
			{
				if (!$options['forumid'])
				{
					continue;
				}

				$import = array(
					'title' => $this->_convertToUtf8($thread['name'], true).' : '.$this->_convertToUtf8($thread['title'], true),
					'node_id' => $options['forumid'],
					'user_id' => $model->mapUserId($thread['postuserid'], 0),
					'username' => $this->_convertToUtf8($thread['postusername'], true),
					'discussion_open' => 1,
					'post_date' => $thread['dateline'],
					'reply_count' => $thread['visible'] - 1,
					'view_count' => 1,
					'sticky' => 0,
					'last_post_date' => $thread['lastpost'],
					'last_post_username' => $this->_convertToUtf8($thread['lastposter'], true)
				);

				$import['username'] = $this->mbTrim($import['username'],50,$import['user_id']);

				switch ($thread['state'])
				{
					case 'moderation': $import['discussion_state'] = 'moderated'; break;
					default: $import['discussion_state'] = $thread['state'];
				}

				$threadId = $model->importThread(0, $import);

				$options['threadid'] = $threadId;
				$model->logImportData('discussion', $thread['discussionid'], $threadId);

				if (!$threadId)
				{
					continue;
				}

				$position = -1;
			}

			if ($threadId)
			{
				$userIdMap = $model->getUserIdsMapFromArray($posts, 'postuserid');

				foreach ($posts AS $post)
				{
					if (trim($post['postusername']) === '' || trim($post['pagetext']) === '')
					{
						continue;
					}

					$post['pagetext'] = $this->_convertVideo($post['pagetext']);

					$import = array(
						'thread_id' => $threadId,
						'user_id' => $this->_mapLookUp($userIdMap, $post['postuserid'], 0),
						'username' => $this->_convertToUtf8($post['postusername'], true),
						'post_date' => $post['dateline'],
						'message' => $this->_convertToUtf8($post['pagetext']),
						'attach_count' => 0,
						'ip' => $post['ipaddress']
					);

					$import['username'] = $this->mbTrim($import['username'],50,$import['user_id']);

					switch ($post['state'])
					{
						case 'deleted': $import['message_state'] = 'deleted'; $import['position'] = $position; break;
						case 'moderation': $import['message_state'] = 'moderated'; $import['position'] = $position; break;
						default: $import['message_state'] = 'visible'; $import['position'] = ++$position; 
					}

					$postid = $model->importPost(0, $import);
					$model->logImportData('message', $post['gmid'], $postid);

					$options['postDateStart'] = $post['dateline'];
					$totalPosts++;
				}
			}

			if (count($posts) < $maxPosts)
			{
				$total++;
				$options['postDateStart'] = 0;
			}
			else
			{
				break;
			}
		}

		XenForo_Db::commit();

		if ($options['postDateStart'])
		{
			$next--;
		}

		$options['processed'] += $total; 
		$this->_session->incrementStepImportTotal($total);

		return array($next, $options, $this->_getProgressOutput($options['processed'], $options['rows']));
	}

	public function stepSGImages($start, array $options)
	{
		$options = array_merge(array(
			'path' => isset($this->_config['attachmentPath']) ? trim($this->_config['attachmentPath']) : '',
			'limit' => 50,
			'alimit' => 4, // images per post
			'processed' => 0,
			'max' => false
		), $options);

		$sDb = $this->_sourceDb;
		$prefix = $this->_prefix;
		$model = $this->_importModel;

		if ($options['max'] === false)
		{
			$content = $sDb->fetchOne('
				SELECT contenttypeid
				FROM ' . $prefix . 'contenttype
				WHERE class = \'SocialGroup\'
			');

			$options['albumType'] = intval($content);

			$data = $sDb->fetchRow('
				SELECT MAX(attachmentid) AS max, COUNT(attachmentid) AS rows
				FROM ' . $prefix . 'attachment
				WHERE state = \'visible\'
				AND contenttypeid = ' . $sDb->quote($options['albumType'])
			);

			$options = array_merge($options,$data);
			
			if ($options['max'])
			{
				// Get board name
				$board = $sDb->fetchOne('
					SELECT value
					FROM ' . $prefix . 'setting
					WHERE varname = \'bbtitle\'
				');

				XenForo_Db::beginTransaction();
				$options['forumid'] = $this->buildImportForum($this->_convertToUtf8('Social Group Images ('.$board.')', true), 950);
				XenForo_Db::commit();
			}

			return array(0, $options, "Processing SG Images ...");
		}

		$attachments = $sDb->fetchAll($sDb->limit('
				SELECT attachmentid, creatoruserid as userid, attachment.dateline, name as title, username,
				filedataid, filename, counter, groupid, filedata.userid as fileuserid, type as state
				FROM ' . $prefix . 'attachment AS attachment
				INNER JOIN ' . $prefix . 'filedata AS filedata USING (filedataid)
				INNER JOIN ' . $prefix . 'socialgroup AS socialgroup ON (socialgroup.groupid = attachment.contentid)
				INNER JOIN ' . $prefix . 'user AS user ON (socialgroup.creatoruserid = user.userid)
				WHERE groupid > ' . $sDb->quote($start) . '
				AND attachment.state = \'visible\'
				AND contenttypeid = ' . $sDb->quote($options['albumType']) . '
				ORDER BY groupid, attachmentid
			', $options['limit']
		));

		if (!$attachments)
		{
			// Rebuild the permission cache
			XenForo_Model::create('XenForo_Model_Node')->updateNestedSetInfo();
			XenForo_Model::create('XenForo_Model_Permission')->rebuildPermissionCache();
			return true;
		}

		$next = 0;
		$last = 0;
		$total = 0;
		$position = 0;
		$userIdMap = $model->getUserIdsMapFromArray($attachments, 'userid');

		foreach ($attachments AS $attachment)
		{
			$next = $attachment['groupid'];

			if ($last <> $next)
			{
				$last = $next;
				$userid = $model->mapUserId($attachment['userid'], 0);
				$username = $this->_convertToUtf8($attachment['username'], true);
				$username = $this->mbTrim($username,50,$userid);
				
				$import = array(
					'title' => $this->_convertToUtf8('Group : '.$attachment['title'], true),
					'node_id' => $options['forumid'],
					'user_id' => $userid,
					'username' => $username,
					'discussion_open' => 1,
					'post_date' => $attachment['dateline'],
					'reply_count' => 0,
					'view_count' => 0,
					'sticky' => 0,
					'discussion_state' => $attachment['state'] == 'public' ? 'visible' : 'moderated',
					'last_post_date' => $attachment['dateline'],
					'last_post_username' => $username
				);

				$threadid = $model->importThread(0, $import);

				$position = 0;
				$acount = $options['alimit'];
				$model->logImportData('groupimage', $attachment['groupid'], $threadid);
			}

			if ($acount >= $options['alimit'])
			{
				if ($position != 0)
				{
					$this->_db->query('
						UPDATE xf_thread
						SET reply_count = reply_count + 1
						WHERE thread_id = ?
					', $threadid);
				}
				
				$acount = 0;
				$position++;

				$import = array(
					'thread_id' => $threadid,
					'user_id' => $userid,
					'username' => $username,
					'post_date' => $attachment['dateline']+$position,
					'message' => "Group Images $position \n\n",
					'attach_count' => 0,
					'ip' => '0.0.0.0',
					'position' => $position,
					'message_state' => 'visible'
				);

				$postid = $model->importPost(0, $import);
			}

			$attachment['userid'] = $userid;
			$attachment['postid'] = $postid;

			unset($attachment['message']);
			$success = $this->_makeAttachment($options, $attachment);

			if ($success)
			{
				$total++;
				$acount++;
			}
		}

		$options['processed'] += $total; 
		$this->_session->incrementStepImportTotal($total);

		return array($next, $options, $this->_getProgressOutput($options['processed'], $options['rows']));
	}

	public function stepBlogs($start, array $options)
	{
		$options = array_merge(array(
			'max' => false,
			'limit' => 100,
			'processed' => 0,
			'postLimit' => 500,
			'postDateStart' => 0,
		), $options);

		$sDb = $this->_sourceDb;
		$prefix = $this->_prefix;
		$model = $this->_importModel;

		$active = $sDb->fetchOne('
			SELECT active
			FROM ' . $prefix . 'product
			WHERE productid = \'vbblog\'
		');

		if (!$active)
		{
			return true; // Blogs not installed or active.
		}

		if ($options['max'] === false)
		{
			$data = $sDb->fetchRow('
				SELECT MAX(blogid) AS max, COUNT(blogid) AS rows
				FROM ' . $prefix . 'blog
			');

			$options = array_merge($options,$data);
			
			if ($options['max'])
			{
				// Get board name
				$board = $sDb->fetchOne('
					SELECT value
					FROM ' . $prefix . 'setting
					WHERE varname = \'bbtitle\'
				');

				XenForo_Db::beginTransaction();
				$options['forumid'] = $this->buildImportForum($this->_convertToUtf8('Blogs ('.$board.')', true), 920);
				XenForo_Db::commit();
			}

			return array(0, $options, "Processing Blogs ...");
		}

		$threads = $sDb->fetchAll($sDb->limit('
				SELECT *
				FROM ' . $prefix . 'blog AS blog
				INNER JOIN ' . $prefix . 'blog_text AS blog_text 
				ON (blog.firstblogtextid = blog_text.blogtextid)
				WHERE blog.blogid >= ' . $sDb->quote($start) . '
				ORDER BY blog.blogid
			', $options['limit']
		));

		if (!$threads)
		{
			// Rebuild the permission cache
			XenForo_Model::create('XenForo_Model_Node')->updateNestedSetInfo();
			XenForo_Model::create('XenForo_Model_Permission')->rebuildPermissionCache();
			return true; // All done.
		}

		$next = 0;
		$total = 0;
		$totalPosts = 0;

		XenForo_Db::beginTransaction();

		foreach ($threads AS $thread)
		{
			if (trim($thread['username']) === '' || trim($thread['title']) === '')
			{
				continue;
			}

			$postDateStart = $options['postDateStart'];

			$options['postDateStart'] = 0;
			$next = $thread['blogid'] + 1; 

			$maxPosts = $options['postLimit'] - $totalPosts;

			$posts = $sDb->fetchAll($sDb->limit('
					SELECT blog_text.* 
					FROM ' . $prefix . 'blog_text AS blog_text
					INNER JOIN ' . $prefix . 'user AS user USING (userid)
					WHERE blog_text.blogid = ' . $sDb->quote($thread['blogid']) . '
					AND blog_text.dateline > ' . $sDb->quote($postDateStart) . '
					ORDER BY blog_text.dateline
				', $maxPosts
			));

			if (!$posts)
			{
				if ($postDateStart)
				{
					$total++;
				}
				continue;
			}

			if ($postDateStart)
			{
				$threadId = $options['threadid'];
				$position = $this->_db->fetchOne('
					SELECT MAX(position)
					FROM xf_post
					WHERE thread_id = ?
				', $threadId);
			}
			else
			{
				if (!$options['forumid'])
				{
					continue;
				}
  
				$import = array(
					'title' => $this->_convertToUtf8($thread['title'], true),
					'node_id' => $options['forumid'],
					'user_id' => $model->mapUserId($thread['userid'], 0),
					'username' => $this->_convertToUtf8($thread['username'], true),
					'discussion_open' => 1,
					'post_date' => $thread['dateline'],
					'reply_count' => $thread['comments_visible'],
					'view_count' => $thread['views'] ,
					'sticky' => 0,
					'last_post_date' => $thread['lastcomment'],
					'last_post_username' => $this->_convertToUtf8($thread['lastcommenter'], true)
				);

				$import['username'] = $this->mbTrim($import['username'],50,$import['user_id']);

				switch ($thread['state'])
				{
					case 'moderation': $import['discussion_state'] = 'moderated'; break;
					default: $import['discussion_state'] = $thread['state'];
				}

				$threadId = $model->importThread(0, $import);

				$options['threadid'] = $threadId;
				$model->logImportData('blog', $thread['blogid'], $threadId);

				XenForo_Db::commit();

				if (!$threadId)
				{
					continue;
				}

				$position = -1;
			}

			if ($threadId)
			{
				$first = true;
				$userIdMap = $model->getUserIdsMapFromArray($posts, 'userid');

				XenForo_Db::beginTransaction();

				foreach ($posts AS $post)
				{
					if (trim($post['username']) === '' || trim($post['pagetext']) === '')
					{
						continue;
					}

					$post['pagetext'] = $this->_convertVideo($post['pagetext']);

					$import = array(
						'thread_id' => $threadId,
						'user_id' => $this->_mapLookUp($userIdMap, $post['userid'], 0),
						'username' => $this->_convertToUtf8($post['username'], true),
						'post_date' => $post['dateline'],
						'message' => $this->_convertToUtf8($post['pagetext']),
						'attach_count' => 0,
						'ip' => $post['ipaddress']
					);

					$import['username'] = $this->mbTrim($import['username'],50,$import['user_id']);

					switch ($post['state'])
					{
						case 'deleted': $import['message_state'] = 'deleted'; $import['position'] = $position; break;
						case 'moderation': $import['message_state'] = 'moderated'; $import['position'] = $position; break;
						default: $import['message_state'] = 'visible'; $import['position'] = ++$position; 
					}

					$postid = $model->importPost(0, $import);
					$model->logImportData('blogcomment', $post['blogtextid'], $postid);

					if ($first)
					{
						$first = false;
						$model->logImportData('blogfirst', $thread['blogid'], $postid);
					}

					$options['postDateStart'] = $post['dateline'];
					$totalPosts++;
				}
			}

			if (count($posts) < $maxPosts)
			{
				$total++;
				$options['postDateStart'] = 0;
			}
			else
			{
				break;
			}
		}

		XenForo_Db::commit();

		if ($options['postDateStart'])
		{
			$next--;
		}

		$options['processed'] += $total; 
		$this->_session->incrementStepImportTotal($total);

		return array($next, $options, $this->_getProgressOutput($options['processed'], $options['rows']));
	}

	public function stepArticles($start, array $options)
	{
		$options = array_merge(array(
			'max' => false,
			'cats' => 0,
			'limit' => 50,
			'processed' => 0,
			'cmsTypes' => '',
			'postLimit' => 500,
			'postDateStart' => 0,
		), $options);

		$sDb = $this->_sourceDb;
		$prefix = $this->_prefix;
		$model = $this->_importModel;

		$active = $sDb->fetchOne('
			SELECT active
			FROM ' . $prefix . 'product
			WHERE productid = \'vbcms\'
		');

		if (!$active)
		{
			return true; // CMS not installed or active.
		}

		if ($options['max'] === false)
		{
			$content = $sDb->fetchAll('
				SELECT contenttypeid, class
				FROM ' . $prefix . 'contenttype
				WHERE class IN (\'Article\',\'StaticPage\',\'PhpEval\',\'Section\')
			');

			$options['cmsTypes'] = Array('0');

			foreach ($content AS $type)
			{
				if ($type['class'] <> 'Section')
				{
					$options['cmsTypes'][] = $type['contenttypeid'];
				}
				$options['cms'.$type['class']] = $type['contenttypeid'];
			}

			$options['cmsTypes'] = implode(',',$options['cmsTypes']);

			$data = $sDb->fetchRow('
				SELECT MAX(nodeid) AS max, COUNT(nodeid) AS rows
				FROM ' . $prefix . 'cms_node
				WHERE contenttypeid IN ('.$options['cmsTypes'].')
			');

			$options = array_merge($options,$data);

			if ($options['max'])
			{
				// Get board name
				$board = $sDb->fetchOne('
					SELECT value
					FROM ' . $prefix . 'setting
					WHERE varname = \'bbtitle\'
				');

				XenForo_Db::beginTransaction();
				$options['forumid'] = $this->buildImportForum($this->_convertToUtf8('CMS Articles ('.$board.')', true), 930);
				XenForo_Db::commit();

				$options['cats'] = 1;
				return array(0, $options, "Processing Sections ...");
			}
		}

		if ($options['cats'] == 1)
		{
			XenForo_Db::beginTransaction();

			// Do all sections in one go
			$cats = $sDb->fetchAll('
				SELECT *
				FROM ' . $prefix . 'cms_node AS cms_node 
				INNER JOIN ' . $prefix . 'cms_nodeinfo AS cms_nodeinfo USING (nodeid)
				WHERE contenttypeid = ' . $sDb->quote($options['cmsSection']) . '
				ORDER BY nodeid
			');

			foreach ($cats AS $category)
			{
				$newnode = $this->buildImportForum($this->_convertToUtf8($category['title']), $category['nodeid'], $options['forumid']);
				$model->logImportData('cmsnode', $category['nodeid'], $newnode);
			}

			XenForo_Db::commit();

			$options['cats'] = 2;
			return array(0, $options, "Processing Articles ...");
		}

		$threads = $sDb->fetchAll($sDb->limit('
				SELECT *
				FROM ' . $prefix . 'cms_node AS cms_node 
				INNER JOIN ' . $prefix . 'user AS user USING (userid)
				INNER JOIN ' . $prefix . 'cms_nodeinfo AS cms_nodeinfo USING (nodeid)
				WHERE contenttypeid IN ('.$options['cmsTypes'].') 
				AND cms_node.nodeid >= ' . $sDb->quote($start) . '
				ORDER BY cms_node.nodeid
			', $options['limit']
		));

		if (!$threads)
		{
			// Rebuild the permission cache
			XenForo_Model::create('XenForo_Model_Node')->updateNestedSetInfo();
			XenForo_Model::create('XenForo_Model_Permission')->rebuildPermissionCache();
			return true; // All done.
		}

		$next = 0;
		$total = 0;
		$totalPosts = 0;

		$nodeMap = $model->getImportContentMap('cmsnode');

		XenForo_Db::beginTransaction();

		foreach ($threads AS $thread)
		{
			if (trim($thread['username']) === '' || trim($thread['title']) === '')
			{
				continue;
			}

			$postDateStart = $options['postDateStart'];

			$options['postDateStart'] = 0;
			$next = $thread['nodeid'] + 1; 

			$maxPosts = $options['postLimit'] - $totalPosts;

			$posts = $sDb->fetchAll($sDb->limit('
					SELECT cms_node.nodeid, post.userid, post.username, 
					post.dateline, post.ipaddress, post.parentid, cms_node.contenttypeid, 
					post.pagetext as postmessage, cms_article.pagetext as articlemessage,
					cms_nodeconfig.value as staticmessage, post.visible, post.postid
					FROM ' . $prefix . 'cms_nodeinfo AS cms_nodeinfo 
					INNER JOIN ' . $prefix . 'cms_node AS cms_node USING (nodeid)
					INNER JOIN ' . $prefix . 'post AS post 
					ON (cms_nodeinfo.associatedthreadid = post.threadid)
					LEFT JOIN ' . $prefix . 'cms_article AS cms_article USING (contentid)
					LEFT JOIN ' . $prefix . 'cms_nodeconfig AS cms_nodeconfig 
					ON (cms_nodeconfig.nodeid = cms_node.nodeid AND cms_nodeconfig.name = "pagetext")
					WHERE cms_node.nodeid = ' . $sDb->quote($thread['nodeid']) . '
					ORDER BY cms_node.nodeid, post.dateline
				', $maxPosts
			));

			if (!$posts)
			{
				if ($postDateStart)
				{
					$total++;
				}
				continue;
			}

			if ($postDateStart)
			{
				$threadId = $options['threadid'];
				$position = $this->_db->fetchOne('
					SELECT MAX(position)
					FROM xf_post
					WHERE thread_id = ?
				', $threadId);
			}
			else
			{
				$forumid = $this->_mapLookUp($nodeMap, $thread['parentnode']);

				if (!$forumid)
				{
					continue;
				}

				$import = array(
					'title' => $this->_convertToUtf8($thread['title'], true),
					'node_id' => $forumid,
					'user_id' => $model->mapUserId($thread['userid'], 0),
					'username' => $this->_convertToUtf8($thread['username'], true),
					'discussion_open' => 1,
					'post_date' => $thread['publishdate'],
					'reply_count' => 0,
					'view_count' => $thread['viewcount'] ,
					'sticky' => 0,
					'last_post_date' => $thread['lastupdated'],
					'last_post_username' => 'vB4 Importer'
				);

				$import['username'] = $this->mbTrim($import['username'],50,$import['user_id']);

				switch ($thread['setpublish'])
				{
					case 0: $import['discussion_state'] = 'moderated'; break;
					default: $import['discussion_state'] = 'visible';
				}

				$threadId = $model->importThread(0, $import);

				$options['threadid'] = $threadId;
				$model->logImportData('cmsarticle', $thread['nodeid'], $threadId);

				if (!$threadId)
				{
					continue;
				}

				$position = -1;
			}

			if ($threadId)
			{
				$first = true;
				$userIdMap = $model->getUserIdsMapFromArray($posts, 'userid');

				foreach ($posts AS $post)
				{
					if ($post['parentid'])
					{
						$post['pagetext'] = $post['postmessage'];
					}
					else
					{
						if ($post['contenttypeid'] == $options['cmsArticle'])
						{
							$post['pagetext'] = $post['articlemessage'];
						}
						else
						{	
							$post['pagetext'] = $post['staticmessage'];
						}
					}

					if (trim($post['username']) === '' || trim($post['pagetext']) === '')
					{
						continue;
					}

					$post['pagetext'] = $this->_convertVideo($post['pagetext']);

					$import = array(
						'thread_id' => $threadId,
						'user_id' => $this->_mapLookUp($userIdMap, $post['userid'], 0),
						'username' => $this->_convertToUtf8($post['username'], true),
						'post_date' => $post['dateline'],
						'message' => $this->_convertToUtf8($post['pagetext']),
						'attach_count' => 0,
						'ip' => $post['ipaddress']
					);

					$import['username'] = $this->mbTrim($import['username'],50,$import['user_id']);

					switch ($post['visible'])
					{
						case 2: $import['message_state'] = 'deleted'; $import['position'] = $position; break;
						case 0: $import['message_state'] = 'moderated'; $import['position'] = $position; break;
						default: $import['message_state'] = 'visible'; $import['position'] = ++$position; 
					}

					$postid = $model->importPost(0, $import);
					$model->logImportData('cmscomment', $post['postid'], $postid);

					if ($first)
					{
						$first = false;
						$model->logImportData('cmsfirst', $thread['nodeid'], $postid);
					}

					$options['postDateStart'] = $post['dateline'];
					$totalPosts++;
				}
			}

			if (count($posts) < $maxPosts)
			{
				$total++;
				$options['postDateStart'] = 0;
			}
			else
			{
				break;
			}
		}

		XenForo_Db::commit();

		if ($options['postDateStart'])
		{
			$next--;
		}

		$options['processed'] += $total; 
		$this->_session->incrementStepImportTotal($total);

		return array($next, $options, $this->_getProgressOutput($options['processed'], $options['rows']));
	}

	public function stepReputation($start, array $options)
	{
		$options = array_merge(array(
			'max' => false,
			'limit' => 100,
			'processed' => 0,
		), $options);

		$sDb = $this->_sourceDb;
		$prefix = $this->_prefix;
		$model = $this->_importModel;
		
		if ($options['max'] === false)
		{
			$data = $sDb->fetchRow('
				SELECT MAX(reputationid) AS max, COUNT(reputationid) AS rows
				FROM ' . $prefix . 'reputation
				WHERE reputation >= 0
			');

			$options = array_merge($options,$data);
		}

		$reputation = $sDb->fetchAll($sDb->limit('
				SELECT *
				FROM ' . $prefix . 'reputation
				WHERE reputation >= 0
				AND reputationid >= ' . $sDb->quote($start) . '
				ORDER BY reputationid
			', $options['limit']
		));

		if (!$reputation)
		{
			return true;
		}

		$next = 0;
		$total = 0;

		$userids = array();
		$postids = array();

		foreach ($reputation AS $rep)
		{
			$userids[] = $rep['userid'];
			$userids[] = $rep['whoadded'];
			$postids[] = $rep['postid'];
		}

		$userIdMap = $model->getImportContentMap('user', $userids);
		$postIdMap = $model->getImportContentMap('post', $postids);

		XenForo_Db::beginTransaction();

		foreach ($reputation AS $like)
		{
			$likeUserId = $this->_mapLookUp($userIdMap, $like['whoadded']);
			$postUserId = $this->_mapLookUp($userIdMap, $like['userid']);
			$postId = $this->_mapLookUp($postIdMap, $like['postid']);

			if ($likeUserId > 0 && $postUserId > 0 && $postId > 0)
			{
				$this->_importLike($postId, $postUserId, $likeUserId, $like['dateline']);
			}
			
			$total++;
			$next = $like['reputationid'] + 1;
		}

		XenForo_Db::commit();

		$options['processed'] += $total; 
		$this->_session->incrementStepImportTotal($total);
		
		return array($next, $options, $this->_getProgressOutput($options['processed'], $options['rows']));
	}

	protected function _importLike($contentId, $contentUserId, $likeUserId, $likeDate)
	{
		$this->_db->query('
			INSERT INTO xf_liked_content
				(content_type, content_id, content_user_id, like_user_id, like_date)
			VALUES
				(?, ?, ?, ?, ?)
		', array('post', $contentId, $contentUserId, $likeUserId, $likeDate));

		$this->_db->query('
				UPDATE xf_user
				SET like_count = like_count + 1
				WHERE user_id = ?
			', $contentUserId);

		$likeModel = $this->_importModel->getModelFromCache('XenForo_Model_Like');
		$likeHandler = $likeModel->getLikeHandler('post');
		$latestLikes = $likeModel->getLatestContentLikeUsers('post', $contentId);
		$likeHandler->incrementLikeCounter($contentId, $latestLikes);
	}

	protected function _convertVideo($string)
	{
		// Convert Video Tags to Media Tags.
		$string = preg_replace('/\[video=vimeo\;(.+)(&.*)?"?\].*\[\/video\]/i', '[media=vimeo]$1[/media]' ,$string);
		$string = preg_replace('/\[video=youtube\;(.+)(&.*)?"?\].*\[\/video\]/i', '[media=youtube]$1[/media]' ,$string);
		$string = preg_replace('/\[video=facebook\;(.+)(&.*)?"?\].*\[\/video\]/i', '[media=facebook]$1[/media]' ,$string);

		// Convert raw youtube links to media bbcode (Krochinzky)
		$string = preg_replace('/\[url="?http:\/\/www\.youtube\.com\/watch\?v=(.+)(&.*)?"?\].*\[\/url\]/i', '[media=youtube]$1[/media]' ,$string);
		$string = preg_replace('/\[url\]http:\/\/www\.youtube\.com\/watch\?v=(.+)(&.*)?\[\/url\]/i', '[media=youtube]$1[/media]' ,$string);

		// Convert raw vimeo links to media bbcode (Krochinzky)
		$string = preg_replace('/\[url\]http:\/\/(www\.)?vimeo\.com\/(\d+)\[\/url\]/i', '[media=vimeo]$2[/media]' ,$string);
		$string = preg_replace('/\[url="?http:\/\/(www\.)?vimeo\.com\/(\d+)"?](.*)\[\/url\]/i', '[media=vimeo]$2[/media]' ,$string);

		// Convert raw facebook links to media bbcode.
		$string = preg_replace('/\[url="?http:\/\/www\.facebook\.com\/video\/video\.php\?v=(.+)(&.*)?"?\].*\[\/url\]/i', '[media=facebook]$1[/media]' ,$string);
		$string = preg_replace('/\[url\]http:\/\/www\.facebook\.com\/video\/video\.php\?v=(.+)(&.*)?\[\/url\]/i', '[media=facebook]$1[/media]' ,$string);

		return trim($string);
	}

	protected function _setForumReadWrite()
	{
		$output = array();
		$output['general']['viewNode'] = 'content_allow';
		$output['forum']['postThread'] = 'content_allow';
		$output['forum']['postReply'] = 'content_allow';
		$output['forum']['editOwnPost'] = 'content_allow';
		$output['forum']['deleteOwnPost'] = 'content_allow';
		$output['forum']['deleteOwnThread'] = 'content_allow';
		$output['forum']['viewAttachment'] = 'content_allow';
		$output['forum']['uploadAttachment'] = 'content_allow';
		$output['forum']['votePoll'] = 'content_allow';
		return $output;
	}

	protected function _setForumReadonly()
	{
		$output = array();
		$output['general']['viewNode'] = 'content_allow';
		$output['forum']['postThread'] = 'reset';
		$output['forum']['postReply'] = 'reset';
		$output['forum']['editOwnPost'] = 'unset';
		$output['forum']['deleteOwnPost'] = 'unset';
		$output['forum']['deleteOwnThread'] = 'unset';
		$output['forum']['viewAttachment'] = 'content_allow';
		$output['forum']['uploadAttachment'] = 'reset';
		$output['forum']['votePoll'] = 'unset';
		return $output;
	}

	protected function _setForumNoAccess()
	{
		$output = array();
		$output['general']['viewNode'] = 'reset';
		$output['forum']['postThread'] = 'reset';
		$output['forum']['postReply'] = 'reset';
		$output['forum']['editOwnPost'] = 'reset';
		$output['forum']['deleteOwnPost'] = 'reset';
		$output['forum']['deleteOwnThread'] = 'reset';
		$output['forum']['viewAttachment'] = 'reset';
		$output['forum']['uploadAttachment'] = 'reset';
		$output['forum']['votePoll'] = 'reset';
		return $output;
	}

	protected function _setForumDeny()
	{
		$output = array();
		$output['general']['viewNode'] = 'deny';
		$output['forum']['postThread'] = 'reset';
		$output['forum']['postReply'] = 'reset';
		$output['forum']['editOwnPost'] = 'reset';
		$output['forum']['deleteOwnPost'] = 'reset';
		$output['forum']['deleteOwnThread'] = 'reset';
		$output['forum']['viewAttachment'] = 'reset';
		$output['forum']['uploadAttachment'] = 'reset';
		$output['forum']['votePoll'] = 'reset';
		return $output;
	}

	protected function getCmsIdsMapFromArray(array $source, $key)
	{
		$model = $this->_importModel;
		$userIds = array();
		foreach ($source AS $data)
		{
			$userIds[] = $data[$key];
		}
		return $model->getImportContentMap('cmsfirst', $userIds);
	}

	protected function getBlogIdsMapFromArray(array $source, $key)
	{
		$model = $this->_importModel;
		$userIds = array();
		foreach ($source AS $data)
		{
			$userIds[] = $data[$key];
		}
		return $model->getImportContentMap('blogfirst', $userIds);
	}

	protected function _makeAttachment($options, &$attachment)
	{
		$sDb = $this->_sourceDb;
		$prefix = $this->_prefix;
		$model = $this->_importModel;

		if (!$options['path'])
		{
			$fData = $sDb->fetchOne('
				SELECT filedata
				FROM ' . $prefix . 'filedata
				WHERE filedataid = ' . $sDb->quote($attachment['filedataid'])
			);

			if ($fData === '')
			{
				return false;
			}

			$attachFile = tempnam(XenForo_Helper_File::getTempDir(), 'xf');

			if (!$attachFile || !@file_put_contents($attachFile, $fData))
			{
				return false;
			}

			$isTemp = true;
		}
		else
		{
			$attachFileOrig = "$options[path]/" . implode('/', str_split($attachment['fileuserid'])) . "/$attachment[filedataid].attach";

			if (!file_exists($attachFileOrig))
			{
				return false;
			}

			$attachFile = tempnam(XenForo_Helper_File::getTempDir(), 'xf');
			copy($attachFileOrig, $attachFile);

			$isTemp = true;
		}

		$success = $model->importPostAttachment(
			$attachment['attachmentid'],
			$this->_convertToUtf8($attachment['filename']),
			$attachFile,
			$attachment['userid'],
			$attachment['postid'],
			$attachment['dateline'],
			array('view_count' => $attachment['counter']),
			array($this, 'processAttachmentTags'),
			$attachment['message']
		);

		if ($isTemp)
		{
			@unlink($attachFile);
		}

		return $success;
	}

	public static function processAttachmentTags($oldAttachmentId, $newAttachmentId, $messageText)
	{
		if (stripos($messageText, '[ATTACH') !== false)
		{
			$newTag = sprintf('[ATTACH]%d.vB[/ATTACH]', $newAttachmentId); // Note use of attachid.vb

			$messageText = preg_replace("#\[ATTACH[^\]]*\]{$oldAttachmentId}\[/ATTACH\]#siU", $newTag, $messageText);
		}

		return $messageText;
	}

	protected function buildImportForum($title, $order, $category = 0)
	{
		if (!$category)
		{
			$category = $this->getImportCategory();
		}

		$import = array(
			'node_type_id' => 'Forum',
			'title' => $title,
			'description' => $title . ' Imported from vBulletin 4',
			'display_order' => $order,
			'parent_node_id' => $category,
			'display_in_list' => 1, 
			'discussion_count' => 0,
			'message_count' => 0,
			'last_post_date' => Time(),
			'last_post_username' => 'vB 4 Importer',
			'last_thread_title' => $title,
		);

		$nodeId = $this->_importModel->importForum(0, $import);

		if ($nodeId)
		{
			$userGroups = $this->_db->fetchAll('
				SELECT *
				FROM xf_user_group
			');

			foreach ($userGroups AS $userGroup)
			{
				switch ($userGroup['user_group_id'])
				{
					case 2: // Registered
						$newPerms = $this->_setForumNoAccess();
						break;

					case 3: // Admins
						$newPerms = $this->_setForumReadWrite();
						break;

					case 4: // Moderators
						$newPerms = $this->_setForumReadonly();
						break;

					default: // The rest
						$newPerms = $this->_setForumDeny();
				}

				$this->_importModel->insertNodePermissionEntries($nodeId, $userGroup['user_group_id'], 0, $newPerms);
			}
		}
		else
		{
			throw new XenForo_Exception($title . ' : Forum Creation Failed.');
		}

		return $nodeId ;
	}

	protected function getImportCategory()
	{
		$nodeId = $this->_db->fetchOne('
			SELECT node_id
			FROM xf_node
			WHERE node_type_id = "Category" AND node_name = "vB4 Importer"
		');

		if ($nodeId)
		{
			return $nodeId ;
		}

		return $this->buildImportCategory('vBulletin 4 Imported Data', 900);
	}

	protected function buildImportCategory($title, $order)
	{
		$rev = self::getVersion();

		$import = array(
			'node_type_id' => 'Category',
			'title' => $title,
			'description' => 'Information Imported From vBulletin 4 Using Importer Version '.$rev,
			'display_order' => $order,
			'parent_node_id' => 0,
			'node_name' => 'vB4 Importer',
		);

		$nodeId = $this->_importModel->importForum(0, $import);

		if ($nodeId)
		{
			$userGroups = $this->_db->fetchAll('
				SELECT *
				FROM xf_user_group
			');

			foreach ($userGroups AS $userGroup)
			{
				switch ($userGroup['user_group_id'])
				{
					case 2: // Registered
						$newPerms = $this->_setForumNoAccess();
						break;

					case 3: // Admins
						$newPerms = $this->_setForumReadWrite();
						break;

					case 4: // Moderators
						$newPerms = $this->_setForumReadonly();
						break;

					default: // The rest
						$newPerms = $this->_setForumDeny();
				}

				$this->_importModel->insertNodePermissionEntries($nodeId, $userGroup['user_group_id'], 0, $newPerms);
			}
		}
		else
		{
			throw new XenForo_Exception($title . ' : Category Creation Failed.');
		}

		return $nodeId ;
	}

	protected function mbTrim($string, $len = 0, $id = 0)
	{
/*
		Trims multi byte string. 
		Mainly used for usernames.
		Adds prefix as well - if requested, and string exceeds limit. 
*/
		if (utf8_strlen($string) <= $len) 
		{ 
			return $string; 
		}

		if ($len < 2)
		{
			throw new XenForo_Exception('Multi-byte Trim Parameter Error : Len '.$len);
		}

		if ($id) 
		{
			$string = $id.'#'.$string;
		}
		
		return utf8_substr($string,0,$len);
	}
}

