<?php

function getPaymentMethods()
{
  return array("paypal" => array("id" => "paypal", "name" => "PayPal"));
}

function getCurrency($currency)
{
  switch($currency) {
  case 1: return 'AUD';
  case 2: return 'CAD';
  case 3: return 'CHF';
  case 4: return 'DKK';
  case 5: return 'EUR';
  case 6: return 'GBP';
  case 7: return 'HKD';
  case 8: return 'JPY';
  case 9: return 'NOK';
  case 10: return 'NZD';
  case 11: return 'SEK';
  case 12: return 'USD';
  default: return 'USD';
  }
}

function paymentUrlPayPal($method, $item, $quantity, $amount, $tax, $handling, 
                     $shipping, $currency, $business, $transid, $return, $finish, $testing)
{
  global $vbulletin;
 
  if($testing)
    $ipn = "https://www.sandbox.paypal.com/cgi-bin/webscr";
  else
    $ipn = "https://www.paypal.com/cgi-bin/webscr";

  $curr = getCurrency($currency);
  $url = $ipn . "?cmd=_xclick&business=".urlencode($business)."&item_name=".urlencode($item)."&amount=$amount".
                 "&handling=$handling&shipping=$shipping&tax=$tax&quantity=$quantity".
                 "&currency_code=$curr&return=".urlencode($return).
                 "&custom=$transid";
  if($finish)
    $url .= "&notify_url=".urlencode($vbulletin->options["bburl"] . "/vbdigishop_gateway.php?method=paypal");
             
  return $url;  
}

function paymentUrl2Checkout($method, $item, $quantity, $amount, $tax, $handling, 
                     $shipping, $currency, $business, $transid, $return, $finish, $testing)
{
  global $vbulletin;

  $url = 'https://www.2checkout.com/2co/buyer/purchase/';
    
  $sid = $vbulletin->options["vbdigishop_2co_account"];

  $url .= "?sid=$sid&total=$amount&cart_order_id=$transid&id_type=1".
          "&c_prod_1=1&c_name_1=Modules&c_description_1=".urlencode("vBulletin Modules&").
          "&c_price_1=$amount&c_tangible=N&fixed=Y".
          "&return_url=".urlencode($vbulletin->options["bburl"] . "/vbdigishop.php?do=2coconfirm");

  if($testing)
    $url .= '&demo=Y';
  
  return $url;
}

function paymentUrl($method, $item, $quantity, $amount, $tax, $handling, 
                     $shipping, $currency, $business, $transid, $return, $finish, $testing)
{
  switch($method) {
    case 'paypal':
      return paymentUrlPayPal($method, $item, $quantity, $amount, $tax, $handling, 
                     $shipping, $currency, $business, $transid, $return, $finish, $testing);
    case '2checkout':
      return paymentUrl2Checkout($method, $item, $quantity, $amount, $tax, $handling, 
                     $shipping, $currency, $business, $transid, $return, $finish, $testing);
    
  }
}

?>

