<?php

function printItemsSelect($items, $selected, $all, $name, $handler, $showid = false)
{
  global $vbphrase;

  echo '<select class="bginput" name="'.$name.'" id=id_"'.$name.'" onChange="'.$handler.'">';
  if($all)
    echo '<option value="-1">'.$vbphrase["vbdigishop_all"].'</option>';

  foreach($items as $item) {
    $sel = false;
    if($item["id"] == $selected)
      $sel = true;

    echo '<option value="'.$item["id"].'" ';
    if($sel)
      echo "selected ";
    $sid = '';
    if($showid)
      $sid = $item["id"].' - ';
    echo '>'.$sid.$item["name"].'</option>';
  }

  echo '</select>';
}

function printCategoriesSelect($selected, $all, $name, $handler)
{
  global $db;

  $cats_get = $db->query_read("SELECT * FROM ". TABLE_PREFIX ."vbdigishop_categories ORDER BY id");
  $cats = array();
  while($cat = $db->fetch_array($cats_get))
    $cats[] = $cat;

  printItemsSelect($cats, $selected, $all, $name, $handler, true);
}

function printSubCategoriesSelect($selected, $cat, $all, $name, $handler)
{
  global $db;

  $subcats_get = $db->query_read("SELECT * FROM ". TABLE_PREFIX ."vbdigishop_subcategories 
    WHERE category='$cat' ORDER BY name");
  $subcats = array();
  while($subcat = $db->fetch_array($subcats_get))
    $subcats[] = $subcat;

  printItemsSelect($subcats, $selected, $all, $name, $handler);
}

function printCategoriesJavascript()
{
  global $db;

  $cats_get = $db->query_read("SELECT * FROM ". TABLE_PREFIX ."vbdigishop_subcategories ORDER BY category, name");
  $cats = array();
  while($cat = $db->fetch_array($cats_get))
    $cats[$cat["category"]][] = $cat;

  echo "var cats = new Array(".count($cats).");\n";
  $i = 0;
  foreach($cats as $catgroup) {
    echo "cats[$i] = new Array(".count($catgroup).");\n";
    $n = 0;
    foreach($catgroup as $cat) {
      echo "cats[$i][$n] = new Array(".$cat["category"].", '".$cat["name"]."', '".$cat["id"]."');\n"; 
      $n++;
    }
    $i++;
  }
}

function sendThankYouMail($userid = -1, $transid)
{
  global $db, $vbulletin;
  
  $fromsite = $vbulletin->options['bbtitle'];
  $fromemail = $vbulletin->options['webmasteremail'];
  if($userid == -1) {
    $toemail = $vbulletin->userinfo['email'];
    $userid = $vbulletin->userinfo['userid'];
  } else {
    $user = $db->query_first("SELECT email FROM ".TABLE_PREFIX."user WHERE userid=$userid");
    $toemail = $user["email"];
  } 
  $emailsubject = $vbulletin->options['vbdigishop_thankyousubject'];
  $message = nl2br($vbulletin->options['vbdigishop_thankyouemail']);
  
  $products = $db->query_read("
      SELECT ".TABLE_PREFIX."vbdigishop_products.*,
        ".TABLE_PREFIX."vbdigishop_boughtproducts.price AS realprice
      FROM ".TABLE_PREFIX."vbdigishop_boughtproducts
      JOIN ".TABLE_PREFIX."vbdigishop_products 
        ON ".TABLE_PREFIX."vbdigishop_products.id=".TABLE_PREFIX."vbdigishop_boughtproducts.productid
      WHERE transid='$transid' AND userid=$userid");
  $prodtable = '<table><tr><td>Product Name</td><td>Price</td></tr>';
  while($product = $db->fetch_array($products)) {
    $prodtable .= "<tr><td>".$product["name"]."</td><td>".$product["realprice"]."</td></tr>";
  }
  $prodtable .= "</table>";
  $message = str_replace('$products', $prodtable, $message);

  $headers="From: ".$fromsite." <".$fromemail.">\n";
  $headers.="Reply-To: ".$fromsite." <".$fromemail.">\n";
  $headers.="MIME-Version: 1.0\n";
  $headers.="X-Sender: ".$_SERVER['REMOTE_ADDR']."\n";
  $headers.="X-Mailer: PHP/".phpversion()."\n";
  $headers.="X-Priority: 3\n";
  $headers.="Content-Type: text/html; charset=iso-8859-1\n";
  $headers.="Return-Path: <".$fromemail.">\n";
  if ($toemail <> '') {
     mail($toemail, $emailsubject, $message, $headers);
  }

  $toemail = $vbulletin->options['webmasteremail'];
  mail($toemail, $emailsubject, $message, $headers);
}

function isUserInGroup($groupid, &$groups, $userid)
{
  global $vbulletin, $db;

  $user = $db->query_first("SELECT membergroupids FROM ".TABLE_PREFIX."user WHERE userid=$userid");
  $groups = $user["membergroupids"];
  $groupids = explode(',', $groups);
  foreach($groupids as $grid)
    if(intval($grid) == $groupid)
      return true;

  return false;
}

function promoteUser($transid, $userid)
{
  global $db;

  $products = $db->query_read("SELECT ".TABLE_PREFIX."vbdigishop_products.id
    FROM ".TABLE_PREFIX."vbdigishop_boughtproducts
    JOIN ".TABLE_PREFIX."vbdigishop_products ON productid=".TABLE_PREFIX."vbdigishop_products.id
    WHERE transid='$transid'");
  while($product = $db->fetch_array($products)) {
    $prodid = $product["id"];
    $promogroups = $db->query_read("SELECT groupid FROM ".TABLE_PREFIX."vbdigishop_product_promotion WHERE product=$prodid");
    while($group = $db->fetch_array($promogroups)) {
      $groups = '';
      if(!isUserInGroup($group["groupid"], $groups, $userid)) {
        if(empty($groups))
          $groups = $group["groupid"];
        else
          $groups .= ','.$group["groupid"];
        
        $db->query_write("UPDATE ".TABLE_PREFIX."user SET membergroupids='$groups' WHERE userid=$userid");
      }  
    }
  }
}

function assign_rand_value($num)
{
  switch($num)
  {
    case "1":
     $rand_value = "a";
    break;
    case "2":
     $rand_value = "b";
    break;
    case "3":
     $rand_value = "c";
    break;
    case "4":
     $rand_value = "d";
    break;
    case "5":
     $rand_value = "e";
    break;
    case "6":
     $rand_value = "f";
    break;
    case "7":
     $rand_value = "g";
    break;
    case "8":
     $rand_value = "h";
    break;
    case "9":
     $rand_value = "i";
    break;
    case "10":
     $rand_value = "j";
    break;
    case "11":
     $rand_value = "k";
    break;
    case "12":
     $rand_value = "l";
    break;
    case "13":
     $rand_value = "m";
    break;
    case "14":
     $rand_value = "n";
    break;
    case "15":
     $rand_value = "o";
    break;
    case "16":
     $rand_value = "p";
    break;
    case "17":
     $rand_value = "q";
    break;
    case "18":
     $rand_value = "r";
    break;
    case "19":
     $rand_value = "s";
    break;
    case "20":
     $rand_value = "t";
    break;
    case "21":
     $rand_value = "u";
    break;
    case "22":
     $rand_value = "v";
    break;
    case "23":
     $rand_value = "w";
    break;
    case "24":
     $rand_value = "x";
    break;
    case "25":
     $rand_value = "y";
    break;
    case "26":
     $rand_value = "z";
    break;
    case "27":
     $rand_value = "0";
    break;
    case "28":
     $rand_value = "1";
    break;
    case "29":
     $rand_value = "2";
    break;
    case "30":
     $rand_value = "3";
    break;
    case "31":
     $rand_value = "4";
    break;
    case "32":
     $rand_value = "5";
    break;
    case "33":
     $rand_value = "6";
    break;
    case "34":
     $rand_value = "7";
    break;
    case "35":
     $rand_value = "8";
    break;
    case "36":
     $rand_value = "9";
    break;
  }
  
  return $rand_value;
}
?>
