<?php
// Setup PHP Enviropment
error_reporting(E_ALL & ~E_NOTICE);
// Define Contants
define('THIS_SCRIPT', 'vbdigishop');
// Cache Templates & Variables
// get special phrase groups
$phrasegroups = array(
	'vbdigishop',
	'threadmanage',
	'posting'
);

$specialtemplates = array();

$globaltemplates = array(
    'vbdigishop_main',
    'vbdigishop_addlicense',
    'vbdigishop_alsobought',
    'vbdigishop_bestsellerbit',
    'vbdigishop_bundlesbit',
    'vbdigishop_cart',
    'vbdigishop_cartitem',
    'vbdigishop_cartitemreview',
    'vbdigishop_category',
    'vbdigishop_dlproduct',
    'vbdigishop_download',
    'vbdigishop_gatewaysbit',
    'vbdigishop_horizontalcategorybit',
    'vbdigishop_legalbit',
    'vbdigishop_newestbit',
    'vbdigishop_payment',
    'vbdigishop_product',
    'vbdigishop_productsbit',
    'vbdigishop_relatedproduct',
    'vbdigishop_smallcart',
    'vbdigishop_smallcartitem',
    'vbdigishop_thankyou',
    'vbdigishop_upcomingbit',
    'vbdigishop_verticalcategorybit', 
);

$actiontemplates = array();

// Include Globals
require_once('./global.php');
$footer = "$vbphrase[vbdigishop_copyright] $footer";

$globals = array(
    'currency'          => TYPE_STR,
);

if(!($permissions['vbdigishop'] & $vbulletin->bf_ugp['vbdigishop']['canuse'])){
    print_no_permission();
}

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'main';
}

function getBestSeller($catid = -1)
{
  global $db, $vbphrase, $vbulletin;

  $currency = $vbulletin->options['vbdigishop_currency'];
  
  if($catid == -1)
    $where = '';
  else
    $where = "AND category=$catid";
    
  $bestseller = $db->query_first("
                    SELECT COUNT( * ) AS cnt, " . TABLE_PREFIX . "vbdigishop_products . *
                    FROM " . TABLE_PREFIX . "vbdigishop_boughtproducts
                    JOIN " . TABLE_PREFIX . "vbdigishop_products ON productid = " . TABLE_PREFIX . "vbdigishop_products.id
                    WHERE paid =1 AND status=1 $where
                    GROUP BY productid
                    ORDER BY cnt DESC
                    LIMIT 1
                    ");
  eval('$bestsellerbit .= "' . fetch_template('vbdigishop_bestsellerbit') . '";');

  return $bestsellerbit;
}

function getSpecialBundles()
{
  global $db, $vbulletin, $vbphrase;

  $currency = $vbulletin->options['vbdigishop_currency'];

  $bundles = 1;
  $bundlecategory = $vbulletin->options['vbdigishop_bundlecat'];
  $bundles_get = $db->query_read("
               SELECT *
                 FROM " . TABLE_PREFIX . "vbdigishop_products
                 WHERE category = $bundlecategory AND status=1
                 ORDER BY price DESC
               ");
   while ($bundle = $db->fetch_array($bundles_get)){
     $saving = $bundle['price']-$bundle['discountprice'];
     $discount = ($saving*100)/$bundle['price'];
     $discount = round($discount, 0);
     eval('$bundlesbit .= "' . fetch_template('vbdigishop_bundlesbit') . '";');
   }
  
  return $bundlesbit;
}

function getNewestProduct($catid = -1)
{
  global $db, $vbphrase, $vbulletin;

  $currency = $vbulletin->options['vbdigishop_currency'];

  if($catid == -1)
    $where = '';
  else
    $where = "AND category=$catid";

  $newest = $db->query_first("
                SELECT *
                FROM " . TABLE_PREFIX . "vbdigishop_products
                WHERE status='1' $where
                ORDER BY id DESC
                LIMIT 1
                ");

  if($vbulletin->options['vbdigishop_bundlecat'] == $newest["category"])
    $price = $newest["discountprice"];
  else
    $price = $newest["price"];

  eval('$newestbit .= "' . fetch_template('vbdigishop_newestbit') . '";');

  return $newestbit;
}

function getUpcomingProduct($catid = -1)
{
  global $db, $vbphrase, $vbulletin;

  $currency = $vbulletin->options['vbdigishop_currency'];

  if($catid == -1)
    $where = '';
  else
    $where = "AND category=$catid";

  $upcoming = $db->query_first("
                  SELECT *
                  FROM " . TABLE_PREFIX . "vbdigishop_products
                  WHERE status='3' $where
                  ORDER BY id DESC
                  LIMIT 1
                  ");

  if($vbulletin->options['vbdigishop_bundlecat'] == $upcoming["category"])
    $price = $upcoming["discountprice"];
  else
    $price = $upcoming["price"];

  eval('$upcomingbit .= "' . fetch_template('vbdigishop_upcomingbit') . '";');

  return $upcomingbit;
}

function getCartContent()
{
  global $db, $vbulletin, $vbphrase;

  $currency = $vbulletin->options['vbdigishop_currency'];
  
  $userid = $vbulletin->userinfo['userid'];
  $products = $db->query_read("
              SELECT ".TABLE_PREFIX."vbdigishop_carts.id AS cartid, discount, count, 
              ".TABLE_PREFIX."vbdigishop_products.*
              FROM ".TABLE_PREFIX."vbdigishop_carts
              JOIN ".TABLE_PREFIX."vbdigishop_products ON productid=".TABLE_PREFIX."vbdigishop_products.id
              WHERE userid=$userid
              ");
  while($product = $db->fetch_array($products)) {
    $price = ($product["discount"] == 1 || $vbulletin->options['vbdigishop_bundlecat'] == $product["category"])
        ? $product["discountprice"] : $product["price"];
    $total = $product["count"] * doubleval($price);
    $total = number_format($total, 2);
    eval('$smallcartitems .= "' . fetch_template('vbdigishop_smallcartitem') . '";');
  }
  
  if($db->num_rows($products) == 0)
    $emptycart = 1;
  else
    $emptycart = 0;

  eval('$smallcartcontent = "' . fetch_template('vbdigishop_smallcart') . '";');

  return $smallcartcontent;
}

function getCategories()
{
  global $db, $vbphrase, $vbulletin;

  $currency = $vbulletin->options['vbdigishop_currency'];
  
  $catsperrow = 2;
  $totalcats = 0;
  $catwidth = 1/$catsperrow * 100;
  $catwidth = "$catwidth%";
  $categories_get = $db->query_read("
	                SELECT *
                    FROM " . TABLE_PREFIX . "vbdigishop_categories
                    ORDER BY display ASC
	                ");
  while ($category = $db->fetch_array($categories_get)){
    $totalcats ++;
    $whichcategory = $category['id'];
    $totalrecords = 0;
    $records_get = $db->query_read("
                    SELECT *
                    FROM `" . TABLE_PREFIX . "vbdigishop_products`
                    WHERE category = '$whichcategory' AND status = 1
                    ORDER BY id ASC
                    ");
    while ($records = $db->fetch_array($records_get)) {
           $totalrecords ++;
    }
    eval('$vcategories .= "' . fetch_template('vbdigishop_verticalcategorybit') . '";');
    eval('$hcategories .= "' . fetch_template('vbdigishop_horizontalcategorybit') . '";');
  }

  return array($vcategories, $hcategories);
}

function hasDownloads()
{
  global $db, $vbulletin;
  
  $userid = $vbulletin->userinfo['userid'];
  $cnt = $db->query_first("SELECT COUNT(id) AS cnt FROM ".TABLE_PREFIX."vbdigishop_boughtproducts WHERE userid=$userid");  
  return $cnt["cnt"] > 0;
}

// #######################################################################
// ############################# MAIN PAGE ###############################
// #######################################################################

if ($_REQUEST['do'] == 'main'){

  // Get Welcome Message
  ob_start();
  include('vbdigishop/includes/welcome.inc.php');
  $welcome = ob_get_contents();
  ob_end_clean();

  $privacy = $vbulletin->options['vbdigishop_privacy'];
  $licence = $vbulletin->options['vbdigishop_licence'];
  $refund = $vbulletin->options['vbdigishop_refund'];
  $defcolor = $vbulletin->options['vbdigishop_defcolor'];
  $currency = $vbulletin->options['vbdigishop_currency'];
  $bundles = $vbulletin->options['vbdigishop_bundle'];

  // vbDigiShop Categories
  list($vcategories, $hcategories) = getCategories();

  // Special Bundles
  if ($vbulletin->options['vbdigishop_bundle'])
    $bundlesbit = getSpecialBundles();
  
  // Best Seller
  $bestsellerbit = getBestSeller();

  // Newest Product
  $newestbit = getNewestProduct();

  // Upcoming Product
  $upcomingbit = getUpcomingProduct();

  // Your Cart
  $smallcartcontent = getCartContent();

  $userid = $vbulletin->userinfo['userid'];
  $navbits = construct_navbits(array("vbdigishop.php?" . $vbulletin->session->vars['sessionurl'] . ""=> $vbphrase['vbdigishop_navbar']));
  eval('$navbar = "' . fetch_template('navbar') . '";');
  eval('$legalbit .= "' . fetch_template('vbdigishop_legalbit') . '";');
  eval('$gatewaysbit .= "' . fetch_template('vbdigishop_gatewaysbit') . '";');
  eval('print_output("' . fetch_template('vbdigishop_main') . '");');
}


// #######################################################################
// ######################## CATEGORY LISTING #############################
// #######################################################################

if ($_REQUEST['do'] == 'category'){

  $perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_UINT);
  $pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
  $privacy = $vbulletin->options['vbdigishop_privacy'];
  $licence = $vbulletin->options['vbdigishop_licence'];
  $refund = $vbulletin->options['vbdigishop_refund'];
  $defcolor = $vbulletin->options['vbdigishop_defcolor'];
  $currency = $vbulletin->options['vbdigishop_currency'];
  $bundles = $vbulletin->options['vbdigishop_bundle'];

  // Get Category ID
  $vbulletin->input->clean_array_gpc('r', array(
	'categoryid'			=> TYPE_UINT
  ));
  $categoryid = $vbulletin->GPC['categoryid'];

  // Get Category Info
  $categoryinfo = $vbulletin->db->query_first("
	              SELECT *
	              FROM " . TABLE_PREFIX . "vbdigishop_categories
	              WHERE id = '$categoryid'
	              LIMIT 1
                  ");

  // Get Categories
  list($vcategories, $hcategories) = getCategories();

  // Get Subcategories
  $catsperrow = 2;
  $totalsubcats = 0;
  $catwidth = 1/$catsperrow * 100;
  $catwidth = "$catwidth%";
  $subcategories_get = $vbulletin->db->query_read("
	                   SELECT *
                       FROM " . TABLE_PREFIX . "vbdigishop_subcategories
                       WHERE category = '$categoryid'
                       ORDER BY id ASC
	                   ");
                       while ($subcategory = $vbulletin->db->fetch_array($subcategories_get)){
                       $totalsubcats ++;
                       $whichsubcategory = $subcategory['id'];
                       $totalrecords = 0;
                       $records_get = $db->query_read("
                                      SELECT *
                                      FROM `" . TABLE_PREFIX . "vbdigishop_products`
                                      WHERE subcategory = '$whichsubcategory' AND status=1
                                      ORDER BY id ASC
                                      ");
                                      while ($records = $vbulletin->db->fetch_array($records_get)){
                                             $totalrecords ++;
                                      }
                       eval('$hsubcategories .= "' . fetch_template('vbdigishop_horizontalsubcategorybit') . '";');
                       }


  // Best Seller in Category
  $bestsellerbit = getBestSeller($categoryid);

  // Newest Product in Category
  $newestbit = getNewestProduct($categoryid);

  // Upcoming Product in Category
  $upcomingbit = getUpcomingProduct($categoryid);

  // Your Cart
  $smallcartcontent = getCartContent();
  if(empty($smallcartcontent))
    $emptycart = 1;
  else
    $emptycart = 0;

  // Special Bundles
  if ($vbulletin->options['vbdigishop_bundle'])
    $bundlesbit = getSpecialBundles();

  // If there is no Subcategory then get Category's products
  if (!$subcategory) {
     $totalproducts = 0;
     $totalrecords = $db->query_first("
                  SELECT COUNT(`id`) AS `totalrecords`
                  FROM `" . TABLE_PREFIX . "vbdigishop_products`
                  WHERE category = '$categoryid' AND status=1
                  ORDER BY id DESC
                  ");
     $recperpage = $vbulletin->options['vbdigishop_products_perpage'];
     sanitize_pageresults($totalrecords['totalrecords'], $pagenumber, $perpage, $recperpage, $recperpage);
     $limitlower = ($pagenumber - 1) * $perpage + 1;
     $limitupper = $pagenumber * $perpage;
     if ($limitupper > $totalrecords['totalrecords']) {
         $limitupper = $totalrecords['totalrecords'];
         if ($limitlower > $totalrecords['totalrecords']) {
             $limitlower = $totalrecords['totalrecords'] - $perpage;
         }
     }
     if ($limitlower <= 0) {
         $limitlower = 1;
     }
     $products_get = $db->query_read("
                     SELECT *
                     FROM `" . TABLE_PREFIX . "vbdigishop_products`
                     LEFT JOIN " . TABLE_PREFIX . "vbdigishop_specials ON " . TABLE_PREFIX . "vbdigishop_specials.prodid = id
                     WHERE category =$categoryid AND status=1
                     GROUP BY id
                     LIMIT " . ($limitlower - 1) . ", $perpage
                     ");
                     while ($products = $vbulletin->db->fetch_array($products_get)){
                        if($vbulletin->options['vbdigishop_bundlecat'] == $categoryid)
                          $price = $products["discountprice"];
                        else
                          $price = $products["price"];
                        
                        $totalproducts ++;
                        $pagenav = construct_page_nav($pagenumber, $perpage, $totalrecords['totalrecords'], 'vbdigishop.php?' . $vbulletin->session->vars['sessionurl'] . 'do=category&categoryid='. $products[category] .'');
                        eval('$productsbit .= "' . fetch_template('vbdigishop_productsbit') . '";');
                     }
  }

  $userid = $vbulletin->userinfo['userid'];
  $navbits = construct_navbits(array("vbdigishop.php?" . $vbulletin->session->vars['sessionurl'] . ""=> $vbphrase['vbdigishop_navbar'], '' => $categoryinfo['name']));
  eval('$navbar = "' . fetch_template('navbar') . '";');
  eval('$legalbit .= "' . fetch_template('vbdigishop_legalbit') . '";');
  eval('$gatewaysbit .= "' . fetch_template('vbdigishop_gatewaysbit') . '";');
  eval('print_output("' . fetch_template('vbdigishop_category') . '");');
}

// #######################################################################
// ############################ VIEW PRODUCT #############################
// #######################################################################

if ($_REQUEST['do'] == 'product'){

  $privacy = $vbulletin->options['vbdigishop_privacy'];
  $licence = $vbulletin->options['vbdigishop_licence'];
  $refund = $vbulletin->options['vbdigishop_refund'];
  $defcolor = $vbulletin->options['vbdigishop_defcolor'];
  $currency = $vbulletin->options['vbdigishop_currency'];
  $bundles = $vbulletin->options['vbdigishop_bundle'];

  // Get Category ID
  $vbulletin->input->clean_array_gpc('r', array(
	'productid'			=> TYPE_UINT
  ));
  $productid = $vbulletin->GPC['productid'];

  $addons = $db->query_read("
      SELECT ". TABLE_PREFIX ."vbdigishop_products.*,
          ". TABLE_PREFIX ."vbdigishop_categories.name AS catname,
          ". TABLE_PREFIX ."vbdigishop_subcategories.name AS subcatname
      FROM ". TABLE_PREFIX ."vbdigishop_addons
      JOIN ". TABLE_PREFIX ."vbdigishop_products ON relprodid=". TABLE_PREFIX ."vbdigishop_products.id
      JOIN ". TABLE_PREFIX ."vbdigishop_categories ON
        ". TABLE_PREFIX ."vbdigishop_categories.id=". TABLE_PREFIX ."vbdigishop_products.category
      LEFT JOIN ". TABLE_PREFIX ."vbdigishop_subcategories ON
        ". TABLE_PREFIX ."vbdigishop_subcategories.id=". TABLE_PREFIX ."vbdigishop_products.subcategory
      WHERE ". TABLE_PREFIX ."vbdigishop_addons.prodid=$productid
      ORDER BY ". TABLE_PREFIX ."vbdigishop_products.name ASC");
  $addonscount = $db->num_rows($addons);
  if($addonscount > 0) {
    $addonshtml = '';

    $idx = 1;
    $special = 0;
    while($product = $db->fetch_array($addons)) {
      $name = "addons_$idx";
      $specialname = "specials_$idx"."_discount";
      $idx++;
      eval('$addonshtml .= "' . fetch_template('vbdigishop_relatedproduct') . '";');
    }
  }

  $specials = $db->query_read("
      SELECT ". TABLE_PREFIX ."vbdigishop_products.*,
          ". TABLE_PREFIX ."vbdigishop_categories.name AS catname,
          ". TABLE_PREFIX ."vbdigishop_subcategories.name AS subcatname
      FROM ". TABLE_PREFIX ."vbdigishop_specials
      JOIN ". TABLE_PREFIX ."vbdigishop_products ON relprodid=". TABLE_PREFIX ."vbdigishop_products.id
      JOIN ". TABLE_PREFIX ."vbdigishop_categories ON
        ". TABLE_PREFIX ."vbdigishop_categories.id=". TABLE_PREFIX ."vbdigishop_products.category
      LEFT JOIN ". TABLE_PREFIX ."vbdigishop_subcategories ON
        ". TABLE_PREFIX ."vbdigishop_subcategories.id=". TABLE_PREFIX ."vbdigishop_products.subcategory
      WHERE ". TABLE_PREFIX ."vbdigishop_specials.prodid=$productid
      ORDER BY ". TABLE_PREFIX ."vbdigishop_products.name ASC");
  $specialscount = $db->num_rows($specials);
  if($specialscount > 0) {
    $specialshtml = '';

    $idx = 1;
    $special = 1;
    while($product = $db->fetch_array($specials)) {
      $name = "specials_$idx";
      $specialname = "specials_$idx"."_discount";
      $idx++;
      eval('$specialshtml .= "' . fetch_template('vbdigishop_relatedproduct') . '";');
    }
  }

  $boughtalso = $db->query_read("
      SELECT ". TABLE_PREFIX ."vbdigishop_products.*, COUNT( also.productid ) AS times
      FROM ". TABLE_PREFIX ."vbdigishop_boughtproducts
      JOIN ". TABLE_PREFIX ."vbdigishop_boughtproducts AS also 
          ON also.userid = ". TABLE_PREFIX ."vbdigishop_boughtproducts.userid
      JOIN ". TABLE_PREFIX ."vbdigishop_products
          ON also.productid = ". TABLE_PREFIX ."vbdigishop_products.id
      WHERE ". TABLE_PREFIX ."vbdigishop_boughtproducts.productid=$productid
          AND also.paid =1
          AND also.productid<>$productid
      GROUP BY also.productid
      ORDER BY ". TABLE_PREFIX ."vbdigishop_products.name ASC");

  $boughtalsocount = $db->num_rows($boughtalso); 
  if($boughtalsocount > 0) {
    $boughtalsohtml = '';
    
    $idx = 1;
    while($product = $db->fetch_array($boughtalso)) {
      $name = "boughtalso_$idx";
      $idx++;

      $relid = $product["id"];
      $relcount = $db->query_first("SELECT COUNT(productid) AS times
        FROM ". TABLE_PREFIX ."vbdigishop_boughtproducts
        WHERE productid=$relid
            AND userid IN 
              (SELECT userid FROM ". TABLE_PREFIX ."vbdigishop_boughtproducts WHERE productid=$productid)
        GROUP BY productid");

      $times = $relcount["times"];
      eval('$boughtalsohtml .= "' . fetch_template('vbdigishop_alsobought') . '";');
    }
  } 

  // Get Categories
  list($vcategories, $hcategories) = getCategories();

  // Special Bundles
  if ($vbulletin->options['vbdigishop_bundle'])
    $bundlesbit = getSpecialBundles();
  
  // Best Seller
  $bestsellerbit = getBestSeller();

  // Newest Product
  $newestbit = getNewestProduct();

  // Upcoming Product
  $upcomingbit = getUpcomingProduct();

  // Your Cart
  $smallcartcontent = getCartContent();
  if(empty($smallcartcontent))
    $emptycart = 1;
  else
    $emptycart = 0;

  $products = $db->query_read("
      SELECT ". TABLE_PREFIX ."vbdigishop_products.*,
          ". TABLE_PREFIX ."vbdigishop_categories.name AS catname,
          ". TABLE_PREFIX ."vbdigishop_subcategories.name AS subcatname
      FROM ". TABLE_PREFIX ."vbdigishop_products
      JOIN ". TABLE_PREFIX ."vbdigishop_categories ON
        ". TABLE_PREFIX ."vbdigishop_categories.id=". TABLE_PREFIX ."vbdigishop_products.category
      LEFT JOIN ". TABLE_PREFIX ."vbdigishop_subcategories ON
        ". TABLE_PREFIX ."vbdigishop_subcategories.id=". TABLE_PREFIX ."vbdigishop_products.subcategory
      WHERE ". TABLE_PREFIX ."vbdigishop_products.id=$productid
      ORDER BY ". TABLE_PREFIX ."vbdigishop_products.name ASC");
  $product = $db->fetch_array($products);
  if($vbulletin->options['vbdigishop_bundlecat'] == $product["category"])
    $price = $product["discountprice"];
  else
    $price = $product["price"];

  $userid = $vbulletin->userinfo['userid'];
  $loggedin = $vbulletin->userinfo['userid'];
  $navbits = construct_navbits(array("vbdigishop.php?" . $vbulletin->session->vars['sessionurl'] . ""=> $vbphrase['vbdigishop_navbar'], '' => $product['name']));
  eval('$navbar = "' . fetch_template('navbar') . '";');
  eval('$legalbit .= "' . fetch_template('vbdigishop_legalbit') . '";');
  eval('$gatewaysbit .= "' . fetch_template('vbdigishop_gatewaysbit') . '";');
  eval('print_output("' . fetch_template('vbdigishop_product') . '");');
}

function verifyDiscount($prodid, $id)
{
  global $db, $vbulletin;

  $userid = $vbulletin->userinfo['userid'];
  $special = $db->query_read("
      SELECT relid
      FROM ". TABLE_PREFIX ."vbdigishop_specials
      WHERE prodid=$id AND relprodid=$prodid");
  if($db->num_rows($special) == 1)
    return 1;
    
  return 0;
}

function addProductToCart($id, $discount, $forproduct)
{
  global $db, $vbulletin;
  
  $userid = $vbulletin->userinfo['userid'];
  $products = $db->query_read("SELECT id FROM ".TABLE_PREFIX."vbdigishop_carts
    WHERE userid=$userid AND productid=$id");
  if($db->num_rows($products) > 0) {
    $db->query_write("UPDATE ".TABLE_PREFIX."vbdigishop_carts
      SET count=count+1
      WHERE userid=$userid AND productid=$id");
  } else {
    $db->query_write("INSERT INTO ".TABLE_PREFIX."vbdigishop_carts (id, userid, productid, discount, forproduct, count)
      VALUES (NULL, $userid, $id, $discount, $forproduct, 1)");
  }
}

function addToCart()
{
  $id = isset($_REQUEST['id']) ? intval($_REQUEST['id']) : -1;
  addProductToCart($id, 0, "NULL");

  $types = array("addons", "specials", "boughtalso");
  foreach($types as $type) {
    $count = intval($_REQUEST["$type"."_count"]);
    for($i = 1; $i <= $count; $i++) {
      $prodid = $_REQUEST["$type"."_$i"];
      if(!empty($prodid)) {
        $prodid = intval($prodid);

        $discount = $_REQUEST["$type".'_'.$i."_discount"] == '1';
        if($discount)
          $discount = verifyDiscount($prodid, $id);
        else
          $discount = 0;
        if($discount == 1)
          $forproduct = $id;
        else
          $forproduct = "NULL";
          
        addProductToCart($prodid, $discount, $forproduct);
      }
    }
  }
}

function getQuantityOptions($count)
{
  $options = "";
  for($i = 1; $i <= 10; $i++) {
    $selected = $count == $i ? "selected" : "";
    
    $options .= '<option '.$selected.' value="'.$i.'">'.$i.'</option>';
  }
  
  return $options;
}

function changeQuantity()
{
  global $db, $vbulletin;

  $userid = $vbulletin->userinfo['userid'];
  $id = isset($_REQUEST['id']) ? intval($_REQUEST['id']) : -1;
  $count = isset($_REQUEST['quantity']) ? intval($_REQUEST['quantity']) : -1;
  
  $db->query_write("UPDATE ".TABLE_PREFIX."vbdigishop_carts
    SET count=$count
    WHERE userid=$userid AND productid=$id");
}

function deleteFromCart()
{
  global $db, $vbulletin;

  $userid = $vbulletin->userinfo['userid'];
  $id = isset($_REQUEST['id']) ? intval($_REQUEST['id']) : -1;
  $db->query_write("DELETE FROM ".TABLE_PREFIX."vbdigishop_carts
    WHERE userid=$userid AND (productid=$id OR forproduct=$id)");
}

if ($_REQUEST['do'] == 'cart') {

  if(!($permissions['vbdigishop'] & $vbulletin->bf_ugp['vbdigishop']['canorder'])){
      print_no_permission();
  }

  $privacy = $vbulletin->options['vbdigishop_privacy'];
  $licence = $vbulletin->options['vbdigishop_licence'];
  $refund = $vbulletin->options['vbdigishop_refund'];
  $defcolor = $vbulletin->options['vbdigishop_defcolor'];
  $currency = $vbulletin->options['vbdigishop_currency'];
  $bundles = $vbulletin->options['vbdigishop_bundle'];

  if($_REQUEST["action"] == 'addtocart')
    addToCart();
  if($_REQUEST["action"] == 'changequantity')
    changeQuantity();
  if($_REQUEST["action"] == 'delete')
    deleteFromCart();

  $userid = $vbulletin->userinfo['userid'];
  $items = $db->query_read("
    SELECT ".TABLE_PREFIX."vbdigishop_carts.discount,
      ".TABLE_PREFIX."vbdigishop_carts.count,
      ".TABLE_PREFIX."vbdigishop_products.*
    FROM ".TABLE_PREFIX."vbdigishop_carts
    JOIN ".TABLE_PREFIX."vbdigishop_products ON productid=".TABLE_PREFIX."vbdigishop_products.id
    WHERE userid=$userid
    ORDER BY ".TABLE_PREFIX."vbdigishop_products.name ASC");

  $cartitems = "";
  $totalprice = 0;
  while($product = $db->fetch_array($items)) {
    $quantityoptions = getQuantityOptions($product["count"]);
    $price = ($product["discount"] == 1 || $vbulletin->options['vbdigishop_bundlecat'] == $product["category"])
       ? $product["discountprice"] : $product["price"];
    $total = $product["count"] * doubleval($price);
    $totalprice += $total;
    $total = number_format($total, 2);
    eval('$cartitems .= "' . fetch_template('vbdigishop_cartitem') . '";');
  }
  $totalprice = number_format($totalprice, 2);


  // Get Categories
  list($vcategories, $hcategories) = getCategories();

  // Special Bundles
  if ($vbulletin->options['vbdigishop_bundle'])
    $bundlesbit = getSpecialBundles();
  
  // Best Seller
  $bestsellerbit = getBestSeller();

  // Newest Product
  $newestbit = getNewestProduct();

  // Upcoming Product
  $upcomingbit = getUpcomingProduct();

  // Your Cart
  $smallcartcontent = getCartContent();
  if(empty($smallcartcontent))
    $emptycart = 1;
  else
    $emptycart = 0;

  $userid = $vbulletin->userinfo['userid'];
  $navbits = construct_navbits(array("vbdigishop.php?" . $vbulletin->session->vars['sessionurl'] . ""=> $vbphrase['vbdigishop_navbar'], '' => $vbphrase['vbdigishop_goto_checkout']));
  eval('$navbar = "' . fetch_template('navbar') . '";');
  eval('$legalbit .= "' . fetch_template('vbdigishop_legalbit') . '";');
  eval('$gatewaysbit .= "' . fetch_template('vbdigishop_gatewaysbit') . '";');
  eval('print_output("' . fetch_template('vbdigishop_cart') . '");');
}

if ($_REQUEST['do'] == 'checkout') {

  if(!($permissions['vbdigishop'] & $vbulletin->bf_ugp['vbdigishop']['canorder'])){
      print_no_permission();
  }

  $privacy = $vbulletin->options['vbdigishop_privacy'];
  $licence = $vbulletin->options['vbdigishop_licence'];
  $refund = $vbulletin->options['vbdigishop_refund'];
  $defcolor = $vbulletin->options['vbdigishop_defcolor'];
  $currency = $vbulletin->options['vbdigishop_currency'];
  $bundles = $vbulletin->options['vbdigishop_bundle'];
  $userid = $vbulletin->userinfo['userid'];
  $items = $db->query_read("
    SELECT ".TABLE_PREFIX."vbdigishop_carts.discount,
      ".TABLE_PREFIX."vbdigishop_carts.count,
      ".TABLE_PREFIX."vbdigishop_products.*
    FROM ".TABLE_PREFIX."vbdigishop_carts
    JOIN ".TABLE_PREFIX."vbdigishop_products ON productid=".TABLE_PREFIX."vbdigishop_products.id
    WHERE userid=$userid
    ORDER BY ".TABLE_PREFIX."vbdigishop_products.name ASC");

  $cartitems = "";
  $totalprice = 0;
  while($product = $db->fetch_array($items)) {
    $quantityoptions = getQuantityOptions($product["count"]);
    $price = ($product["discount"] == 1 || $vbulletin->options['vbdigishop_bundlecat'] == $product["category"]) 
        ? $product["discountprice"] : $product["price"];
    $total = $product["count"] * doubleval($price);
    $totalprice += $total;
    $total = number_format($total, 2);
    eval('$cartitems .= "' . fetch_template('vbdigishop_cartitemreview') . '";');
  }

  if($totalprice == 0 && $db->num_rows($items) > 0) {
    $transid = md5(rand());
    $totalprice = moveCartItemsToBought($transid, $userid, 1);
    
    $vbulletin->url = "vbdigishop.php?do=download";
    standard_redirect();    
  }

  $totalprice = number_format($totalprice, 2);

  // Get Categories
  list($vcategories, $hcategories) = getCategories();

  // Special Bundles
  if ($vbulletin->options['vbdigishop_bundle'])
    $bundlesbit = getSpecialBundles();

  // Best Seller
  $bestsellerbit = getBestSeller();

  // Newest Product
  $newestbit = getNewestProduct();

  // Upcoming Product
  $upcomingbit = getUpcomingProduct();

  // Your Cart
  $smallcartcontent = getCartContent();
  if(empty($smallcartcontent))
    $emptycart = 1;
  else
    $emptycart = 0;

  $userid = $vbulletin->userinfo['userid'];
  $navbits = construct_navbits(array("vbdigishop.php?" . $vbulletin->session->vars['sessionurl'] . ""=> $vbphrase['vbdigishop_navbar'], '' => $vbphrase['vbdigishop_pay_now']));
  eval('$navbar = "' . fetch_template('navbar') . '";');
  eval('$legalbit .= "' . fetch_template('vbdigishop_legalbit') . '";');
  eval('$gatewaysbit .= "' . fetch_template('vbdigishop_gatewaysbit') . '";');
  eval('print_output("' . fetch_template('vbdigishop_payment') . '");');
}

function moveCartItemsToBought($transid, $userid, $paid)
{
  global $db, $vbulletin;
  
  $items = $db->query_read("
    SELECT ".TABLE_PREFIX."vbdigishop_carts.discount,
      ".TABLE_PREFIX."vbdigishop_carts.count,
      ".TABLE_PREFIX."vbdigishop_products.*
    FROM ".TABLE_PREFIX."vbdigishop_carts
    JOIN ".TABLE_PREFIX."vbdigishop_products ON productid=".TABLE_PREFIX."vbdigishop_products.id
    WHERE userid=$userid
    ORDER BY ".TABLE_PREFIX."vbdigishop_products.name ASC");

  $totalprice = 0;
  if($paid) {
    $paiddate = date("Y-m-d");
    $gateway = 4;
  } else {
    $paiddate = "0000-00-00";
    $gateway = 0;
  }
  while($product = $db->fetch_array($items)) {
    $discount = $product["discount"];
    $singleprice = ($discount == 1 || $vbulletin->options['vbdigishop_bundlecat'] == $product["category"])
        ? $product["discountprice"] : $product["price"];
    $price = $product["count"] * doubleval($singleprice);
    $totalprice += $price;

    $id = $product["id"];
    for($i = 0; $i < $product["count"]; $i++) {
      $db->query_write("INSERT INTO ".TABLE_PREFIX."vbdigishop_boughtproducts
        (userid, productid, price, transid, boughtdate, paiddate, paid, discount, gateway) VALUES
        ($userid, $id, $singleprice, '$transid', NOW(), $paiddate, $paid, $discount, $gateway)");
    }
  }
  $db->query_write("DELETE FROM ".TABLE_PREFIX."vbdigishop_carts WHERE userid=$userid");
  $db->query_write("INSERT INTO ".TABLE_PREFIX."mbm_payments (id, script, function) VALUES
    ('$transid', '/vbdigishop/finishpayment.php', '')");

  return $totalprice;
}

if ($_REQUEST['do'] == 'pay') {

  if(!($permissions['vbdigishop'] & $vbulletin->bf_ugp['vbdigishop']['canorder'])){
      print_no_permission();
  }

  $privacy = $vbulletin->options['vbdigishop_privacy'];
  $licence = $vbulletin->options['vbdigishop_licence'];
  $refund = $vbulletin->options['vbdigishop_refund'];
  $defcolor = $vbulletin->options['vbdigishop_defcolor'];
  $currency = $vbulletin->options['vbdigishop_currency'];
  $bundles = $vbulletin->options['vbdigishop_bundle'];
  $userid = $vbulletin->userinfo['userid'];

  $transid = md5(rand());
  $totalprice = moveCartItemsToBought($transid, $userid, 0);

  $paypalemailaddress = $vbulletin->options["vbdigishop_paypal_email"];
  $currency = $vbulletin->options["vbdigishop_curr"];
  $method = $_REQUEST["pmethod"];
  if($method == 'paypal') {
    $finish = true;
    $testingmode = $vbulletin->options["vbdigishop_paypaltesting"];
  } else if($method == '2checkout') {
    $finish = true;
    $testingmode = $vbulletin->options["vbdigishop_2cotesting"];
  }
  
  require_once(DIR . '/vbdigishop/includes/mbmpayment.php');
  $vbulletin->url = paymentUrl($method, "Modules", 1, $totalprice, 0, 0, 0, $currency,
          $paypalemailaddress, $transid, $vbulletin->options['bburl'] . "/vbdigishop.php", $finish,
          $testingmode);

  standard_redirect();
}

if ($_REQUEST['do'] == '2coconfirm') {
  $transid = $_REQUEST["cart_order_id"];
  $db->query_write("UPDATE ".TABLE_PREFIX."vbdigishop_boughtproducts SET
    paid=1,
    paiddate=NOW(),
    gateway=2
    WHERE transid='$transid'");

  require_once(DIR.'/vbdigishop/digishop_functions.php');
  sendThankYouMail(-1, $transid);
  $userid = $vbulletin->userinfo['userid'];
  promoteUser($transid, $userid);

  $privacy = $vbulletin->options['vbdigishop_privacy'];
  $licence = $vbulletin->options['vbdigishop_licence'];
  $refund = $vbulletin->options['vbdigishop_refund'];
  $defcolor = $vbulletin->options['vbdigishop_defcolor'];
  $currency = $vbulletin->options['vbdigishop_currency'];

  $dlpageurl = $vbulletin->options["bburl"].'/vbdigishop.php?do=download';
  $baseurl = $vbulletin->options["bburl"];

  $userid = $vbulletin->userinfo['userid'];
  eval('$navbar = "' . fetch_template('navbar') . '";');
  eval('$legalbit .= "' . fetch_template('vbdigishop_legalbit') . '";');
  eval('$gatewaysbit .= "' . fetch_template('vbdigishop_gatewaysbit') . '";');
  eval('print_output("' . fetch_template('vbdigishop_thankyou') . '");');
}

if ($_REQUEST['do'] == '2coerror') {
  echo "error<br />";
}

function addLicense()
{
  global $db, $vbulletin;

  $bid = isset($_REQUEST['bid']) ? intval($_REQUEST['bid']) : -1;
  $domain = addslashes($_REQUEST["domain"]);
  $userid = $vbulletin->userinfo['userid'];
  $db->query_write("UPDATE ".TABLE_PREFIX."vbdigishop_boughtproducts
      SET domain='$domain'
      WHERE userid=$userid AND id=$bid");
}

if ($_REQUEST['do'] == 'download') {

  if(!($permissions['vbdigishop'] & $vbulletin->bf_ugp['vbdigishop']['canorder'])){
      print_no_permission();
  }

  // Get Licence Message
  ob_start();
  include('vbdigishop/includes/download.inc.php');
  $licencemessage = ob_get_contents();
  ob_end_clean();

  if($_REQUEST["action"] == 'addlicense')
    addLicense();

  $privacy = $vbulletin->options['vbdigishop_privacy'];
  $licence = $vbulletin->options['vbdigishop_licence'];
  $refund = $vbulletin->options['vbdigishop_refund'];
  $defcolor = $vbulletin->options['vbdigishop_defcolor'];
  $currency = $vbulletin->options['vbdigishop_currency'];

  // Get Categories
  list($vcategories, $hcategories) = getCategories();

  // Special Bundles
  if ($vbulletin->options['vbdigishop_bundle'])
    $bundlesbit = getSpecialBundles();

  // Best Seller
  $bestsellerbit = getBestSeller();

  // Newest Product
  $newestbit = getNewestProduct();

  // Upcoming Product
  $upcomingbit = getUpcomingProduct();

  // Your Cart
  $smallcartcontent = getCartContent();
  if(empty($smallcartcontent))
    $emptycart = 1;
  else
    $emptycart = 0;

  $userid = $vbulletin->userinfo['userid'];
  $products = $db->query_read("SELECT ".TABLE_PREFIX."vbdigishop_boughtproducts.domain,
      ".TABLE_PREFIX."vbdigishop_boughtproducts.boughtdate,
      ".TABLE_PREFIX."vbdigishop_boughtproducts.price AS boughtprice,
      ".TABLE_PREFIX."vbdigishop_boughtproducts.gateway,
      ".TABLE_PREFIX."vbdigishop_boughtproducts.id AS bid,
      ".TABLE_PREFIX."vbdigishop_products.*
    FROM ".TABLE_PREFIX."vbdigishop_boughtproducts
    JOIN ".TABLE_PREFIX."vbdigishop_products ON productid=".TABLE_PREFIX."vbdigishop_products.id
    WHERE userid=$userid AND paid=1
    ORDER BY name");

  $downloads = "";
  $dlcount = 0;
  while($product = $db->fetch_array($products)) {
    list($year, $month, $day) = split('-', $product["boughtdate"]);
    $date = "$day/$month/$year";
    $price = $product["boughtprice"];
    switch($product["gateway"]) {
    case 1: $gateway = 'PayPal'; break;
    case 2: $gateway = '2Checkout'; break;
    case 3: $gateway = 'iDeal'; break;
    case 4: $gateway = 'Free'; break;
    }
    $addeditlink = '<a href="vbdigishop.php?do=addlicense&id='.$product["bid"].'">';
    if(empty($product["domain"]))
      $addeditlink .= 'Submit URL';
    else
      $addeditlink .= 'Edit Licence';
    $addeditlink .= '</a>';
    eval('$downloads .= "' . fetch_template('vbdigishop_dlproduct') . '";');
    $dlcount++;
  }

  $userid = $vbulletin->userinfo['userid'];
  $navbits = construct_navbits(array("vbdigishop.php?" . $vbulletin->session->vars['sessionurl'] . ""=> $vbphrase['vbdigishop_navbar'], '' => $vbphrase['vbdigishop_my_orders']));
  eval('$navbar = "' . fetch_template('navbar') . '";');
  eval('$legalbit .= "' . fetch_template('vbdigishop_legalbit') . '";');
  eval('$gatewaysbit .= "' . fetch_template('vbdigishop_gatewaysbit') . '";');
  eval('print_output("' . fetch_template('vbdigishop_download') . '");');
}

if ($_REQUEST['do'] == 'addlicense') {
  $id = isset($_REQUEST['id']) ? intval($_REQUEST['id']) : -1;

  $privacy = $vbulletin->options['vbdigishop_privacy'];
  $licence = $vbulletin->options['vbdigishop_licence'];
  $refund = $vbulletin->options['vbdigishop_refund'];
  $defcolor = $vbulletin->options['vbdigishop_defcolor'];
  $currency = $vbulletin->options['vbdigishop_currency'];

  // Get Categories
  list($vcategories, $hcategories) = getCategories();

  // Special Bundles
  if ($vbulletin->options['vbdigishop_bundle'])
    $bundlesbit = getSpecialBundles();

  // Best Seller
  $bestsellerbit = getBestSeller();

  // Newest Product
  $newestbit = getNewestProduct();

  // Upcoming Product
  $upcomingbit = getUpcomingProduct();

  // Your Cart
  $smallcartcontent = getCartContent();
  if(empty($smallcartcontent))
    $emptycart = 1;
  else
    $emptycart = 0;

  $userid = $vbulletin->userinfo['userid'];
  $product = $db->query_first("SELECT ".TABLE_PREFIX."vbdigishop_boughtproducts.domain,
      ".TABLE_PREFIX."vbdigishop_products.name
    FROM ".TABLE_PREFIX."vbdigishop_boughtproducts
    JOIN ".TABLE_PREFIX."vbdigishop_products ON productid=".TABLE_PREFIX."vbdigishop_products.id
    WHERE userid=$userid AND ".TABLE_PREFIX."vbdigishop_boughtproducts.id=$id");

  if(empty($product["domain"]))
    $action = "Add";
  else
    $action = "Edit";

  $userid = $vbulletin->userinfo['userid'];
  $navbits = construct_navbits(array("vbdigishop.php?" . $vbulletin->session->vars['sessionurl'] . ""=> $vbphrase['vbdigishop_navbar'], '' => $vbphrase['vbdigishop_licence_edit']));
  eval('$navbar = "' . fetch_template('navbar') . '";');
  eval('$legalbit .= "' . fetch_template('vbdigishop_legalbit') . '";');
  eval('$gatewaysbit .= "' . fetch_template('vbdigishop_gatewaysbit') . '";');
  eval('print_output("' . fetch_template('vbdigishop_addlicense') . '");');
}

if ($_REQUEST['do'] == 'dl') {

  if(!($permissions['vbdigishop'] & $vbulletin->bf_ugp['vbdigishop']['canorder'])){
      print_no_permission();
  }

  $privacy = $vbulletin->options['vbdigishop_privacy'];
  $licence = $vbulletin->options['vbdigishop_licence'];
  $refund = $vbulletin->options['vbdigishop_refund'];
  $defcolor = $vbulletin->options['vbdigishop_defcolor'];
  $currency = $vbulletin->options['vbdigishop_currency'];
  $bundles = $vbulletin->options['vbdigishop_bundle'];

  $id = intval($_REQUEST["id"]);
  $userid = $vbulletin->userinfo['userid'];
  $product = $db->query_first("SELECT ".TABLE_PREFIX."vbdigishop_products.*
    FROM ".TABLE_PREFIX."vbdigishop_boughtproducts
    JOIN ".TABLE_PREFIX."vbdigishop_products ON productid=".TABLE_PREFIX."vbdigishop_products.id
    WHERE userid=$userid AND paid=1 AND productid=$id AND filename>''");

  if(empty($product)) exit;

  $fname = $product["filename"];
  $filePath = DIR.'/vbdigishop/products/'.$fname;

  $fsize = filesize($filePath);

  $mtype = '';
  // mime type is not set, get from server settings
  if (function_exists('mime_content_type')) {
    $mtype = mime_content_type($filePath);
  }
  else if (function_exists('finfo_file')) {
    $finfo = finfo_open(FILEINFO_MIME); // return mime type
    $mtype = finfo_file($finfo, $filePath);
    finfo_close($finfo);
  }
  if ($mtype == '') {
    $mtype = "application/force-download";
  }

  header("Pragma: public");
  header("Expires: 0");
  header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
  header("Cache-Control: public");
  header("Content-Description: File Transfer");
  header("Content-Type: $mtype");
  header("Content-Disposition: attachment; filename=\"$fname\"");
  header("Content-Transfer-Encoding: binary");
  header("Content-Length: " . $fsize);

  @readfile($filePath);
}

?>
