<?php
//#####################################################################################
//                                  vbdigishop Mod for vBulletin
//                      http://www.vbgreece.com/index.php?page=vbdigishop
//- ##################################################################################### -

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array(
	'vbdigishop',
	'style'
);

$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_template.php');
require_once(DIR . '/vbdigishop/digishop_functions.php');
require_once(DIR . '/includes/class_image.php');

print_cp_header();
?>

<script type="text/javascript">
function selectYear(box)
{
  var year = box.options[box.selectedIndex].value;
  
  window.location = 'vbdigishop_admin.php?do=sales&year=' + year;
}

function catChanged(box)
{
  var cat = box.options[box.selectedIndex].value;
  
  window.location = 'vbdigishop_admin.php?do=products&selcat=' + cat;
}

function subCatChanged(box)
{
  var subcat = box.options[box.selectedIndex].value;
  var cat = document.forms["cpform"].selcat.options[document.forms["cpform"].selcat.selectedIndex].value;

  window.location = 'vbdigishop_admin.php?do=products&selcat=' + cat + '&selsubcat=' + subcat;
}

function catChangedRel(box, id, type)
{
  var cat = box.options[box.selectedIndex].value;
  
  window.location = 'vbdigishop_admin.php?do=editrelated&selcat=' + cat + '&id=' + id + '&type=' + type;
}

function subCatChangedRel(box, id, type)
{
  var subcat = box.options[box.selectedIndex].value;
  var cat = document.forms["cpform"].selcat.options[document.forms["cpform"].selcat.selectedIndex].value;

  window.location = 'vbdigishop_admin.php?do=editrelated&selcat=' + cat + '&selsubcat=' + subcat + '&id=' + id + '&type=' + type;
}

function prodCatChanged(box)
{
  var cat = box.options[box.selectedIndex].value;
  var subs = document.forms["cpform"].subcategory;
  
  subs.options.length = 0;
  for(m = subs.options.length - 1; m > 0; m--)
    subs.options[m] = null;
  var idx = 0;
  for(n = 0; n < cats.length; n++)
    for(i = 0; i < cats[n].length; i++)
      if(cats[n][i][0] == cat) {
        subs.options[idx] = new Option(cats[n][i][1], cats[n][i][2]);
        idx++;
      }
  if(subs.options.length > 0)
    subs.options[0].selected = true;
}

function doAction(box, id)
{
  var val = box.options[box.selectedIndex].value;
  
  if(val == 1)
    window.location = 'vbdigishop_admin.php?do=edit&id=' + id;
  
  if(val == 2) {
    if(confirm('<?php echo $vbphrase["vbdigishop_deleteprodquestion"]; ?>'))
      window.location = 'vbdigishop_admin.php?do=products&action=delete&id=' + id;
  }

  if(val == 3)
    window.location = 'vbdigishop_admin.php?do=editrelated&type=addons&id=' + id;
  if(val == 4)
    window.location = 'vbdigishop_admin.php?do=editrelated&type=boughtalso&id=' + id;
  if(val == 5)
    window.location = 'vbdigishop_admin.php?do=editrelated&type=specials&id=' + id;
}

function catAction(box, id)
{
  var val = box.options[box.selectedIndex].value;
  
  if(val == 1)
    window.location = 'vbdigishop_admin.php?do=subcategories&catid=' + id;
  if(val == 2)
    window.location = 'vbdigishop_admin.php?do=editcat&catid=' + id;
  if(val == 3) {
    if(confirm('<?php echo $vbphrase["vbdigishop_deletecatquestion"]; ?>'))
      window.location = 'vbdigishop_admin.php?do=categories&action=deletecat&catid=' + id;
  }  
}

function subCatAction(box, id, catid)
{
  var val = box.options[box.selectedIndex].value;
  
  if(val == 1)
    window.location = 'vbdigishop_admin.php?do=editsubcat&subcatid=' + id + '&catid=' + catid;
  if(val == 2) {
    if(confirm('<?php echo $vbphrase["vbdigishop_deletesubcatquestion"]; ?>'))
      window.location = 'vbdigishop_admin.php?do=subcategories&action=deletesubcat&subcatid=' + id + '&catid=' + catid;
  }
}

<?php printCategoriesJavascript(); ?>
</script>

<?php

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'main';
}

function getrandid($length)
{
  if($length > 0) { 
    $rand_id="";
    for($i = 1; $i <= $length; $i++) {
      mt_srand((double)microtime() * 1000000);
      $num = mt_rand(1,36);
      $rand_id .= assign_rand_value($num);
    }
  }
  
  return $rand_id;
}

function findext($filename)
{
  $filename = strtolower($filename) ;
  $exts = split("[/\\.]", $filename) ;
  $exts = $exts[count($exts)-1];

  return $exts;
} 

function stripext($name)
{
  $ext = strrchr($name, '.');
  if($ext !== false)
    $name = substr($name, 0, -strlen($ext));

  return $name;
}

function saveProduct()
{
  global $db, $vbulletin;
  
  $id = isset($_REQUEST['id']) ? intval($_REQUEST['id']) : -1;
  $name = addslashes($_REQUEST['name']);
  $status = isset($_REQUEST['status']) ? intval($_REQUEST['status']) : -1;
  $code = addslashes($_REQUEST['code']);
  $category = isset($_REQUEST['category']) ? intval($_REQUEST['category']) : -1;
  $subcategory = isset($_REQUEST['subcategory']) ? intval($_REQUEST['subcategory']) : -1;
  $manufacturer = addslashes($_REQUEST['manufacturer']);
  $price = str_replace(',', '.', $_REQUEST["price"]);
  $discountprice = str_replace(',', '.', $_REQUEST['discountprice']);
  $shortdescription = addslashes($_REQUEST['shortdescription']);
  $fulldescription = addslashes($_REQUEST['fulldescription']);
  $featureslink = addslashes($_REQUEST['featureslink']);
  $demolink = addslashes($_REQUEST['demolink']);
  $dlperiod = isset($_REQUEST['dlperiod']) ? intval($_REQUEST['dlperiod']) : -1;
  $promousergroups = isset($_REQUEST["promousergroups"]) ? $_REQUEST["promousergroups"] : array();

  $productfileupd = "";
  $productfilename = "";
  if(!empty($_FILES["file"]["name"])) {
    if($_FILES["file"]["error"] == UPLOAD_ERR_OK) {
      @unlink(DIR . '/vbdigishop/products/' . $_FILES["file"]["name"]);
      $extension = findext($_FILES["file"]["name"]);
      $filename = stripext($_FILES["file"]["name"]); 
      $productfilename = $filename.'_'.getrandid(16).'.'.$extension;
      rename($_FILES["file"]["tmp_name"], DIR . '/vbdigishop/products/' . $productfilename);
      $productfileupd = ", filename='$productfilename'";
    } else {
	    print_stop_message('vbdigishop_couldnotuploadproductfile');
    }
  }
  $productimageupd = "";
  $productimagename = "";
  if(!empty($_FILES["image"]["name"])) {
    if($_FILES["image"]["error"] == UPLOAD_ERR_OK) {
      @unlink(DIR . '/vbdigishop/images/' . $_FILES["image"]["name"]);
      rename($_FILES["image"]["tmp_name"], DIR . '/vbdigishop/images/' . $_FILES["image"]["name"]);
      $productimagename = $_FILES["image"]["name"];
      $productimageupd = ", image='$productimagename'";
     
      $image = &vB_Image::fetch_library($vbulletin);
      $thumb = $image->fetch_thumbnail($productimagename, DIR . '/vbdigishop/images/' . $productimagename);
      @unlink(DIR . '/vbdigishop/images/thumb_' . $productimagename);
      @$file = fopen(DIR . '/vbdigishop/images/thumb_' . $productimagename, 'w');
      @fwrite($file, $thumb["filedata"]);
      @fclose($file);
    } else {
	    print_stop_message('vbdigishop_couldnotuploadimagefile');
    }
  }

  if($id == -1) {
    $db->query_write("INSERT INTO ". TABLE_PREFIX ."vbdigishop_products (id, name, code, category, 
      subcategory, status, manufacturer, price, discountprice, shortdescription, fulldescription,
      image, featureslink, demolink, dlperiod, filename) VALUES (NULL, '$name',
      '$code', $category, $subcategory, $status, '$manufacturer', '$price', '$discountprice',
      '$shortdescription', '$fulldescription', '$productimagename', '$featureslink', 
      '$demolink', 0, '$productfilename')");
    $id = $db->insert_id();  
  } else {
    $product = $db->query_first("SELECT filename FROM ".TABLE_PREFIX."vbdigishop_products WHERE id=$id");
    if($product["filename"] != $productfilename && !empty($productfilename))
      @unlink(DIR . '/vbdigishop/products/' . $product["filename"]);

    $db->query_write("UPDATE ". TABLE_PREFIX ."vbdigishop_products SET 
      name='$name', code='$code', category=$category, subcategory=$subcategory, status=$status,
      manufacturer='$manufacturer', price='$price', discountprice='$discountprice',
      shortdescription='$shortdescription', fulldescription='$fulldescription',
      featureslink='$featureslink', demolink='$demolink', dlperiod=0
      $productfileupd $productimageupd
      WHERE id=$id");
  }

  $groups = $db->query_read("SELECT groupid FROM ".TABLE_PREFIX."vbdigishop_product_promotion WHERE product=$id");
  $oldgroups = array();
  while($group = $db->fetch_array($groups))
    $oldgroups[] = $group["groupid"];

  $db->query_write("DELETE FROM ".TABLE_PREFIX."vbdigishop_product_promotion WHERE product=$id");
  foreach($promousergroups as $group)
    $db->query_write("INSERT INTO ".TABLE_PREFIX."vbdigishop_product_promotion (product, groupid)
        VALUES ($id, $group)");

  $diff = array_diff($promousergroups, $oldgroups);
  if(!empty($diff)) {
    $users = $db->query_read("
        SELECT ".TABLE_PREFIX."user.membergroupids, ".TABLE_PREFIX."user.userid 
        FROM ".TABLE_PREFIX."vbdigishop_boughtproducts
        JOIN ".TABLE_PREFIX."user 
          ON ".TABLE_PREFIX."vbdigishop_boughtproducts.userid=".TABLE_PREFIX."user.userid 
        WHERE productid=$id");
    while($user = $db->fetch_array($users)) {
      $groups = !empty($user["membergroupids"]) ? explode(',', $user["membergroupids"]) : array();
      $newgroups = array();
      foreach($groups as $group) {
        if(!in_array($group, $oldgroups))
          $newgroups[] = $group;
      }
      foreach($promousergroups as $group) {
        if(!in_array($group, $newgroups))
          $newgroups[] = $group;
      }

      $first = true;
      $groups = '';
      foreach($newgroups as $group) {
        if(!$first)
          $groups .= ',';
        $groups .= $group;
        $first = false;
      }
      $userid = $user["userid"];
      $db->query_write("UPDATE ".TABLE_PREFIX."user SET membergroupids='$groups' WHERE userid=$userid");
    }
  }  
}

function deleteProduct()
{
  global $db;
  
  $id = isset($_REQUEST['id']) ? intval($_REQUEST['id']) : -1;
  $prods = $db->query_read("SELECT filename, image FROM ". TABLE_PREFIX ."vbdigishop_products WHERE id=$id");
  $prod = $db->fetch_array($prods);

  $db->query_write("DELETE FROM ". TABLE_PREFIX ."vbdigishop_products WHERE id=$id");
  $db->query_write("DELETE FROM ". TABLE_PREFIX ."vbdigishop_addons WHERE prodid=$id");
  $db->query_write("DELETE FROM ". TABLE_PREFIX ."vbdigishop_specials WHERE prodid=$id");

  @unlink(DIR . '/vbdigishop/images/'.$prod["image"]);
  @unlink(DIR . '/vbdigishop/images/thumb_'.$prod["image"]);
  @unlink(DIR . '/vbdigishop/products/'.$prod["filename"]);
}

// #######################################################################
// ###################### START SHOW CATEGORIES ##########################
// #######################################################################
if ($_REQUEST['do'] == 'products') {
  if($_REQUEST['action'] == "edit")
    saveProduct();
  if($_REQUEST['action'] == "delete")
    deleteProduct();

  $selcat = isset($_REQUEST['selcat']) ? intval($_REQUEST['selcat']) : -1;
  $selsubcat = isset($_REQUEST['selsubcat']) ? intval($_REQUEST['selsubcat']) : -1;
  $searchtext = isset($_REQUEST['searchtext']) ? $_REQUEST['searchtext'] : '';  

  print_form_header('vbdigishop_admin', 'products');
	print_table_header($vbphrase["vbdigishop_products"], 7);
  ?>
  
  <tr valign="top">
  	<td class="alt1" colspan="7">
      <table cellpadding="4" cellspacing="0" border="0" align="center" width="100%" id="cpform_table">
        <tr valign="top">
  	      <td class="alt1">
            <?php echo $vbphrase["vbdigishop_search"]; ?>: <input type="text" class="bginput" name="searchtext" id="it_searchtext_1" value="" size="35" dir="ltr" tabindex="1" />
          </td>
  	      <td class="alt1" align="left">
            <?php echo $vbphrase["vbdigishop_category"]; ?>: <?php printCategoriesSelect($selcat, true, 'selcat', 'catChanged(this)'); ?>&nbsp;&nbsp;
            <?php echo $vbphrase["vbdigishop_subcategory"]; ?>: <?php printSubCategoriesSelect($selsubcat, $selcat, true, 'selsubcat', 'subCatChanged(this)'); ?>
          </td>
  	      <td class="alt1" align="left">
  	        <a href="vbdigishop_admin.php?do=edit&id=-1">[<?php echo $vbphrase["vbdigishop_addnewproduct"];?>]</a>
  	      </td>
        </tr>
      </table>
    </td>
  </tr>
  
<?php
	print_cells_row(array($vbphrase["vbdigishop_name"], $vbphrase["vbdigishop_code"], 
    $vbphrase["vbdigishop_category"], $vbphrase["vbdigishop_subcategory"], 
    $vbphrase["vbdigishop_price"], $vbphrase["vbdigishop_discountprice"], 
    $vbphrase["vbdigishop_actions"]), 1, 'tcat');

  $where = ' ';
  // FIXME: table prefixes
  if($selcat != -1 || $selsubcat != -1 || !empty($searchtext)) {
    $where = "WHERE ";
    if($selsubcat != -1) {
      $where .= "vbdigishop_products.subcategory=$selsubcat ";
    } else if($selcat != -1) {
      $where .= "vbdigishop_products.category=$selcat ";
    }
    if(!empty($searchtext)) {
      if(empty($where))
        $where = "WHERE ";
      else
        $where .= " && ";
      $where .= "MATCH(vbdigishop_products.name, vbdigishop_products.shortdescription, 
        vbdigishop_products.fulldescription) AGAINST ('$searchtext' IN BOOLEAN MODE) ";
    }
  }
  $products_get = $db->query_read("
      SELECT ". TABLE_PREFIX ."vbdigishop_products.*, 
          ". TABLE_PREFIX ."vbdigishop_categories.name AS catname, 
          ". TABLE_PREFIX ."vbdigishop_subcategories.name AS subcatname
      FROM ". TABLE_PREFIX ."vbdigishop_products
      JOIN ". TABLE_PREFIX ."vbdigishop_categories ON 
        ". TABLE_PREFIX ."vbdigishop_categories.id=". TABLE_PREFIX ."vbdigishop_products.category
      LEFT JOIN ". TABLE_PREFIX ."vbdigishop_subcategories ON 
        ". TABLE_PREFIX ."vbdigishop_subcategories.id=". TABLE_PREFIX ."vbdigishop_products.subcategory
      $where
      ORDER BY ". TABLE_PREFIX ."vbdigishop_categories.name ASC");

	while ($product = $db->fetch_array($products_get)) {
 		$cell[1] = "<b><a href=\"vbdigishop_admin.php?do=edit&id=".$product["id"]."\">".$product["name"]."</a></b>";
		$cell[2] = $product["code"];
		$cell[3] = $product["catname"];
		$cell[4] = $product["subcatname"];
		$cell[5] = $product["price"];
		$cell[6] = $product["discountprice"];
		$cell[7] = "<select class=\"bginput\" onChange=\"doAction(this, ".$product["id"].")\">
      <option value=\"0\">".$vbphrase["vbdigishop_selectaction"]."</option>
      <option value=\"1\">".$vbphrase["vbdigishop_edit"]."</option>
      <option value=\"2\">".$vbphrase["vbdigishop_delete"]."</option>
      <option value=\"3\">".$vbphrase["vbdigishop_editaddons"]."</option>
      <option value=\"5\">".$vbphrase["vbdigishop_editspecials"]."</option>
      </select>";

		print_cells_row($cell);
		unset($cell);
  }

  print_table_footer();
}

if ($_REQUEST['do'] == 'edit') {
  $id = isset($_REQUEST['id']) ? intval($_REQUEST['id']) : -1;

  if($id != -1) {
    $prod_get = $db->query_read("SELECT * FROM ". TABLE_PREFIX ."vbdigishop_products WHERE id=$id");
    $product = $db->fetch_array($prod_get);
    $label = $vbphrase["vbdigishop_edit"]." ".$product["name"];
  } else {
    $cats = $db->query_read("SELECT * FROM ". TABLE_PREFIX ."vbdigishop_categories ORDER BY name");
    $cat = $db->fetch_array($cats);

    $product = array("id" => -1, "name" => "", "code" => "", "category" => $cat["id"],
        "subcategory" => -1, "manufacturer" => "", "price" => "", "discountprice" => "",
        "shortdescription" => "", "fulldescription" => "", "image" => "",
        "featureslink" => "", "demolink" => "", "dlperiod" => 5, "filename" => "");
    $label = $vbphrase["vbdigishop_addnewproduct"];  
  }

  print_form_header('vbdigishop_admin', 'products', true);
	print_table_header($label, 2);
	echo '<input type="hidden" name="action" value="edit" />';
	echo '<input type="hidden" name="id" value="'.$id.'" />';

  print_input_row($vbphrase["vbdigishop_name"], "name", $product["name"], 30, 50);
  $states = array(array("id" => 1, "name" => "Active"), array("id" => 2, "name" => "Disabled"),
      array("id" => 3, "name" => "Upcoming")); ?>
  <tr valign="top">
	  <td class="alt1">Status</td>
	  <td class="alt1">
      <div id="ctrl_name">
        <?php printItemsSelect($states, $product["status"], false, "status", ""); ?>
      </div>
    </td>
  </tr>  
  <?php print_input_row($vbphrase["vbdigishop_code"], "code", $product["code"], 30, 30); ?>
  <tr valign="top">
	  <td class="alt1"><?php echo $vbphrase["vbdigishop_category"]; ?></td>
	  <td class="alt1">
      <div id="ctrl_name">
        <?php printCategoriesSelect($product["category"], false, "category", "prodCatChanged(this)"); ?>
      </div>
    </td>
  </tr>  
  <tr valign="top">
	  <td class="alt2"><?php echo $vbphrase["vbdigishop_subcategory"]; ?></td>
	  <td class="alt2">
      <div id="ctrl_name">
        <?php printSubCategoriesSelect($product["subcategory"], $product["category"], false, "subcategory", ""); ?>
      </div>
    </td>
  </tr> 
  <?php
  print_input_row($vbphrase["vbdigishop_manufacturer"], "manufacturer", $product["manufacturer"], 30, 50);
  print_input_row($vbphrase["vbdigishop_price"], "price", $product["price"], 7, 7);
  print_input_row($vbphrase["vbdigishop_discountprice"], "discountprice", $product["discountprice"], 7, 7);
  print_textarea_row($vbphrase["vbdigishop_shortdescription"], "shortdescription", $product["shortdescription"], 8, 60, false, false);
  print_textarea_row($vbphrase["vbdigishop_fulldescription"], "fulldescription", $product["fulldescription"], 8, 60, false, false);
  print_upload_row($vbphrase["vbdigishop_image"], "image");
  print_input_row($vbphrase["vbdigishop_featureslink"], "featureslink", $product["featureslink"], 30, 50);
  print_input_row($vbphrase["vbdigishop_demolink"], "demolink", $product["demolink"], 30, 50);
  print_upload_row($vbphrase["vbdigishop_productfile"], "file");
  
  $groups_get = $db->query_read("SELECT usergroupid, title 
                                 FROM ". TABLE_PREFIX ."usergroup
                                 WHERE usergroupid>8 
                                 ORDER BY usergroupid");
  $groups = array();
  while($group = $db->fetch_array($groups_get))
    $groups[] = $group;

  $groups_get = $db->query_read("SELECT groupid FROM ".TABLE_PREFIX."vbdigishop_product_promotion WHERE product=$id");  
  $selectedgroups = array();
  while($group = $db->fetch_array($groups_get))
    $selectedgroups[] = $group["groupid"];

  function isSelected($groups, $group)
  {
    foreach($groups as $gr)
      if($gr == $group)
        return true;
    return false;
  }
  ?>  
  <tr valign="top">
	  <td class="alt2"><?php echo $vbphrase["vbdigishop_promousergroup"]; ?></td>
	  <td class="alt2">
	    <select name="promousergroups[]" size="6" multiple>
        <?php 
          foreach($groups as $group) {
            $selected = isSelected($selectedgroups, $group["usergroupid"]) ? 'selected' : '';
            echo '<option value="'.$group["usergroupid"].'" '.$selected.' >'.$group["title"].'</option>';        
          }
        ?>
      </select>
    </td>
  </tr>
  <tr valign="top">
	  <td class="alt1"><?php echo $vbphrase["vbdigishop_productfilename"]; ?></td>
	  <td class="alt1"><?php echo $product["filename"]; ?></td>
  </tr>  
  <tr valign="top">
	  <td class="alt2"><?php echo $vbphrase["vbdigishop_productimage"]; ?></td>
	  <td class="alt2"><?php echo $product["image"];
      if(!empty($product["image"]))
        echo '<br /><img src="../vbdigishop/images/thumb_'. $product["image"] . '" />'; 
     ?></td>
  </tr> 
  <?php
  
  print_submit_row();
  print_table_footer();
}

function newCategory()
{
  global $db;
  
  $catname = $_REQUEST['catname'];
  $db->query_write("INSERT INTO ". TABLE_PREFIX ."vbdigishop_categories (id, name)
    VALUES (NULL, '$catname')");
  
  return $db->insert_id();
}

function newSubCategory($catid)
{
  global $db;
  
  $subcatname = $_REQUEST['subcatname'];
  $db->query_write("INSERT INTO ". TABLE_PREFIX ."vbdigishop_subcategories (id, category, name)
    VALUES (NULL, $catid, '$subcatname')");
  
  return $db->insert_id();
}

function deleteCategory($catid)
{
  global $db;
  
  $prods = $db->query_read("SELECT COUNT(*) AS cnt FROM ". TABLE_PREFIX ."vbdigishop_products
    WHERE category=$catid");
  $prodcnt = $db->fetch_array($prods);

  if($prodcnt["cnt"] > 0)
    print_stop_message('vbdigishop_cannotdeletecategory', $catid);
  else {
    $db->query_write("DELETE FROM ". TABLE_PREFIX ."vbdigishop_categories WHERE id=$catid");
    $db->query_write("DELETE FROM ". TABLE_PREFIX ."vbdigishop_subcategories WHERE category=$catid");
  }
}

function deleteSubCategory($subcatid)
{
  global $db;
  
  $prods = $db->query_read("SELECT COUNT(*) AS cnt FROM ". TABLE_PREFIX ."vbdigishop_products
    WHERE subcategory=$subcatid");
  $prodcnt = $db->fetch_array($prods);

  if($prodcnt["cnt"] > 0)
    print_stop_message('vbdigishop_cannotdeletesubcategory', $catid);
  else {
    $db->query_write("DELETE FROM ". TABLE_PREFIX ."vbdigishop_subcategories WHERE id=$subcatid");
  }
}

function editCategory($catid)
{
  global $db;
  
  $catname = $_REQUEST['catname'];

  $db->query_write("UPDATE ". TABLE_PREFIX ."vbdigishop_categories SET name='$catname' WHERE id=$catid");
}

function editSubCategory($subcatid)
{
  global $db;
  
  $subcatname = $_REQUEST['subcatname'];

  $db->query_write("UPDATE ". TABLE_PREFIX ."vbdigishop_subcategories SET name='$subcatname' WHERE id=$subcatid");
}

function saveDisplayOrder()
{
  global $db;
  
  $display = $_REQUEST["display"];
  $keys = array_keys($display);
  foreach($keys as $idx) {
    $order = $display[$idx];
    $db->query_write("UPDATE ".TABLE_PREFIX."vbdigishop_categories SET display=$order WHERE id=$idx");  
  }
}

if ($_REQUEST['do'] == 'categories') {
  $catid = isset($_REQUEST['catid']) ? intval($_REQUEST['catid']) : -1;

  if($_REQUEST['action'] == "newcat")
    $catid = newCategory();
  if($_REQUEST['action'] == "editcat")
    editCategory($catid);
  if($_REQUEST['action'] == "deletecat") {
    deleteCategory($catid);
    $catid = -1;
  }
  if($_REQUEST['action'] == "save")
    saveDisplayOrder();

  print_form_header('vbdigishop_admin', 'categories', true);
	print_table_header($vbphrase["vbdigishop_categories"], 3);
	print_cells_row(array($vbphrase["vbdigishop_categoryname"], "Display", 
    $vbphrase["vbdigishop_actions"]), 1, 'tcat');

  $cats_query = $db->query_read("SELECT * FROM ". TABLE_PREFIX ."vbdigishop_categories ORDER BY display");
  while($cat = $db->fetch_array($cats_query)) {
    $cell[0] = $cat["name"];
		$cell[1] = '<input type="text" class="bginput" size="3" name="display['.$cat["id"].']" value="'.$cat["display"].'">';
    $cell[2] = '<select class="bginput" name="action" onChange="catAction(this, '.$cat["id"].')">
                  <option value="0">'.$vbphrase["vbdigishop_selectaction"].'</option>
                  <option value="1">'.$vbphrase["vbdigishop_editsubcategories"].'</option>
                  <option value="2">'.$vbphrase["vbdigishop_rename"].'</option>
                  <option value="3">'.$vbphrase["vbdigishop_delete"].'</option>
                </select>'; 
 		print_cells_row($cell);
  }
  print_cells_row(array('[<a href="vbdigishop_admin.php?do=newcat">'.$vbphrase["vbdigishop_newcategory"].'</a>]', '', ''));
  
	echo '<input type="hidden" name="action" value="save" />';
  print_table_footer(6, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"  Save  \" accesskey=\"s\" />");
}

if ($_REQUEST['do'] == 'editcat') {
  $catid = isset($_REQUEST['catid']) ? intval($_REQUEST['catid']) : -1;

  print_form_header('vbdigishop_admin', 'categories', true);
	print_table_header($vbphrase["vbdigishop_editcategory"], 2);

  $cats = $db->query_read("SELECT * FROM ". TABLE_PREFIX ."vbdigishop_categories WHERE id=$catid");
  $cat = $db->fetch_array($cats);

	echo '<input type="hidden" name="action" value="editcat" />';
	echo '<input type="hidden" name="catid" value="'.$catid.'" />';
  print_input_row($vbphrase["vbdigishop_categoryname"], "catname", $cat["name"], 30, 50);

  print_submit_row();
  print_table_footer();
}

if ($_REQUEST['do'] == 'subcategories') {
  $catid = isset($_REQUEST['catid']) ? intval($_REQUEST['catid']) : -1;
  $subcatid = isset($_REQUEST['subcatid']) ? intval($_REQUEST['subcatid']) : -1;

  if($_REQUEST['action'] == "deletesubcat") {
    deleteSubCategory($subcatid);
    $subcatid = -1;
  }
  if($_REQUEST['action'] == "newsubcat")
    $subcatid = newSubCategory($catid);
  if($_REQUEST['action'] == "editsubcat")
    $subcatid = editSubCategory($subcatid);

  print_form_header('vbdigishop_admin', 'subcategories', true);
	print_table_header($vbphrase["vbdigishop_subcategories"], 3);

  $subcats_query = $db->query_read("SELECT * FROM ". TABLE_PREFIX ."vbdigishop_subcategories
      WHERE category=$catid
      ORDER BY name");
  while($subcat = $db->fetch_array($subcats_query)) {
    $cell[0] = $subcat["name"];
    $cell[1] = '';
    $cell[2] = '<select class="bginput" name="action" onChange="subCatAction(this, '.$subcat["id"].', '.$catid.')">
                  <option value="0">'.$vbphrase["vbdigishop_selectaction"].'</option>
                  <option value="1">'.$vbphrase["vbdigishop_rename"].'</option>
                  <option value="2">'.$vbphrase["vbdigishop_delete"].'</option>
                </select>'; 
 		print_cells_row($cell);
  }
  print_cells_row(array('[<a href="vbdigishop_admin.php?do=newsubcat&catid='.$catid.'">'.$vbphrase["vbdigishop_newsubcategory"].'</a>]', '', ''));

  print_table_footer();
}

if ($_REQUEST['do'] == 'editsubcat') {
  $catid = isset($_REQUEST['catid']) ? intval($_REQUEST['catid']) : -1;
  $subcatid = isset($_REQUEST['subcatid']) ? intval($_REQUEST['subcatid']) : -1;

  print_form_header('vbdigishop_admin', 'subcategories', true);
	print_table_header($vbphrase["vbdigishop_editsubcategory"], 2);

  $subcats = $db->query_read("SELECT * FROM ". TABLE_PREFIX ."vbdigishop_subcategories WHERE id=$subcatid");
  $subcat = $db->fetch_array($subcats);

	echo '<input type="hidden" name="action" value="editsubcat" />';
	echo '<input type="hidden" name="catid" value="'.$catid.'" />';
	echo '<input type="hidden" name="subcatid" value="'.$subcatid.'" />';
  print_input_row($vbphrase["vbdigishop_subcategoryname"], "subcatname", $subcat["name"], 30, 50);

  print_submit_row();
  print_table_footer();
}

if ($_REQUEST['do'] == 'newcat') {
  print_form_header('vbdigishop_admin', 'categories', true);
	print_table_header($vbphrase["vbdigishop_newcategory"], 2);

	echo '<input type="hidden" name="action" value="newcat" />';
  print_input_row($vbphrase["vbdigishop_categoryname"], "catname", "", 30, 50);

  print_submit_row();
  print_table_footer();
}

if ($_REQUEST['do'] == 'newsubcat') {
  $catid = isset($_REQUEST['catid']) ? intval($_REQUEST['catid']) : -1;

  print_form_header('vbdigishop_admin', 'subcategories', true);
	print_table_header($vbphrase["vbdigishop_newsubcategory"], 2);

	echo '<input type="hidden" name="action" value="newsubcat" />';
	echo '<input type="hidden" name="catid" value="'.$catid.'" />';
  print_input_row($vbphrase["vbdigishop_subcategoryname"], "subcatname", "", 30, 50);

  print_submit_row();
  print_table_footer();
}

function addRelated($id, $relid, $type)
{
  global $db;
  
  $db->query_write("INSERT INTO ". TABLE_PREFIX ."vbdigishop_$type (relid, prodid, relprodid)
    VALUES (NULL, $id, $relid)");
}

function deleteRelated($relid, $type)
{
  global $db;
  
  $db->query_write("DELETE FROM ". TABLE_PREFIX ."vbdigishop_$type WHERE relid=$relid");
}

if ($_REQUEST['do'] == 'editrelated') {
  $id = isset($_REQUEST['id']) ? intval($_REQUEST['id']) : -1;
  $type = $_REQUEST["type"];
  $selcat = isset($_REQUEST['selcat']) ? intval($_REQUEST['selcat']) : -1;
  $selsubcat = isset($_REQUEST['selsubcat']) ? intval($_REQUEST['selsubcat']) : -1;
  $searchtext = isset($_REQUEST['searchtext']) ? $_REQUEST['searchtext'] : '';
  
  if($_REQUEST["action"] == "add") {
    $relid = isset($_REQUEST['relid']) ? intval($_REQUEST['relid']) : -1;
    addRelated($id, $relid, $type);
  }
  if($_REQUEST["action"] == "delete") {
    $relid = isset($_REQUEST['relid']) ? intval($_REQUEST['relid']) : -1;
    deleteRelated($relid, $type);
  }
    
  $products_get = $db->query_read("
      SELECT ". TABLE_PREFIX ."vbdigishop_products.*, 
          ". TABLE_PREFIX ."vbdigishop_categories.name AS catname, 
          ". TABLE_PREFIX ."vbdigishop_subcategories.name AS subcatname
      FROM ". TABLE_PREFIX ."vbdigishop_products
      JOIN ". TABLE_PREFIX ."vbdigishop_categories ON 
        ". TABLE_PREFIX ."vbdigishop_categories.id=". TABLE_PREFIX ."vbdigishop_products.category
      LEFT JOIN ". TABLE_PREFIX ."vbdigishop_subcategories ON 
        ". TABLE_PREFIX ."vbdigishop_subcategories.id=". TABLE_PREFIX ."vbdigishop_products.subcategory
      WHERE ". TABLE_PREFIX ."vbdigishop_products.id=$id");
  $product = $db->fetch_array($products_get);
  
  $pageheader = $vbphrase["vbdigishop_related_$type-header"];
  $title = $vbphrase["vbdigishop_related_$type-title"];
  $select = $vbphrase["vbdigishop_related_$type-select"];

  print_form_header('vbdigishop_admin', 'editrelated', true);
  echo '<input type="hidden" name="type" value="'.$type.'" />';
  echo '<input type="hidden" name="id" value="'.$id.'" />';
  
	print_table_header($pageheader, 7); ?>
  <tr valign="top">
    <td class="alt1" colspan="7">
      <table width="100%">
        <tr>
          <td colspan="3">
            <h3><?php echo $vbphrase["vbdigishop_product"].': <em>'.$product["name"].'</em>'; ?></h3>
          </td>
        </tr>
        <tr>
          <td><?php echo $vbphrase["vbdigishop_code"].': '.$product["code"]; ?></td>
          <td><?php echo $vbphrase["vbdigishop_category"].': '.$product["catname"]; ?></td>
          <td><?php echo $vbphrase["vbdigishop_subcategory"].': '.$product["subcatname"]; ?></td>
        </tr>
        <tr>
          <td><?php echo $vbphrase["vbdigishop_price"].': '.$product["price"]; ?></td>
          <td><?php echo $vbphrase["vbdigishop_discountprice"].': '.$product["discountprice"]; ?></td>
          <td><?php echo $vbphrase["vbdigishop_manufacturer"].': '.$product["manufacturer"]; ?></td>
        </tr>
      </table>
    </td>
	</tr>
  <?php
	print_table_header($title, 7);
	$relprods = $db->query_read("
    SELECT ". TABLE_PREFIX ."vbdigishop_$type.relid,
        ". TABLE_PREFIX ."vbdigishop_products.*,
        ". TABLE_PREFIX ."vbdigishop_categories.name AS catname, 
        ". TABLE_PREFIX ."vbdigishop_subcategories.name AS subcatname
    FROM ". TABLE_PREFIX ."vbdigishop_$type
    JOIN ". TABLE_PREFIX ."vbdigishop_products ON 
        ". TABLE_PREFIX ."vbdigishop_products.id=". TABLE_PREFIX ."vbdigishop_$type.relprodid
    JOIN ". TABLE_PREFIX ."vbdigishop_categories ON 
        ". TABLE_PREFIX ."vbdigishop_categories.id=". TABLE_PREFIX ."vbdigishop_products.category
    LEFT JOIN ". TABLE_PREFIX ."vbdigishop_subcategories ON 
        ". TABLE_PREFIX ."vbdigishop_subcategories.id=". TABLE_PREFIX ."vbdigishop_products.subcategory
    WHERE ". TABLE_PREFIX ."vbdigishop_$type.prodid=$id
    ORDER BY ". TABLE_PREFIX ."vbdigishop_products.name");
  $cnt = 0;
	print_cells_row(array($vbphrase["vbdigishop_name"], $vbphrase["vbdigishop_code"], 
    $vbphrase["vbdigishop_category"], $vbphrase["vbdigishop_subcategory"], 
    $vbphrase["vbdigishop_price"], $vbphrase["vbdigishop_discountprice"], 
    $vbphrase["vbdigishop_actions"]), 1, 'tcat');
  while($prod = $db->fetch_array($relprods)) {
 		$cell[1] = "<b>".$prod["name"]."</b>";
		$cell[2] = $prod["code"];
		$cell[3] = $prod["catname"];
		$cell[4] = $prod["subcatname"];
		$cell[5] = $prod["price"];
		$cell[6] = $prod["discountprice"];
		$cell[7] = '[<a href="vbdigishop_admin.php?do=editrelated&action=delete&id='.$id.'&type='.$type.'&relid='.$prod["relid"].'&selcat='.$selcat.'&selsubcat='.$selsubcat.'&searchtext='.$searchtext.'">'.$vbphrase["vbdigishop_remove"].'</a>]';

		print_cells_row($cell);
		unset($cell);
  
    $cnt++;
  }
  if($cnt == 0) {
		print_cells_row(array($vbphrase["vbdigishop_empty"], "", "", "", "", "", ""));
  }
	
	print_table_header($select, 7);
	?>
  
  <tr valign="top">
  	<td class="alt1" colspan="7">
      <table cellpadding="4" cellspacing="0" border="0" align="center" width="100%" id="cpform_table">
        <tr valign="top">
  	      <td class="alt1">
            <?php echo $vbphrase["vbdigishop_search"]; ?>: <input type="text" class="bginput" name="searchtext" id="it_searchtext_1" value="" size="35" dir="ltr" tabindex="1" />
          </td>
  	      <td class="alt1" align="left">
            <?php echo $vbphrase["vbdigishop_category"]; ?>: <?php printCategoriesSelect($selcat, true, 'selcat', 'catChangedRel(this, '.$id.', \''.$type.'\')'); ?>&nbsp;&nbsp;
            <?php echo $vbphrase["vbdigishop_subcategory"]; ?>: <?php printSubCategoriesSelect($selsubcat, $selcat, true, 'selsubcat', 'subCatChangedRel(this, '.$id.', \''.$type.'\')'); ?>
          </td>
        </tr>
      </table>
    </td>
  </tr>
  
<?php
	print_cells_row(array($vbphrase["vbdigishop_name"], $vbphrase["vbdigishop_code"], 
    $vbphrase["vbdigishop_category"], $vbphrase["vbdigishop_subcategory"], 
    $vbphrase["vbdigishop_price"], $vbphrase["vbdigishop_discountprice"], 
    $vbphrase["vbdigishop_actions"]), 1, 'tcat');

  $where = '';
  if($selcat != -1 || $selsubcat != -1 || !empty($searchtext)) {
    $where = "WHERE ";
    if($selsubcat != -1) {
      $where .= "vbdigishop_products.subcategory=$selsubcat && ";
    } else if($selcat != -1) {
      $where .= "vbdigishop_products.category=$selcat && ";
    }
    if(!empty($searchtext)) {
      if(empty($where))
        $where = "WHERE ";
      $where .= "MATCH(vbdigishop_products.name, vbdigishop_products.shortdescription, 
        vbdigishop_products.fulldescription) AGAINST ('$searchtext' IN BOOLEAN MODE) && ";
    }
  }
  if(empty($where))
    $where = "WHERE ";
  $products_get = $db->query_read("
      SELECT ". TABLE_PREFIX ."vbdigishop_products.*, 
          ". TABLE_PREFIX ."vbdigishop_categories.name AS catname, 
          ". TABLE_PREFIX ."vbdigishop_subcategories.name AS subcatname
      FROM ". TABLE_PREFIX ."vbdigishop_products
      JOIN ". TABLE_PREFIX ."vbdigishop_categories ON 
        ". TABLE_PREFIX ."vbdigishop_categories.id=". TABLE_PREFIX ."vbdigishop_products.category
      LEFT JOIN ". TABLE_PREFIX ."vbdigishop_subcategories ON 
        ". TABLE_PREFIX ."vbdigishop_subcategories.id=". TABLE_PREFIX ."vbdigishop_products.subcategory
      $where ". TABLE_PREFIX ."vbdigishop_products.id NOT IN
        (SELECT relprodid FROM ". TABLE_PREFIX ."vbdigishop_$type WHERE prodid=$id)
      ORDER BY ". TABLE_PREFIX ."vbdigishop_categories.name ASC");

	while ($prod = $db->fetch_array($products_get)) {
 		$cell[1] = "<b>".$prod["name"]."</b>";
		$cell[2] = $prod["code"];
		$cell[3] = $prod["catname"];
		$cell[4] = $prod["subcatname"];
		$cell[5] = $prod["price"];
		$cell[6] = $prod["discountprice"];
		$cell[7] = '[<a href="vbdigishop_admin.php?do=editrelated&action=add&id='.$id.'&type='.$type.'&relid='.$prod["id"].'&selcat='.$selcat.'&selsubcat='.$selsubcat.'&searchtext='.$searchtext.'">'.$vbphrase["vbdigishop_add"].'</a>]';

		print_cells_row($cell);
		unset($cell);
  }
	
  print_table_footer();
}

if ($_REQUEST['do'] == 'selectuser') {

  $username = addslashes($_REQUEST["username"]);
  $action = $_REQUEST["action"];

  print_form_header('vbdigishop_admin', 'selectuser');
	print_table_header("Select User", 2);
  ?>
  
  <tr valign="top">
  	<td class="alt1" colspan="7">
      <table cellpadding="4" cellspacing="0" border="0" align="center" width="100%" id="cpform_table">
        <tr valign="top">
  	      <td class="alt1">
            <?php echo $vbphrase["vbdigishop_search"]; ?>: <input type="text" class="bginput" name="username" id="it_searchtext_1" value="" size="35" dir="ltr" tabindex="1" />
          </td>
        </tr>
      </table>
    </td>
  </tr>
  
<?php
	print_cells_row(array("User Name", "Email"), 1, 'tcat');

  $users = $db->query_read("SELECT userid, username, email FROM ".TABLE_PREFIX."user
      WHERE username LIKE '%$username%'");
  
	while ($user = $db->fetch_array($users)) {
 		$cell[1] = "<b><a href=\"vbdigishop_admin.php?do=$action&userid=".$user["userid"]."\">".$user["username"]."</a></b>";
		$cell[2] = $user["email"];

		print_cells_row($cell);
		unset($cell);
  }

  print_table_footer();
}

function addOrder($userid, $productid)
{
  global $db;
  
  $price = str_replace(',', '.', $_REQUEST["price"]);
  list($day, $month, $year) = split('/', $_REQUEST["date"]);
  $date = "$year-$month-$day";
  $gateway = intval($_REQUEST["gateway"]);
  $transid = $_REQUEST["invoice"];
  
  $error = '';
  if(empty($transid))
    $error .= "Invoice Number can not be empty<br />";
  if(empty($day) || empty($month) || empty($year))
    $error .= "Date has wrong format (should be dd/mm/yy)<br />";
  if(empty($price) || !is_numeric($price))
    $error .= "Price has wring format (should be xx.xx)<br />";
    
  if(!empty($error))
    return $error;
  
  $db->query_write("INSERT INTO ".TABLE_PREFIX."vbdigishop_boughtproducts (userid, productid,
      price, transid, boughtdate, paiddate, paid, discount, gateway) VALUES ($userid, $productid, '$price',
      '$transid', '$date', NOW(), 1, 0, $gateway)");

  promoteUser($transid, $userid);
  
  return '';
}

if ($_REQUEST['do'] == 'addorder') {

  $userid = isset($_REQUEST['userid']) ? intval($_REQUEST['userid']) : -1;
  $user = $db->query_first("SELECT username, email FROM ".TABLE_PREFIX."user WHERE userid=$userid");
  $productid = isset($_REQUEST['productid']) ? intval($_REQUEST['productid']) : -1;
  
  $error = '';
  if($_REQUEST["action"] == 'addorder')
    $error = addOrder($userid, $productid);
  if($_REQUEST["action"] == 'delete')
    $db->query_write("DELETE FROM ".TABLE_PREFIX."vbdigishop_boughtproducts WHERE id=$productid");
  
  echo '<script language="JavaScript" src="cal/calendar2.js"></script>
    <script src="js/prototype.js" type="text/javascript"></script>
    <script src="js/scriptaculous.js" type="text/javascript"></script>';
  
  print_form_header('vbdigishop_admin', 'addorder', true);
	echo '<input type="hidden" name="do" value="addorder" />';
	echo '<input type="hidden" name="action" value="addorder" />';
	echo '<input type="hidden" name="userid" value="'.$userid.'" />';
	echo '<input type="hidden" name="productid" value="'.$productid.'" />';

  if(empty($error)) {
    $prodid = -1;
    $price = '';
    $date = '';
    $transid = '';
  } else {
    $prodid = $productid;
    $price = $_REQUEST["price"];
    $date = $_REQUEST["date"];
    $transid = $_REQUEST["invoice"];
  }

	print_table_header("Products bought by User", 6); ?>
  <tr valign="top">
    <td class="alt1" colspan="6">
      <table width="100%">
        <tr>
          <td>
            User: &nbsp;<input class="bginput" type="text" id="auto" name="user" size="30" value="<?php echo $user["username"];?>" />
            <div id="list" class="autocomplete"></div>
          </td>
        </tr>
      </table>
    </td>
	</tr>
  <?php
  if($userid != -1) {
  	print_table_header("New Order", 6); ?>
    <tr valign="top">
      <td class="alt2" colspan="6">
        <table width="100%">
          <?php if(!empty($error)) { ?>
          <tr>
            <td colspan="2">
              <h3><?php echo $error; ?></h3>
            </td>
          </tr>
          <?php } ?>
          <tr>
            <td>
              <b>Product:</b>
            </td>
            <td>
            <?php
              $products_q = $db->query_read("SELECT * FROM ".TABLE_PREFIX."vbdigishop_products ORDER BY name");
              $products = array();
              while($prod = $db->fetch_array($products_q))
                $products[] = $prod;
              printItemsSelect($products, $prodid, false, "productid", "");
            ?>
            </td>
          </tr>
          <tr>
            <td>
              <b>Price:</b>
            </td>
            <td>
              <input name="price" value="<?php echo $price; ?>" class="bginput" />
            </td>
          </tr>
          <tr>
            <td>
              <b>Date:</b>
            </td>
            <td>
              <input name="date" value="<?php echo $date; ?>" class="bginput" />
              <a href="javascript:cal.popup();"><img src="img/cal.gif" width="16" height="16" border="0" alt="Click Here to Pick up the date"></a>
            </td>
          </tr>
          <tr>
            <td>
              <b>Payment Gateway:</b>
            </td>
            <td>
            <?php
              $gateways = array(array("id" => 1, "name" => "PayPal"), array("id" => 2, "name" => "2 Checkout"));
              printItemsSelect($gateways, -1, false, "gateway", "");
            ?>
            </td>
          </tr>
          <tr>
            <td>
              <b>Invoice Number:</b>
            </td>
            <td>
              <input name="invoice" value="<?php echo $transid; ?>" class="bginput" />
            </td>
          </tr>
          <tr>
            <td>
              <input type="submit" class="bginput" value="Add" />
            </td>
          </tr>
        </table>
      </td>
  	</tr>
    <?php
  	print_table_header("Bought Products", 6);
  	print_cells_row(array("Product Name", "Price", "Date", "Invoice", "Gateway", "Action"), 1, 'tcat');
  	
  	$products = $db->query("SELECT ".TABLE_PREFIX."vbdigishop_boughtproducts.price AS boughtprice, 
            boughtdate, ".TABLE_PREFIX."vbdigishop_products.name, transid,
            ".TABLE_PREFIX."vbdigishop_boughtproducts.id AS prodid, gateway
  	    FROM ".TABLE_PREFIX."vbdigishop_boughtproducts
        JOIN ".TABLE_PREFIX."vbdigishop_products ON productid=".TABLE_PREFIX."vbdigishop_products.id
        WHERE userid=$userid
        ORDER BY transid, ".TABLE_PREFIX."vbdigishop_products.name");
  	while ($product = $db->fetch_array($products)) {
   		$cell[1] = "<b>".$product["name"]."</b>";
  		$cell[2] = $product["boughtprice"];
  		list($year, $month, $day) = split('-', $product["boughtdate"]);
  		$cell[3] = "$day/$month/$year";
      $cell[4] = $product["transid"];
      $cell[5] = $product["gateway"] == 1 ? "PayPal" : "2 Checkout";
      $cell[6] = '<a href="vbdigishop_admin.php?do=addorder&action=delete&productid='.$product["prodid"].'&userid='.$userid.'">Delete</a>';
      
  		print_cells_row($cell);
  		unset($cell);
    }
  }
    
  print_table_footer();
  echo '<script language="JavaScript">';
  if($userid != -1) {
    echo 'var cal = new calendar2(document.forms["cpform"].elements["date"]);
				cal.year_scroll = false;
				cal.time_comp = false;';
	}
	echo 'new Ajax.Autocompleter("auto", "list", "vbdigishop_users.php", {afterUpdateElement: updateId, paramName: name});
				function updateId(input, li)
        {
          document.forms["cpform"].userid.value = li.childNodes[1].firstChild.nodeValue;
          document.forms["cpform"].action.value = "selectuser";
          document.forms["cpform"].submit();
        }
			</script>
      <style type="text/css">      
        div.autocomplete {
        position:absolute;
        width:250px;
        background-color:white;
        color:black;
        border:1px solid #888;
        margin:0px;
        padding:0px;
      }
      div.autocomplete ul {
        list-style-type:none;
        margin:0px;
        padding:0px;
      }
      div.autocomplete ul li.selected { background-color: #ffb;}
      div.autocomplete ul li {
        list-style-type:none;
        display:block;
        margin:0;
        padding:2px;
        height:17px;
        cursor:pointer;
      }
      div.autocomplete ul li span.informal {
        display:none;
      }
    </style>';
}

if ($_REQUEST['do'] == 'sales') {

  $year = empty($_REQUEST["year"]) ? date('Y') : $_REQUEST["year"];
  $years = "";
  
  $now = intval(date('Y'));
  for($i = $now - 3; $i <= $now + 3; $i++) {
    $selected = '';
    if($i == intval($year))
      $selected = "selected";
    $years .= '<option value="'.$i.'" '.$selected.' >'.$i.'</option>';
  }
    
  $categories = $db->query_read("SELECT ".TABLE_PREFIX."vbdigishop_categories. *, 
      ".TABLE_PREFIX."vbdigishop_subcategories.id AS subid, 
      ".TABLE_PREFIX."vbdigishop_subcategories.name AS subname
    FROM ".TABLE_PREFIX."vbdigishop_categories
    LEFT JOIN ".TABLE_PREFIX."vbdigishop_subcategories ON category = ".TABLE_PREFIX."vbdigishop_categories.id
    ORDER BY name, subname");

  $cols = $db->num_rows($categories) + 2;
  print_form_header('vbdigishop_admin', 'products');
	print_table_header("Sales Report", $cols); ?>
  <tr valign="top">
    <td class="alt1" colspan="<?php echo $cols; ?>">
      <table width="100%">
        <tr>
          <td align="right">
            Sales for year: &nbsp;
            <select class="bginput" name="<?php echo $year; ?>" onChange="selectYear(this)">
              <?php echo $years; ?>
            </select>
          </td>
        </tr>
      </table>
    </td>
	</tr>
	
	<?php
	$headers = array("Month");
	$cats = array();
	while($cat = $db->fetch_array($categories)) {
	  $name = $cat["name"];
	  if(!empty($cat["subname"]))
	    $name .= ' - '.$cat["subname"];
    $headers[] = $name;
    $cats[] = array($cat["id"], $cat["subid"]);
  }
  $headers[] = "";
  print_cells_row($headers, 1, 'tcat');
  
  function salesForCategory($sales, $cat, $subcat)
  { 
    foreach($sales as $sale)
      if($sale["category"] == $cat)
        if($sale["subcategory"] == -1 || $sale["subcategory"] == $subcat)
        return $sale;
        
    return FALSE;
  }
  
  for($i = 1; $i <= 12; $i++) {
    $start = mktime(0, 0, 0, $i, 1, intval($year)); 
    $startdate = date('Y-m-d', $start);
    $end = mktime(0, 0, 0, $i + 1, 1, intval($year)); 
    $enddate = date('Y-m-d', $end);
    $cols = array(date('M', $start));

    $sales = $db->query("SELECT COUNT(".TABLE_PREFIX."vbdigishop_boughtproducts.id) AS count, 
          SUM(".TABLE_PREFIX."vbdigishop_boughtproducts.price) AS total,
          ".TABLE_PREFIX."vbdigishop_products.subcategory,
          ".TABLE_PREFIX."vbdigishop_products.category
        FROM ".TABLE_PREFIX."vbdigishop_boughtproducts
        JOIN ".TABLE_PREFIX."vbdigishop_products ON productid=".TABLE_PREFIX."vbdigishop_products.id
        WHERE paid=1 AND boughtdate>='$startdate' AND boughtdate<'$enddate'
        GROUP BY subcategory");
    $salesdata = array();
    while($sale = $db->fetch_array($sales))
      $salesdata[] = $sale;

    $idx = 2;
    foreach($cats as $cat) {
      $sale = salesForCategory($salesdata, $cat[0], $cat[1]);
      if($sale === FALSE)
        $cols[$idx++] = '0<br />0';
      else 
        $cols[$idx++] = $sale["count"].'<br />'.$sale["total"];
    }

    $cols[] = "";
    print_cells_row($cols);
    unset($cols);
  }

  print_table_footer();
}

print_cp_footer();
?>
