<?php
//VERSION 4.0-0.4 release candidate 1
// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('banning', 'cpuser');
// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_banning.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminipbans'))
{
    print_cp_no_permission();
}

// ############################# LOG ACTION ###############################
$vbulletin->input->clean_array_gpc('r', array(
	'userid' => TYPE_INT
));
log_admin_action();

print_cp_header("IP ban manager");

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'list';
}


if($_REQUEST['do'] == 'list')
{
	//list
	print_table_start();
	print_table_header("IP Bans", 8);
	print_cells_row(array("IP","Cidr","Banned by","Registration","exempt","Expires","Reason","Delete"));
	$q = $db->query("SELECT " . TABLE_PREFIX . "ipban.*," . TABLE_PREFIX . "user.username
                         FROM " . TABLE_PREFIX . "ipban
                         LEFT JOIN " . TABLE_PREFIX . "user ON " . TABLE_PREFIX . "ipban.setby = " . TABLE_PREFIX . "user.userid
			 WHERE (expires > unix_timestamp() OR expires = 0)");
	while ($row = $db->fetch_array($q))
	{
		$data = array();
		$data[] = long2ip($row['ip']);
		$data[] = "/" . $row['cidr'];
		$data[] = $row['username'];
		$data[] = ($row['registration']) ? 'Yes':'No';
		$data[] = ($row['exempt']) ? 'Yes':'No';
		$data[] = date("r",$row['expires']);
		$data[] = $row['reason'];
		$data[] = "<a href=\"?do=delete&ipbanid=".$row['ipbanid']."\">[Delete]</a>";
		print_cells_row($data);
		//echo long2ip($row['ip']) . " \n";
	}
	print_table_footer();
}

if($_REQUEST['do'] == 'tools')
{
	print_form_header('ipbans','whois');
	print_table_header("Whois");
	print_input_row("IP Address","ip","");
	print_submit_row();

	echo '<hr>';

	print_form_header('ipbans','testip');
	print_table_header("Test IP ban");
	print_input_row("IP Address","ip","");
	print_submit_row();
    
	echo '<hr>';

	print_form_header('ipbans','testuser');
	print_table_header("User ban checker (enter username or userid)");
	print_input_row("Username","username","");
	print_input_row("Userid","userid","");
	print_submit_row();

	echo '<hr>';

	print_form_header('ipbans','cidr');
	print_table_header("CIDR to range calculator");
	print_input_row("IP Address","ip","");
	print_input_row("CIDR","cidr","");
	print_submit_row();

	echo '<hr>';

	print_form_header('ipbans','range');
	print_table_header("Range to CIDR calculator");
	print_input_row("Starting IP Address","ip","");
	print_input_row("Ending IP Address","ip2","");
	print_input_row("Max Depth","depth","10");
	print_submit_row();
}

if($_REQUEST['do'] == 'range')
{
	$vbulletin->input->clean_array_gpc('p', array('ip' => TYPE_NOHTML,'ip2' => TYPE_NOHTML,'depth' => TYPE_UINT));
	$ip=ip2long($vbulletin->GPC['ip']);
	$ip2=ip2long($vbulletin->GPC['ip2']);
	$maxdepth=$vbulletin->GPC['depth'];
	$bans = array();

//printf('%032b<br />',$ip);
//printf('%032b<br />',$ip2);
	$type = 'ban';

	function makeban($start,$end,$type,$depth)
	{
		global $bans,$maxdepth;
		$s=$start;
		$e = $end;
		$test = ~($s^$e); //=> 1 where ips agree 0 where they disagree

//printf('%032b<br />',$test);
		$cidr = 0;
		while($test & 0x80000000)
		{
			$test = $test << 1;
			$cidr++;
		}
		$cidrmask = ((pow(2,$cidr) -1) << (32 - $cidr));
		$startip = $start & $cidrmask;
		$bans[] = array('ip'=>$startip,'cidr'=>$cidr,'type'=>$type);

		$endmask = 0xFFFFFFFF << (32 - $cidr);
		$endmask = $endmask >> 32;
		$endip = $startip | $endmask;

		$depth++;

		if($startip != $start && $depth < $maxdepth)
		{
			makeban($startip,$start,(($type=='ban')?'exempt':'ban'),$depth);
		}
		if($endip != $end && $depth < $maxdepth)
		{
			makeban($end,$endip,(($type=='ban')?'exempt':'ban'),$depth);
		}

		if($depth >= $maxdepth)
		{
			$bans[] = array('ip'=>'','cidr'=>'','type'=>'hit depth limit');
		}
	}

	makeban($ip,$ip2,$type,0);





	print_table_start();
	print_table_header("Range {$vbulletin->GPC['ip']} - {$vbulletin->GPC['ip2']}", 3);
	print_cells_row(array('IP','CIDR','Type'));
	foreach($bans AS $ban)
	{
		print_cells_row(array(long2ip($ban['ip']),$ban['cidr'],$ban['type']));
	}
	print_table_footer();

}

if($_REQUEST['do'] == 'cidr')
{
	$vbulletin->input->clean_array_gpc('p', array('ip' => TYPE_NOHTML,'cidr'=>TYPE_INT));
	/*if($vbulletin->GPC['cidr'] < 16)
	{
		$vbulletin->GPC['cidr'] = 16;
	}*/

	if($vbulletin->GPC['cidr'] > 32)
	{
		$vbulletin->GPC['cidr'] = 32;
	}

	if(strlen($vbulletin->GPC['reason'])<1)
	{
		$vbulletin->GPC['reason'] = "No Reason";
	}

	$ip=sprintf("%u",ip2long($vbulletin->GPC['ip']));
	$cidrmask = ((pow(2,$vbulletin->GPC['cidr']) -1) << (32 - $vbulletin->GPC['cidr'])); //nb only works with ipv4. for ipv6 changes need to be made.

	$startip = $ip & $cidrmask;
	$endmask = 0xFFFFFFFF << (32 - $vbulletin->GPC['cidr']);
	$endmask = $endmask >> 32;
	$endip = $startip | $endmask;
	print_table_start();
	print_table_header("CIDR range {$vbulletin->GPC['ip']}/{$vbulletin->GPC['cidr']}", 2);
	print_cells_row(array('Start','End'));
	print_cells_row(array(long2ip($startip),long2ip($endip)));
	print_table_footer();
}

if($_REQUEST['do'] == 'whois')
{
	$vbulletin->input->clean_array_gpc('p', array('ip' => TYPE_STR));
	$ip=escapeshellarg($vbulletin->GPC['ip']);
	echo '<pre>'.`whois $ip`.'</pre>';
}

if($_REQUEST['do'] == 'testuser')
{
 	//86.181.76.17
    $vbulletin->input->clean_array_gpc('p', array('userid' => TYPE_UINT,'username'=>TYPE_SQL));
	if($vbulletin->GPC['username'] != '')
	{
		$q = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user
                               WHERE username = '" . $db->escape_string(htmlspecialchars_uni($vbulletin->GPC['username'])) . "'");
		$userid = $q['userid'];
	}
	elseif($vbulletin->GPC['userid'])
	{
		$userid = $vbulletin->GPC['userid'];
	}
    else
    {
        print_cp_message('Please enter a username or a userid');
    }
    
    $q = $db->query_read(sprintf("SELECT DISTINCT ipaddress from ".TABLE_PREFIX."post WHERE userid = %d",$userid));
    print_table_start();
	print_table_header("IP Bans affecting userid: $userid", 8);
	print_cells_row(array("IP","Cidr","Banned by","Registration","exempt","Expires","Reason","Delete"));
    $done = array();
    while($row = $db->fetch_array($q))
    {
        $ip = ip2long($row['ipaddress']);
        $q2=$db->query("SELECT * FROM " . TABLE_PREFIX . "ipban
                      LEFT JOIN " . TABLE_PREFIX . "user ON " . TABLE_PREFIX . "ipban.setby = " . TABLE_PREFIX . "user.userid
                        where ip = ($ip & ((pow(2,`cidr`) - 1) << (32 - `cidr`)))
                        and (`expires` = 0 OR `expires` > " . TIMENOW . ")
                        ORDER BY cidr ASC
                        ");
        $reg = 0;
        $all = 0;
        while ($row = $db->fetch_array($q2))
        {
            if(!in_array($row['ipbanid'],$done))
            {
                $done[] = $row['ipbanid'];
                $data = array();
                $data[] = long2ip($row['ip']);
                $data[] = "/" . $row['cidr'];
                $data[] = $row['username'];
                $data[] = ($row['registration']) ? 'Yes':'No';
                $data[] = ($row['exempt']) ? 'Yes':'No';
                $data[] = date("r",$row['expires']);
                $data[] = $row['reason'];
                $data[] = "<a href=\"?do=delete&ipbanid=".$row['ipbanid']."\">[Delete]</a>";
                print_cells_row($data);
                //echo long2ip($row['ip']) . " \n";
                if($row['exempt'])
                {
                    $all = 0;
                    $reg = 0;
                }
                else
                {
                    $reg = 1;
                    if(!$row['registration'])
                    {
                        $all = 1;
                    }
                }
            }
            $ips[] = array('ip'=>long2ip($ip),'reg'=>$reg,'all'=>$all);
        }
    }
    print_table_footer();
    if(is_array($ips))
    {
        foreach($ips AS $ipaddress)
        {
            print_table_start();
            print_table_header("Status of $ipaddress[ip]", 2);
            print_cells_row(array('Registration',($ipaddress['reg']) ? 'Banned':'Allowed'));
            print_cells_row(array('Site',($ipaddress['all']) ? 'Banned':'Allowed'));
            print_table_footer();
        }
    }
}

if($_REQUEST['do'] == 'testip')
{
	$vbulletin->input->clean_array_gpc('p', array('ip' => TYPE_NOHTML));
	$ip = sprintf("%u",ip2long($vbulletin->GPC['ip']));
	print_table_start();
	print_table_header("IP Bans affecting {$vbulletin->GPC['ip']}", 8);
	print_cells_row(array("IP","Cidr","Banned by","Registration","exempt","Expires","Reason","Delete"));
	$q=$db->query("SELECT * FROM " . TABLE_PREFIX . "ipban
				  LEFT JOIN " . TABLE_PREFIX . "user ON " . TABLE_PREFIX . "ipban.setby = " . TABLE_PREFIX . "user.userid
					where ip = ($ip & ((pow(2,`cidr`) - 1) << (32 - `cidr`)))
					and (`expires` = 0 OR `expires` > " . TIMENOW . ")
					ORDER BY cidr ASC
					");
	$reg = 0;
	$all = 0;
	while ($row = $db->fetch_array($q))
	{
		$data = array();
		$data[] = long2ip($row['ip']);
		$data[] = "/" . $row['cidr'];
		$data[] = $row['username'];
		$data[] = ($row['registration']) ? 'Yes':'No';
		$data[] = ($row['exempt']) ? 'Yes':'No';
		$data[] = date("r",$row['expires']);
		$data[] = $row['reason'];
		$data[] = "<a href=\"?do=delete&ipbanid=".$row['ipbanid']."\">[Delete]</a>";
		print_cells_row($data);
		//echo long2ip($row['ip']) . " \n";
		if($row['exempt'])
		{
			$all = 0;
			$reg = 0;
		}
		else
		{
			$reg = 1;
			if(!$row['registration'])
			{
				$all = 1;
			}
		}
	}
	print_table_footer();
	print_table_start();
	print_table_header("Status of {$vbulletin->GPC['ip']}", 2);
	print_cells_row(array('Registration',($reg) ? 'Banned':'Allowed'));
	print_cells_row(array('Site',($all) ? 'Banned':'Allowed'));
	print_table_footer();
}

if($_REQUEST['do'] == 'doadd')
{
	//add
	$vbulletin->input->clean_array_gpc('p', array(
		'ip' => TYPE_STR,
		'period' => TYPE_STR,
		'reason' => TYPE_NOHTML,
		'cidr' => TYPE_INT,
		'exempt' => TYPE_BOOL,
		'registration' => TYPE_BOOL

	));

	// check that the number of days is valid
	if ($vbulletin->GPC['period'] != 'PERMANENT' AND !preg_match('#^(D|M|Y)_[1-9][0-9]?$#', $vbulletin->GPC['period']))
	{
		print_stop_message('invalid_ban_period_specified');
	}

	// if we've got this far all the incoming data is good
	if ($vbulletin->GPC['period'] == 'PERMANENT')
	{
		// make this ban permanent
		$liftdate = 0;
	}
	else
	{
		// get the unixtime for when this ban will be lifted
		$liftdate = convert_date_to_timestamp($vbulletin->GPC['period']);
	}

	//dont let an admin ban too large a range of ips at once
	if($vbulletin->GPC['cidr'] < 8)
	{
		$vbulletin->GPC['cidr'] = 8;
	}

	if($vbulletin->GPC['cidr'] > 32)
	{
		$vbulletin->GPC['cidr'] = 32;
	}

	if(strlen($vbulletin->GPC['reason'])<1)
	{
		$vbulletin->GPC['reason'] = "No Reason";
	}

	$ip=sprintf("%u",ip2long($vbulletin->GPC['ip']));
	$cidrmask = ((pow(2,$vbulletin->GPC['cidr']) -1) << (32 - $vbulletin->GPC['cidr'])); //nb only works with ipv4. for ipv6 changes need to be made.

	$ip = $ip & $cidrmask;

	if(isset($vbulletin->config['SpecialUsers']['unbannableips']))
	{
		$unbannable = explode("|",$vbulletin->config['SpecialUsers']['unbannableips']);
		if(is_array($unbannable))
		{
			foreach($unbannable as $unbannableip)
			{
				$unbannableip = ip2long($unbannableip);
				$unbannableip = $unbannableip & $cidrmask;

				if($unbannableip == $ip)
				{
					print_stop_message('unbannable_ip');
				}
			}
		}
	}

	if($vbulletin->GPC['registration'] AND $vbulletin->GPC['exempt'])
	{
		print_stop_message('regexempt');
	}


	$db->query("INSERT INTO " . TABLE_PREFIX . "ipban (ip,cidr,registration,exempt,setby,reason,expires) VALUES
		    ($ip,{$vbulletin->GPC['cidr']},{$vbulletin->GPC['registration']},{$vbulletin->GPC['exempt']},
		    {$vbulletin->userinfo['userid']},'{$vbulletin->GPC['reason']}',$liftdate)");

	print_cp_message("Ip Ban added sucessfully","ipbans.php",3);
}

if($_REQUEST['do'] == 'add')
{

	$temporary_phrase = $vbphrase['temporary_ban_options'];
	$permanent_phrase = $vbphrase['permanent_ban_options'];

	// make a list of banning period options
	$periodoptions = array(
		$temporary_phrase => array(
			'D_1'  => "1 $vbphrase[day]",
			'D_2'  => "2 $vbphrase[days]",
			'D_3'  => "3 $vbphrase[days]",
			'D_4'  => "4 $vbphrase[days]",
			'D_5'  => "5 $vbphrase[days]",
			'D_6'  => "6 $vbphrase[days]",
			'D_7'  => "7 $vbphrase[days]",
			'D_10' => "10 $vbphrase[days]",
			'D_14' => "2 $vbphrase[weeks]",
			'D_21' => "3 $vbphrase[weeks]",
			'M_1'  => "1 $vbphrase[month]",
			'M_2' => "2 $vbphrase[months]",
			'M_3' => "3 $vbphrase[months]",
			'M_4' => "4 $vbphrase[months]",
			'M_5' => "5 $vbphrase[months]",
			'M_6' => "6 $vbphrase[months]",
			'Y_1' => "1 $vbphrase[year]",
			'Y_2' => "2 $vbphrase[years]",
		),
		$permanent_phrase => array(
			'PERMANENT' => "$vbphrase[permanent] - $vbphrase[never_lift_ban]"
		)
	);

	foreach ($periodoptions["$temporary_phrase"] AS $thisperiod => $text)
	{
		if ($liftdate = convert_date_to_timestamp($thisperiod))
		{
			$periodoptions["$temporary_phrase"]["$thisperiod"] .= ' (' . vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'], $liftdate) . ')';
		}
	}
	//add form
	print_form_header("ipbans","doadd");
	print_table_header("Add ip ban");
	print_input_row("IP Address","ip","");
	print_input_row("CIDR Range (if you are unsure what this does, leave it as 32)","cidr",32);
	print_yes_no_row("Registrations only?","registration",0);
	print_yes_no_row("Exempt IP?","exempt",0);
	print_select_row($vbphrase['lift_ban_after'], 'period', $periodoptions, $vbulletin->GPC['period']);
	print_input_row("Reason to ban ip", 'reason', '', true, 50, 250);
	print_submit_row();

}

if($_REQUEST['do'] == 'delete')
{
	$vbulletin->input->clean_array_gpc('g', array('ipbanid' => TYPE_INT));
	//print confirm form
	print_delete_confirmation("ipban", $vbulletin->GPC['ipbanid'], "ipbans", "dodelete", 'ipban', 0,'','ip');
}

if($_REQUEST['do'] == 'dodelete')
{
	//do the delete
	$vbulletin->input->clean_array_gpc('p', array('ipbanid' => TYPE_INT));
	$db->query("DELETE FROM " . TABLE_PREFIX . "ipban WHERE ipbanid = '{$vbulletin->GPC['ipbanid']}'");
	print_cp_message("Ip Ban deleted sucessfully","?",3);
}
print_cp_footer();