<?
/*
 (c) DataLife Engine
 http://dle-news.ru
*/

if(!defined('DATALIFEENGINE'))die;

$gd_version = 2;

class thumbnail_photo
{
	var $img;
    var $watermark_image_light;
    var $watermark_image_dark;

	function thumbnail_photo_start ($imgfile)
	{
		//detect image format
		$this->img['format'] = ereg_replace(".*\.(.*)$","\\1",$imgfile);
		$this->img['format'] = strtoupper($this->img['format']);

		if ($this->img['format']=="JPG" || $this->img['format']=="JPEG") {
			$this->img['format']="JPEG";
			$this->img['src'] = imagecreatefromjpeg ($imgfile);
		} elseif ($this->img['format']=="PNG") {
			$this->img['format']="PNG";
			$this->img['src'] = imagecreatefrompng ($imgfile);
		} elseif ($this->img['format']=="GIF") {
			$this->img['format']="GIF";
			$this->img['src'] = imagecreatefromgif ($imgfile);
		} else {
			die;
		}

		$this->img['lebar'] = @imagesx($this->img['src']);
		$this->img['tinggi'] = @imagesy($this->img['src']);
		$this->img['lebar_thumb'] = $this->img['lebar'];
		$this->img['tinggi_thumb'] = $this->img['tinggi'];

		//default quality jpeg
		$this->img['quality']=90;

		if ($this->img['src'] == "") {
			@unlink($imgfile);
			die;

		}
	}

function size_auto($size=100, $site=0)
{
	global $gd_version;

	$site = intval($site);

	if ($this->img['lebar'] <= $size AND $this->img['tinggi'] <= $size ) {
		$this->img['lebar_thumb'] = $this->img['lebar'];
		$this->img['tinggi_thumb'] = $this->img['tinggi'];
		return 0;
	}

 switch ($site) {

	case "1" :
		if ($this->img['lebar'] <= $size)
        {
			$this->img['lebar_thumb'] = $this->img['lebar'];
			$this->img['tinggi_thumb'] = $this->img['tinggi'];
			return 0;
        } else {
    		$this->img['lebar_thumb']=$size;
    		$this->img['tinggi_thumb'] = ($this->img['lebar_thumb']/$this->img['lebar'])*$this->img['tinggi'];
        }

		break;

	case "2" :
		if ($this->img['tinggi'] <= $size)
        {
			$this->img['lebar_thumb'] = $this->img['lebar'];
			$this->img['tinggi_thumb'] = $this->img['tinggi'];
			return 0;
        } else {
	    	$this->img['tinggi_thumb']=$size;
    		$this->img['lebar_thumb'] = ($this->img['tinggi_thumb']/$this->img['tinggi'])*$this->img['lebar'];
        }

		break;

	default:

	    if ($this->img['lebar']>=$this->img['tinggi'])
		{
    		$this->img['lebar_thumb']=$size;
    		$this->img['tinggi_thumb'] = ($this->img['lebar_thumb']/$this->img['lebar'])*$this->img['tinggi'];

		} else {

	    	$this->img['tinggi_thumb']=$size;
    		$this->img['lebar_thumb'] = ($this->img['tinggi_thumb']/$this->img['tinggi'])*$this->img['lebar'];

 	    }

		break;
  }

	if($gd_version==1)
          {
           $this->img['des'] = imagecreate($this->img['lebar_thumb'],$this->img['tinggi_thumb']);
    	   @imagecopyresized ($this->img['des'], $this->img['src'], 0, 0, 0, 0, $this->img['lebar_thumb'], $this->img['tinggi_thumb'], $this->img['lebar'], $this->img['tinggi']);
    	  }
	elseif($gd_version==2)
           {
            $this->img['des'] = imagecreatetruecolor($this->img['lebar_thumb'],$this->img['tinggi_thumb']);
    	    @imagecopyresampled ($this->img['des'], $this->img['src'], 0, 0, 0, 0, $this->img['lebar_thumb'], $this->img['tinggi_thumb'], $this->img['lebar'], $this->img['tinggi']);
    	    }

	$this->img['src'] = $this->img['des'];
	return 1;
}

function jpeg_quality($quality=90)
	{
		//jpeg quality
		$this->img['quality']=$quality;
	}

function save($save="")
{

 		if ($this->img['format']=="JPG" || $this->img['format']=="JPEG") {
			//JPEG
			imagejpeg($this->img['src'],"$save",$this->img['quality']);
		} elseif ($this->img['format']=="PNG") {
			//PNG
			imagepng($this->img['src'],"$save");
		} elseif ($this->img['format']=="GIF") {
			//GIF
			imagegif($this->img['src'],"$save");
		}

		imagedestroy($this->img['src']);
}


function show ()
{
		if ($this->img['format']=="JPG" || $this->img['format']=="JPEG") {
			//JPEG
			imageJPEG($this->img['src'],"",$this->img['quality']);
		} elseif ($this->img['format']=="PNG") {
			//PNG
			imagePNG($this->img['src']);
		} elseif ($this->img['format']=="GIF") {
			//GIF
			imageGIF($this->img['src']);
		}

		imagedestroy($this->img['src']);
}


function insert_watermark($min_image)
    { global $config;
        $margin = 7;

		$this->watermark_image_light = ROOT_DIR.'/engine/photo/img/watermake_light.png';
		$this->watermark_image_dark =  ROOT_DIR.'/engine/photo/img/watermake_dark.png';

        $image_width = imagesx($this->img['src']);
        $image_height = imagesy($this->img['src']);

        list($watermark_width, $watermark_height)
            = getimagesize($this->watermark_image_light);


                $watermark_x = $image_width - $margin - $watermark_width;
                $watermark_y = $image_height - $margin - $watermark_height;


        $watermark_x2 = $watermark_x + $watermark_width;
        $watermark_y2 = $watermark_y + $watermark_height;

        if ($watermark_x < 0 OR $watermark_y < 0 OR
            $watermark_x2 > $image_width OR $watermark_y2 > $image_height OR
			$image_width < $min_image OR $image_height < $min_image)
        {
           return;
        }


        $test = imagecreatetruecolor(1, 1);
        imagecopyresampled($test, $this->img['src'], 0, 0, $watermark_x, $watermark_y, 1, 1, $watermark_width, $watermark_height);
        $rgb = imagecolorat($test, 0, 0);

        $r = ($rgb >> 16) & 0xFF;
        $g = ($rgb >> 8) & 0xFF;
        $b = $rgb & 0xFF;

        $max = min($r, $g, $b);
        $min = max($r, $g, $b);
        $lightness = (double)(($max + $min) / 510.0);
        imagedestroy($test);

        $watermark_image = ($lightness < 0.5) ? $this->watermark_image_light : $this->watermark_image_dark;

        $watermark = imagecreatefrompng($watermark_image);

        imagealphablending($this->img['src'], TRUE);
        imagealphablending($watermark, TRUE);

        imagecopy($this->img['src'], $watermark, $watermark_x, $watermark_y, 0, 0,$watermark_width, $watermark_height);

        imagedestroy($watermark);

    }

	function elf($a, $x, $y, $z, $n)
	{
		global	$pc;

		switch ($a)
		{
	    case "1":
        //negativ
        imagefilter( $this->img['src'], IMG_FILTER_NEGATE);
	    break;

	    case "2":
        ///
        imagefilter( $this->img['src'], IMG_FILTER_GRAYSCALE);
	    break;

	    case "3":
        //EDGEDETECT
        imagefilter( $this->img['src'], IMG_FILTER_EDGEDETECT);
	    break;


	    case "4":
        //EMBOSS
        imagefilter( $this->img['src'], IMG_FILTER_EMBOSS);
	    break;



	    case "5":
        //BLUR g
        imagefilter( $this->img['src'], IMG_FILTER_GAUSSIAN_BLUR);
	    break;

	    case "6":
        //BLUR
        imagefilter( $this->img['src'], IMG_FILTER_SELECTIVE_BLUR);
	    break;

	    case "7":
        //REMOVAL
        imagefilter( $this->img['src'], IMG_FILTER_MEAN_REMOVAL);
	    break;

	    case "8":
        //SMOOTH
        imagefilter( $this->img['src'], IMG_FILTER_SMOOTH, $x);
	    break;

	    case "9":
        //COLORIZE
        if ($x<0 or $x>255) $x = 0;
        if ($y<0 or $y>255) $y = 0;
        if ($z<0 or $z>255) $z = 0;
        imagefilter( $this->img['src'], IMG_FILTER_COLORIZE, $x, $y, $z );
	    break;


	    case "10":
        //
        imagefilter( $this->img['src'], IMG_FILTER_BRIGHTNESS, $x);
	    break;

	    case "11":
        //
        imagefilter( $this->img['src'], IMG_FILTER_CONTRAST, $x );
	    break;

	 	case "12":

        	$n = trim ($n);

        	$ns = explode ("\n", $n);


        	for ( $i = 0; $i < count ($ns); $i ++)
        	{
              preg_match("#(((.*?)=(.*?),(.*?),(.*?);)|((.*?);))#ies", $ns[$i],  $f);

				if ( count ($f) == 7)
				{
	                $elf = intval($f[3]);

	                $parametr_1 = intval($f[4]);

	                $parametr_2 = intval($f[5]);

	                $parametr_3 = intval($f[6]);

				}else if ( count ($f) == 9)
				{
                	$elf	=	intval($f[8]);
				}

						switch ($elf)
						{
						    case "1":
						    imagefilter( $this->img['src'], IMG_FILTER_NEGATE);
						    break;

						    case "2":
					        imagefilter( $this->img['src'], IMG_FILTER_GRAYSCALE);
						    break;

						    case "3":
					        imagefilter( $this->img['src'], IMG_FILTER_EDGEDETECT);
						    break;


						    case "4":
					        imagefilter( $this->img['src'], IMG_FILTER_EMBOSS);
						    break;

						    case "5":
					        imagefilter( $this->img['src'], IMG_FILTER_GAUSSIAN_BLUR);
						    break;

						    case "6":
					        imagefilter( $this->img['src'], IMG_FILTER_SELECTIVE_BLUR);
						    break;

						    case "7":
					        imagefilter( $this->img['src'], IMG_FILTER_MEAN_REMOVAL);
						    break;

						    case "8":
					        imagefilter( $this->img['src'], IMG_FILTER_SMOOTH, $parametr_1);
						    break;

						    case "9":
					        if ($parametr_1<0 or $parametr_1>255) $parametr_1 = 0;
					        if ($parametr_2<0 or $parametr_2>255) $parametr_2 = 0;
					        if ($parametr_3<0 or $parametr_3>255) $parametr_3 = 0;
					        imagefilter( $this->img['src'], IMG_FILTER_COLORIZE, $parametr_1, $parametr_2, $parametr_3 );
						    break;

						    case "10":
					        imagefilter( $this->img['src'], IMG_FILTER_BRIGHTNESS, $parametr_1);
						    break;

						    case "11":
					        imagefilter( $this->img['src'], IMG_FILTER_CONTRAST, $parametr_1);
						    break;
					    }

        	}

	 	break;
		}
	}
}
?>