<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBExperience 3.8                                                 # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2006-2009 Marius Czyz. All Rights Reserved.           # ||
|| #################################################################### ||
\*======================================================================*/

function DoDropColumns()
{
	global $vbulletin;
	
	$vbulletin->db->hide_errors();
	$vbulletin->db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . "xperience_stats");
	$vbulletin->db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . "xperience_groups");	
	$vbulletin->db->query_write("ALTER TABLE `". TABLE_PREFIX ."user` DROP `xperience`");
	$vbulletin->db->query_write("ALTER TABLE `". TABLE_PREFIX ."user` DROP `xperience_points`");
	$vbulletin->db->query_write("ALTER TABLE `". TABLE_PREFIX ."user` DROP `xperience_done`");
	$vbulletin->db->query_write("ALTER TABLE `". TABLE_PREFIX ."user` DROP `xperience_level`");
	$vbulletin->db->query_write("ALTER TABLE `". TABLE_PREFIX ."user` DROP `xperience_levelp`");
	$vbulletin->db->query_write("ALTER TABLE `". TABLE_PREFIX ."user` DROP `xperience_next_level`");
	$vbulletin->db->query_write("ALTER TABLE `". TABLE_PREFIX ."user` DROP `xperience_next_level_points`");
	$vbulletin->db->query_write("ALTER TABLE `". TABLE_PREFIX ."user` DROP `xperience_ppd`");
	$vbulletin->db->query_write("ALTER TABLE `". TABLE_PREFIX ."user` DROP `xperience_awards`");
	$vbulletin->db->query_write("ALTER TABLE `". TABLE_PREFIX ."user` DROP `xperience_shopitems`");
	$vbulletin->db->query_write("ALTER TABLE `". TABLE_PREFIX ."user` DROP `xperience_awardcount`");
	$vbulletin->db->query_write("ALTER TABLE `". TABLE_PREFIX ."user` DROP `xperience_promotioncount`");
	$vbulletin->db->query_write("ALTER TABLE `". TABLE_PREFIX ."user` DROP `xperience_achievementcount`");
	$vbulletin->db->show_errors();
	
}



function DoInstall()
{
	global $vbulletin;
	

	$vbulletin->db->query_write("CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "xperience_gap (
		gapid INT UNSIGNED NOT NULL AUTO_INCREMENT,
		userid BIGINT NOT NULL DEFAULT '0', 
		toid BIGINT NOT NULL DEFAULT '0', 
		field VARCHAR(250) DEFAULT '',
		amount BIGINT NOT NULL DEFAULT '0', 
		dateline INT(10) DEFAULT '0',
		PRIMARY KEY (gapid)
	)"); 
	
	$vbulletin->db->query_write("CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "xperience_achievements_categories (
		categoryid INT UNSIGNED NOT NULL AUTO_INCREMENT,
		categorytitle VARCHAR(250) NOT NULL DEFAULT 'Category',
		categorydesc MEDIUMTEXT,
		categoryorder INT(10) DEFAULT '1',
		PRIMARY KEY (categoryid)
	)");

	$vbulletin->db->query_write("CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "xperience_achievements (
		achievementid INT UNSIGNED NOT NULL AUTO_INCREMENT,
		title VARCHAR(250) DEFAULT 'Achievement',
		description MEDIUMTEXT, 
		sortorder INT(10) DEFAULT '1',
		imagesmall VARCHAR(250) DEFAULT '',
		imagebig VARCHAR(250) DEFAULT '',	
		categoryid SMALLINT(10) DEFAULT '1',
		PRIMARY KEY (achievementid)
	)"); 
	
	$vbulletin->db->query_write("CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "xperience_achievements_fields (
		fieldid INT UNSIGNED NOT NULL AUTO_INCREMENT,
		achievementid INT(10) DEFAULT '0',
		field VARCHAR(250) DEFAULT '',
		value BIGINT NOT NULL DEFAULT '0',
		compare SMALLINT(6) NOT NULL DEFAULT '1',
		PRIMARY KEY (fieldid)
	)"); 
	
	$vbulletin->db->query_write("CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "xperience_achievements_issues (
		issueid INT UNSIGNED NOT NULL AUTO_INCREMENT,
		achievementid INT(10) DEFAULT '0',
		userid INT(10) DEFAULT '0',
		dateline INT(10) DEFAULT '0',
		PRIMARY KEY (issueid)
	)");
	
	$vbulletin->db->query_write("CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "xperience_achievements_log (
		logid INT UNSIGNED NOT NULL AUTO_INCREMENT,
		achievementid INT(10) DEFAULT '0',
		userid INT(10) DEFAULT '0',
		dateline INT(10) DEFAULT '0',
		logtype INT(10) DEFAULT '0',
		PRIMARY KEY (logid)
	)");
	
	$vbulletin->db->query_write("CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "xperience_promotion (
		promotionid INT UNSIGNED NOT NULL AUTO_INCREMENT,
		field VARCHAR(250) DEFAULT '',
		value BIGINT NOT NULL DEFAULT '0', 
		compare SMALLINT(6) NOT NULL DEFAULT '1',
		from_ug INT(10) DEFAULT '0',
		to_ug INT(10) DEFAULT '0',
		promotiontype INT(10) DEFAULT '0',
		sortorder INT(10) DEFAULT '0',
		parentid INT(10) DEFAULT '0',
		comment VARCHAR(250) DEFAULT '',
		PRIMARY KEY (promotionid)
	)"); 
	
	$vbulletin->db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . "xperience_promotion_log");
	$vbulletin->db->query_write("CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "xperience_promotion_issues (
		promotionlogid INT UNSIGNED NOT NULL AUTO_INCREMENT,
		promotionid INT(10) DEFAULT '0',
		userid INT(10) DEFAULT '0',
		from_ug INT(10) DEFAULT '0',
		to_ug INT(10) DEFAULT '0',
		promotiontype INT(10) DEFAULT '0',
		comment VARCHAR(250) NOT NULL DEFAULT '-',
		dateline INT(10) DEFAULT '0',
		PRIMARY KEY (promotionlogid),
		KEY userid (userid)
	)"); 
	
	
	$vbulletin->db->query_write("CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "xperience_shop (
		itemid INT UNSIGNED NOT NULL AUTO_INCREMENT,
		itemname VARCHAR(250) NOT NULL DEFAULT 'award',
		itemdesc MEDIUMTEXT,
		itempicture VARCHAR(250) DEFAULT '',
		itemicon VARCHAR(250) DEFAULT '',
		itemthumb VARCHAR(250) DEFAULT '',
		ldmlinkid INT DEFAULT '0',
		dl2linkid INT DEFAULT '0',
		canbesold SMALLINT NOT NULL DEFAULT '1', 
		canbegiven SMALLINT NOT NULL DEFAULT '1', 
		canbedropped SMALLINT NOT NULL DEFAULT '1', 
		catid INT(6) DEFAULT '1',
		quantity SMALLINT NOT NULL DEFAULT '1', 
		costs INT NOT NULL DEFAULT '1',
		costfield VARCHAR(250) DEFAULT '',
		itemstatus INT(6) DEFAULT '1',
		PRIMARY KEY (itemid)
	)"); 
	
	$vbulletin->db->query_write("CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "xperience_shop_ta (
		taid INT UNSIGNED NOT NULL AUTO_INCREMENT,
		itemid SMALLINT NOT NULL DEFAULT '1',
		buyer BIGINT NOT NULL DEFAULT '0', 
		dateline INT(10) DEFAULT '0',
		costs INT NOT NULL DEFAULT '1',
		costfield VARCHAR(250) DEFAULT '',
		dateline_sell INT(10) DEFAULT '0',
		sell INT NOT NULL DEFAULT '0',
		dateline_ga INT(10) DEFAULT '0',
		userid BIGINT NOT NULL DEFAULT '0', 
		PRIMARY KEY (taid)
	)"); 
	
	$vbulletin->db->query_write("CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "xperience_shop_cat (
		catid INT UNSIGNED NOT NULL AUTO_INCREMENT,
		catname VARCHAR(250) NOT NULL DEFAULT 'award',
		catdesc MEDIUMTEXT, 
		catparent SMALLINT NOT NULL DEFAULT '0',
		catstatus INT(6) DEFAULT '1',
		PRIMARY KEY (catid)
	)"); 
	
	$vbulletin->db->query_write("CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "xperience_awards (
		awardid INT UNSIGNED NOT NULL AUTO_INCREMENT,
		awardname VARCHAR(250) NOT NULL DEFAULT 'award',
		awardtitle VARCHAR(250) NOT NULL DEFAULT 'My Award',
		awarddesc MEDIUMTEXT, 
		awardurl VARCHAR(250) DEFAULT '',
		awardbigurl VARCHAR(250) DEFAULT '',
		awardstatus SMALLINT NOT NULL DEFAULT '1', 
		awardfields MEDIUMTEXT,
		awardexclusions VARCHAR(250) DEFAULT '',
		awardlimit SMALLINT(6) DEFAULT '0',
		awardcategory SMALLINT(10) DEFAULT '1',
		manualassign VARCHAR(250) NOT NULL DEFAULT '0',
		PRIMARY KEY (awardid),
		KEY awardname (awardname)
	)"); 
		
	$vbulletin->db->query_write("CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "xperience_award_issues (
		issueid INT UNSIGNED NOT NULL AUTO_INCREMENT,
		awardid INT(10) DEFAULT '0',
		userid INT(10) DEFAULT '0',
		dateline INT(10) DEFAULT '0',
		dateline_in INT(10) DEFAULT '0',
		dateline_out INT(10) DEFAULT '0',
		PRIMARY KEY (issueid)
	)");
		
	$vbulletin->db->query_write("CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "xperience_award_categories (
		categoryid INT UNSIGNED NOT NULL AUTO_INCREMENT,
		categorytitle VARCHAR(250) NOT NULL DEFAULT 'Category',
		categorydesc MEDIUMTEXT,
		categoryorder INT(10) DEFAULT '1',
		PRIMARY KEY (categoryid)
	)");
	
	$vbulletin->db->query_write("CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "xperience_groups (
		groupid INT(10) DEFAULT '0',
		members INT(10) DEFAULT '0',
		points BIGINT DEFAULT '0',
		points_max BIGINT DEFAULT '0',
		points_min BIGINT DEFAULT '0'
	)"); 
		
	$vbulletin->db->query_write("CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "xperience_custompoints (
		pointid INT UNSIGNED NOT NULL AUTO_INCREMENT,
		userid INT(10) DEFAULT '0',
		points_misc_custom BIGINT DEFAULT '0',
		adminid INT(10) DEFAULT '0',
		comment VARCHAR(250) NOT NULL DEFAULT '-',
		dateline INT(10) DEFAULT '0',
		PRIMARY KEY (pointid),
		KEY userid (userid)
	)"); 
	
	$vbulletin->db->query_write("CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "xperience_stats_changes (
		statsid INT UNSIGNED NOT NULL AUTO_INCREMENT,
		userid BIGINT NOT NULL DEFAULT '0', 
		field VARCHAR(250) DEFAULT '',
		oldvalue BIGINT NOT NULL DEFAULT '0', 
		difference BIGINT NOT NULL DEFAULT '0', 
		newvalue BIGINT NOT NULL DEFAULT '0', 
		ismajor SMALLINT(6) DEFAULT '0',
		dateline INT(10) DEFAULT '0',
		PRIMARY KEY (statsid)
	)"); 
	
	
	$vbulletin->db->query_write("CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "xperience_stats (
		userid INT(10) DEFAULT '0',
		points_xperience BIGINT DEFAULT '0',
		points_thread BIGINT DEFAULT '0',
		points_threads BIGINT DEFAULT '0',
		points_threads_sg BIGINT DEFAULT '0',
		points_thread_group_discussion BIGINT DEFAULT '0',
		points_thread_votes BIGINT DEFAULT '0',
		points_thread_replycount BIGINT DEFAULT '0',
		points_thread_views BIGINT DEFAULT '0',
		points_thread_stickies BIGINT DEFAULT '0',
		points_thread_tags BIGINT DEFAULT '0',
		points_post BIGINT DEFAULT '0',
		points_posts BIGINT DEFAULT '0',
		points_posts_sg BIGINT DEFAULT '0',
		points_post_group_discussion BIGINT DEFAULT '0',
		points_post_thanks BIGINT DEFAULT '0',
		points_post_thanks_use BIGINT DEFAULT '0',
		points_post_attachment BIGINT DEFAULT '0',
		points_post_attachment_views BIGINT DEFAULT '0',
		points_post_avg FLOAT DEFAULT '0',
		points_user BIGINT DEFAULT '0',
		points_user_profile BIGINT DEFAULT '0',
		points_user_infractions BIGINT DEFAULT '0',
		points_user_reputation BIGINT DEFAULT '0',
		points_user_reputation_use BIGINT DEFAULT '0',
		points_user_online BIGINT DEFAULT '0',
		points_user_socialgroup BIGINT DEFAULT '0',
		points_user_visitormessages BIGINT DEFAULT '0',
		points_user_albumpictures BIGINT DEFAULT '0',
		points_user_referrals BIGINT DEFAULT '0',
		points_user_friends SMALLINT(6) DEFAULT '0',
		points_user_activity FLOAT DEFAULT '0',
		points_misc BIGINT DEFAULT '0',
		points_misc_ldm BIGINT DEFAULT '0',
		points_misc_dl2 BIGINT DEFAULT '0',
		points_misc_ppd BIGINT DEFAULT '0',
		points_misc_vbblog BIGINT DEFAULT '0',
		points_misc_custom BIGINT DEFAULT '0',
		points_misc_events BIGINT DEFAULT '0',
		shop BIGINT DEFAULT '0',
		dateline INT(10) DEFAULT '0',
		promoted SMALLINT NOT NULL DEFAULT '0',
		PRIMARY	KEY userid (userid)
	)"); 
	
	$vbulletin->db->query_write("CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "xperience_level (
		usergroupid SMALLINT(6) DEFAULT '0',
		xperience_points FLOAT DEFAULT '0',
		xperience_level SMALLINT(6) DEFAULT '1',
		PRIMARY KEY	(xperience_level)
	)"); 
	

	if (!vbexp_field_exists('user', 'xperience')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "user ADD xperience BIGINT DEFAULT '1'");
	if (!vbexp_field_exists('user', 'xperience_done')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "user ADD xperience_done SMALLINT(6) DEFAULT '0'");
	if (!vbexp_field_exists('user', 'xperience_level')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "user ADD xperience_level SMALLINT(6) DEFAULT '1'");
	if (!vbexp_field_exists('user', 'xperience_levelp')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "user ADD xperience_levelp SMALLINT(6) DEFAULT '1'");
	if (!vbexp_field_exists('user', 'xperience_next_level')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "user ADD xperience_next_level BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('user', 'xperience_next_level_points')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "user ADD xperience_next_level_points BIGINT DEFAULT '1'");
	if (!vbexp_field_exists('user', 'xperience_ppd')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "user ADD xperience_ppd FLOAT DEFAULT '0'");
	if (!vbexp_field_exists('user', 'xperience_awards')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "user ADD xperience_awards VARCHAR(250) NOT NULL DEFAULT ''");
	if (!vbexp_field_exists('user', 'xperience_shopitems')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "user ADD xperience_shopitems MEDIUMTEXT");
	if (!vbexp_field_exists('user', 'xperience_achievements')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "user ADD xperience_achievements MEDIUMTEXT");
	if (!vbexp_field_exists('user', 'xperience_lastupdate')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "user ADD xperience_lastupdate INT(10) DEFAULT '0'");
	if (!vbexp_field_exists('user', 'xperience_awardcount')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "user ADD xperience_awardcount SMALLINT(6) DEFAULT '0'");
	if (!vbexp_field_exists('user', 'xperience_promotioncount')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "user ADD xperience_promotioncount SMALLINT(6) DEFAULT '0'");
	if (!vbexp_field_exists('user', 'xperience_achievementcount')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "user ADD xperience_achievementcount SMALLINT(6) DEFAULT '0'");

	if (vbexp_field_exists('user', 'xperience_awards')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "user MODIFY xperience_awards MEDIUMTEXT");
	if (vbexp_field_exists('user', 'xperience_shopitems')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "user MODIFY xperience_shopitems MEDIUMTEXT");
	
	if (!vbexp_field_exists('xperience_promotion', 'comment')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_promotion ADD comment VARCHAR(250) DEFAULT ''");

	if (!vbexp_field_exists('xperience_awards', 'awardlimit')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_awards ADD awardlimit SMALLINT(6) DEFAULT '1'");
	if (!vbexp_field_exists('xperience_awards', 'awardurl')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_awards ADD awardurl VARCHAR(250) DEFAULT ''");
	if (!vbexp_field_exists('xperience_awards', 'awardbigurl')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_awards ADD awardbigurl VARCHAR(250) DEFAULT ''");
	if (!vbexp_field_exists('xperience_awards', 'awardcategory')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_awards ADD awardcategory SMALLINT(10) DEFAULT '1'");

	if (vbexp_field_exists('xperience_shop_ta', 'buyer')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_shop_ta MODIFY buyer BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_shop_ta', 'userid')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_shop_ta ADD userid BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_shop_ta', 'sell')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_shop_ta ADD sell INT NOT NULL DEFAULT '0'");
	if (!vbexp_field_exists('xperience_shop_ta', 'dateline_sell')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_shop_ta ADD dateline_sell INT(10) DEFAULT '0'");
	if (!vbexp_field_exists('xperience_shop_ta', 'dateline_ga')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_shop_ta ADD dateline_ga INT(10) DEFAULT '0'");
	
	if (!vbexp_field_exists('xperience_shop', 'itemicon')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_shop ADD itemicon VARCHAR(250) DEFAULT ''");
	if (!vbexp_field_exists('xperience_shop', 'itemthumb')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_shop ADD itemthumb VARCHAR(250) DEFAULT ''");
	if (!vbexp_field_exists('xperience_shop', 'ldmlinkid')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_shop ADD ldmlinkid INT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_shop', 'dl2linkid')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_shop ADD dl2linkid INT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_shop', 'canbesold')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_shop ADD canbesold SMALLINT NOT NULL DEFAULT '1'");
	if (!vbexp_field_exists('xperience_shop', 'canbegiven')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_shop ADD canbegiven SMALLINT NOT NULL DEFAULT '1'");
	if (!vbexp_field_exists('xperience_shop', 'canbedropped')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_shop ADD canbedropped SMALLINT NOT NULL DEFAULT '1'");
		
	if (!vbexp_field_exists('xperience_stats', 'shop')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD shop BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_xperience')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_xperience BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'promoted')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD promoted SMALLINT NOT NULL DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_misc_custom')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_misc_custom BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_misc_vbblog')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_misc_vbblog BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_misc_ppd')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_misc_ppd BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_misc_dl2')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_misc_dl2 BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_misc_ldm')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_misc_ldm BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_misc')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_misc BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_thread_tags')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_thread_tags BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_post_attachment')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_post_attachment BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_post_attachment_views')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_post_attachment_views BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_post_thanks_use')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_post_thanks_use BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_user_reputation_use')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_user_reputation_use BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_user_referrals')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_user_referrals BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_user_friends')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_user_friends BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_user_activity')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_user_activity BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_user_socialgroup')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_user_socialgroup BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_user_visitormessages')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_user_visitormessages BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_user_albumpictures')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_user_albumpictures BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_thread_group_discussion')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_thread_group_discussion BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_post_group_discussion')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_post_group_discussion BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_user_profile')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_user_profile BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_threads_sg')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_threads_sg BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_posts_sg')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_posts_sg BIGINT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_post_avg')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_post_avg FLOAT DEFAULT '0'");
	if (!vbexp_field_exists('xperience_stats', 'points_misc_events')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD points_misc_events BIGINT DEFAULT '0'");

	if (vbexp_field_exists('xperience_stats', 'points_post_attachement')) $vbulletin->db->query_write("ALTER TABLE ". TABLE_PREFIX ."xperience_stats DROP points_post_attachement");
	if (vbexp_field_exists('xperience_stats', 'points_user_activity')) $vbulletin->db->query_write("ALTER TABLE ". TABLE_PREFIX ."xperience_stats MODIFY points_user_activity FLOAT DEFAULT '0'");
	
	//if (!vbexp_field_exists('xperience_promotion_log', 'promotiontype')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_promotion_log ADD promotiontype INT DEFAULT '0'");	
	
	
//	$getpromotionsq = $vbulletin->db->query_read("SELECT promotionid, from_ug, to_ug FROM " . TABLE_PREFIX . "xperience_promotion_log WHERE promotiontype=0 ORDER BY dateline DESC LIMIT 100");
//	if ($vbulletin->db->num_rows($getpromotionsq) > 0) 
//	{
//		while ($getpromotions = $vbulletin->db->fetch_array($getpromotionsq)) 
//		{
//			$vbulletin->db->query_write("UPDATE
//				" . TABLE_PREFIX . "xperience_promotion_log
//				SET
//				promotiontype=".HasPromoted($getpromotions['from_ug'], $getpromotions['to_ug'])."
//				WHERE promotionid=".$getpromotions['promotionid']
//			);			
//		}
//	}
	
	
	
	if (vbexp_field_exists('xperience_awards', 'manualassign')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_awards MODIFY manualassign VARCHAR(250) NOT NULL DEFAULT '0'");
	if (!vbexp_field_exists('xperience_awards', 'manualassign')) $vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_awards ADD manualassign VARCHAR(250) NOT NULL DEFAULT '0'");
	if (vbexp_field_exists('user', 'xperience_points')) $vbulletin->db->query_write("ALTER TABLE ". TABLE_PREFIX ."user DROP xperience_points");

	$istable = $vbulletin->db->query_read("SELECT categoryid FROM " . TABLE_PREFIX . "xperience_award_categories");
	if ($vbulletin->db->num_rows($istable) == 0) 
	{
		$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_award_categories (categorytitle) VALUES ('All Awards')");
	}

	
	$istable = $vbulletin->db->query_read("SELECT awardid FROM " . TABLE_PREFIX . "xperience_awards");
	if ($vbulletin->db->num_rows($istable) == 0) 
	{
		CreateDefaultAwards();
	}
	
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "xperience_awards SET awardcategory=1 WHERE awardcategory=0");

	$istable = $vbulletin->db->query_read("SELECT achievementid FROM " . TABLE_PREFIX . "xperience_achievements");
	if ($vbulletin->db->num_rows($istable) == 0) 
	{
		CreateDefaultAchievements();
	}



	$vbulletin->db->hide_errors();
	$vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "xperience_stats ADD PRIMARY KEY (userid)");
	$vbulletin->db->show_errors();
	
}

function CreateDefaultAchievements()
{
	global $vbulletin;
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_achievements_categories (categorytitle, categorydesc, categoryorder) VALUES ('Achievements', 'All Achievements', '1')");
	$categoryid =	$vbulletin->db->insert_id();
	
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_achievements (sortorder, categoryid, title, description,  imagesmall, imagebig) VALUES (1, ".$categoryid.", '10 Days registered', '10 Days registered', '".$vbulletin->options['bburl']."/xperience/icons/calendar_16.png', '".$vbulletin->options['bburl']."/xperience/icons/calendar_32.png')");
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_achievements_fields (achievementid, field, value, compare) VALUES (".$vbulletin->db->insert_id().", 'points_user_online', 20, 1)");

	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_achievements (sortorder, categoryid, title, description,  imagesmall, imagebig) VALUES (1, ".$categoryid.", 'First 1000 Experience Points', 'First 1000 Experience Points', '".$vbulletin->options['bburl']."/xperience/icons/spheres_iridescent_16.png', '".$vbulletin->options['bburl']."/xperience/icons/spheres_iridescent_32.png')");
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_achievements_fields (achievementid, field, value, compare) VALUES (".$vbulletin->db->insert_id().", 'points_xperience', 1000, 1)");

	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_achievements (sortorder, categoryid, title, description,  imagesmall, imagebig) VALUES (1, ".$categoryid.", 'Got three Friends', '', '".$vbulletin->options['bburl']."/xperience/icons/dude4_16.png', '".$vbulletin->options['bburl']."/xperience/icons/dude4_32.png')");
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_achievements_fields (achievementid, field, value, compare) VALUES (".$vbulletin->db->insert_id().", 'points_user_friends', 9, 1)");


}

function CreateDefaultAwards()
{
	global $vbulletin;
	
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_award_categories (categorytitle, categorydesc, categoryorder) VALUES ('Awards', 'All Awards', '1')");
	$categoryid =	$vbulletin->db->insert_id();
	
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_awards (awardcategory, awardlimit, awardurl, awardbigurl, awardtitle, awarddesc, awardfields) VALUES (".$categoryid.", '0', '".$vbulletin->options['bburl']."/xperience/icons/favorites_16.png', '".$vbulletin->options['bburl']."/xperience/icons/favorites_32.png', 'Most Popular', 'Favourite Person', 'points_user_reputation')");
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_awards (awardcategory, awardlimit, awardurl, awardbigurl, awardtitle, awarddesc, awardfields) VALUES (".$categoryid.", '0', '".$vbulletin->options['bburl']."/xperience/icons/symbol_configuration_1_16.png', '".$vbulletin->options['bburl']."/xperience/icons/symbol_configuration_1_32.png', 'Activity Award', 'Very Active', 'points_user_activity')");
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_awards (awardcategory, awardlimit, awardurl, awardbigurl, awardtitle, awarddesc, awardfields) VALUES (".$categoryid.", '0', '".$vbulletin->options['bburl']."/xperience/icons/robot_16.png', '".$vbulletin->options['bburl']."/xperience/icons/robot_32.png', 'Posting Award', 'Zealousness posting and tagging', 'points_threads+points_thread_votes+points_thread_replycount+points_thread_views+points_thread_stickies+points_thread_tags+points_posts+points_post_attachment')");
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_awards (awardcategory, awardlimit, awardurl, awardbigurl, awardtitle, awarddesc, awardfields) VALUES (".$categoryid.", '0', '".$vbulletin->options['bburl']."/xperience/icons/flower_blue_16.png', '".$vbulletin->options['bburl']."/xperience/icons/flower_blue_32.png', 'Community Award', 'Social engaged', 'points_user_visitormessages+points_user_socialgroup+points_user_friends+points_user_reputation')");
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_awards (awardcategory, awardlimit, awardurl, awardbigurl, awardtitle, awarddesc, awardfields) VALUES (".$categoryid.", '0', '".$vbulletin->options['bburl']."/xperience/icons/spam_16.png', '".$vbulletin->options['bburl']."/xperience/icons/spam_32.png', 'Frequent Poster', 'User likes to post', 'points_post_avg')");

	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_awards (awardcategory, awardlimit, awardurl, awardbigurl, awardtitle, awarddesc, awardfields) VALUES (".$categoryid.", '0', '".$vbulletin->options['bburl']."/xperience/icons/spheres_embriotic_16.png', '".$vbulletin->options['bburl']."/xperience/icons/spheres_embriotic_32.png', 'Blog Award', 'Communicative and informational', 'points_misc_vbblog')");
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_awards (awardcategory, awardlimit, awardurl, awardbigurl, awardtitle, awarddesc, awardfields) VALUES (".$categoryid.", '0', '".$vbulletin->options['bburl']."/xperience/icons/calendar_16.png', '".$vbulletin->options['bburl']."/xperience/icons/calendar_32.png', 'Calendar Award', 'Engaged with events', 'points_misc_events')");

}

function vbexp_field_exists($table, $field)
{
	global $vbulletin;
	return ($vbulletin->db->num_rows($vbulletin->db->query_read("SHOW COLUMNS FROM `" . TABLE_PREFIX .$table."` LIKE '".$field."'"))> 0);
}


?>