<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

define( 'THIS_SCRIPT', "watermark" );

function ditchempty()
{
    global $PP_PATH;

    header("Content-Type: image/gif");
    readfile( "$PP_PATH/images/spacer.gif" );
    exit;
}

require "pp-inc.php";

typecast($_REQUEST, array('file' => INT, 'size' => INT));
typecast($_COOKIE, array('catp' => STRING));

// Init some variables
authenticate();

if ( isset($Globals['ppboards']) && $User['adminedit'] != 1 )
{
    if ( $Globals['ppboards'] == "closed" )
	{
        ditchempty();
    }
}

if ( $file == 0 || (($User['username'] == "" || $User['username'] == $Globals['pp_lang']['unreg']) && $Globals['reqregister'] == "yes") )
{
    ditchempty();
}

$rows = ppmysql_query("SELECT id,userid,cat,storecat,bigimage,medsize,approved FROM {$Globals['pp_db_prefix']}photos WHERE id=$file", $link);
list( $id, $iuserid, $dbcat, $storecat, $bigimage, $medsize, $approved ) = mysql_fetch_row($rows);
ppmysql_free_result( $rows );

if ( $file != $id )
{
    ditchempty();
}

$isjpeg = false;

if ( stristr($bigimage,".jpg") || stristr($bigimage,".jpeg") ) 
{
    $isjpeg = true;
    $cttype = "Content-Type: image/jpg";
}
elseif ( stristr($bigimage,".gif") ) 
{
    $cttype = "Content-Type: image/gif";
}
elseif ( stristr($bigimage,".png") ) 
{
    $cttype = "Content-Type: image/png";
}
else 
{
    ditchempty();
}
if ( $storecat == 0 )
{
    $storecat = $dbcat;
}

if ( $User['adminedit'] != 1 && $User['userid'] != $iuserid ) {

    if ( $CatPerms['cattype'][$dbcat] == "c" )
    {
        if ( $CatPerms['ugview'][$dbcat] == 1 && $catp == "" )
        {
            ditchempty();
        }
    }
    else
    {
        if ( $CatPerms['ugview'][500] == 1 && $catp == "" )
        {
            ditchempty();
        }
    }

    $catpass = walk_tree( $dbcat );

    if ( trim($catpass) != "" )
    {
        if ( strcmp($catp, $catpass) )
        {
            ditchempty();
        }
    }
}

if ( $approved == 1 || $User['adminedit'] == 1 || $User['moderator'] == 1 )
{
    if ($Globals['bigsave'] == "yes")
    {
        header($cttype);
        header("Content-Disposition: attachment; filename=$bigimage");

        if ( isset($size) && $medsize > 0 )
        {
            $srcfilename = "{$Globals['datafull']}/$storecat/medium/$bigimage";
        }
        else
        {
            $srcfilename = "{$Globals['origfull']}/$storecat/$bigimage";
        }

        if ( $Globals['onthefly'] == "yes" && $isjpeg ) 
        {
            // Only works if using GD2 and the image is a JPG
            if ( file_exists($Globals['watermark']) )
            {
                $watermark = $Globals['watermark'];

                $imageInfo = getimagesize($srcfilename);
                $width = $imageInfo[0];
                $height = $imageInfo[1];

                $logoinfo = getimagesize($watermark);
                $logowidth = $logoinfo[0];
                $logoheight = $logoinfo[1];

			    if( $Globals['gravity'] == "Center" )
			    {
			        $horizmargin = ( $width / 2 ) - ( $logowidth / 2 );
			        $vertmargin = ( $height / 2 ) - ( $logoheight / 2 );
			    }
			    elseif( $Globals['gravity'] == "NorthWest" )
			    {
			        // top left
			        $horizmargin = 0;
			        $vertmargin = 0;
			    }
			    elseif( $Globals['gravity'] == "NorthEast" )
			    {
			        // top right
			        $horizmargin = $width - $logowidth;
			        $vertmargin = 0;
			    }
			    elseif( $Globals['gravity'] == "SouthWest" )
			    {
			        // bottom left
			        $horizmargin = 0;
			        $vertmargin = $height - $logoheight;
			    }
			    elseif( $Globals['gravity'] == "North" )
			    {
			        // top middle
			        $horizmargin = ( ( $width - $logowidth ) / 2 );
			        $vertmargin = 0;
			    }
			    elseif( $Globals['gravity'] == "East" )
			    {
			        // middle right
			        $horizmargin = $width - $logowidth;
			        $vertmargin = ( $height / 2 ) - ( $logoheight / 2 );
			    }
			    elseif( $Globals['gravity'] == "South" )
			    {
			        // bottom middle
			        $horizmargin = ( ( $width - $logowidth ) / 2 );
			        $vertmargin = $height - $logoheight;
			    }
			    elseif( $Globals['gravity'] == "West" )
			    {
			        // middle left
			        $horizmargin = 0;
			        $vertmargin = ( $height / 2 ) - ( $logoheight / 2 );
			    }
			    else
			    {
			        // bottom right
			        $horizmargin = $width - $logowidth;
			        $vertmargin = $height - $logoheight;
			    }

                $photoImage = ImageCreateFromJPEG($srcfilename);
                ImageAlphaBlending($photoImage, true);

                $logoImage = ImageCreateFromPNG($watermark);
                $logoW = ImageSX($logoImage);
                $logoH = ImageSY($logoImage);

                ImageCopy($photoImage, $logoImage, $horizmargin, $vertmargin, 0, 0, $logoW, $logoH);
                ImageJPEG($photoImage, "", 90);

                ImageDestroy($photoImage);
                ImageDestroy($logoImage);
                exit;
            }
         }

         readfile( $srcfilename );
    }
    else
    {
        header($cttype);
        header("Content-Disposition: attachment; filename=$bigimage");

        readfile( "{$Globals['datadir']}/$storecat/thumbs/$bigimage" );
    }
}
else
{
    header("Content-Type: image/gif");
    readfile( "./images/ipending.gif" );
}

?>