<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

define( 'THIS_SCRIPT', "useralbums" );
require "pp-inc.php";

typecast($_REQUEST, array('ppaction' => STRING,'albumid' => INT));
typecast($_POST, array('admin' => INT, 'category' => INT, 'do' => STRING, 'isprivate' => STRING, 'canzip' => STRING,
                       'albumdesc' => STRING, 'albumname' => STRING, 'theme' => STRING, 'parent' => INT,
                       'sortorder' => INT, 'catorder' => INT, 'frames' => STRING, 'oldstat' => STRING,
                       'albumowner' => STRING, 'thumbtype' => INT, 'intro' => STRING, 'introtitle' => STRING,
                       'introcopy' => STRING) );

authenticate();

if ( $Globals['ppboards'] == "closed" && $User['adminedit'] != 1 )
{
    diewell( $Globals['closedmsg'] );
}

// Init some variables
if ( !isset($ppaction) ) $ppaction="albums";
if ( !isset($category) || $User['assign'] == 0 || empty($category))
{
    $category = null;
}

if ( $gologin != 1 )
{
    if ( $nopost == 1 )
    {
        diewell($Globals['pp_lang']['albnoperm']);
    }

    if ( $User['uploads'] == 2 )
    {
        diewell($Globals['pp_lang']['noverify']);
    }
}

if ( ($Globals['allowpa'] == "no" || $User['albums'] == 0) && $User['adminedit'] != 1 )
{
    diewell($Globals['pp_lang']['nopa']);
}

topmenu();

if ( isset($albumid) && $User['adminedit'] != 1 )
{
    $security = ppmysql_query("SELECT parent FROM {$Globals['pp_db_prefix']}categories WHERE id=$albumid AND cattype='a'", $link);
    list($thisparent) = mysql_fetch_row($security);

    if ( $thisparent != $User['userid'] )
    {
        diewell($Globals['pp_lang']['invalidid']);
    }
}

if ( $ppaction == "albums" )
{
    $albumcode = albumli( $User['userid'] );

    printheader( 0, $Globals['pp_lang']['useralbums'] );
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/alb-add.tmpl" );

    printfooter();
    exit;
}

if ($ppaction == "addalbum")
{
    //# Add a album
    if ( !empty($do) )
    {
        if ( !isset($isprivate) ) $isprivate = "no";
        if ( !isset($canzip) )    $canzip = "no";
        if ( !isset($albumdesc) ) $albumdesc = null;
        if ( !isset($albumname) ) $albumname = $Globals['pp_lang']['newalbum'];

        $pa_password = null;
        if ( $isprivate == "yes" )
        {
            $pa_password = gen_password();
        }

        $setug = ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}categories (id,catname,parent,description,private,password,cattype,canzip) values(NULL,'$albumname','{$User['userid']}','$albumdesc','$isprivate','$pa_password','a','$canzip')", $link);
        $thealbumid = mysql_insert_id( $link );

        if ( $thealbumid == 0 )
        {
            diewell( "{$Globals['pp_lang']['errordir']}" );
        }

        mkppdir( "{$Globals['datafull']}$thealbumid" );

        if ( $Globals['datafull'] != $Globals['origfull'] )
        {
            mkppdir( "{$Globals['origfull']}$thealbumid" );
        }

        // Let's update the category cache
        update_catprops();

        forward( "useralbums.php?ppaction=albums", $Globals['pp_lang']['complete'] );
    }

    //# Print out the Add a album HTML form
    printheader( 0, $Globals['pp_lang']['useralbums'] );
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/alb-addalb.tmpl" );
    printfooter();

    exit;
}

if ($ppaction == "newpass")
{
    $pa_password = gen_password();

    $setug = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET password='$pa_password' WHERE id=$albumid", $link);

    // Let's update the category cache
    update_catprops();

    $ppaction = "editalbum";
    $do = null;
}


if ($ppaction == "editalbum")
 {
    if ( $do == "process" )
    {
        if ( !isset($isprivate) ) $isprivate="no";
        if ( !isset($canzip) )    $canzip = "no";
        if ( !isset($albumdesc) ) $albumdesc = null;
        if ( !isset($albumname) ) $albumname = "{$Globals['pp_lang']['newalbum']}";
        if ( !isset($category) || $category == 500 ) $category = null;
        if ( !isset($parent) || $parent == 500 || $albumid == $parent ) $parent = 0;

        $albuserid = $User['userid'];
        if ( $albumowner && $albumowner != $User['username'] && $User['adminedit'] == 1 )
        {
            list( $tid, $newowner, $tmail ) = get_userinfo($albumowner);

            if ( $tid > 0 )
            {
                $albuserid = $tid;
            }
        }

        $albumq = ppmysql_query("SELECT children,subalbum FROM {$Globals['pp_db_prefix']}categories WHERE id=$albumid", $link);
        list( $oldchild, $oldparent ) = mysql_fetch_row($albumq);

        $pa_password = null;

        if ( $isprivate == "yes" && $oldstat == "no" )
        {
            $pa_password = gen_password();
            ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET password='$pa_password' WHERE id=$albumid", $link);
        }
        elseif ( $isprivate == "no" && $oldstat == "yes" )
        {
            ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET password='' WHERE id=$albumid", $link);
        }

        // Fix the thumbnails prefix (if needed)
        if ( !empty($frames) && $frames != "thumbnail" )
        {
            $frames = "thumbnail-$frames";
        }

        $intro = ( $intro == "yes" ? "yes" : "no" );

        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET catname='$albumname', description='$albumdesc',
                       private='$isprivate', children='$category', sortorder=$sortorder, catorder=$catorder, canzip='$canzip',
                       theme='$theme', frames='$frames', subalbum=$parent, parent=$albuserid, thumbtype=$thumbtype,
                       intro='$intro', introcopy='$introcopy', introtitle='$introtitle' WHERE id=$albumid", $link);

        if ( $oldparent != $parent )
        {
            // They reassigned, so recalc old assignment and new
            updateparents( $oldparent );
            updateparents( $parent );

            upgradecategories( $oldparent );

            // We only need run this once if we do a full rescan
            if ( $oldparent != 0 )
            {
                upgradecategories( $parent );
            }
            else
            {
                $rerun = true;
            }
        }

        // We only need run this once if we do a full rescan
        if ( $oldchild != $category && $rerun == false )
        {
            // No need to run these twice!
            if ( $oldchild != $oldparent && $oldchild != $parent )
            {
                updateparents( $oldchild );
            }

            if ( $category != $oldparent && $category != $parent )
            {
                updateparents( $category );
            }

            // They reassigned, so recalc old assignment and new
            upgradecategories( $oldchild );

            if ( $oldchild != 0 )
            {
                upgradecategories( $category );
            }
        }

        // Let's update the category cache
        update_catprops();

        if ( $admin == 1 )
        {
            forward( "adm-misc.php?admact=albums", $Globals['pp_lang']['complete'] );
        }
        else
        {
            forward( "useralbums.php?ppaction=albums", $Globals['pp_lang']['complete'] );
        }

        forward( "useralbums.php?ppaction=albums", $Globals['pp_lang']['complete'] );
    }

    printheader( 0, $Globals['pp_lang']['editalbum'] );

    $boards = ppmysql_query("SELECT c.id,c.catname,c.description,c.private,c.password,c.children,c.parent,c.subalbum,c.thumbtype,
                              c.catorder,c.sortorder,c.thumbnail,c.canzip,c.theme,c.frames,c.albums,c.intro,c.introtitle,c.introcopy,
                              p.bigimage,p.userid,p.cat,p.storecat
                              FROM {$Globals['pp_db_prefix']}categories c
                              LEFT JOIN {$Globals['pp_db_prefix']}photos p ON p.id=c.thumbnail
                              WHERE c.id=$albumid", $link);

    list($id,$albumname,$albumdesc,$isprivate,$password,$child,$parent,$albpar,$thumbtype,$catorder,$sortorder,$thumbnail,$canzip,$deftheme,$defframe,$haschild,$intro,$introtitle,$introcopy,$bigimage,$imguser,$imgcat,$imgstore) = mysql_fetch_row($boards);

    list( $origid, $origowner, $origmail ) = get_userinfo( "", $parent);

    // First lets get the selection for any parents assigned
    $selected = $albpar;

    catmoveopt( 0, 0, 0, 1, true, true );

    $alboptions = "<option value=\"500\" $child>{$Globals['pp_lang']['notassigned']}</option>$catoptions";
    $catoptions = null;

    // Now get selection for any assigned categories
    $selected = $child;
    if ( $haschild == null )
    {
        catmoveopt( 0, 1, 1 );
    }

    $catoptions = "<option value=\"500\" $child>{$Globals['pp_lang']['notassigned']}</option>$catoptions";

    // sort box
    $resultc = ppmysql_query("SELECT * FROM {$Globals['pp_db_prefix']}sort", $link);

    $sortdefault = null;
    $soptions = null;

    while ( list($sortid, $sortname, $sortc) = mysql_fetch_row($resultc) )
    {
        if ($sortid == $sortorder)
        {
            $sortdefault = "<option selected=\"selected\" value=\"$sortid\">$sortname</option>";
            $sortcode = "$sortc";
        }
        else
        {
            $soptions .= "<option value =\"$sortid\">$sortname</option>";
        }
    }

    $sortoptions = "<select name=\"sortorder\" style=\"font-size: 9pt; background: FFFFFF;\">$sortdefault$soptions</select>";
    // end sort box //

    $persel = ( $child == "" ? "" : "selected=\"selected\"" );

    $albumname = str_replace( "\"", "&quot", $albumname);
    $albumdesc = str_replace( "\"", "&quot", $albumdesc);

    if ( $isprivate == "yes" )
    {
        $privatecode = "<select name=\"isprivate\"><option value=\"yes\" selected=\"selected\">{$Globals['pp_lang']['yes']}</option><option value=\"no\">{$Globals['pp_lang']['no']}</option></select>";
        $gencode = "{$Globals['pp_lang']['curpassword']}: <b>$password</b> <span class=\"{$Style['small']}\">(<a href=\"{$Globals['maindir']}/useralbums.php?ppaction=newpass&albumid=$albumid\">{$Globals['pp_lang']['genpass']}</a>)</span>";
    }
    else
    {
        $privatecode = "<select name=\"isprivate\"><option value=\"no\" selected=\"selected\">{$Globals['pp_lang']['no']}</option><option value=\"yes\">{$Globals['pp_lang']['yes']}</option></select>";
        $gencode = null;
    }

    if ($canzip == "yes")
    {
        $zipcode = "<select name=\"canzip\"><option value=\"yes\" selected=\"selected\">{$Globals['pp_lang']['yes']}</option><option value=\"no\">{$Globals['pp_lang']['no']}</option></select>";
    }
    else
    {
        $zipcode = "<select name=\"canzip\"><option value=\"no\" selected=\"selected\">{$Globals['pp_lang']['no']}</option><option value=\"yes\">{$Globals['pp_lang']['yes']}</option></select>";
    }

    if ( !empty($bigimage) )
    {
        if ( $imgstore != 0 )
        {
            $imgcat = $imgstore;
        }

        $thumbrc = get_imagethumb( $bigimage, $imgcat, $imguser, 1 );
        $thumbrc = "<a href=\"{$Globals['maindir']}/showphoto.php?photo=$thumbnail\" target=\"_blank\">$thumbrc</a>";
    }
    else
    {
        $thumbrc = "{$Globals['pp_lang']['none']}";
    }

    // Themes and Frames
    if( $Globals['forumstyle'] == "no" )
    {
        $dir_name = "{$Globals['PP_PATH']}/stylesheets";
        $dir = opendir($dir_name);
        $themesel = null;

        if ( $deftheme != "" )
        {
            $themesel = "<option selected=\"selected\">$deftheme</option>";
        }

        $themesel .= "<option value=\"\">{$Globals['pp_lang']['admindefault']}</option>";

        while ($file_name = readdir($dir))
        {
            if (($file_name != ".") && ($file_name != "..") && ($file_name != "template.css") && (stristr($file_name,".css")))
            {
                $file_name = str_replace(".css", "", $file_name);
                if ( $file_name != $setting )
                {
                    $themesel .= "<option value=\"$file_name\">$file_name</option>";
                }
            }
        }
        closedir($dir);
    }

    $dir_name = "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}";
    $dir = opendir($dir_name);
    $framesel = null;

    if ( !empty($defframe) )
    {
        $defframe = str_replace("thumbnail-", "", $defframe);
        $framesel = "<option selected=\"selected\">$defframe</option>";
    }
    $framesel .= "<option value=\"0\">{$Globals['pp_lang']['admindefault']}</option>";

    while ($file_name = readdir($dir))
    {
        if ( stristr($file_name,"thumbnail") )
        {
            $file_name = str_replace(".tmpl", "", $file_name);
            $file_name = str_replace("thumbnail-", "", $file_name);
            if ( $file_name != $setting )
            {
                $framesel .= "<option value=\"$file_name\">$file_name</option>";
            }
        }
    }
    closedir($dir);

    if ( $thumbtype == 1 )
    {
       $thumbtype = "<select name=\"thumbtype\"><option value=\"0\">{$Globals['pp_lang']['gallery']}</option><option value=\"1\" selected=\"selected\">{$Globals['pp_lang']['thumbnail']}</option><option value=\"2\">{$Globals['pp_lang']['withtitles']}</option><option value=\"3\">{$Globals['pp_lang']['groupby']}</option><option value=\"4\">{$Globals['pp_lang']['puzzle']}</option></select>";
    }
    elseif( $thumbtype == 2 )
    {
       $thumbtype = "<select name=\"thumbtype\"><option value=\"0\">{$Globals['pp_lang']['gallery']}</option><option value=\"1\">{$Globals['pp_lang']['thumbnail']}</option><option value=\"2\" selected=\"selected\">{$Globals['pp_lang']['withtitles']}</option><option value=\"3\">{$Globals['pp_lang']['groupby']}</option><option value=\"4\">{$Globals['pp_lang']['puzzle']}</option></select>";
    }
    elseif( $thumbtype == 3 )
    {
       $thumbtype = "<select name=\"thumbtype\"><option value=\"0\">{$Globals['pp_lang']['gallery']}</option><option value=\"1\">{$Globals['pp_lang']['thumbnail']}</option><option value=\"2\">{$Globals['pp_lang']['withtitles']}</option><option value=\"3\" selected=\"selected\">{$Globals['pp_lang']['groupby']}</option><option value=\"4\">{$Globals['pp_lang']['puzzle']}</option></select>";
    }
    elseif( $thumbtype == 4 )
    {
       $thumbtype = "<select name=\"thumbtype\"><option value=\"0\">{$Globals['pp_lang']['gallery']}</option><option value=\"1\">{$Globals['pp_lang']['thumbnail']}</option><option value=\"2\">{$Globals['pp_lang']['withtitles']}</option><option value=\"3\">{$Globals['pp_lang']['groupby']}</option><option value=\"4\" selected=\"selected\">{$Globals['pp_lang']['puzzle']}</option></select>";
    }
    else
    {
       $thumbtype = "<select name=\"thumbtype\"><option value=\"0\" selected=\"selected\">{$Globals['pp_lang']['gallery']}</option><option value=\"1\">{$Globals['pp_lang']['thumbnail']}</option><option value=\"2\">{$Globals['pp_lang']['withtitles']}</option><option value=\"3\">{$Globals['pp_lang']['groupby']}</option><option value=\"4\">{$Globals['pp_lang']['puzzle']}</option></select>";
    }

    if ($intro == "yes")
    {
        $introopt = "<option value=\"yes\" selected=\"selected\">{$Globals['pp_lang']['yes']}</option><option value=\"no\">{$Globals['pp_lang']['no']}</option>";
    }
    else
    {
        $introopt = "<option value=\"yes\">{$Globals['pp_lang']['yes']}</option><option value=\"no\" selected=\"selected\">{$Globals['pp_lang']['no']}</option>";
    }

    $introtitle = htmlentities( $introtitle );
    $introcopy = htmlentities( $introcopy );

    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/alb-editalb.tmpl" );
    printfooter();

    exit;
}

if ( $ppaction == "delalbum" )
{
    //# Delete a album
    if ( $do == "process" )
    {
        //# Process delete album
        if ( $albumid != 500 && $albumid != "0" && $albumid != "" )
        {
            delete_cat($albumid, "a");
        }
        else
        {
            diewell($Globals['pp_lang']['invalidid']);
        }

        // Let's update the category cache
        update_catprops();

        forward( "useralbums.php?ppaction=albums", $Globals['pp_lang']['complete'] );
    }

    // Generate an 'are you sure' you want to delete? form...

    $albumq = ppmysql_query("SELECT catname FROM {$Globals['pp_db_prefix']}categories WHERE id=$albumid", $link);
    list( $albumname ) = mysql_fetch_row($albumq);

    printheader( 0, $Globals['pp_lang']['deleteuser'] );
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/alb-confirm.tmpl" );
    printfooter();
}

?>