<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

// For flash uploader, we need to use sessions
session_start();
$_SESSION["file_info"] = array();

define( 'THIS_SCRIPT', "uploadphoto" );
require "pp-inc.php";
require "{$Globals['PP_PATH']}/image-inc.php";

typecast($_REQUEST, array('cat' => INT, 'noflash' => INT));
typecast($_POST, array('process' => STRING, 'category' => STRING, 'skipupload' => STRING, 'processall' => STRING,
                       'upuser' => STRING, 'deftitle' => STRING,'defdesc' => STRING, 'defkeywords' => STRING, 'updir' => STRING,
                       'downloadurl' => STRING, 'skipwater' => STRING, 'albumsel' => INT, 'dthumbs' => STRING,
                       'notify' => STRING, 'rating' => STRING, 'comments' => STRING, 'numprocess' => INT,
                       'keywords' => STRING, 'mature' => STRING) );

$noflash = ( $noflash == 1 ? 1 : 0 );
$allowed = array ( 'img' => array('src') );

function check_tags( $data, $allowed )
{
    $data = preg_replace("/<(.*?)>/e", "process_tag(stripslashes('\\1'), \$allowed)", $data);
    $data = str_replace('javascript:','#',$data);

    return( $data );
}


function process_tag( $data, $allowed )
{
    global $imgtags;

    # ending tags
    if ( preg_match("/^\/([a-z0-9]+)/i", $data, $matches) )
    {
        $name = strtolower($matches[1]);

        if (in_array($name, array_keys($allowed)))
        {
            return "</" . $name . ">";
        }
        else
        {
            return "";
        }
    }

    # starting tags
    if ( preg_match("/^([a-z0-9]+)(.*?)(\/?)$/i", $data, $matches) )
    {
        $name = strtolower($matches[1]);
        $body = $matches[2];
        $ending = $matches[3];

        if ( in_array($name, array_keys($allowed)) )
        {
            $params = null;
            preg_match_all("/([a-z0-9]+)=\"(.*?)\"/i", $body, $matches_2, PREG_SET_ORDER);
            preg_match_all("/([a-z0-9]+)=([^\"\s]+)/i", $body, $matches_1, PREG_SET_ORDER);
            $matches = array_merge($matches_1, $matches_2);

            foreach( $matches as $match )
            {
                $pname = strtolower($match[1]);

                if ( in_array($pname, $allowed[$name]) )
                {
                    $params .= " $pname=\"$match[2]\"";
                }
            }

            $imgtags[] .= "<" . $name.$params.$ending . ">";

            return "<" . $name.$params.$ending . ">";

        }
        else
        {
            return "";
        }
    }

    # garbage, ignore it
    return "";
}

if ( is_array($_FILES) )
{
    while( list($key,$value) = each($_FILES) )
    {
        ${$key} = $value;
    }
}

authenticate();

if ( $Globals['ppboards'] == "closed" && $User['adminedit'] != 1 )
{
    diewell( $Globals['closedmsg'] );
}

if ( $User['adminedit'] == 0 && $Globals['allowup'] == "no" )
{
    diewell( $Globals['pp_lang']['upnot'] );
}

$querystring = findenv("QUERY_STRING");
if ( ($User['uploads'] == 0 && $gologin==1) || $querystring == "gologin" )
{
    login( "{$Globals['maindir']}/uploadphoto.php" );
    exit;
}

if ( $User['uploads'] == 0 )
{
    diewell($Globals['pp_lang']['noupload']);
}

if ( $User['uploads'] == 2 )
{
    diewell($Globals['pp_lang']['noverify']);
}

if ( $User['uploadlimit'] > 0 )
{
    $upload = ppmysql_query("SELECT COUNT(*) FROM {$Globals['pp_db_prefix']}photos WHERE userid={$User['userid']} AND date > UNIX_TIMESTAMP( DATE_SUB(NOW(), INTERVAL 24 HOUR) )", $link);
    list( $uploadchk ) = mysql_fetch_row($upload);

    if ( $uploadchk >= $User['uploadlimit'] )
    {
        $Globals['pp_lang']['uplimit'] = str_replace( "%pics%", $uploadchk, $Globals['pp_lang']['uplimit'] );
        diewell($Globals['pp_lang']['uplimit']);
    }
}

topmenu();

if ( isset($cat) && !empty($cat) )
{
    $ctitleq = ppmysql_query("SELECT id,catname,thumbs,cattype,parent,password,theme FROM {$Globals['pp_db_prefix']}categories WHERE id=$cat", $link);
    list( $catid, $thecatname, $catthumbs, $cattype, $catparent, $thiscatpass, $cattheme ) = mysql_fetch_row($ctitleq);

    if ( $cattheme != "" && $Globals['forumstyle'] == "no" )
    {
        $Globals['theme'] = $cattheme;

        if ( is_dir( "{$Globals['PP_PATH']}/stylesheets/{$Globals['theme']}" ) )
        {
            $Globals['idir'] = "{$Globals['maindir']}/stylesheets/{$Globals['theme']}";
        }
    }
}
else
{
    $cat = 500;
}

if ( empty($process) )
{
    printheader( $cat, $Globals['pp_lang']['uploadphoto'] );

    $selected = $cat;
    catmoveopt(0,0,0,1);
    $albumcats = $catoptions;
    $catoptions = null;
    catmoveopt(0,1);

    $resulta = ppmysql_query("SELECT SUM(filesize) AS fsize FROM {$Globals['pp_db_prefix']}photos WHERE userid={$User['userid']} AND storecat=0", $link);
    list( $diskuse ) = mysql_fetch_row($resulta);

    // $disk_k is set in login-inc and is their max upload space
    $disk_b = $disk_k * 1024;

    // For graph of status
    $usedpx = 0;
    $availpx = 100;

    if ( $disk_k > 0 )
    {
        $diskbytes = $disk_b - $diskuse;

        if ( $diskbytes < 0 )
        {
            diewell( $Globals['pp_lang']['overquota'] );
        }

        $diskspace = ( $diskbytes / 1024 );

        if ( $diskuse > 0 )
        {
            $usedpx = 100 - round(($diskbytes/$disk_b)*100);
            $availpx = round(100 - $usedpx);
        }

        $diskspace = number_format( sprintf("%1.1f", $diskspace) ). "{$Globals['pp_lang']['kb']} ($diskbytes {$Globals['pp_lang']['bytes']})";
        $diskbytes = number_format( $diskbytes );
        $disk_b = number_format($disk_b);
        $disk_k = number_format($disk_k) . "{$Globals['pp_lang']['kb']} ($disk_b {$Globals['pp_lang']['bytes']})";
    }
    else
    {
        $diskspace = $Globals['pp_lang']['unlimit'];
        $disk_k = $Globals['pp_lang']['unlimit'];
    }

    // Grab number of queued images
    $inpath = "{$Globals['zipuploaddir']}/{$User['userid']}";
    $photocount = 0;

    if ( $handle = @opendir( $inpath ) )
    {
        while ( $realname = readdir( $handle ) )
        {
            if (( $realname != ".") && ( $realname != ".." ) )
            {
                $filepath = "$inpath/$realname";
                if ( !is_image($realname) && !is_multimedia($realname) )
                {
                    @unlink( $filepath );
                    continue;
                }

                $diskuse += filesize( $filepath );
                $photocount++;
            }
        }

        if ( $photocount > 0 )
        {
            $photocount = "<a href=\"{$Globals['maindir']}/bulkupload.php?ppaction=addphotos&amp;do=preview&amp;defcat=$cat\">$photocount</a>";
        }
    }

    $diskusekb = $diskuse/1024;
    $diskusekb = number_format( sprintf("%1.1f", $diskusekb ));
    $diskuse = number_format( $diskusekb ) ."{$Globals['pp_lang']['kb']} ($diskuse {$Globals['pp_lang']['bytes']})";

    $Globals['pp_lang']['uplimit2'] = str_replace( "%pictures%", $User['uploadlimit'], $Globals['pp_lang']['uplimit2'] );
    $imagetype = str_replace( ".", "", $Globals['acceptimg']);

    if ( $Globals['allowmedia'] == "yes" )
    {
        $imagetype .= "<br />" . str_replace( ".", "", $Globals['acceptmm']);
    }

    if ( $User['adminedit'] == 1 )
    {
        $imgdir = "{$Globals['zipuploaddir']}/{$User['userid']}";

        //if you have a low number of users you can use this drop down list box, otherwise you have to input the name manually
        //$useroptions = "<select name=\"upuser\"><option selected=\"userid\" value=\"{$User['userid']}\">{$User['username']}</option>";
        //$useroptions .= useropts();
        //$useroptions .= "</select>";

        $utemp = $User['username'];
        if ( $Globals['vbversion'] == "ib3" || $Globals['vbversion'] == "fusion" || $Globals['vbversion'] == "threads" || $Globals['vbversion'] == "threads7" )
        {
            $utemp = $User['login'];
        }

        $useroptions = "<tr>
					<td class=\"{$Style['tddetails']}\" width=\"50%\" align=\"left\"><span class=\"{$Style['small']}\">{$Globals['pp_lang']['upuser']}</span></td>
					<td class=\"{$Style['tddetails']}\" width=\"50%\" align=\"left\">
					    <input type=\"text\" name=\"upuser\" value=\"$utemp\" />
                    </td>
					</tr>";
    }
    else
    {
        $skiphtml = null;
    }

		for( $i = 0; $i < $Globals['maxfiles']; $i++ )
		{
		    $uploadfields .= "<input type=\"file\" name=\"theimage[]\" size=\"50\" /><br />";
		}

    if ( $up_k > 0 )
    {
        $maxfilesize = $up_k . "{$Globals['pp_lang']['kb']} {$Globals['pp_lang']['filelimit']}";
    }
    else
    {
        $maxfilesize = $Globals['pp_lang']['nolimit'];
    }

    if ( $Globals['allowzip'] == "yes" )
    {
        $upmmmb = $Globals['mmuploadsize'] / 1000;
        $upmmmb = number_format( $upmmmb, 2 );
        $Globals['pp_lang']['zips'] = str_replace( "%mmsize%", $upmmmb, $Globals['pp_lang']['zips'] );
        $maxfilesize .= "<br />{$Globals['pp_lang']['zips']}";
    }

    $Globals['mmuploadsize'] = $Globals['mmuploadsize'] * 1024;

    // Reformat for screen, just in case
    $Globals['pp_lang']['topcat'] = str_replace( "<p>", " ", $Globals['pp_lang']['topcat'] );

    $moreinfo = null;
    if ( $Globals['maxfiles'] > 1 && $Globals['allowmedia'] == "yes" )
    {
        if ( $Globals['allowzip'] == "yes" )
        {
            $moreinfo = "<br />{$Globals['pp_lang']['multizips']}";
        }
        else
        {
            $moreinfo = "<br />{$Globals['pp_lang']['multifile']}";
        }
    }

    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );

    if ( $User['userid'] < 1 || $Globals['flashupload'] == "no" || $noflash == 1 )
    {
        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/uploadphoto.tmpl" );
    }
    else
    {
        $_SESSION['userid'] = $User['userid'];
        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/uploadphoto2.tmpl" );
    }

    printfooter();
}
else
{
    $wasuploaded = "no";

    if ( $category == 0 )
    {
        $category = 500;
    }

    if ( $albumsel > 0 )
    {
        $category = $albumsel;
    }

    if ( $processall != "processall" )
    {
        $processall = "no";
    }

    // If we are uploading as a different user, set us to that user
    $uploaduser = $User['userid'];
    check_user_dir( $uploaduser );

    if ( isset($upuser) )
    {
        if ( !empty($upuser) && $upuser != $User['username'] )
        {
            list( $upuserid, $tusername, $tmail ) = get_userinfo($upuser);
            if ( empty($upuserid) )
            {
                diewell( "$upuser: {$Globals['pp_lang']['nofind']}" );
            }
        }

        check_user_dir( $upuserid );
    }

    if ( $category == "notcat" )
    {
        diewell( $Globals['pp_lang']['topcat'] );
    }

    if ( $skipupload == "skipupload" )
    {
        $upuser = urlencode(stripslashes(un_htmlspecialchars($upuser)));
        $deftitle = urlencode(stripslashes(un_htmlspecialchars($deftitle)));
        $defdesc = urlencode(stripslashes(un_htmlspecialchars($defdesc)));
        $defkeywords = urlencode(stripslashes(un_htmlspecialchars($defkeywords)));
        $updir = urlencode(stripslashes(un_htmlspecialchars($updir)));
        $ismature = ( $mature == "yes" ? 1 : 0 );

        if( isset($skipwater) )
        {
            forward( "bulkupload.php?ppaction=addphotos&do=preview&photopath=$uploaduser&upuser=$upuser&notify=$notify&defcat=$category&numprocess=$numprocess&deftitle=$deftitle&defdesc=$defdesc&defkeywords=$defkeywords&updir=$updir&processall=$processall&skipwater=true&dthumbs=$dthumbs&mature=$ismature", $Globals['pp_lang']['prepare'] );
        }
        else {
            forward( "bulkupload.php?ppaction=addphotos&do=preview&photopath=$uploaduser&upuser=$upuser&notify=$notify&defcat=$category&numprocess=$numprocess&deftitle=$deftitle&defdesc=$defdesc&defkeywords=$defkeywords&updir=$updir&processall=$processall&dthumbs=$dthumbs&mature=$ismature", $Globals['pp_lang']['prepare'] );
        }

    }

    // Grab any URL images (if specified)
    if ( isset($downloadurl) && !empty($downloadurl) )
    {
        // Process a single image?
        if ( is_image($downloadurl) )
        {
            $handle = @fopen( $downloadurl, "rb" );
            if ( !$handle )
            {
                $tryagain = "{$thishost}$downloadurl";
                $handle = @fopen( $tryagain, "rb" );
            }
            $imgstring = null;

            if ( $handle )
            {
                // Read in 4k blocks
                while ( !feof($handle) )
                {
                    $imgstring .= fread( $handle, 4096 ) ;
                }

                fclose($handle);

                $realname = substr( $downloadurl, strrpos($downloadurl, "/")+1 );
                $filepath = "{$Globals['zipuploaddir']}/{$User['userid']}/$realname";
                $handle = fopen( $filepath, "wb+" );
                fwrite( $handle, $imgstring, strlen($imgstring) ) ;
                fclose($handle);
            }
        }
        elseif (preg_match("/^(http|https|ftp):\/\/(([A-Z0-9][A-Z0-9_-]*)(:[A-Z0-9][A-Z0-9_-]*)?@)?(([A-Z0-9][A-Z0-9_-]*)(\.[A-Z0-9][A-Z0-9_-]*)+)(:(\d+))?(\/)?/i", $downloadurl) )
        {
            // Process a page?

            $getUrl = @file($downloadurl);

            $imgtags = array();
            $processed_data = check_tags($getUrl, $allowed);

            if ( count($imgtags) > 0 )
            {
                $parseurl = parse_url($downloadurl);
                $thishost = "{$parseurl[scheme]}://{$parseurl[host]}";

                for ( $x=0; $x<count($imgtags); $x++ )
                {
                    $imgtag = null;

                    $imgtag = str_replace( "<img src=\"", "", $imgtags[$x] );
                    $imgtag = str_replace( "\"/>", "", $imgtag );
                    $imgtag = str_replace( "\" />", "", $imgtag );
                    $imgtag = str_replace( "\">", "", $imgtag );
                    $imgtag = str_replace( "&amp;", "&", $imgtag );

                    $handle = @fopen( $imgtag, "rb" );
                    if ( !$handle )
                    {
                        // Nothing there, maybe relative to the top of the site?
                        $tryagain = "{$thishost}$imgtag";
                        $handle = @fopen( $tryagain, "rb" );

                        if ( !$handle )
                        {
                            // Nothing so far, probably relative, so check from the location of the file down
                            $basedir = substr( $parseurl[path], 0, strrpos($parseurl[path], "/") );
                            $tryagain = "{$thishost}/$basedir/$imgtag";
                            $handle = @fopen( $tryagain, "rb" );
                        }
                    }
                    $imgstring = null;

                    if ( $handle )
                    {
                        // Read in 4k blocks
                        while ( !feof($handle) )
                        {
                            $imgstring .= fread( $handle, 4096 ) ;
                        }
                        fclose($handle);

                        $realname = substr( $imgtag, strrpos($imgtag, "/")+1 );
                        $filepath = "{$Globals['zipuploaddir']}/{$User['userid']}/$realname";
                        $handle = fopen( $filepath, "wb+" );
                        fwrite( $handle, $imgstring, strlen($imgstring) ) ;
                        fclose($handle);
                    }
                }
            }
        }
    }

    for( $i = 0; $i < $Globals['maxfiles']; $i++ )
    {
        $wasuploaded = "no";

        $testname = $_FILES['theimage']['name'][$i];
        $realsize = $_FILES['theimage']['size'][$i];

        if ( empty($testname) || $realsize < 1 )
        {
            break;
        }

        $realname = fixfilenames( $testname );
        $outfilename = "{$User['userid']}$realname";

        $filepath = "{$Globals['zipuploaddir']}/$uploaduser";
        $filedir = "$filepath/$outfilename";

        //
        // ZIP Uploads for Users
        //
        if ( $Globals['allowzip'] == "yes" )
        {
            if (strtolower(substr($outfilename,strlen($outfilename) - 4,4)) == ".zip" )
            {
                if ( $Globals['unregpho'] == "yes" && $gologin == 1 )
                {
                    diewell( $Globals['pp_lang']['zipreg'] );
                }

                require_once "{$Globals['PP_PATH']}/pclzip.lib.php";

                chdir( $filepath );
                $dst_file = handleupload( $filepath, $i );

                $archive = new PclZip($dst_file);
                $list = $archive->extract(PCLZIP_OPT_PATH, $dst_file, PCLZIP_OPT_REMOVE_ALL_PATH);

                //$sys_cmd = "{$Globals['zip_command']} -qq $dst_file";
                //system( $sys_cmd );
                unlink( $dst_file );
            }
        }

        if ( $Globals['allowmedia'] == "yes" )
        {
            if ( is_multimedia( $outfilename ) )
            {
                if ( $Globals['unregpho'] == "yes" && $gologin == 1 )
                {
                    diewell( $Globals['pp_lang']['vidreg'] );
                }

                handleupload( "{$Globals['zipuploaddir']}/{$User['userid']}", $i );
            }
        }

        if ( is_image($outfilename) )
        {
            handleupload( "{$Globals['zipuploaddir']}/{$User['userid']}", $i);
        }

        if ( $wasuploaded == "no" )
        {
            diewell("{$Globals['pp_lang']['notype']}: $realname");
        }
    }

    if ( empty($numprocess) )
    {
        $numprocess = 10;
    }

    if ( $i == 1 && is_image($outfilename) )
    {
        $resulta = ppmysql_query("SELECT maximages,extra1,extra2,extra3,extra4,extra5,extra6,numextra FROM {$Globals['pp_db_prefix']}categories where id=$category", $link);
        list( $maximages, $c1, $c2, $c3, $c4, $c5, $c6, $n1 ) = mysql_fetch_row($resulta);
        ppmysql_free_result($resulta);

        // Only do a "quick upload" if the user has nothing else to prompt for
        if ( $c1 == "" && $c2 == "" && $c3 == "" && $c4 == "" && $c5 == "" && $c6 == "" && $n1 == 0 && $Globals['optcats'] == "no" )
        {
            // Only uploaded 1 image, find it and process it...
            $inpath = "{$Globals['zipuploaddir']}/{$User['userid']}";
            if ( $User['adminedit'] == 1 )
            {
                if ( isset($upuser) && !empty($upuser) && $upuser != $User['userid'] )
                {
                    list( $upuserid, $tusername, $tmail ) = get_userinfo($upuser);

                    if ( empty($upuserid) )
                    {
                        diewell( "$upuser: Unable to find this user. Please check spelling." );
                    }
                }
                else
                {
                    $upuserid = $User['userid'];
                }

                if ( !empty($updir) )
                {
                    $inpath = $updir;

                    if ( !is_dir($updir) )
                    {
                        diewell( "Cannot find the directory: $updir" );
                    }
                }

                check_user_dir( $upuserid );
            }
            else
            {
                $upuserid = $User['userid'];
            }

            // And only do these if we are quick uploading...
            $resulta = ppmysql_query("SELECT COUNT(*), SUM(filesize) AS fsize FROM {$Globals['pp_db_prefix']}photos WHERE userid=$upuserid AND storecat=0", $link);
            list( $uploadchk, $diskuse ) = mysql_fetch_row($resulta);

            // $disk_k is set in forum file and is their max upload specs
            $disk_k = ($disk_k * 1024);
            $up_k = ($up_k * 1024);

            $filesize = $_FILES['theimage']['size'][0];
            $diskbytes = $disk_k - ($diskuse + $filesize);

            if ( $filesize > $up_k && $up_k != 0 )
            {
                @unlink( $filedir );
                diewell( "$realname ({$Globals['pp_lang']['exfiles']})" );
            }
            elseif ( $diskbytes < 0 && $disk_k != 0 )
            {
                @unlink( $filedir );
                include "{$Globals['PP_PATH']}/languages/{$Globals['pplang']}.php";
                diewell( $Globals['pp_lang']['overmax1'] );
            }

            if ( $maximages > 0 )
            {
                // This category has a limit on the number of photos, so we need to check if there are too many
                $resulta = ppmysql_query("SELECT COUNT(*) FROM {$Globals['pp_db_prefix']}photos WHERE cat=$category", $link);
                list( $numimages ) = mysql_fetch_row($resulta);

                if ( $numimages > $maximages )
                {
                    // Yep, too many images, lets remove the excess
                    $extras = $numimages - $maximages;
                    $numimages++;

                    $resultb = ppmysql_query("SELECT id,userid,bigimage,medsize FROM {$Globals['pp_db_prefix']}photos WHERE cat=$category ORDER BY date DESC LIMIT $maximages,$extras", $link);
                    while ( list( $pid, $uid, $bigimage, $medsize ) = mysql_fetch_row($resultb) )
                    {
                        remove_all_files( $bigimage, $medsize, $uid, $defcat );

                        ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}photos WHERE id=$pid", $link);
                        ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}exif WHERE photoid=$pid", $link);
                        ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}comments WHERE photo=$pid", $link);
                        ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}notify WHERE photo=$pid", $link);
                    }

                    upgradecategories($category);
                }
            }

            if ( $handle = opendir( $inpath ) )
            {
                while ( $processname = readdir( $handle ) )
                {
                    $filein = "{$inpath}/$processname";

                    if ( $processname == $realname && is_file($filein) )
                    {
                        $title = $deftitle;
                        $desc = $defdesc;
                        $keywords = $defkeywords;

                        $chkrealname  = fixfilenames($realname);

                        if ( strcmp($chkrealname, $realname) != 0 )
                        {
                            $newfile = "{$inpath}/$chkrealname";
                            @rename($filein, $newfile);
                            $realname = $chkrealname;
                            $filein = $newfile;
                        }

                        $catq = ppmysql_query("SELECT id FROM {$Globals['pp_db_prefix']}photos WHERE bigimage='$realname'", $link);
                        $imgchk = mysql_num_rows($catq);

                        if ( $imgchk != 0 )
                        {
                            // Image is a duplicate
                            $filenoext = get_filename( $realname );
                            $theext = get_ext( $realname );

                            $x = 0;
                            while ( $imgchk != 0 )
                            {
                                $x++;
                                $newfile = "$filenoext$x$theext";
                                $newfilepath = "{$inpath}/$newfile";

                                $catq = ppmysql_query("SELECT id FROM {$Globals['pp_db_prefix']}photos WHERE bigimage='$newfile'", $link);
                                $imgchk = mysql_num_rows($catq);

                                if ( $imgchk == 0 )
                                {
                                    @rename($filein, $newfilepath);
                                    $realname = $newfile;
                                    $filein = $newfilepath;
                                }
                            }
                        }

                        $filepath = "{$Globals['origfull']}$category/$realname";
                        copy( $filein, $filepath );
                        @chmod ($filepath, 0666);

                        // Open image, write out thumb, fullsize, and medium as needed
                        create_thumb( $realname, $filepath, $category );
                        $thisphoto = process_image( $realname, $filepath, $category );
                        @unlink ($filein);

                        // Force refresh of cache
                        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}cache SET timestamp=0 WHERE id=1", $link);

                        forward( "showphoto.php?photo=$thisphoto&cat=$category", $Globals['pp_lang']['processing'] );
                    }
                }
            }
        }
    }

    $upuser = urlencode(stripslashes(un_htmlspecialchars($upuser)));
    $deftitle = urlencode(stripslashes(un_htmlspecialchars($deftitle)));
    $defdesc = urlencode(stripslashes(un_htmlspecialchars($defdesc)));
    $defkeywords = urlencode(stripslashes(un_htmlspecialchars($defkeywords)));
    $updir = urlencode(stripslashes(un_htmlspecialchars($updir)));
    $ismature = ( $mature == "yes" ? 1 : 0 );

    if ( isset($skipwater) )
    {
        forward( "bulkupload.php?ppaction=addphotos&do=preview&photopath=$uploaduser&upuser=$upuser&notify=$notify&rating=$rating&comments=$comments&defcat=$category&deftitle=$deftitle&defdesc=$defdesc&defdesc=$defdesc&defkeywords=$defkeywords&numprocess=$numprocess&processall=$processall&skipwater=true&dthumbs=$dthumbs&mature=$ismature", $Globals['pp_lang']['process'] );
    }
    else
    {
        forward( "bulkupload.php?ppaction=addphotos&do=preview&photopath=$uploaduser&upuser=$upuser&notify=$notify&rating=$rating&comments=$comments&defcat=$category&deftitle=$deftitle&defdesc=$defdesc&defdesc=$defdesc&defkeywords=$defkeywords&numprocess=$numprocess&processall=$processall&dthumbs=$dthumbs&mature=$ismature", $Globals['pp_lang']['process'] );
    }
}

?>
