<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

define( 'THIS_SCRIPT', "upgrade" );

ini_set("max_execution_time", 0);
ini_set("memory_limit", "20M");

error_reporting (E_ALL ^ E_NOTICE);

// Let's work from one variable
if (PHP_VERSION < '4.1.0') {
	$_GET = &$HTTP_GET_VARS;
	$_POST = &$HTTP_POST_VARS;
}

$magic = get_magic_quotes_gpc();
// Register the global variables
if (is_array($_GET)) {
    while(list($key,$value) = each($_GET)) {
        if ($magic) {
            $value = stripslashes($value);
        }
        ${$key} = $value;
    }
}

if (is_array($_POST)) {
    while(list($key,$value) = each($_POST)) {
        if ($magic) {
            $value = stripslashes($value);
        }
        ${$key} = $value;
    }
}
set_magic_quotes_runtime(0);
$skip_exheader = "yes";

if ( !isset($upgrade) ) {
    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"90%\" align=\"center\"><tr><td>
        <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\">
        <font color=\"#ffffff\" face=\"MS Sans Serif\" size=\"4\">Welcome to PhotoPost Upgrade Console</font>
        </td></tr>
        <tr><td bgcolor=\"#FFFFFF\"><font face=\"MS Sans Serif\">
        You are only minutes away getting your PhotoPost up to date. Below is a list of PhotoPost versions; you will want
        to select your current version from this list and then follow the pages through each step in the upgrade process.<br /><br />
        For example, if you have version 3.1.1, you would want to select the 3.1.1 option from the list - rerunning an upgrade script may cause damage which
        cannot be undone. If you are running a version which is not listed, then you only need to run those scripts which
        follow your version. For example, if you were running 3.25, then you would run the 3.3 upgrade.<br /><br />
        Always backup your database and data directory before performing an upgrade so you can easily
        fall back if you have problems.<br />
        <br />
        <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=252\">2.52</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade from Perl 2.52 to PHP</td>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=306\">3.0.6</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 3.0.6</td>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=310\">3.1.0</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 3.1.0</td>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=311\">3.1.1</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 3.1.1</td>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=32x\">3.2</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 3.2</td>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=33\">3.3</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 3.3</td>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=40\">4.0</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 4.0</td>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=41\">4.1</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 4.1.X</td>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=45\">4.5</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 4.5.X</td>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=46\">4.6</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 4.6</td>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=467\">4.6.X</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 4.6.X</td>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=47\">4.7</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 4.7x</td>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=482\">4.82</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 4.82</td>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=485\">4.85/4.86</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 4.85 or 4.86</td>
        </tr><tr>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=50\">5.0x to 5.1</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 5.0x</td>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=51\">5.1 to 5.11</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 5.1</td>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=511\">5.1x to 5.2x</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 5.1x to 5.2</td>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=52\">5.2x to 5.3</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 5.2/5.21 to 5.3</td>
        </tr>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=53\">5.3x to 5.5</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 5.3/5.31 to 5.5</td>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=55\">5.5 to 5.6</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 5.5 to 5.6</td>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=56\">5.6 to 5.61</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 5.6 to 5.61</td>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=561\">5.61/5.62 to 6.0</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 5.61/5.62 to 6.0</td>
        </tr>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=60\">6.0x to 6.1</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 6.0/6.01 to 6.1</td>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=61\">6.1x to 6.2</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 6.1/6.11 to 6.2</td>
        </tr>
        </tr><tr>
        <td align=\"center\" bgcolor=\"#FFFFFF\"><a href=\"upgrade.php?upgrade=62\">6.2x to 7.0</a></td>
        <td align=\"center\" bgcolor=\"#FFFFFF\">Upgrade 6.2x to 7.0</td>
        </tr>
        </table><br /><br />
        Make sure you have uploaded ALL of the files in the latest upgrade package to ensure you have everything you need to be up and running smoothly.
        </font></td></tr></table></td></tr></table>";

    print $output;
    exit;
}

if ( $upgrade == "252" ) {
    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade</font>
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\">
            This install script will upgrade your PERL version of PhotoPost to the PhotoPost PHP 3.0 release.  Only run this upgrade if you have the
            2.52 version of PhotoPost.<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=252&amp;step=1\">Proceed to Upgrade --></a></div></font></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }


    $query = array();
    $query[] = "CREATE TABLE useralbums (id smallint(4) NOT NULL auto_increment,albumname varchar(255) NOT NULL default '',parent int(5) NOT NULL default '0',description varchar(255) default NULL,isprivate varchar(4) NOT NULL default 'no',PRIMARY KEY (id),KEY parent(parent)) TYPE=MyISAM;";
    $query[] = "ALTER TABLE photos ADD rating int(2) NOT NULL default '0';";
    $query[] = "ALTER TABLE photos CHANGE medsize medsize mediumint(9) default '0';";
    $query[] = "REPLACE INTO sort VALUES (4,'Most Popular (by rating)','ORDER BY rating DESC, views DESC');";
    $query[] = "REPLACE INTO settings VALUES (91,'Allow users to move/delete their own images?','userdel','','no',58,5);";
    $query[] = "REPLACE INTO settings VALUES (92,'Display Members Gallery on the main index page?','showmem','','yes',55,2);";
    $query[] = "REPLACE INTO settings VALUES (93,'Require users to be registered to view images?','reqregister','','no',56,2);";
    $query[] = "DELETE FROM settings WHERE id='48';";
    $query[] = "UPDATE admingroups SET name=\"Index Display Values\" WHERE id=2;";
    $query[] = "UPDATE settings SET title=\"URL to your forum directory (blank if Internal)\" where id=7;";

    for ( $x=0; $x < count($query); $x++) {
        $iquery = $query[$x];
        print "Performing MySQL command: $iquery ... ";
        $setup = mysql_query($iquery, $link);
        if ( !$setup ) print "<b>Error: ".mysql_error($link)."</b><br />";
        else print "Successful!<br />";
    }

    print "<p>Finished!<br /><br />";

    //
    // Step 2 - here we run up the auto increment counter to 3000 so that any user groups
    // added will start at that high of a number (this way we know when we are dealing with user groups)
    //
    print "Adding/removing blank entries to useralbums...<br /><br />";

    for( $x=0; $x < 3000; $x++ ) {
        $query = "INSERT INTO useralbums (id,albumname,parent,description) values(NULL,'NULL',0,'NULL')";
        $resultb = mysql_query($query, $link);

        if ( !$resultb ) {
            print "Error inserting blank line into UserAlbums.<br />Error: ".mysql_error($link);
            break;
        }

        $thealbumid = mysql_insert_id( $link );

        if ( $thealbumid > 3000 )
            break;

        $query = "DELETE FROM useralbums WHERE id=$thealbumid";
        $resultb = mysql_query($query, $link);
    }

    print "<p>Finished!<br /><br />";

    //
    // Step 3 - here we query the photos and comments database to get the current "rating" of an image
    //
    print "Preparing to update database with new rating system...<br /><br />";

    $query1 = "SELECT id FROM photos";
    $resulta = mysql_query($query1,$link);

    while( list( $photoid ) = mysql_fetch_row($resulta) ) {
        $query2 = "SELECT rating FROM comments WHERE photo=$photoid AND rating != '0'";
        $resultb = mysql_query($query2,$link);

        $numrating=0; $sumrating=0; $averagerate=0;
        while( list ( $checkrating ) = mysql_fetch_row($resultb) ) {
            $numrating++;
            $sumrating = ($sumrating+$checkrating);
        }
        if ( $resultb ) mysql_free_result( $resultb );

        if ( $numrating != 0 && $sumrating != 0 ) $averagerate = round( $sumrating / $numrating );

        $query3 = "UPDATE photos SET rating=$averagerate WHERE id=$photoid";
        $resultc = mysql_query($query3,$link);

        //print "Query: [$query3]<br />";
    }
    mysql_free_result( $resulta );

    print "Finished upgrade! If you havent already, be sure to execute <a href=\"upgrade.php?upgrade=upgcats\">category upgrades</a> when you are finsihed!";
}

if ( $upgrade == "upgcats" ) {
    $skip_exheader = "yes";
    require "pp-inc.php";

    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Install</font>
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\">
            This install script is to upgrade PERL versions of PhotoPost to use the new directory based file structure. Do not run this
            script if you have done so before OR you are not upgrading the Perl version of PhotoPost.<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=upgcats&amp;step=1\">Proceed to Upgrade --></a></div></font></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    print "Starting to move image files... You can ignore any \"file exists errors\"...<br /><br />";

    $datadir = $Globals['datafull'];

    $query = "SELECT id,catname FROM categories";
    $resultb = mysql_query($query, $link);

    while ( list( $thecatid, $thecatname ) = mysql_fetch_row($resultb) ) {
        if ( strstr($datadir, "/") )
            $newdir = $datadir."$thecatid/";
        else
            $newdir = $datadir."$thecatid\\";

        @mkdir( $newdir, 0755 );
        @chmod( $newdir, 0777 );

        $query = "SELECT id,user,userid,cat,bigimage,medsize FROM photos where cat=$thecatid";
        $queryv = mysql_query($query,$link);

        while ( list( $id, $user, $tuserid, $cat, $bigimage, $medsize ) = mysql_fetch_row($queryv) ) {
            $theext = get_ext($bigimage);
            $filename = $bigimage;
            $filename = str_replace( $theext, "", $filename);

            $biglink = $Globals['datafull']."$tuserid$filename$theext";
            $newbiglink = $newdir."$tuserid$filename$theext";

            $thumblink = $Globals['datafull']."$tuserid$filename-thumb$theext";
            $newthumblink = $newdir."$tuserid$filename-thumb$theext";

            $mediumlink = $Globals['datafull']."$tuserid$filename-med$theext";
            $newmediumlink = $newdir."$tuserid$filename-med$theext";

            //print "Moving file: [$biglink] to [$newbiglink]<br />";
            //print "Moving medium file: [$mediumlink] to [$newmediumlink]<br />";
            //print "Moving thumbnail: [$thumblink] to [$newthumblink]<br /><br />";

            if ( file_exists( $biglink ) ) {
                if ( copy($biglink, $newbiglink) ) {
                    unlink( $biglink );
                }
                else {
                    print( "Copy of the file $biglink failed. Check your system when operation is complete.<br />" );
                }
            }
            else {
                if ( !file_exists( $newbiglink ) ) {
                    print "Warning: The file $biglink does not exist; but has an entry in your database.<br />";
                    // If you want to remove the links without filenames, uncomment the lines below
                    //
                    //print( "<b>The file $biglink does not exist. Entry removed from your database.</b><br />" );
                    //$queryd = "DELETE FROM photos where id=$id";
                    //$querydr = mysql_query($queryd,$link);
                }
            }

            if ( $medsize > 0 ) {
                if ( file_exists( $mediumlink ) ) {
                    if ( copy($mediumlink, $newmediumlink) ) {
                        unlink( $mediumlink );
                    }
                    else {
                        print( "Copy of the file $mediumlink failed. Check your system when operation is complete.<br />" );
                    }
                }
                else {
                    if ( !file_exists( $newmediumlink ) ) {
                        print "Warning: The file $mediumlink does not exist; but has an entry in your database.<br />";
                    }
                }
            }

            if ( file_exists( $thumblink ) ) {
                if ( copy($thumblink, $newthumblink) ) {
                    unlink( $thumblink );
                }
                else {
                    print( "Copy of the file $thumblink failed. Check your system when operation is complete.<br />" );
                }
            }
            else {
                $thethumbext = strtolower( $theext );
                $s_thumblink = $Globals['datafull']."$tuserid$filename-thumb$thethumbext";
                if ( file_exists( $s_thumblink ) ) {
                    if ( copy($s_thumblink, $newthumblink) ) {
                        unlink( $s_thumblink );
                    }
                    else {
                        print( "Copy of the file $s_thumblink failed. Check your system when operation is complete.<br />" );
                    }
                }
                else {
                    $s_thumblink = $Globals['datafull']."$tuserid$filename-thumb.jpg";
                    if ( file_exists( $s_thumblink ) ) {
                        if ( copy($s_thumblink, $newthumblink) ) {
                            unlink( $s_thumblink );
                        }
                        else {
                            print( "Copy of the file $s_thumblink failed. Check your system when operation is complete.<br />" );
                        }
                    }
                    else {
                        if ( !file_exists( $newthumblink ) ) {
                            print( "Warning: The thumbnail [$thumblink] does not exist.<br />" );
                        }
                    }
                }
            }
        }
        if ( $queryv ) mysql_free_result($queryv);
    }
    mysql_free_result( $resultb );

    print "Fixing database: changing smallint(6) to mediumint(9) for photos.medsize...";

    $query = "ALTER TABLE photos CHANGE medsize medsize mediumint(9) default '0'";
    $resultb = mysql_query($query, $link)or $mysql_eval_error = mysql_error($link);

    print "Starting to find image files and update file sizes in database...<br /><br />";

    $datadir = $Globals['datafull'];
    $query = "SELECT id,catname FROM categories";
    $resultb = mysql_query($query, $link);

    while ( $row = mysql_fetch_row($resultb) ) {
        list( $thecatid, $thecatname ) = $row;

        if ( strstr($datadir, "/") )
            $newdir = $datadir."$thecatid/";
        else
            $newdir = $datadir."$thecatid\\";

        $query = "SELECT id,user,userid,cat,bigimage,medsize FROM photos where cat=$thecatid";
        $queryv = mysql_query($query,$link);

        while ( $row = mysql_fetch_row($queryv) ) {
            list( $id, $user, $tuserid, $cat, $bigimage, $medsize ) = $row;

            $theext = substr($bigimage, strlen($bigimage) - 4,4);
            $filename = $bigimage;
            $filename = str_replace( $theext, "", $filename);

            $mediumlink = $newdir."$tuserid$filename-med$theext";

            if ( $medsize > 32766 ) {
                if ( file_exists( $mediumlink ) ) {
                    $newmedsize = filesize( $mediumlink );
                    $query = "UPDATE photos SET medsize=$newmedsize WHERE id=$id";
                    $resulta = mysql_query($query,$link);

                    print "$mediumlink: old size: $medsize  -  new size: $newmedsize<br />";
                }
            }
        }
    }

    print "Finished! You should continue to <a href=\"upgrade.php?upgrade=306\">the next step</a>";
}


if ( $upgrade == "306" ) {
    require "config-inc.php";

    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade</font>
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\">
            This install script will upgrade your 3.0.6 release to the 3.1.0 release.  Only run this upgrade if you have the
            3.0.6 version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=306&amp;step=1\">Proceed to Upgrade --></a></div></font></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    print "Preparing to update 3.0.6 database...<p>";

    // Connecting, selecting database
    $link = mysql_connect("$host", "$mysql_user", "$mysql_password") or die('I cannot connect to the PhotoPost database. [host:$host][mysql_user:$mysql_user][mysql_password:$mysql_password]');
    mysql_select_db ("$database", $link)or die("Could not connect to PhotoPost database");

    $query = array();

    $query[] = "REPLACE INTO settings VALUES (94,'Use traditional Members Gallery configuration?','memformat','','yes',57,2);";
    $query[] = "REPLACE INTO settings VALUES (95,'Display headers during SlideShows?','slidehead','','yes',58,2);";
    $query[] = "REPLACE INTO settings VALUES (97,'Maximum multimedia upload size in kB','mmuploadsize','','2000',88,3);";
    $query[] = "REPLACE INTO settings VALUES (98,'Allow users to create Personal Albums?','allowpa','','yes',53,5);";
    $query[] = "REPLACE INTO settings VALUES (99,'Allow multimedia uploads?','allowmedia','','no',88,3);";
    $query[] = "REPLACE INTO settings VALUES (100,'Allow members to rate photos?','allowrate','','yes',54,5);";
    $query[] = "REPLACE INTO settings VALUES (101,'Display new comments/photos indicator on index?','displaynew','','no',58,2);";
    $query[] = "ALTER TABLE users ADD site VARCHAR(30) default NULL;";
    $query[] = "ALTER TABLE users ADD views int(10) NOT NULL default '0';";
    $query[] = "ALTER TABLE useralbums ADD isprivate varchar(4) NOT NULL default 'no';";
    $query[] = "ALTER TABLE useralbums ADD password VARCHAR(16) NOT NULL;";
    $query[] = "ALTER TABLE users ADD offset INT(2) UNSIGNED DEFAULT '0' NOT NULL;";
    $query[] = "ALTER TABLE photos ADD watermarked varchar(5) NOT NULL default 'no';";
    $query[] = "CREATE TABLE favorites (id smallint(4) NOT NULL auto_increment, userid int(8) NOT NULL default '0', photo int(11) NOT NULL default '0', PRIMARY KEY  (id), KEY parent (photo)) TYPE=MyISAM;";
    $query[] = "CREATE TABLE laston (cat smallint(4) NOT NULL default '0', userid mediumint(9) NOT NULL default '0', laston int(11) unsigned default NULL, PRIMARY KEY  (cat,userid)) TYPE=MyISAM;";
    $query[] = "CREATE TABLE ipcache (id int(10) NOT NULL auto_increment,userid INT(25) NOT NULL, ipaddr VARCHAR(75) NOT NULL, date INT(11) UNSIGNED, type VARCHAR(4) NOT NULL, photo INT(10) NOT NULL, PRIMARY KEY (id)) TYPE=MyISAM;";
    $query[] = "REPLACE INTO sort VALUES (6, 'Random', 'ORDER BY RAND()');";
    $query[] = "REPLACE INTO sort VALUES (5, 'Least Popular', 'ORDER BY rating, views');";
    $query[] = "REPLACE INTO sort VALUES (4, 'Most Popular', 'ORDER BY rating DESC, views DESC');";
    $query[] = "REPLACE INTO sort VALUES (7, 'Alphabetical', 'ORDER BY bigimage');";
    $query[] = "DELETE FROM settings WHERE id=73;";
    $query[] = "DELETE FROM settings WHERE id=74;";
    $query[] = "DELETE FROM settings WHERE id=88;";
    $query[] = "DELETE FROM settings WHERE id=39;";
    $query[] = "DELETE FROM settings WHERE id=40;";
    $query[] = "DELETE FROM settings WHERE id=96;";

    for ( $x=0; $x < count($query); $x++) {
        $iquery = $query[$x];
        print "Performing MySQL command: $iquery ... ";
        $setup = mysql_query($iquery, $link);
        if ( !$setup ) print "<b>Error: ".mysql_error($link)."</b><br />";
        else print "Successful!<br />";
    }

    print "Fixing database: changing mediumint(9) to int(10) for photos.filesize...";

    $query = "ALTER TABLE photos CHANGE filesize filesize int(10) default '0'";
    $resultb = mysql_query($query, $link)or $mysql_eval_error = mysql_error($link);

    print "Starting to find image files and update file sizes in database...<br /><br />";

    $datadir = $Globals['datafull'];
    $query = "SELECT id,catname FROM categories";
    $resultb = mysql_query($query, $link);

    while ( $row = mysql_fetch_row($resultb) ) {
        list( $thecatid, $thecatname ) = $row;

        if ( strstr($datadir, "/") )
            $newdir = $datadir."$thecatid/";
        else
            $newdir = $datadir."$thecatid\\";

        $query = "SELECT id,user,userid,cat,bigimage,filesize FROM photos where cat=$thecatid";
        $queryv = mysql_query($query,$link);

        while ( list( $id, $user, $tuserid, $cat, $bigimage, $filesize ) = mysql_fetch_row($queryv) ) {
            $filelink = $newdir."$tuserid$bigimage";

            if ( $filesize > 8388606 ) {
                if ( file_exists( $filelink ) ) {
                    $newsize = filesize( $filelink );
                    $query = "UPDATE photos SET filesize=$newsize WHERE id=$id";
                    $resulta = mysql_query($query,$link);
                }
            }
        }
    }

    print "Finished upgrade! You should continue to <a href=\"upgrade.php?upgrade=311\">next step</a>";
}

if ( $upgrade == "311" ) {
    require "config-inc.php";

    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade</font>
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\">
            This install script will upgrade your 3.1.1 release.  Only run this upgrade if you have the
            3.1.1 version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=311&amp;step=1\">Proceed to Upgrade --></a></div></font></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    error_reporting (E_ALL ^ E_NOTICE);

    function catlist( $parid, $reiter=0 ) {
        global $Globals, $link, $cathash;

        $query = "SELECT id FROM categories WHERE parent=$parid ORDER BY catorder ASC";
        $boards = mysql_query($query,$link);

        if ( $reiter == 0 ) $cathash = "";

        while ( list ( $tid ) = mysql_fetch_row($boards) ) {
            if ( $cathash != "" ) $cathash .= ",";
            $cathash .= "$tid";
            catlist( $tid, 1 );
        }
        mysql_free_result( $boards );

        if ( $reiter == 0 ) {
            $catret = "cat IN ($cathash)";
            $query = "UPDATE categories SET children='$cathash' WHERE id=$parid";
            $resulta = mysql_query($query,$link);
        }

        return ( $catret );
    }

    function upgradecategories( $parent=0 ) {
        global $Globals, $link;

        // update categories
        //
        $query = "SELECT id,catname,description,catorder,parent,thumbs,children FROM categories ORDER BY catorder ASC";
        $boards = mysql_query($query, $link);
        //print "$query ... $boards<br />";

        while ( list( $id, $catname, $catdesc, $order, $catparent, $catthumbs, $children ) = mysql_fetch_row($boards) ) {
            print "Processing $catname ... ";
            catlist( $id );

            $lastposttime=""; $lastpostby=""; $lastpostlink="";
            $lastphoid=""; $lastphoby=""; $lpholink="";
            $newphotos=""; $newcomments=""; $laston=0;

            if ( $children != "" ) $children = "$id,$children";
            else $children = "$id";

            $cphotos=0; $catposts=0;

            if ( $id != "500" ) {
                $quid = "cat IN ($children)";

                if ( $quid != "" && $quid != "cat=" ) {
                    // first we need to get last photo/post info
                    $query = "SELECT id,user,userid,date FROM photos WHERE $quid ORDER BY date DESC";
                    print "$query<br />";
                    $lastp = mysql_query($query, $link);
                    list( $lastphoid, $lastphoby, $lastphobyid, $lastphotime ) = mysql_fetch_row($lastp);
                    mysql_free_result($lastp);

                    // now we get the number of photo, just in this category
                    $query = "SELECT id FROM photos WHERE cat=$id";
                    $lastp2 = mysql_query($query, $link);
                    $cphotos = mysql_num_rows($lastp2);
                    mysql_free_result($lastp2);

                    $query = "SELECT username,id,date,photo FROM comments WHERE $quid ORDER BY date DESC";
                    $lastc = mysql_query($query, $link);
                    $catposts = mysql_num_rows($lastc);
                    list( $lastpostby, $lastpostbyid, $lastposttime, $lastpostlink ) = mysql_fetch_row($lastc);
                    mysql_free_result($lastc);

                    $query = "SELECT id FROM comments WHERE cat=$id";
                    $lastc2 = mysql_query($query, $link);
                    $catposts = mysql_num_rows($lastc2);
                    mysql_free_result($lastc2);

                    // 3.1.2 - How to update children!
                    $query = "UPDATE categories SET lastpost='$lastpostbyid', lastphoto='$lastphoid', posts='$catposts', photos='$cphotos' WHERE id=$id";
                    $resulta = mysql_query($query,$link);
               }
            }
            else {
                if ( $Globals['memformat'] == "no" ) {
                    $query1 = "SELECT id,user,userid,date FROM photos WHERE cat=500 ORDER BY date DESC";
                    $query2 = "SELECT username,id,date,photo FROM comments WHERE cat=500 ORDER BY date DESC";
                }
                else {
                    $query1 = "SELECT id,user,userid,date FROM photos ORDER BY date DESC";
                    $query2 = "SELECT username,id,date,photo FROM comments ORDER BY date DESC";
                }

                $lastp = mysql_query($query1,$link);
                $cphotos = mysql_num_rows($lastp);
                list( $lastphoid, $lastphoby, $lastphobyid, $lastphotime ) = mysql_fetch_row($lastp);
                mysql_free_result($lastp);

                $lastc = mysql_query($query2,$link);
                $catposts = mysql_num_rows($lastc);
                list( $lastpostby, $lastpostbyid, $lastposttime, $lastpostlink ) = mysql_fetch_row($lastc);
                mysql_free_result($lastc);

                // 3.1.2 - How to update children!
                $query = "UPDATE categories SET lastpost='$lastpostbyid', lastphoto='$lastphoid', posts='$catposts', photos='$cphotos' WHERE id=500";
                $resulta = mysql_query($query,$link);
            }
        }

        return;
    }


    function upgradealbums( $parent=0 ) {
        global $Globals, $link;

        // update personal albums
        //
        $query = "SELECT id,albumname FROM useralbums";
        $boards = mysql_query($query, $link);

        while ( list( $id, $albumname ) = mysql_fetch_row($boards) ) {
            print "Processing Personal Album $albumname ...<br />";
            $cphotos=0; $catposts=0;

            // now we get the number of photo, just in this category
            $query = "SELECT id FROM photos WHERE cat=$id";
            $lastp2 = mysql_query($query, $link);
            $cphotos = mysql_num_rows($lastp2);
            mysql_free_result($lastp2);

            $query = "SELECT id FROM comments WHERE cat=$id";
            $lastc2 = mysql_query($query, $link);
            $catposts = mysql_num_rows($lastc2);
            mysql_free_result($lastc2);

            $query = "UPDATE useralbums SET posts='$catposts', photos='$cphotos' WHERE id=$id";
            $resulta = mysql_query($query,$link);
        }

        return;
    }


    print "Preparing to update 3.1.1 database...<p>";

    // Connecting, selecting database
    $link = mysql_connect("$host", "$mysql_user", "$mysql_password") or die('I cannot connect to the PhotoPost database. [host:$host][mysql_user:$mysql_user][mysql_password:$mysql_password]');
    mysql_select_db ("$database", $link)or die("Could not connect to PhotoPost database");

    //
    // check to see if this is the photo database update
    //

    $query = "SELECT varname,setting FROM settings";
    $getsets = mysql_query($query,$link);

    if ( !$getsets ) {
        print "Database not properly setup. Contact administrator.";
        exit;
    }

    while ( list($var, $set) = mysql_fetch_row($getsets)) {
        $Globals[$var] = stripslashes($set);
    }
    mysql_free_result($getsets);

    // Need to update this variable if no underscore at end
    if ( !empty($Globals['dprefix']) ) {
        $oldprefix = $Globals['dprefix'];

        if ( !strstr($oldprefix, "_") ) {
            $newprefix = $oldprefix."_";

            $query = "UPDATE settings SET setting='$newprefix' WHERE id=83";
            $resulta = mysql_query($query, $link)or die( "Failed MySQL Query: [$link]:$query<br />Error: ".mysql_error($link) );

            print "Changed database prefix from '$oldprefix' to '$newprefix'<br /><b>Please make sure this setting is correct and manually fix if incorrect!</b><br /><br />";
        }
    }

    $query = array();

    $query[] = "ALTER TABLE categories ADD children TEXT default NULL;";
    $query[] = "ALTER TABLE categories ADD lastpost INT(11) UNSIGNED;";
    $query[] = "ALTER TABLE categories ADD lastphoto INT(11) UNSIGNED;";
    $query[] = "ALTER TABLE categories ADD photos INT(11) UNSIGNED default '0';";
    $query[] = "ALTER TABLE categories ADD posts INT(11) UNSIGNED default '0';";
    $query[] = "ALTER TABLE useralbums ADD photos INT(11) UNSIGNED default '0';";
    $query[] = "ALTER TABLE useralbums ADD posts INT(11) UNSIGNED default '0';";
    $query[] = "ALTER TABLE photos CHANGE filesize filesize int(10) default '0';";
    $query[] = "ALTER TABLE photos ADD allowprint varchar(5) NOT NULL default 'no'";
    $query[] = "CREATE TABLE exif (photoid INT(11) DEFAULT '0' NOT NULL, exifinfo TEXT);";
    $query[] = "REPLACE INTO settings VALUES (102,'Display and extract EXIF information from images?','showexif','','no',58,2);";
    $query[] = "REPLACE INTO settings VALUES (103,'Do you want to show the Members Gallery in List format?','memblist','','no',58,2);";
    $query[] = "REPLACE INTO settings VALUES (104,'Do you want to prompt for optional info during registration?','getoptional','','yes',355,5);";
    $query[] = "REPLACE INTO settings VALUES (105,'Do you want to be notified of all new comments?','notifyadmin','','no',94,4);";
    $query[] = "REPLACE INTO settings VALUES (106,'Do you want to enable the calendar printing service?','enablecal','','no',59,1);";
    $query[] = "REPLACE INTO settings VALUES (107,'For calendar printing service, enter your Customer ID','calid','','',60,1);";

    for ( $x=0; $x < count($query); $x++) {
        $iquery = $query[$x];
        print "Performing MySQL command: $iquery ... ";
        $setup = mysql_query($iquery, $link);
        if ( !$setup ) print "<b>Error: ".mysql_error($link)."</b><br />";
        else print "Successful!<br />";
    }

    print "<p>Preparing to update categories with photo and posts information...<br />";
    upgradecategories(0);

    print "<p>Preparing to update personal albums with photo and posts information...<br />";
    upgradealbums(0);

    print "<br /><br />Upgrade complete! You should continue to <a href=\"upgrade.php?upgrade=32x\">next step</a>";
}

if ( $upgrade == "32x" ) {
    require "config-inc.php";

    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade</font>
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\">
            This install script will upgrade a 3.2.X version to PhotoPost to the 3.3.0 release. Only run this upgrade if you have the
            3.2 version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=32x&amp;step=1\">Proceed to Upgrade --></a></div></font></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    print "Preparing to update 3.2.X database...<p>";

    // Connecting, selecting database
    $link = mysql_connect("$host", "$mysql_user", "$mysql_password") or die('I cannot connect to the PhotoPost database. [host:$host][mysql_user:$mysql_user][mysql_password:$mysql_password]');
    mysql_select_db ("$database", $link)or die("Could not connect to PhotoPost database");

    $query = array();

    $query[] = "DELETE FROM settings WHERE id=12;";
    $query[] = "DELETE FROM settings WHERE id=23;";
    $query[] = "DELETE FROM settings WHERE id=24;";
    $query[] = "DELETE FROM settings WHERE id=25;";
    $query[] = "DELETE FROM settings WHERE id=26;";
    $query[] = "DELETE FROM settings WHERE id=27;";
    $query[] = "DELETE FROM settings WHERE id=28;";
    $query[] = "DELETE FROM settings WHERE id=29;";
    $query[] = "DELETE FROM settings WHERE id=30;";
    $query[] = "DELETE FROM settings WHERE id=31;";
    $query[] = "DELETE FROM settings WHERE id=32;";
    $query[] = "DELETE FROM settings WHERE id=34;";
    $query[] = "DELETE FROM settings WHERE id=35;";
    $query[] = "DELETE FROM settings WHERE id=36;";
    $query[] = "DELETE FROM settings WHERE id=52;";
    $query[] = "DELETE FROM settings WHERE id=53;";
    $query[] = "DELETE FROM settings WHERE id=54;";
    $query[] = "DELETE FROM settings WHERE id=56;";
    $query[] = "DELETE FROM settings WHERE id=59;";
    $query[] = "DELETE FROM settings WHERE id=60;";
    $query[] = "DELETE FROM settings WHERE id=85;";
    $query[] = "DELETE FROM admingroups WHERE id=6;";
    $query[] = "ALTER TABLE usergroups ADD modaccess smallint(3) NOT NULL default '0';";
    $query[] = "ALTER TABLE photos ADD extra1 VARCHAR(255), ADD extra2 VARCHAR(255), ADD extra3 VARCHAR(255), ADD extra4 VARCHAR(255), ADD extra5 VARCHAR(255), ADD extra6 VARCHAR(255);";
    $query[] = "REPLACE INTO admingroups VALUES (6,'Field Display and Optional Fields');";
    $query[] = "REPLACE INTO settings VALUES (108,'Optional Photo Field #1 (blank for none)','extra1name','','',1,6);";
    $query[] = "REPLACE INTO settings VALUES (109,'Optional Photo Field #2 (blank for none)','extra2name','','',2,6);";
    $query[] = "REPLACE INTO settings VALUES (110,'Optional Photo Field #3 (blank for none)','extra3name','','',3,6);";
    $query[] = "REPLACE INTO settings VALUES (111,'Optional Photo Field #4 (blank for none)','extra4name','','',4,6);";
    $query[] = "REPLACE INTO settings VALUES (112,'Optional Photo Field #5 (blank for none)','extra5name','','',5,6);";
    $query[] = "REPLACE INTO settings VALUES (113,'Optional Photo Field #6 (blank for none)','extra6name','','',6,6);";
    $query[] = "REPLACE INTO settings VALUES (114,'Display filesize?','dispfs','','yes',7,6);";
    $query[] = "REPLACE INTO settings VALUES (115,'Display views?','dispviews','','yes',8,6);";
    $query[] = "REPLACE INTO settings VALUES (116,'Display date?','dispdate','','yes',9,6);";
    $query[] = "REPLACE INTO settings VALUES (117,'Display dimensions?','dispdims','','yes',10,6);";
    $query[] = "REPLACE INTO settings VALUES (118,'Display keywords?','dispkeys','','yes',11,6);";
    $query[] = "REPLACE INTO settings VALUES (119,'Display description?','dispdesc','','yes',12,6);";
    $query[] = "REPLACE INTO settings VALUES (120,'Display ratings that have no comments attached?','dispempty','','yes',13,6);";
    $query[] = "REPLACE INTO settings VALUES (121,'Display title under photo?','disptitle','','yes',14,6);";
    $query[] = "REPLACE INTO settings VALUES (122,'Display quickratings under photos?','dispquick','','yes',15,6);";
    $query[] = "REPLACE INTO settings VALUES (123,'Do you want to allow people to download their favorites?','allowfavzip','','yes',58,2);";
    $query[] = "REPLACE INTO settings VALUES (124,'Display # of comments indicator under thumbnails?','dispcoms','','yes',16,6);";
    $query[] = "UPDATE settings SET setting = '<font size=\"1\" face=\"verdana\">Powered by: PhotoPost --replaceme--<br />Copyright 2007 All Enthusiast, Inc.</font>' WHERE id=37;";
    $query[] = "ALTER TABLE categories ADD password VARCHAR(24);";
    $query[] = "ALTER TABLE photos ADD disporder INT(5) DEFAULT '0' NOT NULL;";
    $query[] = "REPLACE INTO sort VALUES (2,'Latest','ORDER BY disporder DESC,date DESC');";
    $query[] = "REPLACE INTO sort VALUES (3,'Most Views','ORDER BY disporder DESC,views DESC');";
    $query[] = "REPLACE INTO sort VALUES (1,'Most Active','ORDER BY disporder DESC,lastpost DESC');";
    $query[] = "REPLACE INTO sort VALUES (4,'Most Popular','ORDER BY disporder DESC,rating DESC, views DESC');";
    $query[] = "REPLACE INTO sort VALUES (6, 'Random', 'ORDER BY disporder DESC,RAND()');";
    $query[] = "REPLACE INTO sort VALUES (5, 'Least Popular', 'ORDER BY disporder DESC,rating,views');";
    $query[] = "REPLACE INTO sort VALUES (7, 'Alphabetical', 'ORDER BY disporder DESC,bigimage');";
    $query[] = "ALTER TABLE comments CHANGE rating rating FLOAT(12) DEFAULT NULL;";
    $query[] = "ALTER TABLE photos CHANGE rating rating FLOAT(12) DEFAULT NULL;";
    $query[] = "UPDATE comments SET rating=(rating*2);";

    for ( $x=0; $x < count($query); $x++) {
        $iquery = $query[$x];
        print "Performing MySQL command: $iquery ... ";
        $setup = mysql_query($iquery, $link);
        if ( !$setup ) print "<b>Error: ".mysql_error($link)."</b><br />";
        else print "Successful!<br />";
    }

    print "Recalculating ratings...<br><br>";

    // just to revalidate the rating, we need to recheck the rating for the post
    $query1 = "SELECT id FROM photos";
    $result1 = mysql_query($query1,$link);

    while( list($photo) = mysql_fetch_row($result1) ) {
        // just to revalidate the rating, we need to recheck the rating for the post
        $query2 = "SELECT rating FROM comments WHERE photo=$photo AND rating > 0";
        $result2 = mysql_query($query2,$link);

        $numrating=0; $sumrating=0; $averagerate=0;
        while ( list( $checkrating ) = mysql_fetch_row($result2) ) {
            $numrating++;
            $sumrating = ($sumrating+$checkrating);
        }
        @mysql_free_result( $result2 );

        if ( $numrating != 0 && $sumrating != 0 ) $averagerate = $sumrating / $numrating;

        $query3 = "UPDATE photos SET rating=$averagerate WHERE id=$photo";
        $result3 = mysql_query($query3, $link);
    }

    print "Finished upgrade! You should continue to <a href=\"upgrade.php?upgrade=33\">next step</a>";
}


if ( $upgrade == "33" ) {
    require "config-inc.php";

    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if ( !isset($step) ) {
        $output = "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade</font>
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\">
            This install script will upgrade a 3.3.X version to PhotoPost to the 4.0 release. Only run this upgrade if you have the
            3.3 version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=33&amp;step=1\">Proceed to Upgrade --></a></div></font></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    print "Preparing to update 3.3 database...<p>";

    // Connecting, selecting database
    $link = mysql_connect("$host", "$mysql_user", "$mysql_password") or die('I cannot connect to the PhotoPost database. [host:$host][mysql_user:$mysql_user][mysql_password:$mysql_password]');
    mysql_select_db ("$database", $link)or die("Could not connect to PhotoPost database");

    $query = array();

    $query[] = "CREATE TABLE iponline (userid VARCHAR(128) NOT NULL default '', ipaddr VARCHAR(75) NOT NULL default '', date INT(11) UNSIGNED, what VARCHAR(64) NOT NULL default '',PRIMARY KEY (userid)) TYPE=MyISAM;";
    $query[] = "CREATE TABLE admlog (id int(10) NOT NULL auto_increment,adminuser varchar(50) NOT NULL default '',description varchar(255) NOT NULL default '',datestamp int(20) NOT NULL default '0',ip varchar(35) NOT NULL default '',PRIMARY KEY (id)) TYPE=MyISAM;";
    $query[] = "ALTER TABLE comments ADD approved INT(2) DEFAULT '0' NOT NULL;";
    $query[] = "REPLACE INTO sort VALUES (2,'Latest','ORDER BY disporder,date DESC');";
    $query[] = "REPLACE INTO sort VALUES (3,'Most Views','ORDER BY disporder,views DESC');";
    $query[] = "REPLACE INTO sort VALUES (1,'Most Active','ORDER BY disporder,lastpost DESC');";
    $query[] = "REPLACE INTO sort VALUES (4,'Most Popular','ORDER BY disporder,rating DESC, views DESC');";
    $query[] = "REPLACE INTO sort VALUES (6,'Random', 'ORDER BY disporder,RAND()');";
    $query[] = "REPLACE INTO sort VALUES (5,'Least Popular', 'ORDER BY disporder,rating,views');";
    $query[] = "REPLACE INTO sort VALUES (7,'Image Name', 'ORDER BY disporder,bigimage');";
    $query[] = "REPLACE INTO sort VALUES (8,'Title', 'ORDER BY disporder,title');";
    $query[] = "ALTER TABLE photos CHANGE disporder disporder INT(5) DEFAULT '99999' NOT NULL;";
    $query[] = "UPDATE photos SET disporder='99999' WHERE disporder='0';";
    $query[] = "REPLACE INTO settings VALUES (125,'Display unapproved comments?','moderatecoms','','yes',17,6);";
    $query[] = "ALTER TABLE ecards ADD backcolor VARCHAR(12) DEFAULT '#696969' NOT NULL, ADD bordcolor VARCHAR(12) DEFAULT '#000000' NOT NULL, ADD fontcolor VARCHAR(12) DEFAULT '#FFFFFF' NOT NULL, ADD pickfont VARCHAR(32) DEFAULT 'arial' NOT NULL, ADD layout VARCHAR(24) DEFAULT 'tobottom' NOT NULL;";
    $query[] = "REPLACE INTO settings VALUES (84,'PhotoPost Version','pversion','','4.0',53,0);";
    $query[] = "REPLACE INTO settings VALUES (48,'Require users to be registered to send an e-Card?','cardreg','','yes',99,5);";
    $query[] = "REPLACE INTO settings VALUES (126,'How many file upload prompts do you want?','maxfiles','','1',89,3);";

    for ( $x=0; $x < count($query); $x++) {
        $iquery = $query[$x];
        print "Performing MySQL command: $iquery ... ";
        $setup = mysql_query($iquery, $link);
        if ( !$setup ) print "<b>Error: ".mysql_error($link)."</b><br />";
        else print "Successful!<br />";
    }

    print "Finished upgrade!You should continue to <a href=\"upgrade.php?upgrade=40\">next step</a>";
}



if ( $upgrade == "40" ) {
    require "config-inc.php";

    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if ( !isset($step) ) {
        $output = "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade</font>
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\">
            This install script will upgrade a 4.0 version to PhotoPost to the 4.1 release. Only run this upgrade if you have the
            4.0 version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=40&amp;step=1\">Proceed to Upgrade --></a></div></font></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    // Connecting, selecting database
    $link = mysql_connect("$host", "$mysql_user", "$mysql_password") or die('I cannot connect to the PhotoPost database. [host:$host][mysql_user:$mysql_user][mysql_password:$mysql_password]');
    mysql_select_db ("$database", $link)or die("Could not connect to PhotoPost database");

    if ( $step == "1" ) {
        print "Preparing to update 4.0 database...<p>";

        $query = array();
        $query[] = "DELETE FROM {$pp_db_prefix}settings WHERE id=16;";
        $query[] = "DELETE FROM {$pp_db_prefix}settings WHERE id=17;";
        $query[] = "DELETE FROM {$pp_db_prefix}settings WHERE id=55;";
        $query[] = "UPDATE {$pp_db_prefix}settings SET title='PATH to UPLOADS directory?' WHERE id=81;";
        $query[] = "UPDATE {$pp_db_prefix}settings SET title='URL to UPLOADS directory?' WHERE id=82;";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (84,'PhotoPost Version','pversion','','4.1',53,0);";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (128,'Pixel size of borders for images/thumbnails','cellpadding','Thickness - set to 0 for no border','2',60,2);";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (129,'Color for image borders','framecolor','Color of the frame around images/thumbs','#000000',61,2);";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (88,'Quality setting for image resizing/thumbnails?','imgquality','','70',89,3);";
        $query[] = "ALTER TABLE {$pp_db_prefix}iponline DROP PRIMARY KEY, ADD PRIMARY KEY (`ipaddr`);";
        $query[] = "UPDATE {$pp_db_prefix}settings SET title='Do you want Members Gallery to show all of a users photos?' WHERE id=94;";

        for ( $x=0; $x < count($query); $x++) {
            $iquery = $query[$x];
            print "Performing MySQL command: $iquery ... ";
            $setup = mysql_query($iquery, $link);
            if ( !$setup ) print "<b>Error: ".mysql_error($link)."</b><br />";
            else print "Successful!<br />";
        }

        print "<br /><br /><a href=\"upgrade.php?upgrade=40&amp;step=2\">Continue to next step --></a>";
        exit;
    }

    if ( $step == "2" ) {
        $query = "SELECT varname,setting FROM {$pp_db_prefix}settings";
        $getsets = mysql_query($query,$link);

        if ( !$getsets ) {
            print "Database not properly setup. Contact administrator.";
            exit;
        }

        while ( list($var, $set) = mysql_fetch_row($getsets)) {
            $Globals[$var] = stripslashes($set);
        }
        mysql_free_result($getsets);

        if ($Globals['vbversion'] == "2.0.3" || $Globals['vbversion'] == "2.2.0" || $Globals['vbversion'] == "vb2" ) {
            $uquery = "UPDATE {$pp_db_prefix}settings SET setting='vb2' WHERE id=41";
        }
        elseif ($Globals['vbversion'] == "3.0" || $Globals['vbversion'] == "vb3") {
            $uquery = "UPDATE {$pp_db_prefix}settings SET setting='vb3' WHERE id=41";
        }
        elseif ($Globals['vbversion'] == "w3t6" || $Globals['vbversion'] == "threads") {
            $uquery = "UPDATE {$pp_db_prefix}settings SET setting='threads' WHERE id=41";
        }
        elseif ($Globals['vbversion'] == "phpBB2" || $Globals['vbversion'] == "phpbb2") {
            $uquery = "UPDATE {$pp_db_prefix}settings SET setting='phpbb2' WHERE id=41";
        }
        elseif ($Globals['vbversion'] == "nuke" || $Globals['vbversion'] == "nuke") {
            $uquery = "UPDATE {$pp_db_prefix}settings SET setting='nuke' WHERE id=41";
       }
        elseif ($Globals['vbversion'] == "postnuke" || $Globals['vbversion'] == "postnuke") {
            $uquery = "UPDATE {$pp_db_prefix}settings SET setting='postnuke' WHERE id=41";
        }
        elseif ($Globals['vbversion'] == "dcfplus" || $Globals['vbversion'] == "dcf") {
            $uquery = "UPDATE {$pp_db_prefix}settings SET setting='dcf' WHERE id=41";
        }
        elseif ($Globals['vbversion'] == "ib") {
            $uquery = "UPDATE {$pp_db_prefix}settings SET setting='ib' WHERE id=41";
        }
        else {
            $uquery = "UPDATE {$pp_db_prefix}settings SET setting='photopost' WHERE id=41";
        }
        $queryq = mysql_query($uquery,$link);

        $output = "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"90%\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"center\" bgcolor=\"#0059B5\">
            <font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Check your UPLOADS path</font>
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\" align=\"center\">
            <font size=\"2\" face=\"MS Sans Serif\">
            PhotoPost 4.1 switches to a queue method for uploading user files, to do this you need to set the path
            to your UPLOADS directory. Permissions also needs to be set to writeable by the server for this directory.<br /><br />
            <b>These settings are important and will cause uploads to not work if improperly set!</b><br /><br />
            <div align=\"center\">";

        $output .= "<form method=\"post\" action=\"upgrade.php\">
            <table cellpadding=\"2\" cellspacing=\"1\" border=\"1\" width=\"90%\">
            <tr><td class=\"menubar\" align=\"center\" colsize=\"4\">
            <font class=\"medium\">PATH VARIABLES</font></td></tr>";

        $output .= "<tr>
            <td bgcolor=\"#FFFFFF\" align=\"left\" width=\"60%\">Your UPLOADS directory server path, for example: <b>/home/path/photopost/uploads</b></td>
            <td bgcolor=\"#FFFFFF\" align=\"left\" width=\"40%\"><input type=\"text\" size=\"60\" value=\"{$Globals['zipuploaddir']}\" name=\"newpath\" class=\"bginput\"></td>
            </tr>
            <tr>
            <td bgcolor=\"#FFFFFF\" align=\"left\" width=\"60%\">Your UPLOADS directory URL path, for example: <b>http://www.yoursite.com/photopost/uploads</b></td>
            <td bgcolor=\"#FFFFFF\" align=\"left\" width=\"40%\"><input type=\"text\" size=\"60\" value=\"{$Globals['zipuploadurl']}\" name=\"newurl\" class=\"bginput\"></td>
            </tr>
            </table><br />
            <input type=\"hidden\" name=\"submit\" value=\"yes\">
            <input type=\"hidden\" name=\"step\" value=\"3\">
            <input type=\"hidden\" name=\"upgrade\" value=\"40\">
            <input type=\"submit\" value=\"Save Changes\"></form>
            </div></font></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    if ( $step == "3" ) {
        if ( !is_writable($newpath) || !is_dir($newpath) ) {
            @mkdir( $newpath );
            @chmod( $newpath, 0777 );
            if ( !is_writable($newpath) ) {
                $reason .= "<li>Unable to create/write to \"$newpath\"! Check your UPLOADS directory permissions.";
            }
        }

        if ( is_dir($newpath) ) {
            $query = "UPDATE {$pp_db_prefix}settings SET setting='$newpath' WHERE id=81";
            $queryq = mysql_query($query,$link);
        }
        else {
            echo "Please go back and confirm your UPLOADS directory path; we cannot find the directory \"$newpath\".";
            exit;
        }

        $query = "UPDATE {$pp_db_prefix}settings SET setting='$newurl' WHERE id=82";
        $queryq = mysql_query($query,$link);
    }

    print "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\">
            <font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">PhotoPost Upgrade</font>
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\" align=\"center\:>
            <font size=\"2\" face=\"MS Sans Serif\">
            Congratulations! You have finished your upgrade! You should continue to <a href=\"upgrade.php?upgrade=41\">next step</a></font></td></tr></table></td></tr></table>";
}

if ( $upgrade == "41" ) {
    require "config-inc.php";

    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade</font>
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\">
            This install script will upgrade your 4.1.X release.  Only run this upgrade if you have the
            4.1.X version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=41&amp;step=1\">Proceed to Upgrade --></a></div></font></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    print "Preparing to update 4.1 database...<p>";

    // Connecting, selecting database
    $link = mysql_connect("$host", "$mysql_user", "$mysql_password") or die('I cannot connect to the PhotoPost database. [host:$host][mysql_user:$mysql_user][mysql_password:$mysql_password]');
    mysql_select_db ("$database", $link)or die("Could not connect to PhotoPost database");

    if ( $step == "1" ) {
        //
        // check to see if this is the photo database update
        //

        $query = "SELECT varname,setting FROM {$pp_db_prefix}settings";
        $getsets = mysql_query($query,$link);

        if ( !$getsets ) {
            print "Database not properly setup. Contact administrator.";
            exit;
        }

        while ( list($var, $set) = mysql_fetch_row($getsets)) {
            $Globals[$var] = stripslashes($set);
        }
        mysql_free_result($getsets);

        $query = array();
        $query[] = "ALTER TABLE {$pp_db_prefix}categories ADD cattype VARCHAR(4) DEFAULT 'c' NOT NULL;";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (130,'Select a theme for your website','theme','Choose from the available themes for your site layout','default',62,2);";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (131,'Show UBBCode on Photo page?','showubb','','no',16,6);";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (84,'PhotoPost Version','pversion','','4.5',53,0);";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (133,'Use Spider-friendly URLs?','spider','','no',17,6);";

        for ( $x=0; $x < count($query); $x++) {
            $iquery = $query[$x];
            print "Performing MySQL command: $iquery ... ";
            $setup = mysql_query($iquery, $link);
            if ( !$setup ) print "<b>Error: ".mysql_error($link)."</b><br />";
            else print "Successful!<br />";
        }

        print "<br><a href=\"upgrade.php?upgrade=41&amp;step=2\">Upgrade useralbums (only perform this step ONCE!) --></a> or continue to <a href=\"upgrade.php?upgrade=45\">next upgrade</a>.";
        exit;
    }

    if ( $step == "2" ) {
        $result = mysql_query("UPDATE {$pp_db_prefix}categories SET cattype='c'", $link);

        $query = "SELECT id,albumname,description,parent,isprivate,password,photos,posts FROM {$pp_db_prefix}useralbums ORDER BY id";
        $boards = mysql_query($query, $link);

        if ( $boards ) {
            while ( list( $id, $albumname, $albdesc, $albparent, $isprivate, $password, $photos, $posts ) = mysql_fetch_row($boards) ) {
                print "Processing $albumname ... <br>";

                $albumname = addslashes($albumname);
                $albdesc = addslashes($albdesc);

                $query2 = "INSERT INTO {$pp_db_prefix}categories (id,catname,description,parent,private,password,photos,posts,cattype) VALUES( $id, '$albumname', '$albdesc', $albparent, '$isprivate', '$password', $photos, $posts, 'a' )";
                $result = mysql_query($query2, $link);
            }

            print "dropping useralbums table and setting cattype...<br>";
            $result = mysql_query("DROP TABLE {$pp_db_prefix}useralbums", $link);
        }
    }

    print "Upgrade complete! You should continue to <a href=\"upgrade.php?upgrade=45\">next step</a>";
}

if ( $upgrade == "45" ) {
    require "config-inc.php";

    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade</font>
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\">
            This install script will upgrade your 4.5 release.  Only run this upgrade if you have the
            4.5 version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=45&amp;step=1\">Proceed to Upgrade --></a></div></font></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    if ( $step == "1" ) {
        print "Preparing to update 4.5 database...<p>";

        // Connecting, selecting database
        $link = mysql_connect("$host", "$mysql_user", "$mysql_password") or die('I cannot connect to the PhotoPost database. [host:$host][mysql_user:$mysql_user][mysql_password:$mysql_password]');
        mysql_select_db ("$database", $link)or die("Could not connect to PhotoPost database");

        $query = array();

        $query[] = "ALTER TABLE {$pp_db_prefix}categories ADD theme VARCHAR(32) NOT NULL;";
        $query[] = "ALTER TABLE {$pp_db_prefix}categories ADD catdepth varchar(6) DEFAULT NULL;";
        $query[] = "ALTER TABLE {$pp_db_prefix}categories ADD watermark varchar(255) NOT NULL default '';";
        $query[] = "ALTER TABLE {$pp_db_prefix}iponline ADD item VARCHAR(16) NOT NULL default '';";
        $query[] = "ALTER TABLE {$pp_db_prefix}usergroups ADD useralbums int(3) NOT NULL default '0';";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (134, 'Use Anti-leeching code?', 'right-click', 'Use Right-Click Disable Script', 'no', 18, 6);";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (135, 'Display number of viewers on categories?', 'displayonline', 'Adds a query to main index, but shows numbers of viewers per category', 'yes', 60, 2);";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (37,'cright','cright','','<font size=\"1\" face=\"verdana\">Powered by: PhotoPost<br />Copyright 2007 All Enthusiast, Inc.</font>',300,'0');";
        $query[] = "DROP TABLE {$pp_db_prefix}stylesheet;";

        for ( $x=0; $x < count($query); $x++) {
            $iquery = $query[$x];
            print "Performing MySQL command: $iquery ... ";
            $setup = mysql_query($iquery, $link);
            if ( !$setup ) print "<b>Error: ".mysql_error($link)."</b><br />";
            else print "Successful!<br />";
        }
    }

    print "Upgrade complete! You should continue to <a href=\"upgrade.php?upgrade=46\">next step</a>";
}


if ( $upgrade == "46" ) {
    require "config-inc.php";

    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"$mainfonts\">Welcome to PhotoPost Upgrade</font>
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"$mainfonts\">
            This install script will upgrade your 4.6 release.  Only run this upgrade if you have the
            4.6 version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=46&amp;step=1\">Proceed to Upgrade --></a></div></font></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    if ( $step == "1" ) {
        print "Preparing to update 4.6 database...<p>";

        // Connecting, selecting database
        $link = mysql_connect("$host", "$mysql_user", "$mysql_password") or die('I cannot connect to the PhotoPost database. [host:$host][mysql_user:$mysql_user][mysql_password:$mysql_password]');
        mysql_select_db ("$database", $link)or die("Could not connect to PhotoPost database");

        $query = "ALTER TABLE {$pp_db_prefix}photos ADD storecat INT(12) DEFAULT '0' NOT NULL AFTER `cat`";
        print "Performing MySQL command: $query ... ";
        $setup = mysql_query($query, $link);
        if ( !$setup ) print "<b>Error: ".mysql_error($link)."</b><br />";
        else print "Successful!<br />";

        $query = "ALTER TABLE {$pp_db_prefix}photos ADD storeid INT(12) DEFAULT '0' NOT NULL AFTER `storecat`";
        print "Performing MySQL command: $query ... ";
        $setup = mysql_query($query, $link);
        if ( !$setup ) print "<b>Error: ".mysql_error($link)."</b><br />";
        else print "Successful!<br />";

        $query = "REPLACE INTO {$pp_db_prefix}settings VALUES (136, 'Allow users to choose additional categories during upload?', 'optcats', '', 'no', 19, 6)";
        print "Performing MySQL command: $query ... ";
        $setup = mysql_query($query, $link);
        if ( !$setup ) print "<b>Error: ".mysql_error($link)."</b><br />";
        else print "Successful!<br />";
    }

    print "<br />Upgrade complete! You should continue to <a href=\"upgrade.php?upgrade=467\">next step</a>";
}


if ( $upgrade == "467" ) {
    require "config-inc.php";

    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade</font>
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">
            This install script will upgrade your 4.6.7 release.  Only run this upgrade if you have the
            4.6.7 version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=467&amp;step=1\">Proceed to Upgrade --></a></div></font></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    if ( $step == "1" ) {
        print "Preparing to update 4.6.7 database...<p>";

        // Connecting, selecting database
        $link = mysql_connect("$host", "$mysql_user", "$mysql_password") or die('I cannot connect to the PhotoPost database. [host:$host][mysql_user:$mysql_user][mysql_password:$mysql_password]');
        mysql_select_db ("$database", $link)or die("Could not connect to PhotoPost database");

        $query = array();

        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (137, 'Enable slideshows?', 'slideshow', '', 'yes', 19, 6)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (138, 'Enable next and previous photo previews?', 'nextbox', '', 'yes', 20, 6)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (139, 'How many days after an eCard has been read do you want to keep it?', 'cardage', '', '7', 99, 5)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (140, 'Expire eCards after how many days (even if not read)?', 'cardexpire', '', '90', 100, 5)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (141, 'Acceptable multimedia file types?', 'acceptmm', 'Seperate file types by a comma and include the . (example: .mpg,.wma,.asf,.mp3)', '.mpeg,.mpg,.avi,.asf,.wmv,.mov', 89, 3)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (142, 'Acceptable image file types?', 'acceptimg', 'Seperate file types by a comma and include the . (example: .jpg,.gif,.png)', '.jpg,.jpeg,.png,.gif', 89, 3)";
        $query[] = "ALTER TABLE {$pp_db_prefix}usergroups ADD reqmod INT(3) DEFAULT '0' NOT NULL";
        $query[] = "ALTER TABLE {$pp_db_prefix}ecards ADD returnr INT(15) DEFAULT '0' NOT NULL";
        $query[] = "ALTER TABLE {$pp_db_prefix}notify ADD type INT(2) DEFAULT '0' NOT NULL";
        $query[] = "ALTER TABLE {$pp_db_prefix}ecards ADD readdate INT(15) DEFAULT '0' NOT NULL";
        $query[] = "DELETE FROM {$pp_db_prefix}settings WHERE id = 22";
        $query[] = "DELETE FROM {$pp_db_prefix}settings WHERE id = 57";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (143,'Select a border for your thumbnails','thumbborder','Choose from the available borders for your thumbnails','thumbnail',62,2);";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (84,'PhotoPost Version','pversion','','4.7',53,0)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (37,'cright','cright','','<font size=\"1\" face=\"verdana\">Powered by: PhotoPost<br />Copyright 2007 All Enthusiast, Inc.</font>',300,'0')";

        for ( $x=0; $x < count($query); $x++) {
            $iquery = $query[$x];
            print "Performing MySQL command: $iquery ... ";
            $setup = mysql_query($iquery, $link);
            if ( !$setup ) print "<b>Error: ".mysql_error($link)."</b><br />";
            else print "Successful!<br />";
        }
    }

    print "<br />Upgrade complete! You should continue to <a href=\"upgrade.php?upgrade=47\">next step</a>";
}


if ( $upgrade == "47" ) {
    require "config-inc.php";

    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade</font>
            </font></td></tr>
            <tr><td bgcolor=\"#ffffff\"><font size=\"2\" face=\"MS Sans Serif\">
            This install script will upgrade your 4.7 release.  Only run this upgrade if you have the
            4.7 version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=47&amp;step=1\">Proceed to Upgrade --></a></div></font></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    // Connecting, selecting database
    $link = mysql_connect("$host", "$mysql_user", "$mysql_password") or die('I cannot connect to the PhotoPost database. [host:$host][mysql_user:$mysql_user][mysql_password:$mysql_password]');
    mysql_select_db ("$database", $link)or die("Could not connect to PhotoPost database");

    if ( $step == "1" ) {
        print "Preparing to reorganize admin options...<p>";

        $query = array();
        $query[] = "UPDATE {$pp_db_prefix}admingroups SET name='Global Options' WHERE id=1";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=1,section=1 WHERE id=1";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=2,section=1 WHERE id=2";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=3,section=1 WHERE id=3";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=4,section=1 WHERE id=4";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=5,section=1 WHERE id=5";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=6,section=1 WHERE id=6";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=7,section=1 WHERE id=7";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=8,section=1 WHERE id=8";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=9,section=1 WHERE id=9";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=10,section=1 WHERE id=10";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=11,section=1 WHERE id=11";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=12,section=1 WHERE id=41";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=13,section=1 WHERE id=49";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=14,section=1 WHERE id=83";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=15,section=1 WHERE id=133";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=16,section=1 WHERE id=81";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=17,section=1 WHERE id=82";
        $query[] = "UPDATE {$pp_db_prefix}admingroups SET name='Admin Options' WHERE id=2";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=1,section=2 WHERE id=38";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=2,section=2 WHERE id=51";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=3,section=2 WHERE id=67";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=4,section=2 WHERE id=68";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=5,section=2 WHERE id=80";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=6,section=2 WHERE id=70";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=7,section=2 WHERE id=98";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=8,section=2 WHERE id=99";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=9,section=2 WHERE id=105";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=10,section=2 WHERE id=71";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=11,section=2 WHERE id=123";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=12,section=2 WHERE id=91";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=13,section=2 WHERE id=140";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=14,section=2 WHERE id=139";
        $query[] = "UPDATE {$pp_db_prefix}admingroups SET name='Index Options' WHERE id=3";
        $query[] = "DELETE FROM {$pp_db_prefix}settings WHERE id=33";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=1,section=3 WHERE id=50";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=2,section=3 WHERE id=58";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=3,section=3 WHERE id=78";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=4,section=3 WHERE id=79";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=5,section=3 WHERE id=92";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=6,section=3 WHERE id=101";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=7,section=3 WHERE id=135";
        $query[] = "UPDATE {$pp_db_prefix}admingroups SET name='Show Gallery Options' WHERE id=4";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=1,section=4 WHERE id=15";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=2,section=4 WHERE id=124";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=3,section=4 WHERE id=103";
        $query[] = "UPDATE {$pp_db_prefix}admingroups SET name='Show Photo Options' WHERE id=5";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=1,section=5 WHERE id=13";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=2,section=5 WHERE id=47";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=3,section=5 WHERE id=48";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=4,section=5 WHERE id=72";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=11,section=5 WHERE id=114";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=12,section=5 WHERE id=115";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=13,section=5 WHERE id=116";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=14,section=5 WHERE id=117";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=15,section=5 WHERE id=118";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=16,section=5 WHERE id=119";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=17,section=5 WHERE id=120";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=18,section=5 WHERE id=121";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=19,section=5 WHERE id=122";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=20,section=5 WHERE id=100";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=21,section=5 WHERE id=125";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=22,section=5 WHERE id=137";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=23,section=5 WHERE id=134";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=24,section=5 WHERE id=95";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=25,section=5 WHERE id=131";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=26,section=5 WHERE id=138";
        $query[] = "UPDATE {$pp_db_prefix}admingroups SET name='Upload Photo Options' WHERE id=6";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=1,section=6 WHERE id=18";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=2,section=6 WHERE id=19";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=3,section=6 WHERE id=20";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=4,section=6 WHERE id=21";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=5,section=6 WHERE id=43";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=6,section=6 WHERE id=44";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=7,section=6 WHERE id=88";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=8,section=6 WHERE id=89";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=9,section=6 WHERE id=102";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=10,section=6 WHERE id=97";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=11,section=6 WHERE id=141";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=12,section=6 WHERE id=142";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=13,section=6 WHERE id=126";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=14,section=6 WHERE id=136";
        $query[] = "INSERT INTO {$pp_db_prefix}admingroups VALUES (7,'Comments Options')";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=1,section=7 WHERE id=42";
        $query[] = "INSERT INTO {$pp_db_prefix}admingroups VALUES (8,'Registration Options')";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=1,section=8 WHERE id=76";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=2,section=8 WHERE id=104";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=3,section=8 WHERE id=61";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=4,section=8 WHERE id=62";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=5,section=8 WHERE id=63";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=6,section=8 WHERE id=64";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=7,section=8 WHERE id=65";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=8,section=8 WHERE id=66";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=9,section=8 WHERE id=93";
        $query[] = "INSERT INTO {$pp_db_prefix}admingroups VALUES (9,'Layout Options')";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=1,section=9 WHERE id=45";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=2,section=9 WHERE id=46";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=3,section=9 WHERE id=69";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=4,section=9 WHERE id=14";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=5,section=9 WHERE id=75";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=6,section=9 WHERE id=130";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=7,section=9 WHERE id=129";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=8,section=9 WHERE id=128";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=9,section=9 WHERE id=143";
        $query[] = "INSERT INTO {$pp_db_prefix}admingroups VALUES (10,'Watermark Options')";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=1,section=10 WHERE id=86";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=2,section=10 WHERE id=87";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=3,section=10 WHERE id=90";
        $query[] = "ALTER TABLE {$pp_db_prefix}comments ADD ipaddress VARCHAR(32)";
        $query[] = "ALTER TABLE {$pp_db_prefix}photos ADD ipaddress VARCHAR(32)";
        $query[] = "INSERT INTO {$pp_db_prefix}admingroups VALUES (11, 'Sidebar Settings')";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (144, 'Sidebar Placement?', 'sidebar', 'Set this to off for no sidebar or left or right depending on your tastes.', 'off', 1, 11)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (145, 'Sidebar Width', 'sidebar_width', ' Choose the width for your sidebar', '20%', 4, 11)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (146, 'Under Category PAL?', 'undercat', ' Display Recent Comments and Who\'s Online Pals', 'no', 5, 11)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (147, 'Statistics PAL?', 'statspal', ' Display Statistics Pal?', 'yes', 6, 11)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (148, 'Top Posters PAL?', 'topposterspal', ' Display Top Posters Pal?', 'no', 7, 11)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (149, 'Random Image PAL?', 'randompal', ' Display Random Image?', 'yes', 8, 11)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (150, 'Highest Ratings PAL?', 'ratingspal', ' Display Highest Ratings?', 'no', 9, 11)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (151, 'Show Sidebar on Index Page?', 'sidebar_index', '', 'no', 2, 11)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (152, 'Show Sidebar Globally?', 'sidebar_global', 'Showsidebar on showphoto,showmembers and showgallery pages?', 'no', 3, 11);";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (153, 'Default theme setting (UBBThreads users only)', 'threads', 'Threads Users: We need to know what the site default theme setting is.', 'infopop', 18, 1)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (154, 'Show signatures?', 'showsigs', 'When available, display signatures?', 'yes', 27, 5)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (155, 'Show Avatars?', 'showavatar', 'When available, show avatars?', 'yes', 28, 5)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (156, 'Show Category Avatars?', 'indexavatars', 'Do you want to display the Index Avatars?', 'yes', 9, 3)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (157, 'Display Custom PAL #1', 'custom1pal', ' If you modified the custom1pal.tmpl and want to include it set to yes', 'no', 11, 11)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (158, 'Display Custom PAL #2', 'custom2pal', ' If you modified the custom2pal.tmpl and want to include it set to yes', 'no', 12, 11)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (159, 'Display Custom PAL #3', 'custom3pal', ' If you modified the custom3pal.tmpl and want to include it set to yes', 'no', 13, 11)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (160, 'Number of Top Posters to display', 'numtoppal', '', '5', 14, 11)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (161, 'Number of Last Comments to display', 'numcompal', '', '5', 15, 11)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (162, 'Number of Most Popular Photos to display', 'mostpoppal', '', '5', 16, 11)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (163, 'Use Integrated forum stylesheets?', 'forumstyle', 'If you use a forum like vB3 or Threads and want to use the intergated stylesheet option, choose Yes', 'no', 19, 1)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (164, 'Use Whos Online PAL?', 'onlinepal', '', 'yes', 10, 11)";
        $query[] = "UPDATE {$pp_db_prefix}settings SET setting='4.8' WHERE id=84";
        $query[] = "ALTER TABLE {$pp_db_prefix}favorites CHANGE id id INT(12) NOT NULL AUTO_INCREMENT";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (37,'cright','cright','','<font size=\"1\" face=\"verdana\">Powered by: PhotoPost<br />Copyright &copy; 2007 All Enthusiast, Inc.</font>',300,'0')";
        // New stuff
        $query[] = "ALTER TABLE {$pp_db_prefix}usergroups ADD canassign INT(3) DEFAULT '0' NOT NULL";
        $query[] = "ALTER TABLE {$pp_db_prefix}categories ADD sortorder INT(2) DEFAULT '1' NOT NULL, ADD extra1 VARCHAR(250), ADD extra2 VARCHAR(250), ADD extra3 VARCHAR(250), ADD extra4 VARCHAR(250), ADD extra5 VARCHAR(250), ADD extra6 VARCHAR(250), ADD thumbnail INT(15) DEFAULT '0' NOT NULL";
        $query[] = "ALTER TABLE {$pp_db_prefix}categories DROP INDEX lastphoto";
        $query[] = "ALTER TABLE {$pp_db_prefix}categories DROP INDEX thumbnail";
        $query[] = "ALTER TABLE {$pp_db_prefix}iponline DROP INDEX userid";
        $query[] = "ALTER TABLE {$pp_db_prefix}photos DROP INDEX approved";
        $query[] = "ALTER TABLE {$pp_db_prefix}photos DROP INDEX date";
        $query[] = "ALTER TABLE {$pp_db_prefix}categories ADD INDEX ( `lastphoto` )";
        $query[] = "ALTER TABLE {$pp_db_prefix}categories ADD INDEX ( `thumbnail` )";
        $query[] = "ALTER TABLE {$pp_db_prefix}iponline ADD INDEX ( `userid` )";
        $query[] = "ALTER TABLE {$pp_db_prefix}photos ADD INDEX `approved` ( `approved` , `storecat` )";
        $query[] = "ALTER TABLE {$pp_db_prefix}photos ADD INDEX ( `date` )";

        for ( $x=0; $x < count($query); $x++) {
            $iquery = $query[$x];
            $setup = mysql_query($iquery, $link);
            if ( !$setup ) print "<b>$iquery failed with error: ".mysql_error($link)."</b><br />";
        }

        $fixq = "SELECT setting FROM {$pp_db_prefix}settings WHERE id IN (108,109,110,111,112,113) ORDER BY id";
        $fixextra = mysql_query($fixq, $link);

        if ( $fixextra ) {
            list( $ex1 ) = mysql_fetch_row($fixextra);
            list( $ex2 ) = mysql_fetch_row($fixextra);
            list( $ex3 ) = mysql_fetch_row($fixextra);
            list( $ex4 ) = mysql_fetch_row($fixextra);
            list( $ex5 ) = mysql_fetch_row($fixextra);
            list( $ex6 ) = mysql_fetch_row($fixextra);
            @mysql_free_result($fixextra);

            $ex1 = addslashes($ex1); $ex2 = addslashes($ex2);
            $ex3 = addslashes($ex3); $ex4 = addslashes($ex4);
            $ex5 = addslashes($ex5); $ex6 = addslashes($ex6);

            $query2 = array();
            $query2[] = "UPDATE {$pp_db_prefix}categories SET extra1='$ex1'";
            $query2[] = "UPDATE {$pp_db_prefix}categories SET extra2='$ex2'";
            $query2[] = "UPDATE {$pp_db_prefix}categories SET extra3='$ex3'";
            $query2[] = "UPDATE {$pp_db_prefix}categories SET extra4='$ex4'";
            $query2[] = "UPDATE {$pp_db_prefix}categories SET extra5='$ex5'";
            $query2[] = "UPDATE {$pp_db_prefix}categories SET extra6='$ex6'";
            $query2[] = "DELETE FROM {$pp_db_prefix}settings WHERE id=108";
            $query2[] = "DELETE FROM {$pp_db_prefix}settings WHERE id=109";
            $query2[] = "DELETE FROM {$pp_db_prefix}settings WHERE id=110";
            $query2[] = "DELETE FROM {$pp_db_prefix}settings WHERE id=111";
            $query2[] = "DELETE FROM {$pp_db_prefix}settings WHERE id=112";
            $query2[] = "DELETE FROM {$pp_db_prefix}settings WHERE id=113";
        }

        for ( $x=0; $x < count($query2); $x++) {
            $iquery = $query2[$x];
            $setup = mysql_query($iquery, $link);
            if ( !$setup ) print "<b>$iquery failed with error: ".mysql_error($link)."</b><br />";
        }

        $verq = mysql_query( "SELECT setting FROM {$pp_db_prefix}settings WHERE id=41", $link);
        list( $whichver ) = mysql_fetch_row($verq);

        if ( $whichver != "threads" ) {
            print "<br /><br />Done! ";
            print "You should continue to <a href=\"upgrade.php?upgrade=482\">next step</a>";
            exit;
        }

        print "<br /><br />--> <a href=\"upgrade.php?upgrade=47&amp;step=2\">click here to continue</a> as there is just one more thing we need from you";
        exit;
    }

    if ( $step == "2" ) {
        $output = "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"90%\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"center\" bgcolor=\"#0059B5\">
            <font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Check your THREADS theme</font>
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\" align=\"center\">
            <font size=\"2\" face=\"MS Sans Serif\">
            Threads Users: PhotoPost 4.8 requires us to know what your default theme is.<br /><br />
            <div align=\"center\">";

        $output .= "<form method=\"post\" action=\"upgrade.php\">
            <table cellpadding=\"2\" cellspacing=\"1\" border=\"1\" width=\"90%\">
            <tr><td bgcolor=\"#C6DFF7\" align=\"center\" colsize=\"4\">
            <font class=\"medium\">THEME SETTING</font></td></tr>";

        $output .= "<tr>
            <td bgcolor=\"#FFFFFF\" align=\"left\" width=\"60%\"><font size=\"2\" face=\"MS Sans Serif\">Please enter your default theme. By default this is 'infopop'.</font></td>
            <td bgcolor=\"#FFFFFF\" align=\"left\" width=\"40%\"><input type=\"text\" size=\"60\" value=\"infopop\" name=\"newtheme\" class=\"bginput\"></td>
            </tr>
            </table><br />
            <input type=\"hidden\" name=\"submit\" value=\"yes\">
            <input type=\"hidden\" name=\"step\" value=\"3\">
            <input type=\"hidden\" name=\"upgrade\" value=\"47\">
            <input type=\"submit\" value=\"Save Changes\"></form>
            </div></font></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    if ( $step == "3" ) {
        $newtheme = addslashes($newtheme);
        $verq = mysql_query( "UPDATE {$pp_db_prefix}settings SET setting='$newtheme' WHERE id=153", $link);

        print "Upgrade complete!  You should continue to <a href=\"upgrade.php?upgrade=482\">next step</a>";
    }
}

if ( $upgrade == "482" ) {
    require "config-inc.php";

    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade</font>
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">
            This install script will upgrade your 4.8.2 release.  Only run this upgrade if you have the
            4.8.2 version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=482&amp;step=1\">Proceed to Upgrade --></a></div></font></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    if ( $step == "1" ) {
        print "Preparing to update 4.8.2 database...<p>";

        // Connecting, selecting database
        $link = mysql_connect("$host", "$mysql_user", "$mysql_password") or die('I cannot connect to the PhotoPost database. [host:$host][mysql_user:$mysql_user][mysql_password:$mysql_password]');
        mysql_select_db ("$database", $link)or die("Could not connect to PhotoPost database");

        $query = array();
        $compression = ( $compression == 0 ? "no" : "yes" );
        $onthefly    = ( $onthefly == 0 ? "no" : "yes" );
        $botbuster   = ( $botbuster == 0 ? "no" : "yes" );

        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (166,'BotBuster Integration', 'botbuster', 'Set to yes if you have BotBuster on your system (this includes the necessary tag)', '$botbuster', 22, 1)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (167,'Enable ZLIB page compression', 'compression', 'Set to on if you want to enable Zlib page compression (and it is supported)', '$compression', 23, 1)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (168,'Date format', 'ppdateformat', 'Keywords: dow, month, mm, dd, yyyy', '$ppdateformat', 24, 1)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (169,'GMT Offset', 'gmtoffset', 'If you are running VB and want the server to display the time as an offset of GMT (for example, to the timezone where your server is located), enter the offset here.', '$gmtoffset', 25, 1)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (170,'Enable IP Cache Timeout', 'ipcache', 'This variable is used to track IP addresses and userids for voting and viewing purposes. This is set in HOURS. 0 disables this setting', '$ipcache', 26, 1)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (171,'PhotoPost Cookie Path', 'cookie_path', 'This should be set to match the path/domain for your cookies. Setting to / enables entire site.', '$cookie_path', 1, 12)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (172,'Forum Cookie Prefix', 'cookieprefix', 'Some Default values vB3: bb, phpBB2: phpbb2mysql, Threads: w3t_', '$cookieprefix', 2, 12)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (173,'PhotoPost Cookie Domain', 'domain_path', '.yourdomain.com; sets the cookie to be usable across the domain', '$cookie_domain', 3, 12)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (174,'Debug Setting', 'debug', 'How do you want PhotoPost to handle errors?', '$debug', 27, 1)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (175,'Enable On-The-Fly Watermarks', 'onthefly', 'Requires GD2 and you must edit the file watermark.php', '$onthefly', 29, 5)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (176,'Imaging Integration (IM or GD)', 'usegd', 'Select ImageMagick or GD1/GD2 for image processing', '$usegd', 28, 1)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (177,'Directory for backups?', 'backupdir', 'The full path to the directory to store backups', '$backupdir', 29, 1)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (178,'Path to mysqldump', 'mysqldumppath', 'The full path to your mysqldump executable', '$mysqldumppath', 30, 1)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (179,'Path to jpegtran (if used)', 'jpegtran', 'If you would like to clean any JPG image uploaded before being processed; enter the path to your jpegtran executable.', '$jpegtran', 18, 1)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (180,'Path to jhead (if used)', 'jhead_command', 'This only needs to be set if you are extracting EXIF information from images. Full server path.', '$jhead_command', 19, 1)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (181,'Gallery Open?', 'ppboards', '', '$ppboards', 20, 1)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (182,'Message displayed when closed', 'closedmsg', '', '$closedmsg', 21, 1)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (165,'Your SMF Cookie Name', 'smfcookie', 'Only needed for users of SMF forums', '', 5, 13)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (183,'Show Peronsal Albums Index link under Members Gallery?', 'showalbum', 'Adds a text link to the Albums index into the Members Gallery description', 'yes', 10, 3)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (184,'Allow users to move their own images?','usermove', '', 'no', 16, 2)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (84,'PhotoPost Version','pversion','','4.85',53,0)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (37,'cright','cright','','<font size=\"1\" face=\"verdana\">Powered by: PhotoPost<br />Copyright 2007 All Enthusiast, Inc.</font>',300,'0')";
        $query[] = "REPLACE INTO {$pp_db_prefix}admingroups VALUES (12,'Cookie Settings')";
        $query[] = "REPLACE INTO {$pp_db_prefix}admingroups VALUES (13,'Forum Settings')";
        $query[] = "ALTER TABLE {$pp_db_prefix}usergroups ADD uplimit INT(5) DEFAULT '0' NOT NULL";
        $query[] = "ALTER TABLE {$pp_db_prefix}categories ADD ugnovote VARCHAR(255) NULL AFTER ugnopost";
        $query[] = "UPDATE {$pp_db_prefix}settings SET title='Allow users to delete their own images?',optionorder=17 WHERE id=91";
        $query[] = "ALTER TABLE {$pp_db_prefix}categories CHANGE catorder catorder MEDIUMINT(4) DEFAULT '9999' NOT NULL";
        $query[] = "UPDATE {$pp_db_prefix}categories SET catorder=9999 WHERE catorder=0 AND cattype='a'";

        // Move some stuff around
        $query[] = "UPDATE {$pp_db_prefix}settings SET section=13,optionorder=1 WHERE id=7";
        $query[] = "UPDATE {$pp_db_prefix}settings SET section=13,optionorder=2 WHERE id=41";
        $query[] = "UPDATE {$pp_db_prefix}settings SET section=13,optionorder=3 WHERE id=83";
        $query[] = "UPDATE {$pp_db_prefix}settings SET section=13,optionorder=4 WHERE id=163";
        $query[] = "UPDATE {$pp_db_prefix}settings SET section=13,optionorder=5 WHERE id=153";

        for ( $x=0; $x < count($query); $x++) {
            $iquery = $query[$x];
            print "Performing MySQL command: $iquery ... ";
            $setup = mysql_query($iquery, $link);
            if ( !$setup ) print "<b>Error: ".mysql_error($link)."</b><br />";
            else print "Successful!<br />";
        }
    }

    print "<br />Upgrade complete! You should continue to <a href=\"upgrade.php?upgrade=485\">next step</a>";
}

if ( $upgrade == "485" ) {
    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">
            This install script will upgrade your 4.8.5 or 4.8.6 release.  Only run this upgrade if you have the
            4.8.5 or 4.8.6 version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=485&amp;step=1\">Proceed to Upgrade --></a></div></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    $output .= "$output<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
        <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">PhotoPost Upgrade
        </font></td></tr>
        <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">";

    if ( $step == "1" ) {
        $skip_exheader = "yes";
        require "pp-inc.php";

        print "{$output}Preparing to update 4.8.5 database...<p>";

        $query = array();
        $query[] = "ALTER TABLE {$pp_db_prefix}photos ADD numcom INT(8) DEFAULT '0' NOT NULL , ADD lastposter VARCHAR(255), ADD lastpid INT(8) DEFAULT '0' NOT NULL";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (185,'Use embedded multimedia?','embededmm', '', 'yes', 5, 5)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (186,'Degrees to rotate portrait thumbnails? (set to 0 for no rotation)','rotatep', 'For users of ImageMagick only', '0', 15, 6)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (187,'Degrees to rotate landscape thumbnails? (set to 0 for no rotation)','rotatel', 'For users of ImageMagick only', '0', 16, 6)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (188,'If rotating, long side for mini thumbnail?','minil', 'If rotating your thumbnails, we need to create a mini thumbnail', '50', 17, 6)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (189,'If rotating, short side for mini thumbnail?','minis', 'If rotating your thumbnails, we need to create a mini thumbnail', '27', 18, 6)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (190,'Allow downloads from URLs?','downurl', '', 'yes', 19, 6)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (191,'Allows users to order prints of photos?','enableprint', 'Users can elect to not allow photos to be printed if enabled', 'no', 20, 6)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (192,'Number of top level categories to show on index page?','indexcats', 'Set to 0 to show all top level categories on one page', '0', 11, 3)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (193,'Use popup window for BIG images?','bigpopup', 'If you want BIG photos to appear using a popup window, set to yes', 'no', 30, 5)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (194,'Do you want to use the forum-style layout?','pplayout', 'Yes is the default setting, No uses the thumbnail gallery layout', 'yes', 31, 1)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (195,'Do you want to enable the Announcement box?','news', '', 'no', 12, 3)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (196,'Title for the Announcement box?','newstitle', '', 'News', 13, 3)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (197,'Contents of the Announcement box?','newscopy', 'This block can contain HTML code (200 character limit)', '', 14, 3)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (198,'Use 24 hour time format?','timeformat', 'You can elect to have time displayed as HH:MMam or using the 24 hour clock', 'no', 32, 1)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (199,'Do you want moderators to have global rights?','modprivs', 'Set this to NO if you want to assign moderators to specific categories', 'yes', 18, 2)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (200,'Display Moderators as part of the category description?','dispmods', 'Set this to YES if you want the moderators listed on the index page under a cateogry', 'no', 15, 3)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (201,'Use photo view caching to reduce view update queries on high load sites?','viewcache', 'Set this to YES if you want to enable the view caching code which caches photo view updates', 'no', 33, 1)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (202,'Min allowable image width in pixels','minwidth','','0',21,6)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (203,'Min allowable image height in pixels','minheight','','0',22,6)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (204,'Mobile Phone Integration: EMail address for images','mobemail','EMail address users should send their images to','',23,6)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (205,'Show Last Comments column on Index?','showcoms','','yes',16,3)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (206,'Show Last Photo column on Index','showlast','','yes',17,3)";
        $query[] = "ALTER TABLE {$pp_db_prefix}categories ADD maximages INT(12) default '0' NOT NULL, ADD canzip VARCHAR(3) DEFAULT 'no' NOT NULL, ADD frames VARCHAR(32) NULL";
        $query[] = "ALTER TABLE {$pp_db_prefix}categories ADD numextra INT(3) default '0' NOT NULL";
        $query[] = "ALTER TABLE {$pp_db_prefix}categories ADD intro VARCHAR(3) default 'no' NOT NULL, ADD introtitle VARCHAR(128) DEFAULT NULL, ADD introcopy TEXT DEFAULT NULL, ADD moderators TEXT DEFAULT NULL";
        $query[] = "ALTER TABLE {$pp_db_prefix}categories ADD ratingtype INT(1) DEFAULT '0' NOT NULL, ADD takevotes INT(1) DEFAULT '0' NOT NULL";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (84,'PhotoPost Version','pversion','','5',53,0)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (37,'cright','cright','','<font size=\"1\" face=\"verdana\">Powered by: PhotoPost<br />Copyright 2007 All Enthusiast, Inc.</font>',300,'0')";
        $query[] = "UPDATE {$pp_db_prefix}photos SET allowprint='yes' WHERE allowprint != 'no'";
        $query[] = "CREATE TABLE {$pp_db_prefix}photoviews (photoid mediumint(9) NOT NULL default '0') TYPE=HEAP";
        $query[] = "CREATE TABLE {$pp_db_prefix}extrafields (id INT(12) NOT NULL AUTO_INCREMENT, cat INT(12), fieldname VARCHAR(255), fieldtype VARCHAR(2), fieldoptions TEXT, PRIMARY KEY (id) )";
        $query[] = "CREATE TABLE {$pp_db_prefix}photoextras (id INT(12) NOT NULL AUTO_INCREMENT, photo INT(12), extraid INT(12), selection TEXT, PRIMARY KEY (id) )";
        $query[] = "UPDATE {$pp_db_prefix}categories SET frames=NULL WHERE frames='0'";
        $query[] = "ALTER TABLE {$pp_db_prefix}users ADD cellphone VARCHAR( 255 )";

        for ( $x=0; $x < count($query); $x++) {
            $iquery = $query[$x];
            $setup = mysql_query($iquery, $link);
            if ( !$setup ) print "Error performing MySQL command: $iquery<br><b>Error: ".mysql_error($link)."</b><br><br>";
        }

        // No error required
        $query2 = array();
        $query2[] = "DELETE FROM {$pp_db_prefix}settings WHERE id=106";
        $query2[] = "DELETE FROM {$pp_db_prefix}settings WHERE id=107";
        $query2[] = "DELETE FROM {$pp_db_prefix}settings WHERE id=106";
        $query2[] = "DELETE FROM {$pp_db_prefix}settings WHERE id=107";

        for ( $x=0; $x < count($query2); $x++) {
            $iquery = $query2[$x];
            $setup = mysql_query($iquery, $link);
        }

        // Update comment counts
        if ( $Globals['dispempty'] == "yes" )
            $querya = "SELECT photo,COUNT(*) FROM {$Globals['pp_db_prefix']}comments GROUP BY photo";
        else
            $querya = "SELECT photo,COUNT(*) FROM {$Globals['pp_db_prefix']}comments WHERE LENGTH(comment) > 1 GROUP BY photo";

        $querya = mysql_query($querya,$link);
        while ( list( $id, $comcount ) = mysql_fetch_row($querya) ) {
            if ( $comcount > 0 ) {
                $queryi = "UPDATE {$Globals['pp_db_prefix']}photos SET numcom='$comcount' WHERE id=$id";
                $queryid = mysql_query($queryi, $link);
            }
        }

        print "<br><br><a href=\"upgrade.php?upgrade=485&amp;step=2\">Move DATA directory files (you only do this only once successfully) --></a> or quit here.<br />
        Moving data files can take some time depending on your installation; 10,000 files could take 5 minutes or more. Please be patient.";
        print "</td></tr></table></td></tr></table>";
        exit;
    }

    if ( $step == "2" ) {
        ini_set("max_execution_time", 0);

        $skip_exheader = "yes";
        require "pp-inc.php";

        print "{$output}Preparing to move files...<p>";
        flush();

        $datadir = $Globals['datafull'];

        $query = "SELECT id FROM {$pp_db_prefix}categories ORDER BY id";
        $queryv = mysql_query($query,$link);

        $waserror = false;
        while ( list( $id ) = mysql_fetch_row($queryv) ) {
            $newdir = "{$datadir}$id";
            if ( is_writable( $newdir ) ) {
                mkppdir( $newdir );
            }
            else {
                if ( is_dir( $newdir ) ) {
                    $waserror = true;
                    print "The directory $newdir is not writable.<br />";
                }
                else {
                    mkppdir( $newdir );
                    if ( !is_writable($newdir) ) {
                        $waserror = true;
                        print "The directory $newdir cannot be created.<br />";
                    }
                }
            }
        }
        @mysql_free_result($queryv);

        if ( $waserror ) {
            print "<br />We cannot continue because of errors. Please correct and hit REFRESH to correct and continue.";
            print "</td></tr></table></td></tr></table>";
            exit;
        }

        $query = "SELECT id,user,userid,cat,storecat,bigimage,medsize FROM {$pp_db_prefix}photos ORDER BY id";
        $queryv = mysql_query($query,$link);

        while ( list( $id, $user, $tuserid, $cat, $storecat, $bigimage, $medsize ) = mysql_fetch_row($queryv) ) {
            // Ignore copies
            if ( $storecat != 0 ) continue;

            $newdir = "{$datadir}$cat";

            $theext = get_ext($bigimage);
            $filename = $bigimage;
            $filename = str_replace( $theext, "", $filename);
            $newfilename = "$tuserid$bigimage";

            $thumblink = "$newdir/$tuserid$filename-thumb$theext";
            $newthumblink = "$newdir/thumbs/$tuserid$bigimage";
            $checkthumb = "$newdir/thumbs/$bigimage";

            $mediumlink = "$newdir/$tuserid$filename-med$theext";
            $newmediumlink = "$newdir/medium/$tuserid$bigimage";

            // Check to see that the filenames are not already the same.
            if ( !file_exists($checkthumb) || is_multimedia($bigimage) ) {
                if ( $medsize > 0 ) {
                    if ( file_exists( $mediumlink ) ) {
                        if ( copy($mediumlink, $newmediumlink) ) {
                            unlink( $mediumlink );
                        }
                        else {
                            print( "Copy photo $id: of $mediumlink to $newmediumlink failed!<br />" );
                        }
                    }
                }

                if ( file_exists( $thumblink ) ) {
                    if ( copy($thumblink, $newthumblink) ) {
                        unlink( $thumblink );
                    }
                    else {
                        print( "Copy of photo $id: $thumblink to $newthumblink failed!<br />" );
                    }
                }
                else {
                    $thethumbext = strtolower( $theext );
                    $s_thumblink = "$newdir/$tuserid$filename-thumb$thethumbext";
                    $thumblink2 = "$newdir/thumbs/$tuserid$filename.jpg";
                    if ( file_exists( $s_thumblink ) ) {
                        if ( copy($s_thumblink, $thumblink2) ) {
                            unlink( $s_thumblink );
                        }
                        else {
                            print( "Copy of photo $id: file $s_thumblink to $thumblink2 failed!<br />" );
                        }
                    }
                    else {
                        $s_thumblink = "$newdir/$tuserid$filename-thumb.jpg";
                        if ( file_exists( $s_thumblink ) ) {
                            if ( copy($s_thumblink, $thumblink2) ) {
                                unlink( $s_thumblink );
                            }
                            else {
                                print( "Copy of photo $id: file $s_thumblink to $thumblink2 failed!<br />" );
                            }
                        }
                    }
                }
            }
        }
        @mysql_free_result($queryv);

        print "<br><br>This step has completed. If you had file errors, you can REFRESH this page to keep
               moving files or retry moves that did not work if you fixed any permissions issues.<br><br>
               When you are finished, <a href=\"upgrade.php?upgrade=485&amp;step=3\">click here to continue to next step ---></a>";
        print "</td></tr></table></td></tr></table>";
        exit;
    }

    if ( $step == "3" ) {
        $skip_exheader = "yes";
        require "pp-inc.php";

        print "{$output}Updating filenames...<p>";

        $query = "SELECT id,userid,bigimage FROM {$pp_db_prefix}photos ORDER BY id";
        $queryv = mysql_query($query,$link);

        while ( list( $id, $tuserid, $bigimage ) = mysql_fetch_row($queryv) ) {
            $query = "UPDATE {$pp_db_prefix}photos SET bigimage='$tuserid$bigimage' WHERE id=$id";
            $queryb = mysql_query($query,$link);
        }

        print "Updates completed...<br><br>Preparing to remove files which are no longer used by PhotoPost.";
        flush();
    }

    if ( file_exists("$PP_PATH/login.php") ) {
        unlink( "$PP_PATH/dcfp_auth_lib.php");
        unlink( "$PP_PATH/subscribe.php");
        unlink( "$PP_PATH/showalbums.php");
        unlink( "$PP_PATH/login.php");
        unlink( "$PP_PATH/orderphotos.php");
        unlink( "$PP_PATH/logout.php");
        unlink( "$PP_PATH/reportphoto.php");
        unlink( "$PP_PATH/cookies.php");
        unlink( "$PP_PATH/catopts.php");
        unlink( "$PP_PATH/addfav.php");
        unlink( "$PP_PATH/zipndownload.php");
        unlink( "$PP_PATH/sortphotos.php");
        unlink( "$PP_PATH/login-inc.php");
        unlink( "$PP_PATH/createcal.php");
        unlink( "$PP_PATH/email-inc.php");
        unlink( "$PP_PATH/adm-cinc.php");
        unlink( "$PP_PATH/adm-admlog.php");
        unlink( "$PP_PATH/adm-backup.php");
        unlink( "$PP_PATH/adm-editint.php");
        unlink( "$PP_PATH/adm-modcom.php");
        unlink( "$PP_PATH/adm-move.php");
        unlink( "$PP_PATH/adm-phpi.php");
        unlink( "$PP_PATH/adm-purge.php");
        unlink( "$PP_PATH/adm-templ.php");
        unlink( "$PP_PATH/adm-pa.php");
        unlink( "$PP_PATH/adm-cfgtpl.php");
        unlink( "$PP_PATH/adm-cfgedit.php");
        unlink( "$PP_PATH/adm-cfgint.php");
        unlink( "$PP_PATH/adm-editcfg.php");
        unlink( "$PP_PATH/adm-intedit.php");
        unlink( "$PP_PATH/adm-options.php");
        unlink( "$PP_PATH/adm-order.php");
        unlink( "$PP_PATH/adm-style.php");
    }

    print "<br />Upgrade complete! You should continue to <a href=\"upgrade.php?upgrade=50\">next step</a>";
    print "</td></tr></table></td></tr></table>";
    exit;
}


if ( $upgrade == "5b3" ) {
    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">
            This install script will upgrade your 5.0b3 release to 5.0b4.  Only run this upgrade if you have the
            5.0b3 version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=5b3&amp;step=1\">Proceed to Upgrade --></a></div></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    $output .= "$output<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
        <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">PhotoPost Upgrade
        </font></td></tr>
        <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">";

    if ( $step == "1" ) {
        $skip_exheader = "yes";
        require "pp-inc.php";

        print "{$output}Preparing to update database...<p>";

        $query = array();
        $query[] = "ALTER TABLE {$pp_db_prefix}categories ADD numextra INT(3) default '0' NOT NULL";
        $query[] = "ALTER TABLE {$pp_db_prefix}categories ADD ratingtype INT(1) DEFAULT '0' NOT NULL, ADD takevotes INT(1) DEFAULT '0' NOT NULL";
        $query[] = "CREATE TABLE {$pp_db_prefix}extrafields (id INT(12) NOT NULL AUTO_INCREMENT, cat INT(12), fieldname VARCHAR(255), fieldtype VARCHAR(2), fieldoptions TEXT, PRIMARY KEY (id) )";
        $query[] = "CREATE TABLE {$pp_db_prefix}photoextras (id INT(12) NOT NULL AUTO_INCREMENT, photo INT(12), extraid INT(12), selection TEXT, PRIMARY KEY (id) )";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (201,'Use photo view caching to reduce view update queries on high load sites?','viewcache', 'Set this to YES if you want to enable the view caching code which caches photo view updates', 'no', 33, 1)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (202,'Min allowable image width in pixels','minwidth','','0',21,6)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (203,'Min allowable image height in pixels','minheight','','0',22,6)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (204,'Mobile Phone Integration: EMail address for images','mobemail','EMail address users should send their images to','',23,6)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (205,'Show Last Comments column on Index?','showcoms','','yes',16,3)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (206,'Show Last Photo column on Index','showlast','','yes',17,3)";
        $query[] = "UPDATE {$pp_db_prefix}categories SET frames=NULL WHERE frames='0'";
        $query[] = "ALTER TABLE {$pp_db_prefix}users ADD cellphone VARCHAR( 255 )";

        for ( $x=0; $x < count($query); $x++) {
            $iquery = $query[$x];
            $setup = mysql_query($iquery, $link);
            if ( !$setup ) print "Error performing MySQL command: $iquery<br><b>Error: ".mysql_error($link)."</b><br><br>";
        }

        $query = "SELECT photoid, COUNT(*) as views FROM {$Globals['pp_db_prefix']}photoviews GROUP BY photoid";
        $result = mysql_query($query,$link);

        while ($newviews = mysql_fetch_array($result)) {
            $query = "UPDATE {$Globals['pp_db_prefix']}photos SET views = views+$newviews[views] WHERE id='$newviews[photoid]'";
            $result2 = mysql_query($query,$link);
        }

        $query = "DELETE FROM {$Globals['pp_db_prefix']}photoviews";
        $result = mysql_query($query,$link);

        print "<br />Upgrade complete! You should continue to <a href=\"upgrade.php?upgrade=50\">next step</a>";
        print "</td></tr></table></td></tr></table>";
        exit;
    }
}

function fixf( $var ) { $var=stripslashes($var); return(addslashes($var)); }

if ( $upgrade == "50" ) {
    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">
            This install script will upgrade your 5.0 release to 5.1.  Only run this upgrade if you have the
            5.0 version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=50&amp;step=1\">Proceed to Upgrade --></a></div></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    $output .= "$output<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
        <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">PhotoPost Upgrade
        </font></td></tr>
        <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">";

    if ( $step == "1" ) {
        $skip_exheader = "yes";
        require "pp-inc.php";

        print "{$output}Preparing to update database...<p>";

        $query = array();
        $query[] = "ALTER TABLE {$pp_db_prefix}categories ADD ismember SMALLINT(1) default '0' NOT NULL";
        $query[] = "ALTER TABLE {$pp_db_prefix}categories ADD albums TEXT AFTER children";
        $query[] = "UPDATE {$pp_db_prefix}settings SET section=3,optionorder=18 WHERE id=194";
        $query[] = "UPDATE {$pp_db_prefix}settings SET section=4,optionorder=4 WHERE id=94";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=31 WHERE id=193";
        $query[] = "UPDATE {$pp_db_prefix}settings SET title='URL to PhotoPost data directory' WHERE id=5";
        $query[] = "UPDATE {$pp_db_prefix}settings SET title='Show Personal Albums Index link under Members Gallery?' WHERE id=183";
        $query[] = "UPDATE {$pp_db_prefix}settings SET title='Full SERVER PATH to PhotoPost data directory' WHERE id=6";
        $query[] = "UPDATE {$pp_db_prefix}settings SET title='Enable on-the-fly image protection',description='This option uses the watermark.php script to serve images' WHERE id=175";
        $query[] = "UPDATE {$pp_db_prefix}settings SET description='Use Right-Click Disable JavaScript to try and prevent right-clicking images' WHERE id=134";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (207,'Original Image storage directory URL','origdir','Typically this path matches your DATA directory URL, unless you want to store your original images seperatly from your thumbnail/medium images','{$Globals['datadir']}',34,1)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (208,'Orignial Image storage directory server path','origfull','Typically this path matches your DATA directory server path, unless you want to store your original images seperatly from your thumbnail/medium images','{$Globals['datafull']}',35,1)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (209,'When using on-the-fly image generation, do you want to overlay the watermark image?','overwater','You can use this feature for on-the-fly watermarks in combination with the on-the-fly image generation.','no',30,5)";

        for ( $x=0; $x < count($query); $x++) {
            $iquery = $query[$x];
            $setup = mysql_query($iquery, $link);
            if ( !$setup ) print "Error performing MySQL command: $iquery<br><b>Error: ".mysql_error($link)."</b><br><br>";
        }

        unlink( "$PP_PATH/adm-userg.php");
        unlink( "$PP_PATH/adm-approve.php");
        unlink( "$PP_PATH/adm-db.php");
        unlink( "$PP_PATH/adm-menu.php");

        $query = "SELECT id,catname,description,extra1,extra2,extra3,extra4,extra5,extra6,introtitle,introcopy FROM {$pp_db_prefix}categories";
        $resultb = mysql_query($query, $link);
        while ( list( $cid, $cname, $cdesc, $e1, $e2, $e3, $e4, $e5, $e6, $i1, $i2 ) = mysql_fetch_row($resultb) ) {
            $cname = fixf($cname); $cdesc = fixf($cdesc); $e1 = fixf($e1); $e2 = fixf($e2); $e3 = fixf($e3); $e4 = fixf($e4); $e5 = fixf($e5); $e6 = fixf($e6); $i1 = fixf($i1); $i2 = fixf($i2);
            $query2 = "UPDATE {$pp_db_prefix}categories SET catname='$cname',description='$cdesc',extra1='$e1',extra2='$e2',extra3='$e3',extra4='$e4',extra5='$e5',extra6='$e6',introtitle='$i1',introcopy='$i2' WHERE id=$cid";
            $resultc = mysql_query($query2, $link);
        }

        $query = "SELECT id,username,comment FROM {$pp_db_prefix}comments";
        $resultb = mysql_query($query, $link);
        while ( list( $cid, $cname, $ccomment ) = mysql_fetch_row($resultb) ) {
            $cname = fixf($cname); $ccomment = fixf($ccomment);
            $query2 = "UPDATE {$pp_db_prefix}comments SET username='$cname',comment='$ccomment' WHERE id=$cid";
            $resultc = mysql_query($query2, $link);
        }

        $query = "SELECT id,user,title,description,extra1,extra2,extra3,extra4,extra5,extra6 FROM {$pp_db_prefix}photos";
        $resultb = mysql_query($query, $link);
        while ( list( $cid, $cname, $ctitle, $cdesc, $e1, $e2, $e3, $e4, $e5, $e6 ) = mysql_fetch_row($resultb) ) {
            $cname = fixf($cname); $ctitle = fixf($ctitle); $cdesc = fixf($cdesc); $e1 = fixf($e1); $e2 = fixf($e2); $e3 = fixf($e3); $e4 = fixf($e4); $e5 = fixf($e5); $e6 = fixf($e6);
            $query2 = "UPDATE {$pp_db_prefix}photos SET user='$cname',title='$ctitle',description='$cdesc',extra1='$e1',extra2='$e2',extra3='$e3',extra4='$e4',extra5='$e5',extra6='$e6' WHERE id=$cid";
            $resultc = mysql_query($query2, $link);
        }

        // Now we need to update everything and populate the new albums field
        upgradecategories(0);

        print "<br />Upgrade complete! You should continue to <a href=\"upgrade.php?upgrade=51\">next step</a>";
        print "</td></tr></table></td></tr></table>";
        exit;
    }
}

if ( $upgrade == "51" ) {
    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">
            This install script will upgrade your 5.1 release to 5.11.  Only run this upgrade if you have the
            5.0 version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=51&amp;step=1\">Proceed to Upgrade --></a></div></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    $output .= "$output<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
        <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">PhotoPost Upgrade
        </font></td></tr>
        <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">";

    if ( $step == "1" ) {
        $skip_exheader = "yes";
        require "pp-inc.php";

        print "{$output}Preparing to update database...<p>";

        $query = array();
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (210,'Default location of the photo previews?','filmstrip','Determines the location of the film-strip previews on the showphoto page.','top',26,5)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (84,'PhotoPost Version','pversion','','5.11',53,0);";

        for ( $x=0; $x < count($query); $x++) {
            $iquery = $query[$x];
            $setup = mysql_query($iquery, $link);
            if ( !$setup ) print "Error performing MySQL command: $iquery<br><b>Error: ".mysql_error($link)."</b><br><br>";
        }

        print "<br />Upgrade complete! You should continue to <a href=\"upgrade.php?upgrade=511\">next step</a>";
        print "</td></tr></table></td></tr></table>";
        exit;
    }
}

if ( $upgrade == "511" ) {
    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">
            This install script will upgrade your 5.1X release to 5.2.  Only run this upgrade if you have the
            5.1x version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=511&amp;step=1\">Proceed to Upgrade --></a></div></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    $output .= "$output<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
        <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">PhotoPost Upgrade
        </font></td></tr>
        <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">";

    if ( $step == "1" ) {
        // Connecting, selecting database
        $skip_exheader = "yes";
        require "config-inc.php";
        $link = mysql_connect("$host", "$mysql_user", "$mysql_password") or die('I cannot connect to the PhotoPost database. [host:$host][mysql_user:$mysql_user][mysql_password:$mysql_password]');
        mysql_select_db ("$database", $link)or die("Could not connect to PhotoPost database");

        print $output;
        print "Preparing to update database...<p>";
        flush();

        $query = array();
        $query[] = "CREATE TABLE {$pp_db_prefix}cache (id tinyint(1) NOT NULL default '1', timestamp int(15) NOT NULL default '0',
                                           statscache mediumtext, recentcache mediumtext, popularcache mediumtext,
                                           randomcache mediumtext, calcache mediumtext, catcache mediumtext, catprops mediumtext,
                                           PRIMARY KEY  (id), KEY id (id)) TYPE=MyISAM";
        $query[] = "INSERT INTO {$pp_db_prefix}cache VALUES (1,0,null,null,null,null,null,null,null)";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (84,'PhotoPost Version','pversion','','5.2',53,0);";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (211,'Minutes to cache index page data for featured photos, statistics and PALs?','cachetimeout','Number of minutes to cache information. Default is 10 minutes, 0 means no caching.','10',36,1)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (212,'Show Calendar PAL?','calpal','Do you want to display the calendar pal, yes or no.','yes',16,11)";

        for ( $x=0; $x < count($query); $x++) {
            $iquery = $query[$x];
            $setup = mysql_query($iquery, $link);
            if ( !$setup ) print "Error performing MySQL command: $iquery<br><b>Error: ".mysql_error($link)."</b><br><br>";
        }
        mysql_close($link);

        require "pp-inc.php";

        // Let's update the category cache
        update_catcache();
        update_catprops();

        print "<br />Upgrade complete! You should continue to <a href=\"upgrade.php?upgrade=52\">next step</a>";
        print "</td></tr></table></td></tr></table>";
        exit;
    }
}

if ( $upgrade == "52" ) {
    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">
            This install script will upgrade your 5.2x release to 5.3.  Only run this upgrade if you have the
            5.2x version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=52&amp;step=1\">Proceed to Upgrade --></a></div></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    $output .= "$output<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
        <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">PhotoPost Upgrade
        </font></td></tr>
        <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">";

    if ( $step == "1" ) {
        // Connecting, selecting database
        $skip_exheader = "yes";
        require "config-inc.php";
        $link = mysql_connect("$host", "$mysql_user", "$mysql_password") or die('I cannot connect to the PhotoPost database. [host:$host][mysql_user:$mysql_user][mysql_password:$mysql_password]');
        mysql_select_db ("$database", $link)or die("Could not connect to PhotoPost database");

        print $output;
        print "Preparing to update database...<p>";
        flush();

        $query = array();
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (84,'PhotoPost Version','pversion','','5.3',53,0);";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (213,'Show html code to display photos?','showhtml','Do you want to show the img src html tag for a photo?','no',6,5)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (214,'Show direct links to photos?','showdirect','Do you want to display the page link to a photo?','no',7,5)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (215,'Load limit for server?','loadlimit','If running *nix and you want to disable your forums when load goes over a certain limit; place the high limit here.','0',35,1)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (216,'Default number of thumbnail rows?','thumbrows','How many rows of thumbnails do you want to display by default on this page?','3',5,4)";
        $query[] = "DELETE FROM {$pp_db_prefix}settings WHERE id=191";
        $query[] = "ALTER TABLE {$pp_db_prefix}categories ADD thumbtype INT(2) UNSIGNED DEFAULT '0'";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (217,'Use category cache?','catcache','On some larger sites, using the category cache can actually reduce performance.','yes',36,1)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (218,'Display Featured Photos on this page?','features','On larger sites this option can slow down the showgallery page. Turn off to speed up this page.','yes',8,5)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (219,'Display Admin quick move/delete options under photo?','quickopts','On larger sites this option can slow down the showphoto page. Turn off to speed up this page.','yes',8,5)";
        $query[] = "ALTER TABLE {$pp_db_prefix}categories ADD subalbum INT(12) DEFAULT '0' NOT NULL AFTER albums";
        $query[] = "UPDATE {$pp_db_prefix}settings SET setting = '<font size=\"1\" face=\"verdana\">Powered by: PhotoPost --replaceme--<br />Copyright 2007 All Enthusiast, Inc.</font>' WHERE id=37";

        for ( $x=0; $x < count($query); $x++) {
            $iquery = $query[$x];
            $setup = mysql_query($iquery, $link);
            if ( !$setup ) print "Error performing MySQL command: $iquery<br><b>Error: ".mysql_error($link)."</b><br><br>";
        }
        mysql_close($link);

        print "<br />Upgrade complete! You should continue to <a href=\"upgrade.php?upgrade=53\">next step</a>";
        print "</td></tr></table></td></tr></table>";
        exit;
    }
}

if ( $upgrade == "53" ) {
    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">
            This install script will upgrade your 5.3x release to 5.5.  Only run this upgrade if you have the
            5.2x version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=53&amp;step=1\">Proceed to Upgrade --></a></div></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    $output .= "$output<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
        <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">PhotoPost Upgrade
        </font></td></tr>
        <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">";

    if ( $step == "1" ) {
        // Connecting, selecting database
        $skip_exheader = "yes";
        require "pp-inc.php";

        print $output;
        print "Preparing to update database...<p>";
        flush();

        $query = array();
        $query[] = "ALTER TABLE {$pp_db_prefix}photos ADD allowrate INT(1) DEFAULT '1' NOT NULL, ADD allowcoms INT(1) DEFAULT '1' NOT NULL;";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (220,'Number of minutes a user is allowed to edit a comment?','comtimeout','0 to disable. 86400 is one day.','0',2,7)";
        $query[] = "ALTER TABLE {$pp_db_prefix}comments CHANGE cat cat INT(11) DEFAULT '0' NOT NULL";
        $query[] = "ALTER TABLE {$pp_db_prefix}comments CHANGE userid userid INT(11) DEFAULT '0' NOT NULL";
        $query[] = "ALTER TABLE {$pp_db_prefix}comments CHANGE username username VARCHAR(32) NOT NULL";
        $query[] = "DELETE FROM {$pp_db_prefix}settings WHERE id=219";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (84,'PhotoPost Version','pversion','','5.5',53,0);";

        for ( $x=0; $x < count($query); $x++) {
            $iquery = $query[$x];
            $setup = mysql_query($iquery, $link);
            if ( !$setup ) print "Error performing MySQL command: $iquery<br><b>Error: ".mysql_error($link)."</b><br><br>";
        }

        update_catprops();

        print "<br />Upgrade complete! You should continue to <a href=\"upgrade.php?upgrade=55\">next step</a>";
        print "</td></tr></table></td></tr></table>";
        exit;
    }
}

if ( $upgrade == "55" ) {
    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">
            This install script will upgrade your 5.5 release to 5.6.  Only run this upgrade if you have the
            5.5 version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=55&amp;step=1\">Proceed to Upgrade --></a></div></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
        <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">PhotoPost Upgrade
        </font></td></tr>
        <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">";

    if ( $step == "1" ) {
        // Connecting, selecting database
        $skip_exheader = "yes";
        require "pp-inc.php";

        print $output;
        print "Preparing to update database...<p>";
        flush();

        $query = array();
        $query[] = "ALTER TABLE {$pp_db_prefix}favorites ADD INDEX ( userid )";
        $query[] = "ALTER TABLE {$pp_db_prefix}users ADD lastphoto INT( 12 ) NOT NULL DEFAULT '0', ADD lastdate INT( 15 ) NOT NULL DEFAULT '0'";
        $query[] = "CREATE TABLE {$pp_db_prefix}searchids (
            searchid INT( 12 ) NOT NULL AUTO_INCREMENT PRIMARY KEY ,
            userid INT( 12 ) NOT NULL DEFAULT '0',
            searchtype VARCHAR( 1 ) NULL ,
            searchterms VARCHAR( 250 ) NULL ,
            searchdate VARCHAR( 15 ) NULL ,
            cats MEDIUMTEXT NULL ,
            name VARCHAR( 64 ) NULL ,
            preview SMALLINT( 1 ) NOT NULL DEFAULT '1',
            idlist MEDIUMTEXT NULL ,
            numresults INT( 5 ) NOT NULL DEFAULT '0',
            ipaddress VARCHAR( 15 ) NULL ,
            searchtime FLOAT( 6, 6 ) NOT NULL DEFAULT '0',
            date INT( 15 ) NOT NULL DEFAULT '0'
            )";
        $query[] = "ALTER TABLE {$pp_db_prefix}users CHANGE bio bio MEDIUMTEXT NULL DEFAULT NULL";
        $query[] = "ALTER TABLE {$pp_db_prefix}users CHANGE interests interests MEDIUMTEXT NULL DEFAULT NULL";
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (84,'PhotoPost Version','pversion','','5.6',53,0);";
        $query[] = "REPLACE INTO {$pp_db_prefix}admingroups VALUES (14,'Search Options');";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (221,'Require users to be registered to use search?','searchreg','','no',1,14)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (222,'Maximium number of search results to return?','searchmax','On larger sites, the less the better.','500',2,14)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (223,'Number of seconds between searches?','searchto','The number of seconds a user must wait between searches.','30',3,14)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (224,'Number of days to hold search results?','searchhold','','7',5,14)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (225,'Display who is viewing a category?','catonline','This option adds a query to the Show Gallery page.','yes',5,4)";

        for ( $x=0; $x < count($query); $x++) {
            $iquery = $query[$x];
            $setup = mysql_query($iquery, $link);
            if ( !$setup ) print "Error performing MySQL command: $iquery<br><b>Error: ".mysql_error($link)."</b><br><br>";
        }

        $resulta = mysql_query("SELECT userid FROM {$pp_db_prefix}photos WHERE userid > 0", $link);
        while ( list( $puser ) = mysql_fetch_row($resulta) )
        {
            $resultb = mysql_query("SELECT id,user,date FROM {$pp_db_prefix}photos WHERE userid=$puser ORDER BY date DESC LIMIT 1", $link);

            while ( list( $pid, $pname, $pdate) = mysql_fetch_row($resultb) )
            {
                $resultc = mysql_query("SELECT userid FROM {$pp_db_prefix}users WHERE userid=$puser LIMIT 1", $link);
                list ( $checkid ) = mysql_fetch_row($resultc);

                if ( $checkid )
                {
                    $resultd = mysql_query("UPDATE {$pp_db_prefix}users SET lastphoto=$pid,lastdate=$pdate WHERE userid=$puser", $link);
                }
                else
                {
                    $pname = addslashes($pname);
                    $resultd = mysql_query("INSERT INTO {$pp_db_prefix}users (userid,username,lastphoto,lastdate) VALUES ($puser,'$pname',$pid,$pdate)", $link);
                }
            }
        }

        print "<br />Upgrade complete! You should continue to <a href=\"upgrade.php?upgrade=56\">next step</a>";
        print "</td></tr></table></td></tr></table>";
        exit;
    }
}

if ( $upgrade == "56" ) {
    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">
            This install script will upgrade your 5.6 release to 5.61.  Only run this upgrade if you have the
            5.6 version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=56&amp;step=1\">Proceed to Upgrade --></a></div></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
        <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">PhotoPost Upgrade
        </font></td></tr>
        <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">";

    if ( $step == "1" ) {
        // Connecting, selecting database
        $skip_exheader = "yes";
        require "pp-inc.php";

        print $output;
        print "Preparing to update database...<p>";
        flush();

        $query = array();
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (84,'PhotoPost Version','pversion','','5.61',53,0);";
        $query[] = "CREATE TABLE IF NOT EXISTS {$pp_db_prefix}favorites (id int(12) NOT NULL auto_increment,
                    userid int(8) NOT NULL default '0',
                    photo int(11) NOT NULL default '0',
                    PRIMARY KEY (id), KEY parent (photo), KEY userid (userid)) TYPE=MyISAM";

        for ( $x=0; $x < count($query); $x++) {
            $iquery = $query[$x];
            $setup = mysql_query($iquery, $link);
            if ( !$setup ) print "Error performing MySQL command: $iquery<br><b>Error: ".mysql_error($link)."</b><br><br>";
        }

        print "<br />Upgrade complete! You should continue to <a href=\"upgrade.php?upgrade=561\">next step</a>";
        print "</td></tr></table></td></tr></table>";
        exit;
    }
}


if ( $upgrade == "561" ) {
    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">
            This install script will upgrade your 5.61 release to 6.0.  Only run this upgrade if you have the
            5.6 version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=561&amp;step=1\">Proceed to Upgrade --></a></div></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
        <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">PhotoPost Upgrade
        </font></td></tr>
        <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">";

    if ( $step == "1" ) {
        // Connecting, selecting database
        $skip_exheader = "yes";
        require "pp-inc.php";

        print $output;
        print "Preparing to update database...<p>";
        flush();

        $query = array();
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (84,'PhotoPost Version','pversion','','6.0',53,0);";

        $query[] = "CREATE TABLE {$pp_db_prefix}messages (
                        msgid int( 12 ) NOT NULL AUTO_INCREMENT ,
                        userid int( 12 ) NOT NULL default '0',
                        datestamp int( 15 ) NOT NULL default '0',
                        message mediumtext,
                        status smallint( 1 ) NOT NULL default '0',
                        type enum( 'c', 'f', 'i', 'm', 'r' ) default NULL ,
                        photo int( 12 ) NOT NULL default '0',
                    PRIMARY KEY ( msgid ) ) TYPE=MYISAM";

        $query[] = "CREATE TABLE {$pp_db_prefix}captcha (
                        id int( 12 ) NOT NULL auto_increment ,
                        code varchar( 12 ) default NULL ,
                    PRIMARY KEY ( id ) ) TYPE=MyISAM";

        $query[] = "CREATE TABLE {$pp_db_prefix}buddies (
                        id int( 12 ) NOT NULL auto_increment ,
                        userid int( 12 ) NOT NULL default '0',
                        buddy int( 12 ) NOT NULL default '0',
                    PRIMARY KEY ( id ) ,
                    KEY userid ( userid ) ) TYPE=MyISAM";

        $query[] = "CREATE TABLE {$pp_db_prefix}board (
                        msgid int(12) NOT NULL auto_increment,
                        replyto int(12) NOT NULL default '0',
                        userid int(12) NOT NULL default '0',
                        category int(4) NOT NULL default '0',
                        date int(15) NOT NULL default '0',
                        subject varchar(250) default NULL,
                        message mediumtext,
                        replies int(6) NOT NULL default '0',
                        views int(7) NOT NULL default '0',
                        lastmsg int(12) NOT NULL default '0',
                        lastdate int(15) NOT NULL default '0',
                        lastuser int(12) NOT NULL default '0',
                        lastusername varchar(32) default NULL,
                        ipaddr varchar(15) default NULL,
                        updated int(16) NOT NULL default '0',
                        updateuser int(12) NOT NULL default '0',
                    PRIMARY KEY  (msgid),
                    KEY date (date) ) TYPE=MyISAM";

        $query[] = "CREATE TABLE {$pp_db_prefix}invites (
                        id int( 12 ) NOT NULL AUTO_INCREMENT ,
                        code varchar( 32 ) default NULL ,
                        email varchar( 32 ) default NULL ,
                        name varchar( 64 ) default NULL ,
                        message mediumtext,
                        datestamp int( 16 ) NOT NULL default '0',
                        referer int( 10 ) NOT NULL default '0',
                        status smallint( 1 ) NOT NULL default '0',
                        uid int( 12 ) NOT NULL default '0',
                        PRIMARY KEY ( id ) ,
                        UNIQUE KEY code ( code ) ) TYPE=MYISAM";

        $query[] = "ALTER TABLE {$pp_db_prefix}users
                        ADD realname varchar(80) default NULL,
                        ADD title varchar(30) default NULL,
                        ADD signature varchar(250) default NULL,
                        ADD avatar varchar(120) default NULL,
                        ADD mature tinyint(1) NOT NULL default '1',
                        ADD invites int(6) NOT NULL default '0',
                        ADD accepts int(6) NOT NULL default '0',
                        ADD laston int(15) NOT NULL default '0'";

        $query[] = "ALTER TABLE {$pp_db_prefix}photos ADD votes tinyint(1) NOT NULL default '0'";
        $query[] = "ALTER TABLE {$pp_db_prefix}comments ADD votes tinyint(1) NOT NULL default '0'";

        $query[] = "ALTER TABLE {$pp_db_prefix}iponline ADD uid INT(12) NOT NULL default '0', ADD referer VARCHAR(255) default NULL, ADD agent VARCHAR(100) default NULL";
        $query[] = "ALTER TABLE {$pp_db_prefix}photos ADD tags INT(15) NOT NULL default '0', ADD ismature smallint(1) NOT NULL default '0', ADD exifinfo BINARY(1) NOT NULL DEFAULT '0'";
        $query[] = "ALTER TABLE {$pp_db_prefix}categories CHANGE cattype cattype ENUM('c','a') NOT NULL DEFAULT 'c'";

        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (226,'Use lightbox integration?','lightbox','','no',32,5)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (227,'Width to trigger lightbox integration (if enabled)?','lbwidth','','900',33,5)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (228,'Height to trigger lightbox integration (if enabled)?','lbheight','','600',34,5)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (229,'Use mature content filter?','mature','Prevents photos marked from mature being shown without user electing to view them.','no',18,2)";

        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (230,'Use uniform thumbnail feature?','uniform','','no',26,6)";
        $query[] = "UPDATE {$pp_db_prefix}settings SET title='Use uniform thumbnail feature?' WHERE id=230";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (231,'Uniform thumbnail height?','uniheight','Can only be used when using IM for imaging.','78',27,6)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (232,'Uniform thumbnail width','uniwidth','Can only be used when using IM for imaging.','120',28,6)";

        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (233,'Use Messaging System for PhotoPost alerts/notices?','usemsg','','yes',38,1)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (234,'Use CAPTCHA images when verifying registration?','usecaptcha','Requires GD2 support!','no',4,8)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (235,'Enable PhotoPost Message Board?','usebb','Used only for internal PhotoPost systems.','no',5,13)";
        $query[] = "DELETE FROM {$pp_db_prefix}settings WHERE id=166;";

        $query[] = "UPDATE {$pp_db_prefix}settings SET setting='<font size=\"1\" face=\"verdana\">Photo Sharing Gallery by PhotoPost<br />Copyright &copy 2007 All Enthusiast, Inc.</font>' WHERE id=37";

        for ( $x=0; $x < count($query); $x++)
        {
            $iquery = $query[$x];
            $setup = mysql_query($iquery, $link);
            if ( !$setup ) print "Error performing MySQL command: $iquery<br><b>Error: ". mysql_error($link) ."</b><br><br>";
        }

        print "updating photo tags...";

        // Set tags info for all photos
        $resulta = mysql_query("SELECT id,count(*) FROM {$pp_db_prefix}favorites GROUP BY photo", $link);
        while ( list( $pid, $pcount ) = mysql_fetch_row($resulta) )
        {
            mysql_query("UPDATE {$pp_db_prefix}photos SET tags=$pcount WHERE id=$pid LIMIT 1", $link);
        }

        print "done.<br />scanning for exifs... ";

        // Set EXIF info for all photos
        $resulta = mysql_query("SELECT photoid FROM {$pp_db_prefix}exif", $link);
        while ( list( $pid ) = mysql_fetch_row($resulta) )
        {
            mysql_query("UPDATE {$pp_db_prefix}photos SET exifinfo=1 WHERE id=$pid LIMIT 1", $link);
        }

        print "done.<br />updating users table...";

        // Set usernames info for all users (the hard way, seperate db's)
        $resultb = mysql_query("SELECT userid,user FROM {$pp_db_prefix}photos", $link);
        while ( list( $uid, $username ) = mysql_fetch_row($resultb) )
        {
            $username = addslashes($username);

            // Lets force an INSERT to make sure we have records for everyone
            mysql_query("INSERT IGNORE INTO {$pp_db_prefix}users (userid,username) VALUES($pid,'$username')", $link);
            mysql_query("UPDATE {$pp_db_prefix}users SET username='$username' WHERE userid=$pid LIMIT 1", $link);
        }

        print "done.<br />updating votes...";

        // Convert old ratings to new votes
        $resultb = mysql_query("SELECT id FROM {$pp_db_prefix}categories WHERE ratingtype=1", $link);
        while ( list( $cid ) = mysql_fetch_row($resultb) )
        {
            mysql_query("UPDATE {$pp_db_prefix}photos SET votes=rating WHERE cat=$cid", $link);
            mysql_query("UPDATE {$pp_db_prefix}comments SET vote=1 WHERE cat=$cid", $link);
        }

        if ( $Globals['vbversion'] == "photopost" )
        {
            $avdir = $Globals['datadir']."/avatars";
            @mkdir( $avdir );
            @chmod( $avdir, 0777 );
        }

        upgradecategories(0);

        print "<br />Upgrade complete! You should continue to <a href=\"upgrade.php?upgrade=60\">next step</a>";
        print "</td></tr></table></td></tr></table>";
        exit;
    }
}

if ( $upgrade == "60" ) {
    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">
            This install script will upgrade your 6.0/6.0x to 6.1.  Only run this upgrade if you have the
            6.0 or 6.0x version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=60&amp;step=1\">Proceed to Upgrade --></a></div></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
        <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">PhotoPost Upgrade
        </font></td></tr>
        <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">";

    if ( $step == "1" ) {
        // Connecting, selecting database
        $skip_exheader = "yes";
        require "pp-inc.php";

        print $output;
        print "Preparing to update database...<p>";
        flush();

        $query = array();
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (84,'PhotoPost Version','pversion','','6.1',53,0);";

        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (236,'Enable Email a Friend feature?','findfriend','','yes',7,4)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (238,'Use images for user menu options on showphoto?','imgmenu','','yes',35,5)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (239,'Enable zoom javascript?','zoom','Enable the TJP zoom javascript feature on showphoto?','no',36,5)";
        $query[] = "UPDATE {$pp_db_prefix}settings SET optionorder=6 WHERE id=216";
        $query[] = "ALTER TABLE {$pp_db_prefix}messages ADD fromuserid INT( 12 ) DEFAULT '0' NOT NULL AFTER userid";
        $query[] = "UPDATE {$pp_db_prefix}settings SET title='Use CAPTCHA images when verifying unregistered users?' WHERE id=234";

        for ( $x=0; $x < count($query); $x++) {
            $iquery = $query[$x];
            $setup = mysql_query($iquery, $link);
            if ( !$setup ) print "Error performing MySQL command: $iquery<br><b>Error: ".mysql_error($link)."</b><br><br>";
        }

        // For each category, set the thumbnail to the first photo if no thumbnail is set
        $resulta = mysql_query("SELECT id FROM {$Globals['pp_db_prefix']}categories WHERE thumbnail=0");

        if ( $resulta )
        {
            while ( list( $cid ) = mysql_fetch_row($resulta) )
            {
                if ( $cid > 0 )
                {
                    $resultb = mysql_query("SELECT id FROM {$Globals['pp_db_prefix']}photos WHERE cat=$cid ORDER BY date ASC LIMIT 1");
                    list( $firsth ) = mysql_fetch_row($resultb);

                    if ( $firsth )
                    {
                        mysql_query("UPDATE {$pp_db_prefix}categories SET thumbnail=$firsth WHERE id=$cid", $link);
                    }
                }
            }
        }

        print "<br />Upgrade complete! You should continue to <a href=\"upgrade.php?upgrade=61\">next step</a>";
        print "</td></tr></table></td></tr></table>";
        exit;
    }
}


if ( $upgrade == "61" ) {
    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">
            This install script will upgrade your 6.1x to 6.2.  Only run this upgrade if you have the
            6.1x version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=61&amp;step=1\">Proceed to Upgrade --></a></div></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
        <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">PhotoPost Upgrade
        </font></td></tr>
        <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">";

    if ( $step == "1" ) {
        // Connecting, selecting database
        $skip_exheader = "yes";
        require "pp-inc.php";

        print $output;
        print "Preparing to update database...<p>";
        flush();

        $query = array();
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (84,'PhotoPost Version','pversion','','6.2',53,0);";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (240,'Enable Flash uploader?','flashupload','Selects flash uploader if user is registered and flash is installed. As a 3rd party plug-in, this option is not supported by PhotoPost support.','no',29,6)";

        $query[] = "ALTER TABLE {$pp_db_prefix}users ADD paypal VARCHAR(75) NOT NULL DEFAULT ''";
        $query[] = "INSERT INTO {$pp_db_prefix}admingroups VALUES (15, 'Payment Options');";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (241, 'Which Payment Processor do you want to use?', 'processor', 'currently paypal and authorize.net are supported', 'paypal', 3, 15)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (242, 'Authorize.Net Login ID', 'authorizeid', 'Your Login ID for Authorize.Net.', '', 4, 15)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (243, 'Authorize.Net Transaction Key', 'authorizekey', 'The transaction key as specified within the Security section of the Authorize.Net merchant account system.', '', 5, 15)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (244, 'MoneyBookers Email', 'mbemail', 'Please enter your MoneyBookers email, all references to the subscription service will use this email.', '', 6, 15)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (245, 'Moneybookers Secret Word', 'mbsecret', 'Secret Word in lowercase as typed into your Moneybookers Profile.', '', 7, 15)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (246, 'WorldPay Installation ID', 'wp_instid', 'The Install ID that is generated by the WorldPay CMS for the subscription callback.<br />You must set your callback url to point to your payment.php script', '', 8, 15)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (247, 'WorldPay Callback Password', 'wp_password', 'The password entered during the creation of the subscription callback within the WorldPay CMS.', '', 9, 15)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (248, 'Default Currency', 'currency', '', 'USD', 19, 1)";
	    $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (249,'Your PayPal email address for your account?', 'paypalemail', 'Required to receive payments!', '', 12, 15)";
	    $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (250,'PayPal currency code?', 'paypalcur', 'USD for US Dollar', 'USD', 13, 15)";

	    $query[] = "CREATE TABLE IF NOT EXISTS {$pp_db_prefix}subscriptions (id int(10) NOT NULL auto_increment,
	                name VARCHAR(75) NOT NULL default '',
	                description TEXT NULL DEFAULT NULL,
	                gid INT(4) NOT NULL default '0',
	                duration VARCHAR(75) NOT NULL default '',
	                days INT(4) NOT NULL default '0',
					price float(12,2) NOT NULL default '0.00',
					isactive varchar(3) NOT NULL default 'yes',
	                PRIMARY KEY (id)) TYPE=MyISAM ";

	    $query[] = "CREATE TABLE IF NOT EXISTS {$pp_db_prefix}paid_subscriptions (id int(10) NOT NULL auto_increment,
	                userid VARCHAR(75) NOT NULL default '',
	                start VARCHAR(250) NOT NULL default '',
	                end VARCHAR(75) NOT NULL default '',
	                days INT(4) NOT NULL default '0',
					subid INT(5) NOT NULL default '0',
	                gid INT(4) NOT NULL default '0',
	                oldid INT(4) NOT NULL default '0',
	                PRIMARY KEY (id)) TYPE=MyISAM ";

        $query[] = "CREATE TABLE IF NOT EXISTS {$pp_db_prefix}currency (id int(12) NOT NULL auto_increment,
                    name VARCHAR( 25 ) NOT NULL ,
                    code VARCHAR( 5 ) NOT NULL ,
     			    symbol VARCHAR(25) NOT NULL default '',
     			    type INT(3) NOT NULL default '0',
                    PRIMARY KEY (id)) TYPE=MyISAM ";

	    $query[] = "CREATE TABLE {$pp_db_prefix}payments (id int(12)  NOT NULL auto_increment,
	                amount float(12,2) NOT NULL default '0',
	                pmt_key VARCHAR(32) NOT NULL default '',
	                user_id INT(5) NOT NULL default '0',
	                sub_id INT(5) NOT NULL default '0',
	                PRIMARY KEY (id) ) TYPE=MyISAM ";

        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (1,'US Dollars','USD','&#36;', '0')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (2,'Britain Pounds','GBP','&#163;', '0')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (3,'Canadian Dollars','CAD','&#36;', '0')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (4,'Australian Dollars','AUD','&#36;', '0')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (5,'Brazil, Reais','BRL','&#82;&#36;', '0')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (7,'Costa Rica, Coln','CRC','&#8353;', '2')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (8,'Denmark Kroner','DKK','&#107;&#114;', '2')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (9,'Euro','EUR','&#8364;', '0')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (10,'Lira','ITL','&#8356;', '1')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (11,'Franc','FRF','&#8355;', '1')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (12,'Korea (South), Won','KRW','&#65510;', '3')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (13,'Japan, Yen','JPY','&#165;', '3')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (14,'South Africa, Rand','ZAR','&#82;', '0')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (15,'Indian, Rupees','INR','&#8360;', '2')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (16,'Thailand, Baht','THB','&#3647;', '0')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (17,'Laos, Kips','LAK','&#8365;', '3')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (18,'China, Yuan','CNY','&#20803;', '3')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (19,'Hong Kong, Dollars','HKD','HK$', '0')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (20,'Iran Rials','IRR','&#65020;', '2')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (21,'Israel, New Shekels','ILS','&#8362;', '2')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (22,'Mongolia, Tugriks','MNT','&#8366;', '2')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (23,'Netherlands Antilles, Guilders/Florins','ANG','&#402;', '2')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (24,'Nigeria, Nairas','NGN','&#8358;', '2')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (25,'Russia, Rubles','RUB','&#1088;&#1091;&#1073;', '2')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (26,'Taiwan, New Dollars','TWD','NT$', '0')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (27,'Vietnam, Dong','VND','&#8363;', '2')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (28,'Pesos','COP','&#8369;', '0')";
        $query[] = "INSERT INTO {$pp_db_prefix}currency VALUES (29,'Signapore Dollars','SGD','SGD&#36;', '0')";

        for ( $x=0; $x < count($query); $x++) {
            $iquery = $query[$x];
            $setup = mysql_query($iquery, $link);
            if ( !$setup ) print "Error performing MySQL command: $iquery<br><b>Error: ".mysql_error($link)."</b><br><br>";
        }

        print "<br />Upgrade complete! You should continue to <a href=\"upgrade.php?upgrade=62\">next step</a>";
        print "</td></tr></table></td></tr></table>";
        exit;
    }
}

if ( $upgrade == "62" ) {
    $output = "<html><head><title>PhotoPost Upgrade Script</title></head><body bgcolor=\"#000099\">";

    if (!isset($step)) {
        $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
            <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">Welcome to PhotoPost Upgrade
            </font></td></tr>
            <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">
            This install script will upgrade your 6.2x to 7.0.  Only run this upgrade if you have the
            6.2x version of the database in place (either by previous upgrades or if upgrading in order to the latest).<p>
            <div align=\"right\">
            <a href=\"upgrade.php?upgrade=62&amp;step=1\">Proceed to Upgrade --></a></div></td></tr></table></td></tr></table>";

        print $output;
        exit;
    }

    $output .= "<br /><br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" bgcolor=\"#C6DFF7\" width=\"650\" align=\"center\"><tr><td>
        <table cellpadding=\"4\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr><td colsize=\"6\" align=\"left\" bgcolor=\"#0059B5\"><font color=\"#ffffff\" size=\"4\" face=\"MS Sans Serif\">PhotoPost Upgrade
        </font></td></tr>
        <tr><td bgcolor=\"#FFFFFF\"><font size=\"2\" face=\"MS Sans Serif\" color=\"#000000\">";

    if ( $step == "1" ) {
        // Connecting, selecting database
        $skip_exheader = "yes";
        require "pp-inc.php";

        print $output;
        print "Preparing to update database...<p>";
        flush();

        $query = array();
        $query[] = "REPLACE INTO {$pp_db_prefix}settings VALUES (84, 'PhotoPost Version','pversion','','7.0',53,0);";
        $query[] = "DELETE FROM {$pp_db_prefix}settings WHERE id=236";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (251, 'Number of thumbnail preview columns?', 'previewcols', 'Can be 1 or 3.', '3', 33, 5)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (252, 'Border color of currently showing thumbnail in thumbnail preview column?', 'selectcolor', '', '#00cc00', 34, 5)";
        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (254, 'Path to ffmpeg (if used)', 'ffmpeg', 'This only needs to be set if you are using ffmpeg to extract video thumbnails. Full server path.', '/usr/bin/ffmpeg', 31, 1)";
        $query[] = "INSERT INTO {$pp_db_prefix}sort VALUES (9,'Votes', 'ORDER BY disporder,votes')";

        if ( $Globals['spider'] == "yes" )
        {
            $query[] = "UPDATE {$pp_db_prefix}settings SET setting='spider' WHERE id=133";
        }
        else
        {
            $query[] = "UPDATE {$pp_db_prefix}settings SET setting='none' WHERE id=133";
        }

        $query[] = "INSERT INTO {$pp_db_prefix}settings VALUES (253, 'SEO meta description for index page?', 'seoindex', '', 'A community photo gallery', 19, 3)";

        for ( $x=0; $x < count($query); $x++) {
            $iquery = $query[$x];
            $setup = mysql_query($iquery, $link);
            if ( !$setup ) print "Error performing MySQL command: $iquery<br><b>Error: ".mysql_error($link)."</b><br><br>";
        }

        print "<br />Upgrade complete! You need to remove the upgrade.php script for security reasons before continuing.";
        print "</td></tr></table></td></tr></table>";
        exit;
    }
}
?>