<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

define( 'THIS_SCRIPT', "slideshow" );
require "pp-inc.php";

// Force no spider-URLs
$Globals['spider'] = "none";

typecast($_REQUEST, array('photo' => INT, 'size' => STRING, 'cat' => STRING,
                          'nocache' => INT, 'sortby' => STRING, 'sortdir' => STRING, 'limit' => STRING,
                          'way' => STRING, 'sorttime' => INT, 'page' => INT, 'slideshow' => INT,
                          'slidedelay' => INT));
typecast($_COOKIE, array('catp' => STRING));

authenticate();

if ( $Globals['ppboards'] == "closed" && $User['adminedit'] != 1 )
{
    diewell( $Globals['closedmsg'] );
}

// Init some variables
if ( $size != "big" )
{
    $size = "medium";
}

topmenu();

if ( !isset($slidedelay) )
{
    printheader( $cat, "{$Globals['galleryname']} {$Globals['pp_lang']['slideshow']}" );

    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/slideshow.tmpl");
    printfooter();
    exit;
}

if ( empty($photo) )
{
    diewell( $Globals['pp_lang']['nophoto'] );
}

if ( ($User['username'] == "" || $User['username'] == $Globals['pp_lang']['unreg']) && $Globals['reqregister'] == "yes" )
{
    diewell( $Globals['pp_lang']['noreg'] );
}

$rows = ppmysql_query("SELECT id,user,userid,cat,storecat,date,title,description,keywords,bigimage,width,height,filesize,views,medwidth,medheight,medsize,approved,disporder FROM {$Globals['pp_db_prefix']}photos WHERE id=$photo", $link);
list( $id, $photouser, $iuserid, $dbcat, $storecat, $date, $title, $desc, $keywords, $bigimage, $width, $height, $filesize, $views, $medwidth, $medheight, $medsize, $approved, $issticky) = mysql_fetch_row($rows);
ppmysql_free_result( $rows );

if ( empty($id) )
{
    diewell( $Globals['pp_lang']['nophoto'] );
}

if ( $storecat == 0 )
{
    $storecat = $dbcat;
}

$thecatname = $CatPerms['catname'][$dbcat];
$cattheme = $CatPerms['catname'][$dbcat];

$resulta = ppmysql_query("SELECT theme,sortorder FROM {$Globals['pp_db_prefix']}categories where id=$dbcat", $link);
list( $cattheme, $sortorder ) = mysql_fetch_row($resulta);
ppmysql_free_result($resulta);

if ( $cattheme && $Globals['forumstyle'] == "no" )
{
    $Globals['theme'] = $cattheme;

    if ( is_dir( "{$Globals['PP_PATH']}/stylesheets/{$Globals['theme']}" ) )
    {
        $Globals['idir'] = "{$Globals['maindir']}/stylesheets/{$Globals['theme']}";
    }
}

is_cat_protected( $dbcat, $catp, $cattype );

//
// Next and Previous images for display
//
if ( !isset($sortby) && $sortorder > 0 && empty($limit) )
{
    $resultc = ppmysql_query("SELECT * FROM {$Globals['pp_db_prefix']}sort WHERE sortid=$sortorder", $link);
    list($sortid, $sortname, $sortcode) = mysql_fetch_row($resultc);
    ppmysql_free_result( $resultc );
}
elseif ( isset($sortby) )
{
    // Timeframe
    $searchq = null;
    if ( $sorttime > 0 ) {
        $searchdate = time() - ($sorttime * (24 * 3600));
        $searchq = "AND date > $searchdate";
    }

    // Sortname?
    if ( !empty($sortby) ) {
        if ( $sortby == "s" ) $sortvar = "filesize";
        elseif ( $sortby == "r" ) $sortvar = "rating";
        elseif ( $sortby == "l" ) $sortvar = "lastpost";
        elseif ( $sortby == "d" ) $sortvar = "date";
        elseif ( $sortby == "v" ) $sortvar = "views";
        else $sortvar = "bigimage";

        $sortdir = ( $way == "asc" ? "ASC" : "DESC" );
        $sortcode = "$searchq ORDER BY $sortvar $sortdir";
        if ( $sortby == "r" ) $sortcode = "$searchq AND rating > 0 $sortcode";
    }
}
else
{
    if ( !empty($limit) )
    {
        $sortcode = "ORDER BY date DESC";
    }
}

if ( $cat == "fav" )
{
    $query = "SELECT p.id,p.bigimage,p.cat,p.userid,p.approved,p.storecat,p.height,p.width FROM {$Globals['pp_db_prefix']}favorites f, {$Globals['pp_db_prefix']}photos p
        WHERE f.userid={$User['userid']} AND f.photo=p.id $sortcode";
}
elseif ( $cat == 500 )
{
    if ( $Globals['memformat'] == "yes" )
    {
        $query = "SELECT id,bigimage,cat,userid,approved,storecat,height,width FROM {$Globals['pp_db_prefix']}photos WHERE userid='$iuserid' AND approved=1 $sortcode";
    }
    else
    {
        $query = "SELECT id,bigimage,cat,userid,approved,storecat,height,width FROM {$Globals['pp_db_prefix']}photos WHERE cat=500 AND userid='$iuserid' AND approved=1 $sortcode";
    }
}
elseif ( $cat == MOBILE_CAT )
{
    $query = "SELECT id,bigimage,cat,userid,approved,storecat,height,width FROM {$Globals['pp_db_prefix']}photos WHERE cat='".MOBILE_CAT."' AND userid='$iuserid' AND approved=1 $sortcode";
}
elseif ( $cat == "recent" || $limit == "recent" )
{
    $query = "SELECT id,bigimage,cat,userid,approved,storecat,height,width FROM {$Globals['pp_db_prefix']}photos WHERE approved=1 ORDER BY date DESC";
}
elseif ( $cat == "views" || $limit == "views" )
{
    $query = "SELECT id,bigimage,cat,userid,approved,storecat,height,width FROM {$Globals['pp_db_prefix']}photos WHERE approved=1 ORDER BY views DESC";
}
elseif ( $cat == "all" || $limit == "all" )
{
    $query = "SELECT id,bigimage,cat,userid,approved,storecat,height,width FROM {$Globals['pp_db_prefix']}photos WHERE approved=1 $sortcode";
}
elseif ( $cat == "last1" || $cat == "last7" || $cat == "last14" )
{
    // Last 1 days
    if ( $limit == "last14" ) $days = 14;
    elseif ( $limit == "last7" ) $days = 7;
    else $days = 1;

    $searchdate = time() - ($days * (24 * 3600));

    $whichcat = ( is_numeric($cat) ? "AND cat=$cat" : "" );

    $query = "SELECT id,bigimage,cat,userid,approved,storecat,height,width FROM {$Globals['pp_db_prefix']}photos WHERE date > $searchdate AND approved=1 $whichcat ORDER BY date DESC";
}
else
{
    $query = "SELECT id,bigimage,cat,userid,approved,storecat,height,width FROM {$Globals['pp_db_prefix']}photos WHERE cat=$dbcat AND approved=1 $sortcode";
}

$rows = ppmysql_query($query, $link);
$grabnext = false;

while ( list($npid, $npbig, $npcat, $npuserid, $npapp, $npstore, $npheight, $npwidth) = mysql_fetch_array($rows) )
{
    if ( $npid == $photo )
    {
        $grabnext = true;
        continue;
    }

    if ( is_image_private($npcat) == "no" && $grabnext == true )
    {
        $next_image = $npid;
        break;
    }
}
ppmysql_free_result($rows);

if ( empty($slidedelay) )
{
    $slidedelay = 4;
}

if ( !isset($next_image) )
{
    $slideurl = construct_newppurl( "showphoto.php", array( 'photo' => $id, 'title' => $title, 'cat' => $cat) );
}
else
{
    $slideurl = "{$Globals['maindir']}/slideshow.php?photo=$next_image&amp;cat=$cat&amp;slideshow=1&amp;slidedelay=$slidedelay";
}

$slidestop = construct_newppurl( "showphoto.php", array( 'photo' => $id, 'title' => $title, 'cat' => $cat) );
$slidecode = "<a rel=\"nofollow\" href=\"$slidestop\">{$Globals['pp_lang']['stop']}</a> &middot; <span id=\"sspause\"><a href=\"javascript:stopslideshow();\">Pause</a></span><span id=\"ssresume\" style=\"display:none;\"><a href=\"$slideurl\">Resume</a></span>";

if ( VB3_ENHANCEDINT == "on" ) {
    $desc = un_htmlspecialchars(convert_markups($desc));
}
else
{
    $desc = convert_returns(convert_markups($desc));
}

if ( !empty($title) )
{
    printheader( $dbcat, " $title", $slideshow );
}
else
{
    printheader( $dbcat, " $bigimage", $slideshow );
}

$theext = get_ext($bigimage);
$filename = $bigimage;
$filename = str_replace( $theext, "", $filename);
$videodisp = null;
$imgurl = null;

if ( $Globals['bigsave'] == "yes" )
{
    if ( $medsize > 0 )
    {
        if ( $Globals['onthefly'] == "yes" )
        {
            $imgdisp = "<a href=\"$slidestop\"><img width=\"$medwidth\" height=\"$medheight\" src=\"{$Globals['maindir']}/watermark.php?file=$photo&size=1\" border=\"0\" alt=\"\" /></a>";
        }
        else
        {
            $imgdisp = "<a href=\"$slidestop\"><img width=\"$medwidth\" height=\"$medheight\" src=\"{$Globals['datadir']}/$storecat/medium/$bigimage$rand\" border=\"0\" alt=\"\" /></a>";
            $imgurl = "{$Globals['datadir']}/$storecat/medium/$bigimage";
        }
    }
    else
    {
        if ( is_multimedia($bigimage) == 1 )
        {
            $mmthumb = "{$Globals['datadir']}/$storecat/thumbs/$filename.jpg";
            $dirthumb = "{$Globals['datafull']}/$storecat/thumbs/$filename.jpg";

            if ( !file_exists($dirthumb) )
            {
                $mmthumb = "{$Globals['idir']}/video.gif";
            }

            $imgdisp = "<a href=\"{$Globals['origdir']}/$storecat/$bigimage\"><img src=\"$mmthumb$rand\" border=\"0\" alt=\"\" /></a>";
            $videodisp = "<span class=\"{$Style['small']}\">{$Globals['pp_lang']['video']}</span><br />";
        }
        else
        {
            if ( $filesize > 0 )
            {
                if ( $Globals['onthefly'] == "yes" )
                {
                    $imgdisp = "<img width=\"$width\" height=\"$height\" src=\"{$Globals['maindir']}/watermark.php?file=$photo\" border=\"0\" alt=\"$filename\" />";
                }
                else
                {
                    $imgsrc = "{$Globals['origdir']}/$storecat/$bigimage$rand";
                    $imgdisp = "<img width=\"$width\" height=\"$height\" src=\"$imgsrc\" border=\"0\" alt=\"$filename\" />";
                    $imgurl = "{$Globals['origdir']}/$storecat/$bigimage";
                }

                if ( $altlink )
                {
                    $imgdisp = "<a href=\"$slidestop\">$imgdisp</a>";
                }
            }
            else
            {
                $imgdisp = "<img src=\"{$Globals['datadir']}/$storecat/thumbs/$bigimage\" border=\"0\" alt=\"\" />";
            }
        }
    }
}
else
{
    $imgdisp = "<img src=\"{$Globals['datadir']}/$storecat/thumbs/$bigimage\" border=\"0\" alt=\"\" />";
}

if ( $Globals['ipcache'] != 0 )
{
    $ipaddress = findenv("REMOTE_ADDR");
    $result = ppmysql_query("SELECT userid,date,photo FROM {$Globals['pp_db_prefix']}ipcache WHERE ipaddr='$ipaddress' AND type='view' AND photo=$photo LIMIT 1", $link);
    $numfound = mysql_num_rows($result);

    if ( $numfound > 0 )
    {
        list( $tuserid, $lastdate, $photo ) = mysql_fetch_row($result);

        $mytime = time();
        $timeout = time() - ($Globals['ipcache'] * 3600);

        if ( $lastdate < $timeout )
        {
            if ( $Globals['viewcache'] == "yes" )
            {
                ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}photoviews SET photoid=$photo", $link);
            }
            else
            {
                ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET views=views+1 WHERE id=$photo", $link);
            }

            if ( $User['userid'] > 0 && $Globals['vbversion'] == "photopost" )
            {
                ppmysql_query("UPDATE {$Globals['pp_db_prefix']}users SET views=views+1 WHERE userid={$User['userid']}",$db_link);
            }

            ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}ipcache WHERE date < $timeout", $link);
            ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}ipcache (userid,ipaddr,date,type,photo) VALUES ('$tuserid', '$ipaddress', '$mytime', 'view', $photo)", $link);
        }
    }
    else
    {
        $mytime = time();

        ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}ipcache (userid,ipaddr,date,type,photo) VALUES ('$tuserid', '$ipaddress', '$mytime', 'view', $photo)", $link);

        if ( $Globals['viewcache'] == "yes" )
        {
            ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}photoviews SET photoid=$photo", $link);
        }
        else
        {
            ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET views=views+1 WHERE id=$photo", $link);
        }

        if ( $User['userid'] > 0 && $Globals['vbversion'] == "photopost" )
        {
            ppmysql_query("UPDATE {$Globals['pp_db_prefix']}users SET views=views+1 WHERE userid={$User['userid']}",$db_link);
        }
    }
}
else
{
    if ( $Globals['viewcache'] == "yes" )
    {
        ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}photoviews SET photoid=$photo", $link);
    }
    else
    {
        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET views=views+1 WHERE id=$photo", $link);
    }

    if ( $User['userid'] > 0 && $Globals['vbversion'] == "photopost" )
    {
        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}users SET views=views+1 WHERE userid={$User['userid']}", $link);
    }
}

include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/showslide.tmpl" );

if ( $Globals['slidehead'] == "yes" )
{
    printfooter();
}

?>