<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

define( 'THIS_SCRIPT', "showphoto" );
require "pp-inc.php";

$PATH_INFO = findenv("PATH_INFO");
if ( isset($PATH_INFO) && $Globals['spider'] != "none" )
{
    $id = 0;
    $test = explode('/', substr($PATH_INFO,1));

    for( $i = 0; $i < count($test); $i++ )
    {
        if( $i % 2 == 0 )
        {
            if ( $Globals['spider'] == "seo" )
            {
                if ( $test[$i] == "photo" )
                {
                    // Was "spider", but want an SEO, so do a 301 search engine friendly forward
                    // http://www.website.com/showphoto.php/photo/229
                    $id = (int)$test[$i+1];
                }
            }
            else
            {
                // Using "spider" URLs
                $_REQUEST[$test[$i]] = $test[$i+1];
            }
        }
    }

    if ( $Globals['spider'] == "seo" && strstr($PATH_INFO, "?") )
    {
        // Was "normal" URLs, but want an SEO, so do a 301 search engine friendly forward
        // http://www.website.com/showphoto.php?photo=229
        $id = (int)$_GET['photo'];
    }

    if ( $id > 0 )
    {
        $r = ppmysql_query_one("SELECT cat,title FROM {$Globals['pp_db_prefix']}photos WHERE id=$id", $link);

        header ('HTTP/1.1 301 Moved Permanently');
        header ('Location: '. construct_newppurl( "showphoto.php", array('photo' => $id, 'title' => $r['title'], 'cat' => $r['cat']) ) );
        exit;
    }
}

typecast($_REQUEST, array('photo' => INT, 'perpage' => INT, 'cpage' => INT, 'cat' => STRING, 'nocache' => INT,
                          'sortby' => STRING, 'sortdir' => STRING, 'limit' => STRING, 'way' => STRING,' sorttime' => INT,
                          'page' => INT, 'date' => INT, 'ppuser' => INT));
typecast($_COOKIE, array('catp' => STRING, 'poptions' => STRING));

// Init some variables
if ( $size != "big" ) $size = "medium";

if ( isset($_GET['catp']) )
{
    @setcookie( "catp", $_GET['catp'], 0, "{$Globals['cookie_path']}", $Globals['domain_path'] );
    $GLOBALS['catp'] = $_GET['catp'];
}
elseif ( isset($_POST['catp']) )
{
    @setcookie( "catp", $_POST['catp'], 0, "{$Globals['cookie_path']}", $Globals['domain_path'] );
    $GLOBALS['catp'] = $_POST['catp'];
}

if ( isset($perpage) && is_numeric($perpage) )
{
    if ( $perpage != $ppperpage )
    {
        @setcookie( "ppperpage", $perpage, 0, $Globals['cookie_path'], $Globals['domain_path'] );
        $page = 1;
    }
}

authenticate();

if ( $Globals['ppboards'] == "closed" && $User['adminedit'] != 1 )
{
    diewell( $Globals['closedmsg'] );
}

if ( !$photo )
{
    diewell( $Globals['pp_lang']['nophoto'] );
}

if ( ($User['username'] == "" || $User['username'] == $Globals['pp_lang']['unreg']) && $Globals['reqregister'] == "yes" )
{
    diewell( $Globals['pp_lang']['noregview'] );
}

if ( $perpage < 1 )
{
    $perpage = $Globals['defaultposts'];
}

$rows = ppmysql_query("SELECT id,user,userid,cat,storecat,storeid,date,title,description,ismature,keywords,bigimage,width,height,filesize,views,medwidth,medheight,medsize,approved,rating,extra1,extra2,extra3,extra4,extra5,extra6,disporder,ipaddress,allowprint,allowrate,allowcoms,tags,exifinfo FROM {$Globals['pp_db_prefix']}photos WHERE id=$photo", $link);
list( $id, $photouser, $iuserid, $dbcat, $storecat, $storeid, $pdate, $title, $desc, $ismature, $keywords, $bigimage, $width, $height, $photosize, $views, $medwidth, $medheight, $medsize, $approved, $imgrating, $extra1, $extra2, $extra3, $extra4, $extra5, $extra6, $issticky, $ipaddr, $allowprint, $allowrate, $allowcoms, $tags, $exifinfo ) = mysql_fetch_row($rows);
ppmysql_free_result( $rows );

if ( $photo != $id || !$dbcat )
{
    diewell( $Globals['pp_lang']['nophoto'] );
}

if ( $Globals['mature'] == "yes" && $ismature && !$User['mature'] )
{
    diewell( $Globals['pp_lang']['maturewarn'] );
}

if ( !$cat && $limit )
{
    $cat = $limit;
}

if ( !$cat )
{
    $cat = $dbcat;
}

$extra1 = convert_markups($extra1);
$extra2 = convert_markups($extra2);
$extra3 = convert_markups($extra3);
$extra4 = convert_markups($extra4);
$extra5 = convert_markups($extra5);
$extra6 = convert_markups($extra6);

list( $phuid, $phuhomep, $numposts, $phutitle, $phureg, $phuloc, $phuavatar, $phusig ) = get_profiledata( $iuserid );

$photouser = htmlspecialchars( $photouser );

if ( $phuavatar && $Globals['showavatar'] == "yes" )
{
    $phuavatar = htmlspecialchars( $photouser ) . "<br /><br />$phuavatar";
}
else
{
    $phuavatar = htmlspecialchars( $photouser );
}

if ( $phureg )
{
    $phureg = "<br /><br />{$Globals['pp_lang']['registered']}: " . formatppdate($phureg, "month yyyy");
}

if ( $numposts )
{
    $phuposts = "<br />{$Globals['pp_lang']['posts']}: ". number_format($numposts);
}

if ( $phuloc )
{
    $phuloc = "<br />{$Globals['pp_lang']['location']}: $phuloc";
}

if ( $phutitle )
{
    $phutitle = "<br />$phutitle";
}

if ( $storecat == 0 )
{
    $storecat = $dbcat;
}

if ( $allowrate == 0 && $Globals['allowrate'] == "yes" )
{
    // User doesn't want any ratings on their image
    $Globals['allowrate'] = "no";
}

if ( $allowcoms == 0 && $Globals['allowpost'] == "yes" )
{
    // User doesn't want any comments on their image
    $Globals['allowpost'] = "no";
}
elseif ( $allowcoms == 2 && $Globals['allowpost'] == "yes" )
{
    // Photo is "closed" for new topics
    $User['comments'] = 0;
}

$resulta = ppmysql_query("SELECT catname,cattype,theme,frames,sortorder,extra1,extra2,extra3,extra4,extra5,extra6,thumbnail,numextra,ratingtype,ugnopost,ugnovote FROM {$Globals['pp_db_prefix']}categories WHERE id=$dbcat", $link);
list( $thecatname, $cattype, $cattheme, $frames, $sortorder, $Globals['extra1name'], $Globals['extra2name'], $Globals['extra3name'], $Globals['extra4name'], $Globals['extra5name'], $Globals['extra6name'], $catthumb, $numextra, $ratingtype, $ugnopost, $ugnovote ) = mysql_fetch_row($resulta);
ppmysql_free_result($resulta);

// We need these here
$CatPerms['ugpost'][$dbcat] = $CatPerms['ugvote'][$dbcat] = 1;

foreach( $User['usergroups'] AS $usergroup )
{
    $allnopost = explode( ",", $ugnopost );
    if ( !in_array( $usergroup, $allnopost ) )
    {
        $CatPerms['ugpost'][$dbcat] = 0;
    }

    $allnovote = explode( ",", $ugnopost );
    if ( !in_array( $usergroup, $allnovote ) )
    {
        $CatPerms['ugvote'][$dbcat] = 0;
    }
}

if ( $cattheme && $Globals['forumstyle'] == "no" )
{
    $Globals['theme'] = $cattheme;

    if ( is_dir( "{$Globals['PP_PATH']}/stylesheets/{$Globals['theme']}" ) )
    {
        $Globals['idir'] = "{$Globals['maindir']}/stylesheets/{$Globals['theme']}";
    }
}

// Non standard frames
if ( !empty($frames) )
{
    unset( $Globals['thumbstd'] );
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/$frames.tmpl" );
}

is_cat_protected( $dbcat, $catp, $cattype );

// Need to grab any custom fields for this category
$numcustom = 0;
if ( $numextra > 0 )
{
        $catextras = ppmysql_query("SELECT e.id,e.fieldname,e.fieldtype,e.fieldoptions,p.selection FROM {$Globals['pp_db_prefix']}extrafields e
                   LEFT JOIN {$Globals['pp_db_prefix']}photoextras p ON (p.extraid=e.id AND p.photo=$id)
                   WHERE e.cat=$dbcat", $link);

        $customboxes = array();
        $numcustom = 0;

        while ( list( $exid, $exname, $extype, $exoptions, $extrasel ) = mysql_fetch_row($catextras) )
        {
            $extrase1 = un_htmlspecialchars( $extrase1 );

            if ( $extype == "c" )
            {
                // Checkboxes are different, because we display each of the selections indexed by number

                $exselection = null;
                $exselects = explode( "||", $exoptions );
                $exmysel = explode( ",", $extrasel );

                $y = 0;
                foreach( $exselects as $exextra )
                {
                    $checked = null;
                    if ( $extrasel != null && in_array($y, $exmysel) )
                    {
                        // This is one they selected
                        $checked = "checked=\"checked\"";
                    }

                    $exselection .= "<input type=\"checkbox\" name=\"dummy\" $checked disabled> $exextra<br />";
                    $y++;
                }

                $customboxes['title'][$numcustom] = $exname;
                $customboxes['value'][$numcustom] = $exselection;
            }
            else
            {
                // Everything else is only a one-item display
                $customboxes['title'][$numcustom] = $exname;
                $customboxes['value'][$numcustom] = $extrasel;
            }

            $numcustom++;
        }
        ppmysql_free_result( $catextras );
}

if ( $User['userid'] > 0 && $Globals['displaynew'] == "yes" )
{
    $resultb = ppmysql_query("REPLACE INTO {$Globals['pp_db_prefix']}laston VALUES('$dbcat',{$User['userid']},$lasttimeon)", $link);
}

if ( $Globals['nextbox'] == "yes" )
{
	  //
    // Next and Previous images for display
    //
    if ( !isset($sortby) && $sortorder > 0 && empty($limit) )
    {
        $resultc = ppmysql_query("SELECT * FROM {$Globals['pp_db_prefix']}sort WHERE sortid=$sortorder", $link);
        list($sortid, $sortname, $sortcode) = mysql_fetch_row($resultc);
        ppmysql_free_result( $resultc );
    }
    elseif ( isset($sortby) )
    {
        // Timeframe
        $searchq = null;
    
        if ( $sorttime > 0 )
        {
            $searchq = "AND date > ". time() - (($sorttime * 24) * 3600);
        }
    
        // Sortname?
        if ( !empty($sortby) )
        {
            if ( $sortby == "s" )
            {
                $sortvar = "filesize";
            }
	    elseif ( $sortby == "c" )
	    {
	        $sortvar = "votes";
	    }
            elseif ( $sortby == "r" )
            {
                $sortvar = "rating";
            }
            elseif ( $sortby == "l" )
            {
                $sortvar = "lastpost";
            }
            elseif ( $sortby == "d" )
            {
                $sortvar = "date";
            }
            elseif ( $sortby == "v" )
            {
                $sortvar = "views";
            }
            else
            {
                $sortvar = "bigimage";
            }
    
            $sortdir = ( $way == "asc" ? "ASC" : "DESC" );
            $sortcode = "$searchq ORDER BY $sortvar $sortdir";
    
            if ( $sortby == "r" )
            {
                $sortcode = "$searchq AND rating > 0 $sortcode";
            }
        }
    }
    else
    {
        if ( !empty($limit) )
        {
            $sortcode = "ORDER BY date DESC";
        }
    }
    
    if ( $cat == 500 )
    {
        if ( $Globals['memformat'] == "yes" )
        {
            $query = "SELECT id,cat,title,bigimage,userid,approved,storecat,height,width,ismature FROM {$Globals['pp_db_prefix']}photos WHERE userid='$iuserid' AND approved=1 $sortcode";
        }
        else
        {
            $query = "SELECT id,cat,title,bigimage,userid,approved,storecat,height,width,ismature FROM {$Globals['pp_db_prefix']}photos WHERE cat=500 AND userid='$iuserid' AND approved=1 $sortcode";
        }
    }
    elseif ( $cat == MOBILE_CAT || $dbcat == MOBILE_CAT )
    {
        $query = "SELECT id,cat,title,bigimage,userid,approved,storecat,height,width,ismature FROM {$Globals['pp_db_prefix']}photos WHERE cat='".MOBILE_CAT."' AND userid='$iuserid' AND approved=1 $sortcode";
    }
    elseif ( $cat == "recent" || $limit == "recent" )
    {
        $query = "SELECT id,cat,title,bigimage,userid,approved,storecat,height,width,ismature FROM {$Globals['pp_db_prefix']}photos WHERE approved=1 AND storecat=0 ORDER BY date DESC";
    }
    elseif ( $cat == "views" || $limit == "views" )
    {
        $query = "SELECT id,cat,title,bigimage,userid,approved,storecat,height,width,ismature FROM {$Globals['pp_db_prefix']}photos WHERE approved=1 AND storecat=0 ORDER BY views DESC";
    }
    elseif ( $cat == "all" || $limit == "all" )
    {
        $query = "SELECT id,cat,title,bigimage,userid,approved,storecat,height,width,ismature FROM {$Globals['pp_db_prefix']}photos WHERE approved=1 $sortcode";
    }
    elseif ( strstr($limit,"last") )
    {
        // Last xx days
        if ( $limit == "last14" )
        {
            $days = 14;
        }
        elseif ( $limit == "last7" )
        {
            $days = 7;
        }
        else
        {
            $days = 1;
        }
    
        $searchdate = time() - (($days * 24) * 3600);
        $whichcat = ( is_numeric($cat) ? "AND cat=$cat" : null );
    
        $query = "SELECT id,cat,title,bigimage,userid,approved,storecat,height,width,ismature FROM {$Globals['pp_db_prefix']}photos WHERE date > $searchdate AND approved=1 $whichcat ORDER BY date DESC";
    }
    elseif( !empty($date) )
    {
        $thisdate = getdate($date);
        $thismonth = $thisdate["mon"];
        $thisyear  = $thisdate["year"];
        $thisday   = $thisdate["mday"];
    
        $lowdate  = mktime(0, 0, 0, $thismonth, $thisday, $thisyear);
        $highdate = mktime(0, 0, 0, $thismonth, $thisday+1, $thisyear);
    
        $whichcat = ( is_numeric($cat) ? "AND cat=$cat" : "" );
        $query = "SELECT id,cat,title,bigimage,userid,approved,storecat,height,width,ismature FROM {$Globals['pp_db_prefix']}photos WHERE date >= $lowdate AND date < $highdate AND approved=1 $whichcat ORDER BY date DESC";
    }
    elseif ( $ppuser )
    {
        $query = "SELECT id,cat,title,bigimage,userid,approved,storecat,height,width,ismature FROM {$Globals['pp_db_prefix']}photos WHERE cat=$dbcat AND userid=$ppuser AND approved=1 $sortcode";
    }
    else
    {
        $query = "SELECT id,cat,title,bigimage,userid,approved,storecat,height,width,ismature FROM {$Globals['pp_db_prefix']}photos WHERE cat=$dbcat AND approved=1 $sortcode";
    }
    $rows = ppmysql_query($query, $link);
    
    $stripimgs = array();
    $lessphotos = $morephotos = false;
    
    if ( $Globals['previewcols'] == 1 )
    {
        $highf = 7;
        $lowf = 6;
        $middlef = 4;
        if ( $Globals['filmstrip'] == "top" || $Globals['filmstrip'] == "bottom" )
        {
            $splitf = 7;
        }
        else
        {
            $splitf = 1;
        }
        $previewwidth = $Globals['previewwidth'] + 10;
    }
    else
    {
        $highf = 21;
        $lowf = 20;
        $middlef = 11;
        if ( $Globals['filmstrip'] == "top" || $Globals['filmstrip'] == "bottom" )
        {
            $splitf = 7;
        }
        else
        {
            $splitf = 3;
        }
        $previewwidth = ($Globals['previewwidth'] + 3) * 3;
    }
    
    while ( $thisrec = mysql_fetch_row($rows) )
    {
        if ( $thisrec[9] == 1 && (!$User['userid'] || !$User['mature'] ) )
        {
            continue;
        }
    
        if ( is_image_private($thisrec[1]) == "no" )
        {
            if ( $thisrec[0] == $photo )
            {
                $stripimgs[] = $thisrec;
    
                // Grab more (if there)
                $exc = 0;
                while ( $nextrec = mysql_fetch_row($rows) )
                {
                    if ( $nextrec[9] == 1 && (!$User['userid'] || !$User['mature']) )
                    {
                        continue;
                    }
    
                    if ( is_image_private($nextrec[1]) == "no" )
                    {
                        $stripimgs[] = $nextrec;
    
                        if ( count($stripimgs) == $highf )
                        {
                            $morephotos = true;
                            break;
                        }
                    }
                }
                break;
            }
            else
            {
                $stripimgs[] = $thisrec;
    
                if ( count($stripimgs) == $middlef )
                {
                    array_shift($stripimgs);
                    $lessphotos = true;
                }
            }
        }
    }
    ppmysql_free_result($rows);
    
    $filmstrips = array_fill( 0, $highf, null );
    $nextlink = $prevlink = $slidecode = $nextajax = $prevajax = null;
    $init = 1;
    
    foreach( $stripimgs AS $ids => $strip )
    {
        if ( $strip[0] > 0 )
        {
            list($npid, $npcat, $xtitle, $npbig, $npuserid, $npapp, $npstore, $npheight, $npwidth, $ismature) = $strip;
    
            if ( !$npstore )
            {
                $npstore = $npcat;
            }
    
            $pimgtag = get_imagethumb( $npbig, $npstore, $npuserid, $npapp );
            $boxcolor = $Globals['framecolor'];
    
            if ( $ids == 0 && $lessphotos )
            {
                $prevajax = "&laquo; <a title=\"{$Globals['pp_lang']['morephotos']}\" href=\"javascript:sendPhotoReq('$npid','$cat','$photo','$limit','$sortby','$sortdir','$sorttime','$ppuser');\">{$Globals['pp_lang']['more']}</a>";
            }
            elseif ( $npid == $photo )
            {
                $previd = $ids - 1;
                $nextid = $ids + 1;
                list($pnpid,$pcat,$ptitle) = $stripimgs[$previd];
                list($nnpid,$ncat,$ntitle) = $stripimgs[$nextid];
    
                if ( $pnpid )
                {
                    $conurl = construct_newppurl( "showphoto.php", array('photo' => $pnpid, 'title' => $ptitle, 'cat' => $pcat) );
                    $prevlink = "&laquo; <a title=\"$ptitle\" href=\"$conurl\">{$Globals['pp_lang']['prev']}</a>";
                }
    
                if ( $nnpid )
                {
                    $conurl = construct_newppurl( "showphoto.php", array('photo' => $nnpid, 'title' => $ntitle, 'cat' => $ncat) );
                    $nextlink = " &middot; <a title=\"$ntitle\" href=\"$conurl\">{$Globals['pp_lang']['next']}</a> &raquo;";
                }
    
                $boxcolor = $Globals['selectcolor'];
            }
            elseif ( $ids == $lowf && $morephotos )
            {
                if ( $prevajax )
                {
                    $nextajax .= " &middot; ";
                }
    
                $nextajax .= "<a title=\"{$Globals['pp_lang']['morephotos']}\" href=\"javascript:sendPhotoReq('$npid','$cat','$photo','$limit','$sortby','$sortdir','$sorttime','$ppuser');\">{$Globals['pp_lang']['more']}</a> &raquo;";
            }
    
            $savecat = $cat;
            $cat = $npcat;
            $filmstrips[$ids] = get_thumbtmpl( $npid, $pimgtag, $npheight, $npwidth, $thumbtag, -1, null, $xtitle, $boxcolor );
            $cat = $savecat;
    
        }
        else
        {
            $filmstrips[$ids] = null;
        }
    }
    
    foreach ($filmstrips as $key => $value)
    {
        if (is_null($value))
        {
            unset($filmstrips[$key]);
        }
    }
    
    reset($filmstrips);
    
    // Let's get their preference
    if ( $Globals['filmstrip'] == "bottom" )
    {
        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/filmstrip-hor.tmpl" );
        $filmstrip = "<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><td nowrap=\"nowrap\">$prevajax</td><td>$filmstrip</td><td nowrap=\"nowrap\">$nextajax</td></tr></table>";
    }
    elseif ( $Globals['filmstrip'] == "left" )
    {
        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/filmstrip-ver.tmpl" );
        $filmstrip = "$prevajax$filmstrip$nextajax";
    }
    elseif ( $Globals['filmstrip'] == "right" )
    {
        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/filmstrip-ver.tmpl" );
        $filmstrip = "$prevajax$filmstrip$nextajax";
    }
    else
    {
        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/filmstrip-hor.tmpl" );
        $filmstrip = "<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><td nowrap=\"nowrap\">$prevajax</td><td>$filmstrip</td><td nowrap=\"nowrap\">$nextajax</td></tr></table>";
    }
    unset($stripimgs);
    // End to get Next and Previous images for display
}

if ( $nextlink && $Globals['slideshow'] == "yes" )
{
    $slideurl = "{$Globals['maindir']}/slideshow.php?photo=$photo";

    if ( !empty($limit) )
    {
        $slideurl .= "&amp;limit=$limit";
    }

    if ( !empty($cat) )
    {
        $slideurl .= "&amp;cat=$cat";
    }

    $slidecode = " &nbsp;&middot; <a rel=\"nofollow\" href=\"$slideurl\" title=\"{$Globals['pp_lang']['slideshow']}\">{$Globals['pp_lang']['slideshow']}</a>";
}

$exifdata = null;
if ( $exifinfo && $Globals['showexif'] == "yes" )
{
    $row = ppmysql_query("SELECT exifinfo FROM {$Globals['pp_db_prefix']}exif WHERE photoid=$photo", $link);
    if ( $row )
    {
        list( $exifinfo ) = mysql_fetch_row($row);
    }
    ppmysql_free_result( $row );

    $restexif = unserialize($exifinfo);

$exifdata = <<<EXIFINFO
    $ppopen
    <tr>
    <td class="{$Style['menubar']}" align="center" colspan="4">
        <span class="{$Style['small']}"><b>{$Globals['pp_lang']['exif']}</b></span>
    </td>
    </tr>
EXIFINFO;

    $col = 1;

    while( list($k,$v) = each($restexif) )
    {
        if ( !empty($v) )
        {
            if ( is_numeric($v) )
            {
                if ( strlen($v) == 10 )
                {
                    $v = formatppdate( $v );
                }
                else
                {
                    $v = number_format( $v );
                }
            }
            else
            {
                $v = htmlentities(strip_tags(trim($v)));
            }

            if ( $k == "IsColor" )
            {
                if ( $v == 1 ) {
                    $v = $Globals['pp_lang']['yes'];
                }
                else
                {
                    $v = $Globals['pp_lang']['no'];
                }
            }

            if ( $col == 1 )
            {
                $exifdata .= "<tr>";
            }

            $exifdata .= "<td class=\"{$Style['tddetails']}\" width=\"25%\" align=\"left\"><span class=\"{$Style['small']}\">$k:</span></td>
                <td class=\"{$Style['tddetails']}\" width=\"25%\" align=\"left\"><span class=\"{$Style['small']}\">$v</span></td>\n";

            if ( $col == 1 )
            {
                $col = 2;
            }
            else
            {
                $col = 1;
                $exifdata .= "</tr>";
            }
        }
    }

    if ( $col == 2 )
    {
        $exifdata .= "<td class=\"{$Style['tddetails']}\" width=\"25%\">&nbsp;</td><td class=\"{$Style['tddetails']}\" width=\"25%\">&nbsp;</td>";
    }

    $exifdata .= "$ppclose<br />";
}


// for childsub, we need to set these globals
$ppuser = $iuserid;
$uploadquery = "?cat=$dbcat";

if ( $width && $height )
{
    $sizecode = "$width x $height";
}
else
{
    $Globals['dispdims'] = "no";
}

$count    = 0;
$theext   = get_ext($bigimage);
$filename = $bigimage;
$filename = str_replace( $theext, "", $filename);
$altlink = null;

if ( $imgrating && $Globals['allowrate'] == "yes" )
{
    $rating = number_format( $imgrating, 2 );
    $ratingicon = null;

    for ( $x = 0; $x < round($rating); $x++ )
    {
        $ratingicon .= "<img src=\"{$Globals['idir']}/star.png\" alt=\"*\" />";
    }
}
else
{
    $rating = $Globals['pp_lang']['none'];
}

$extracat = null;
if ( $Globals['optcats'] == "yes" )
{
    // Additional categories?
    $result2 = ppmysql_query("SELECT p.id,p.title,p.cat,c.catname FROM {$Globals['pp_db_prefix']}photos p
               LEFT JOIN {$Globals['pp_db_prefix']}categories c ON c.id=p.cat
               WHERE p.storeid=$id OR p.id=$storeid", $link);

    while ( list( $exid, $ptitle, $pcatid, $excat ) = mysql_fetch_row($result2) )
    {
        if ( $exid != $photo )
        {
            $otherlink = "<a href=\"" . construct_newppurl( "showphoto.php", array( 'photo' => $exid, 'title' => $ptitle, 'cat' => $pcatid) ) ."\">$excat</a>";
            $extracat .= ( empty($extracat) ? "$otherlink" : ", $otherlink" );
        }
    }

    ppmysql_free_result( $result2 );
}

$rand = ( $nocache == 1 ? "?".rand(0,9999) : null );

if ( $approved != 0 || $User['moderator'] == 1 || $User['adminedit'] == 1 )
{
    $filesize = sprintf("%1.1f", ($photosize/1024))."{$Globals['pp_lang']['kb']}";
    $dispmed = 0;

    if ( $medsize > 0 )
    {
        $medsize = sprintf("%1.1f", ($medsize/1024))."{$Globals['pp_lang']['kb']}";

        if ( $Globals['bigpopup'] == "yes" )
        {
            if ( $Globals['lightbox'] == "yes" && ($width < $Globals['lbwidth'] || $height < $Globals['lbheight']) )
            {
                $useimglink = "<a rel=\"lightbox\" href=\"{$Globals['datadir']}/$storecat/$bigimage\">";
            }
            else
            {
                $useimglink = "<a href=\"javascript:;\" onclick=\"openBigWindow('{$Globals['maindir']}/showfull.php?photo=$photo','scrollbars=yes,toolbar=no,status=no,resizable=yes,width=$width,height=$height')\">";
            }
        }
        else
        {
            $useimagelink = construct_newppurl( "showphoto.php", array('photo' => $id, 'title' => $title, 'cat' => $dbcat) );
        }

        if ( $size != "big" )
        {
            $dispmed = 1;
            $altlink = "<br /><div align=\"center\"><span class=\"{$Style['small']}\">{$Globals['pp_lang']['viewlarger']}</span></div>";
        }
        else
        {
            $altlink = "<br /><div align=\"center\"><span class=\"{$Style['small']}\">{$Globals['pp_lang']['viewsmaller']}</span></div>";
        }

        $filesize = "$medsize, $filesize";
   }

    $videodisp = $imgurl = null;
    $seotitle = htmlspecialchars($bigimage);

    if ( !empty($title) )
    {
        $seotitle = htmlspecialchars($title);
    }

    if ($Globals['bigsave'] == "yes")
    {
        if ( $dispmed == 1 )
        {
            if ( $Globals['onthefly'] == "yes" )
            {
                if ( $Globals['zoom'] == "no" )
                {
                    $imgdisp = "$useimglink<img width=\"$medwidth\" height=\"$medheight\" src=\"{$Globals['maindir']}/watermark.php?file=$id&amp;size=1\" border=\"0\" alt=\"$seotitle\" /></a>";
                }
                else
                {
                    $imgdisp = "$useimglink<img width=\"$medwidth\" height=\"$medheight\" src=\"{$Globals['maindir']}/watermark.php?file=$id&amp;size=1\" border=\"0\" alt=\"$seotitle\" onmouseover=\"TJPzoom(this, '{$Globals['datadir']}/$storecat/$bigimage');\" /></a>";
                }
                $imgurl = "{$Globals['datadir']}/$storecat/medium/$bigimage";
            }
            else
            {
                if ( $Globals['zoom'] == "no" )
                {
                    $imgdisp = "$useimglink<img width=\"$medwidth\" height=\"$medheight\" src=\"{$Globals['datadir']}/$storecat/medium/$bigimage$rand\" border=\"0\" alt=\"$seotitle\" /></a>";
                }
                else
                {
                    $imgdisp = "$useimglink<img width=\"$medwidth\" height=\"$medheight\" src=\"{$Globals['datadir']}/$storecat/medium/$bigimage$rand\" border=\"0\" alt=\"$seotitle\" onmouseover=\"TJPzoom(this, '{$Globals['datadir']}/$storecat/$bigimage');\" /></a>";
                }

                $imgurl = "{$Globals['datadir']}/$storecat/medium/$bigimage";
            }
        }
        else
        {
            if ( is_multimedia($bigimage) == 1 )
            {
                $mmthumb = "{$Globals['datadir']}/$storecat/thumbs/$filename.jpg";
                $dirthumb = "{$Globals['datafull']}/$storecat/thumbs/$filename.jpg";
                $imgurl = "{$Globals['datadir']}/$storecat/$bigimage";

                if ( !file_exists($dirthumb) )
                {
                    $mmthumb = "{$Globals['idir']}/video.gif";
                }

                $imgdisp = "<a href=\"{$Globals['origdir']}/$storecat/$bigimage\"><img src=\"$mmthumb$rand\" border=\"0\" alt=\"$seotitle\" /></a>";
                $videodisp = "<span class=\"{$Style['small']}\">{$Globals['pp_lang']['video']}</span><br />";

                if ( $Globals['embededmm'] == "yes" )
                {
                    if ( stristr($bigimage, ".mov") )
                    {
                        $mmthumb = "{$Globals['idir']}/mm-qt.gif";
                        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/embed-qt.tmpl" );
                        $videodisp = null;
                    }
                    elseif ( stristr($bigimage, ".wmv") || stristr($bigimage, ".mpg") || stristr($bigimage, ".mpeg") || stristr($bigimage, ".avi") )
                    {
                        $mmthumb = "{$Globals['idir']}/video.gif";
                        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/embed-ms.tmpl" );
                    }
                    elseif( stristr($bigimage, ".fla") || stristr($bigimage, ".swf") )
                    {
                        $mmthumb = "{$Globals['idir']}/mm-fla.gif";
                        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/embed-fla.tmpl" );
                    }
                    elseif( stristr($bigimage, ".mp3") || stristr($bigimage, ".wav") || stristr($bigimage, ".mid") || stristr($bigimage, ".aiff") )
                    {
                        $mmthumb = "{$Globals['idir']}/mm-audio.gif";
                        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/embed-audio.tmpl" );
                    }
                    elseif( stristr($bigimage, ".rm") )
                    {
                        $mmthumb = "{$Globals['idir']}/mm-rm.gif";
                        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/embed-rm.tmpl" );
                    }
                }
            }
            else
            {
                if ( $Globals['onthefly'] == "yes" )
                {
                    $imgdisp = "<img width=\"$width\" height=\"$height\" src=\"{$Globals['maindir']}/watermark.php?file=$id\" border=\"0\" alt=\"$seotitle\" />";
                    $imgurl = "{$Globals['origdir']}/$storecat/$bigimage";
                }
                else
                {
                    $imgsrc = "{$Globals['origdir']}/$storecat/$bigimage$rand";
                    $imgdisp = "<img width=\"$width\" height=\"$height\" src=\"$imgsrc\" border=\"0\" alt=\"$filename\" />";
                    $imgurl = "{$Globals['origdir']}/$storecat/$bigimage";
                }

                if ( $altlink )
                {
                    $imgdisp = "<a href=\"" . construct_newnewppurl( "showphoto.php", array('photo' => $photo, 'title' => $title) ) . "\">$imgdisp</a>";
                }
            }
        }
    }
    else
    {
        $imgdisp = "<img src=\"{$Globals['datadir']}/$storecat/thumbs/$bigimage\" border=\"0\" alt=\"$seotitle\" />";
    }
}
else
{
    $imgdisp = "<img width=\"100\" height=\"75\" src=\"{$Globals['idir']}/ipending.gif\" border=\"0\" alt=\"$seotitle\" />";
}

$userip = null;

$ratedisplay = null;
$rateperms = ( $cattype == "a" ? $CatPerms['ugvote'][500] : $CatPerms['ugvote'][$dbcat] );

if ( $Globals['allowrate'] == "yes" && $rateperms == 0 && $ratingtype != 1 )
{
    $alreadyrated = 0;
    if ( $User['userid'] > 0 )
    {
        $resultb = ppmysql_query("SELECT rating FROM {$Globals['pp_db_prefix']}comments WHERE photo=$photo AND userid={$User['userid']} AND rating > 0 LIMIT 1", $link);

        while( list( $checkrating ) = mysql_fetch_row($resultb) )
        {
            $alreadyrated = 1;
            $ratedisplay = "<span class=\"{$Style['small']}\">{$Globals['pp_lang']['rated']}$checkrating</span>";
        }
        ppmysql_free_result($resultb);
    }
    else
    {
        // Let's check their IP address for unregistered
        $ipaddress = findenv("REMOTE_ADDR");
        $result = ppmysql_query("SELECT rating FROM {$Globals['pp_db_prefix']}comments WHERE photo=$photo AND ipaddress='$ipaddress' AND rating > 0 LIMIT 1", $link);
        $numfound = mysql_num_rows($result);

        if ( $numfound > 0 )
        {
            $ratedisplay = "{$Globals['pp_lang']['unregrated']}";
            $alreadyrated = 1;
        }
    }

    if ( $alreadyrated == 0 )
    {
        if ( $User['userid'] != $iuserid )
        {
            include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/quickrate.tmpl" );
        }
    }
}

$ppdate = formatppdate( $pdate );

if ( VB3_ENHANCEDINT == "on" )
{
    $desc = un_htmlspecialchars(convert_markups($desc));
}
else
{
    $desc = convert_returns(convert_markups($desc));
}

$pmenuitem = array();
$vbppmenu = null;
$vb4ppmenu = null;

if ( $User['userid'] > 0 )
{
    $resultf = ppmysql_query("SELECT id FROM {$Globals['pp_db_prefix']}favorites WHERE photo=$id AND userid={$User['userid']}", $link);
    $isfav = mysql_num_rows($resultf);

    if ( $isfav == 0 )
    {
        $menuitem = "<span id=\"favorite\"><a title=\"{$Globals['pp_lang']['addfavorite']}\" href=\"javascript://\" onclick=\"sendInfoReq('addfav','$id');\">{$Globals['pp_lang']['addfav']}</a></span>";
    }
    else
    {
        $menuitem = "<span id=\"favorite\"><a title=\"{$Globals['pp_lang']['delfavorite']}\" href=\"javascript://\" onclick=\"sendInfoReq('delfav','$id');\">{$Globals['pp_lang']['delfav']}</a></span>";

    }

    $pmenuitem[] = $menuitem;
    $vbppmenu = "<tr><td class=\"vbmenu_option\">$menuitem</td></tr>";
    $vb4ppmenu = "<li>$menuitem</li>\n";
}

if ( ($Globals['allowpost'] == "yes" && $User['comments'] == 1) && $CatPerms['ugpost'][$dbcat] == 0 )
{
    $newid = 0;
    if ( $User['userid'] < 1 )
    {
        if ( $Globals['usecaptcha'] == "yes" )
        {
            // Let's generate a totally random string using md5
            $md5 = md5(rand(0,999));

            // We don't need a 32 character long string so we trim it down to 5
            $pass = substr($md5, 10, 5);

            $r = ppmysql_query( "INSERT INTO {$Globals['pp_db_prefix']}captcha (id,code) VALUES (NULL,'$pass')", $link );
            $newid = mysql_insert_id($link);

            if ( !$newid )
            {
                diewell( $Globals['pp_lang']['caperror'] );
            }
        }
    }

    if ( $Globals['imgmenu'] == "yes" )
    {
        $buttonlink = "<img src=\"{$Globals['idir']}/note_add.png\" alt=\"{$Globals['pp_lang']['post']}\" border=\"0\" />";
    }
    else
    {
        $buttonlink = $Globals['pp_lang']['post'];
    }

    $menuitem = "<a title=\"{$Globals['pp_lang']['post']}\" href=\"{$Globals['maindir']}/comments.php?photo=$id\">$buttonlink</a>";
    $pmenuitem[] = $menuitem;
    $vbppmenu .= "<tr><td class=\"vbmenu_option\">$menuitem</td></tr>";
    $vb4ppmenu .= "<li>$menuitem</li>\n";
}

if ( $User['userid'] > 0 )
{
    if ( $Globals['imgmenu'] == "yes" )
    {
        $buttonlink = "<img src=\"{$Globals['idir']}/exclamation.png\" alt=\"{$Globals['pp_lang']['reportphoto']}\" border=\"0\" />";
    }
    else
    {
        $buttonlink = $Globals['pp_lang']['reportphoto'];
    }

    $menuitem = "<a title=\"{$Globals['pp_lang']['reportphoto']}\" href=\"{$Globals['maindir']}/misc.php?action=reportphoto&amp;report=$id\">$buttonlink</a>";
    $pmenuitem[] = $menuitem;
    $vbppmenu .= "<tr><td class=\"vbmenu_option\">$menuitem</td></tr>";
    $vb4ppmenu .= "<li>$menuitem</li>\n";
}

if ( $Globals['enablecard'] == "yes" && ($Globals['cardreg'] == "no" || $User['userid'] > 0) )
{
    if ( $Globals['imgmenu'] == "yes" )
    {
        $buttonlink = "<img src=\"{$Globals['idir']}/email_go.png\" alt=\"{$Globals['pp_lang']['sendecard']}\" border=\"0\" />";
    }
    else
    {
        $buttonlink = $Globals['pp_lang']['sendecard'];
    }

    $menuitem = "<a title=\"{$Globals['pp_lang']['sendecard']}\" href=\"{$Globals['maindir']}/ecard.php?ecard=$id\">$buttonlink</a>";
    $pmenuitem[] = $menuitem;
    $vbppmenu .= "<tr><td class=\"vbmenu_option\">$menuitem</td></tr>";
    $vb4ppmenu .= "<li>$menuitem</li>\n";
}

if ( $Globals['usenotify'] == "yes" && $User['userid'] > 0 )
{
    $results = ppmysql_query("SELECT id FROM {$Globals['pp_db_prefix']}notify WHERE userid={$User['userid']} AND photo=$photo LIMIT 1", $link);
    list( $notifyid ) = mysql_fetch_row($results);
    ppmysql_free_result($results);


    if ( $notifyid )
    {
        if ( $Globals['imgmenu'] == "yes" )
        {
            $buttonlink = "<img src=\"{$Globals['idir']}/email_delete.png\" alt=\"{$Globals['pp_lang']['disbale']}\" border=\"0\" />";
        }
        else
        {
            $buttonlink = $Globals['pp_lang']['disable'];
        }

        $menuitem = "<span id=\"notify\"><a title=\"{$Globals['pp_lang']['notifytitle']}\" href=\"javascript:sendInfoReq('nonotify','$id');\">$buttonlink</a></span>";
        $pmenuitem[] = $menuitem;
        $vbppmenu .= "<tr><td class=\"vbmenu_option\">$menuitem</td></tr>";
        $vb4ppmenu .= "<li>$menuitem</li>\n";
    }
    else
    {
        if ( $Globals['imgmenu'] == "yes" )
        {
            $buttonlink = "<img src=\"{$Globals['idir']}/email_add.png\" alt=\"{$Globals['pp_lang']['enable']}\" border=\"0\" />";
        }
        else
        {
            $buttonlink = $Globals['pp_lang']['enable'];
        }

        $menuitem = "<span id=\"notify\"><a title=\"{$Globals['pp_lang']['enable']}\" title=\"{$Globals['pp_lang']['unnotifytitle']}\" href=\"javascript:sendInfoReq('notify','$id');\">$buttonlink</a></span>";
        $pmenuitem[] = $menuitem;
        $vbppmenu .= "<tr><td class=\"vbmenu_option\">$menuitem</td></tr>";
        $vb4ppmenu .= "<li>$menuitem</li>\n";
    }
}

if ( is_image($bigimage) )
{
    if ( $Globals['imgmenu'] == "yes" )
    {
        $buttonlink = "<img src=\"{$Globals['idir']}/printer.png\" alt=\"{$Globals['pp_lang']['printview']}\" border=\"0\" />";
    }
    else
    {
        $buttonlink = $Globals['pp_lang']['printview'];
    }

    $menuitem = "<a title=\"{$Globals['pp_lang']['printview']}\" href=\"javascript:;\" onclick=\"openBigWindow('{$Globals['maindir']}/showfull.php?photo=$photo','scrollbars=yes,toolbar=yes,status=no,resizable=yes,width=$width,height=$height')\">$buttonlink</a>";
    $pmenuitem[] = $menuitem;
    $vbppmenu .= "<tr><td class=\"vbmenu_option\">$menuitem</td></tr>";
    $vb4ppmenu .= "<li>$menuitem</li>\n";
}

if ( $exifinfo )
{
    if ( $Globals['imgmenu'] == "yes" )
    {
        $buttonlink = "<img src=\"{$Globals['idir']}/camera.png\" alt=\"{$Globals['pp_lang']['showexif']}\" border=\"0\" />";
    }
    else
    {
        $buttonlink = $Globals['pp_lang']['showexif'];
    }

    $menuitem = "<a title=\"{$Globals['pp_lang']['exiftitle']}\" href=\"javascript:sendInfoReq('exif','$photo');\">$buttonlink</a>";
    $pmenuitem[] = $menuitem;
    $vbppmenu .= "<tr><td class=\"vbmenu_option\">$menuitem</td></tr>";
    $vb4ppmenu .= "<li>$menuitem</li>\n";
}

$userip = null;
if ( $User['adminedit'] == 1  || $User['moderator'] == 1 || ($User['userid'] == $iuserid && $ueditpho == 1) )
{
    if ( !isset($ismod) )
    {
        $ismod = ( $User['adminedit'] == 1 ? true : false );

        if ( $User['moderator'] == 1 )
        {
            $ismod = is_moderator($dbcat);
        }
    }

    if ( $ismod || ($User['userid'] == $iuserid && $ueditpho == 1) )
    {
        $vbppmenu .= "<tr><td class=\"thead\">{$Globals['pp_lang']['adminopts']}</td></tr>";

        $menuitem = "<a title=\"{$Globals['pp_lang']['editphoto']}\" href=\"{$Globals['maindir']}/editphoto.php?phoedit=$id\">{$Globals['pp_lang']['editphoto']}</a>";
        $pmenuitem[] = $menuitem;
        $vbppmenu .= "<tr><td class=\"vbmenu_option\">$menuitem</td></tr>";
        $vb4ppmenu .= "<li>$menuitem</li>\n";

        if ( $Globals['allowpost'] == "yes" && $CatPerms['ugpost'][$dbcat] == 0 )
        {
            if ( $allowcoms == 1 )
            {
                $menuitem = "<span id=\"close\"><a title=\"{$Globals['pp_lang']['ocomtitle']}\" href=\"javascript:sendInfoReq('close','$id');\">{$Globals['pp_lang']['closecoms']}</a></span>";
                $pmenuitem[] = $menuitem;
                $vbppmenu .= "<tr><td class=\"vbmenu_option\">$menuitem</td></tr>";
   	        $vb4ppmenu .= "<li>$menuitem</li>\n";
            }
            else
            {
                $menuitem = "<span id=\"close\"><a title=\"{$Globals['pp_lang']['ccomtitle']}\" href=\"javascript:sendInfoReq('open','$id');\">{$Globals['pp_lang']['opencoms']}</a></span>";
                $pmenuitem[] = $menuitem;
                $vbppmenu .= "<tr><td class=\"vbmenu_option\">$menuitem</td></tr>";
   	        $vb4ppmenu .= "<li>$menuitem</li>\n";
            }
        }
    }

    if ( $ismod || $User['adminedit'] == 1 )
    {
        $userip = " <i>$ipaddr</i>";
    }

    if ( $User['adminedit'] == 1 )
    {
        if ( $approved == 0 )
        {
            $menuitem = " &nbsp; <span id=\"approve\"><a title=\"{$Globals['pp_lang']['aphototitle']}\" href=\"javascript:sendInfoReq('approve','$id');\">{$Globals['pp_lang']['approve']}</a>";
            $pmenuitem[] = $menuitem;
            $vbppmenu .= "<tr><td class=\"vbmenu_option\">$menuitem</td></tr>";
            $vb4ppmenu .= "<li>$menuitem</li>\n";
        }
        elseif ( $approved == 2 )
        {
            $menuitem = "<span id=\"hide\"><a title=\"{$Globals['pp_lang']['rphototitle']}\" href=\"javascript:sendInfoReq('unhide','$id');\">{$Globals['pp_lang']['unhide']}</a>";
            $pmenuitem[] = $menuitem;
            $vbppmenu .= "<tr><td class=\"vbmenu_option\">$menuitem</td></tr>";
            $vb4ppmenu .= "<li>$menuitem</li>\n";
        }
        else
        {
            $menuitem = "<span id=\"hide\"><a title=\"{$Globals['pp_lang']['hphototitle']}\" href=\"javascript:sendInfoReq('hide','$id');\">{$Globals['pp_lang']['hide']}</a>";
            $pmenuitem[] = $menuitem;
            $vbppmenu .= "<tr><td class=\"vbmenu_option\">$menuitem</td></tr>";
            $vb4ppmenu .= "<li>$menuitem</li>\n";
        }

        $menuitem = "<a title=\"{$Globals['pp_lang']['adminopts']}\" href=\"javascript:sendInfoReq('photoadmin','$photo');\">{$Globals['pp_lang']['movedel']}</a>";
        $pmenuitem[] = $menuitem;
        $vbppmenu .= "<tr><td class=\"vbmenu_option\">$menuitem</td></tr>";
        $vb4ppmenu .= "<li>$menuitem</li>\n";

        if ( $cattype == "a" )
        {
            if ( $photo == $catthumb )
            {
                $menuitem = "<a title=\"{$Globals['pp_lang']['removealbum']}\" href=\"{$Globals['maindir']}/editphoto.php?uncat=$dbcat&amp;phoedit=$id\">{$Globals['pp_lang']['removealbum']}</a>";
                $pmenuitem[] = $menuitem;
                $vbppmenu .= "<tr><td class=\"vbmenu_option\">$menuitem</td></tr>";
                $vb4ppmenu .= "<li>$menuitem</li>\n";
            }
            else
            {
                $menuitem = "<a title=\"{$Globals['pp_lang']['makethumb']}\" href=\"{$Globals['maindir']}/editphoto.php?makecat=$dbcat&amp;phoedit=$id\">{$Globals['pp_lang']['makethumb']}</a>";
                $pmenuitem[] = $menuitem;
                $vbppmenu .= "<tr><td class=\"vbmenu_option\">$menuitem</td></tr>";
                $vb4ppmenu .= "<li>$menuitem</li>\n";
            }
        }


        if ( $issticky == 99999 )
        {
            $menuitem = "<span id=\"stick\"><a title=\"{$Globals['pp_lang']['sphototitle']}\" href=\"javascript:sendInfoReq('stick','$id');\">{$Globals['pp_lang']['stick']}</a>";
            $pmenuitem[] = $menuitem;
            $vbppmenu .= "<tr><td class=\"vbmenu_option\">$menuitem</td></tr>";
            $vb4ppmenu .= "<li>$menuitem</li>\n";
        }
        else
        {
            $menuitem = "<span id=\"stick\"><a title=\"{$Globals['pp_lang']['uphototitle']}\" href=\"javascript:sendInfoReq('unstick','$id');\">{$Globals['pp_lang']['unstick']}</a>";
            $pmenuitem[] = $menuitem;
            $vbppmenu .= "<tr><td class=\"vbmenu_option\">$menuitem</td></tr>";
            $vb4ppmenu .= "<li>$menuitem</li>\n";
        }

        if ( $cattype == "c" )
        {
            if ( $photo == $catthumb )
            {
                $menuitem = "<a title=\"{$Globals['pp_lang']['removeindex']}\" href=\"{$Globals['maindir']}/editphoto.php?uncat=$dbcat&amp;phoedit=$id\">{$Globals['pp_lang']['removeindex']}</a>";
                $pmenuitem[] = $menuitem;
                $vbppmenu .= "<tr><td class=\"vbmenu_option\">$menuitem</td></tr>";
                $vb4ppmenu .= "<li>$menuitem</li>\n";
            }
            else
            {
                $menuitem = "<a title=\"{$Globals['pp_lang']['makeindex']}\" href=\"{$Globals['maindir']}/editphoto.php?makecat=$dbcat&amp;phoedit=$id\">{$Globals['pp_lang']['makeindex']}</a>";
                $pmenuitem[] = $menuitem;
                $vbppmenu .= "<tr><td class=\"vbmenu_option\">$menuitem</td></tr>";
                $vb4ppmenu .= "<li>$menuitem</li>\n";
            }
        }
    }
}

// Now format the menu
$rowcount = round(count($pmenuitem) / 3);

if ( $rowcount )
{
$pmenu = <<<PPPRINT
<table cellpadding="3" cellspacing="0" border="0" width="100%" align="center">
<tr><td>
PPPRINT;

    foreach( $pmenuitem AS $x => $menuitem)
    {
        if ( $x % $rowcount == 0 && $rowcount > 0 )
        {
            $pmenu .= "</td><td class=\"{$Style['tddetails']}\" align=\"center\" width=\"33%\">";
        }

        $pmenu .= "$menuitem<br />";
    }

    $pmenu .= "</td></tr></table>";
}

// find similiar posts
if ( empty($keywords) )
{
    $keywords = $title;
}

$keylinks = null;
$keys = explode( " ", $keywords );
$keys = array_unique($keys);

foreach( $keys as $si )
{
    $si = un_htmlspecialchars($si);

    $ignorew = array( "the", "a", "but", "are", "and" );

    if ( $si && !in_array($si, $ignorew) )
    {
        $keylinks .= "<a rel=\"nofollow\" href=\"{$Globals['maindir']}/search.php?keywords=$si\">$si</a> ";
    }
}

if ( $Globals['allowpost'] == "yes" )
{
    $cc = $ckcolor = 0;
    $posts = null;
    $comq = "<br />";

    if ( $Globals['dispempty'] == "yes" )
    {
        $query = "SELECT id,username,userid,date,rating,comment,approved,ipaddress FROM {$Globals['pp_db_prefix']}comments WHERE photo=$photo ORDER BY date ASC";
    }
    else
    {
        $query = "SELECT id,username,userid,date,rating,comment,approved,ipaddress FROM {$Globals['pp_db_prefix']}comments WHERE photo=$photo AND LENGTH(comment) > 0 ORDER BY date ASC";
    }

    $rows = ppmysql_query($query, $link);
    $comcount = mysql_num_rows($rows);

    if ( $comcount == 0 )
    {
        $compages = 0;
    }
    else
    {
        if ( $perpage > 0 )
        {
            $compages = ($comcount/$perpage);
        }
        else
        {
            $perpage = $Globals['defaultposts'];
            $compages = ($comcount/$perpage);
        }
    }

    if (intval($compages) < $compages)
    {
        $compages = intval($compages)+1;
    }
    else
    {
        $compages = intval($compages);
    }

    if ( isset($cpage) )
    {
        $cstartnumb=($cpage*$perpage)-$perpage+1;
    }
    else
    {
        $cpage = 1;
        $cstartnumb = 1;
    }

    if ($Globals['vbversion'] == 'dcfplus')
    {
        // need some admin preferences from DCF+, but don't want to call for them inside
        // the loop, since they incur a sql query.
        $allow_disable_email = dcfp_auth_get_setup_param("allow_disable_email");
        $allow_disable_inbox = dcfp_auth_get_setup_param("allow_disable_inbox");
        $allow_disable_profile = dcfp_auth_get_setup_param("allow_disable_profile");
    }

    $itemnum = 0;

    while ( list( $id, $cuser, $cuserid, $cdate, $crating, $commenttextline, $approved, $comip ) = mysql_fetch_row($rows) )
    {
        if ( ($crating > 0 && $ratingtype != 1) && $Globals['allowrate'] == "yes" )
        {
            $ratingdisp[$itemnum] = "{$Globals['pp_lang']['rating']}:&nbsp;<b>$crating</b>&nbsp;";
        }
        else
        {
            $ratingdisp[$itemnum] = null;
        }

        if ( ($Globals['dispempty'] == "no" && trim($commenttextline) == "") || ($Globals['moderatecoms'] == "no" && $approved == 0) )
        {
            // Do not print anything under these condition; placeholder
        }
        else
        {
            $cc++;

            if ($cc >= $cstartnumb)
            {
                if ($cc < ($cstartnumb+$perpage))
                {
                    $profilelink = get_profilelink( $cuserid, $cuser );

                    $imgtime[$itemnum] = formatpptime( $cdate );
                    $imgdate[$itemnum] = formatppdate( $cdate );

                    $commentnum[$itemnum] = $id;
                    $cowner[$itemnum] = $cuserid;

                    $ucuser[$itemnum] = $Globals['pp_lang']['unreg'];
                    $uclocation[$itemnum] = $uctitle[$itemnum] = $ucposts[$itemnum] = null;
                    $uregdate[$itemnum] = $uugallery[$itemnum] = $uisonline[$itemnum] = $uhpage[$itemnum] = null;
                    $ucedit[$itemnum] = false;

                    // call get_profiledata to get all the links possible
                    unset($postline);
                    list( $cuname, $cuhomep, $cuposts, $cutitle, $cureg, $culoc, $cuavatar, $usig ) = get_profiledata( $cuserid );

                    if ( $cureg )
                    {
                        $uregdate[$itemnum] = "<br /><br />{$Globals['pp_lang']['registered']}: " . formatppdate($cureg, "month yyyy");
                    }

                    if ( $cuposts )
                    {
                        $ucposts[$itemnum] = "<br />{$Globals['pp_lang']['posts']}: ". number_format($cuposts);
                    }

                    if ( $culoc )
                    {
                        $uclocation[$itemnum] = "<br />{$Globals['pp_lang']['location']}: $culoc";
                    }

                    if ( $cutitle )
                    {
                        $uctitle[$itemnum] = "<br />$cutitle";
                    }

                    if ( ($User['adminedit'] == 1  || $User['moderator'] == 1) && $comip )
                    {
                        $uctitle[$itemnum] .= "<br /><i>$comip</i>";
                    }

                    $uugallery[$itemnum] = $ugallery;
                    $uisonline[$itemnum] = $isonline;
                    $uhpage[$itemnum] = $cuhomep;

                    if ( $cuavatar && $Globals['showavatar'] == "yes" )
                    {
                        $cuname .= "<br />$cuavatar";
                    }

                    $ucuser[$itemnum] = $cuname;

                    if ( $cuserid > 0 )
                    {
                        $upostline[$itemnum] = $postline;
                    }

                    if ( $ckcolor == 1 )
                    {
                        $fillcolor[$itemnum] = "{$Style['tdbackground']}";
                        $ckcolor = 0;
                    }
                    else
                    {
                        $fillcolor[$itemnum] = "{$Style['tddetails']}";
                        $ckcolor = 1;
                    }

                    $commenttextline = un_htmlspecialchars($commenttextline);

                    if ( VB3_ENHANCEDINT == "on" )
                    {
                        $commenttextline = convert_markups($commenttextline);
                    }
                    else
                    {
                        $commenttextline = convert_returns(convert_markups($commenttextline));
                    }

                    $commenttext[$itemnum] = $commenttextline;

                    if ( $usig && $Globals['showsigs'] == "yes" )
                    {
                        $usigline = convert_markups($usig);
                        $usigline = un_htmlspecialchars($usigline);
                        $commenttext[$itemnum] .= "<br /><br />------------------------------<br />$usigline";
                    }

                    if ( ($User['userid'] == $cowner[$itemnum] && $ueditposts == 1) || $ismod )
                    {
                        if ( $Globals['comtimeout'] > 0 && !$ismod )
                        {
                            $julian = time();
                            $timediff = $julian - $cdate;

                            if ( $timediff < $Globals['comtimeout'] )
                            {
                                $ucedit[$itemnum] = true;
                            }
                        }
                        else
                        {
                            $ucedit[$itemnum] = true;
                        }
                    }

                    $itemnum++;
                }
            }
        }
    }
    ppmysql_free_result( $rows );

    if ( ($Globals['allowpost'] == "yes" && $User['comments'] == 1) && $CatPerms['ugpost'][$dbcat] == 0 )
    {
        if ( $ratingtype != 1 )
        {
            $ratecode .= get_rate_code(0);
        }

        if ( VB40 == "on" && VB3_ENHANCEDINT == "on" )
        {
            include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/quickcom40.tmpl" );
        }
        elseif ( SIMPLE_VERSION > 366 && VB40 == "off" && VB3_ENHANCEDINT == "on" )
        {
            include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/quickcom367.tmpl" );
        }
        else
        {
            include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/quickcom.tmpl" );
        }
    }
}

// begin pages/nav system ##
$comnav = null;

if ( $compages > 1 )
{
    $comnav .= "<table cellpadding=\"5\" cellspacing=\"0\" border=\"0\" align=\"center\" width=\"{$Globals['tablewidth']}\">
        <tr><td class=\"{$Style['tddetails']}\" width=\"40%\">&nbsp;</td>
        <td class=\"{$Style['tddetails']}\"><b>{$Globals['pp_lang']['page']}:&nbsp;</b> ";

    $thestart = null;

    if ( $cpage < 11 )
    {
        $thestart = 1;
    }

    if ( $cpage > 10 )
    {
        $thestart = ($cpage / 10);
        $thestart = (int)$thestart;
        $thestart = ($thestart * 10);
    }
    $theend = $thestart + 9;

    for ( $p = $thestart; $p <= $compages; $p++ )
    {
        if ($p != $thestart)
        {
            $comnav .= " &middot; ";
        }

        if ( $cpage != $p )
        {
            if ( $p == ($theend+1) )
            {
                $thispage = "$p >";
            }
            else
            {
                $thispage = "$p";
            }

            $conurl = construct_newppurl( "showphoto.php", array('photo' => $photo, 'cpage' => $p, 'title' => $title, 'cat' => $cat) );
            $comnav .= "<a href=\"$conurl\">$thispage</a>";
        }

        if ( $p > $theend )
        {
            break;
        }

        if ( $cpage == $p )
        {
            $comnav .= "<b>$p</b>";
        }
    }

    if ( $cpage < $compages )
    {
        $nextpage = $cpage + 1;

        $conurl = construct_newppurl( "showphoto.php", array('photo' => $photo, 'cpage' => $nextpage, 'title' => $title, 'cat' => $cat) );
        $more = "<a href=\"$conurl\"><img height=\"16\" width=\"63\" alt=\"{$Globals['pp_lang']['more']}\" border=\"0\" src=\"{$Globals['idir']}/more.gif\" /></a>";
    }
    else
    {
        $more = "&nbsp";
    }

    $comnav .= "</td><td class=\"{$Style['tddetails']}\" width=\"20%\" align=\"center\">$more</td></tr></table>";
}
// end pages/nav ###

if ( $Globals['ipcache'] != 0 )
{
    $ipaddress = findenv("REMOTE_ADDR");
    $result = ppmysql_query("SELECT userid,date,photo FROM {$Globals['pp_db_prefix']}ipcache WHERE ipaddr='$ipaddress' AND type='view' AND photo=$photo LIMIT 1", $link);
    $numfound = mysql_num_rows($result);

    $mytime = time();

    if ( $numfound > 0 )
    {
        list( $tuserid, $lastdate, $photo ) = mysql_fetch_row($result);

        if ( $lastdate < $timeout )
        {
            inc_photoviews( $photo );

            if ( $User['userid'] > 0 && $Globals['vbversion'] == "photopost" )
            {
                ppmysql_query("UPDATE {$Globals['pp_db_prefix']}users SET views=views+1 WHERE userid={$User['userid']}", $db_link);
            }

            $timeout = time() - ($Globals['ipcache'] * 3600);
            ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}ipcache WHERE date < $timeout", $link);
            ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}ipcache (userid,ipaddr,date,type,photo) VALUES ('$tuserid', '$ipaddress', '$mytime', 'view', $photo)", $link);
        }
    }
    else
    {
        ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}ipcache (userid,ipaddr,date,type,photo) VALUES ('$tuserid', '$ipaddress', '$mytime', 'view', $photo)", $link);

        inc_photoviews( $photo );

        if ( $User['userid'] > 0 && $Globals['vbversion'] == "photopost" )
        {
            ppmysql_query("UPDATE {$Globals['pp_db_prefix']}users SET views=views+1 WHERE userid={$User['userid']}",$db_link);
        }
    }
}
else {
    inc_photoviews( $photo );

    if ( $User['userid'] > 0 && $Globals['vbversion'] == "photopost" )
    {
        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}users SET views=views+1 WHERE userid={$User['userid']}", $link);
    }
}

if ( $Globals['sidebar_global'] == "yes" )
 {
    if ( $Globals['statspal'] == "yes" )
    {
        get_statscache();
    }

    if ( $Globals['topposterspal'] == "yes" )
    {
        get_posterscache();
    }

    if ( $Globals['ratingspal'] == "yes" )
    {
        get_ratingcache();
    }
}

$metadesc = $desc;
$metadesc = strip_tags(htmlspecialchars($metadesc));
$metakey = $keywords;

if ( !empty($title) )
{
    printheader( $dbcat, $title, "", "yes", $bigimage );
}
else
{
    printheader( $dbcat, $bigimage, "", "yes" , $bigimage );
}

topmenu();

childsub($dbcat, $cattype);
$childnav = "<a href=\"{$Globals['maindir']}/\">{$Globals['pp_lang']['home']}</a> $childnav";

// Make the display codes (just in case)
if ( is_multimedia($bigimage) )
{
    $showbbcode = "[media]{$imgurl}[/media]";
}
else
{
    $showbbcode = "[img]{$imgurl}[/img]";
}

if ( is_image($bigimage) )
{
$showhtmlcode = "&lt;img src=&quot;$imgurl&quot; /&gt;";

}
$showdirectcode = "$imgurl";

$phulink = construct_newppurl( "showgallery.php", array('ppuser' => $iuserid, 'username' => $photouser ) );
$phumemlink = construct_newppurl( "member.php", array('uid' => $iuserid, 'username' => $photouser) );
$views = number_format($views);

if ( is_multimedia($bigimage) == 1 )
{
    $showbbthumb = "[url=". construct_newppurl( "showphoto.php", array( 'photo' => $photo, 'title' => $title, 'cat' => $storecat ) ) ."][img]{$mmthumb}[/img][/url]";
}
else
{
    $showbbthumb = "[url=". construct_newppurl( "showphoto.php", array( 'photo' => $photo, 'title' => $title, 'cat' => $storecat ) ) ."][img]{$Globals['datadir']}/{$storecat}/thumbs/{$bigimage}[/img][/url]";
}
$showbbmed = "[url=". construct_newppurl( "showphoto.php", array( 'photo' => $photo, 'title' => $title, 'cat' => $storecat ) ) ."][img]{$Globals['datadir']}/{$storecat}/medium/{$bigimage}[/img][/url]";

if ( is_multimedia($bigimage) == 1 )
{
    $showbbfull = "[media]{$Globals['datadir']}/{$storecat}/{$bigimage}[/media]";
}
else
{
    $showbbfull = "[img]{$Globals['datadir']}/{$storecat}/{$bigimage}[/img]";
}

$filmstrip_top = $filmstrip_bottom = $filmstrip_left = $filmstrip_right = null;
$colspan1 = 5;
$colspan2 = 5;

if ( $Globals['nextbox'] == "yes" )
{
    // Let's get their preference
    if ( $Globals['filmstrip'] == "bottom" )
    {
        $filmstrip_bottom = "<tr><td class=\"{$Style['tddetails']}\" valign=\"top\" align=\"center\" width=\"100%\" colspan=\"$colspan2\" id=\"filmstrip\">$filmstrip</td></tr>";
    }
    elseif ( $Globals['filmstrip'] == "left" )
    {
        $filmstrip_left = "<td class=\"{$Style['tddetails']}\" valign=\"top\" align=\"center\" width=\"420\" id=\"filmstrip\">$filmstrip</td>";
        $colspan1 = 2;
        $colspan2 = 1;
    }
    elseif ( $Globals['filmstrip'] == "right" )
    {
        $filmstrip_right = "<td class=\"{$Style['tddetails']}\" valign=\"top\" align=\"center\" width=\"150\" id=\"filmstrip\">$filmstrip</td>";
        $colspan1 = 2;
        $colspan2 = 1;
    }
    else
    {
        $filmstrip_top = "<tr><td class=\"{$Style['tddetails']}\" valign=\"top\" align=\"center\" width=\"100%\" colspan=\"$colspan2\" id=\"filmstrip\">$filmstrip</td></tr>";
    }
}

// Start printing the page..
include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );

if ( $Globals['sidebar'] == "left" && $Globals['sidebar_global'] == "yes" )
{
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/sidebar_leftopen.tmpl" );
}

if ( $Globals['sidebar'] == "right" && $Globals['sidebar_global'] == "yes" )
{
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/sidebar_rightopen.tmpl" );
}

if ( VB3_ENHANCEDINT == "on" )
{
    $stylepath = ( $stylevar[imgdir_button][0] == "/" || $stylevar[imgdir_button][0] == "h" ? "" : "{$Globals['vbulletin']}/" );
}

include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/showphoto.tmpl" );

if ( $Globals['sidebar'] == "left" && $Globals['sidebar_global'] == "yes" )
{
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/sidebar_leftclose.tmpl" );
}

if ( $Globals['sidebar'] == "right" && $Globals['sidebar_global'] == "yes" )
{
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/sidebar_rightclose.tmpl" );
}

printfooter();

?>
