<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

define( 'THIS_SCRIPT', "showmembers" );
require "pp-inc.php";

$PATH_INFO = findenv("PATH_INFO");
if ( isset($PATH_INFO) && $Globals['spider'] != "none" )
{
    $test = explode('/', substr($PATH_INFO,1));

    for($i = 0; $i < count($test); $i++)
    {
        if( $i % 2 == 0 )
        {
                // Using "spider" URLs
                $_REQUEST[$test[$i]] = $test[$i+1];
        }
    }
}

typecast($_REQUEST, array('si' => STRING, 'sl' => STRING, 'name' => STRING, 'ppuser' => INT, 'cat' => INT,
                          'limit' => STRING, 'catp' => STRING,'page' => INT,'perpage' => INT,'sort' => INT, 'page' => INT));

// Set cookies first
if ( $perpage || $sort || $sl )
{
    // perpage, sortby, sorttime, way, thumbsonly, sort, sl
    if ( !$perpage ) $perpage = 12;
    $setcookie = serialize( array( $perpage, $sortby, $sorttime, $way, $thumbsonly, $sort, $sl ) );
    @setcookie( "ppperpage", $setcookie, 0, $Globals['cookie_path'], $Globals['domain_path'] );
}
else
{
    // perpage, sortby, sorttime, way, thumbsonly
    typecast($_COOKIE, array('ppperpage' => STRING));
    if ( $ppperpage )
    {
        list( $perpage, $sortby, $sorttime, $way, $thumbsonly, $sort, $sl ) = unserialize( un_htmlspecialchars($ppperpage) );
    }
}
// Init some variables
if ( !isset($cat) ) $cat = 500;

if ( $_GET['limit'] == "all" )
{
    setcookie("ppperpage","", time() - 3600, $Globals['cookie_path'], $Globals['domain_path'] );
    $sl = "";
}

authenticate();

if ( $Globals['ppboards'] == "closed" && $User['adminedit'] != 1 )
{
    diewell( $Globals['closedmsg'] );
}

if ( is_numeric($cat) )
{
    $ctitleq = ppmysql_query("SELECT catname,thumbs,cattype,parent,theme,sortorder,frames,intro,introtitle,introcopy,ratingtype,takevotes
              FROM {$Globals['pp_db_prefix']}categories WHERE id=$cat", $link);

    if ( !$ctitleq )
    {
        diewell( $Globals['pp_lang']['noview'] );
    }

    list( $thecatname, $catthumbs, $cattype, $catparent, $cattheme, $catsortorder, $frames, $hasintro, $introtitle, $introcopy, $ratingtype, $takevotes ) = mysql_fetch_row($ctitleq);
    ppmysql_free_result( $ctitleq );

    if ( !preg_match("/([\<])([^\>]{1,})*([\>])/i", $introtitle) )
    {
        $introtitle = preg_replace("/(\r\n|\r|\n)/i","<br />",$introtitle);
    }

    if ( !preg_match("/([\<])([^\>]{1,})*([\>])/i", $introcopy) )
    {
        $introcopy = preg_replace("/(\r\n|\r|\n)/i","<br />",$introcopy);
    }

    if ( $cattype == "a" )
    {
        $titlereplace = "$tusername's {$Globals['pp_lang']['persalbum']}";
        $catthumbs = "yes";
    }

    // Nonstandard theme
    if ( !empty($cattheme) )
    {
        $Globals['theme'] = $cattheme;
        if ( is_dir( "{$Globals['PP_PATH']}/stylesheets/{$Globals['theme']}" ) )
        {
            $Globals['idir'] = "{$Globals['maindir']}/stylesheets/{$Globals['theme']}";
        }
    }

    // Non standard frames
    if ( !empty($frames) )
    {
        unset( $Globals['thumbstd'] );
        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/$frames.tmpl" );
    }

    is_cat_protected( $cat, $catp, $cattype );

    if ( $User['userid'] > 0 && $Globals['displaynew'] == "yes" )
    {
        $lasttimeon = time();
        $resultb = ppmysql_query("REPLACE INTO {$Globals['pp_db_prefix']}laston VALUES('$cat','{$User['userid']}','$lasttimeon')", $link);
    }
}

$perpage1x = $Globals['thumbcols'];
$perpage3x = ($perpage1x * 3);
$perpage4x = ($perpage1x * 4);
$perpage5x = ($perpage1x * 5);
$perpage6x = ($perpage1x * 6);

if ( $perpage )
{
    if ( $perpage > 90 ) {
        $perpage = 90;
    }

    if ($perpage < $perpage1x) {
        $perpage = $perpage1x;
    }
}
else
{
    if ( isset($ppperpage) )
    {
        $perpage = $ppperpage;
    }
    else
    {
        $perpage = ($Globals['thumbcols'] * $Globals['thumbrows']);
    }
}

if ( isset($page) && $page > 0 )
{
    $startnumb = ($page*$perpage)-$perpage+1;
}
else
{
    $page = 1;
    $startnumb = 1;
}

// do the sort box //
$sortoptions = null;
$sortdefault="";

// This is the default sort (4 = Alphabetical)
if ( empty($sort) )
{
    $sortparam = ( isset($catsortorder) && $catsortorder > 0 ? $catsortorder : 4 );
}
else
{
    $sortparam = ( isset($sort) && $sort > 0 ? $sort : 4 );
}

$resultc = ppmysql_query("SELECT * FROM {$Globals['pp_db_prefix']}sortmemb", $link);

while ( list($sortid, $sortname, $sortc) = mysql_fetch_row($resultc) )
{
    if ( $sortparam != $sortid )
    {
        $sortoptions .= "<option value =\"$sortid\">$sortname</option>";
    }
    else
    {
        $sortdefault = "<option selected=\"selected\" value=\"$sortid\">$sortname</option>";
        $sortcode = "$sortc";
    }

    if ( $sortdefault == "" )
    {
        $sortdefault = "<option selected=\"selected\">{$Globals['pp_lang']['newest']}</option>";
    }
}
ppmysql_free_result( $resultc );

$sort = "<select onchange=\"submit();\" name=\"sort\" style=\"font-size: 9pt;\">$sortdefault$sortoptions</select>";
// end sort box //

$datecheck = null;
if ( !empty($limit) )
{
    if ( $limit == "all" )
    {
        $thecatname = $Globals['pp_lang']['callimages'];
        $days = 0;
    }
    elseif ( $limit == "last1" )
    {
        $thecatname = $Globals['pp_lang']['clastday'];
        $days = 1;
    }
    elseif ( $limit == "last7" )
    {
        $thecatname = $Globals['pp_lang']['clast7'];
        $days = 7;
    }
    elseif ( $limit == "last14" )
    {
        $thecatname = $Globals['pp_lang']['clast14'];
        $days = 14;
    }

    if ( $days > 0 )
    {
        $timeq = time() - (($days * 24) * 3600);
        $datecheck = " p.date > $timeq ";
    }
}
elseif ( !empty($date) )
{
    $thisdate = getdate($date);
    $thismonth = $thisdate['mon'];
    $thisyear  = $thisdate['year'];
    $thisday   = $thisdate['mday'];

    $lowdate  = mktime(0, 0, 0, $thismonth, $thisday, $thisyear);
    $highdate = mktime(0, 0, 0, $thismonth, $thisday+1, $thisyear);

    $datecheck = " p.date >= $lowdate AND p.date < $highdate";
}

printheader( $cat, $thecatname );

childsub($cat);
$childnav = "<a href=\"{$Globals['maindir']}/\">{$Globals['pp_lang']['home']}</a> $childnav";

topmenu();

if ( $Globals['features'] == "yes" && $ppuser )
{
    if ( $Globals['mostrecent'] == "yes" && $Globals['recentdefault'] == "no" )
    {
        display_gallery("latest", $ppuser);
    }

    list( $tuserid, $tname, $tmail ) = get_userinfo( "", $ppuser);
}
elseif ( $Globals['features'] == "yes" && ($Globals['mostrecent'] == "yes" && $Globals['recentdefault'] == "no") )
{
    display_gallery("latest", "", $cat);
}

// If we're not in the member gallery cat, then print thumbs..
// Otherwise, print a list of users.
$phrase = null;

if ( !empty($si) )
{
    $sterms = trim($si);
    $searchterms = explode(" ", $sterms);
    $htmlsi = htmlspecialchars($si);

    $scount=0;
    $totalterms = count($searchterms);
    $totalterms++;

    foreach ( $searchterms as $key )
    {
        $scount++;
        if ($scount > 1)
        {
            $phrase .= " AND ";
        }

        $phrase .= "(p.user LIKE '%$key%')";
    }

    if ( $phrase )
    {
        $phrase = "WHERE $phrase";
    }
}

if ( $datecheck && $phrase )
{
    $phrase .= " AND $datecheck";
}
elseif ( !$phrase && $datecheck )
{
    $phrase = "WHERE $datecheck";
}

if ( isset($sl) && !empty($sl) )
{
    if ( empty($phrase) )
    {
        $phrase = "WHERE p.user LIKE '$sl%'";
    }
    else
    {
        $phrase .= " AND p.user LIKE '$sl%'";
    }
}

if ( is_numeric($cat) && $cat != 500 )
{
    if ( empty($phrase) )
    {
        $phrase .= "WHERE ";
    }
    else
    {
        $phrase .= "AND ";
    }

    $phrase .= "p.cat=$cat";
}
elseif ( is_numeric($cat) && $cat == 500 )
{
    if ( empty($phrase) )
    {
        $phrase .= "WHERE ";
    }
    else
    {
        $phrase .= "AND ";
    }

    $phrase .= "p.approved=1";
}

if ( $Globals['membthumb'] == "yes" && $cat == 500 )
{
    $queryz = ppmysql_query("SELECT p.id, p.date, p.user, p.userid, SUM(p.views) AS tviews, COUNT(*) AS pcount, SUM(p.numcom) as numcom,
                                MAX(p.lastpost) AS maxlast, MAX(p.date) AS maxdate, SUM(p.filesize) AS tfilesize,
                                u.lastphoto, u.lastdate,
                                p2.bigimage, p2.cat, p2.storecat, p2.height, p2.width, p2.ismature
                              FROM {$Globals['pp_db_prefix']}photos p
                              LEFT JOIN {$Globals['pp_db_prefix']}users u ON (u.userid=p.userid)
                              LEFT JOIN {$Globals['pp_db_prefix']}photos p2 ON (p2.id=u.lastphoto)
                              $phrase
                              GROUP BY p.userid $sortcode", $link);
}
else
{
    $queryz = ppmysql_query("SELECT p.id, p.date, p.user, p.userid, SUM(p.views) AS tviews, COUNT(*) AS pcount, SUM(p.numcom) as numcom,
                                MAX(p.lastpost) AS maxlast, MAX(p.date) AS maxdate, SUM(p.filesize) AS tfilesize
                              FROM {$Globals['pp_db_prefix']}photos p
                              $phrase
                              GROUP BY p.userid $sortcode", $link);
}

$rowcnt = mysql_num_rows($queryz);

if ( $posternav )
{
    $posternav = "<br />$posternav<br />";
}

$noresults = null;
if ( $rowcnt == 0 )
{
    $noresults = "<div align=\"center\"><br />{$Globals['pp_lang']['nousers']}<br /><br /></div></font>";
}

$uout = null;
$cc = $count = $cntresults = $itemcnt = 0;
$numcols = $Globals['thumbcols'];
$pwidth = intval(100/($numcols));
$filesize = $gallery = array();

$mcheck = true;
if ( $Globals['mature'] == "yes" )
{
    $mcheck = false;

    if ( $User['userid'] )
    {
        $mcheck = $User['mature'];
    }
}

while ( $memrec = mysql_fetch_array($queryz) )
{
    $cc++;
    if ( $cc >= $startnumb )
    {
        if ( $cc < ($startnumb+$perpage) )
        {
            if ($Globals['membthumb'] == "yes")
            {
                if ( $cat == 500 )
                {
                    $photorec = &$memrec;
                }
                else
                {
                    $pquery = ppmysql_query("SELECT id, bigimage, cat, storecat, ismature, height, width FROM {$Globals['pp_db_prefix']}photos WHERE approved=1 AND userid={$memrec['userid']} AND cat=$cat ORDER BY date DESC LIMIT 1", $link);
                    $photorec = mysql_fetch_array($pquery);
                }

                if ( $photorec['storecat'] != 0 )
                {
                    $photorec['cat'] = $photorec['storecat'];
                }

                $is_private = is_image_private( $photorec['cat'] );

                if ( $is_private == "yes" || ($mcheck && $photorec['ismature'] == 1) )
                {
                    $photorec['bigimage'] = null;
                    $gallery['thumbrc'][$itemcnt] = "<img border=\"0\" src=\"{$Globals['idir']}/nothumb.gif\" alt=\"\" /><br />";
                    $gallery['thumbtag'][$itemcnt] = "{$Globals['idir']}/nothumb.gif";
                }

                if ( !empty($photorec['bigimage']) )
                {
                    $thumbrc = get_imagethumb( $photorec['bigimage'], $photorec['cat'], $memrec['userid'], 1 );
                    $gallery['thumbrc'][$itemcnt] = $thumbrc;
                    $gallery['thumbtag'][$itemcnt] = $thumbtag;
                    $gallery['cat'][$itemcnt] = $photorec['cat'];
                    $gallery['thumbnail'][$itemcnt] = get_thumbtmpl( $photorec['id'], $thumbrc, $photorec['height'], $photorec['width'], $thumbtag, $cat );
                    $gallery['plink'][$itemcnt] = "<a href=\"". construct_newppurl( "showgallery.php", array('cat' => $cat, 'ppuser' => $memrec['userid']) ) ."\">";
                    $imgheight[$itemcnt] = $photorec['height'];
                    $imgwidth[$itemcnt] = $photorec['width'];
                }

                if ($memrec['userid'] > 0 )
                {
                    $memlink[$itemcnt] = "<a href=\"". construct_newppurl( "member.php", array('uid' => $memrec['userid'], 'username' => $memrec['user']) ) ."\">{$memrec['user']}</a>";
                }
                else
                {
                    $memlink[$itemcnt] = "{$memrec['user']}";
                }
            }
            else
            {
                $gallery['thumbrc'][$itemcnt] = null;
                $gallery['thumbtag'][$itemcnt] = null;
                $gallery['plink'][$itemcnt]    = null;
                $gallery['cat'][$itemcnt] = $memrec['cat'];
                $gallery['thumbnail'][$itemcnt] = null;

                $memlink[$itemcnt] = "<a href=\"". construct_newppurl( "showgallery.php", array('cat' => $cat, 'ppuser' => $memrec['userid']) ) ."\">{$memrec['user']}</a>";
            }

            if ( !empty($gallery['thumbrc'][$itemcnt]) || (empty($gallery['thumbrc'][$itemcnt]) && $Globals['membthumb'] == "no") )
            {
                $comcount[$itemcnt] = number_format( $memrec['numcom'] );

                $cclock = formatpptime( $memrec['maxdate'] );
                $ppdate = formatppdate( $memrec['maxdate'] );

                $lpprint[$itemcnt] .= "$ppdate $cclock";
                $views[$itemcnt] = $memrec['tviews'];
                $uphotos[$itemcnt] = $memrec['pcount'];
                $puser[$itemcnt] = $memrec['user'];
                $puserid[$itemcnt] = $memrec['userid'];

                $memrec['tfilesize'] = $memrec['tfilesize']/1024;
                $pfilesize = sprintf("%1.1f", $memrec['tfilesize']);
                $filesize[$itemcnt] = $pfilesize."k";

                $itemcnt++;
            }
            else
            {
                // usually means a person with no approved images, so we dont display them
                $cc--;
                $rowcnt--;
            }
        }
    }
}
ppmysql_free_result( $queryz );

pagesystem($rowcnt, "showmembers");

if ( $Globals['sidebar_global'] == "yes" )
{
    if ( $Globals['statspal'] == "yes" )
    {
        get_statscache();
    }

    if ( $Globals['topposterspal'] == "yes" )
    {
        get_posterscache();
    }

    if ( $Globals['ratingspal'] == "yes" )
    {
        get_ratingcache();
    }
}

$more = null;
if ( $cat && $cat != 500 ) $more .= "&amp;cat=$cat";
if ( $limit ) $more .= "&amp;limit=$limit";

//
// Print the page
//

$whoonline = null;
if ( $Globals['onlinepal'] == "yes" && $Globals['sidebar_global'] == "yes" )
{
    // Lets get Who is Online
    $whoonline = get_whoonline();
}

$ungroup = null;
if ( $cat != 500 )
{
    $ungroup = " &middot; <a rel=\"nofollow\" href=\"{$Globals['maindir']}/showgallery.php?cat=$cat&amp;thumbcheck=9\">{$Globals['pp_lang']['ungroup']}</a>";
}

include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );

if ( $Globals['sidebar'] == "left" && $Globals['sidebar_global'] == "yes" )
{
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/sidebar_leftopen.tmpl" );
}

if ( $Globals['sidebar'] == "right" && $Globals['sidebar_global'] == "yes" )
{
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/sidebar_rightopen.tmpl" );
}

if ( $Globals['memblist'] == "no" )
{
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/showmgall.tmpl" );
}
else
{
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/showmlist.tmpl" );
}

if ( $Globals['sidebar'] == "left" && $Globals['sidebar_global'] == "yes" )
{
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/sidebar_leftclose.tmpl" );
}

if ( $Globals['sidebar'] == "right" && $Globals['sidebar_global'] == "yes" )
{
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/sidebar_rightclose.tmpl" );
}

printfooter();

?>
