<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

define( 'THIS_SCRIPT', "showgallery" );
require "pp-inc.php";

$PATH_INFO = findenv("PATH_INFO");
if ( isset($PATH_INFO) && $Globals['spider'] != "none" )
{
    $id = 0;
    $test = explode('/', substr($PATH_INFO,1));

    for($i = 0; $i < count($test); $i++)
    {
        if( $i % 2 == 0 )
        {
            if ( $Globals['spider'] == "seo" )
            {
                if ( $test[$i] == "cat" )
                {
                    // Do a 301 search engine friendly forward
                    $id = (int)$test[$i+1];
                }
            }
            else
            {
                // Using "spider" URLs
                $_REQUEST[$test[$i]] = $test[$i+1];
            }
        }
    }

    if ( $Globals['spider'] == "seo" && strstr($PATH_INFO, "?") )
    {
        // Was "normal" URLs, but want an SEO, so do a 301 search engine friendly forward
        // http://www.website.com/showgallery.php?cat=503
        $id = (int)$_GET['cat'];

        typecast($_REQUEST, array('ppuser' => INT, 'catp' => STRING, 'votecontrol' => STRING, 'sortby' => STRING, 'sorttime' => INT, 'way' => STRING, 'thumbsonly' => INT, 'perpage' => INT, 'page' => INT));
        if ( $perpage )
        {
            // perpage, sortby, sorttime, way, thumbsonly
            $setcookie = serialize( array( $perpage, $sortby, $sorttime, $way, $thumbsonly, $sort, $sl ) );
            @setcookie( "ppperpage", $setcookie, 0, $Globals['cookie_path'], $Globals['domain_path'] );
        }
        if ( $votecontrol )
        {
            $setvotes = "$votecontrol-$id";
            @setcookie( "ppvote", $setvotes, 0, "{$Globals['cookie_path']}", $Globals['domain_path'] );
        }
        if ( isset($catp) )
        {
            @setcookie( "catp", $catp, 0, "{$Globals['cookie_path']}", $Globals['domain_path'] );
            $GLOBALS['catp'] = $catp;
        }
    }

    if ( $id > 0 )
    {
        $cat = $id;
        header ('HTTP/1.1 301 Moved Permanently');
        header ('Location: '. construct_newppurl( "showgallery.php", array('cat' => $id, 'ppuser' => $ppuser) ) );
        exit;
    }
}

typecast($_REQUEST, array('si' => STRING, 'name' => STRING, 'cat' => STRING, 'catp' => STRING, 'page' => INT,
                          'ppuser' => INT, 'what' => STRING, 'when' => STRING, 'whenterm' => STRING,
                          'thumbcheck' => INT, 'votecontrol' => STRING, 'quickjump' => STRING, 'sortby' => STRING,
                          'sorttime' => INT, 'thumbsonly' => INT, 'perpage' => INT, 'way' => STRING
                      ));

if ( $quickjump == "Go" )
{
    unset($what, $sorttime, $when, $way, $shortby, $thumbsonly);
}

// Set cookies first
if ( $perpage || $sort || $sl )
{
    // perpage, sortby, sorttime, way, thumbsonly, sort, sl
    $setcookie = serialize( array( $perpage, $sortby, $sorttime, $way, $thumbsonly, $sort, $sl ) );
    @setcookie( "ppperpage", $setcookie, 0, $Globals['cookie_path'], $Globals['domain_path'] );
}
else
{
    // perpage, sortby, sorttime, way, thumbsonly
    typecast($_COOKIE, array('ppperpage' => STRING));
    if ( $ppperpage )
    {
        list( $perpage, $sortby, $sorttime, $way, $thumbsonly, $sort, $sl ) = unserialize( un_htmlspecialchars($ppperpage) );
    }
}

// Init some variables
if ( !isset($cat) || empty($cat) && $ppuser  ) $cat = "500";
elseif ( !isset($cat) || empty($cat) && !$ppuser  ) $cat = "all";
if ( !isset($page)                 ) $page = 1;
if ( !isset($what) || empty($what) ) $what = "allfields";

// Do we need to set password or get last used password?
if ( isset($catp) )
{
    @setcookie( "catp", $catp, 0, "{$Globals['cookie_path']}", $Globals['domain_path'] );
    $GLOBALS['catp'] = $catp;
}
else
{
    typecast($_COOKIE, array('catp' => STRING));
}

if ( !$ppuser && ($cat == 500 || $cat == MOBILE_CAT) )
{
    // They shouldnt be here if they didnt give us a valid user, send em to showmembers
    header( "Location: {$Globals['maindir']}/showmembers.php" );
    exit;
}

// Let do this....

authenticate();

if ( $Globals['ppboards'] == "closed" && $User['adminedit'] != 1 )
{
    diewell( $Globals['closedmsg'] );
}

$catinfo = array( 'intro' => 'no', 'thumbtype' => 0);

if ( is_numeric($cat) )
{
    $ctitleq = ppmysql_query("SELECT c.id,c.catname,c.description,c.thumbs,c.cattype,c.parent,c.theme,c.thumbtype,
                     c.sortorder,c.frames,c.intro,c.introtitle,c.introcopy,c.ratingtype,c.takevotes,c.ismember,n.userid
        FROM {$Globals['pp_db_prefix']}categories c
        LEFT JOIN {$Globals['pp_db_prefix']}notify n ON (n.userid='{$User['userid']}' AND n.photo=c.id AND n.type=1)
        WHERE c.id=$cat", $link);

    $catinfo = mysql_fetch_assoc($ctitleq);

    if ( !$catinfo['id'] )
    {
        diewell( $Globals['pp_lang']['noview'] );
    }

    if ( (($catinfo['ismember'] == 1 || $thumbsonly == 3) || (!$thumbcheck && $catinfo['thumbtype'] == 3)) && empty($ppuser) )
    {
        // They shouldnt be here if they didnt give us a valid user, send em to showmembers
        header( "Location: {$Globals['maindir']}/showmembers.php?cat={$catinfo['id']}&date=$date" );
        exit;
    }

    if ( !preg_match("/([\<])([^\>]{1,})*([\>])/i", $catinfo['introtitle']) )
    {
        $catinfo['introtitle'] = preg_replace("/(\r\n|\r|\n)/i","<br />", $catinfo['introtitle']);
    }

    if ( !preg_match("/([\<])([^\>]{1,})*([\>])/i", $catinfo['introcopy']) )
    {
        $catinfo['introcopy'] = preg_replace("/(\r\n|\r|\n)/i","<br />", $catinfo['introcopy']);
        $catinfo['introcopy'] = convert_markups( $catinfo['introcopy'] );
    }

    if ( $catinfo['cattype'] == "a" )
    {
        $titlereplace = "$tusername's {$Globals['pp_lang']['persalbum']}";
        $catinfo['thumbs'] = "yes";
    }

    // Nonstandard theme
    if ( $catinfo['theme'] && $Globals['forumstyle'] == "no" )
    {
        $Globals['theme'] = $catinfo['theme'];
        if ( is_dir( "{$Globals['PP_PATH']}/stylesheets/{$Globals['theme']}" ) )
        {
            $Globals['idir'] = "{$Globals['maindir']}/stylesheets/{$Globals['theme']}";
        }
    }

    // Non standard frames
    if ( !empty($catinfo['frames']) )
    {
        unset( $Globals['thumbstd'] );
        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/{$catinfo['frames']}.tmpl" );
    }

    is_cat_protected( $cat, $catp, $catinfo['cattype'] );

    if ( $User['userid'] > 0 && $Globals['displaynew'] == "yes" )
    {
        $lasttimeon = time();
        $resultb = ppmysql_query("REPLACE INTO {$Globals['pp_db_prefix']}laston VALUES('$cat', '{$User['userid']}', '$lasttimeon')", $link);
    }

    $ismod = false;
    if ( $catinfo['ratingtype'] == 1 )
    {

        typecast($_COOKIE, array('ppvote' => STRING));
        if ( $ppvote )
        {
            $parts = explode("-", $ppvote);
            $votecheck  = $parts[0];
            $votecat = $parts[1];

            if ( $votecat == $cat )
            {
                $votecontrol = $votecheck;
            }
        }


        if ( !$sortby )
        {
            if ( $catinfo['takevotes'] == 0 )
            {
                $sortby = "b";
                $catinfo['sortorder'] = 4;
            }
            elseif ( $catinfo['takevotes'] == 1 )
            {
                $sortby = "b";
                $catinfo['sortorder'] = 4;
            }
            else
            {
                $sortby = "c";
                $catinfo['sortorder'] = 9;
            }
        }

        if ( $User['userid'] > 0 )
        {
            // Voting controls
            if ( $User['adminedit'] == 1 || $User['moderator'] == 1 )
            {
                $ismod = true;
                if ( $User['moderator'] == 1 )
                {
                    $ismod = is_moderator($cat);
                }
            }

            if ( isset($votecontrol) && $ismod )
            {
                if ( $votecontrol == "enable" )
                {
                    // enable and set order to random
                    $updateq = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET takevotes=1,sortorder=6 WHERE id=$cat", $link);
                    $catinfo['takevotes'] = 1;
                    setcookie( "ppvote", "", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );
                }
                elseif ( $votecontrol == "disable" )
                {
                    // disable and set order to highest rated
                    $updateq = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET takevotes=0,sortorder=4 WHERE id=$cat", $link);
                    $catinfo['takevotes'] = 0;
                    setcookie( "ppvote", "", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );
                }
                elseif ( $votecontrol == "end" )
                {
                    // disable and set order to highest rated
                    $updateq = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET takevotes=2,sortorder=4 WHERE id=$cat", $link);
                    $catinfo['takevotes'] = 2;
                    setcookie( "ppvote", "", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );
                }
                elseif ( $votecontrol == "reset" )
                {
                    $updateq = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET votes=0 WHERE cat=$cat", $link);
                    $updateq = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}comments WHERE cat=$cat AND votes=1", $link);
                    setcookie( "ppvote", "", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );
                }
            }

            // Grab the image they voted on (if they voted)
            $result = ppmysql_query("SELECT photo FROM {$Globals['pp_db_prefix']}comments WHERE cat=$cat AND userid={$User['userid']} AND votes=1", $link);
            $hasvoted = mysql_num_rows($result);
            list( $uservoted ) = mysql_fetch_row($result);
        }
    }
}
else
{
    if ( $thumbsonly == 3 && empty($ppuser) )
    {
        // They shouldnt be here if they didnt give us a valid user, send em to showmembers
        header( "Location: {$Globals['maindir']}/showmembers.php?cat=$cat" );
        exit;
    }
}

if ( $thumbsonly != 3 )
{
    $thumbsonly = ( isset($thumbsonly) ? $thumbsonly : $catinfo['thumbtype'] );
}

$perpage1x = $Globals['thumbcols'];
$perpage3x = ($perpage1x * 3);
$perpage4x = ($perpage1x * 4);
$perpage5x = ($perpage1x * 5);
$perpage6x = ($perpage1x * 6);

// Force a contest catgeory to show all images on one page
if ( $catinfo['ratingtype'] == 1 )
{
    unset($page);
    $perpage = 1000000;
}
else
{
    if ( $perpage )
    {
        if ( $perpage > 90 ) {
            $perpage = 90;
        }

        if ($perpage < $perpage1x) {
            $perpage = $perpage1x;
        }
    }
    else
    {
        if ( isset($ppperpage) )
        {
            $perpage = $ppperpage;
        }
        else
        {
            $perpage = ($Globals['thumbcols'] * $Globals['thumbrows']);
        }
    }
}

if ( isset($page) && $page > 0 )
{
    $startnumb = ($page*$perpage)-$perpage+1;
}
else
{
    $page = 1;
    $startnumb = 1;
}

// do the sort box //
$catrows = $sortcode = null;

if ( empty($sortby) && is_numeric($cat) )
 {
    $sortparam = ( isset($catinfo['sortorder']) && $catinfo['sortorder'] > 0 ? $catinfo['sortorder'] : 1 );

    $resultc = ppmysql_query("SELECT * FROM {$Globals['pp_db_prefix']}sort WHERE sortid=$sortparam", $link);
    list($sortid, $sortname, $sortcode) = mysql_fetch_row($resultc);
}
else
{
    $sortcode = "ORDER BY disporder,date DESC";
}

$subalbums = $subcats = $seemore = null;

if (!empty($ppuser))
{
    if ( $cat == 500 || $cat == MOBILE_CAT )
    {
        list( $tuserid, $tusername, $tmail ) = get_userinfo( "", $ppuser);
        $catinfo['catname'] = "$tusername {$Globals['pp_lang']['gallery']}";
        $titlereplace = "$tusername's {$Globals['pp_lang']['gallery']}";

        if ( $Globals['memformat'] == "no" )
        {
            $seemore = "<a rel=\"nofollow\" href=\"${$Globals['maindir']}/search.php?cats=all&ppuser=$ppuser\">{$Globals['pp_lang']['tosee']} $tusername's {$Globals['pp_lang']['littlephotos']}</a>";
        }
    }
    elseif ( $catinfo['cattype'] == "a" )
    {
        list( $tuserid, $tusername, $tmail ) = get_userinfo( "", $ppuser);
        $catinfo['catname'] = "$tusername {$Globals['pp_lang']['album']}";
        $titlereplace = "$tusername {$Globals['pp_lang']['album']}";
    }
}

// Don't do these if we are not on page 1
if ( $page == 1 )
{
    $albums = array();
    $albums['subalbcnt'] = $albums['albumcount'] =  $x = 0;

    if ( !empty($ppuser) )
    {
        $arows = ppmysql_query("SELECT c.id,c.parent,c.catname,c.description,c.photos,c.private,
                         p.bigimage, p.cat, p.storecat, p.approved, p.width, p.height, p.userid,
                         p2.bigimage AS thumbnail, p2.cat AS thumbcat, p2.storecat AS thumbstore, p2.userid AS thumbuserid
                  FROM {$Globals['pp_db_prefix']}categories c
                  LEFT JOIN {$Globals['pp_db_prefix']}photos p ON p.id=c.lastphoto
                  LEFT JOIN {$Globals['pp_db_prefix']}photos p2 ON p2.id=c.thumbnail
                  WHERE ( c.parent=$ppuser AND c.cattype='a' AND c.photos > 0 AND c.subalbum=0 ) ORDER BY catorder ASC", $link);

        while ( $album = mysql_fetch_assoc($arows) )
        {
            $albumlink = construct_newppurl( "showgallery.php", array('cat' => $album['id']) );

            if ( $album['private'] == "no" || $User['userid'] == $album['parent'] || $User['adminedit'] == 1 )
            {
                if ( !empty($album['thumbnail']) )
                {
                    if ( $album['thumbstore'] != 0 )
                    {
                        $album['thumbcat'] = $album['thumbstore'];
                    }

                    $thumbrc = get_imagethumb( $album['thumbnail'], $album['thumbcat'], $album['thumbuserid'], $album['approved'] );
                }
                else
                {
                    if ( $album['storecat'] != 0 )
                    {
                        $album['cat'] = $album['storecat'];
                    }

                    $thumbrc = get_imagethumb( $album['bigimage'], $album['cat'], $album['userid'], $album['approved'] );
                }
            }
            else {
                continue;
                //$thumbrc = "<img src=\"{$Globals['idir']}/lock.jpg\" border=\"0\">";
                //$thumbtag = "{$Globals['idir']}/lock.jpg";
            }

            $albums['thumb'][$x]    = $thumbrc;
            $albums['thumbtag'][$x] = $thumbtag;
            $albums['desc'][$x]     = ( empty($album['description']) ? "" : "<br />". $album['description'] );
            $albums['desc'][$x]     .= ( $album['private'] == "no" ? "" : "<br /><b>{$Globals['pp_lang']['private']}</b>" );
            $albums['name'][$x]     = $album['catname'];
            $albums['photos'][$x]   = $album['photos'];
            $albums['link'][$x]     = $albumlink;
            $albums['private'][$x]  = $album['private'];
            $albums['width'][$x]    = $album['width'];
            $albums['height'][$x]   = $album['height'];
            $albums['username'][$x] = $tusername;
            $memrec['userid']       = $album['parent'];
            $albums['thumbnail'][$x]= get_thumbtmpl( $id, $thumbrc, $album['height'], $album['width'], $thumbtag, $album['id'], $albumlink );

            $albums['albumcount']++;
            $x++;
        }
        ppmysql_free_result( $arows );

        $fillercode = $albumfiller = "&nbsp;";

        if ( $User['userid'] == $ppuser )
        {
            $uploadcat = ( $album['id'] > 0 ? $album['id'] : 500 );
            $fillercode = "<a href=\"{$Globals['maindir']}/uploadphoto.php?cat=$uploadcat\">{$Globals['pp_lang']['upload']}</a>";
            $albumfiller = "<a href=\"{$Globals['maindir']}/useralbums.php?ppaction=addalbum\">{$Globals['pp_lang']['addalbum']}</a>";
        }
    }

    // Now lets see if any albums are assigned here (none applied to Members Galleries)
    if ( $cat != 500 && is_numeric($cat) )
    {
        $subrows = ppmysql_query("SELECT c.id,c.parent,c.catname,c.description,c.photos,c.private,
                         p.userid, p.user, p.bigimage, p.cat, p.storecat, p.approved, p.width, p.height,
                         p2.bigimage AS thumbnail, p2.cat AS thumbcat, p2.storecat AS thumbstore, p2.userid AS thumbuserid, p2.user AS thumbuser

                  FROM {$Globals['pp_db_prefix']}categories c
                  LEFT JOIN {$Globals['pp_db_prefix']}photos p ON p.id=c.lastphoto
                  LEFT JOIN {$Globals['pp_db_prefix']}photos p2 ON p2.id=c.thumbnail
                  WHERE ( (c.children=$cat OR c.subalbum=$cat) AND c.cattype='a' AND c.photos > 0 )", $link);

        while ( $album = mysql_fetch_assoc($subrows) )
        {
            $albumlink = construct_newppurl( "showgallery.php", array('cat' => $album['id']) );

            if ( $album['private'] == "no" || $User['userid'] == $album['parent'] )
            {
                if ( !empty($album['thumbnail']) )
                {
                    if ( $album['thumbstore'] != 0 )
                    {
                        $album['thumbcat'] = $album['thumbstore'];
                    }

                    $thumbrc = get_imagethumb( $album['thumbnail'], $album['thumbcat'], $album['thumbuserid'], 1 );
                    $albums['username'][$x] = $album['thumbuser'];
                }
                else {
                    if ( $album['storecat'] != 0 )
                    {
                        $album['cat'] = $album['storecat'];
                    }

                    $thumbrc = get_imagethumb( $album['bigimage'], $album['cat'], $album['userid'], $album['approved'] );
                }
            }
            else
            {
                // If the category we are in is private, then we will show subalbums that are private,
                // even if those subalbums themselves are also private. If the category is not private,
                // then we do not show private subalbums.

                if ( empty($CatPerms['catpass'][$cat]) )
                {
                    continue;
                }
                else
                {
                    $thumbrc = "<img src=\"{$Globals['idir']}/lock.jpg\" border=\"0\">";
                    $thumbtag = "{$Globals['idir']}/lock.jpg";
                }
            }

            $albums['username'][$x] = $album['user'];
            $albums['thumb'][$x]   = $thumbrc;
            $albums['thumbtag'][$x] = $thumbtag;
            $albums['desc'][$x]    = ( empty($album['description']) ? "" : "<br />". $album['description'] );
            $albums['name'][$x]    = $album['catname'];
            $albums['photos'][$x]  = $album['photos'];
            $albums['link'][$x]    = $albumlink;
            $albums['private'][$x] = $album['private'];
            $albums['width'][$x]   = $album['width'];
            $albums['height'][$x]  = $album['width'];
            $albums['thumbnail'][$x]= get_thumbtmpl( $album['id'], $thumbrc, $album['width'], $album['width'], $thumbtag, $album['id'], $albumlink );

            $albums['subalbcnt']++;
            $x++;
        }
        ppmysql_free_result( $subrows );
    }

    if ( is_numeric($cat) && $catinfo['cattype'] != 'a' )
    {
        catrow( $cat, "showgallery" );
    }
}

$cols = $Globals['thumbcols'];

// Sort timeframe (takes priority over recent selection if selected)
if ( !empty($sorttime) )
{
    $sortcheck = time()  - (($sorttime * 24) * 3600);
    $datecheck = "AND date > $sortcheck";
}

// Sortname?
if ( $sortby ) {
    if ( $sortby == "s" )
    {
        $sortvar = "filesize";
    }
    elseif ( $sortby == "c" )
    {
        $sortvar = "votes";
    }
    elseif ( $sortby == "r" )
    {
        $sortvar = "rating";
    }
    elseif ( $sortby == "l" )
    {
        $sortvar = "lastpost";
    }
    elseif ( $sortby == "d" )
    {
        $sortvar = "date";
    }
    elseif ( $sortby == "v" )
    {
        $sortvar = "views";
    }
    else
    {
        $sortvar = "bigimage";
    }

    $sortdir = ( $way == "asc" ? "ASC" : "DESC" );
    $sortcode = "ORDER BY disporder,$sortvar $sortdir";

    if ( $sortby == "l" )
    {
        $sortcode = "AND lastpost > 0 $sortcode";
    }
}

$query = "SELECT id,user,userid,cat,storecat,date,title,description,ismature,keywords,bigimage,width,height,filesize,views,medwidth,medheight,medsize,approved,rating,votes,allowprint,numcom,lastposter FROM {$Globals['pp_db_prefix']}photos ";

if ( !$ppuser && is_numeric($cat) )
{
    $query .= "WHERE cat=$cat AND approved < 2 $datecheck $sortcode";
}
elseif ( is_numeric( $ppuser ) )
{
    $query .= "WHERE userid=$ppuser AND storecat=0";

    if ( $ppuser != $User['userid'] )
    {
        $query .= " AND approved=1";
    }

    if ( is_numeric($cat) && $cat != 500 )
    {
        $query .= " AND cat=$cat";
    }
    elseif ( $cat == 500 )
    {
        if ( $Globals['memformat'] == "no" )
        {
            $query .= " AND cat=500";
        }
    }

    $query .= " $datecheck $sortcode";
}
else
{
    $query .= "WHERE storecat=0";

    if ( $ppuser != $User['userid'] )
    {
        $query .= " AND approved=1";
    }

    if ( is_numeric($cat) && $cat != 500 )
    {
        $query .= " AND cat=$cat";
    }
    elseif ( $cat == 500 )
    {
        if ( $Globals['memformat'] == "no" )
        {
            $query .= " AND cat=500";
        }
    }
    $query .= " $datecheck $sortcode";
}

$queryv = ppmysql_query($query, $link);
$rowcnt = mysql_num_rows($queryv);

$count = $cntresults = $itemcnt = 0;
$pwidth = intval(100 / $Globals['thumbcols']);
$gallery = array();

while ( $row = mysql_fetch_row($queryv) )
{
    list( $id, $tuser, $tuserid, $pcat, $storecat, $pdate, $title, $desc, $ismature, $keywords, $bigimage, $width, $height, $filesize, $views, $medwidth, $medheight, $medsize, $approved, $imgrating, $imgvotes, $allowprint, $comcount, $lastposter ) = $row;

    $is_private = "no";

    if ( $pcat != $cat )
    {
        $is_private = is_image_private( $pcat );
    }

    if ( $storecat == 0 )
    {
        $storecat = $pcat;
    }

    if ( $CatPerms['cattype'][$pcat] == "a" && $cat == 500 )
    {
        continue;
    }

    if ( $approved == 0 && ($User['adminedit'] == 0 && $User['moderator'] == 0 && $tuserid != $User['userid']) )
    {
        continue;
    }

    if ( ($Globals['mature'] == "yes" && $ismature == 1) && (!$User['userid'] || !$User['mature']) )
    {
        continue;
    }

    if ( $is_private == "no" )
    {
        $cntresults++;

        if ( $cntresults >= $startnumb )
        {
            if ( $cntresults < ($startnumb+$perpage) )
            {
                $sizecode = $Globals['pp_lang']['na'];

                if ( $width > 0 && $height > 0 )
                {
                    $sizecode = "$width x $height";
                }

                $filesize = sprintf("%1.1f", ($filesize/1024)) . "{$Globals['pp_lang']['kb']}";
                $theext = get_ext($bigimage);
                $filename = $bigimage;
                $filename = str_replace( $theext, "", $filename);

                $ppdate = formatppdate( $pdate );

                if ( $medsize > 0 )
                {
                    $medsize = sprintf("%1.1f", ($medsize/1024)) . "{$Globals['pp_lang']['kb']}";
                    $ilink = "{$Globals['datadir']}/$storecat/medium/$bigimage";
                    $biglink = "{$Globals['datadir']}/$storecat/$bigimage";

                    $fsizedisp = "$medsize, $filesize";
                }
                else
                {
                    $ilink = "{$Globals['datadir']}/$storecat/$bigimage";
                    $fsizedisp = "<a href=\"". construct_newppurl( "showphoto.php", array( 'photo' => $id, 'title' => $title, 'cat' => $cat) ) ."\">$filesize</a>";
                }

                // Find out if a photo has comments
                if ( $comcount > 0 )
                {
                    $comline = "<span class=\"{$Style['small']}\"><a href=\"". construct_newppurl( "showphoto.php", array( 'photo' => $id, 'title' => $title, 'cat' => $cat) ) ."\">$comcount {$Globals['pp_lang']['littlecom']}</a></span>";
                }
                else
                {
                    $comline = "<span class=\"{$Style['small']}\">{$Globals['pp_lang']['nocomments']}</span>";
                }

                // get the rating
                if ( ($imgrating && $Globals['allowrate'] == "yes") || $catinfo['ratingtype'] == 1 )
                {
                    $rating = number_format( $imgrating, 2 );
                }
                else
                {
                    $rating = $Globals['pp_lang']['none'];
                }

                $thumbrc = get_imagethumb( $bigimage, $storecat, $tuserid, $approved );
                $gallery['profilelink'][$itemcnt] = construct_newppurl( "member.php", array('uid' => $tuserid, 'username' => $tuser) );
                $gallery['plink'][$itemcnt] = "<a href=\"". construct_newppurl( "showphoto.php", array( 'photo' => $id, 'title' => $title, 'cat' => $cat) ) ."\">";

                $gallery['thumbrc'][$itemcnt] = $thumbrc;
                $gallery['thumbtag'][$itemcnt] = $thumbtag;

                $gallery['tuser'][$itemcnt] = $tuser;
                if ( strlen($title) > 22 )
                {
                    $disptitle = substr($title,0,22) . "...";
                }
                else
                {
                     $disptitle = $title;
                }

                $gallery['filename'][$itemcnt]   = $bigimage;
                $gallery['title'][$itemcnt] = $disptitle;
                $gallery['views'][$itemcnt] = $views;
                $gallery['rating'][$itemcnt]     = $rating;
                $gallery['votes'][$itemcnt]      = $imgvotes;
                $gallery['ppdate'][$itemcnt]     = "$ppdate $pptime";
                $gallery['comline'][$itemcnt]    = $comline;
                $gallery['fsizedisp'][$itemcnt]  = $fsizedisp;
                $gallery['sizecode'][$itemcnt]   = $sizecode;
                $gallery['allowprint'][$itemcnt] = $allowprint;
                $gallery['width'][$itemcnt]      = $width;
                $gallery['height'][$itemcnt]     = $height;
                $gallery['id'][$itemcnt]         = $id;
                $gallery['userid'][$itemcnt]     = $tuserid;
                $gallery['voted'][$itemcnt]      = ( $id == $uservoted ? 1 : 0 );
                $gallery['thumbnail'][$itemcnt]  = get_thumbtmpl( $id, $thumbrc, $height, $width, $thumbtag, -1, null, $title );
                $gallery['background'][$itemcnt] = ( $approved == 2 ? $Style['tableborders'] : $Style['tddetails'] );

                $itemcnt++;
            }
        }
    }
}

ppmysql_free_result( $queryv );
$numpages = pagesystem($cntresults);

$pageind = null;
if ( $cntresults > 0 )
{
    $start = ( $page > 1 ? (($page-1)*$perpage)+1 : 1 );

    $finish = $page * $perpage;

    if ( $finish > $cntresults )
    {
        $finish = $cntresults;
    }

    $replvars = array( "{start}", "{finish}", "{cntresults}" );
    $replnews = array( $start, $finish, $cntresults );
    $pageind = str_replace( $replvars, $replnews, $Globals['pp_lang']['imagecnt'] );
}

$noresults = null;
if ( $rowcnt == 0 || $cntresults == 0 )
{
    $noresults .= "<span class=\"{$Style['medium']}\">{$Globals['pp_lang']['nocatimg']}<br /></span>";
}

$nextbutton = $prevbutton = null;

if ( $posternav )
{
    if ( $page < $pages )
    {
        $nextpage = $page + 1;
        if ( $ppuser )
        {
            $nextbutton = "&nbsp;&nbsp;&nbsp;<span style=\"font-size: large;\"><a href=\"". construct_newppurl( "showgallery.php", array('cat' => $cat, 'ppuser' => $ppuser, 'page' => $nextpage) ) ."\">&raquo;</a></span>";
        }
        else
        {
            $nextbutton = "&nbsp;&nbsp;&nbsp;<span style=\"font-size: large;\"><a href=\"". construct_newppurl( "showgallery.php", array('cat' => $cat, 'page' => $nextpage) ) ."\">&raquo;</a></span>";
        }
    }

    if ( $page > 1 )
    {
        $prevpage = $page - 1;
        if ( $ppuser )
        {
            $prevbutton = "&nbsp;<span style=\"font-size: large;\"><a href=\"". construct_newppurl( "showgallery.php", array('cat' => $cat, 'ppuser' => $ppuser, 'page' => $prevpage) ) ."\">&laquo;</a></span>&nbsp;&nbsp;&nbsp;";
        }
        else
        {
            $prevbutton = "&nbsp;<span style=\"font-size: large;\"><a href=\"". construct_newppurl( "showgallery.php", array('cat' => $cat, 'page' => $prevpage) ) ."\">&laquo;</a></span>&nbsp;&nbsp;&nbsp;";
        }
    }
    $posternav = "$prevbutton$posternav$nextbutton";

    if ( !empty($seemore) )
    {
        $seemore = "<br /><br />$seemore";
    }
}

if ( !empty($noresults) )
{
    $noresults = "<b>$noresults</b>";
}

if ( !empty($noresults) && !empty($seemore) )
{
    $noresults .= "<br />";
}

if ( empty($posternav) && empty($seemore) && empty($noresults) )
{
    $posternav = "&nbsp;";
}

// Quick Jump menu
if ( $cat > 0 )
{
    $seltext = null;
    $selected = $cat;
}

catmoveopt(0,1);

if ( !is_numeric($cat) )
{
    $catoptions = "<option value=\"$cat\">{$Globals['pp_lang']['custom']}</option>$catoptions";
}
elseif ( $catinfo['cattype'] == "a" )
{
    $catoptions = "<option value=\"$cat\">{$catinfo['catname']}</option>$catoptions";
}

$quickjump = "<select name=\"cat\">$catoptions</select>";

// Last thing, give them a subscribe button?
$subscribe = "&nbsp;";

if ( $User['userid'] > 0 && $Globals['usenotify'] == "yes" && is_numeric($cat) && $cat != 500 )
{
    if ( $catinfo['notify'] == $User['userid'] )
    {
        $subscribe = "<span id=\"subscribe\"><a title=\"{$Globals['pp_lang']['unsubtitle']}\" href=\"javascript:sendInfoReq('subscribe','$cat');\">{$Globals['pp_lang']['unsubgallery']}</a>";
    }
    else
    {
        $subscribe = "<span id=\"subscribe\"><a title=\"{$Globals['pp_lang']['subtitle']}\" href=\"javascript:sendInfoReq('subscribe','$cat');\">{$Globals['pp_lang']['subscribe']}</a>";
    }
}

if ( $Globals['sidebar_global'] == "yes" )
{
    if ( $Globals['statspal'] == "yes" )
    {
        get_statscache();
    }

    if ( $Globals['topposterspal'] == "yes" )
    {
        get_posterscache();
    }

    if ( $Globals['ratingspal'] == "yes" )
    {
        get_ratingcache();
    }
}

//
// Print the page
//

$metadesc = $catinfo['description'];
$metadesc = strip_tags(htmlspecialchars($metadesc));
$metakey = null;

topmenu();
printheader( $cat, $catinfo['catname'] );

childsub($cat, $catinfo['cattype']);
$childnav = "<a href=\"{$Globals['maindir']}/\">{$Globals['pp_lang']['home']}</a> $childnav";

// Cell alignment
$aligntb = ( $thumbsonly > 0 ? "middle" : "bottom" );

if ( $thumbsonly == 1 )
{
   $views = "<option value=\"0\">{$Globals['pp_lang']['gallery']}</option><option value=\"1\" selected=\"selected\">{$Globals['pp_lang']['thumbnail']}</option><option value=\"2\">{$Globals['pp_lang']['withtitles']}</option><option value=\"3\">{$Globals['pp_lang']['groupby']}</option><option value=\"4\">{$Globals['pp_lang']['puzzle']}</option>";
}
elseif( $thumbsonly == 2 )
{
   $views = "<option value=\"0\">{$Globals['pp_lang']['gallery']}</option><option value=\"1\">{$Globals['pp_lang']['thumbnail']}</option><option value=\"2\" selected=\"selected\">{$Globals['pp_lang']['withtitles']}</option><option value=\"3\">{$Globals['pp_lang']['groupby']}</option><option value=\"4\">{$Globals['pp_lang']['puzzle']}</option>";
}
elseif( $thumbsonly == 3 )
{
   $views = "<option value=\"0\">{$Globals['pp_lang']['gallery']}</option><option value=\"1\">{$Globals['pp_lang']['thumbnail']}</option><option value=\"2\">{$Globals['pp_lang']['withtitles']}</option><option value=\"3\" selected=\"selected\">{$Globals['pp_lang']['groupby']}</option><option value=\"4\">{$Globals['pp_lang']['puzzle']}</option>";
}
elseif( $thumbsonly == 4 )
{
   $views = "<option value=\"0\">{$Globals['pp_lang']['gallery']}</option><option value=\"1\">{$Globals['pp_lang']['thumbnail']}</option><option value=\"2\">{$Globals['pp_lang']['withtitles']}</option><option value=\"3\">{$Globals['pp_lang']['groupby']}</option><option value=\"4\" selected=\"selected\">{$Globals['pp_lang']['puzzle']}</option>";

   // $thumbfudge is used to add a few thumbnails per line when using Puzzle view (since we have more room)
   $thumbfudge = 7;
}
else
{
   $views = "<option value=\"0\" selected=\"selected\">{$Globals['pp_lang']['gallery']}</option><option value=\"1\">{$Globals['pp_lang']['thumbnail']}</option><option value=\"2\">{$Globals['pp_lang']['withtitles']}</option><option value=\"3\">{$Globals['pp_lang']['groupby']}</option><option value=\"4\">{$Globals['pp_lang']['puzzle']}</option>";
}

$whoonline = null;
if ( $Globals['catonline'] == "yes" )
{
    // Lets get Who is Online
    $whoonline = get_whoonline( $cat );
}

$showsearch = true;
if ( $cat == 500 || ($Globals['searchreg'] == "yes" && $User['userid'] == 0) )
{
    $showsearch = false;
}

include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );

if ( $Globals['sidebar'] == "left" && $Globals['sidebar_global'] == "yes" )
{
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/sidebar_leftopen.tmpl" );
}

if ( $Globals['sidebar'] == "right" && $Globals['sidebar_global'] == "yes" )
{
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/sidebar_rightopen.tmpl" );
}

if ( $catinfo['cattype'] == "c" && !$ppuser )
{
    if ( $Globals['features'] == "yes" )
    {
        if ( $Globals['mostrecent'] == "yes" && $Globals['recentdefault'] == "yes" )
        {
            display_gallery("latest", "", $cat);
        }

        if ( $Globals['dispopular'] == "yes" )
        {
            display_gallery("most_views", "", $cat);
        }

        if ( $Globals['disrandom'] == "yes" )
        {
            display_gallery("random", "", $cat);
        }
    }
}

$whichgallery = ( $Globals['pplayout'] == "no" ? "categall" : "categories" );
$count = 0;

include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/showgallery.tmpl" );

if ( $Globals['sidebar'] == "left" && $Globals['sidebar_global'] == "yes" )
{
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/sidebar_leftclose.tmpl" );
}

if ( $Globals['sidebar'] == "right" && $Globals['sidebar_global'] == "yes" )
{
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/sidebar_rightclose.tmpl" );
}

printfooter();

?>
