<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

define( 'THIS_SCRIPT', "showframe" );
require "pp-inc.php";

typecast($_REQUEST, array('photo' => INT, 'cat' => STRING, 'sortby' => STRING, 'sortdir' => STRING, 'limit' => STRING,
                          'way' => STRING, 'sorttime' => INT, 'page' => INT, 'date' => INT, 'init' => INT, 'orig' => INT,
                          'action' => STRING, 'month' => INT, 'year' => INT, 'ispal' => INT, 'soprtby' => STRING,
                          'sortdir' => STRING, 'sorttime' => INT, 'ppuser' => INT, 'feature' => STRING) );
typecast($_COOKIE, array('catp' => STRING));

if ( !$action )
{
    $action = "thumbs";
}

authenticate();

if ( $Globals['ppboards'] == "closed" && $User['adminedit'] != 1 )
{
    exit;
}

$output = null;

if ( $action == "thumbs" )
{
    if ( !$photo )
    {
        exit;
    }

    if ( ($User['username'] == "" || $User['username'] == $Globals['pp_lang']['unreg']) && $Globals['reqregister'] == "yes" )
    {
        exit;
    }

    $rows = ppmysql_query("SELECT id,user,userid,cat,storecat,storeid,bigimage,width,height FROM {$Globals['pp_db_prefix']}photos WHERE id=$photo", $link);
    list( $id, $photouser, $iuserid, $dbcat, $storecat, $storeid, $bigimage, $width, $height ) = mysql_fetch_row($rows);
    ppmysql_free_result( $rows );

    if ( $photo != $id || !$dbcat )
    {
        exit;
    }

    $iphoto = $orig;

    if ( !$cat && $limit ) {
        $cat = $limit;
    }

    if ( $storecat == 0 ) {
        $storecat = $dbcat;
    }

    $resulta = ppmysql_query("SELECT catname,cattype,sortorder FROM {$Globals['pp_db_prefix']}categories where id=$dbcat", $link);
    list( $thecatname, $cattype, $sortorder ) = mysql_fetch_row($resulta);
    ppmysql_free_result($resulta);

    is_cat_protected( $dbcat, $catp, $cattype );

    //
    // Next and Previous images for display
    //
    if ( !$sortby && $sortorder > 0 && empty($limit) )
    {
        $resultc = ppmysql_query("SELECT * FROM {$Globals['pp_db_prefix']}sort WHERE sortid=$sortorder", $link);
        list($sortid, $sortname, $sortcode) = mysql_fetch_row($resultc);
        ppmysql_free_result( $resultc );
    }
    elseif ( $sortby )
    {
        // Timeframe
        $searchq = null;

        if ( $sorttime > 0 )
        {
            $searchq = "AND date > ". time() - (($sorttime * 24) * 3600);
        }

        // Sortname?
        if ( !empty($sortby) )
        {
            if ( $sortby == "s" )
            {
                $sortvar = "filesize";
            }
            elseif ( $sortby == "r" )
            {
                $sortvar = "rating";
            }
            elseif ( $sortby == "l" )
            {
                $sortvar = "lastpost";
            }
            elseif ( $sortby == "d" )
            {
                $sortvar = "date";
            }
            elseif ( $sortby == "v" )
            {
                $sortvar = "views";
            }
            else
            {
                $sortvar = "bigimage";
            }

            $sortdir = ( $way == "asc" ? "ASC" : "DESC" );
            $sortcode = "$searchq ORDER BY $sortvar $sortdir";

            if ( $sortby == "r" )
            {
                $sortcode = "$searchq AND rating > 0 $sortcode";
            }
        }
    }
    else
    {
        if ( !empty($limit) )
        {
            $sortcode = "ORDER BY date DESC";
        }
    }

    if ( $cat == "fav" )
    {
        $query = "SELECT p.id,p.bigimage,p.cat,p.userid,p.approved,p.storecat,p.height,p.width FROM {$Globals['pp_db_prefix']}favorites f, {$Globals['pp_db_prefix']}photos p
            WHERE f.userid={$User['userid']} AND f.photo=p.id $sortcode";
    }
    elseif ( $cat == 500 )
    {
        if ( $Globals['memformat'] == "yes" )
        {
            $query = "SELECT id,cat,title,bigimage,userid,approved,storecat,height,width,ismature FROM {$Globals['pp_db_prefix']}photos WHERE userid='$iuserid' AND approved=1 $sortcode";
        }
        else
        {
            $query = "SELECT id,cat,title,bigimage,userid,approved,storecat,height,width,ismature FROM {$Globals['pp_db_prefix']}photos WHERE cat=500 AND userid='$iuserid' AND approved=1 $sortcode";
        }
    }
    elseif ( $cat == MOBILE_CAT || $dbcat == MOBILE_CAT )
    {
        $query = "SELECT id,cat,title,bigimage,userid,approved,storecat,height,width,ismature FROM {$Globals['pp_db_prefix']}photos WHERE cat='".MOBILE_CAT."' AND userid='$iuserid' AND approved=1 $sortcode";
    }
    elseif ( $cat == "recent" || $limit == "recent" )
    {
        $query = "SELECT id,cat,title,bigimage,userid,approved,storecat,height,width,ismature FROM {$Globals['pp_db_prefix']}photos WHERE approved=1 AND storecat=0 ORDER BY date DESC";
    }
    elseif ( $cat == "views" || $limit == "views" )
    {
        $query = "SELECT id,cat,title,bigimage,userid,approved,storecat,height,width,ismature FROM {$Globals['pp_db_prefix']}photos WHERE approved=1 AND storecat=0 ORDER BY views DESC";
    }
    elseif ( $cat == "all" || $limit == "all" )
    {
        $query = "SELECT id,cat,title,bigimage,userid,approved,storecat,height,width,ismature FROM {$Globals['pp_db_prefix']}photos WHERE approved=1 $sortcode";
    }
    elseif ( strstr($limit,"last") )
    {
        // Last xx days
        if ( $limit == "last14" )
        {
            $days = 14;
        }
        elseif ( $limit == "last7" )
        {
            $days = 7;
        }
        else
        {
            $days = 1;
        }

        $searchdate = time() - (($days * 24) * 3600);
        $whichcat = ( is_numeric($cat) ? "AND cat=$cat" : null );

        $query = "SELECT id,cat,title,bigimage,userid,approved,storecat,height,width,ismature FROM {$Globals['pp_db_prefix']}photos WHERE date > $searchdate AND approved=1 $whichcat ORDER BY date DESC";
    }
    elseif( !empty($date) )
    {
        $thisdate = getdate($date);
        $thismonth = $thisdate["mon"];
        $thisyear  = $thisdate["year"];
        $thisday   = $thisdate["mday"];

        $lowdate  = mktime(0, 0, 0, $thismonth, $thisday, $thisyear);
        $highdate = mktime(0, 0, 0, $thismonth, $thisday+1, $thisyear);

        $whichcat = ( is_numeric($cat) ? "AND cat=$cat" : "" );
        $query = "SELECT id,cat,title,bigimage,userid,approved,storecat,height,width,ismature FROM {$Globals['pp_db_prefix']}photos WHERE date >= $lowdate AND date < $highdate AND approved=1 $whichcat ORDER BY date DESC";
    }
    elseif ( $ppuser )
    {
        $query = "SELECT id,cat,title,bigimage,userid,approved,storecat,height,width,ismature FROM {$Globals['pp_db_prefix']}photos WHERE cat=$dbcat AND userid=$ppuser AND approved=1 $sortcode";
    }
    else
    {
        $query = "SELECT id,cat,title,bigimage,userid,approved,storecat,height,width,ismature FROM {$Globals['pp_db_prefix']}photos WHERE cat=$dbcat AND approved=1 $sortcode";
    }
    $rows = ppmysql_query($query, $link);

    if ( $Globals['previewcols'] == 1 )
    {
        $highf = 7;
        $lowf = 6;
        $middlef = 4;
        if ( $Globals['filmstrip'] == "top" || $Globals['filmstrip'] == "bottom" )
        {
            $splitf = 7;
        }
        else
        {
            $splitf = 1;
        }
        $previewwidth = $Globals['previewwidth'] + 10;
    }
    else
    {
        $highf = 21;
        $lowf = 20;
        $middlef = 11;
        if ( $Globals['filmstrip'] == "top" || $Globals['filmstrip'] == "bottom" )
        {
            $splitf = 7;
        }
        else
        {
            $splitf = 3;
        }
        $previewwidth = ($Globals['previewwidth'] + 3) * 3;
    }

    while ( $thisrec = mysql_fetch_row($rows) )
    {
        if ( $thisrec[9] == 1 && (!$User['userid'] || !$User['mature'] ) )
        {
            continue;
        }

        if ( is_image_private($thisrec[1]) == "no" )
        {
            if ( $thisrec[0] == $photo )
            {
                $stripimgs[] = $thisrec;

                // Grab more (if there)
                $exc = 0;
                while ( $nextrec = mysql_fetch_row($rows) )
                {
                    if ( $nextrec[9] == 1 && (!$User['userid'] || !$User['mature']) )
                    {
                        continue;
                    }

                    if ( is_image_private($nextrec[1]) == "no" )
                    {
                        $stripimgs[] = $nextrec;

                        if ( count($stripimgs) == $highf )
                        {
                            $morephotos = true;
                            break;
                        }
                    }
                }
                break;
            }
            else
            {
                $stripimgs[] = $thisrec;

                if ( count($stripimgs) == $middlef )
                {
                    array_shift($stripimgs);
                    $lessphotos = true;
                }
            }
        }
    }
    ppmysql_free_result($rows);

    $filmstrips = array_fill( 0, $highf, null );
    $nextlink = $prevlink = $slidecode = $nextajax = $prevajax = null;
    $init = 1;

    //print "<pre>"; print_r($stripimgs); exit;
    foreach( $stripimgs AS $ids => $strip )
    {
        if ( $strip[0] > 0 )
        {
            list($npid, $npcat, $xtitle, $npbig, $npuserid, $npapp, $npstore, $npheight, $npwidth, $ismature) = $strip;

            if ( !$npstore )
            {
                $npstore = $npcat;
            }

            $isme[$ids] = ( $npid == $photo ? true : false );
            $pimgtag = get_imagethumb( $npbig, $npstore, $npuserid, $npapp );

            $boxcolor = $Style['framecolor'];
            if ( $npid == $orig )
            {
                $boxcolor = "#00cc00";
            }

            $savecat = $cat;
            $cat = $npcat;
            $filmstrips[$ids] = get_thumbtmpl( $npid, $pimgtag, $npheight, $npwidth, $thumbtag, -1, null, $xtitle, $boxcolor );
            $cat = $savecat;

            if ( $ids == 0 && $lessphotos )
            {
                $prevlink = "&laquo; <a title=\"{$Globals['pp_lang']['morephotos']}\" href=\"javascript:sendPhotoReq('$npid','$cat','$orig','$limit','$sortby','$sortdir','$sorttime','$ppuser');\">{$Globals['pp_lang']['more']}</a>";
            }
            elseif ( $ids == 20 && $morephotos )
            {
                if ( $prevlink )
                {
                    $nextlink = " &middot; ";
                }

                $nextlink .= "<a title=\"{$Globals['pp_lang']['morephotos']}\" href=\"javascript:sendPhotoReq('$npid','$cat','$orig','$limit','$sortby','$sortdir','$sorttime','$ppuser');\">{$Globals['pp_lang']['more']}</a> &raquo;";
            }
        }
        else
        {
            $filmstrips[$ids] = null;
        }
    }

    foreach ($filmstrips as $key => $value)
    {
        if (is_null($value))
        {
            unset($filmstrips[$key]);
        }
    }
    reset($filmstrips);

    // Let's get their preference
    if ( $Globals['filmstrip'] == "bottom" )
    {
        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/filmstrip-hor.tmpl" );
        $filmstrip = "<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><td nowrap=\"nowrap\">$prevlink</td><td>$filmstrip</td><td nowrap=\"nowrap\">$nextlink</td></tr></table>";
    }
    elseif ( $Globals['filmstrip'] == "left" )
    {
        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/filmstrip-ver.tmpl" );
        $filmstrip = "$prevlink$nextlink$filmstrip$prevlink$nextlink";
    }
    elseif ( $Globals['filmstrip'] == "right" )
    {
        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/filmstrip-ver.tmpl" );
        $filmstrip = "$prevlink$filmstrip$nextlink";
    }
    else
    {
        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/filmstrip-hor.tmpl" );
        $filmstrip = "<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><td nowrap=\"nowrap\">$prevlink</td><td>$filmstrip</td><td nowrap=\"nowrap\">$nextlink</td></tr></table>";
    }

    $output .= "filmstrip||$filmstrip\n";
}

if ( $action == "feature" )
{
    $featurestrip = null;

    $catquery = null;
    $userq = null;
    $query = false;
    $localupd = false;
    $q_switch = ( $feature ? $feature : "random" );

     if ( !$ispal )
     {
         $rcols = $Globals['recentcols'];
         $rphotos = $Globals['recentnum'];
     }
     elseif ( ( $Globals['undercat'] == "yes" ) && ($Globals['sidebar_index'] == "no" || $Globals['sidebar'] == "off" ) )
     {
         $rcols = 2;
         $rphotos = 4;
     }
     else
     {
         $rcols = 1;
         $rphotos = 6;
     }

    $grabnum = $Globals['recentnum'] + 5;
    $twidth = round(100/$rcols);

    if ( $cat == 500 )
    {
        $catname = "{$Globals['pp_lang']['gallery']}";
        if ( $si == "" ) $catquery = "500";
    }
    elseif ( $cat )
    {
        if ( is_numeric($cat) )
        {
            $catname = $CatPerms['catname'][$cat];
            $cattype = $CatPerms['cattype'][$cat];
            $catchildren = $CatPerms['children'][$cat];

            $catquery = $cat;

            if ( $catchildren )
            {
                $catquery .= ",$catchildren";
            }
        }
        elseif ( $cat != "all" )
        {
            $catquery = 500;
        }
    }

    if ( $showuser )
    {
        $userq = " AND userid=$showuser";

        list( $tuserid, $tusername, $tmail ) = get_userinfo("", $showuser);
        $catname = "$tusername's $catname";
    }

    if ( $catquery )
    {
        $catquery = " AND cat IN ($catquery)";
    }

    if ( $catname )
    {
        $catname = "<br />[$catname]";
    }

    if ( $feature == "random" )
    {
        if ( !isset($cat) || empty($catquery) )
        {
            $group_title = "<a title=\"{$Globals['pp_lang']['mostrecent']}\" href=\"javascript:sendFeatReq('latest','$ispal',0);\">{$Globals['pp_lang']['mostrecent']}</a> &middot; <a title=\"{$Globals['pp_lang']['mostpop']}\" href=\"javascript:sendFeatReq('most_views','$ispal',0);\">{$Globals['pp_lang']['mostpop']}</a> &middot; {$Globals['pp_lang']['randoms']}";
            $query = "SELECT id,user,userid,cat,storecat,title,bigimage,height,width, id*0+RAND() as rand_col FROM {$Globals['pp_db_prefix']}photos WHERE approved=1 ORDER BY rand_col DESC LIMIT $grabnum";
            $localupd = "randomcache";
        }
        else
        {
            $group_title = "<a title=\"{$Globals['pp_lang']['mostrecent']}\" href=\"javascript:sendFeatReq('latest','$ispal','$cat');\">{$Globals['pp_lang']['mostrecent']}</a> &middot; <a title=\"{$Globals['pp_lang']['mostpop']}\" href=\"javascript:sendFeatReq('most_views','$ispal','$cat');\">{$Globals['pp_lang']['mostpop']}</a> &middot; {$Globals['pp_lang']['randoms']}$catname";
            $query = "SELECT id,user,userid,cat,storecat,title,bigimage,height,width, id*0+RAND() as rand_col FROM {$Globals['pp_db_prefix']}photos WHERE approved=1 $userq $catquery ORDER BY rand_col DESC LIMIT $grabnum";
        }

        $toggle = "random";
        $ppstyle = $vbcollapse[collapseobj_random];
    }
    elseif ( $feature == "most_views" )
    {
        if ( !$cat && !$showuser && !$catquery )
        {
            if ( $updatecache || empty($cacheq['recentcache']) )
            {
                $group_title = "<a title=\"{$Globals['pp_lang']['mostrecent']}\" href=\"javascript:sendFeatReq('latest','$ispal',0);\">{$Globals['pp_lang']['mostrecent']}</a> &middot; {$Globals['pp_lang']['mostpop']} &middot; <a title=\"{$Globals['pp_lang']['randoms']}\" href=\"javascript:sendFeatReq('random','$ispal',0);\">{$Globals['pp_lang']['randoms']}</a>";
                $query = "SELECT id,user,userid,cat,storecat,title,ismature,bigimage,height,width FROM {$Globals['pp_db_prefix']}photos WHERE approved=1 AND storecat=0 ORDER BY views DESC LIMIT $grabnum";
                $localupd = "recentcache";
            }
            else
            {
                $group_title = "<a title=\"{$Globals['pp_lang']['mostrecent']}\" href=\"javascript:sendFeatReq('latest','$ispal',0);\">{$Globals['pp_lang']['mostrecent']}</a> &middot; {$Globals['pp_lang']['mostpop']} &middot; <a title=\"{$Globals['pp_lang']['randoms']}\" href=\"javascript:sendFeatReq('random','$ispal',0);\">{$Globals['pp_lang']['randoms']}</a>";
                $results = unserialize( $cacheq['recentcache'] );
            }
        }
        else
        {
            $query = "SELECT id,user,userid,cat,storecat,title,ismature,bigimage,height,width FROM {$Globals['pp_db_prefix']}photos WHERE approved=1 AND storecat=0 $userq $catquery ORDER BY views DESC LIMIT $grabnum";
            $group_title = "<a title=\"{$Globals['pp_lang']['mostrecent']}\" href=\"javascript:sendFeatReq('latest','$ispal','$cat');\">{$Globals['pp_lang']['mostrecent']}</a> &middot; {$Globals['pp_lang']['mostpop']} &middot; <a title=\"{$Globals['pp_lang']['randoms']}\" href=\"javascript:sendFeatReq('random','$ispal','$cat');\">{$Globals['pp_lang']['randoms']}</a>$catname";
        }

        // Used for vB3 tags
        $toggle = "popular";
        $ppstyle = $vbcollapse[collapseobj_popular];
    }
    else
    {
        if ( !$cat && !$showuser && !$catquery )
        {
            if ( $updatecache || empty($cacheq['recentcache']) )
            {
                $group_title = "{$Globals['pp_lang']['mostrecent']} &middot; <a title=\"{$Globals['pp_lang']['mostpop']}\" href=\"javascript:sendFeatReq('most_views','$ispal',0);\">{$Globals['pp_lang']['mostpop']}</a> &middot; <a title=\"{$Globals['pp_lang']['randoms']}\" href=\"javascript:sendFeatReq('random','$ispal',0);\">{$Globals['pp_lang']['randoms']}</a>";
                $query = "SELECT id,user,userid,cat,storecat,title,ismature,bigimage,height,width FROM {$Globals['pp_db_prefix']}photos WHERE approved=1 AND storecat=0 ORDER BY date DESC LIMIT $grabnum";
                $localupd = "recentcache";
            }
            else
            {
                $group_title = "{$Globals['pp_lang']['mostrecent']} &middot; <a title=\"{$Globals['pp_lang']['mostpop']}\" href=\"javascript:sendFeatReq('most_views','$ispal',0);\">{$Globals['pp_lang']['mostpop']}</a> &middot; <a title=\"{$Globals['pp_lang']['randoms']}\" href=\"javascript:sendFeatReq('random','$ispal',0);\">{$Globals['pp_lang']['randoms']}</a>";
                $results = unserialize( $cacheq['recentcache'] );
            }
        }
        else
        {
            $query = "SELECT id,user,userid,cat,storecat,title,ismature,bigimage,height,width FROM {$Globals['pp_db_prefix']}photos WHERE approved=1 AND storecat=0 $userq $catquery ORDER BY date DESC LIMIT $grabnum";
            $group_title = "{$Globals['pp_lang']['mostrecent']} &middot; <a title=\"{$Globals['pp_lang']['mostpop']}\" href=\"javascript:sendFeatReq('most_views','$ispal','$cat');\">{$Globals['pp_lang']['mostpop']}</a> &middot; <a title=\"{$Globals['pp_lang']['randoms']}\" href=\"javascript:sendFeatReq('random','$ispal','$cat');\">{$Globals['pp_lang']['randoms']}</a>$catname";
        }

        // Used for vB3 tags
        $toggle = "latest";
        $ppstyle = $vbcollapse[collapseobj_latest];
    }

    // Used for vB3 tags
    $ppimgid = "collapseimg_$toggle";
    $pptbid = "collapseobj_$toggle";

    $result = ppmysql_query($query, $link);
    $results = array();

    while ( $features = mysql_fetch_array($result) )
    {
        $results[] = $features;
    }
    ppmysql_free_result($result);

    $count = 0;
    $catcache = array();

    foreach( $results AS $features )
    {
        $thiscat = $features['cat'];
        if( $features['storecat'] != 0 )
        {
            $features['cat'] = $features['storecat'];
        }

        if ( $features['cattype'] == "a" )
        {
            $CatPerms['ugview'][$thiscat] = $CatPerms['ugview'][500];
        }

        if ( $CatPerms['ugview'][$thiscat] == 0 )
        {
            if ( !$catcache[$thiscat] )
            {
                $catcache[$thiscat] = is_image_private( $features['cat'] );
            }

            if ( $catcache[$thiscat] == "no" )
            {
                $count++;
                $ptitle[$count] = "<br />".$features['title'];
                $pid[$count] = $features['id'];
                $pimgtag[$count] = get_imagethumb( $features['bigimage'], $features['cat'], $features['userid'], 1 );
                $fthumbtag[$count] = $thumbtag;
                $pwidth[$count] = $features['width'];
                $pheight[$count] = $features['height'];

                $pcatname[$count] = "<br />[ <a href=\"" . construct_newppurl( "showgallery.php", array('cat' => $thiscat) ) ."\">{$CatPerms['catname'][$thiscat]}</a> ]";
                $puser[$count] = "<a href=\"". construct_newppurl( "member.php", array('uid' => $features['userid'], 'username' => $features['user']) ) ."\">{$features['user']}</a>";

                // Make the thumbnail
                $savecat = $cat;
                $cat = $features['cat'];
                $pthumb[$count] = get_thumbtmpl( $features['id'], $pimgtag[$count], $features['height'], $features['width'], $thumbtag, $q_switch, null, $features['title'] );
                $cat = $savecat;
            }
        }

        if ( $count == $rphotos )
        {
            break;
        }
    }

    if ( isset($stylevar[imgdir_button]) )
    {
        $stylepath = ( $stylevar[imgdir_button][0] == "/" || $stylevar[imgdir_button][0] == "h" ? "" : "{$Globals['vbulletin']}/" );
    }

    $featurestrip = $morephotos = null;

    if ( $feature == "random" )
    {
        $morephotos = "&middot; <a title=\"{$Globals['pp_lang']['more']}\" href=\"javascript:sendFeatReq('random','$ispal','$cat');\">{$Globals['pp_lang']['more']}</a> &middot;";
    }

    if ( $count )
    {
        if ( !$ispal )
        {
            include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/feature.tmpl" );
            $output .= "random||$featurestrip\n";
        }
        else
        {
            include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/featurepal.tmpl" );
            $output .= "randompal||$featurestrip\n";
        }
    }
}

if ( $action == "cal" )
{
    // Using today's date we get the current month
    $todayis = getdate();

    if ( $month && $year )
    {
        $todayis['mon'] = $month;
        $todayis['year'] = $year;
    }

    // And now we print the calendar
    $output .= "cal||". gen_cal( $todayis['mon'], $todayis['year'] ) ."\n";
}

if ( $action == "tags" )
{
    $result = ppmysql_query("SELECT f.userid,u.username FROM {$Globals['pp_db_prefix']}favorites f
                                   LEFT JOIN {$Globals['pp_db_prefix']}users u ON (u.userid=f.userid)
                                   WHERE f.photo=$photo", $link);

    $tagdata = null;
    while ( list($fuid, $fname ) = mysql_fetch_row($result) )
    {
        $tagdata .= ( $tagdata ? ", " : "" ) . "<a href=\"". construct_newppurl( "member.php", array('uid' => $fuid, 'username' => $fname) ) ."\">$fname</a>";
    }

    if ( $tagdata )
    {
$taginfo = <<<TAGINFO
    <table class="{$Style['tablesurround']}" cellpadding="1" cellspacing="1" border="0" width="90%" align="center">
    <tr>
    <td>
        <table cellpadding="2" cellspacing="1" width="100%" class="{$Style['tableborders']}">
        <tr>
        <td class="{$Style['tddetails']}" align=\"left\">
            {$Globals['pp_lang']['utagged']}: $tagdata
        </td>
        </tr>
        </table>
    </td>
    </tr>
    </table>
TAGINFO;

        $output .= "extrainfo||$taginfo\n";
    }
}

if ( $action == "addbuddy" )
{
    ppmysql_query("INSERT IGNORE INTO {$Globals['pp_db_prefix']}buddies (id,userid,buddy) VALUES( NULL, {$User['userid']}, $photo )", $link);
    $output .= "buddy||<a title=\"{$Globals['pp_lang']['addbuddy']}\" href=\"javascript:sendInfoReq('delbuddy','$uid');\">{$Globals['pp_lang']['remfrombuddy']}</a>";
}

if ( $action == "delbuddy" )
{
    ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}buddies WHERE userid={$User['userid']} AND buddy=$photo", $link);
    $output .= "buddy||<a title=\"{$Globals['pp_lang']['rembuddy']}\" href=\"javascript:sendInfoReq('addbuddy','$uid');\">{$Globals['pp_lang']['addtobuddy']}</a>";
}

if ( $action == "exif" )
{
    if ( $Globals['showexif'] == "yes" )
    {
        $row = ppmysql_query("SELECT exifinfo FROM {$Globals['pp_db_prefix']}exif WHERE photoid=$photo", $link);
        if ( $row )
        {
            list( $exifinfo ) = mysql_fetch_row($row);
        }
        ppmysql_free_result( $row );

        $exifdata = null;

        if ( $exifinfo && $Globals['showexif'] == "yes" )
        {
            $restexif = unserialize($exifinfo);

$exifdata = <<<EXIFINFO
                    <table class="{$Style['tablesurround']}" cellpadding="1" cellspacing="1" border="0" width="90%" align="center">
                    <tr>
                    <td>
                        <table cellpadding="2" cellspacing="1" width="100%" class="{$Style['tableborders']}">
                        <tr>
                        <td class="{$Style['menubar']}" align="center" colspan="4">
                            <span class="{$Style['small']}"><b>{$Globals['pp_lang']['exif']}</b></span>
                        </td>
                        </tr>
EXIFINFO;

            $col = 1;

            while( list($k,$v) = each($restexif) )
            {
                if ( !empty($v) )
                {
                    if ( is_numeric($v) )
                    {
                        if ( strlen($v) == 10 )
                        {
                            $v = formatppdate( $v );
                        }
                        else
                        {
                            $v = number_format( $v );
                        }
                    }
                    else
                    {
                        $v = htmlentities(strip_tags(trim($v)));
                    }

                    if ( $k == "IsColor" )
                    {
                        if ( $v == 1 ) {
                            $v = "Yes";
                        }
                        else
                        {
                            $v = "No";
                        }
                    }

                    if ( $col == 1 )
                    {
                        $exifdata .= "<tr>";
                    }

                    $exifdata .= "<td class=\"{$Style['tddetails']}\" width=\"25%\" align=\"left\"><span class=\"{$Style['small']}\">$k:</span></td>
                        <td class=\"{$Style['tddetails']}\" width=\"25%\" align=\"left\"><span class=\"{$Style['small']}\">$v</span></td>\n";

                    if ( $col == 1 )
                    {
                        $col = 2;
                    }
                    else
                    {
                        $col = 1;
                        $exifdata .= "</tr>";
                    }
                }
            }

            if ( $col == 2 ) {
                $exifdata .= "<td class=\"{$Style['tddetails']}\" width=\"25%\">&nbsp;</td><td class=\"{$Style['tddetails']}\" width=\"25%\">&nbsp;</td>";
            }

            $exifdata .= "</tr></table></td></tr></table><br />";
        }
    }

    $output .= "extrainfo||$exifdata\n";
}

if ( $action == "photoadmin" )
{
    $rows = ppmysql_query("SELECT id,user,userid,cat FROM {$Globals['pp_db_prefix']}photos WHERE id=$photo", $link);
    list( $id, $photouser, $iuserid, $dbcat, $storecat ) = mysql_fetch_row($rows);
    ppmysql_free_result( $rows );

    if ( $id )
    {
        $ismod = false;

        if ( $User['adminedit'] == 1 || $User['moderator'] == 1 || ($User['userid'] == $iuserid && $ueditpho == 1) )
        {
            if ( $User['adminedit'] == 1 || $User['moderator'] == 1 )
            {
                $ismod = true;

                if ( $User['moderator'] == 1 )
                {
                    $ismod = is_moderator($dbcat);
                }
            }

            if ( $ismod || ($User['userid'] == $iuserid && $ueditpho == 1) )
            {
                $selected = $dbcat;

                catmoveopt(0,1);
$admindisplay = <<< ADMINOPTS
        <form method="post" action="{$Globals['maindir']}/adm-photo.php">
            <table cellpadding="0" cellspacing="0" border="0" width="100%">
            <tr>
ADMINOPTS;

                if ( $Globals['usermove'] == "yes" || $ismod )
                {
                    $admindisplay .= "<td class=\"{$Style['menubarnb']}\" width=\"50%\" align=\"center\">
                        {$Globals['pp_lang']['move']}: <select name=\"catmove\" style=\"font-size: 9pt; background: FFFFFF;\">
                        $catoptions</select></td><td class=\"{$Style['menubarnb']}\" width=\"50%\" align=\"center\">";
                }

                if ( $Globals['userdel'] == "yes" || $ismod )
                {
                    $admindisplay .= "&nbsp;&nbsp;<input type=\"checkbox\" name=\"pdelete\" value=\"yes\" /> {$Globals['pp_lang']['deletephoto']}&nbsp;&nbsp;";
                }
                else
                {
                    $admindisplay .= "&nbsp;&nbsp;<input type=\"hidden\" name=\"pdelete\" value=\"no\" />";
                }

                $admindisplay .= "<input type=\"hidden\" name=\"ppaction\" value=\"movedel\" />
                                  <input type=\"hidden\" name=\"pid\" value=\"$id\" />
                                  <input type=\"hidden\" name=\"page\" value=\"$page\" />
                                  <input type=\"hidden\" name=\"limit\" value=\"$limit\" />
                                  <input type=\"hidden\" name=\"origcat\" value=\"$dbcat\" /></span>&nbsp;
                                  <input type=\"submit\" value=\"{$Globals['pp_lang']['submit']}\" /></td>
                                  </tr></table></form>";

                $output .= "extrainfo||$admindisplay\n";
            }
        }
    }
}

if ( $action == "addfav" )
{
    $julian = time();
    $q = ppmysql_query("SELECT userid,title FROM {$Globals['pp_db_prefix']}photos WHERE id=$photo LIMIT 1", $link);
    list( $puserid,$ptitle ) = mysql_fetch_row($q);

    ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET tags=(tags+1) WHERE id=$photo", $link);
    ppmysql_query("REPLACE INTO {$Globals['pp_db_prefix']}favorites values(NULL,'{$User['userid']}', $photo)", $link);

    $msgtext = get_string( "favmsg", "<a href=\"". construct_newppurl( "member.php", array('uid' => $User['userid'], 'username' => $User['username']) ) ."\">{$User['username']}</a>", "<a href=\"{$Globals['maindir']}/showphoto.php?photo=$photo\">$ptitle</a>" );
    send_ppmsg( $puserid, $msgtext, $photo, 'f' );

    $output .= "favorite||{$Globals['pp_lang']['added']}\n";
}

if ( $action == "delfav" )
{
    $result = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET tags=(tags-1) WHERE id=$photo", $link);
    $result = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}favorites WHERE photo=$photo AND userid='{$User['userid']}'", $link);
    $output .= "favorite||{$Globals['pp_lang']['removed']}\n";
}

if ( $action == "notify" )
{
    if ($Globals['usenotify'] == "yes")
    {
        $resulta = ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}notify (id,userid,photo) values(NULL,'{$User['userid']}',$photo)", $link);
        $output .= "notify||{$Globals['pp_lang']['enabled']}\n";
    }
}

if ( $action == "subscribe" )
{
    $message = null;

    if ( $User['userid'] > 1 || $photo )
    {
        if ( $Globals['usenotify'] == "yes" )
        {
            $resulta = ppmysql_query("SELECT id FROM {$Globals['pp_db_prefix']}notify WHERE userid='{$User['userid']}' AND photo=$photo AND type=1 LIMIT 1", $link);
            list( $nid ) = mysql_fetch_row($resulta);
            ppmysql_free_result( $resulta );

            if (empty($nid))
            {
                $resulta = ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}notify (id,userid,photo,type) values(NULL,'{$User['userid']}',$photo,1)", $link);
                $message = $Globals['pp_lang']['submsg'];
            }
            else
            {
                $resulta = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}notify WHERE photo=$photo AND userid='{$User['userid']}' AND type=1", $link);
                $message = $Globals['pp_lang']['unsubmsg'];
            }
        }
    }

    $output .= "subscribe||$message\n";
}

if ( $action == "nonotify" )
{
    $resulta = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}notify WHERE photo=$photo AND userid='{$User['userid']}'", $link);
    $output .= "notify||{$Globals['pp_lang']['disabled']}\n";
}

if ( $action == "open" )
{
    $q = ppmysql_query("SELECT userid,cat FROM {$Globals['pp_db_prefix']}photos WHERE id=$photo LIMIT 1", $link);
    list( $puserid, $dbcat ) = mysql_fetch_row($q);

    $ismod = ( $User['adminedit'] == 1 ? true : false );

    if ( $User['moderator'] == 1 )
    {
        $ismod = is_moderator($dbcat);
    }

    if ( $User['userid'] == $puserid || $ismod )
    {
        $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET allowcoms=1 WHERE id=$photo", $link);
        $output .= "close||{$Globals['pp_lang']['open']}\n";
    }
}

if ( $action == "close" )
{
    $q = ppmysql_query("SELECT userid,cat FROM {$Globals['pp_db_prefix']}photos WHERE id=$photo LIMIT 1", $link);
    list( $puserid, $dbcat ) = mysql_fetch_row($q);

    $ismod = ( $User['adminedit'] == 1 ? true : false );

    if ( $User['moderator'] == 1 )
    {
        $ismod = is_moderator($dbcat);
    }

    if ( $User['userid'] == $puserid || $ismod )
    {
        $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET allowcoms=2 WHERE id=$photo", $link);
        $output .= "close||{$Globals['pp_lang']['closedcom']}\n";
    }
}

if ( $action == "hide" )
{
    if ( $User['adminedit'] == 1 )
    {
        $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET approved=2 WHERE id=$photo", $link);

        // Let's update the category cache
        update_catcache();

        $output .= "hide||{$Globals['pp_lang']['hidden']}\n";
    }
}

if ( $action == "unhide" )
{
    if ( $User['adminedit'] == 1 )
    {
        $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET approved=1 WHERE id=$photo", $link);

        // Let's update the category cache
        update_catcache();

        $output .= "hide||{$Globals['pp_lang']['unhidden']}\n";
    }
}

if ( $action == "approve" )
{
    $resulta = ppmysql_query("SELECT cat FROM {$Globals['pp_db_prefix']}photos WHERE id=$photo LIMIT 1", $link);
    list( $pcat ) = mysql_fetch_row($resulta);

    $ismod = ( $User['adminedit'] == 1 ? true : false );

    if ( $User['moderator'] == 1 )
    {
        $ismod = is_moderator($pcat);
    }

    if ( $ismod )
    {
        $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET approved=1 WHERE id=$photo", $link);
        $output .= "approve||{$Globals['pp_lang']['unhidden']}\n";
    }
}

if ( $action == "stick" )
{
    if ( $User['adminedit'] == 1 )
    {
        $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET disporder=1 WHERE id=$photo", $link);
        $output .= "stick||{$Globals['pp_lang']['stuck']}\n";
    }
}

if ( $action == "unstick" )
{
    if ( $User['adminedit'] == 1 )
    {
        $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET disporder=99999 WHERE id=$photo", $link);
        $output .= "stick||{$Globals['pp_lang']['unstuck']}\n";
    }
}

echo $output;

?>
