<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2006, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

define( 'THIS_SCRIPT', "search" );
require "pp-inc.php";

function intarray($var)
{
    return (int)$var;
}

typecast($_GET, array('searchid' => INT, 'cpage' => INT, 'date' => INT));
typecast($_REQUEST, array('cat' => INT, 'final' => STRING, 'preview' => STRING, 'ppuser' => INT,
                        'what' => STRING, 'name' => STRING, 'condition' => STRING, 'keywords' => STRING,
                        'cats' => STRING, 'whenterm' => STRING, 'when' => INT));

authenticate();

if ( $Globals['ppboards'] == "closed" && $User['adminedit'] != 1 )
{
    diewell( $Globals['closedmsg'] );
}

if ( $Globals['searchreg'] == "yes" && $User['userid'] == 0 )
{
    diewell( $Globals['pp_lang']['searchreg'] );
}

$ipaddress = addslashes( findenv("REMOTE_ADDR") );

topmenu();

if ( $searchid )
{
    $squery = ppmysql_query("SELECT idlist,searchtype,searchterms,numresults,preview,searchdate FROM {$Globals['pp_db_prefix']}searchids WHERE searchid=$searchid LIMIT 1", $link);
    $sresult = mysql_fetch_assoc($squery);

    if ( !$sresult['idlist'] )
    {
        diewell( $Globals['pp_lang']['searchid'] );
    }

    $sresults = explode( ",", $sresult['idlist'] );
    $numresults = $sresult[numresults];

    $sterms = explode(" ", trim($sresult['searchterms']));
    $keyhtml = htmlspecialchars( $sresult['searchterms'] );
    $stype = $sresult['searchtype'];

    if ( $keyhmtl ) $keyhtml = "( $keyhtml )";

    $searchtype = $Globals['pp_lang']['callimages'];

    if ( $sresult['searchtype'] == "f" )
    {
        list( $tuserid, $tusername, $tmail ) = get_userinfo( "", $User['userid']);
        $searchtype = "$tusername {$Globals['pp_lang']['favorites']}";
    }
    elseif ( $sresult['searchdate'] == "1-d" )
    {
        $searchtype = $Globals['pp_lang']['clastday'];
    }
    elseif ( $sresult['searchdate'] == "1-w" )
    {
        $searchtype = $Globals['pp_lang']['clast7'];
    }
    elseif ( $sresult['searchdate'] == "2-w" )
    {
        $searchtype = $Globals['pp_lang']['clast14'];
    }
    elseif ( $sresult['searchdate'] > 0 )
    {
        $searchtype = formatppdate( $sresult['searchdate'] );
    }

    if ( $pperpage > 0 )
    {
        $pages = ($numresults/$pperpage);
    }
    else
    {
        $pperpage = ($Globals['thumbcols'] * 5);
        $pages = ($numresults/$pperpage);
    }
    $pwidth = intval(100 / $Globals['thumbcols']);

    if ( intval($pages) < $pages )
    {
        $pages = intval($pages)+1;
    }
    else
    {
        $pages = intval($pages);
    }

    if ( $cpage )
    {
        $cstartnumb = ($cpage*$pperpage)-$pperpage;
    }
    else
    {
        $cpage = 1;
        $cstartnumb = 0;
    }

    $idlist = null; $limitq = 0;
    for ( $x = $cstartnumb; $x < ($cstartnumb+$pperpage); $x++ )
    {
        if ( $sresults[$x] )
        {
            $idlist .= ( $idlist ? "," : "" ). $sresults[$x];
            $limitq++;
        }
    }

    if ( !$limitq || !$idlist )
    {
        diewell( $Globals['pp_lang']['nophotos'] );
    }

    $mcheck = true;
    if ( $Globals['mature'] == "yes" )
    {
        $mcheck = false;

        if ( $User['userid'] )
        {
            $mcheck = $User['mature'];
        }
    }

    if ( $stype == "p" || $stype == "f" )
    {
        $getsearch = ppmysql_query("SELECT id,user,userid,date,bigimage,cat,storecat,rating,title,description,ismature FROM {$Globals['pp_db_prefix']}photos WHERE id IN ($idlist) LIMIT $limitq", $link);
    }
    else
    {
        $getsearch = ppmysql_query("SELECT c.id,c.username,c.userid AS comuserid,c.date,c.rating,c.comment AS description,c.cat,c.photo,p.bigimage,p.cat,p.storecat,p.user,p.userid,p.title,p.ismature FROM {$Globals['pp_db_prefix']}comments c
            LEFT JOIN {$Globals['pp_db_prefix']}photos p ON p.id=c.photo WHERE c.id IN ($idlist) LIMIT $limitq", $link);
    }
    $itemnum = 0;

    while( $getphoto = mysql_fetch_assoc($getsearch) )
    {
        if ( ($getphoto[ismature] == 1 && $mcheck) || $getphoto[ismature] == 0 )
        {
            $results['cid'][$itemnum] = $getphoto[id];
            $getphoto['savetitle'] = $getphoto[title];

            if ( $sresult[searchtype] == "p" || $sresult[searchtype] == "f" )
            {
                $conurl = construct_newppurl( "showphoto.php", array('photo' => $getphoto['id'], 'title' => $getphoto['savetitle'], 'cat' => $getphoto['cat']) );
            }
            else
            {
                $conurl = construct_newppurl( "showphoto.php", array('photo' => $getphoto['photo'], 'title' => $getphoto['savetitle'], 'cat' => $getphoto['cat']) );
            }

            $ucuser[$itemnum] = "<a href=\"$conurl\">$getphoto[user]</a>";
            $cuserid[$itemnum] = $getphoto[userid];
            $imgtime[$itemnum] = formatpptime( $getphoto[date] );
            $imgdate[$itemnum] = formatppdate( $getphoto[date] );

            if ($getphoto[rating] > 0 && $Globals['allowrate'] == "yes" )
            {
                $ratingdisp[$itemnum] = "<br />{$Globals['pp_lang']['rating']}:&nbsp;<b>$getphoto[rating]</b>&nbsp;";
            }
            else
            {
                $ratingdisp[$itemnum] = null;
            }

            reset($sterms);
            foreach($sterms as $key)
            {
                $key = trim(addslashes($key));

                if ( $key )
                {
                    $getphoto[description] = preg_replace( "/($key)/i", "[i]$1[/i]", $getphoto[description] );
                    $getphoto[title] = preg_replace( "/($key)/i", "[i]$1[/i]", $getphoto[title] );
                }
            }

            $getphoto[title] = ( strlen($getphoto[title]) > 22 ? substr($getphoto[title],0,22)."..." : $getphoto[title] );
            $getphoto[title] = convert_markups($getphoto[title]);
            if ( $getphoto[title] )
            {
                $getphoto[title] = "<b>$getphoto[title]</b> ";
            }

            if ( $sresult[searchtype] == "c" )
            {
                $getphoto[title] .= "({$Globals['pp_lang']['commentby']} ". htmlspecialchars($getphoto[username]) .")";
            }

            if ( $getphoto[title] )
            {
                $getphoto[title] .= "<br /><br />";
            }

            $restitle[$itemnum] = convert_returns($getphoto[title]);

            if ( VB3_ENHANCEDINT == "on" )
            {
                $getphoto[description] = convert_markups(un_htmlspecialchars($getphoto[description]));
            }
            else
            {
                $getphoto[description] = convert_markups($getphoto[description]);
            }

            $restext[$itemnum] = convert_returns($getphoto[description]);

            $ccat[$itemnum] = $getphoto[cat];
            $cphoto[$itemnum] = $getphoto[id];

            $thumbrc[$itemnum] = null;

            if ( $sresult[preview] == 1 )
            {
                if ( $getphoto[storecat] )
                {
                    $getphoto[cat] = $getphoto[storecat];
                }

                $thisthumb = get_imagethumb( $getphoto[bigimage], $getphoto[cat], $getphoto[userid], 1 );

                if ( $sresult[searchtype] == "p" || $sresult[searchtype] == "f" )
                {
                    $conurl = construct_newppurl( "showphoto.php", array('photo' => $getphoto['id'], 'title' => $getphoto['savetitle'], 'cat' => $getphoto['cat']) );
                }
                else
                {
                    $conurl = construct_newppurl( "showphoto.php", array('photo' => $getphoto['photo'], 'title' => $getphoto['savetitle'], 'cat' => $getphoto['cat']) );
                }

                $thumbrc[$itemnum] = "<a href=\"$conurl\">$thisthumb</a><br />";
            }

            $itemnum++;
        }
    }

    $more = $less = "&nbsp;";

    if ( $cpage != $pages && $pages > 1 )
    {
        $nextpage = $cpage+1;
        $more = "<a href=\"{$Globals['maindir']}/search.php?searchid=$searchid&amp;cpage=$nextpage\">{$Globals['pp_lang']['nextpage']}</a>";
    }

    if ( $cpage > 1 )
    {
        $prevpage = $cpage-1;
        $less = "<a href=\"{$Globals['maindir']}/search.php?searchid=$searchid&amp;cpage=$prevpage\">{$Globals['pp_lang']['prevpage']}</a>";
    }

    printheader( 0, $Globals['pp_lang']['search'] );

    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/search-r.tmpl" );

    printfooter();
    exit;
}

if ( !$keywords && !$name && !$date && !$when && !$whenterm && !$what && !$cats )
{
    // Remove expired searches
    $expiredate = time() - ( $Globals['searchhold'] * 86400 );
    $queryq = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}searchids WHERE date < $expiredate", $link);

    $seltext = "selected=\"selected\"";

    if ( $cat > 0 )
    {
        $seltext = null;
        $selected = $cat;
    }

    catmoveopt(0,1);
    printheader( 0, $Globals['pp_lang']['search'] );

    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/search.tmpl" );

    printfooter();
}
else
{
    if ( !isset($what) )
    {
        $what = "allfields";
    }

    if ( !isset($name) )
    {
        $name = null;
    }

    if ( !isset($cats) || $cats == "all" )
    {
        $cats = null;
        $searchterm = "all";
    }

    if ( $User['userid'] > 0 )
    {
        $lasts = ppmysql_query("SELECT searchid,searchterms,name,date,searchtype,searchdate,cats FROM {$Globals['pp_db_prefix']}searchids WHERE userid={$User['userid']} ORDER BY date DESC LIMIT 5", $link);
    }
    else
    {
        // If not logged in, use ip address
        $lasts = ppmysql_query("SELECT searchid,searchterms,name,date,searchtype,searchdate,cats FROM {$Globals['pp_db_prefix']}searchids WHERE ipaddress='$ipaddress' ORDER BY date DESC LIMIT 5", $link);
    }

    $sresults = mysql_fetch_assoc($lasts);

    if ( $sresults['date'] )
    {
        $tdiff = time() - $sresults['date'];

        if ( $tdiff < $Globals['searchto'] )
        {
            $tdiff = $Globals['searchto'] - $tdiff;
            $prevsearches = null;

            do
            {
                $kwords = $Globals['pp_lang']['callimages'];

                if ( $sresults['searchterms'] )
                {
                    $kwords = $sresults['searchterms'];
                }
                elseif ( $sresults['name'] )
                {
                    $kwords = $sresults['name'];
                }
                elseif ( $sresults['searchtype'] == "f" )
                {
                    list( $tuserid, $tusername, $tmail ) = get_userinfo( "", $User['userid']);
                    $kwords = "$tusername {$Globals['pp_lang']['favorites']}";
                }
                elseif ( $sresults['searchdate'] == "1-d" )
                {
                    $kwords = $Globals['pp_lang']['clastday'];
                }
                elseif ( $sresults['searchdate'] == "7-d" )
                {
                    $kwords = $Globals['pp_lang']['clast7'];
                }
                elseif ( $sresults['searchdate'] == "2-w" )
                {
                    $kwords = $Globals['pp_lang']['clast14'];
                }

                if ( is_numeric($sresults['cats']) )
                {
                    $kwords = get_catname($sresults['cats']) . " - $kwords";
                }

                $prevsearches .= "<a href=\"{$Globals['maindir']}/search.php?searchid=$searchid\">". htmlspecialchars( $kwords ) ."</a><br />";
            } while ( $sresults = mysql_fetch_assoc($lasts) );

            $Globals['pp_lang']['searchwait'] = str_replace( "%tdiff%", $tdiff, $Globals['pp_lang']['searchwait'] );
            $Globals['pp_lang']['searchwait'] = str_replace( "%prevsearches%", $prevsearches, $Globals['pp_lang']['searchwait'] );

            diewell( $Globals['pp_lang']['searchwait'] );
        }
    }

    $mcats = null;

    if ( @is_array( $_POST['cats'] ) )
    {
        $filtercats = array_filter( $_POST['cats'], "intarray" );
        $mcats = addslashes(implode( ",", $filtercats ));
    }
    elseif ( @is_array( $_GET['cats'] ) )
    {
        $filtercats = array_filter( $_GET['cats'], "intarray" );
        $mcats = addslashes(implode( ",", $filtercats ));
    }
    elseif ( !empty($cats) )
    {
        $filtercats = array_filter( $cats, "intarray" );
        $mcats = addslashes(implode( ",", $filtercats ));
    }
    elseif ( $cat )
    {
        if ( $cat == 500 )
        {
            if ( $Globals['memformat'] == "no" )
            {
                $mcats = 500;
            }
        }
        else
        {
            $mcats = (int)$cat;

            if ( $mcats == 0 )
            {
                $mcats = "all";
            }
        }
    }

    // multiple cats
    if ( $mcats && $mcats != "all" )
    {
        $catcheck = " AND cat IN ($mcats)";
    }

    // time frame (days is default)
    if ( $when && $whenterm )
    {
        if ( $whenterm == "w" )
        {
            $days = ($when * 7);
        }
        elseif ( $whenterm == "m" )
        {
            $days = ($when * 30);
        }
        elseif ( $whenterm == "y" )
        {
            $days = ($when * 365);
        }
        else {
            $days = $when;
            $whenterm = "d";
        }

        $searchdate = time() - ($days * ((24 * 3600)));
        $datephrase .= " AND date > $searchdate";
        $searchterm = "$when-$whenterm";
    }

    if ( !empty($date) )
    {
        $thisdate = getdate($date);
        $thismonth = $thisdate['mon'];
        $thisyear  = $thisdate['year'];
        $thisday   = $thisdate['mday'];

    	$lowdate  = mktime(0, 0, 0, $thismonth, $thisday, $thisyear);
    	$highdate = mktime(0, 0, 0, $thismonth, $thisday+1, $thisyear);

        $datephrase = "AND date >= $lowdate AND date < $highdate";
        $searchdate = time() - ($days * ((24 * 3600)));
        $searchterm = $date;
    }

    if ( $what == "comments" )
    {
        $query = "SELECT id,cat FROM {$Globals['pp_db_prefix']}comments";
        $keyphrase = null;

        if ( $Globals['moderatecoms'] == "no" )
        {
            $keyphrase .= " AND approved=1";
        }

        // search terms
        $searchterms = explode(" ", trim($keywords));

        if ( !isset($condition) )
        {
            $condition = "AND";
        }

        if ( $condition == "or" )
        {
            $scond = "OR";
        }
        else
        {
            $scond = "AND";
        }

        foreach( $searchterms as $key )
        {
            $key = trim(addslashes($key));

            if ( $key )
            {
                $keyphrase .= " $scond ((comment LIKE \"% $key%\") OR (comment LIKE \"$key%\"))";
            }
        }

        if ( $name )
        {
            $keyphrase .= " AND (username LIKE '%$name%')";
        }
        elseif ( $ppuser > 0 )
        {
            if ( $ppuser != $User['userid'] )
            {
                $keyphrase .= " AND approved=1";
            }

            if ( $cat == 500 )
            {
                $keyphrase .= " AND (userid=$ppuser AND storecat=0)";
            }
            else
            {
                $keyphrase .= " AND (userid=$ppuser)";
            }
        }

        $query .= " WHERE comment != '' $catcheck $exclude_cat $keyphrase$datephrase ORDER BY date DESC LIMIT {$Globals['searchmax']}";

        $searchtype = "c";
        $preview = ( $preview == "yes" ? 1 : 0 );
    }
    else
    {
        if ( $what == "fav" && $User['userid'] > 0 )
        {
            $query = "SELECT p.id,p.cat FROM {$Globals['pp_db_prefix']}favorites f, {$Globals['pp_db_prefix']}photos p WHERE f.userid={$User['userid']} AND f.photo=p.id";
            $searchtype = "f";
        }
        else
        {
            $query = "SELECT id,cat FROM {$Globals['pp_db_prefix']}photos ";

            // search terms
            $searchterms = explode(" ", trim(un_htmlspecialchars($keywords)));
            $keyphrase = null;

            foreach ( $searchterms as $key )
            {
                $key = trim(addslashes($key));
                $key = str_replace( "%", "\%", $key);

                if ( $key )
                {
                    if ( !$condition )
                    {
                        $scond = "AND";
                    }
                    elseif ( $condition == "or" )
                    {
                        $scond = "OR";
                    }
                    else
                    {
                        $scond = "AND";
                    }

                    if ( $what == "allfields" )
                    {
                        $keyphrase .= ( empty($keyphrase) ? "AND " : "$scond " );

                        $keyphrase .= "((title LIKE \"% $key%\" OR description LIKE \"% $key%\" OR keywords LIKE \"% $key%\" OR bigimage LIKE \"% $key%\"
                            OR extra1 LIKE \"% $key%\" OR extra2 LIKE \"% $key%\" OR extra3 LIKE \"% $key%\" OR extra4 LIKE \"% $key%\" OR extra5 LIKE \"% $key%\" OR extra6 LIKE \"% $key%\")";
                        $keyphrase .= " OR (title LIKE \"$key%\" OR description LIKE \"$key%\" OR keywords LIKE \"$key%\" OR bigimage LIKE \"$key%\"
                            OR extra1 LIKE \"%$key%\" OR extra2 LIKE \"%$key%\" OR extra3 LIKE \"%$key%\" OR extra4 LIKE \"%$key%\" OR extra5 LIKE \"%$key%\" OR extra6 LIKE \"%$key%\"))";
                    }
                    elseif ( $what == "title" )
                    {
                        $keyphrase .= ( empty($keyphrase) ? "AND " : "$scond " );

                        $keyphrase .= "((title LIKE \"% $key%\") OR (title LIKE \"$key%\"))";
                    }
                    elseif ( $what == "titledesc" )
                    {
                        $keyphrase .= ( empty($keyphrase) ? "AND " : "$scond " );

                        $keyphrase .= "((title LIKE \"% $key%\" OR description LIKE \"% $key%\")";
                        $keyphrase .= " OR (title LIKE \"$key%\" OR description LIKE \"$key%\"))";
                    }
                    else
                    {
                        unset( $what );
                    }
                }
            }

            if ( $name )
            {
                $keyphrase .= " AND (user LIKE '%$name%')";
            }
  	        elseif ( $ppuser > 0 )
  	        {
  	            if ( $ppuser != $User['userid'] )
  	            {
  	                $keyphrase .= " AND approved=1";
  	            }
  
  	            if ( $cat == 500 )
  	            {
  	                $keyphrase .= " AND (userid=$ppuser AND storecat=0)";
  	            }
  	            else
  	            {
  	                $keyphrase .= " AND (userid=$ppuser)";
  	            }
  	        }

            $query .= "WHERE approved=1 AND storecat=0 $catcheck$keyphrase$datephrase ORDER BY date DESC LIMIT {$Globals['searchmax']}";
            $searchtype = "p";
        }

        $preview = 1;
    }

    $stime = microtime();
    $queryv = ppmysql_query($query, $link);
    $etime = microtime();

    $searchtime = ($etime - $stime);
    $ids = array();

    while ( list( $pid, $pcat ) = mysql_fetch_row($queryv) )
    {
        $is_private = is_image_private( $pcat );

        if ( $is_private == "no" )
        {
            $ids[] = $pid;
        }
    }

    $searchlist = implode( ",", $ids );
    $searchcount = count($ids);

    if ( $searchcount )
    {
        $keywords = addslashes($keywords);
        $dateterm = addslashes($dateterm);
        $mcats = addslashes($mcats);
        $name = addslashes($name);
        $julian = time();

        // Store the restuls
        $ressult = ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}searchids (searchid,userid,searchtype,searchterms,searchdate,cats,name,preview,idlist,numresults,ipaddress,searchtime,date)
                        VALUES ( NULL, {$User['userid']}, '$searchtype', '$keywords', '$searchterm', '$mcats', '$name', $preview, '$searchlist', $searchcount, '$ipaddress', '$searchtime', $julian)", $link );

        $searchid = mysql_insert_id( $link );

        forward( "search.php?searchid=$searchid", $Globals['pp_lang']['searchfor'] );
    }
    else
    {
        // No results
        diewell( $Globals['pp_lang']['searchnone'] );
        exit;
    }

}

?>
