<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

error_reporting(E_ALL & ~E_NOTICE & ~8192);  
define('PP_SCRIPT', 'PP_Pro');

function typecast(&$passtype, $typelist)
{
    foreach ($typelist AS $varname => $type)
    {
        if ( isset($passtype[$varname]) )
        {
            if ( $type == "INT" || $type == 2 )
            {
                $passtype[$varname] = (int)$passtype[$varname];
            }
            elseif ( $type == "STRING" )
            {
                if ( VB3_INTEGRATION == "off" )
                {
                    $passtype[$varname] = (ini_get("magic_quotes_gpc")) ? addslashes(htmlspecialchars(stripslashes(trim($passtype[$varname])))) : addslashes(htmlspecialchars(trim($passtype[$varname])));
                }
                else
                {
                    $passtype[$varname] = addslashes(htmlspecialchars(trim($passtype[$varname])));
                }
            }
            else
            {
                $passtype[$varname] = (ini_get("magic_quotes_gpc")) ? trim($passtype[$varname]) : addslashes(trim($passtype[$varname]));
            }

            unset( $GLOBALS[$varname] );

            $GLOBALS[$varname] = $passtype[$varname];
        }
        else
        {
            unset($GLOBALS[$varname]);
        }
    }
}

function typecast_wc($pattern, $type)
{
    // Let's import the GPC variables
    global $_GET, $_POST, $_COOKIE;

    foreach ($_GET AS $key => $val)
    {
        if ( @eregi("^".$pattern, $key) )
        {
            typecast($_GET, array( $key => $type));
        }
    }

    // Overwrites GET with POST
    foreach ($_POST as $key => $val)
    {
        if ( @eregi("^".$pattern, $key) )
        {
            typecast($_POST, array( $key => $type));
        }
    }
}

function un_htmlspecialchars($string)
{
    $string = str_replace(array('&lt;', '&gt;', '&quot;', '&amp;'), array('<', '>', '"', '&'), $string);
    $string = strip_tags($string, "<b><table><tr><td><strong><i><em><u><a><div><span><p><blockquote><ol><ul><li><font><img><br><h1><h2><h3><h4><h5><h6>");

    return $string;
}

// Init some system variables
$User = $Globals = array();
$bbuserinfo = null;

require "config-inc.php";
$ppstarttime = microtime();

if ( VB3_INTEGRATION == "off" )
{
    // Let's work from one variable
    if ( PHP_VERSION < '4.1.0' )
    {
        $_GET = &$HTTP_GET_VARS;
        $_POST = &$HTTP_POST_VARS;
        $_COOKIE = &$HTTP_COOKIE_VARS;
        $_SERVER = &$HTTP_SERVER_VARS;
        $_ENV = &$HTTP_ENV_VARS;
        $_FILES = &$HTTP_POST_FILES;
        $_REQUEST = array_merge($_GET, $_POST, $_COOKIE);
    }

    // Turn off the magic quoting
    @set_magic_quotes_runtime(0);
}

// Let's make sure we don't get anything we don't want...
if ( ini_get('register_globals') )
{
    // Unset the globals
    if( is_array($_GET) )
    {
        while( list($k, $v) = each($_GET) )
        {
            if ( is_array($v) )
            {
                die("Fatal Error in URL construction.");
            }

            unset($$k, $GLOBALS[$k]);
        }
    }

    if( is_array($_POST) )
    {
        while( list($k, $v) = each($_POST) )
        {
            unset($$k, $GLOBALS[$k]);
        }
    }

    if( is_array($_COOKIE) )
    {
        while( list($k, $v) = each($_COOKIE) )
        {
            unset($$k, $GLOBALS[$k]);
        }
    }
}

// set default language, if not set
if ( !isset($pplang) || empty($pplang) )
{
    $pplang = "english";
}

$Globals['PP_PATH']   = ".";
$Globals['TMPL_PATH'] = "templates";

// set PhotoPost path, if not set set it to "."
if ( $PP_PATH )
{
    $Globals['PP_PATH'] = $PP_PATH;
}

// set PhotoPost template path
if ( $TMPL_PATH )
{
    $Globals['TMPL_PATH'] = $TMPL_PATH;
}

if ( VB3_INTEGRATION == "on" )
{
    if ( VB40 == "on" )
    {
        $Globals['TMPL_PATH'] .= "/vb4enhanced";
    }
    else
    {
        $Globals['TMPL_PATH'] .= "/vb3enhanced";
    }

    // Allows for style overrides if the directory exists
    if ( is_dir( "$PP_PATH/{$Globals['TMPL_PATH']}/$styleid" ) )
    {
        $Globals['TMPL_PATH'] = "{$Globals['TMPL_PATH']}/$styleid";
    }
}

require "{$Globals['PP_PATH']}/languages/$pplang.php";

//===========================================================
// Connecting, selecting database
//===========================================================

if ( VB35 == "on" )
{
    // vB3.5 forces us to reverse the call method to conform to their new connect code
    $link = mysql_connect("$host", "$mysql_user", "$mysql_password") or die ('I cannot connect to the PhotoPost database. [$php_errormsg]');
    mysql_select_db ("$database", $link)or die("Could not connect to PhotoPost database". mysql_error() );

    if ( $host == $host_bb && $database == $database_bb && $mysql_user == $user_bb )
    {
        $db_link = $link;
    }
    else
    {
        $db_link = mysql_connect("$host_bb:3306", "$user_bb", "$password_bb") or die ("I cannot connect to the Members database. [$php_errormsg]");
        mysql_select_db("$database_bb", $db_link)or die("Could not connect to User database". mysql_error() );
    }
}
else
{
    $link = mysql_connect("$host:3306", "$mysql_user", "$mysql_password") or die ('I cannot connect to the PhotoPost database. [$php_errormsg]');
    mysql_select_db ("$database", $link)or die("Could not connect to PhotoPost database". mysql_error() );

    if ( $host == $host_bb && $database == $database_bb && $mysql_user == $user_bb )
    {
       $db_link = $link;
    }
    else
    {
        $db_link = mysql_connect("$host_bb", "$user_bb", "$password_bb") or die ("I cannot connect to the Members database. [$php_errormsg]");
        mysql_select_db("$database_bb", $db_link)or die("Could not connect to User database". mysql_error() );
    }
}

// Let's get all our settings....
$getsets = ppmysql_query("SELECT varname,setting FROM {$pp_db_prefix}settings", $link);

if ( !$getsets )
{
    print "Database not properly setup - unable to read {$pp_db_prefix}settings table. Contact administrator.";
    exit;
}

while ( list($var, $set) = mysql_fetch_row($getsets))
{
    $Globals[$var] = stripslashes($set);
}
mysql_free_result($getsets);

// These variables come from the config-inc.php, placed here so in the Global array
$Globals['pplang'] = $pplang;
$Globals['zip_command'] = $zip_command;
$Globals['mogrify_command'] = $mogrify_command;
$Globals['pp_db_prefix'] = $pp_db_prefix;
$Globals['printheader'] = "no";
$Globals['vblicense'] = $vblicense;

if ( $Globals['vbversion'] == "xenforo" && $Globals['forumstyle'] == "yes" )
{
        $Globals['TMPL_PATH'] .= "/xenforo";
}

// Load limiter (are we overloaded?)
if ( $Globals['loadlimit'] > 0 && $User['adminedit'] == 0 )
{
    if (@file_exists('/proc/loadavg') && $filestuff = @file_get_contents('/proc/loadavg'))
    {
        $loadavg = explode(' ', $filestuff);
        if (trim($loadavg[0]) > $Globals['loadlimit'])
        {
           print $Globals['pp_lang']['overload'];
           exit;
        }
    }
}

// Nope, so continue...
if ( $Globals['vbulletin'] == "/" )
{
    $Globals['vbulletin'] = null;
}

// If the stylesheets/theme directory exists, use those images
if ( is_dir( "$PP_PATH/stylesheets/{$Globals['theme']}" ) )
{
    $Globals['idir'] = "{$Globals['maindir']}/stylesheets/{$Globals['theme']}";
}

// need to fix a couple variables to prevent problems
$Globals['maindir'] = trim( $Globals['maindir'] );

// Get our cached data
$lasttimeon = time();

if ( THIS_SCRIPT != "upgrade" )
{
    if ( $Globals['cachetimeout'] == 0 )
    {
        // No caching
        $updatecache = true;
    }
    else
    {
        // Depending on the page, we don't need all the cached data (just saves space this way)
        $cachevars = "timestamp,statscache";

        if ( $Globals['catcache'] == "yes" )
        {
            // Are we caching category info as well?
            $cachevars .= ",catcache,catprops";
        }

        if ( THIS_SCRIPT == "ppindex" )
        {
            // Anything else?
            if ( $Globals['calpal'] == "yes" ) $cachevars .= ",calcache";
            if ( $Globals['mostrecent'] == "yes" ) $cachevars .= ",recentcache";
            if ( $Globals['disrandom'] == "yes" || $Globals['randompal'] == "yes" ) $cachevars .= ",randomcache";
            if ( $Globals['dispopular'] == "yes" ) $cachevars .= ",popularcache";
        }
        elseif ( (THIS_SCRIPT == "showgallery" || THIS_SCRIPT == "showmembers" || THIS_SCRIPT == "showphoto" || THIS_SCRIPT == "subscriptions") && $Globals['sidebar_global'] == "yes" )
        {
            if ( $Globals['calpal'] == "yes" )
            {
                $cachevars .= ",calcache";
            }
        }

        $totalv = ppmysql_query("SELECT $cachevars FROM {$Globals['pp_db_prefix']}cache WHERE id=1", $link);
        $cacheq = mysql_fetch_array($totalv);

        // timestamp is the time of the next scheduled update; do we need to update cache?
        $updatecache = false;

        if ( $cacheq['timestamp'] < $lasttimeon )
        {
            $updatecache = true;
        }

        if ( isset($cacheq['catcache']) )
        {
            $cacheq['catcache'] = unserialize($cacheq['catcache']);
        }

        if ( isset($cacheq['catcache']) )
        {
            $cacheq['catprops'] = unserialize($cacheq['catprops']);
        }
    }
}

// Get the thumbnail templates
include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/{$Globals['thumbborder']}.tmpl" );

// If they want compression, enable it!
if ( $Globals['compression'] == "yes" && !isset($disableforadmin) )
{
    $phpa = phpversion();
    $phpv = $phpa[0] . "." . $phpa[2] . $phpa[4];
    if (($phpv > 4.0004) && extension_loaded("zlib") && !ini_get("zlib.output_compression") && !ini_get("output_handler"))
    {
        ob_start("ob_gzhandler");
    }
}

if ( $Globals['cjurl'] != "" )
{
    if ( $Globals['cjurl'] != "" )
    {
        $Globals['cright'] = str_replace( "", $Globals['cjurl'], $Globals['cright'] );
    }
}

if ( VB3_INTEGRATION == "on" )
{
    $Globals['cright'] = str_replace( "--replaceme--", "PHP vB3 Enhanced", $Globals['cright'] );
}
else
{
    $Globals['cright'] = str_replace( "--replaceme--", "PHP", $Globals['cright'] );
}

$menu = $posternav = null;

// handler to hand all mysql_queries
function ppmysql_query( $query, $database )
{
    global $Globals, $User;

    $mysql_eval_error = null;
    $qstarttime = microtime();
    $mysql_eval_result = mysql_query($query, $database);
    $qendtime = microtime();

    $starttime = explode(" ", $qstarttime);
    $endtime = explode(" ", $qendtime);

    $totaltime = $endtime[0] - $starttime[0] + $endtime[1] - $starttime[1];
    $totaltime = number_format( $totaltime, 5 );

    $Globals['number_queries']++;
    $Globals['queries'][] = $query;
    $Globals['timing'][] = $totaltime;

    if ( !$mysql_eval_result )
    {
        $mysql_eval_error = mysql_error($database);

        if ( $Globals['debug'] == 1 )
        {
            $letter = "An error was encountered during execution of the query:\n\n";
            $letter .= $query."\n\n";
            $letter .="The query returned with an errorcode of: \n\n$mysql_eval_error\n\n";
            $letter .= "If you need assistence or feel this is a 'bug'; please report it to our ";
            $letter .= "support forums at: http://www.photopost.com/members/forum/f66/index.html\n\n";
            $letter .= "To turn off these emails, set \$debug=0 in your config-inc.php file.";

            $email = $Globals['adminemail'];
            $email_from = "From: {$Globals['adminemail']}";

            $subject="Subject: {$Globals['webname']} MySQL Error Report";
            $subject = trim($subject);

            mail( $email, $subject, $letter, $email_from );
        }
        elseif ( $Globals['debug'] == 2 )
        {
            $what = findenv("PHP_SELF");
            $script['0'] = null;
            preg_match ("/(.*)\/(.*).php/", $what, $script);
            $what = $script['2'];

            $errormsg = "We're sorry, but the system experienced an unrecoverable error. Please try again later.";

            if ( $User['adminedit'] == 1 )
            {
                $errormsg .= "<br /><br />Script: $what<br /><br />Query: $query<br /><br />Result: $mysql_eval_error<br /><br />Database handle: $database";
            }

            diewell( $errormsg );
        }
        $mysql_eval_result = FALSE;
    }

    return $mysql_eval_result;
}


function ppmysql_free_result( $result )
{
    return @mysql_free_result($result);
}


function ppmysql_query_one( $query, $database = NULL )
{
    global $Globals, $User, $link;

    if ( !$database ) $database = $link;

    $q = ppmysql_query( $query, $database );

    $r = null;
    if ( $q )
    {
        $r = mysql_fetch_assoc( $q );
    }

    return( $r );
}

function ppmysql_query_onerow( $query )
{
    global $Globals, $User, $link;

    $q = ppmysql_query( $query, $link );

    $r = array( null );
    if ( $q )
    {
        $r = mysql_fetch_row( $q );
    }

    return( $r );
}


function printheader( $thecat, $titlereplace, $slideshow=0, $printheader="yes", $filename="", $other=0 ) {
    global $Globals, $User, $CatPerms, $Style, $link, $slidedelay, $slideurl, $vbheader, $vbnoheader;
    global $contentmeta, $doctype, $ppuser, $metadesc, $metakey;

    if ( $Globals['printheader'] == "yes" )
    {
        return;
    }

    $rsslink = null;
    $more = ( $thecat ? "&amp;cat=$thecat" : null );
    $more .= ( $ppuser ? "&amp;ppuser=$ppuser" : null );

    if ( VB3_INTEGRATION == "on" && stristr( $vbheader, "RSS2" ) )
    {
        $vbheader = str_replace( "type=RSS2", "type=RSS2$more", $vbheader );
        $vbheader = str_replace( "{$Globals['vbulletin']}/external.php", "{$Globals['maindir']}/external.php", $vbheader );
        $vbheader = str_replace( "\"external.php", "\"{$Globals['maindir']}/external.php", $vbheader );
        $vbheader = str_replace( "title=\"", "title=\"{$Globals['galleryname']}", $vbheader );
    }
    else
    {
        $rsslink = "<link rel=\"alternate\" type=\"application/rss+xml\" title=\"RSS Feed\" href=\"{$Globals['maindir']}/external.php?type=RSS2$more\" />";
    }

    if ( $other ) $thiscat = $other;
    else $thiscat = $thecat;

    if ( !is_numeric($thecat) )
    {
        $thecat = 500;
    }

    if ( $slideshow == 1 && $Globals['slidehead'] == "no" )
    {
        $printheader = "no";
    }

    if ( $slideshow == 1 )
    {
        $refreshlink = str_replace( "&amp;", "&", $slideurl );
        $slidems = $slidedelay * 1000;

        $headslide = "<noscript><meta http-equiv=\"refresh\" content=\"$slidedelay; URL=$refreshlink\"></noscript>";
        $headslide .= "
<script type=\"text/javascript\">
<!--
timer = setTimeout(\"location.replace('$refreshlink')\", $slidems);
function stopslideshow() {
clearTimeout(timer);
var sspause = document.getElementById('sspause');
if (sspause) { sspause.style.display = 'none'; }
var ssresume = document.getElementById('ssresume');
if (ssresume) { ssresume.style.display = ''; } }
function resumess(url) { location.replace('$refreshlink'); }
-->
</script>";
    }
    else {
        $headslide = null;
    }

    $ajaxcode = null;
    $tvar = $Globals['idir'];

    if ( THIS_SCRIPT == "uploadphoto" && $Globals['flashupload'] == "yes" && $User['userid'] > 0 )
    {
    	$session = session_id();

        $filetypes = $Globals['acceptimg'] . ";" . $Globals['acceptmm'];
        $filetypes = str_replace( array(",", "."), array(";","*."), $filetypes );
        $maxpostsize = round($Globals['mmuploadsize'] / 1024);

$ajaxcode = <<<PPPRINT
    	<link href="{$Globals['maindir']}/stylesheets/flashuploader.css" rel="stylesheet" type="text/css" />
    	<script type="text/javascript" src="{$Globals['maindir']}/js/swfupload.js"></script>
    	<script type="text/javascript" src="{$Globals['maindir']}/js/swfupload.queue.js"></script>
    	<script type="text/javascript" src="{$Globals['maindir']}/js/fileprogress.js"></script>
    	<script type="text/javascript" src="{$Globals['maindir']}/js/handlers.js"></script>
    	<script type="text/javascript" src="{$Globals['maindir']}/js/flashdetect.js"></script>
    	<script type="text/javascript">

    	// -----------------------------------------------------------------------------
    	// Globals
    	// Major version of Flash required
    	var requiredMajorVersion = 9;
    	// Minor version of Flash required
    	var requiredMinorVersion = 0;
    	// Minor revision of Flash required
    	var requiredRevision = 0;
    	// -----------------------------------------------------------------------------

    		var swfu;

    		window.onload = function() {
    			var settings = {
    				flash_url : "{$Globals['maindir']}/js/swfupload.swf",
    				upload_url: "{$Globals['maindir']}/upload.php",	// Relative to the SWF file
    				post_params: {"PHPSESSID" : "{$session}","userid" : "{$User['userid']}"},
    				file_size_limit : "$maxpostsize MB",
    				file_types : "$filetypes",
    				file_types_description : "Image & Movie Files",
    				file_upload_limit : 250,
    				file_queue_limit : 0,
    				custom_settings : {
    					progressTarget : "fsUploadProgress",
    					cancelButtonId : "btnCancel"
    				},
    				debug: false,

        			// Button settings
                    button_placeholder_id: "spanButtonPlaceHolder",
                    button_image_url: "{$Globals['maindir']}/images/XPButtonUpload.png",
                    button_width : 160,
                    button_height : 22,
                    button_text: '<span class="theFont">Select Files for Upload</span>',
                    button_text_style: ".theFont { font-family: verdana,geneva; font-size: 12px; }",
                    button_text_left_padding: 5,
                    button_text_top_padding: 1,
                    button_action : SWFUpload.BUTTON_ACTION.SELECT_FILES,
                    button_disabled : false,
                    button_cursor : SWFUpload.CURSOR.HAND,
                    button_window_mode : SWFUpload.WINDOW_MODE.TRANSPARENT,

    				// The event handler functions are defined in handlers.js
    				file_queued_handler : fileQueued,
    				file_queue_error_handler : fileQueueError,
    				file_dialog_complete_handler : fileDialogComplete,
    				upload_start_handler : uploadStart,
    				upload_progress_handler : uploadProgress,
    				upload_error_handler : uploadError,
    				upload_success_handler : uploadSuccess,
    				upload_complete_handler : uploadComplete,
    				queue_complete_handler : queueComplete	// Queue plugin event
    			};

    			swfu = new SWFUpload(settings);
    	     };
    	</script>
PPPRINT;
    }

    if ( THIS_SCRIPT == "showgallery" || THIS_SCRIPT == "member" || THIS_SCRIPT == "showphoto" || THIS_SCRIPT == "ppindex" )
    {
$ajaxcode = <<<PPPRINT
<script type="text/javascript" language="javascript">
<!--
function createXMLHttpRequest() {
    var ua;

    if(window.XMLHttpRequest) {
        try {
            ua = new XMLHttpRequest();
        } catch(e) {
            ua = false;
        }
    } else if(window.ActiveXObject) {
        try {
            ua = new ActiveXObject("Microsoft.XMLHTTP");
        } catch(e) {
            ua = false;
        }
    }
    return ua;
}

var req = createXMLHttpRequest();

function sendPhotoReq(photo,cat,orig,limit,sortby,sortdir,sorttime,ppuser) {
        req.open('get', '{$Globals['maindir']}/showframe.php?action=thumbs&photo='+photo+'&cat='+cat+'&orig='+orig+'&limit='+limit+'&sortby='+sortby+'&sortdir='+sortdir+'&sorttime='+sorttime+'&ppuser='+ppuser);
        req.onreadystatechange = handleResponse;
        req.send(null);
}

function sendFeatReq(feature,ispal,cat) {
        req.open('get', '{$Globals['maindir']}/showframe.php?action=feature&feature='+feature+'&ispal='+ispal+'&cat='+cat);
        req.onreadystatechange = handleResponse;
        req.send(null);
}

function sendCalReq(month,year) {
        req.open('get', '{$Globals['maindir']}/showframe.php?action=cal&month='+month+'&year='+year);
        req.onreadystatechange = handleResponse;
        req.send(null);
}

function sendInfoReq(what,photo) {
        req.open('get', '{$Globals['maindir']}/showframe.php?action='+what+'&photo='+photo);
        req.onreadystatechange = handleResponse;
        req.send(null);
}

function handleResponse() {
    if(req.readyState == 4){
        var response = req.responseText;
        var update = new Array();

        if(response.indexOf('||' != -1)) {
            update = response.split('||');
            document.getElementById(update[0]).innerHTML = update[1];
        }
    }
}
function showcodes(){
    document.getElementById('showcodes').style.display='';
}
//-->
</script>
PPPRINT;
    }

    $nocachetag = "<!-- no cache headers -->
<meta http-equiv=\"pragma\" content=\"no-cache\" />
<meta http-equiv=\"expires\" content=\"Sat, 01 Dec 2001 00:00:00 GMT\" />
<meta http-equiv=\"cache-control\" content=\"no-cache, must-revalidate\" />
<!-- end no cache headers -->\n";

    if ( $metadesc && VB3_INTEGRATION == 'off' )
    {
        $contentmeta .= "\n<meta name=\"description\" content=\"$metadesc\" />\n";
    }

    if ( $metakey && VB3_INTEGRATION == 'off' )
    {
        $contentmeta .= "<meta name=\"keywords\" content=\"$metakey\" />\n";
    }

    $javapopup = "<script type=\"text/javascript\" language=\"javascript\">
        <!--
        var pppath = '$tvar';

        var PopUpHelpX = (screen.width/2)-150;
        var PopUpHelpY = (screen.height/2)-200;
        var pos = \"left=\"+PopUpHelpX+\",top=\"+PopUpHelpY;
        function PopUpHelp(url){
        PopUpHelpWindow = window.open(\"{$Globals['maindir']}/\"+url,\"Smilies\",\"scrollbars=yes,width=550,height=400,\"+pos);
        }
        //-->
        </script>\n";

    if ( !stristr( $vbheader, "lightbox.css" ) )
    {
        $javapopup .= "<link rel=\"stylesheet\" href=\"{$Globals['maindir']}/stylesheets/lightbox.css\" type=\"text/css\" media=\"screen\" />\n";
    }

    if ( THIS_SCRIPT == "showphoto" && $Globals['lightbox'] == "yes" )
    {
        $javapopup .= "<script type=\"text/javascript\" src=\"{$Globals['maindir']}/js/prototype.js\"></script>\n
            <script type=\"text/javascript\" src=\"{$Globals['maindir']}/js/effects.js\"></script>\n
            <script type=\"text/javascript\" src=\"{$Globals['maindir']}/js/scriptaculous.js?load=effects\"></script>\n
            <script type=\"text/javascript\" src=\"{$Globals['maindir']}/js/lightbox.js\"></script>\n";
    }

    if ( THIS_SCRIPT == "showphoto" && $Globals['zoom'] == "yes" )
    {
$javapopup .= <<<PPPRINT
<script type="text/javascript" src="{$Globals['maindir']}/js/tjpzoom.js"></script>
<script type="text/javascript" language="javascript">
<!--
var TJPzoomwidth=160;
var TJPzoomheight=120;
var TJPzoomwindowlock=0;
var TJPzoomoffsetx=.5;
var TJPzoomoffsety=.5;
var TJPzoomamount=4;
var TJPzoomamountmax=12;
var TJPzoomamountmin=1;
var TJPborderthick=2;
var TJPbordercolor='#cccccc';
var TJPshadowthick=8;
var TJPshadow='{$Globals['maindir']}/js/';
//-->
</script>
<script type="text/javascript" src="{$Globals['maindir']}/js/instant.js"></script>
PPPRINT;
    }

    if ( $filename )
    {
        if( stristr($filename, ".mov") )
        {
$javapopup .= <<<JAVAADD
    <script language="javascript" src="{$Globals['maindir']}/js/quicktimedetect.js"></script>
    <script type="text/javascript" language="javascript">
    <!--
        var haveQT = false;
        pluginFound = detectPlugin('QuickTime');
        if (!pluginFound && detectableWithVB)
            pluginFound = detectQuickTimeActiveXControl();
        haveQT = pluginFound;
    //-->
    </script>
JAVAADD;
        }
    }

    $stylesheet = get_forum_style();

    // Read in the header tags file
    if ( file_exists($Globals['headtags']) )
    {
        $filearray = file( $Globals['headtags'] );
        $headtags = implode( " ", $filearray );
    }
    else
    {
        $headtags = null;
    }

    if ( !empty($vbheader) )
    {
        if ( $printheader == "yes" )
        {
            $theader = $vbheader;
        }
        else
        {
            $theader = $vbnoheader;
        }

        $theader = str_replace( "<meta name=\"keywords\" content=\"","<meta name=\"keywords\" content=\"$metakey, ", $theader);
        $theader = str_replace( "<meta name=\"description\" content=\"","<meta name=\"description\" content=\"$metadesc, ", $theader);
        $theader = str_replace( "{tablewidth}", $Globals['tablewidth'], $theader);
        $theader = str_replace( "{pagebgcolor}", $Globals['forwardbod'], $theader);
        $theader = str_replace( "<head>","<head><title>{$titlereplace} - {$Globals['galleryname']}</title>", $theader );
        $theader = str_replace( "{ppheader}", "$nocachetag $headtags $javapopup $headslide $ajaxcode $rsslink", $theader);

        print $theader;
    }
    else
    {
        $newheader = $Globals['header'];

        if ( isset($CatPerms['headtags'][$thecat]) && file_exists($CatPerms['headtags'][$thecat]) )
        {
            $headtags = implode( " ", file($CatPerms['headtags'][$thecat]) );
        }

        if ( isset($CatPerms['footer'][$thecat]) && file_exists($CatPerms['footer'][$thecat]) )
        {
            $Globals['footer'] = $CatPerms['footer'][$thecat];
        }

        if ( isset($CatPerms['header'][$thecat]) && file_exists($CatPerms['header'][$thecat]) )
        {
            $newheader = $CatPerms['header'][$thecat];
        }

        $header = "$doctype
<html xmlns=\"http://www.w3.org/1999/xhtml\">
<head>
<title>{$titlereplace} - {$Globals['galleryname']}</title>
$contentmeta
$nocachetag
$headtags
$javapopup
$headslide
$stylesheet
$ajaxcode
$rsslink
</head>
<body>";

        if ( file_exists($newheader) )
        {
            print $header;

            if ( $printheader == "yes" )
            {
                @include( $newheader );
            }
        }
        else
        {
            print $header;
        }
    }

    //
    // Now lets put them into the Who's Online table
    //
    if ( $Globals['onlinepal'] == "yes" || $Globals['displayonline'] == "yes" )
    {
        update_whoonline( $thiscat );

        // Cleanup old records (number of seconds)
        if ( THIS_SCRIPT == "ppindex" )
        {
            $expire = time() - 3600;
            $resultb = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}iponline WHERE date < $expire", $link);
        }
    }

    // Does the admin need a reminder?
    if ( $Globals['ppboards'] == "closed" && $User['adminedit'] == 1 )
    {
        echo "<div align=\"center\"><span class=\"{$Style['onbody']}\"><br />Your boards are currently closed!<br /><br /></span></div>";
    }

    // That's it!
    $Globals['printheader'] = "yes";

    return;
}

function printfooter( $headers = "yes" )
{
    global $Globals, $CatPerms, $User, $Style, $vbfooter, $ppstarttime;

    // Removing the line below constitutes a violation of your License Agreement
    // and will result in significant penalities if removed.
    print "<div align=\"center\"><span class=\"{$Style['onbody']}\">{$Globals['cright']}</span></div><br />";

    // Set this to 1 if you want to see debug information (only prints for admins)
    // Set this to 2 is you want to print out queries and timing info
    $showsqldebug = 0;

    $ppendtime = microtime();
    $starttime = explode(" ", $ppstarttime);
    $endtime = explode(" ", $ppendtime);

    $totaltime = $endtime[0] - $starttime[0] + $endtime[1] - $starttime[1];
    $totaltime = number_format( $totaltime, 5 );

    if ( $showsqldebug > 0 && $headers == "yes" )
    {
        print "<br /><div align=\"center\"><span class=\"{$Style['onbody']}\"><font size=\"1\">Page generated in $totaltime seconds with {$Globals['number_queries']} queries<br />";
        if ( $User['adminedit'] == 1 && $showsqldebug == 2 )
        {
            for ($x = 0; $x < count($Globals['queries']); $x++ )
            {
                print ($x+1). ": {$Globals['queries'][$x]} ({$Globals['timing'][$x]} sec)<br />";
            }
        }
        print "</font></span></div>";
    }

    if ( !empty($vbfooter) && $headers != "no" )
    {
        print $vbfooter;
    }
    else
    {
        if ( $headers == "yes" && file_exists($Globals['footer']) )
        {
            @include( $Globals['footer'] );
        }
    }

    print "</body></html>";

    return;
}


function get_ext( $filename )
{
    return substr( $filename, strrpos($filename,".") );
}

function get_filename($filename)
{
    return str_replace( get_ext($filename), "", $filename );
}


function is_cat_protected( $cat, $password, $cattype = "c" )
{
    global $Globals, $childnav, $menu, $User, $link, $CatPerms;

    // Admins and owners get a free pass
    if ( $User['adminedit'] == 1 || ($cattype == "a" && $User['userid'] == $CatPerms['parent'][$cat]) )
    {
        return( true );
    }

    if ( $cattype == "c" )
    {
        if ( $CatPerms['ugview'][$cat] == 1 && !$password )
        {
            diewell( $Globals['pp_lang']['nopermcat'] );
        }
    }
    else
    {
        if ( $CatPerms['ugview'][500] == 1 && !$password )
        {
            diewell( $Globals['pp_lang']['nopermcat'] );
        }
    }

    $catpass = walk_tree( $cat );

    if ( trim($catpass) != "" )
    {
        if ( strcmp($password, $catpass) )
        {
            get_password( $cat );
            exit;
        }
    }

    return( true );
}


function is_image_private($catid)
{
    global $Globals, $User, $link, $CatPerms, $catp;

    // Never private for admins
    if ( $User['adminedit'] == 1 )
    {
        return( "no" );
    }

    // Lets check everything else
    if ( $CatPerms['cattype'][$catid] == "a" )
    {
        $CatPerms['ugview'][$catid] = $CatPerms['ugview'][500];
    }

    if ( $CatPerms['ugview'][$catid] == 1 )
    {
        return( "yes" );
    }

    if ( trim($CatPerms['catpass'][$catid]) != "" && $catp != $CatPerms['catpass'][$catid] )
    {
        return( "yes" );
    }

    return( "no" );
}


function get_thumbtmpl( $id, $imgtag, $height, $width, $thumbtag, $whichcat = -1, $thislink = null, $title = null, $boxcolor = null )
{
    global $Globals, $limit, $size, $cat, $page, $sortby, $sorttime, $way, $memrec, $storecat;

    if ( $boxcolor == null )
    {
        $boxcolor = $Globals['framecolor'];
    }

    if ( $_REQUEST['si'] && $_REQUEST['cat'] == 500 )
    {
        $_REQUEST['si'] = null;
    }

    if ( !empty($thislink) )
    {
        $murl = "<a href=\"$thislink\">";
    }
    else
    {
        if ( $whichcat == -1 || $whichcat == "most_views" || $whichcat == "latest" || $whichcat == "random" || $whichcat == "favorites")
        {
            $murl = "<a href=\"" . construct_newppurl( "showphoto.php", array( 'photo' => $id, 'title' => $title, 'cat' => $cat) ) . "\">";
            $limit = $oldlimit;
        }
        else
        {
            $murl = "<a href=\"" . construct_newppurl( "showgallery.php", array( 'cat' => $whichcat, 'ppuser' => $memrec['userid']) ) . "\">";
        }
    }

    $mthumb = $murl . $imgtag . "</a>";

    // Process the thumb varibales
    if ( isset($Globals['thumbstd']) )
    {
        $workthumb = $Globals['thumbstd'];
    }
    elseif ( $height > $width )
    {
        $workthumb = $Globals['thumbpor'];
    }
    else
    {
        $workthumb = $Globals['thumblan'];
    }

    $thumbtag = str_replace( "{pthumbtag}", $thumbtag, $workthumb );
    $thumbtag = str_replace( "{thislink}", $murl, $thumbtag );
    $thumbtag = str_replace( "{mthumb}", $mthumb, $thumbtag );
    $thumbtag = str_replace( "{boxcolor}", $boxcolor, $thumbtag );

    return($thumbtag);
}

function display_gallery($q_switch, $showuser="", $showcat="", $overcol=0, $overnum=0, $ispal=0)
{
    global $Globals, $User, $Style, $ppopen, $ppclose, $link, $cat, $CatPerms, $stylevar, $vbcollapse, $thumbtag, $limit;
    global $updatecache, $cacheq, $lasttimeon, $ismature;

    $rcols = ( $overcol == 0 ? $Globals['recentcols'] : $overcol );
    $rphotos = ( $overnum == 0 ? $Globals['recentnum'] : $overnum );

    // Some fudges to try and give people more images should they be restricted to some in the current list
    if ( !$updatecache && ($User['userid'] && $User['mature']) )
    {
        $grabnum = $Globals['recentnum'] + 5;
    }
    else
    {
        $grabnum = $Globals['recentnum'] + 25;
    }

    $catquery = $userq = null;
    $query = $localupd = false;

    $twidth = round(100/$rcols);

    if ( $cat == 500 )
    {
        $catname = "{$Globals['pp_lang']['gallery']}";
        $catquery = 500;
    }
    elseif ( !empty($cat) )
    {
        if ( is_numeric($cat) )
        {
            $catname = $CatPerms['catname'][$cat];
            $cattype = $CatPerms['cattype'][$cat];
            $catchildren = $CatPerms['children'][$cat];

            $catquery = $cat;
            if ( $catchildren )
            {
                $catquery .= ",$catchildren";
            }
        }
        elseif ( $cat != "all" )
        {
            $catquery = 500;
        }
    }

    if ( $showuser )
    {
        $userq = " AND userid=$showuser";

        list( $tuserid, $tusername, $tmail ) = get_userinfo("", $showuser);
        $catname = "$tusername's $catname";
    }

    if ( $catquery )
    {
        $catquery = " AND cat IN ($catquery)";
    }

    if ( $catname )
    {
        $catname = "<br />[$catname]";
    }

    $morephotos = null;
    switch ($q_switch)
    {
        case "latest":
            if ( !$cat && !$showuser && !$catquery )
            {
                if ( $updatecache || empty($cacheq['recentcache']) )
                {
                    $group_title = "{$Globals['pp_lang']['mostrecent']} &middot; <a title=\"popular photos\" href=\"javascript:sendFeatReq('most_views','$ispal',0);\">{$Globals['pp_lang']['popular']}</a> &middot; <a title=\"random photos\" href=\"javascript:sendFeatReq('random','$ispal',0);\">{$Globals['pp_lang']['randoms']}</a>";
                    $query = "SELECT id,user,userid,cat,storecat,title,ismature,bigimage,height,width FROM {$Globals['pp_db_prefix']}photos WHERE approved=1 AND storecat=0 ORDER BY date DESC LIMIT $grabnum";
                    $localupd = "recentcache";
                }
                else
                {
                    $group_title = "{$Globals['pp_lang']['mostrecent']} &middot; <a title=\"popular photos\" href=\"javascript:sendFeatReq('most_views','$ispal',0);\">{$Globals['pp_lang']['popular']}</a> &middot; <a title=\"random photos\" href=\"javascript:sendFeatReq('random','$ispal',0);\">{$Globals['pp_lang']['randoms']}</a>";
                    $results = unserialize( $cacheq['recentcache'] );
                }
            }
            else
            {
                $query = "SELECT id,user,userid,cat,storecat,title,ismature,bigimage,height,width FROM {$Globals['pp_db_prefix']}photos WHERE approved=1 AND storecat=0 $userq $catquery ORDER BY date DESC LIMIT $grabnum";
                $group_title = "{$Globals['pp_lang']['mostrecent']} &middot; <a title=\"popular photos\" href=\"javascript:sendFeatReq('most_views','$ispal',0);\">{$Globals['pp_lang']['popular']}</a> &middot; <a title=\"random photos\" href=\"javascript:sendFeatReq('random','$ispal',0);\">{$Globals['pp_lang']['randoms']}</a>";
            }

            // Used for vB3 tags
            $toggle = "latest";
            $ppstyle = $vbcollapse[collapseobj_latest];

            break;

        case "most_views":
            if ( !$cat && !$showuser && !$catquery )
            {
                if ( $updatecache || empty($cacheq['popularcache']) )
                {
                    $group_title = "{$Globals['pp_lang']['popular']}";
                    $query = "SELECT id,user,userid,cat,storecat,title,ismature,bigimage,height,width FROM {$Globals['pp_db_prefix']}photos WHERE approved=1 AND storecat=0 ORDER BY views DESC LIMIT $grabnum";
                    $localupd = "popularcache";
                }
                else
                {
                    $group_title = "{$Globals['pp_lang']['popular']}";
                    $results = unserialize( $cacheq['popularcache'] );
                }
            }
            else
            {
                $group_title = "{$Globals['pp_lang']['popular']} - $catname";
                $query = "SELECT id,user,userid,cat,storecat,title,ismature,bigimage,height,width FROM {$Globals['pp_db_prefix']}photos WHERE approved=1 AND storecat=0 $userq $catquery ORDER BY views DESC LIMIT $grabnum";
            }

            // Used for vB3 tags
            $toggle = "mostviews";
            $ppstyle = $vbcollapse[collapseobj_mostviews];

            break;

        case "favorites":
 	    $group_title = "{$Globals['pp_lang']['favorites']} - $catname";
            $query = "SELECT p.id,p.user,p.userid,p.cat,p.storecat,p.title,p.ismature,p.bigimage,p.height,p.width FROM {$Globals['pp_db_prefix']}photos p
                        LEFT JOIN {$Globals['pp_db_prefix']}favorites f ON (f.photo=p.id)
                        WHERE p.approved=1 AND p.storecat=0 AND f.userid=$showuser
                        $catquery
                        ORDER BY date DESC
                        LIMIT $grabnum";

            // Used for vB3 tags
            $toggle = "favorites";
            $ppstyle = $vbcollapse[collapseobj_favorites];

            break;

        default:
            if ( !$cat && !$showuser && !$catquery )
            {
                if ( $updatecache || empty($cacheq['randomcache']) )
                {
                    $group_title = "<a title=\"{$Globals['pp_lang']['mostrecent']}\" href=\"javascript:sendFeatReq('latest','$ispal',0);\">{$Globals['pp_lang']['mostrecent']}</a> &middot; <a title=\"{$Globals['pp_lang']['mostpop']}\" href=\"javascript:sendFeatReq('most_views','$ispal',0);\">{$Globals['pp_lang']['mostpop']}</a> &middot; {$Globals['pp_lang']['randoms']}";
                    $query = "SELECT id,user,userid,cat,storecat,title,ismature,bigimage,height,width, id*0+RAND() as rand_col FROM {$Globals['pp_db_prefix']}photos WHERE approved=1 ORDER BY rand_col DESC LIMIT $grabnum";
                    $localupd = "randomcache";
                }
                else
                {
                    $group_title = "<a title=\"{$Globals['pp_lang']['mostrecent']}\" href=\"javascript:sendFeatReq('latest','$ispal','$cat');\">{$Globals['pp_lang']['mostrecent']}</a> &middot; <a title=\"{$Globals['pp_lang']['mostpop']}\" href=\"javascript:sendFeatReq('most_views','$ispal','$cat');\">{$Globals['pp_lang']['mostpop']}</a> &middot; {$Globals['pp_lang']['randoms']}$catname";
                    $results = unserialize( $cacheq['randomcache'] );
                }
            }
            else
            {
                $group_title = "<a title=\"{$Globals['pp_lang']['mostrecent']}\" href=\"javascript:sendFeatReq('latest','$ispal','$cat');\">{$Globals['pp_lang']['mostrecent']}</a> &middot; <a title=\"{$Globals['pp_lang']['mostpop']}\" href=\"javascript:sendFeatReq('most_views','$ispal','$cat');\">{$Globals['pp_lang']['mostpop']}</a> &middot; {$Globals['pp_lang']['randoms']}$catname";
                $query = "SELECT id,user,userid,cat,storecat,title,ismature,bigimage,height,width, id*0+RAND() as rand_col FROM {$Globals['pp_db_prefix']}photos WHERE approved=1 $userq $catquery ORDER BY rand_col DESC LIMIT $grabnum";
            }

            // Used for vB3 tags
            $toggle = "random";
            $ppstyle = $vbcollapse[collapseobj_random];

            if ( !$cat ) $cat = 0;

            if ( THIS_SCRIPT != "member" )
            {
                $morephotos = "&middot; <a title=\"more photos\" href=\"javascript:sendFeatReq('random','$ispal','$cat');\">{$Globals['pp_lang']['more']}</a> &middot;";
            }

            break;
    }

    // Used for vB3 tags
    $ppimgid = "collapseimg_$toggle";
    $pptbid = "collapseobj_$toggle";

    if ( $query )
    {
        // We're processing a query, not the cache
        $result = ppmysql_query($query, $link);
        $numimages = mysql_num_rows( $result );

        $results = array();

        while ( $features = mysql_fetch_assoc($result) )
        {
            $results[] = $features;
        }
        ppmysql_free_result($result);

        if ( $localupd && $Globals['cachetimeout'] > 0 )
        {
            // If we need to update the cache, do it here
            $slashcache = addslashes(serialize($results));
            $nextupdate = $lasttimeon + ($Globals['cachetimeout'] * 60);
            ppmysql_query("UPDATE {$Globals['pp_db_prefix']}cache SET timestamp=$nextupdate,$localupd='$slashcache' WHERE id=1", $link);
        }
    }
    else
    {
        // Processing the cache
        $numimages = count($results);
    }

    $count = 0;
    $catcache = array();

    foreach( $results AS $features )
    {
        $thiscat = $features['cat'];

        if( $features['storecat'] != 0 )
        {
            $features['cat'] = $features['storecat'];
        }

        if ( $features['cattype'] == "a" )
        {
            $CatPerms['ugview'][$thiscat] = $CatPerms['ugview'][500];
        }

        if ( $CatPerms['ugview'][$thiscat] == 0 )
        {
            if ( !$catcache[$thiscat] )
            {
                $catcache[$thiscat] = is_image_private( $features['cat'] );
            }

            if ( $catcache[$thiscat] == "no" )
            {
                $mcheck = true;
                if ( $Globals['mature'] == "yes" )
                {
                    $mcheck = false;

                    if ( $User['userid'] )
                    {
                        $mcheck = $User['mature'];
                    }
                }

                if ( $features['cat'] == 500 )
                {
      	            $whichcat = "showmembers";
                }
	        else
                {
      	            $whichcat = "showgallery";

                }
                if ( ($features['ismature'] == 1 && $mcheck) || $features['ismature'] == 0 )
                {
                    $count++;
                    $ptitle[$count] = ( strlen($features['title']) < 20 ? $features['title'] : substr($features['title'], 0, 20) );
                    $pid[$count] = $features['id'];
                    $pimgtag[$count] = get_imagethumb( $features['bigimage'], $features['cat'], $features['userid'], 1, 0, 0, 0, 0, $features['title'] );
                    $fthumbtag[$count] = $thumbtag;
                    $pwidth[$count] = $features['width'];
                    $pheight[$count] = $features['height'];

                    $pcatname[$count] = "<br />[ <a href=\"" . construct_newppurl( "$whichcat.php", array('cat' => $thiscat) ) ."\">{$CatPerms['catname'][$thiscat]}</a> ]";
                    $puser[$count] = "<a href=\"". construct_newppurl( "member.php", array('uid' => $features['userid'], 'username' => $features['user']) ) ."\">{$features['user']}</a>";

                    // Make the thumbnail
                    $savecat = $cat;
                    $cat = $features['cat'];
                    $pthumb[$count] = get_thumbtmpl( $features['id'], $pimgtag[$count], $features['height'], $features['width'], $thumbtag, $q_switch, null, $features['title'] );
                    $cat = $savecat;
                }
            }
        }

        if ( $count == $rphotos )
        {
            break;
        }
    }

    if ( isset($stylevar[imgdir_button]) )
    {
        $stylepath = ( $stylevar[imgdir_button][0] == "/" || $stylevar[imgdir_button][0] == "h" ? "" : "{$Globals['vbulletin']}/" );
    }

    $featurestrip = null;

    if ( $count )
    {
        if ( !$ispal )
        {
            include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/feature.tmpl" );
        }
        else
        {
            include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/featurepal.tmpl" );
        }
    }

    if ( $ispal == 0 )
    {
        $featurestrip = "<div id=\"random\">$featurestrip</div>";
    }

    // Now print it!
    print $featurestrip;
}


function update_catcache() {
    global $Globals, $link, $cacheq;

    $catdata = array();

    // First we need to cache the categories
    $query = "SELECT c.id, c.description, c.catorder, c.photos, c.posts, c.catdepth,
                     p.id AS lastphotoid, p.title AS lasttitle, p.bigimage AS lastimage, p.cat AS lastcat, p.storecat AS laststore,
                     p.approved, p.user AS lastuser, p.userid AS lastuserid, p.date AS lastdate, p.width AS lastwidth, p.height AS lastheight,
                     p2.bigimage AS tbigimage, p2.cat AS tcat, p2.storecat AS tstorecat, p2.userid AS tuserid, p2.width AS twidth, p2.height AS theight,
                     com.username AS comusername, com.id AS comid, com.date AS comdate, com.photo AS comphotoid
                     FROM {$Globals['pp_db_prefix']}categories c
                     LEFT JOIN {$Globals['pp_db_prefix']}photos p ON c.lastphoto=p.id
                     LEFT JOIN {$Globals['pp_db_prefix']}photos p2 ON c.thumbnail=p2.id
                     LEFT JOIN {$Globals['pp_db_prefix']}comments com ON com.id=c.lastpost
                     ORDER BY c.catorder ASC";

    $boards = ppmysql_query($query, $link);

    while ( $category = mysql_fetch_array($boards) )
    {
        $catdata[] = $category;
    }
    ppmysql_free_result($boards);

    if ( $Globals['cachetimeout'] > 0 && $Globals['catcache'] == "yes" )
    {
        // Now lets write it to the cache
        $slashcache = addslashes(serialize($catdata));
        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}cache SET catcache='$slashcache' WHERE id=1", $link);
    }

    return($catdata);
}

function catrow( $parent, $whoami = "index" ) {
    global $Globals, $link, $catrows, $catdepth, $cptotal, $totalviews, $diskspace, $cats, $thumbtag;
    global $Style, $CatPerms, $User, $catp, $ppopen, $ppclose, $ppcollapse, $cat, $sort, $page;
    global $cacheq, $updatecache;

    $x = $dontcount = $totalprivph = $totalprivpo = $albumposts = $albumphotos = $startcat = $endcat = 0;
    $maincats = $subcats[] = $laston = $cats = $catdata = array();

    if ( empty($cacheq['catcache']) || $updatecache )
    {
        $cacheq['catcache'] = update_catcache();
    }

    $catdata = &$cacheq['catcache'];

    foreach ( $catdata AS $categories )
    {
        $whichcat = $categories['id'];

        if ( $CatPerms['parent'][$whichcat] == 0 || $parent == $categories['id'] )
        {
            if ( $parent == 0 || $parent == $categories['id'] )
            {
                // count the number of main categories
                $maincats[$x] = $categories;
                if ( $categories['id'] == 500 || $categories['id'] == MOBILE_CAT )
                {
                    $dontcount++;
                }
                $x++;
            }
        }

        $subcats[$whichcat] = $categories;

        if ( $CatPerms['cattype'][$whichcat] == "a" )
        {
            $albumphotos += $categories['photos'];
            $albumposts += $categories['posts'];
        }
    }

    if ( $page > 0 && $Globals['indexcats'] > 0 )
    {
        // Where do we start?
        if ( $page > 1 )
        {
            $startcat = ( ($Globals['indexcats'] * ($page-1))+1 );
        }
        else
        {
            $startcat = 1;
        }

        // And where do we end?
        if ( $page > 1 )
        {
            $endcat = ( $Globals['indexcats'] * $page );
        }
        else
        {
            $endcat = $Globals['indexcats'];
        }

        // How many top level pages do we have?
        $totalpages = ($x / $Globals['indexcats']);

        if ((intval($totalpages)) < $totalpages)
        {
            $totalpages = intval($totalpages)+1;
        }
        else
        {
            $totalpages = intval($totalpages);
        }

        // Value 1 or 2: 1 Members Gallery + 1 Mobile Gallery
        $totalpages = $totalpages - $dontcount;
    }

    // Then, if we need to, we cache the last time the user was in each category (if enabled)
    if ( $User['userid'] > 0 && $Globals['displaynew'] == "yes" )
    {
        $last = ppmysql_query("SELECT cat,laston FROM {$Globals['pp_db_prefix']}laston WHERE userid='{$User['userid']}'", $link);

        while ( list( $lastcat, $lasttime ) = mysql_fetch_row($last) )
        {
            $laston[$lastcat] = $lasttime;
        }
        ppmysql_free_result($last);
    }

    // Finally, we need to cache the number of users in each category (if enabled)
    if ( $Globals['displayonline'] == "yes" )
    {
        $catonline = cache_catonline();
    }

    // process the array, not the database
    $catcount = $topcatcount = 0;
    $pagenames = array();

    foreach( $maincats AS $y => $maincat )
    {
        $mainid = $maincat['id'];
        $maincatname = $CatPerms['catname'][$mainid];

        if ( $startcat && $endcat )
        {
            if ( $mainid != 500 && $mainid != MOBILE_CAT )
            {
                $topcatcount++;
                $pagenames[$topcatcount] = $CatPerms['catname'][$mainid];

                if ( $topcatcount < $startcat || $topcatcount > $endcat )
                {
                    continue;
                }
            }
        }

        if ( $CatPerms['children'][$mainid] != "" )
        {
            $mainchildren = "$mainid,{$CatPerms['children'][$mainid]}";
        }
        else
        {
            $mainchildren = "$mainid";
        }

        $processcats = explode( ",", $mainchildren );
        $skipchild = null;

        if ( $maincat['catdepth'] != "" )
        {
            $maxcatdepth = $maincat['catdepth'];
        }
        else
        {
            $maxcatdepth = $Globals['catdepth'];
        }

        foreach( $processcats AS $num => $eachcat )
        {
            $category = $subcats[$eachcat];
            $checkid = $category['id'];

            $cats['id'][$catcount] = $checkid;
            $cats['parent'][$catcount] = $CatPerms['parent'][$checkid];

            $isonphoto = $isoncomment = $catdepth = 0;

            // Check expand/collapse for subcats, too
            if ( strstr($ppcollapse, ",{$category['id']},") && $parent != $category['id'] )
            {
                $skipchild = $CatPerms['children'][$checkid];
            }

            if ( $skipchild != "" )
            {
                // okay, so we have skipchild set which means we cant print any of the $skipchild cats
                if ( in_array( $category['id'], explode(",", $skipchild) ) )
                {
                    continue;
                }
            }

            // First thing is to check the indent level
            $chkparent = $CatPerms['parent'][$checkid];
            do {
                if ( $chkparent == 0 || $chkparent == $parent )
                {
                    break;
                }

                $chkparent = $CatPerms['parent'][$chkparent];

                $catdepth++;
            } while ( $chkparent != 0 );

            // Then we check the parents - if we can see them, we cant see this one
            $chkparent = $CatPerms['parent'][$checkid];

            do
            {
                // if one of the parents cant be viewed, neither can this one!
                if ( $CatPerms['ugview'][$chkparent] == 1 && $CatPerms['ugview'][$checkid] == 0 )
                {
                    $CatPerms['ugview'][$checkid] = 1;
                }

                $chkparent = $CatPerms['parent'][$chkparent];
            } while ( $chkparent != 0 );

            if ( $CatPerms['children'][$checkid] != "" )
            {
                $processkids = explode( ",", $CatPerms['children'][$checkid] );
                while ( list($num, $eachkid) = each($processkids) )
                {
                    if ($CatPerms['ugview'][$eachkid] != 1 )
                    {
                        $category['photos'] += $subcats[$eachkid]['photos'];
                        $category['posts'] += $subcats[$eachkid]['posts'];
                    }
                    $catonline[$checkid] += $catonline[$eachkid];
                }
            }

            if ( $CatPerms['ugview'][$checkid] != 1 )
            {
                if ( $category['id'] != 500 )
                {
                    $cats['numphotos'][$catcount] = $category['photos'];
                    $cats['numposts'][$catcount] = $category['posts'];
                }
                else
                {
                    $cats['numphotos'][$catcount] = $category['photos'];
                    $cats['numposts'][$catcount] = $category['posts'];
                }

                $cats['numphotos'][$catcount] = number_format($category['photos']);
                $cats['numposts'][$catcount] = number_format($category['posts']);
                $cats['catthumbs'][$catcount] = $CatPerms['thumbs'][$checkid];

                if ( $CatPerms['thumbs'][$checkid] == "yes" )
                {
                    $cats['dodetails'][$catcount] = 1;
                }
                else
                {
                    if ($Globals['catdetails'] == "yes")
                    {
                        $cats['dodetails'][$catcount] = 1;
                    }
                    else
                    {
                        $cats['dodetails'][$catcount] = 0;
                    }
                }

                $newphotos = $newcomments = null;

                if ( $parent != $category['id'] && $catdepth <= $maxcatdepth && !($category['id'] == 500 && $Globals['showmem'] == "no") )
                {
                    $cats['indent'][$catcount] = ($catdepth*15);

                    if ( $category['id'] == 500 )
                    {
                        $whichcat = "showmembers";

                        if ( $Globals['showalbum'] == "yes" )
                        {
                            $category['description'] .= "<br />&nbsp;&nbsp;&middot;&nbsp;<a href=\"{$Globals['maindir']}/misc.php?action=showalbums\">{$Globals['pp_lang']['albidx']}</a>";
                        }
                    }
                    elseif ( $category['id'] == MOBILE_CAT )
                    {
                        $whichcat = "showmobile";
                    }
                    elseif ( $CatPerms['ismember'][$checkid] == 1 )
                    {
                        $whichcat = "showmembers";
                    }
                    else
                    {
                        $whichcat = "showgallery";
                    }

                    if ( $category['tstorecat'] != 0 )
                    {
                        $category['tcat'] = $category['tstorecat'];
                    }

                    $catavatar = get_imagethumb( $category['tbigimage'], $category['tcat'], $category['tuserid'], 1, 0, 1, $category['twidth'], $category['theight'] );
                    $cats['thumbtag'][$catcount] = $thumbtag;

                    if ( $Globals['rotatel'] > 0 || $Globals['rotatep'] > 0 )
                    {
                        $catavatar = str_replace("/thumbs/", "/mini/", $catavatar);
                    }

                    $cats['avatar'][$catcount] = "<a href=\"". construct_newppurl( "$whichcat.php", array('cat' => $category['id']) ) ."\">$catavatar</a>";
                    $cats['catdescript'][$catcount] = null;

                    // Add Moderators to description?

                    if ( $Globals['dispmods'] == "yes" )
                    {
                        $modlist = null;
                        $mymods = explode(",", $CatPerms['mods'][$checkid] );

                        foreach ($mymods as $modrec)
                        {
                            list( $eachmod, $eachname ) = explode( "||", $modrec );
                            if ( $eachname )
                            {
                                if ( !empty($modlist) )
                                {
                                    $modlist .= ", ";
                                }
                                $modlist .= "<a href=\"". construct_newppurl( "member.php", array('uid' => $eachmod, 'username' => $eachname) ) ."\">$eachname</a>";
                            }
                        }

                        if ( $modlist )
                        {
                            $category['description'] .= "<br />{$Globals['pp_lang']['moderators']}: $modlist";
                        }
                    }

                    if ( !empty($category['description']) )
                    {
                        $cats['catdescript'][$catcount] = "<br /><span class=\"{$Style['small']}\">{$category['description']}</span>";
                    }

                    if ( $cats['dodetails'][$catcount] == 1 )
                    {
                        $cphotos=0;
                        $catposts=0;

                        // check to see if we want to display new posts/comments icon
                        if ( $User['userid'] > 0 && $Globals['displaynew'] == "yes" )
                        {
                            if ( $category['lastdate'] > $laston[$checkid] )
                            {
                                $isonphoto = 1;
                            }

                            if ( $category['comdate'] > $laston[$checkid] )
                            {
                                $isoncomment = 1;
                            }
                        }

                        $cats['lpholink'][$catcount] = null;
                        $cats['lpprint'][$catcount] = $Globals['pp_lang']['nocatphotos'];

                        if ($category['lastphotoid'] != "" && $category['lastdate'] != "")
                        {
                            if ( $isonphoto > 0 )
                            {
                                $cats['lpholink'][$catcount] = "<a href=\"". construct_newppurl( "showphoto.php", array('photo' => $category['lastphotoid'], 'cat' => $category['lastcat'], 'title' => $category['lasttitle']) ) ."\"><img border=\"0\" src=\"{$Globals['idir']}/lastpost.gif\" alt=\"{$Globals['pp_lang']['vlastposted']}\" /></a>";
                            }
                            else
                            {
                                $cats['lpholink'][$catcount] = "<a href=\"". construct_newppurl( "showphoto.php", array('photo' => $category['lastphotoid'], 'cat' => $category['lastcat'], 'title' => $category['lasttitle']) ) ."\"><img border=\"0\" src=\"{$Globals['idir']}/nonewposts.gif\" alt=\"{$Globals['pp_lang']['vlastposted']}\" /></a>";
                            }

                            $cclock = formatpptime( $category['lastdate'] );
                            $ppdate = formatppdate( $category['lastdate'] );

                            $cats['lpprint'][$catcount] = "$ppdate $cclock";
                        }

                        if ( $category['comusername'] )
                        {
                            $cats['lastposttext'][$catcount] = "{$Globals['pp_lang']['by']} {$category['comusername']}";
                        }
                        else
                        {
                            $cats['lastposttext'][$catcount] = null;
                        }

                        if ( $category['lastuser'] )
                        {
                            $cats['lastphotext'][$catcount] = "{$Globals['pp_lang']['by']} {$category['lastuser']}";
                        }
                        else
                        {
                            $cats['lastphotext'][$catcount] = null;
                        }

                        if ( $category['comid'] > 0 )
                        {
                            if ( $isoncomment > 0 )
                            {
                                $cats['lpostlink'][$catcount] = "<a href=\"". construct_newppurl( "showphoto.php", array('photo' => $category['comphotoid'], 'cat' => $category['lastcat']) ) ."\"><img border=\"0\" src=\"{$Globals['idir']}/lastpost.gif\" alt=\"{$Globals['pp_lang']['vlastposted']}\" /></a>";
                            }
                            else
                            {
                                $cats['lpostlink'][$catcount] = "<a href=\"". construct_newppurl( "showphoto.php", array('photo' => $category['comphotoid'], 'cat' => $category['lastcat']) ) ."\"><img border=\"0\" src=\"{$Globals['idir']}/nonewposts.gif\" alt=\"{$Globals['pp_lang']['vlastposted']}\" /></a>";
                            }
                        }
                        else
                        {
                            $cats['lpostlink'][$catcount] = null;
                        }

                        if ($category['comdate'] != "")
                        {
                            $cclock = formatpptime( $category['comdate'] );
                            $ppdate = formatppdate( $category['comdate'] );

                            $cats['lcprint'][$catcount] = "$ppdate $cclock";
                        }
                        else
                        {
                            $cats['lcprint'][$catcount] = $Globals['pp_lang']['nocatcomments'];
                        }

                        if ( $Globals['displayonline'] == "yes" )
                        {
                            if ( $catonline[$checkid] > 0 )
                            {
                                $cats['catonline'][$catcount] = "<i>({$catonline[$checkid]} {$Globals['pp_lang']['viewing']})</i>";
                            }
                            else
                            {
                                $cats['catonline'][$catcount] = null;
                            }
                        }
                    }

                    $catthumbrc = null;

                    if ( $category['laststore'] != 0 )
                    {
                        $category['lastcat'] = $category['laststore'];
                    }

                    if ($category['photos'] > 0 )
                    {
                        $cathumbrc = get_imagethumb( $category['lastimage'], $category['lastcat'], $category['lastuserid'], $category['approved'] );
                    }
                    else
                    {
                        if ( $category['tstorecat'] > 0 )
                        {
                            $category['tcat'] = $category['tstorecat'];
                        }

                        if ( $category['tbigimage'] > 0 )
                        {
                            $cathumbrc = get_imagethumb( $category['tbigimage'], $category['tcat'], $category['tuserid'], 1, 0, 0, $category['twidth'], $category['theight'] );
                        }
                    }

                        $cats['thumbtag'][$catcount] = $thumbtag;
                        $cats['mthumb'][$catcount] = $cathumbrc;
                        $cats['width'][$catcount] = $category['lastwidth'];
                        $cats['height'][$catcount] = $category['lastheight'];
                        $cats['id'][$catcount] = $category['id'];
                        $cats['thumbnail'][$catcount] = get_thumbtmpl( $category['lastphotoid'], $cathumbrc, $category['lastheight'], $category['lastwidth'], $thumbtag, $category['lastcat'] );
                        $cats['thumblink'][$catcount] = null;

                    if ( $CatPerms['thumbs'][$checkid] == "yes" )
                    {
                        $cats['thumblink'][$catcount] = construct_newppurl( "$whichcat.php", array('cat' => $category['id']) );
                        $cats['catlink'][$catcount] = "<a href=\"". construct_newppurl( "$whichcat.php", array('cat' => $category['id']) ) ."\">{$CatPerms['catname'][$checkid]}</a>";

                        $catcount++;
                    }
                    else
                    {
                        $cats['catlink'][$catcount] = "<a href=\"". construct_newppurl( "index.php", array('cat' => $category['id']) ) ."\">{$CatPerms['catname'][$checkid]}</a>";

                        $more = null;
                        if ( $whoami == "showgallery" )
                        {
                            if ( is_numeric($cat) && $cat > 0 )
                            {
                                $more .= "&amp;cat=$cat";
                            }

                            if ( is_numeric($sort) )
                            {
                                $more .= "&ampsort=$sort";
                            }
                        }

                        $cats['catexpand'][$catcount] = "<a rel=\"nofollow\" href=\"{$Globals['maindir']}/misc.php?action=catopts&amp;implode={$category['id']}&amp;whoami=$whoami$more\"><img border=\"0\" src=\"{$Globals['idir']}/catclose.gif\" alt=\"\" /></a>";

                        if ( !empty($ppcollapse) )
                        {
                            if ( strstr($ppcollapse, ",{$category['id']},") )
                            {
                                $cats['catexpand'][$catcount] = "<a rel=\"nofollow\" href=\"{$Globals['maindir']}/misc.php?action=catopts&amp;expand={$category['id']}&amp;whoami=$whoami$more\"><img border=\"0\" src=\"{$Globals['idir']}/catopen.gif\" alt=\"\" /></a>";
                            }
                        }

                        $catcount++;
                    }
                }
            }
        }
    }

    if ( $totalpages > 0 )
    {
        indexpages( $totalpages, $pagenames );
    }

    $cats['catcount'] = $catcount;

    return;
}
// end catrow


function thetime($inhour,$inmin)
{
    if ($inmin < 10)
    {
        $inmin = "0$inmin";
    }

    if ($inhour == 0)
    {
        $inhour = str_replace("0", "12", $inhour);
        $outclock = "{$inhour}:{$inmin}am";
        return($outclock);
    }
    else
    {
        if ($inhour < 10)
        {
            $inhour = str_replace("0", "", $inhour);
        }
    }

    if ($inhour > 11)
    {
        if ($inhour != 12)
        {
            $inhour = $inhour-12;
        }

        $outclock = "{$inhour}:{$inmin}pm";
    }
    else
    {
        $outclock = "{$inhour}:{$inmin}am";
    }

    return($outclock);
}


function formatpptime( $date )
{
    global $Globals, $User;

    $date = $date + ($User['offset'] * 3600) + ($Globals['gmtoffset'] * 3600);
    list($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($date);

    if ( $Globals['timeformat'] == "no" )
    {
        $cclock = thetime($hour,$min);
    }
    else
    {
        if ( $hour < 10 )
        {
            $hour = "0$hour";
        }

        if ( $min < 10 ) {
            $min = "0$min";
        }

        $cclock = "$hour:$min";
    }

    return( $cclock );
}


function formatppdate( $date, $glob_date = "" )
{
    global $Globals, $User;

    $date = $date + ($User['offset'] * 3600) + ($Globals['gmtoffset'] *3600);
    list($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($date);
    $mon++;
    $year = $year + 1900;

    $months = array( "","{$Globals['pp_lang']['month1']}","{$Globals['pp_lang']['month2']}","{$Globals['pp_lang']['month3']}","{$Globals['pp_lang']['month4']}","{$Globals['pp_lang']['month5']}","{$Globals['pp_lang']['month6']}","{$Globals['pp_lang']['month7']}","{$Globals['pp_lang']['month8']}","{$Globals['pp_lang']['month9']}","{$Globals['pp_lang']['month10']}","{$Globals['pp_lang']['month11']}","{$Globals['pp_lang']['month12']}" );
    $days = array( "{$Globals['pp_lang']['day1']}", "{$Globals['pp_lang']['day2']}", "{$Globals['pp_lang']['day3']}", "{$Globals['pp_lang']['day4']}", "{$Globals['pp_lang']['day5']}", "{$Globals['pp_lang']['day6']}", "{$Globals['pp_lang']['day7']}" );

    if ( !$glob_date )
    {
        if ( isset($Globals['ppdateformat']) )
        {
            $glob_date = $Globals['ppdateformat'];
        }
        else
        {
            $glob_date = "dow month dd, yyyy";
        }
    }

    $glob_date = str_replace( "mm", "$mon", $glob_date );
    $glob_date = str_replace( "dd", "$mday", $glob_date );
    $glob_date = str_replace( "yyyy", "$year", $glob_date );
    $glob_date = str_replace( "yy", substr($year, 2, 2), $glob_date );
    $glob_date = str_replace( "month", "$months[$mon]", $glob_date );
    $glob_date = str_replace( "dow", "$days[$wday]", $glob_date );

    return( $glob_date );
}



function pagesystem( $rowcnt, $whoami = "showgallery", $action = false, $pageper = 0 )
{
    global $Globals, $Style, $perpage, $pages, $page, $posternav, $cat, $p, $sort, $sortparam, $ppuser, $susername, $email, $susergroupid;
    global $what, $name, $whenterm, $sl, $sorttime, $sortby, $way, $limit;

    if ( $action )
    {
        $Globals['spider'] = "none";
    }

    $pageper = ( $pageper == 0 ? $perpage : $pageper );

    // begin pages/nav system //
    // $rowcnt = number of images to display
    // $perpage = configurable by menu

    $pages = ($rowcnt/$pageper);

    if ( (intval($pages)) < $pages )
    {
        $pages = intval($pages)+1;
    }
    else
    {
        $pages = intval($pages);
    }

    if ( $page != "" )
    {
        $startnumb = ($page*$pageper)-$pageper+1;
    }
    else
    {
        $page = 1;
        $startnumb = 1;
    }

    if ( $pages > 1 )
    {
        $posternav = "<span class=\"{$Style['large']}\">";
        $thestart = 0;

        if ( $page < 11 ) {
            $thestart = 1;
        }
        elseif ( $page > 10 )
        {
            $thestart = $page-5;
        }

        $theend = $thestart + 9;

        for ( $p = $thestart; $p <= $pages; $p++ )
        {
            if ($p != $thestart)
            {
                $posternav .= " &middot; ";
            }
            else
            {
                $posternav .= "<b>{$Globals['pp_lang']['page']}</b> ";
            }

            if ( $p == $thestart && $p != 1 )
            {
                if ( $whoami == "admusers" )
                {
                    $posternav .= "<a href=\"{$Globals['maindir']}/adm-users.php?username=$susername&amp;email=$email&amp;susergroupid=$susergroupid&amp;ppaction=users&amp;do=findusers&amp;page=1&amp;sort=$sortparam&amp;perpage=$pageper&amp;sl=$sl\">1</a> ... ";
                }
                elseif ( $whoami == "index" )
                {
                    $posternav .= "<a href=\"" . construct_newppurl( "index.php", array('cat' => $cat, 'page' => 1) ) ."\">1</a> ... ";
                }
                elseif ( $whoami == "showgallery" )
                {
                    $posternav .= "<a href=\"" . construct_newppurl( "showgallery.php", array('ppuser' => $ppuser, 'cat' => $cat, 'page' => 1) ) ."\">1</a> ... ";
                }
                elseif ( $whoami == "showmembers" )
                {
                    $posternav .= "<a href=\"" . construct_newppurl( "showmembers.php", array('cat' => $cat, 'page' => 1) ) ."\">1</a> ... ";
                }
                else
                {
                    $posternav .= "<a href=\"{$Globals['maindir']}/$whoami.php?cat=$cat&amp;action=$action\">1</a> ... ";
                }
            }

            if ( $page != $p )
            {
                $thispage = "$p";

                if ( $whoami == "admusers" )
                {
                    $posternav .= "<a href=\"{$Globals['maindir']}/adm-users.php?username=$susername&amp;email=$email&amp;susergroupid=$susergroupid&amp;ppaction=users&amp;do=findusers&amp;page=$p&amp;sort=$sortparam&amp;perpage=$pageper&amp;sl=$sl\">$thispage</a>";
                }
                elseif ( $whoami == "index" )
                {
                    $posternav .= "<a href=\"" . construct_newppurl( "index.php", array('cat' => $cat, 'page' => $thispage) ) ."\">$thispage</a>";
                }
                elseif ( $whoami == "showgallery" )
                {
                    $posternav .= "<a href=\"" . construct_newppurl( "showgallery.php", array('ppuser' => $ppuser, 'cat' => $cat, 'page' => $p) ) ."\">$thispage</a>";
                }
                elseif ( $whoami == "showmembers" )
                {
                    $posternav .= "<a href=\"" . construct_newppurl( "showmembers.php", array('cat' => $cat, 'page' => $p) ) ."\">$thispage</a>";
                }
                else
                {
                    $posternav .= "<a href=\"{$Globals['maindir']}/$whoami.php?cat=$cat&amp;page=$p&amp;action=$action\">$thispage</a>";
                }
            }

            if ( $p > $theend )
            {
                if ( $whoami == "admusers" )
                {
                    $posternav .= " ... <a href=\"{$Globals['maindir']}/adm-users.php?username=$susername&amp;email=$email&amp;susergroupid=$susergroupid&amp;ppaction=users&amp;do=findusers&amp;page=$pages&amp;sort=$sortparam&amp;perpage=$pageper&amp;sl=$sl\">$pages</a>";
                }
                elseif ( $whoami == "index" )
                {
                    $posternav .= " ... <a href=\"" . construct_newppurl( "index.php", array('cat' => $cat, 'page' => $pages) ) ."\">$pages</a>";
                }
                elseif ( $whoami == "showgallery" )
                {
                    $posternav .= " ... <a href=\"" . construct_newppurl( "showgallery.php", array('ppuser' => $ppuser, 'cat' => $cat, 'page' => $pages) ) . "\">$pages</a>";
                }
                elseif ( $whoami == "showmembers" )
                {
                    $posternav .= " ... <a href=\"" . construct_newppurl( "showmembers.php", array('cat' => $cat, 'page' => $pages) ) . "\">$pages</a>";
                }
                else
                {
                    $posternav .= " ... <a href=\"{$Globals['maindir']}/$whoami.php?cat=$cat&amp;page=$pages&amp;action=$action\">$pages</a>";
                }
                break;
            }

            if ( $page == $p )
            {
                $posternav .= "<b>$p</b>";
            }
        }

        $posternav .= "</span>";
    }

    return $pages;
}


function indexpages( $rowcnt, $pagenames )
{
    global $Globals, $Style, $pages, $page, $posternav;

    $pageper = $Globals['indexcats'];
    $pages = ($rowcnt/$pageper);

    if ((intval($pages)) < $pages)
    {
        $pages = intval($pages)+1;
    }
    else
    {
        $pages = intval($pages);
    }

    if ( $page != "" )
    {
        $startnumb = ($page*$pageper)-$pageper+1;
    }
    else
    {
        $page = 1;
        $startnumb = 1;
    }

    if ( $pages > 1 )
    {
        $posternav = "<span class=\"{$Style['small']}\">";
        $thestart = 0;

        if ( $page < 11 )
        {
            $thestart = 1;
        }
        elseif ( $page > 10 )
        {
            $thestart = $page-5;
        }

        $theend = $thestart + 9;

        for ( $p = $thestart; $p <= $pages; $p++ )
        {
            if ( $p != $thestart )
            {
                $posternav .= " &middot; ";
                // Insert a return every 5 titles
                if ( fmod($p,5) == 0 )
                {
                    $posternav .= "<br />&middot; ";
                }
            }
            //else
            //    $posternav .= "<b>{$Globals['pp_lang']['page']}</b> ";

            if ( $p == $thestart && $p != 1 )
            {
                $posternav .= "<a href=\"" . construct_newppurl( "index.php", array('cat' => $cat) ) ."\">{$pagenames[1]}</a> ... ";
            }

            if ( $page != $p )
            {
                $thispage = "$p";

                $posternav .= "<a href=\"" . construct_newppurl( "index.php", array('cat' => $cat) ) ."\">{$pagenames[$thispage]}</a>";
            }

            if ( $p > $theend )
            {
                $posternav .= " ... <a href=\"" . construct_newppurl( "index.php", array('cat' => $cat) ) ."\">{$pagenames[$pages]}</a>";
                break;
            }

            if ( $page == $p )
            {
                $posternav .= "<b>{$pagenames[$p]}</b>";
            }
        }

        $posternav .= "</span>";
    }

    return $pages;
}


function convert_returns( $convert_returns )
{
    $convert_returns = str_replace( "\n\r\n", "<br /><br />", $convert_returns);

    return ( str_replace( "\r", "<br />", $convert_returns) );
}


function construct_newppurl( $url, $parm = null, $id = null, $title = null, $cat = null )
{
    global $Globals, $_REQUEST, $storecat;

    // note to self: take off $cat if you arent going to add category names to url (requires different rewrite)
    $string = null;

    if ( $Globals['spider'] != "seo" )
    {
        if ( is_array($parm) )
        {
            foreach ( $parm AS $p => $v )
            {
                if ( $p && $v )
                {
                    if ( $Globals['spider'] == "spider" )
                    {
                        $string .= "/$p/". ppurlsafe($v);
                    }
                    else
                    {
                        if ( $string == null )
                        {
                            $string = "?$p=". ppurlsafe($v);
                        }
                        else
                        {
                            $string .= "&amp;$p=". ppurlsafe($v);
                        }
                    }
                }
            }
        }

        return( "{$Globals['maindir']}/$url$string" );
    }

    if ( $parm['cat'] == "all" && $storecat > 0 )
    {
        $parm['cat'] = $storecat;
    }

    if ( $url == "showphoto.php" )
    {
        $retstring = "{$Globals['maindir']}/";
        $retstring .= ppurlsafe( get_catname($parm['cat']) );
        $retstring .= "/p" . $parm['photo'];

        if ( $parm['title'] )
        {
            $retstring .= "-" . ppurlsafe($parm['title']);
        }

        if ( $parm['cpage'] > 0 )
        {
            $retstring .= "-cpage" . $parm['cpage'];
        }

        $retstring .= ".html";
    }
    elseif ( $url == "showgallery.php" )
    {
        $retstring = "{$Globals['maindir']}/";

        if ( isset($parm['ppuser']) && $parm['ppuser'] > 0 )
        {
            if ( !isset( $parm['username'] ) || !$parm['username'] )
            {
                list($uid,$parm['username']) = get_userinfo( null, $parm['ppuser'] );
            }

            if ( $parm['cat'] > 0 && $parm['cat'] != 500 && $parm['page'] >= 1 )
            {
                $retstring .= "u" . $parm['ppuser'] . "-" . ppurlsafe( $parm['username'] ) . "-cat" .  $parm['cat'] ."-page" . $parm['page'] .".html";
            }
            elseif ( $parm['cat'] > 0 && $parm['cat'] != 500 && !$parm['page'] )
            {
                $retstring .= "u" . $parm['ppuser'] . "-" . ppurlsafe( $parm['username'] ) . "-cat" .  $parm['cat'] .".html";
            }
            elseif ( $parm['cat'] == 500 && $parm['page'] >= 1 )
            {
                $retstring .= "u" . $parm['ppuser'] . "-" . ppurlsafe( $parm['username'] ) . "-page" . $parm['page'] .".html";
            }
            else
            {
                $retstring .= "u" . $parm['ppuser'] . "-" . ppurlsafe( $parm['username'] ) . ".html";
            }
        }
        elseif ( $parm['page'] > 1 )
        {
            $retstring .= "g" . $parm['cat'] . "-" . ppurlsafe( get_catname($parm['cat']) ) . "-page" . $parm['page'] .".html";
        }
        else
        {
            $retstring .= "g" . $parm['cat'] . "-" . ppurlsafe( get_catname($parm['cat']) ) . ".html";
        }
    }
    elseif ( $url == "member.php" )
    {
        if ( isset($parm['protype']) )
        {
            $retstring = "{$Globals['maindir']}/m" . $parm['uid'] . "-" . ppurlsafe( $parm['username'] ) . "-protype" . $parm['protype'] . ".html";
        }
        else
        {
            $retstring = "{$Globals['maindir']}/m" . $parm['uid'] . "-" . ppurlsafe( $parm['username'] ) . ".html";
        }
    }
    elseif ( $url == "board.php" )
    {
        if ( $parm == null )
        {
            $retstring = "{$Globals['maindir']}/board.html";
        }
        else
        {
            $retstring = "{$Globals['maindir']}/b" . $parm['msg'] . "-" . ppurlsafe( stripslashes($parm['subject']) ) . ".html";
        }
    }
    elseif( $url == "showmembers.php" )
    {
        if ( $parm['page'] > 1 )
        {
            $retstring = "{$Globals['maindir']}/s" . $parm['cat'] . "-" . ppurlsafe( get_catname($parm['cat']) ) . "-page" . $parm['page'] .".html";
        }
        else
        {
            $retstring = "{$Globals['maindir']}/s" . $parm['cat'] . "-" . ppurlsafe( get_catname($parm['cat']) ) . ".html";
        }
    }
    elseif( $url == "index.php" )
    {
        if ( !isset($parm['cat']) || $parm['cat'] == 0 )
        {
            $retstring = "{$Globals['maindir']}";
        }
        elseif ( $parm['page'] > 1 )
        {
            $retstring = "{$Globals['maindir']}/". ppurlsafe( get_catname($parm['cat']) ) . "-page" . $parm['page'] . "/index" . $parm['cat'] . ".html";
        }
        else
        {
            $retstring = "{$Globals['maindir']}/". ppurlsafe( get_catname($parm['cat']) ) ."/index" . $parm['cat'] . ".html";
        }
    }
    else
    {
        $retstring = "{$Globals['maindir']}/$url$string";
    }

    return( $retstring );
}

function ppurlsafe( $string )
{
    $str1 = array('', '', '', '', '', '', '', '(', ')', '[', ']');
    $str2 = array('Ae', 'ae', 'Ue', 'ue', 'Oe', 'oe', 'ss', '', '', '', '');
    $string = str_replace($str1, $str2, $string);
    $string = urlencode( $string );
    $string = strtolower( htmlspecialchars( $string ) );
    $string = @ereg_replace('[^A-Za-z0-9]', '-', $string);

    return( @eregi_replace('-{2,}', '', $string) );
}

function fixfilenames( $realname )
{
    $realname = urldecode($realname);

    $realname  = str_replace( "%20", "_", $realname );
    $realname  = @ereg_replace( "\\\\'", "_", $realname );

    $stripname = get_filename( $realname );
    $theext    = get_ext( $realname );

    $stripname = @ereg_replace( "[^a-zA-Z0-9/\:_\-]", "_", $stripname );
    $realname  = "{$stripname}{$theext}";

    // Lets try to make it look better
    $realname = @ereg_replace("_+", "_", $realname);
    $realname = @ereg_replace("(^_|_$)", "", $realname);

    return( $realname );
}


function gen_password()
{
    $consts = "bcdgklmnprst";
    $vowels = "aeiou";

    for ( $x = 0; $x < 6; $x++ )
    {
        mt_srand ((double) microtime() * 1000000);
        $const[$x] = substr($consts,mt_rand(0,strlen($consts)-1),1);
        $vow[$x]   = substr($vowels,mt_rand(0,strlen($vowels)-1),1);
    }

    $newpass = $const[0] . $vow[0] .$const[2] . $const[1] . $vow[1] . $const[3] . $vow[3] . $const[4];

    return( $newpass );
}


function get_catname( $cat )
{
    global $Globals, $CatPerms, $link;

    if ( isset($CatPerms['catname'][$cat]) )
    {
        return( $CatPerms['catname'][$cat] );
    }

    $catname = null;

    if ( $cat > 0 )
    {
        $catresults = ppmysql_query("SELECT catname FROM {$Globals['pp_db_prefix']}categories WHERE id=$cat", $link);
        list( $catname ) = mysql_fetch_row($catresults) ;
    }

    return( $catname );
}


function childsub( $parid, $cattype="c", $last=0 )
{
    global $Globals, $CatPerms, $childnav, $link, $tusername, $ppuser;

    $origid = $parid;

    if ( $parid == "fav" )
    {
        $childnav = "&raquo; <a href=\"{$Globals['maindir']}/search.php?what=fav\">{$Globals['pp_lang']['myfavorites']}</a>";

        if ( $Globals['allowfavzip'] == "yes" && THIS_SCRIPT == "showgallery" )
        {
            $childnav .= "&nbsp;&nbsp;&nbsp;<a rel=\"nofollow\" href=\"{$Globals['maindir']}/misc.php?action=downloadzip&amp;cat=fav\"><img border=\"0\" src=\"{$Globals['idir']}/download.gif\" alt=\"{$Globals['pp_lang']['downfav']}\" /></a>";
        }
    }
    elseif ( !is_numeric($parid) )
    {
        if ( $parid == "last1" )
        {
            $childnav = "&raquo; {$Globals['pp_lang']['lastdays']}";
        }
        elseif ( $parid == "last7" )
        {
            $childnav = "&raquo; {$Globals['pp_lang']['last7days']}";
        }
        elseif ( $parid == "last14" )
        {
            $childnav = "&raquo; {$Globals['pp_lang']['last14days']}";
        }
        elseif ( $parid == "all" && $ppuser > 0 )
        {
            if ( empty( $tusername ) )
            {
                list( $tid, $tusername, $tmail ) = get_userinfo("", $ppuser);
            }

            $childnav = "&raquo; $tusername";
        }
        else
        {
            $childnav = "&raquo; {$Globals['pp_lang']['custom']}";
        }
    }
    elseif ( $cattype == "a" )
    {
        $subalbumname = $CatPerms['catname'][$parid];
        $aparent = $CatPerms['parent'][$parid];
        $children = $CatPerms['children'][$parid];
        $subalbum = ( isset($CatPerms['subalbum'][$parid]) ? $CatPerms['subalbum'][$parid] : null );

        if ( empty( $tusername ) )
        {
            list( $tid, $tusername, $tmail ) = get_userinfo("", $aparent);
        }

        if ( $children )
        {
            $assignedcat = " (<a href=\"". construct_newppurl( "showgallery.php", array('cat' => $children) ) ."\">". $CatPerms['catname'][$children] ."</a>)";
        }

        if ( $subalbum )
        {
            $assignedalb = " <a href=\"". construct_newppurl( "showgallery.php", array('cat' => $subalbum) ) ."\">". $CatPerms['catname'][$subalbum] ."</a> &raquo;";
        }

        $childnav = "&raquo;
            <a href=\"". construct_newppurl( "showmembers.php", array('cat' => 500) ) ."\">{$Globals['pp_lang']['member']}</a> &raquo;
            <a href=\"". construct_newppurl( "showgallery.php", array('ppuser' => $aparent, 'username' => $tusername) ) ."\">$tusername</a> &raquo;{$assignedalb}
            <a href=\"". construct_newppurl( "showgallery.php", array('cat' => $parid) ) ."\">$subalbumname</a> $childnav$assignedcat";

        if ( isset($CatPerms['canzip'][$parid]) && THIS_SCRIPT == "showgallery" )
        {
            $childnav .= "&nbsp;&nbsp;&nbsp;<a href=\"{$Globals['maindir']}/misc.php?action=downloadzip&amp;cat=$parid\"><img border=\"0\" src=\"{$Globals['idir']}/download.gif\" alt=\"{$Globals['pp_lang']['downfav']}\" /></a>";
        }

        ppmysql_free_result($arows);
    }
    else
    {
        do
        {
            $tusername = $CatPerms['catname'][$parid];

            if ( $CatPerms['thumbs'][$parid] == "yes" )
            {
                if ( $parid == 500 )
                {
                    if ( $Globals['spider'][$parid] == "seo" )
                    {
                        $childnav = "&raquo; <a href=\"". construct_newppurl( "showmembers.php", array('cat' => 500) ) ."\">$tusername</a> $childnav";
                    }
                    else
                    {
                        $childnav = "&raquo; <a href=\"{$Globals['maindir']}/showmembers.php?cat=500&limit=all\">$tusername</a> $childnav";
                    }
                }
                elseif ( $parid == MOBILE_CAT )
                {
                    $childnav = "&raquo; <a href=\"{$Globals['maindir']}/showmobile.php\">$tusername</a> $childnav";
                }
                else
                {
                    if ( $CatPerms['ismember'][$parid] == 0 )
                    {
                        $childnav = "&raquo; <a href=\"". construct_newppurl( "showgallery.php", array('cat' => $parid) ) ."\">$tusername</a> $childnav";
                    }
                    else
                    {
                        $childnav = "&raquo; <a href=\"". construct_newppurl( "showmembers.php", array('cat' => $parid) ) ."\">$tusername</a> $childnav";
                    }
                }
            }
            else
            {
                $childnav = "&raquo; <a href=\"". construct_newppurl( "index.php", array('cat' => $parid) ) ."\">$tusername</a> $childnav";
            }

            $parid = $CatPerms['parent'][$parid];
        } while ( $parid > 0 );

        if ( isset($CatPerms['canzip'][$origid]) )
        {
            $childnav .= "&nbsp;&nbsp;&nbsp;<a href=\"{$Globals['maindir']}/misc.php?action=downloadzip&amp;cat=$origid\"><img border=\"0\" src=\"{$Globals['idir']}/download.gif\" alt=\"{$Globals['pp_lang']['downfav']}\" /></a>";
        }

        if ( $origid == 500 && !empty($ppuser) )
        {
            list( $tid, $tusername, $tmail ) = get_userinfo("", $ppuser);
            $childnav .= "&raquo; <a href=\"". construct_newppurl( "showgallery.php", array('ppuser' => $ppuser, 'username' => $tusername) ) ."\">$tusername</a>";
        }
        elseif ( $origid == MOBILE_CAT && !empty($ppuser) )
        {
            list( $tid, $tusername, $tmail ) = get_userinfo( "", $ppuser );
            $childnav .= "&raquo; <a href=\"" . construct_newppurl( "showgallery.php", array('ppuser' => $ppuser, 'cat' => MOBILE_CAT) ) ."\">$tusername</a>";
        }
    }
}

//
//
function catmoveopt( $subcatid, $albums=0, $member=0, $albumsonly=0, $nothumbs = true, $onlymine = false )
{
    global $Globals, $catoptions, $link, $dashes, $selected, $CatPerms, $User, $cacheq;

    $maincats = array();
    $subcats[] = array();
    $laston = array();
    $parent = $subcatid;
    $x = 0;

    $where = ( $member == 0 ? "" : "WHERE id != 500");

    if ( $albumsonly == 0 )
    {
        if ( empty($cacheq['catcache']) )
        {
            $cacheq['catcache'] = update_catcache();
        }
        $boards = &$cacheq['catcache'];

        foreach ( $boards AS $categories )
        {
            $whichcat = $categories['id'];

            if ( $CatPerms['cattype'][$whichcat] == "c" )
            {
                if ( $CatPerms['parent'][$whichcat] == 0 || $parent == $categories['id'] )
                {
                    if ( $parent == 0 || $parent == $categories['id'] )
                    {
                        // count the number of main categories
                        $maincats[$x] = $categories;
                        $x++;
                    }
                }

                $subcats[$whichcat] = $categories;
            }
        }

        foreach( $maincats AS $y => $maincat )
        {
            $mainid = $maincat['id'];

            if ( $CatPerms['children'][$mainid] != "" )
            {
                $mainchildren = "$mainid,{$CatPerms['children'][$mainid]}";
            }
            else
            {
                $mainchildren = "$mainid";
            }

            $processcats = explode( ",", $mainchildren );

            while ( list($num, $eachcat) = each($processcats) )
            {
                list( $subid ) = $subcats[$eachcat];

                $selecttext = null;
                $partext = null;
                if ( $subid == $selected )
                {
                    $selecttext = "selected=\"selected\"";
                }

                if ( $CatPerms['ugcat'][$subid] != 1 || $User['adminedit'] == 1 )
                {
                    $chkparent = $CatPerms['parent'][$subid];
                    do
                    {
                        if ( $chkparent == 0 || $chkparent == $subcatid )
                        {
                            break;
                        }

                        $partext = "&nbsp; &nbsp; $partext";
                        $chkparent = $CatPerms['parent'][$chkparent];
                    } while ( $chkparent != 0 );

                    if ( $CatPerms['thumbs'][$subid] == "yes" || $nothumbs == false )
                    {
                        $catoptions .= "<option $selecttext value=\"$subid\">$partext{$CatPerms['catname'][$subid]}</option>";
                    }
                    else
                    {
                        $catoptions .= "<option $selecttext value=\"notcat\">$partext{$CatPerms['catname'][$subid]}</option>";
                    }
                }
            }
        }
    }

    if ( $albums == 0 )
    {
        $firstcatid = 0;

        if ( $User['adminedit'] == 1 && $onlymine == false )
        {
            $aquery = "SELECT id,catname,description,parent FROM {$Globals['pp_db_prefix']}categories WHERE cattype='a' ORDER BY parent,catname";
        }
        elseif ( $onlymine == true )
        {
            $aquery = "SELECT id,catname,description,parent FROM {$Globals['pp_db_prefix']}categories WHERE parent='{$User['userid']}' AND cattype='a' AND subalbum=0 ORDER BY catname";
        }
        else
        {
            $aquery = "SELECT id,catname,description,parent FROM {$Globals['pp_db_prefix']}categories WHERE parent='{$User['userid']}' AND cattype='a' ORDER BY catname";
        }

        $arows = ppmysql_query($aquery, $link);
        $cachenames = array();

        while ( list( $subid, $subalbumname, $subalbumdesc, $parent ) = mysql_fetch_row($arows) )
        {
            if ( $firstcatid == 0 )
            {
                $firstcatid = $subid;
            }

            $selecttext = null;
            if ($selected == $subid)
            {
                $selecttext = "selected=\"selected\"";
            }

            if ( !isset($cachenames[$parent]) )
            {
                list( $userid, $username ) = get_userinfo( "", $parent );
                $cachenames[$parent] = $username;
            }

            if ( $onlymine == true )
            {
                $catoptions .= "<option $selecttext value=\"$subid\">$subalbumname</option>";
            }
            else
            {
                $catoptions .= "<option $selecttext value=\"$subid\">{$cachenames[$parent]}: $subalbumname</option>";
            }
        }
        ppmysql_free_result( $arows );
    }

    return( $firstcatid );
}


//
// Recalc a photos rating
//

function calc_rating( $photo )
{
    global $Globals, $link;

    // just to revalidate the rating, we need to recheck the rating for the post
    $resultb = ppmysql_query("SELECT rating FROM {$Globals['pp_db_prefix']}comments WHERE photo='$photo' AND rating > 0", $link);

    $numrating = $sumrating = $averagerate = 0;

    while( list ( $checkrating ) = mysql_fetch_row($resultb) )
    {
        $numrating++;
        $sumrating = ($sumrating+$checkrating);
    }

    if ( $numrating != 0 && $sumrating != 0 )
    {
        $averagerate = $sumrating / $numrating;
    }

    $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET rating=$averagerate WHERE id=$photo", $link);

    return( $averagerate );
}

function catlist( $parid )
{
    global $Globals, $CatPerms, $link, $cathash, $albumhash;

    $parid = (int)$parid;
    $cathash = $albumhash = null;

    $cattype = $CatPerms['cattype'][$parid];

    if ( $cattype == "a" )
    {
        $boards = ppmysql_query("SELECT id,cattype,children FROM {$Globals['pp_db_prefix']}categories
                                 WHERE subalbum=$parid AND cattype='a'
                                 ORDER BY catorder ASC", $link);
    }
    else
    {
        $boards = ppmysql_query("SELECT id,cattype,children FROM {$Globals['pp_db_prefix']}categories
                                 WHERE (parent=$parid AND cattype='c') OR
                                       (children=$parid AND cattype='a') OR
                                       (subalbum=$parid AND cattype='a')
                                 ORDER BY catorder ASC", $link);
    }


    while ( list ( $tid, $cattype, $catkids ) = mysql_fetch_row($boards) )
    {
        if ( $cattype == "a" )
        {
            if ( $albumhash != "" )
            {
                $albumhash .= ",";
            }

            $albumhash .= "$tid";
        }
        else
        {
            if ( $cathash != "" )
            {
                $cathash .= ",";
            }

            $cathash .= "$tid";

            if ( !empty($catkids) )
            {
                $cathash .= ",$catkids";
            }
        }
    }
    ppmysql_free_result( $boards );

    // Once we are all done, update the parent
    ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET children='$cathash',albums='$albumhash' WHERE id=$parid", $link);

    return ( $albumhash );
}


function upgradecategories( $parent=0 )
{
    global $Globals, $CatPerms, $link;

    // update categories

    if ( $parent == 0 )
    {
        // this is a full recalc - done in scan database
        $query = "SELECT id,catname,description,catorder,parent,subalbum,thumbs,children,cattype,albums FROM {$Globals['pp_db_prefix']}categories ORDER BY catorder ASC";
    }
    else
    {
        // this is for a cat, so this one and any parents
        $forcats = "$parent";
        $checkpar = $parent;

        if ( $CatPerms['cattype'][$parent] == "c" )
        {
            while ( $CatPerms['parent'][$checkpar] != 0 )
            {
                $forcats .= ",{$CatPerms['parent'][$checkpar]}";
                $checkpar = $CatPerms['parent'][$checkpar];

                if ( $checkpar == 0 )
                {
                    $forcats .= ",$checkpar";
                }
            }
        }

        $query = "SELECT id,catname,description,catorder,parent,subalbum,thumbs,children,cattype,albums FROM {$Globals['pp_db_prefix']}categories WHERE id IN ($forcats) ORDER BY id DESC";
    }

    $boards = ppmysql_query($query, $link);

    while ( list( $id, $catname, $catdesc, $order, $catparent, $subalbum, $catthumbs, $children, $cattype, $albums ) = mysql_fetch_row($boards) )
    {
        $lastposttime = $lastpostby = $lastpostlink = $lastphoid = null;
        $lastphoby = $lpholink = $newphotos = $newcomments = null;
        $laston = 0;

        if ( $children != "" && $cattype == "c" )
        {
            $children = "$id,$children";
        }
        else
        {
            $children = "$id";
        }

        // Add in any albums that this category may have
        if ( $albums )
        {
            $children .= ",$albums";
        }

        $cphotos = $catposts = 0;

        if ( $id != 500 )
        {
            // first we need to get last photo/post info
            $lastp = ppmysql_query("SELECT id,user,userid,date FROM {$Globals['pp_db_prefix']}photos WHERE cat IN ($children) ORDER BY date DESC LIMIT 1", $link);
            list( $lastphoid, $lastphoby, $lastphobyid, $lastphotime ) = mysql_fetch_row($lastp);

            // now we get the number of photos, just in this category
            $lastp2 = ppmysql_query("SELECT count(*) FROM {$Globals['pp_db_prefix']}photos WHERE cat=$id", $link);
            list ( $cphotos ) = mysql_fetch_row($lastp2);

            // now do the same for comments
            $isempty = ( $Globals['dispempty'] == "yes" ? "" : "AND LENGTH(comment) > 1" );
            $lastc = ppmysql_query("SELECT username,id,date,photo FROM {$Globals['pp_db_prefix']}comments WHERE cat IN ($children) $isempty ORDER BY date DESC LIMIT 1", $link);
            list( $lastpostby, $lastpostbyid, $lastposttime, $lastpostlink ) = mysql_fetch_row($lastc);

            $lastc2 = ppmysql_query("SELECT count(*) FROM {$Globals['pp_db_prefix']}comments WHERE cat=$id $isempty", $link);
            list ( $catposts ) = mysql_fetch_row($lastc2);

            // now we get the number of photos/comments, for any attached albums
            $album1 = ppmysql_query("SELECT photos,posts FROM {$Globals['pp_db_prefix']}categories WHERE (children=$id OR subalbum=$id) AND cattype='a'", $link);

            while ( list($albcnt, $albcomcnt) = mysql_fetch_row($album1) )
            {
                $cphotos  += $albcnt;
                $catposts += $albcomcnt;
            }

            ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET lastpost='$lastpostbyid', lastphoto='$lastphoid', posts='$catposts', photos='$cphotos' WHERE id=$id", $link);
        }
        else
        {
            if ( $Globals['memformat'] == "yes" )
            {
                $query1 = "SELECT id,user,userid,date FROM {$Globals['pp_db_prefix']}photos ORDER BY date DESC LIMIT 1";
                $query2 = "SELECT username,id,date,photo FROM {$Globals['pp_db_prefix']}comments ORDER BY date DESC LIMIT 1";
                $query3 = "SELECT count(*) FROM {$Globals['pp_db_prefix']}photos";
                $query4 = "SELECT count(*) FROM {$Globals['pp_db_prefix']}comments";
            }
            else
            {
                $query1 = "SELECT id,user,userid,date FROM {$Globals['pp_db_prefix']}photos WHERE cat=500 ORDER BY date DESC LIMIT 1";
                $query2 = "SELECT username,id,date,photo FROM {$Globals['pp_db_prefix']}comments WHERE cat=500 ORDER BY date DESC LIMIT 1";
                $query3 = "SELECT count(*) FROM {$Globals['pp_db_prefix']}photos WHERE cat=500";
                $query4 = "SELECT count(*) FROM {$Globals['pp_db_prefix']}comments WHERE cat=500";
            }

            $lastp = ppmysql_query($query1, $link);
            list( $lastphoid, $lastphoby, $lastphobyid, $lastphotime ) = mysql_fetch_row($lastp);

            $lastc = ppmysql_query($query2, $link);
            list( $lastpostby, $lastpostbyid, $lastposttime, $lastpostlink ) = mysql_fetch_row($lastc);

            $totalp = ppmysql_query($query3, $link);
            list( $cphotos ) = mysql_fetch_row($totalp);

            $totalc = ppmysql_query($query4, $link);
            list( $catposts ) = mysql_fetch_row($totalc);

            ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET lastpost='$lastpostbyid', lastphoto='$lastphoid', posts='$catposts', photos='$cphotos' WHERE id=500", $link);
        }
    }

    return;
}



function check_user_dir( $uploaduser )
{
    global $Globals;

    $filepath = "{$Globals['zipuploaddir']}/$uploaduser";

    if ( !file_exists( $filepath ) )
    {
        if ( !@mkdir( $filepath, 0755 ) )
        {
            @chmod( $Globals['zipuploaddir'], 0777 );

            // create a blank index.htm file
            $fd = fopen( $filepath."/index.htm", "w+" );
            fclose($fd);

            if ( !is_writable($filepath) )
            {
                diewell( "$filepath: {$Globals['pp_lang']['errordir']}" );
            }
        }

        @chmod( $filepath, 0777 );
    }
}

function upgradealbums( $parent=0 )
{
    global $Globals, $link;

    // update personal albums
    //
    $boards = ppmysql_query("SELECT id,catname FROM {$Globals['pp_db_prefix']}categories WHERE cattype='a'", $link);

    while ( list( $id, $albumname ) = mysql_fetch_row($boards) )
    {
        print "Processing Personal Album $albumname ...<br />";
        $cphotos = $catposts = 0;

        // now we get the number of photo, just in this category
        $lastp2 = ppmysql_query("SELECT id FROM {$Globals['pp_db_prefix']}photos WHERE cat=$id", $link);
        $cphotos = mysql_num_rows($lastp2);

        $lastc2 = ppmysql_query("SELECT id FROM {$Globals['pp_db_prefix']}comments WHERE cat=$id", $link);
        $catposts = mysql_num_rows($lastc2);

        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET posts='$catposts', photos='$cphotos' WHERE id=$id", $link);
    }

    return;
}


function topmenu()
{
    global $Globals, $Style, $link, $menu, $menu2, $User, $cat, $catquery;

    if ( isset($cat) )
    {
        $catquery = "?cat=$cat";
    }

    $menu = "<span class=\"{$Style['medium']}\">";
    $menu2 = $log = null;

    if ( $User['adminedit'] == 1 || $User['moderator'] == 1 )
    {
        if ( THIS_SCRIPT == "ppindex" )
        {
            $nump = ppmysql_query("SELECT id FROM {$Globals['pp_db_prefix']}photos WHERE approved=0", $link);
            $rows = mysql_num_rows($nump);

            if ( $rows > 0 )
            {
                $menu .= "<img border=\"0\" src=\"{$Globals['idir']}/check.gif\" alt=\"{$Globals['pp_lang']['newphotos']}\" /> ";
            }
        }

        $menu .= "<a href=\"{$Globals['maindir']}/adm-index.php\">{$Globals['pp_lang']['admin']}</a> &middot; <a href=\"{$Globals['maindir']}/\">{$Globals['pp_lang']['home']}</a>";
        $menu .= " &middot; <a rel=\"nofollow\" href=\"{$Globals['maindir']}/search.php?cat=$cat\">{$Globals['pp_lang']['search']}</a>";
    }
    else
    {
        $menu .= "<a href=\"{$Globals['maindir']}\">{$Globals['pp_lang']['home']}</a>";
        $menu .= " &middot; <a rel=\"nofollow\" href=\"{$Globals['maindir']}/search.php\">{$Globals['pp_lang']['search']}</a>";
    }

    if ( $Globals['vbversion'] == "photopost" )
    {
        if ( $Globals['usebb'] == "yes" )
        {
            $menu .= " &middot; <a href=\"". construct_newppurl( "board.php" ) ."\">{$Globals['pp_lang']['messageboard']}</a>";
        }
        $menu .= " &middot; <a href=\"". construct_newppurl( "showmembers.php", array('cat' => 500) ) ."\">{$Globals['pp_lang']['memberlist']}</a>";
    }

    if ( $User['userid'] > 0 )
    {
        if ( VB3_INTEGRATION == "off" )
        {
            $log = " &middot; <a href=\"{$Globals['maindir']}/misc.php?action=logout\">{$Globals['pp_lang']['logout']}</a>";
        }

        if ( $Globals['allowup'] == "yes" )
        {
            $menu2 .= "<a href=\"". construct_newppurl( "showgallery.php", array('ppuser' => $User['userid'], 'username' => $User['username']) ) ."\">{$Globals['pp_lang']['mygallery']}</a>";
        }

        if ( $Globals['allowpa'] == "yes" && $User['albums'] == 1 )
        {
            if ( !empty($menu2) )
            {
                $menu2 .= " &middot; ";
            }

            $menu2 .= "<a href=\"{$Globals['maindir']}/useralbums.php\">{$Globals['pp_lang']['albumadmin']}</a>";
        }

        if ( !empty($menu2) )
        {
            $menu2 .= " &middot; ";
        }

        $menu2 .= "<a rel=\"nofollow\" href=\"{$Globals['maindir']}/search.php?what=fav\">{$Globals['pp_lang']['myfavorites']}</a>";
    }
    else
    {
        if ( VB3_INTEGRATION == "off" )
        {
            $log = "&middot; <a href=\"{$Globals['maindir']}/misc.php?action=login&amp;login=yes\">{$Globals['pp_lang']['login']}</a>";
        }
    }

    if ($Globals['allowregs'] == "yes" && empty($User['userid']) )
    {
        $regtext = get_regcode();
        $menu .= $regtext;
    }

    if ( $User['userid'] > 0 )
    {
        $menu .= " &middot; <a href=\"". construct_newppurl( "member.php", array('uid' => $User['userid'], 'username' => $User['username']) ) ."\">{$Globals['pp_lang']['profile']}</a>";
    }

    if ( $User['adminedit'] == 0 )
    {
        if ( $Globals['allowup'] == "yes" && $User['uploads'] == 1 )
        {
            $menu .= " &middot; <a href=\"{$Globals['maindir']}/uploadphoto.php$catquery\">{$Globals['pp_lang']['upload']}</a>";
        }
    }
    else
    {
        $menu .= " &middot; <a href=\"{$Globals['maindir']}/uploadphoto.php$catquery\">{$Globals['pp_lang']['upload']}</a>";
    }

    if ( $User['userid'] > 0 && $Globals['usemsg'] == "yes" )
    {
        $q = ppmysql_query("SELECT count(*) FROM {$Globals['pp_db_prefix']}messages WHERE userid={$User['userid']} AND status=0", $link);
        list( $msgs ) = mysql_fetch_row($q);

        if ( $msgs )
        {
            if ( $msgs == 1 )
            {
                $menu2 .= "&nbsp;&middot;&nbsp;[ <a href=\"{$Globals['maindir']}/member.php?protype=6\">$msgs message</a> ]";
            }
            else
            {
                $menu2 .= "&nbsp;&middot;&nbsp;[ <a href=\"{$Globals['maindir']}/member.php?protype=6\">$msgs messages</a> ]";
            }
        }
        else
        {
            $menu2 .= "&nbsp;&middot;&nbsp;{$Globals['pp_lang']['lcnomessages']}";
        }
    }

    $menu .= " $log</span>";
    $menu2 = "<span class=\"{$Style['medium']}\">$menu2</span>";

    return;
}

function forward( $redirect, $msg = "" )
{
    global $Globals, $Style, $User, $ppopen, $ppclose, $vbnoheader, $vboptions;

    if ( !$msg )
    {
        $msg = "{$Globals['pp_lang']['forward']} $redirect";
    }

    if ( !$redirect)
    {
        $redirect = "index.php";
    }

    //if ( $Globals['vbversion'] == "postnuke" )
    //    $redirect = "{$Globals['vbulletin']}/modules.php?$redirect";
    //else
    $redirect = "{$Globals['maindir']}/$redirect";

    if ( isset($vbnoheader) )
    {
        $theader = str_replace( "{tablewidth}", $Globals['tablewidth'], $vbnoheader);
        $theader = str_replace( "{pagebgcolor}", $Globals['forwardbod'], $theader);
        $theader = str_replace( "\"client", "\"$vboptions[bburl]/client", $theader );

        // Lets use the vB way to forward
$redircode = <<< REDIR
    <script type="text/javascript">
    <!--
    function exec_refresh()
    {
        window.status = "Redirecting..." + myvar;
        myvar = myvar + " .";
        var timerID = setTimeout("exec_refresh();", 100);
        if (timeout > 0)
        {
            timeout -= 1;
        }
        else
        {
            clearTimeout(timerID);
            window.status = null;
            window.location = "$redirect";
        }
    }

    var myvar = null;
    var timeout = 20;
    exec_refresh();
    //-->
    </script>
REDIR;

        $theader = str_replace( "<head>","<head>\n$redircode\n<title>{$Globals['galleryname']} - {$titlereplace}</title>", $theader );
        $theader = str_replace( "{ppheader}", " ", $theader);

        $success = $theader;
    }
    else
    {
        $forwardstyle = get_forum_style();

        //$forwardstyle = "<link rel=\"stylesheet\" href=\"{$Globals['maindir']}/stylesheets/{$Globals['theme']}.css\" type=\"text/css\" />";
        //$Style['tddetails'] = "tddetails"; $Style['medium'] = "medium"; $Style['small'] = "small";

        $success = "<html><head><title>{$Globals['galleryname']}</title>
            $forwardstyle
            <meta http-equiv=\"refresh\" content=\"1; URL=$redirect\" />
            </head>
            <body leftmargin=\"10\" topmargin=\"10\" marginwidth=\"10\" marginheight=\"10\"> ";
    }

    $success .= "<br /><br />
        <table width=\"60%\" height=\"50%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\">
        <tr align=\"center\" valign=\"middle\"><td>
        $ppopen
        <tr>
        <td class=\"{$Style['tddetails']}\" align=\"center\"><p><span class=\"{$Style['medium']}\"><b>$msg</b><br/><br /></span>
        <span class=\"{$Style['small']}\"><a href=\"$redirect\">{$Globals['pp_lang']['clickhere']}</a></span></p>
        </td>
        </tr>
        $ppclose
        </td></tr></table></body></html>";

    print $success;
    exit;
}


// need to walk the parent tree to find out if we are password protected
function walk_tree( $cat )
{
    global $Globals, $CatPerms;

    if ( $CatPerms['catpass'][$cat] )
    {
        return( $CatPerms['catpass'][$cat] );
    }

    if ( $CatPerms['cattype'][$cat] == "a" )
    {
        return( $CatPerms['catpass'][500] );
    }

    // now go up the tree
    $tparent   = $CatPerms['parent'][$cat];
    $tpassword = $CatPerms['catpass'][$cat];

    while ( $tparent != 0 )
    {
        if ( $tpassword )
        {
            return( $tpassword );
        }

        $tparent   = $CatPerms['parent'][$tparent];
        $tpassword = $CatPerms['catpass'][$tparent];
    }

    return( null );
}

// need to walk the parent tree to find out if we are password protected
function walk_tree_vars( $cat )
{
    global $Globals, $link;

    $mytags = ppmysql_query_onerow("SELECT header,footer,headtags,password,ugnoview,ugnoupload,ugnopost,ugnoanno,watermark,ugnovote,sortorder,frames,ratingtype FROM {$Globals['pp_db_prefix']}categories WHERE id=$cat LIMIT 1", $link);

    return( $mytags );
}


function get_password( $cat )
{
    global $Globals, $Style, $childnav, $menu, $ppopen, $ppclose;

    setcookie( "catp", "", time()-3600);

    topmenu();
    printheader( 0, $Globals['pp_lang']['passreq'] );

    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/getpass.tmpl" );

    printfooter();
    exit;
}


function valid_email($email)
{
    // lets see if the email is valid
    if (!preg_match("/(.*?)@(.*?)\.(.*?)/", $email))
    {
        return false;
    }

    return( true );
}


function diewell( $message, $headers="yes" )
{
    global $Globals, $User, $Style, $childnav, $menu, $ppopen, $ppclose;

    if ( $Globals['texterrors'] == 1 )
    {
        print "<br><br>$message";
        exit;
    }

    if ( $headers == "yes" )
    {
        topmenu();
    }

    printheader( 0, "Message", 0, $headers );

    if ( $headers == "yes" )
    {
        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );
    }

    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/diewell.tmpl" );

    if ( $headers == "yes" )
    {
        printfooter( $headers );
    }

    exit;
}


function fixstring( $string )
{
    return( preg_replace( "/<(?:[^>']*|([']).*?\1)*>/e", "", $string ) );
}


function findenv ( $name )
{
    global $_SERVER, $_ENV, $PHP_SELF;

    $envvar = null;

    if( getenv($name) != "" )
    {
        $envvar = getenv("$name");
    }
    elseif(($envvar == "") && !empty($_ENV['$name']))
    {
        $envvar = $_ENV['$name'];
    }
    elseif(($envvar == "") && !empty($_SERVER['$name']))
    {
        $envvar = $_SERVER['$name'];
    }
    elseif ($envvar == "" && $name == "PHP_SELF" && !empty($PHP_SELF))
    {
        $envvar = $PHP_SELF;
    }
	else if($name == "PATH_INFO" && $envvar == null && isset($_SERVER['REQUEST_URI']))
	{
		$envvar = str_replace($_SERVER['PHP_SELF'], '', $_SERVER['REQUEST_URI']);
	}

   return $envvar;
}


function wordchars( $string )
{
    global $Globals;

    $stripstring = @ereg_replace( "[^a-zA-Z0-9/\: _\-]", "", $string );

    if ( strcmp($string, $stripstring) )
    {
        diewell( $Globals['pp_lang']['erroruser'] );
    }

    return ( $stripstring );
}



function delete_dir($file)
{
    if ( file_exists($file) )
    {
        @chmod( $file, 0777 );

        if ( is_dir($file) )
        {
            $handle = opendir( $file );

            while( $filename = readdir($handle) )
            {
                if ( $filename != "." && $filename != ".." )
                {
                    delete_dir( $file."/".$filename );
                }
            }

            closedir($handle);
            rmdir($file);
        }
        else
        {
            unlink($file);
        }
    }
}

function remove_all_files( $filename, $medsize, $uid, $thecat )
{
    global $Globals;

    $theext = get_ext($filename);
    $filenoext = get_filename($filename);

    // Try everything
    @unlink("{$Globals['datafull']}$thecat/thumbs/$filename");
    @unlink("{$Globals['datafull']}$thecat/thumbs/$filenoext.jpg");
    @unlink("{$Globals['origfull']}$thecat/$filename");
    @unlink("{$Globals['datafull']}$thecat/medium/$filename");
}

function mkppdir( $datadir, $dironly = false )
{
    global $Globals, $Style, $User;

    if ( !is_writable($datadir) )
    {
        @mkdir( $datadir, 0755 );
        @chmod( $datadir, 0777 );

        if ( !is_writable($datadir) )
        {
            diewell( "Unable to create/write to $datadir! Check your data directory permissions before continuing." );
            exit;
        }

        // create a blank index.htm file
        $fd = fopen( "$datadir/index.htm", "w+" );
        fclose($fd);
    }

    if ( $dironly )
    {
        return;
    }

    // Make new thumbs directory
    @mkdir( "$datadir/thumbs", 0755 );
    @chmod( "$datadir/thumbs", 0777 );
    $fd = fopen( "$datadir/thumbs/index.htm", "w+" );
    fclose($fd);

    // Make new medium directory
    @mkdir( "$datadir/medium", 0755 );
    @chmod( "$datadir/medium", 0777 );
    $fd = fopen( "$datadir/medium/index.htm", "w+" );
    fclose($fd);

    // Make new mini directory
    @mkdir( "$datadir/mini", 0755 );
    @chmod( "$datadir/mini", 0777 );
    $fd = fopen( "$datadir/mini/index.htm", "w+" );
    fclose($fd);

    return;
}

function move_image( $pcat, $catmove, $tuserid, $bigimage )
{
    global $Globals;

    $olddir = "{$Globals['datafull']}$pcat";
    $newdir = "{$Globals['datafull']}$catmove";

    // lets make sure we can write and try to fix any problems if we encounter them
    if ( !file_exists($newdir) )
    {
        if ( !mkdir( $newdir, 0755 ) )
        {
            diewell( "Directory not found and creating directory: $newdir. Please check the permissions to your data directory." );
        }

        @chmod( $newdir, 0777 );

        // create a blank index.htm file
        $fd = fopen( "$newdir/index.htm", "w+" );
        fclose($fd);
    }

    if ( !is_writable($newdir) )
    {
        @chmod( $newdir, 0777 );

        if ( !is_writable($newdir) )
        {
            diewell( "Unable to write to or correct: $newdir.<br />You will need to manually adjust the permissions to this directory." );
        }
    }

    $theext = get_ext( $bigimage );
    $filename = str_replace( $theext, "", $bigimage);

    $biglink = "$olddir/$bigimage";
    $newbiglink = "$newdir/$bigimage";

    $thumblink = "$olddir/thumbs/$bigimage";
    $newthumblink = "$newdir/thumbs/$bigimage";
    $mmthumb = "$olddir/thumbs/$filename.jpg";
    $newmmthumb = "$newdir/thumbs/$filename.jpg";

    $mediumlink = "$olddir/medium/$bigimage";
    $newmediumlink = "$newdir/medium/$bigimage";

    if ( file_exists($biglink) )
    {
        if ( @copy($biglink, $newbiglink) )
        {
            @unlink( $biglink );
        }
        else
        {
            diewell( "$biglink -> $newbiglink<br />{$Globals['pp_lang']['errorcopy']}" );
        }
    }
    else
    {
        // Look in original directory
        $oldorig = "{$Globals['origfull']}$pcat/$bigimage";

        if ( file_exists($oldorig) )
        {
            $neworig = "{$Globals['origfull']}$catmove/$bigimage";

            if ( @copy($oldorig, $neworig) )
            {
                @unlink( $oldorig );
            }
            else
            {
                diewell( "$oldorig -> $neworig<br />{$Globals['pp_lang']['errorcopy']}" );
            }
        }
    }

    if ( file_exists($mediumlink) )
    {
        if ( @copy($mediumlink, $newmediumlink) )
        {
            @unlink( $mediumlink );
        }
        else
        {
            @unlink( $newbiglink );
            diewell( "$mediumlink -> $newmediumlink<br />{$Globals['pp_lang']['errorcopy']}" );
        }
    }

    if ( file_exists($thumblink) )
    {
        if ( @copy($thumblink, $newthumblink) )
        {
            @unlink( $thumblink );
        }
        else
        {
            @unlink( $newbiglink );
            @unlink( $newmediumlink );
            diewell( "$thumblink -> $newthumblink<br />{$Globals['pp_lang']['errorcopy']}" );
        }
    }

    if ( file_exists($mmthumb) )
    {
        if ( @copy($mmthumb, $newmmthumb) )
        {
            @unlink( $mmthumb );
        }
        else
        {
            @unlink( $newbiglink );
            @unlink( $newmediumlink );
            diewell( "$thumblink -> $newmmthumb<br />{$Globals['pp_lang']['errorcopy']}" );
        }
    }
}


function updateparents( $parent )
{
    global $Globals, $link;

    do
    {
        catlist( $parent );

        $catp = ppmysql_query("SELECT parent FROM {$Globals['pp_db_prefix']}categories WHERE id=$parent", $link);
        list( $parent ) = mysql_fetch_row($catp);
    } while( $parent != 0 );

    return;
}


function adminlog( $what )
{
    global $Globals, $User, $link;

    $ipaddr = findenv("REMOTE_ADDR");
    $date = time();
    $what = addslashes($what);
    $username = addslashes($User['username']);

    $resultb = ppmysql_query("REPLACE INTO {$Globals['pp_db_prefix']}admlog (adminuser,ip,datestamp,description) VALUES ('$username','$ipaddr','$date','$what')", $link);
}


function send_ppmsg( $puserid, $msgtext, $photo, $type )
{
    global $Globals, $User, $link;

    if ( $Globals['usemsg'] == "yes" && ($puserid && $msgtext) )
    {
        $julian = time();
        $msgtext = addslashes( $msgtext );

        ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}messages (msgid,userid,datestamp,message,type,photo) values(NULL, $puserid, $julian, '$msgtext', '$type', $photo)", $link);
    }
}


function delete_cat( $catid, $cattype )
{
    global $Globals, $link;

    // Delete category from categories table
    if ( !is_numeric($catid) )
    {
        diewell( "Malformed call to delete_cat ($catid)" );
    }

    if ( $cattype == "c" )
    {
        // first, delete children
        $cats = ppmysql_query("SELECT id FROM {$Globals['pp_db_prefix']}categories WHERE parent=$catid AND cattype='c'", $link);

        while ( list( $subcatid ) = mysql_fetch_row($cats) )
        {
            delete_cat( $subcatid, $cattype );
        }

        // get the parent, so we can update the children after we remove it
        $cats = ppmysql_query("SELECT parent FROM {$Globals['pp_db_prefix']}categories WHERE id=$catid", $link);
        list( $subparent ) = mysql_fetch_row($cats);

        $cats = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}categories WHERE id=$catid", $link);

        // now we update the children
        updateparents( $subparent );
    }
    else
    {
        $cats = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}categories WHERE id=$catid", $link);
    }

    $resulta = ppmysql_query("SELECT userid,bigimage,medsize,title FROM {$Globals['pp_db_prefix']}photos WHERE cat=$catid", $link);
    while ( list( $uid, $bigimage, $medsize, $title ) = mysql_fetch_row($resulta) )
    {
        remove_all_files( $bigimage, $medsize, $uid, $catid );
    }

    //# end delete the files //#
    ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}photos WHERE cat=$catid", $link);
    ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}comments WHERE cat=$catid", $link);

    if ( file_exists( "{$Globals['datafull']}$catid" ) )
    {
        delete_dir( $photodir );
    }
}


function admin_email( $ppactionvar, $photonum, $getuserid=0, $phototitle="" )
{
    global $Globals, $Style, $link, $pplang;

    if ( $getuserid == 0 )
    {
        $results = ppmysql_query("SELECT userid,title FROM {$Globals['pp_db_prefix']}photos WHERE id=$photonum", $link);
        list( $getuserid, $phototitle ) = mysql_fetch_row($results);
    }

    list( $tuserid, $usernm, $useremail ) = get_userinfo( "", $getuserid );

    if ( empty($useremail) )
    {
        return;
    }

    $email_from = "From: {$Globals['adminemail']}";
    include "{$Globals['PP_PATH']}/languages/$pplang.php";

    if ($ppactionvar == "approve")
    {
        $letter = $Globals['pp_lang']['emailapp'];
        $subject = $Globals['pp_lang']['emailasub'];
    }

    if ($ppactionvar == "moved")
    {
        $letter = $Globals['pp_lang']['emailmove'];
        $subject = $Globals['pp_lang']['emailmsub'];
    }

    if ($ppactionvar == "delete")
    {
        $letter = $Globals['pp_lang']['emaildel'];
        $subject = $Globals['pp_lang']['emaildsub'];
    }

    $letter = stripslashes($letter);
    mail( $useremail, $subject, $letter, $email_from );
}



function move_image_cat( $pid, $catmove, $forward="yes" )
{
    global $Globals, $link, $User, $page;

    $resulta = ppmysql_query("SELECT userid,cat,storecat,storeid,bigimage,medsize,title FROM {$Globals['pp_db_prefix']}photos WHERE id=$pid", $link);
    list( $puserid, $pcat, $storecat, $storeid, $bigimage, $medsize, $ptitle ) = mysql_fetch_row($resulta);

    if ( ($User['userid'] == $puserid && $Globals['usermove'] == "yes") || $User['adminedit'] == 1 || $User['moderator'] == 1 )
    {
        $cratetype = ppmysql_query("SELECT ratingtype FROM {$Globals['pp_db_prefix']}categories WHERE id=$pcat", $link);
        list( $ratingtype ) = mysql_fetch_row($cratetype);

        $cratetype = ppmysql_query("SELECT ratingtype FROM {$Globals['pp_db_prefix']}categories WHERE id=$catmove", $link);
        list( $moverating ) = mysql_fetch_row($cratetype);

        if ( ($ratingtype == 1 && $moverating == 0) || ($ratingtype == 0 && $moverating == 1) )
        {
            // If this is moved from a voting category to a non-voting category, then we need to reset rating (or visaversa)
            ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET rating=0 WHERE id=$pid", $link);
            ppmysql_query("UPDATE {$Globals['pp_db_prefix']}comments SET rating=0 WHERE photo=$pid", $link);
        }

        // only move an original image
        if ( $storecat == 0 )
        {
            move_image( $pcat, $catmove, $puserid, $bigimage );
        }

        if ( $User['usemod'] == 0 )
        {
            $approved = 1; // No moderation
        }
        else
        {
            $approved = 0; // Moderate this
        }

        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET cat=$catmove, approved=$approved WHERE id=$pid", $link);

        // if this is one of many, then we have to update all to point to new location
        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET storecat=$catmove WHERE storeid=$pid", $link);
        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}comments SET cat=$catmove WHERE photo=$pid", $link);

        upgradecategories( $pcat );
        upgradecategories( $catmove );

        if ( $Globals['useemail'] == "yes" && $User['userid'] != $puserid )
        {
            admin_email( 'moved', $pid, $puserid, $ptitle ) ;
        }

        $ipaddr = findenv("REMOTE_ADDR");
        $date = time();
        $what = "Moved Image: $bigimage from $pcat to $catmove";
        $what = addslashes($what);

        $resultb = ppmysql_query("REPLACE INTO {$Globals['pp_db_prefix']}admlog (adminuser,ip,datestamp,description) VALUES ('{$User['username']}','$ipaddr','$date','$what')", $link);

        if ( $forward == "yes" )
        {
            forward( "showphoto.php?photo=$pid&amp;page=$page", "{$Globals['pp_lang']['moved']} $bigimage" );
        }
    }
    else
    {
        diewell( "{$Globals['pp_lang']['errorperm']}" );
    }
}

function fixcolor( $string="" )
{
    $string = str_replace(" ", "", $string);
    $string = str_replace("\"", "", $string);

    return( "<span color=\"$string\">" );
}


function is_multimedia( $filename )
{
    global $Globals;

    $mediatypes = explode( ",", $Globals['acceptmm'] );
    $ext = strtolower( get_ext($filename) );

    if ( in_array($ext, $mediatypes) )
    {
        return( true );
    }

    return( false );
}


function is_image( $filename )
{
    global $Globals;

    $imagetypes = explode( ",", $Globals['acceptimg'] );
    $ext = strtolower( get_ext($filename) );

    if ( in_array($ext, $imagetypes) )
    {
        return( true );
    }

    return( false );
}



function get_imagethumb( $bigimage, $thecat, $theuser, $approved, $nocache=0, $avatar=0, $thumbw=0, $thumbh=0, $title='' )
{
    global $Globals, $User, $thumbtag;

    $thumbtag = null;

    if ( $title )
    {
        $title = htmlspecialchars( $title );
    }
    else
    {
        $title = htmlspecialchars( $bigimage );
    }

    if ( empty($bigimage) )
    {
        return( null );
    }

    if ( $approved == 0 )
    {
        $imgtag = "<img border=\"0\" src=\"{$Globals['idir']}/ipending.gif\" alt=\"$bigimage\" />";
        return( $imgtag );
    }

    $imgsize = null;

    if ( $avatar == 1 )
    {
        if ( $thumbh < $thumbw )
        {
            $scaleFactor = $thumbw / $Globals['previewwidth'];
        }
        else
        {
            $scaleFactor = $thumbh / $Globals['previewwidth'];
        }

        if ( $thumbh && $thumbw && !is_multimedia($bigimage) )
        {
            $imgh = round( $thumbh / $scaleFactor ) * .5;
            $imgw = round( $thumbw / $scaleFactor ) * .5;
            $imgsize = "height=\"$imgh\" width=\"$imgw\"";
        }
        else
        {
            $imgsize = "width=\"50\" height=\"37\"";
        }
    }

    $photoname = get_filename( $bigimage );
    $theext = get_ext( $bigimage );

    $filepath = "{$Globals['datafull']}/$thecat/thumbs/$bigimage";
    $fileurl = "{$Globals['datadir']}/$thecat/thumbs/$bigimage";

    $imgtag = "<img border=\"0\" $imgsize src=\"{$Globals['idir']}/nothumb.gif\" alt=\"$fileurl\" />";

    $rand = ( $nocache == 1 ? "?" . rand(0,9999) : null );

    if ( file_exists($filepath) )
    {
        if ( VB40 == "on" && $avatar == 1 )
        {
            $imgtag = "<img class=\"forumicon\" title=\"$title\" border=\"0\" src=\"$fileurl$rand\" alt=\"$bigimage\" />";
        }
        else
        {
            $imgtag = "<img title=\"$title\" border=\"0\" $imgsize src=\"$fileurl$rand\" alt=\"$bigimage\" />";
        }
        $thumbtag = $fileurl;
    }
    else
    {
        $theext = strtolower( $theext );
        $filepath2 = "{$Globals['datafull']}/$thecat/thumbs/$photoname.jpg";
        $fileurl2 = "{$Globals['datadir']}/$thecat/thumbs/$photoname.jpg$rand";

        if ( file_exists($filepath2) )
        {
            if ( VB40 == "on" && $avatar == 1 )
            {
                $imgtag = "<img class=\"forumicon\" title=\"$title\" border=\"0\" width=\"50\" height=\"37\" src=\"$fileurl2$rand\" alt=\"$bigimage\" />";
            }
            else
            {
                $imgtag = "<img title=\"$title\" border=\"0\" $imgsize src=\"$fileurl2$rand\" alt=\"$bigimage\" />";
            }
            $thumbtag = $fileurl2;
        }
        else
        {
            if ( is_multimedia($bigimage) )
            {
                if ( $avatar == 0 )
                {
                    $imgsize = "width=\"120\" height=\"78\"";
                }

                $imgtag = "<img title=\"$title\" border=\"0\" $imgsize src=\"{$Globals['idir']}/video.gif\" alt=\"$bigimage\" />";
                $thumbtag = "{$Globals['idir']}/video.gif";

                 if ( stristr($bigimage,".mov") )
                 {
                    $thumbtag = "{$Globals['idir']}/mm-qt.gif";
                    $imgtag = "<img title=\"$title\" border=\"0\" $imgsize src=\"{$Globals['idir']}/mm-qt.gif\" alt=\"\" />";
                 }
                 elseif ( stristr($bigimage,".wmv") || stristr($bigimage,".mpg") || stristr($bigimage,".avi") )
                 {
                    $thumbtag = "{$Globals['idir']}/mm-ms.gif";
                    $imgtag = "<img title=\"$title\" border=\"0\" $imgsize src=\"{$Globals['idir']}/mm-ms.gif\" alt=\"\" />";
                 }
                 elseif( stristr($bigimage,".fla") || stristr($bigimage,".swf") )
                 {
                    $thumbtag = "{$Globals['idir']}/mm-fla.gif";
                    $imgtag = "<img title=\"$title\" border=\"0\" $imgsize src=\"{$Globals['idir']}/mm-fla.gif\" alt=\"\" />";
                 }
                 elseif( stristr($bigimage,".mp3") || stristr($bigimage,".wav") || stristr($bigimage,".mid") || stristr($bigimage,".aiff") )
                 {
                    $thumbtag = "{$Globals['idir']}/mm-audio.gif";
                    $imgtag = "<img title=\"$title\" border=\"0\" $imgsize src=\"{$Globals['idir']}/mm-audio.gif\" alt=\"\" />";
                 }
                 elseif( stristr($bigimage,".rm") )
                 {
                    $thumbtag = "{$Globals['idir']}/mm-real.gif";
                    $imgtag = "<img title=\"$title\" border=\"0\" $imgsize src=\"{$Globals['idir']}/mm-real.gif\" alt=\"\" />";
                 }
            }
        }
    }

    return( $imgtag );
}


function get_rate_code( $onclick, $rating = 0 )
{
    global $Globals, $Style;

    $clickcode = ( $onclick == 1 ? "onclick=\"this.form.submit()\"" : "" );

    if ( $onclick == 1 )
    {
        $retcode .= "{$Globals['pp_lang']['quickrate']}: {$Globals['pp_lang']['poor']} ";
    }
    else
    {
        $retcode .= "{$Globals['pp_lang']['poor']} ";
    }

    $retcode .= "<input type=\"radio\" name=\"rating\" value=\"1\" $clickcode". ($rating==1 ? " checked=\"checked\"" : ""). " />
          <input type=\"radio\" name=\"rating\" value=\"2\" $clickcode". ($rating==2 ? " checked=\"checked\"" : ""). " />
          <input type=\"radio\" name=\"rating\" value=\"3\" $clickcode". ($rating==3 ? " checked=\"checked\"" : ""). " />
          <input type=\"radio\" name=\"rating\" value=\"4\" $clickcode". ($rating==4 ? " checked=\"checked\"" : ""). " />
          <input type=\"radio\" name=\"rating\" value=\"5\" $clickcode". ($rating==5 ? " checked=\"checked\"" : ""). " />
          <input type=\"radio\" name=\"rating\" value=\"6\" $clickcode". ($rating==6 ? " checked=\"checked\"" : ""). " />
          <input type=\"radio\" name=\"rating\" value=\"7\" $clickcode". ($rating==7 ? " checked=\"checked\"" : ""). " />
          <input type=\"radio\" name=\"rating\" value=\"8\" $clickcode". ($rating==8 ? " checked=\"checked\"" : ""). " />
          <input type=\"radio\" name=\"rating\" value=\"9\" $clickcode". ($rating==9 ? " checked=\"checked\"" : ""). " />
          <input type=\"radio\" name=\"rating\" value=\"10\" $clickcode". ($rating==10 ? " checked=\"checked\"" : ""). " />
          {$Globals['pp_lang']['excellent']}";

    return( $retcode );
}



function login( $redirect )
{
    global $Globals, $Style, $User, $link, $ppopen, $ppclose, $db_link;

    list( $forgot_link, $register_link ) = get_logincode();

    printheader( 0, "Login" );
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/login.tmpl" );
    printfooter();

    return(1);
}


function update_catprops()
{
    global $Globals, $link;

    if ( $Globals['cachetimeout'] == 0 || $Globals['catcache'] == "no" )
    {
        // Do nothing
        return;
    }

    $allcats = array();
    $resultb = ppmysql_query("SELECT id,ugnoupload,ugnoview,password,cattype,ismember,catname,parent,children,thumbs,canzip,moderators,header,footer,headtags,subalbum FROM {$Globals['pp_db_prefix']}categories", $link);

    // need to do this loop for each group user is a member of
    while ( $row = mysql_fetch_row($resultb) )
    {
        $arraykey = $row[0];
        $allcats[$arraykey] = $row;
    }

    // Now lets write it to the cache
    $slashcache = addslashes(serialize($allcats));
    ppmysql_query("UPDATE {$Globals['pp_db_prefix']}cache SET catprops='$slashcache' WHERE id=1", $link);

    return;
}


function set_user_perms( $usergroups )
{
    global $Globals, $User, $link, $up_k, $disk_k, $offset, $ueditpho, $ueditposts;

    $gquery = null;
    foreach ( $usergroups as $groupvalue )
    {
        if ( is_numeric($groupvalue) )
        {
            $gquery .= ( $gquery ? "OR groupid=$groupvalue " : "groupid=$groupvalue ");
        }
    }

    $xloop = $unl_up = $unl_disk = $nouploadlimit = $nomod = 0;
    $User['usergroups'] = $usergroups;

    $result = ppmysql_query("SELECT groupid,cpaccess,modaccess,diskspace,uploadsize,uplimit,uploads,comments,editpho,editposts,useralbums,reqmod,canassign FROM {$Globals['pp_db_prefix']}usergroups WHERE $gquery", $link);
    while( list( $usergroup,$cpaccess_a,$modaccess_a,$diskspace_a,$uploadsize_a,$uplimit_a,$uploads_a,$comments_a,$ueditpho_a,$ueditposts_a,$useralb_a,$reqmod_a,$assign_a ) = mysql_fetch_row($result) )
    {
        if ( $cpaccess_a   || !$User['adminedit']   ) $User['adminedit']   = $cpaccess_a;
        if ( $modaccess_a  || !$User['moderator']   ) $User['moderator']   = $modaccess_a;
        if ( $diskspace_a  >  $disk_k       ) $disk_k      = $diskspace_a;
        if ( $uploadsize_a >  $up_k         ) $up_k        = $uploadsize_a;
        if ( $uploads_a    || !$User['uploads'] ) $User['uploads'] = $uploads_a;
        if ( $comments_a   || !$User['comments'] ) $User['comments'] = $comments_a;
        if ( $ueditpho_a   || !$ueditpho    ) $ueditpho    = $ueditpho_a;
        if ( $ueditposts_a || !$ueditposts  ) $ueditposts  = $ueditposts_a;
        if ( $useralb_a    || !$User['albums'] ) $User['albums'] = $useralb_a;
        if ( $reqmod_a     || !$User['usemod'] ) $User['usemod'] = $reqmod_a;
        if ( $assign_a     || !$User['assign'] ) $User['assign'] = $assign_a;
        if ( $uplimit_a > $User['uploadlimit'] ) $User['uploadlimit'] = $uplimit_a;

        if ( $reqmod_a     == 0 ) $nomod = 1;
        if ( $uplimit_a    == 0 ) $nouploadlimit = 1;
        if ( $diskspace_a  == 0 ) $unl_disk = 1;
        if ( $uploadsize_a == 0 ) $unl_up = 1;
    }

    set_group_perms();
    unset( $Globals['cats'] );

    // If any of these values were "unlimited" or "no", then they override any other group setting
    // (i.e. if one group has no upload limit, then the user has no upload limit)

    if ( $nomod == 1 )
    {
        $User['usemod'] = 0;
    }

    if ( $unl_up == 1 )
    {
        $up_k = 0;
    }

    if ( $unl_disk == 1 )
    {
        $disk_k = 0;
    }

    if ( $nouploadlimit == 1 )
    {
        $User['uploadlimit'] = 0;
    }

    $Globals['offset'] = $offset;

    if ( $gologin == 1 )
    {
        $User['username'] = $Globals['pp_lang']['unreg'];
        $User['userid'] = 0;
        $Globals['offset'] = $Globals['gmtoffset'];
    }

    return;
}

function set_group_perms()
{
    global $Globals, $User, $link, $CatPerms, $cacheq;

    if ( $Globals['cachetimeout'] == 0 || empty($cacheq['catprops']) || $Globals['catcache'] == "no" )
    {
        // Manually cache the categories
        $allcats = array();
        $query = "SELECT id,ugnoupload,ugnoview,password,cattype,ismember,catname,parent,children,thumbs,canzip,moderators,header,footer,headtags,subalbum,ugnopost,ugnovote FROM {$Globals['pp_db_prefix']}categories";
        $resultb = ppmysql_query($query,$link);

        // need to do this loop for each group user is a member of
        while ( $row = mysql_fetch_row($resultb) )
        {
            $arraykey = $row[0];
            $allcats[$arraykey] = $row;
        }
        ppmysql_free_result( $resultb );
    }
    else
    {
        $allcats = &$cacheq['catprops'];
    }

    foreach( $allcats as $cat )
    {
        $cuid = $cat[0];

        // Other category info we'll use later
        $CatPerms['catpass'][$cuid] = $cat[3];
        $CatPerms['cattype'][$cuid] = $cat[4];
        $CatPerms['ismember'][$cuid] = $cat[5];
        $CatPerms['catname'][$cuid] = $cat[6];
        $CatPerms['parent'][$cuid] = $cat[7];
        $CatPerms['children'][$cuid] = $cat[8];
        $CatPerms['thumbs'][$cuid] = $cat[9];

        if ( $cat[10] == "yes" ) $CatPerms['canzip'][$cuid] = 1;

        // Category mods
        $CatPerms['mods'][$cuid] = $cat[11];

        // Category specific header, footer and head tags
        if ( $cat[12] ) $CatPerms['header'][$cuid] = $cat[12];
        if ( $cat[13] ) $CatPerms['footer'][$cuid] = $cat[13];
        if ( $cat[14] ) $CatPerms['headtags'][$cuid] = $cat[14];

        // Subalbum of (only for albums)
        if ( $cat[15] && $cat[4] == "a" ) $CatPerms['subalbum'][$cuid] = $cat[15];

        if ( $cat[4] == "c" )
        {
            // We only need to do these permissions for actual categories (not albums)

            $CatPerms['ugcat'][$cuid] = $CatPerms['ugview'][$cuid] = 1;

            // Do usergroup permissions
            foreach( $User['usergroups'] AS $usergroup )
            {
                // We need to grab all the groups which are allowed for each item
                // and cross-ref with our users groups; enabling if allowed

                $allnoup = explode( ",", $cat[1] );
                if ( !in_array( $usergroup, $allnoup ) )
                {
                    $CatPerms['ugcat'][$cuid] = 0;
                }

                $allnoview = explode( ",", $cat[2] );
                if ( !in_array( $usergroup, $allnoview ) )
                {
                    $CatPerms['ugview'][$cuid] = 0;
                }
                $allnopost = explode( ",", $cat[16] );
                if ( !in_array( $usergroup, $allnopost ) )
                {
                    $CatPerms['ugpost'][$cuid] = 0;
                }

                $allnovote = explode( ",", $cat[17] );
                if ( !in_array( $usergroup, $allnovote ) )
                {
                    $CatPerms['ugvote'][$cuid] = 0;
                }
            }
        }
    }

    // Lastly, grab some $User info
    $User['mature'] = 0;

    if ( $User['userid'] > 0 )
    {
        $quser = ppmysql_query_one("SELECT username,mature FROM {$Globals['pp_db_prefix']}users WHERE userid={$User['userid']} LIMIT 1", $link);

        if ( !$quser )
        {
            $uq = addslashes( $User['username'] );
            ppmysql_query("INSERT IGNORE INTO {$Globals['pp_db_prefix']}users (userid,username) VALUES({$User['userid']},'$uq')", $link);
        }
        elseif( $User['username'] != $quser['username'] )
        {
            $uq = addslashes( $User['username'] );
            ppmysql_query("UPDATE {$Globals['pp_db_prefix']}users SET username='$uq' WHERE userid={$User['userid']} LIMIT 1", $link);
            ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET user='$uq' WHERE userid={$User['userid']}", $link);
            ppmysql_query("UPDATE {$Globals['pp_db_prefix']}comments SET username='$uq' WHERE userid={$User['userid']}", $link);
        }
        else
        {
            $User['mature'] = $quser['mature'];
        }
    }

    return;
}


function get_whoonline( $cat = null )
{
    global $Globals, $User, $link;

    if ( $cat )
    {
        // Only for actual categories or albums (otherwise ignore)
        $cat = (int)$cat;
    }

    if ( $cat )
    {
        $oqueryz = ppmysql_query("SELECT userid,date,uid,what FROM {$Globals['pp_db_prefix']}iponline WHERE item=$cat ORDER BY date DESC", $link);
    }
    else
    {
        $oqueryz = ppmysql_query("SELECT userid,date,uid,what FROM {$Globals['pp_db_prefix']}iponline ORDER BY date DESC", $link);
    }

    $onumfound = $anononline = 0;
    $whoonline = null;
    $online_array = array();

    while ( list($ouser, $odate, $ouid, $owhat) = mysql_fetch_row($oqueryz))
    {
        $onumfound++;

        if ( $ouid )
        {
            if ( $owhat == "index" ) $where = $Globals['pp_lang']['tablehead'];
            elseif ( $owhat == "showphoto" ) $where = $Globals['pp_lang']['viewingphoto'];
            elseif ( $owhat == "register" ) $where = $Globals['pp_lang']['registering'];
            elseif ( $owhat == "member" ) $where = $Globals['pp_lang']['viewingprofile'];
            elseif ( $owhat == "showgallery" ) $where = $Globals['pp_lang']['viewinggallery'];
            elseif ( $owhat == "search" ) $where = $Globals['pp_lang']['searching'];
            else $owhat = "";

            array_push($online_array, "<a title=\"$where\" href=\"". construct_newppurl( "member.php", array('uid' => $ouid, 'username' => $ouser) ) ."\">$ouser</a>");
        }
        else
        {
            $anononline++;
        }
    }

    $online_array = array_unique($online_array);

    while (list (, $val) = each ($online_array))
    {
        if ( $whoonline )
        {
            $whoonline .= ", ";
        }

        $whoonline .= "$val";
    }

    if ( $onumfound )
    {
        $whogreet = null;

        if ( $whoonline )
        {
            $whoonline = "$whoonline";

            if ( $anononline )
            {
                if ( $anononline == 1 )
                {
                    $whoonline .= " {$Globals['pp_lang']['and']} $anononline {$Globals['pp_lang']['unruser']}";
                }
                else
                {
                    $whoonline .= " {$Globals['pp_lang']['and']} $anononline {$Globals['pp_lang']['unrusers']}";
                }
            }
        }
        else
        {
            if ( $anononline == 1 )
            {
                $whoonline .= "$anononline {$Globals['pp_lang']['unruser']}";
            }
            else
            {
                $whoonline .= "$anononline {$Globals['pp_lang']['unrusers']}";
            }
        }

        $whoonline = "{$whogreet}{$whoonline}";
    }

    return( $whoonline );
}


function update_whoonline( $thiscat )
{
    global $Globals, $User, $link, $photo;

    $what = findenv( "SCRIPT_NAME" );
    $script['0'] = null;

    preg_match ( "/(.*)\/(.*).php/", $what, $script );
    $what = $script['2'];
    $what = addslashes($what);

    if ( ( THIS_SCRIPT == "showphoto" || THIS_SCRIPT == "showfull" ) && $photo )
    {
        $where = (int)$photo;
    }
    else
    {
        $where = addslashes($thiscat);
    }

    $date = time();
    $ipaddr = findenv("REMOTE_ADDR");

    if ( !$User['userid'] )
    {
        $User['userid'] = 0;
    }

    if ( $User['userid'] < 1 )
    {
        $username = $Globals['pp_lang']['guest'];
    }
    else
    {
        $username = addslashes($User['username']);
        ppmysql_query("UPDATE IGNORE {$Globals['pp_db_prefix']}users SET username='$username',laston=$date WHERE userid={$User['userid']} LIMIT 1", $link);
    }

    $agent = addslashes($_SERVER['HTTP_USER_AGENT']);
    $referer = addslashes($_SERVER['HTTP_REFERER']);
    $whoami = findenv( "SERVER_NAME" );

    if ( $referer && !stristr($referer, $whoami) )
    {
        ppmysql_query("REPLACE INTO {$Globals['pp_db_prefix']}iponline (ipaddr,userid,uid,date,what,item,agent,referer) VALUES ('$ipaddr','$username',{$User['userid']},'$date','$what','$where','$agent','$referer')", $link);
    }
    else
    {
        ppmysql_query("REPLACE INTO {$Globals['pp_db_prefix']}iponline (ipaddr,userid,uid,date,what,item,agent) VALUES ('$ipaddr','$username',{$User['userid']},'$date','$what','$where','$agent')", $link);
    }

    return;
}


function cache_catonline()
{
    global $Globals, $CatPerms, $User, $link;

    $catonline = array();

    $eachonline = ppmysql_query("SELECT item, count(*) FROM {$Globals['pp_db_prefix']}iponline GROUP BY item", $link);

    while ( list( $item, $itemonline ) = mysql_fetch_row($eachonline) )
    {
        if ( $item > 0 )
        {
            if ( $CatPerms['cattype'][$item] == "a" )
            {
                $catonline[500] += $itemonline;
            }
            else
            {
                $catonline[$item] += $itemonline;
            }
        }
    }

    return( $catonline );
}


function ppconvert_markups( $markup )
{
    global $Globals;

    $preg = array(
              '/(?<!\\\\)\[color(?::\w+)?=(.*?)\](.*?)\[\/color(?::\w+)?\]/si'   => "<span style=\"color:\\1\">\\2</span>",
              '/(?<!\\\\)\[size(?::\w+)?=(.*?)\](.*?)\[\/size(?::\w+)?\]/si'     => "<span style=\"font-size:\\1\">\\2</span>",
              '/(?<!\\\\)\[font(?::\w+)?=(.*?)\](.*?)\[\/font(?::\w+)?\]/si'     => "<span style=\"font-family:\\1\">\\2</span>",
              '/(?<!\\\\)\[align(?::\w+)?=(.*?)\](.*?)\[\/align(?::\w+)?\]/si'   => "<div style=\"text-align:\\1\">\\2</div>",
              '/(?<!\\\\)\[b(?::\w+)?\](.*?)\[\/b(?::\w+)?\]/si'                 => "<span style=\"font-weight:bold\">\\1</span>",
              '/(?<!\\\\)\[i(?::\w+)?\](.*?)\[\/i(?::\w+)?\]/si'                 => "<span style=\"font-style:italic\">\\1</span>",
              '/(?<!\\\\)\[u(?::\w+)?\](.*?)\[\/u(?::\w+)?\]/si'                 => "<span style=\"text-decoration:underline\">\\1</span>",
              '/(?<!\\\\)\[center(?::\w+)?\](.*?)\[\/center(?::\w+)?\]/si'       => "<div style=\"text-align:center\">\\1</div>",

              // [code] & [php]
              '/(?<!\\\\)\[code(?::\w+)?\](.*?)\[\/code(?::\w+)?\]/si'           => "<div class=\"bb-code\">\\1</div>",
              '/(?<!\\\\)\[php(?::\w+)?\](.*?)\[\/php(?::\w+)?\]/si'             => "<div class=\"bb-php\">\\1</div>",
              // [email]
              '/(?<!\\\\)\[email(?::\w+)?\](.*?)\[\/email(?::\w+)?\]/si'         => "<a href=\"mailto:\\1\" class=\"bb-email\">\\1</a>",
              '/(?<!\\\\)\[email(?::\w+)?=(.*?)\](.*?)\[\/email(?::\w+)?\]/si'   => "<a href=\"mailto:\\1\" class=\"bb-email\">\\2</a>",
              // [url]
              '/(?<!\\\\)\[url(?::\w+)?\]www\.(.*?)\[\/url(?::\w+)?\]/si'        => "<a href=\"http://www.\\1\" target=\"_blank\" class=\"bb-url\">\\1</a>",
              '/(?<!\\\\)\[url(?::\w+)?\](.*?)\[\/url(?::\w+)?\]/si'             => "<a href=\"\\1\" target=\"_blank\" class=\"bb-url\">\\1</a>",
              '/(?<!\\\\)\[url(?::\w+)?=\"(.*?)\"?\](.*?)\[\/url(?::\w+)?\]/si'  => "<a href=\"\\1\" target=\"_blank\" class=\"bb-url\">\\2</a>",
              '/(?<!\\\\)\[url(?::\w+)?=(.*?)?\](.*?)\[\/url(?::\w+)?\]/si'      => "<a href=\"\\1\" target=\"_blank\" class=\"bb-url\">\\2</a>",
              // [img]
              '/(?<!\\\\)\[img(?::\w+)?\](.*?)\[\/img(?::\w+)?\]/si'             => "<img src=\"\\1\" alt=\"\\1\" class=\"bb-image\" />",
              '/(?<!\\\\)\[img(?::\w+)?=(.*?)x(.*?)\](.*?)\[\/img(?::\w+)?\]/si' => "<img width=\"\\1\" height=\"\\2\" src=\"\\3\" alt=\"\\3\" class=\"bb-image\" />",
              // [quote]
              '/(?<!\\\\)\[quote(?::\w+)?\](.*?)\[\/quote(?::\w+)?\]/si'         => "<div>Quote:<div class=\"bb-quote\">\\1</div></div>",
              '/(?<!\\\\)\[quote(?::\w+)?=(?:&quot;|"|\')?(.*?)["\']?(?:&quot;|"|\')?\](.*?)\[\/quote\]/si'   => "<div>Quote \\1:<div class=\"bb-quote\">\\2</div></div>",
              // [list]
              '/(?<!\\\\)(?:\s*<br\s*\/?>\s*)?\[\*(?::\w+)?\](.*?)(?=(?:\s*<br\s*\/?>\s*)?\[\*|(?:\s*<br\s*\/?>\s*)?\[\/?list)/si' => "\n<li class=\"bb-listitem\">\\1</li>",
              '/(?<!\\\\)(?:\s*<br\s*\/?>\s*)?\[\/list(:(?!u|o)\w+)?\](?:<br\s*\/?>)?/si'    => "\n</ul>",
              '/(?<!\\\\)(?:\s*<br\s*\/?>\s*)?\[\/list:u(:\w+)?\](?:<br\s*\/?>)?/si'         => "\n</ul>",
              '/(?<!\\\\)(?:\s*<br\s*\/?>\s*)?\[\/list:o(:\w+)?\](?:<br\s*\/?>)?/si'         => "\n</ol>",
              '/(?<!\\\\)(?:\s*<br\s*\/?>\s*)?\[list(:(?!u|o)\w+)?\]\s*(?:<br\s*\/?>)?/si'   => "\n<ul class=\"bb-list-unordered\">",
              '/(?<!\\\\)(?:\s*<br\s*\/?>\s*)?\[list:u(:\w+)?\]\s*(?:<br\s*\/?>)?/si'        => "\n<ul class=\"bb-list-unordered\">",
              '/(?<!\\\\)(?:\s*<br\s*\/?>\s*)?\[list:o(:\w+)?\]\s*(?:<br\s*\/?>)?/si'        => "\n<ol class=\"bb-list-ordered\">",
              '/(?<!\\\\)(?:\s*<br\s*\/?>\s*)?\[list(?::o)?(:\w+)?=1\]\s*(?:<br\s*\/?>)?/si' => "\n<ol class=\"bb-list-ordered,bb-list-ordered-d\">",
              '/(?<!\\\\)(?:\s*<br\s*\/?>\s*)?\[list(?::o)?(:\w+)?=i\]\s*(?:<br\s*\/?>)?/s'  => "\n<ol class=\"bb-list-ordered,bb-list-ordered-lr\">",
              '/(?<!\\\\)(?:\s*<br\s*\/?>\s*)?\[list(?::o)?(:\w+)?=I\]\s*(?:<br\s*\/?>)?/s'  => "\n<ol class=\"bb-list-ordered,bb-list-ordered-ur\">",
              '/(?<!\\\\)(?:\s*<br\s*\/?>\s*)?\[list(?::o)?(:\w+)?=a\]\s*(?:<br\s*\/?>)?/s'  => "\n<ol class=\"bb-list-ordered,bb-list-ordered-la\">",
              '/(?<!\\\\)(?:\s*<br\s*\/?>\s*)?\[list(?::o)?(:\w+)?=A\]\s*(?:<br\s*\/?>)?/s'  => "\n<ol class=\"bb-list-ordered,bb-list-ordered-ua\">",
              // escaped tags like \[b], \[color], \[url], ...
              '/\\\\(\[\/?\w+(?::\w+)*\])/'                                      => "\\1"
    );

    $ecomments = preg_replace(array_keys($preg), array_values($preg), $markup);

    // Smilies
    $ecomments = preg_replace("/(( |\n|^):\)|(\[|:)smile(\]|:))/","\\2<img src=\"{$Globals['idir']}/smile.gif\" alt=\"Smile\" />", $ecomments);
    $ecomments = preg_replace("/(( |\n|^);\)|(\[|:)wink(\]|:))/","\\2<img src=\"{$Globals['idir']}/wink.gif\" alt=\"Wink\" />", $ecomments);
    $ecomments = preg_replace("/(( |\n|^):\(|(\[|:)sad(\]|:))/","\\2<img src=\"{$Globals['idir']}/sad.gif\" alt=\"Sad\" />", $ecomments);
    $ecomments = preg_replace("/(( |\n|^):d|(\[|:)teeth(\]|:))/","\\2<img src=\"{$Globals['idir']}/teeth_smile.gif\" alt=\"Smile!\" />", $ecomments);
    $ecomments = preg_replace("/(( |\n|^):p|(\[|:)tongue(\]|:))/","\\2<img src=\"{$Globals['idir']}/tounge_smile.gif\" alt=\"Nah!\" />", $ecomments);
    $ecomments = preg_replace("/(( |\n|^)\(y\)|(\[|:)up(\]|:))/","\\2<img src=\"{$Globals['idir']}/thumbs_up.gif\" alt=\"Thumbs Up!\" />", $ecomments);
    $ecomments = preg_replace("/(( |\n|^)\(n\)|(\[|:)no(\]|:))/","\\2<img src=\"{$Globals['idir']}/thumbs_down.gif\" alt=\"Thumbs Down!\" />", $ecomments);

    // Convert near-URL tags to HTML (auto conversion, no url tag needed
    $ecomments = " " . $ecomments;
    $ecomments = preg_replace("#([\n ])([a-z]+?)://([^, \n\r]+)#i", "\\1[ <a href=\"\\2://\\3\" target=\"_blank\">link</a> ]", $ecomments);
    $ecomments = preg_replace("#([\n ])www\.([a-z0-9\-]+)\.([a-z0-9\-.\~]+)((?:/[^, \n\r]*)?)#i", "\\1[ <a href=\"http://www.\\2.\\3\\4\" target=\"_blank\">link</a> ]", $ecomments);
    $ecomments = preg_replace("#([\n ])([a-z0-9\-_.]+?)@([^, \n\r]+)#i", "\\1<a href=\"mailto:\\2@\\3\">\\2@\\3</a>", $ecomments);
    $ecomments = substr($ecomments, 1);

    return ($ecomments);
}


function get_modcats()
{
    global $Globals, $CatPerms, $User;

    if ( $User['adminedit'] == 1 || $Globals['modprivs'] == "yes" )
    {
        return( null );
    }

    $catlist = null;
    $catarray = array_keys($CatPerms['mods']);

    foreach ($catarray as $k => $thecat)
    {
        $mymods = explode(",", $CatPerms['mods'][$thecat] );

        foreach ($mymods as $eachmod)
        {
            if ( $eachmod )
            {
                if ( $eachmod == $User['userid'] )
                {
                    if ( !empty($catlist) )
                    {
                        $catlist .= ",";
                    }

                    $catlist .= "$thecat";

                    if ( !empty($CatPerms['children'][$thecat]) )
                    {
                        $catlist .= ",{$CatPerms['children'][$thecat]}";
                    }
                    break;
                }
            }
        }
    }

    return ($catlist);
}


function is_moderator( $catid )
{
    global $Globals, $CatPerms, $User;

    if ( $User['adminedit'] == 1 || $Globals['modprivs'] == "yes" )
    {
        return( true );
    }

    $arethey = false;

    // Given a cat, we need to see if they are a mod here or with a parent
    // Category specific moderators
    $mymods = explode(",", $CatPerms['mods'][$catid] );

    foreach ($mymods as $modrec)
    {
        list( $eachmod, $eachname ) = explode( "||", $modrec );

        if ( $eachmod )
        {
            if ( $eachmod == $User['userid'] )
            {
                $arethey = true;
                break;
            }
        }
    }

    if ( $arethey == false )
    {
        // Inherited moderators
        if ( $CatPerms['parent'][$catid] != 0 )
        {
            $checkcat = $CatPerms['parent'][$catid];

            while ( $checkcat )
            {
                $thiscat = $CatPerms['parent'][$checkcat];

                $mymods = explode(",", $CatPerms['mods'][$checkcat] );

                foreach ($mymods as $modrec)
                {
                    list( $eachmod, $eachname ) = explode( "||", $modrec );

                    if ( $eachmod )
                    {
                        if ( $eachmod == $User['userid'] )
                        {
                            $arethey = true;
                            break;
                        }
                    }
                }

                $checkcat = $CatPerms['parent'][$checkcat];
            }
        }
    }

    return( $arethey );
}


function albumopt( $subalbumid )
{
    global $Globals, $link, $paropts;

    $rows = ppmysql_query("SELECT id,catname FROM {$Globals['pp_db_prefix']}categories WHERE parent=$subalbumid AND cattype='a'", $link);
    while ( list( $subid, $subalbumname ) = mysql_fetch_row($rows) )
    {
        if ($subid != 500)
        {
            if ($subthumbs == "no")
            {
                $paropts .= "<option value=\"$subid\">- -$subalbumname</option>";
            }
            else
            {
                $paropts .= "<option value=\"$subid\">$subalbumname</option>";
            }
        }

        albumopt( $subid );
    }
}

function albumli( $userid, $admin=0 )
{
    global $Globals, $link, $Style, $CatPerms, $ppopen, $ppclose;

    $albumcnt=0;

    $output = null;

    $rows = ppmysql_query("SELECT c.id,c.catname,c.description,c.photos,c.private,c.password,c.subalbum,p.cat,p.bigimage,p.approved,p.width,p.height,
                                  p2.bigimage, p2.cat, p2.storecat, p2.userid
                          FROM {$Globals['pp_db_prefix']}categories c
                          LEFT JOIN {$Globals['pp_db_prefix']}photos p ON p.id=c.lastphoto
                          LEFT JOIN {$Globals['pp_db_prefix']}photos p2 ON p2.id=c.thumbnail
                          WHERE ( c.parent='$userid' AND c.cattype='a' ) ORDER BY c.subalbum,c.catorder", $link);

    $output = "<tr><td class=\"{$Style['menubar']}\" valign=\"top\" align=\"left\">{$Globals['pp_lang']['albumcol']}</td>
                <td class=\"{$Style['menubar']}\" align=\"center\" valign=\"middle\">{$Globals['pp_lang']['photocol']}</td>
                <td class=\"{$Style['menubar']}\" align=\"center\" valign=\"middle\">{$Globals['pp_lang']['actions']}</td></tr>";

    $curgroup = 0;

    while ( list( $subid, $subalbumname, $subalbumdesc, $albphotos, $isprivate, $catp, $subalbum, $bigcat, $bigimage, $approved, $iwidth, $iheight, $catthimg, $catthcat, $catstoreid, $catthuid ) = mysql_fetch_row($rows) )
    {
        if ( $curgroup != $subalbum && $albumcnt > 0 )
        {
            $output .= "$ppclose<br />$ppopen<tr><td class=\"{$Style['menubar']}\" colspan=\"3\">{$CatPerms['catname'][$subalbum]}</td></tr>";
            $curgroup = $subalbum;
        }

        $albumcnt++;

        if ( $isprivate == "yes" )
        {
            $privatelink = " ({$Globals['pp_lang']['private']})<br /><span class=\"{$Style['small']}\"><a href=\"{$Globals['maindir']}/showgallery.php?cat=$subid&amp;catp=$catp\">{$Globals['maindir']}/showgallery.php?cat=$subid&amp;catp=$catp</a></span> ";
        }
        else
        {
            $privatelink = null;
        }

        if ( $catstoreid != 0 )
        {
            $catthcat = $catstoreid;
        }

        $thumbrc = null;

        if ( !empty($catthimg) )
        {
            $thumbrc = get_imagethumb( $catthimg, $catthcat, $catthuid, 1 );
        }
        else
        {
            $thumbrc = get_imagethumb( $bigimage, $bigcat, $userid, $approved );
        }

        if ( !empty($thumbrc) )
        {
            $thumbrc .= "<br />";
        }

        $add = "<a href=\"{$Globals['maindir']}/uploadphoto.php?cat=$subid\">{$Globals['pp_lang']['upload']}</a>";
        $delete = "<a href=\"{$Globals['maindir']}/useralbums.php?ppaction=delalbum&amp;albumid=$subid&amp;admin=$admin\">{$Globals['pp_lang']['delete']}</a>";
        $edit = "<a href=\"{$Globals['maindir']}/useralbums.php?ppaction=editalbum&amp;albumid=$subid&amp;admin=$admin\">{$Globals['pp_lang']['edit']}</a>";
        $sort = "<a href=\"{$Globals['maindir']}/misc.php?action=orderphotos&amp;cat=$subid\">{$Globals['pp_lang']['sort']}</a>";

        if ( !empty($subalbumdesc) )
        {
            $subalbumdesc = "<br /><br />{$Globals['pp_lang']['desc']}: $subalbumdesc";
        }

        $output .= "<tr><td class=\"{$Style['tddetails']}\" valign=\"top\" align=\"left\"><b><a href=\"{$Globals['maindir']}/showgallery.php?cat=$subid\">$subalbumname</a></b>{$privatelink}$subalbumdesc</td>
                    <td class=\"{$Style['tddetails']}\" align=\"center\" valign=\"middle\">{$thumbrc}{$Globals['pp_lang']['photos']}: $albphotos</td>
                    <td class=\"{$Style['tddetails']}\" align=\"center\" valign=\"middle\">[$add]<br />[$delete]&nbsp;[$edit]&nbsp;[$sort]</td></tr>";
    }
    ppmysql_free_result( $rows );

    return $output;
}

// Function to grab all the photos posted for each day of the month
function get_photos_for_month($month, $year, $nocache = false)
{
	global $Globals, $link, $cacheq, $updatecache;

    if ( ($updatecache || empty($cacheq['calcache'])) || $Globals['cachetimeout'] == 0 || $nocache )
    {
    	$photos_for_month = array();

    	$lowdate  = mktime(0, 0, 0, $month,   1, $year);
    	$highdate = mktime(0, 0, 0, $month+1, 1, $year);

    	$result = ppmysql_query("SELECT date, title FROM {$Globals['pp_db_prefix']}photos WHERE date >= $lowdate AND date < $highdate ORDER BY date", $link);
    	while( $row = mysql_fetch_array($result) )
    	{
    		$date = getdate($row['date']);

    		$mday = $date['mday'];

    		if ( empty($photos_for_month[$mday]) )
    		{
    			$photos_for_month[$mday] = array();
    		}

    		array_push($photos_for_month[$mday], $row);
    	}
    	@mysql_free_result($result);

        if ( $Globals['cachetimeout'] > 0 && !$nocache)
        {
            // Let's update the cache
            $cacheq = addslashes(serialize($photos_for_month));
            ppmysql_query("UPDATE {$Globals['pp_db_prefix']}cache SET calcache='$cacheq' WHERE id=1", $link);
        }

	    return $photos_for_month;
    }
    else
    {
        $calcache = unserialize( $cacheq['calcache'] );
	    return $calcache;
    }
}

// Format the calender
function gen_cal( $month, $vyear )
{
    global $Globals, $Style, $cacheq, $updatecache, $monthname, $year, $backicon, $foricon;

    // ---------------------------------
    // Get some info on the current date
    $year = $vyear;
    $today = getdate();

    $thismonth = $today['mon'];
    $thisyear  = $today['year'];
    $thisday   = $today['mday'];

    if ( $thismonth != $month || $thisyear != $year )
    {
        // Don't use cache for this kind
        $photos_for_month = get_photos_for_month($month, $year, true);
    }
    else
    {
        $photos_for_month = get_photos_for_month($month, $year);
    }

    // --------------------------------
    // get what weekday the first is on
    $temp = getdate(mktime(0,0,0,$month,1,$year));
    $firstweekday = $temp['wday'];
    $mname        = "month". $temp['mon'];
    $monthname    = $Globals['pp_lang'][$mname];

    // -----------------------------
    // get the last day of the month
    $nextmonth = $month + 1;
    $tempyear = $year;

    if ( $nextmonth == 13 )
    {
        $nextmonth = 1;
        $tempyear = $tempyear + 1;
    }

    $temp = getdate(mktime(0,0,0,$nextmonth,0,$tempyear));
    $lastday = $temp['mday'];
    $currentdate = 1;
    $firstweek = true;
    $weekday = 1;
    $currentweek = 1;

    // --------------------------------------
    // Loop through all the days of the month
    while ( $currentdate <= $lastday )
    {
        $days[$currentdate] = null;
        $printdate = $currentdate;

        if ( ($firstweek) && ($firstweekday) )
        {
            $days[$currentdate] .= "<tr>";
            for ($i=1; $i<=$firstweekday; $i++)
            {
                $days[$currentdate] .= "<td class=\"{$Style['lighttable']}\">&nbsp;</td>";
                $weekday++;
            }
            $firstweek = false;
        }
        else
        {
            $firstweek = false;
        }

        if ( $weekday == 1 )
        {
            $days[$currentdate] .= "<tr>";
        }

        $class = $Style['alternatetable'];
        $alt = null;

        if (($currentdate == $thisday) && ($year == $thisyear) && ($month == $thismonth))
        {
             $class = $Style['tddetails'];
             $printdate = "<span style=\"color: red; font-size: 7pt;\"><b>$printdate</b></span>";
        }

        $datelink = $printdate;

        if ( isset($photos_for_month[$currentdate]) )
        {
            $class = $Style['tddetails'];
            $printdate = "<b>$printdate</b>";
            $alt = "$marray[$currentdate]";

            $htitle = count($photos_for_month[$currentdate]) ." ". $Globals['pp_lang']['photosadded'];
            $datelink = "<a title=\"$htitle\" href=\"{$Globals['maindir']}/search.php?date={$photos_for_month[$currentdate][0]['date']}\">$printdate</a>";
        }

        $days[$currentdate] .= "<td class=\"$class\" align=\"center\">$datelink</td>";

        if ( $weekday == 7 )
        {
            $days[$currentdate] .= "</tr>";
            $lastsat = $currentdate;
            $currentweek++;
        }

        $weekday++;

        if ( $weekday > 7 )
        {
            $weekday = 1;
        }

        $currentdate++;
    }

    // Fill out the rest of the table
    if ( $weekday > 1 )
    {
        for ( $i = $weekday; $i <= 7; $i++ )
        {
            $days[$currentdate] = "<td class=\"{$Style['lighttable']}\">&nbsp;</td>";
            $currentdate = $currentdate + 1;
        }

        $currentdate = $currentdate - 1;
        $days[$currentdate] .= "</tr>";
    }

    if ( $month == 1 ) {
        $prevmonth = 12;
        $prevyear = $year - 1;
    }
    else
    {
        $prevmonth = $month - 1;
        $prevyear = $year;
    }

    $backicon = "<a title=\"back\" href=\"javascript:sendCalReq('$prevmonth','$prevyear');\">&laquo;</a>";

    // Don't offer forward if we're in the current month
    if ($year == $thisyear && $month == $thismonth)
    {
        $foricon = null;
    }
    else
    {
        if ( $month == 12 ) {
            $nextmonth = 1;
            $nextyear = $year + 1;
        }
        else
        {
            $nextmonth = $month + 1;
            $nextyear = $year;
        }

        $foricon = "<a title=\"forward\" href=\"javascript:sendCalReq('$nextmonth','$nextyear');\">&raquo;</a>";
    }

    if ( VB40 == "on" )
    {
$template = <<<PPPRINT
<ol class="floatcontainer"><!--PhotoPost, Copyright All Enthusiast,Inc. -->
<li class="forumbit_nopost">
    <div class="forumhead foruminfo L1">
        <table cellpadding="2" cellspacing="1" width="100%" class="tborder">
        <tr>
        <td align="center" class="tcat">$backicon</td>
        <td align="center" colspan="5" class="tcat"><b>$monthname $year</b></td>
        <td align="center" class="tcat">$foricon</td>
        </tr>
        </table>
    </div>
    <ol class="childforum">
    <li class="forumbit_post L2">
    <div class="forumrow table">
        <div class="blockrow">
            <table cellpadding="2" cellspacing="1" width="100%" class="{$Style['tableborders']}">
            <tr>
            <th class="{$Style['tddetails']}">{$Globals['pp_lang']['day1']}</th><th class="{$Style['tddetails']}">{$Globals['pp_lang']['day2']}</th>
            <th class="{$Style['tddetails']}">{$Globals['pp_lang']['day3']}</th><th class="{$Style['tddetails']}">{$Globals['pp_lang']['day4']}</th>
            <th class="{$Style['tddetails']}">{$Globals['pp_lang']['day5']}</th><th class="{$Style['tddetails']}">{$Globals['pp_lang']['day6']}</th>
            <th class="{$Style['tddetails']}">{$Globals['pp_lang']['day7']}</th></tr>
PPPRINT;
    }
    else
    {
$template = <<<PPPRINT
<table cellpadding="2" cellspacing="1" width="100%" class="{$Style['tableborders']}">
<tr>
<td align="center" class="{$Style['menubar']}">$backicon</td>
<td align="center" colspan="5" class="{$Style['menubar']}"><b>$monthname $year</b></td>
<td align="center" class="{$Style['menubar']}">$foricon</td>
</tr><tr>
<th class="{$Style['tddetails']}">{$Globals['pp_lang']['day1']}</th><th class="{$Style['tddetails']}">{$Globals['pp_lang']['day2']}</th>
<th class="{$Style['tddetails']}">{$Globals['pp_lang']['day3']}</th><th class="{$Style['tddetails']}">{$Globals['pp_lang']['day4']}</th>
<th class="{$Style['tddetails']}">{$Globals['pp_lang']['day5']}</th><th class="{$Style['tddetails']}">{$Globals['pp_lang']['day6']}</th>
<th class="{$Style['tddetails']}">{$Globals['pp_lang']['day7']}</th></tr>
PPPRINT;
    }

    for( $i = 1; $i <= sizeof($days); $i++ )
    {
        $template .= $days[$i];
    }

    if ( VB40 == "on" )
    {
$template .= <<<PPPRINT
            </table>
        </div>
    </div>
    </li>
    </ol>
</li>
</ol>
PPPRINT;
    }
    else
    {
$template .= <<<PPPRINT
</table>
PPPRINT;
    }

    return $template;
}

function inc_photoviews( $photo )
{
    global $Globals, $link;

    if ( $Globals['viewcache'] == "yes" )
    {
        ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}photoviews SET photoid=$photo", $link);

        if ( mt_rand(1,200) < 10 )
        {
            $result = ppmysql_query("SELECT photoid, COUNT(*) as views FROM {$Globals['pp_db_prefix']}photoviews GROUP BY photoid", $link);
            while ($newviews = mysql_fetch_array($result))
            {
                ppmysql_query("UPDATE LOW_PRIORITY {$Globals['pp_db_prefix']}photos SET views = views+$newviews[views] WHERE id='$newviews[photoid]'", $link);
            }

            ppmysql_query("DELETE LOW_PRIORITY FROM {$Globals['pp_db_prefix']}photoviews", $link);
        }
    }
    else
    {
        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET views=views+1 WHERE id=$photo", $link);
    }
}

function get_ratingcache()
{
    global $Globals, $link, $cache;

    // Lets get the Most Popular Photos
    $queryz = ppmysql_query("SELECT count(*) AS vcount,avg(c.rating) AS avgr,p.cat,p.id,p.title,p.rating AS avgr FROM {$Globals['pp_db_prefix']}comments c
                                LEFT JOIN {$Globals['pp_db_prefix']}photos p ON p.id=c.photo
                                WHERE p.numcom > 1
                                GROUP BY c.photo
                                ORDER BY avgr desc,vcount desc
                                LIMIT {$Globals['mostpoppal']}", $link);

    $tpfound = 1;

    while ( list(,, $popcat, $popid, $poptitle, $popviews ) = mysql_fetch_row($queryz) )
    {
        $cache['popular']['title'][$tpfound] = ( strlen($poptitle) > 20 ? substr($poptitle,0,20)."..." : $poptitle );
        $cache['popular']['views'][$tpfound] = number_format($popviews,1);
        $cache['popular']['link'][$tpfound] = construct_newppurl( "showphoto.php", array( 'photo' => $popid, 'title' => $poptitle, 'cat' => $popcat ) );

        $tpfound++;
    }

    return;
}

function get_statscache()
{
    global $Globals, $link, $db_link, $cache;

    $cache['stats']['usertotal'] = get_totalusers();

    $totalv = ppmysql_query("SELECT SUM(views) as totalviews, SUM(filesize) as diskuse, count(*) as totalphotos FROM {$Globals['pp_db_prefix']}photos", $link);
    list( $cache['stats']['totalviews'], $cache['stats']['diskuse'], $cache['stats']['totalphotos'] ) = mysql_fetch_row($totalv);

    $totalv = ppmysql_query("SELECT count(*) FROM {$Globals['pp_db_prefix']}comments", $link);
    list( $cache['stats']['posttotal'] ) = mysql_fetch_row($totalv);

    $cache['stats']['totalviews'] = number_format( $cache['stats']['totalviews'] );
    $cache['stats']['totalphotos'] = number_format( $cache['stats']['totalphotos'] );
    $cache['stats']['usertotal'] = number_format( $cache['stats']['usertotal'] );
    $cache['stats']['posttotal'] = number_format( $cache['stats']['posttotal'] );
    $cache['stats']['diskspace'] = ( $cache['stats']['diskuse'] / 1048576 );
    $cache['stats']['diskspace'] = number_format( $cache['stats']['diskspace'], 1 ) . "{$Globals['pp_lang']['megabytes']}";

    return;
}

function get_posterscache()
{
    global $Globals, $link, $db_link, $cache;

    // Lets get the Top Posters
    $queryz = ppmysql_query("SELECT user,userid,COUNT(*) AS pcount FROM {$Globals['pp_db_prefix']}photos GROUP BY user ORDER BY pcount DESC LIMIT {$Globals['numtoppal']}", $link);

    $numfound = 1;

    while ( list($cache['top']['topposters'][$numfound], $uid, $cache['top']['topposts'][$numfound]) = mysql_fetch_row($queryz))
    {
        $cache['top']['toplink'][$numfound] = construct_newppurl( "showgallery.php", array('ppuser' => $uid, 'username' => $cache['top']['topposters'][$numfound]) );
        $numfound++;
    }

    return;
}


function get_string( $stringvar, $p1 = null, $p2 = null, $p3 = null, $p4 = null, $p5 = null )
{
    global $Globals;

    $retstring = $Globals['pp_lang'][$stringvar];

    if ( $p1 ) $retstring = str_replace( "%p1%", $p1, $retstring );
    if ( $p2 ) $retstring = str_replace( "%p2%", $p2, $retstring );
    if ( $p3 ) $retstring = str_replace( "%p3%", $p3, $retstring );
    if ( $p4 ) $retstring = str_replace( "%p4%", $p4, $retstring );
    if ( $p5 ) $retstring = str_replace( "%p5%", $p5, $retstring );

    return( $retstring );
}


// Default Style settings

$Style = array();
$Style['onbody'] = "onbody";
$Style['tableborders'] = "tableborders";
$Style['tablesurround'] = null;
$Style['tddetails'] = "tddetails";
$Style['tdbackground'] = "tdbackground";
$Style['tdnothumbs'] = "tdnothumbs";
$Style['menubar'] = "menubar";
$Style['menubarnb'] = "menubarnb";
$Style['catcolumn'] = "catcolumn";
$Style['photocol'] = "photocol";
$Style['commentscol'] = "commentscol";
$Style['lastphocol'] = "lastphocol";
$Style['lastcommcol'] = "lastcommcol";
$Style['small'] = "small";
$Style['medium'] = "medium";
$Style['large'] = "large";
$Style['welcome'] = "welcome";
$Style['lighttable'] = "lighttable";
$Style['alternatetable'] = "alternatetable";
$Style['formboxes'] = "formboxes";
$Style['blockquote'] = "blockquote";

// Now lets include the forum integration
require "{$Globals['PP_PATH']}/forums/{$Globals['vbversion']}.php";

include "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/ppopen.tmpl";
include "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/ppclose.tmpl";

?>
