<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

define( 'THIS_SCRIPT', "online" );
require "pp-inc.php";

typecast($_REQUEST, array('page' => INT));

authenticate();

if ( $Globals['ppboards'] == "closed" && $User['adminedit'] != 1 )
{
    diewell( $Globals['closedmsg'] );
}

if ( !isset($page) )
{
    $page = 0;
}

topmenu();

$limit = $page * 50;
$whoonline = $guestonline = null;

$orecs = ppmysql_query("SELECT o.*,p.title AS title,p.cat AS cat FROM {$Globals['pp_db_prefix']}iponline o LEFT JOIN {$Globals['pp_db_prefix']}photos p ON (p.id=o.item) ORDER BY o.uid DESC,o.date DESC LIMIT $limit,50", $link);
$numrows = mysql_num_rows($orecs);

$totalpages = ceil($numrows/50)-1;

while( $rows = mysql_fetch_assoc($orecs) )
{
    $cctime = formatpptime( $rows['date'] );
    $ccdate = formatppdate( $rows['date'] );
    $location = $rows['what'];

    if ( $location == "index" ) $location = "<a href=\"{$Globals['maindir']}\">{$Globals['pp_lang']['tablehead']}</a>";
    elseif ( ($location == "showphoto" || $location == "showfull") && $rows['item'] ) $location = "<a href=\"" . construct_newppurl( "showphoto.php", array( 'photo' => $rows['item'], 'title' => $rows['title'], 'cat' => $rows['cat'] ) ) . "\">{$Globals['pp_lang']['viewingphoto']}</a>";
    elseif ( $location == "register" ) $location = $Globals['pp_lang']['registering'];
    elseif ( $location == "member" ) $location = "<a href=\"". construct_newppurl( "member.php", array('uid' => $rows['item'], 'username' => $rows['userid']) ) ."\">{$Globals['pp_lang']['viewingprofile']}</a>";
    elseif ( $location == "showgallery" ) $location = "<a href=\"" . construct_newppurl( "showgallery.php", array('cat' => $rows['item']) ) . "\">{$Globals['pp_lang']['viewinggallery']}</a>";
    elseif ( $location == "showmember" ) $location = "<a href=\"{$Globals['maindir']}/showmember.php?cat={$rows['item']}\">{$Globals['pp_lang']['viewingmg']}</a>";
    elseif ( $location == "search" ) $location = $Globals['pp_lang']['searching'];
    elseif ( $location == "board" ) $location = "<a href=\"{$Globals['maindir']}/board.php\">{$Globals['pp_lang']['viewingboard']}</a>";
    elseif ( $location == "online" ) $location = "<a href=\"{$Globals['maindir']}/online.php\">{$Globals['pp_lang']['viewingwho']}</a>";
    elseif ( $location == "uploadphoto" ) $location = $Globals['pp_lang']['uploadingphoto'];
    elseif ( $location == "misc" ) $location = $Globals['pp_lang']['other'];
    else $location = null;

    $more = null;
    if ( $User['adminedit'] == 1 )
    {
        $more = " [ {$rows['ipaddr']} ]";
        if ( $rows['referer'] && !stristr($rows['referer'], $_ENV['HOSTNAME']) )
        {
            $more .= "<br />{$Globals['pp_lang']['referrer']}: [ <a target=\"_blank\" href=\"{$rows['referer']}\">{$rows['referer']}</a> ]";
        }

        if ( $rows['agent'] )
        {
            $more .= "<br />{$Globals['pp_lang']['agent']}: [ {$rows['agent']} ]";
        }
    }
    else
    {
        if ( $rows['referer'] && !stristr($rows['referer'], $_ENV['HOSTNAME']) )
        {
            $more .= " [ <a href=\"{$rows['referer']}\">{$Globals['pp_lang']['referrer']}</a> ]";
        }
    }

    if ( $rows['uid'] )
    {
        $onlineuser = "<a href=\"". construct_newppurl( "member.php", array('uid' => $rows['uid'], 'username' => $rows['userid']) ) ."\">{$rows['userid']}</a>";

        $whoonline .= "<tr><td class=\"{$Style['tddetails']}\" width=\"70%\">$onlineuser{$more}</td>
                            <td class=\"{$Style['tddetails']}\" width=\"10%\" align=\"center\">$cctime</td>
                            <td class=\"{$Style['tddetails']}\" width=\"20%\">$location</td>
                            </tr>";
    }
    else
    {
        $onlineuser = $Globals['pp_lang']['guest'];

        $guestonline .= "<tr><td class=\"{$Style['tddetails']}\" width=\"70%\">$onlineuser{$more}</td>
                            <td class=\"{$Style['tddetails']}\" width=\"10%\" align=\"center\">$cctime</td>
                            <td class=\"{$Style['tddetails']}\" width=\"20%\">$location</td>
                            </tr>";
    }

}

if ( $guestonline && $whoonline )
{
    $whoonline .= "<tr><td class=\"{$Style['menubar']}\" width=\"70%\" colspan=\"3\" align=\"center\">{$Globals['pp_lang']['guests']}</td></tr>";
}

$whoonline .= $guestonline;

$prevlink = null;
if ( $page > 0 )
{
    $prevurl = max(0, $page - 1);
    $prevlink = "&laquo; <a href=\"{$Globals['maindir']}/online.php?page=$prevurl\">{$Globals['pp_lang']['prevpage']}</a>";
}

$nextlink = null;
if ( $page < $totalpages )
{
    if ( $prevlink )
    {
        $prevlink .= " &middot; ";
    }

    $nexturl = min($totalpages, $page + 1);
    $nextlink = "<a href=\"{$Globals['maindir']}/online.php?page=$nexturl\">{$Globals['pp_lang']['nextpage']}</a> &raquo;";
}

printheader( $cat, $Globals['pp_lang']['whosonline'] );

include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );
include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/whoonline.tmpl" );

printfooter();

?>
