<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

require "pp-inc.php";

typecast($_REQUEST, array('approve' => STRING, 'defdel' => INT, 'defapp' => INT, 'defhol' => INT,
                          'do' => STRING, 'action' => STRING, 'photo' => INT, 'cat' => STRING, 'report' => INT,
                          'sub' => INT, 'thumb' => INT, 'sort' => INT, 'sl' => STRING, 's' => STRING,
                          'si' => STRING, 'name' => STRING, 'cat' => STRING, 'catp' => STRING, 'page' => INT,
                          'ppuser' => INT, 'what' => STRING, 'when' => STRING, 'sorttime' => INT, 'perpage' => INT,
                          'limit' => STRING, 'way' => STRING, 'sortby' => STRING, 'whoami' => STRING, 'reason' => STRING,
                          'thecount' => INT, 'ppaction' => STRING, 'implode' => INT, 'expand' => INT, 'pid' => INT,
                          'login' => STRING, 'desc' => STRING));
typecast($_COOKIE, array('ppcollapse' => STRING, 'printphotos', STRING));

// Set cookies first
if ( $perpage )
{
    // perpage, sortby, sorttime, way, thumbsonly
    $setcookie = serialize( array( $perpage, $sortby, $sorttime, $way, $thumbsonly ) );
    @setcookie( "ppperpage", $setcookie, 0, $Globals['cookie_path'], $Globals['domain_path'] );
    $page = 1;
}
else
{
    // perpage, sortby, sorttime, way, thumbsonly
    typecast($_COOKIE, array('ppperpage' => STRING));
    if ( $ppperpage )
    {
        list( $perpage, $sortby, $sorttime, $way, $thumbsonly ) = unserialize( un_htmlspecialchars($ppperpage) );
    }
}

//
// ADDFAV
//
// Used to add/remove photos from users "favorites"
//

if ( $action == "addfav" )
{
    if ( !isset($photo) || !isset($do) )
    {
        diewell($Globals['pp_lang']['badfavcall']);
    }

    authenticate();

    if ( $Globals['ppboards'] == "closed" && $User['adminedit'] != 1 )
    {
        diewell( $Globals['closedmsg'] );
    }

    if (!$User['userid'])
    {
        diewell( $Globals['pp_lang']['noreg'] );
    }

    if ( $do == "add" )
    {
        $query = "REPLACE INTO {$Globals['pp_db_prefix']}favorites values(NULL,'{$User['userid']}',$photo)";
        $type = $Globals['pp_lang']['added'];
    }
    else
    {
        if ( empty($photo) || empty($User['userid']) )
        {
            diewell( $Globals['pp_lang']['malform'] );
        }

        $type = $Globals['pp_lang']['removed'];
        $query = "DELETE FROM {$Globals['pp_db_prefix']}favorites WHERE photo=$photo AND userid='{$User['userid']}'";
    }

    $result = ppmysql_query($query, $link);

    if ( isset($cat) )
    {
        forward( "search.php?what=fav", $type );
    }

    forward( "showphoto.php?photo=$photo", $type );
}

//
// VOTE on an image
if ( $action == "vote" )
{
    authenticate();

    if ( $Globals['ppboards'] == "closed" && $User['adminedit'] != 1 )
    {
        diewell( $Globals['closedmsg'] );
    }

    if ( !$User['userid'] )
    {
        diewell( $Globals['pp_lang']['noreg'] );
    }

    if ( isset($cat) )
    {
        // User wants to clear all votes for this category
        if ( !is_numeric($cat) )
        {
            diewell($Globals['pp_lang']['malformed']);
        }

        ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}comments WHERE cat=$cat AND userid={$User['userid']} AND votes=1", $link);
        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET votes=0 WHERE cat=$cat", $link);

        // Recalc all votes (just because we want to be sure!)
        $updateq = ppmysql_query("SELECT photo,COUNT(*) FROM {$Globals['pp_db_prefix']}comments WHERE cat=$cat AND votes=1 GROUP BY photo", $link);
        while ( list($id, $newvotes) =  mysql_fetch_row($updateq) )
        {
            $query2 = "UPDATE {$Globals['pp_db_prefix']}photos SET votes=$newvotes WHERE id=$id";
            $update2 = ppmysql_query($query2, $link);
        }

        forward( "showgallery.php?cat=$cat", $Globals['pp_lang']['vcleared'] );
    }

    if ( empty($photo) )
    {
        diewell($Globals['pp_lang']['malformed']);
    }

    $result = ppmysql_query("SELECT p.userid,p.cat,c.ratingtype,c.takevotes,v.id FROM {$Globals['pp_db_prefix']}photos p
              LEFT JOIN {$Globals['pp_db_prefix']}categories c ON (c.id=p.cat)
              LEFT JOIN {$Globals['pp_db_prefix']}comments v ON (v.cat=c.id AND v.userid={$User['userid']} AND v.votes > 0)
              WHERE p.id=$photo", $link);

    list ( $userid, $cat, $ratingtype, $takevotes, $hasvoted, $userid ) = mysql_fetch_row($result);
    ppmysql_free_result($result);

    if ( $userid == $User['userid'] )
    {
        diewell( $Globals['pp_lang']['voteown'] );
    }

    if ( $ratingtype != 1 )
    {
        diewell( $Globals['pp_lang']['vnotcat'] );
    }

    if ( $takevotes == 0 )
    {
        diewell( $Globals['pp_lang']['vnotyet'] );
    }

    if ( $hasvoted )
    {
        diewell( $Globals['pp_lang']['voted'] );
    }

    $julian = time();
    $ipaddr = findenv("REMOTE_ADDR");
    $username = addslashes( $User['username'] );

    ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}comments (id,username,userid,date,votes,photo,cat,approved,ipaddress) values(NULL,'$username',{$User['userid']},$julian,1,$photo,$cat,'1','$ipaddr')", $link);

    // Recalc all votes
    $updateq = ppmysql_query("SELECT photo,COUNT(*) FROM {$Globals['pp_db_prefix']}comments WHERE cat=$cat AND votes=1 GROUP BY photo", $link);
    while ( list($id, $newvotes) =  mysql_fetch_row($updateq) )
    {
        $update2 = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET votes=$newvotes WHERE id=$id", $link);
    }

    forward( "showgallery.php?cat=$cat", $Globals['pp_lang']['vthankyou'] );
}


//
// CATOPTS
//
// Used to collapse/expand category listings and store the value in a cookie
//

if ( $action == "catopts" )
{
    // Lets check the need to expand/collapse categories
    if ( isset($expand) || isset($implode) )
    {
        if ( $expand > 0 && strstr($ppcollapse, ",$expand,") )
        {
            $ppcollapse = str_replace( ",$expand,", "", $ppcollapse );
            setcookie( "ppcollapse", $ppcollapse, time()+2592000 );
        }

        if ( $implode > 0 && !strstr($ppcollapse, ",$implode,") )
        {
            $ppcollapse .= ",$implode,";
            setcookie( "ppcollapse", $ppcollapse, time()+2592000 );
        }
    }

    $more = ( is_numeric($cat) ? "?cat=$cat" : "" );
    $whoami = rawurlencode( $whoami );

    header( "Location: $whoami.php$more" );
}

//
// COOKIES
//
// Used to clear all site cookies for user (typically when there is a problem)
//

if ( $action == "cookies" )
{
    if (!isset($_POST['doExpire']))
    {
        $CookieArray = $_COOKIE;

        printheader( 0, $Globals['pp_lang']['clearcook'] );
        topmenu();

        echo "<br /><table cellpadding=\"10\" cellspacing=\"0\" border=\"0\" width=\"{$Globals['tablewidth']}\" align=\"center\"><tr>
            <td valign=\"middle\" width=\"50%\">$menu2</td><td width=\"50%\" align=\"right\" valign=\"middle\">$menu&nbsp;</td></tr></table>";

        echo "<table border=\"0\" cellpadding=\"1\" cellspacing=\"0\" align=\"center\" width=\"{$Globals['tablewidth']}\">
            <tr><td class=\"{$Style['tableborders']}\">
            <table border=\"0\" cellpadding=\"10\" cellspacing=\"1\" width=\"100%\">";

        echo "<tr><td class=\"{$Style['menubar']}\" colspan=\"2\">{$Globals['pp_lang']['cookinfo']}</td></tr>
            <tr><td class=\"{$Style['menubar']}\" nowrap=\"nowrap\">{$Globals['pp_lang']['cookname']}</td>
            <td class=\"{$Style['menubar']}\" width=\"100%\">{$Globals['pp_lang']['cookvalue']}</td></tr>";

        if (is_array($CookieArray) && !empty($CookieArray))
        {
            while(list($cName,$cValue) = each($CookieArray))
            {
                $cValue = @urldecode($cValue);
                echo "<tr><td align=\"left\" class=\"{$Style['lighttable']}\" nowrap=\"nowrap\">$cName</td><td align=\"left\" class=\"{$Style['lighttable']}\">$cValue</td></tr>";
            }

            echo "<tr><td class=\"{$Style['tddetails']}\" colspan=\"2\"><form method=\"post\" action=\"{$Globals['maindir']}/misc.php\">
                  <input type=\"hidden\" name=\"action\" value=\"cookies\"><input type=\"submit\" name=\"submit\" value=\"{$Globals['pp_lang']['button']}\" class=\"buttons\" /><input type=\"hidden\" name=\"doExpire\" value=\"1\" /></form><br />
                  <br />{$Globals['pp_lang']['cookmsg']}</tr></table></td></tr></table>";
        }
        else
        {
            echo "<tr><td align=\"left\" class=\"{$Style['lighttable']}\" colspan=\"2\">{$Globals['pp_lang']['nocookies']}</td></tr>";
            echo "</table></td></tr></table>";
        }

       printfooter();
    }
    else
    {
        $CookieArray = $_COOKIE;

        if (is_array($CookieArray) && !empty($CookieArray))
        {
            while(list($cName,$cValue) = each($CookieArray))
            {
                $cName = str_replace(" ","",$cName);

                setcookie("$cName","", time() - 3600, $Globals['cookie_path'], $Globals['domain_path'] );
                setcookie("$cName","", time() - 3600, $Globals['domain_path'] );
                setcookie("$cName","", time() - 3600, "/");
                setcookie("$cName","", time() - 3600);
            }
        }

        header("Location: {$Globals['maindir']}/misc.php?action=cookies");
    }
}

//
// REPORT PHOTO
//
// Used to send a note to the admin about an image
//

if ( $action == "reportphoto" )
{
    list($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime();

    if ( !isset($report) ) {
        diewell($Globals['pp_lang']['badcall']);
    }

    authenticate();

    if ( !$User['userid'] ) {
        diewell( $Globals['pp_lang']['noreg'] );
    }

    if ( $Globals['ppboards'] == "closed" && $User['adminedit'] != 1 )
    {
        diewell( $Globals['closedmsg'] );
    }

    if ( empty($_POST['final']) )
    {
        topmenu();

        printheader( 0, $Globals['pp_lang']['reportphoto'] );
        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );
        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/reportphoto.tmpl" );
        printfooter();
    }
    else
    {
        include("{$Globals['PP_PATH']}/languages/$pplang.php");

        $letter = $Globals['pp_lang']['reportemail'];
        $letter = stripslashes($letter);
        $email = $Globals['adminemail'];
        $email_from = "From: {$Globals['adminemail']}";
        $subject = trim( $Globals['pp_lang']['repsubject'] );

        mail( $email, $subject, $letter, $email_from );
        forward("showphoto.php?photo=$report", $Globals['pp_lang']['webnotice']);
    }
}

//
// REPORT POST
//
// Used to send a note to the admin about an post
//

if ( $action == "reportpost" )
{
    list($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime();

    if ( !isset($report) )
    {
        diewell($Globals['pp_lang']['badcall']);
    }

    authenticate();

    if ( !$User['userid'] )
    {
        diewell( $Globals['pp_lang']['noreg'] );
    }

    if ( $Globals['ppboards'] == "closed" && $User['adminedit'] != 1 )
    {
        diewell( $Globals['closedmsg'] );
    }

    if ( empty($_POST['final']) )
    {
        topmenu();

        printheader( 0, $Globals['pp_lang']['reportpost'] );
        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );
        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/reportpost.tmpl" );
        printfooter();
    }
    else
    {
        include("{$Globals['PP_PATH']}/languages/$pplang.php");

        $resulta = ppmysql_query("SELECT username,comment FROM {$Globals['pp_db_prefix']}comments WHERE id=$report", $link);
        list( $postname, $postcom ) = mysql_fetch_row($resulta);
        ppmysql_free_result( $resulta );

        $letter = $Globals['pp_lang']['reportpost'];
        $letter = str_replace( "{username}", $User['username'], $letter );
        $letter = str_replace( "{URL}", $Globals['maindir'], $letter );

        $email = $Globals['adminemail'];
        $email_from = "From: {$Globals['adminemail']}";
        $subject = trim( $Globals['pp_lang']['reppostsub'] );

        mail( $email, $subject, $letter, $email_from );
        forward( "showphoto.php?photo=$photo", $Globals['pp_lang']['postnotice'] );
    }
}

//
// LOGOUT
//
// Logout a user, of course
//

if ( $action == "logout" )
{
    authenticate();

    $ipaddr = findenv("REMOTE_ADDR");
    if ( $User['userid'] < 1 )
    {
        $username = addslashes($ipaddr);
    }
    else
    {
        $username = addslashes($User['username']);
    }

    $resultb = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}iponline WHERE ipaddr='$ipaddr' OR userid='$username'", $link);

    logout();

    forward( "index.php", $Globals['pp_lang']['logoutok'] );
}

//
// LOGIN
//
// Login a user
//

if ( $action == "login" )
{
    typecast($_POST, array('authuser' => STRING, 'password' => STRING));

    if ( isset( $login ) )
    {
        login( "{$Globals['maindir']}/index.php" );
        exit;
    }

    // Set to no, call authenticate and then check return
    $gologin = 0;

    authenticate( $authuser, $password );

    if ( $gologin == 0 )
    {
        $ipaddr = findenv("REMOTE_ADDR");
        if ( $User['userid'] < 1 )
        {
            $username = addslashes($ipaddr);
        }
        else
        {
            $username = addslashes($User['username']);
        }

        $resultb = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}iponline WHERE ipaddr='$ipaddr' OR userid='$username'", $link);

        setlogin( $password );

        forward( "index.php", $Globals['pp_lang']['loginok'] );
    }
    else
    {
        list($forgot_link, $reglink) = get_logincode();
        diewell( "{$Globals['pp_lang']['loginbad']} <a href=\"$reglink\">{$Globals['pp_lang']['loginbad2']}</a>." );
    }
}

//
// SUBSCRIBE
//
// Handle subscriptions
//

if ( $action == "subscribe" )
{
    authenticate();

    if ( $User['userid'] < 1 || empty($sub) )
    {
        diewell( $Globals['pp_lang']['errorscript'] );
    }

    if ( $Globals['usenotify'] == "no" )
    {
        $message = $Globals['pp_lang']['suberror'];
    }
    else
    {
        $resulta = ppmysql_query("SELECT id FROM {$Globals['pp_db_prefix']}notify WHERE userid='{$User['userid']}' AND photo=$sub AND type=1 LIMIT 1", $link);
        list( $nid ) = mysql_fetch_row($resulta);
        ppmysql_free_result( $resulta );

        if (empty($nid))
        {
            $resulta = ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}notify (id,userid,photo,type) values(NULL,'{$User['userid']}',$sub,1)", $link);
            $message = $Globals['pp_lang']['submsg'];
        }
        else
        {
            $resulta = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}notify WHERE photo=$sub AND userid='{$User['userid']}' AND type=1", $link);
            $message = $Globals['pp_lang']['unsubmsg'];
        }
    }

    forward( "showgallery.php?cat=$sub", $message);
}

//
// ZIP 'N DOWNLOAD
//
// Zips up a gallery and allows it to be downloaded
//
if ( $action == "downloadzip" )
{
    authenticate();

    if ( $Globals['ppboards'] == "closed" && $User['adminedit'] != 1 )
    {
        diewell( $Globals['closedmsg'] );
    }

    class zipfile
    {
        var $datasec = array();  // array to store compressed data
        var $ctrl_dir = array(); // central directory
        var $eof_ctrl_dir = "\x50\x4b\x05\x06\x00\x00\x00\x00"; //end of Central directory record
        var $old_offset = 0;

        function add_dir($name)
        {
            $name = str_replace("\\", "/", $name);

            $fr = "\x50\x4b\x03\x04";
            $fr .= "\x0a\x00";    // ver needed to extract
            $fr .= "\x00\x00";    // gen purpose bit flag
            $fr .= "\x00\x00";    // compression method
            $fr .= "\x00\x00\x00\x00"; // last mod time and date

            $fr .= pack("V",0);   // crc32
            $fr .= pack("V",0);   // compressed filesize
            $fr .= pack("V",0);   // uncompressed filesize
            $fr .= pack("v", strlen($name) ); // length of pathname
            $fr .= pack("v", 0 ); // extra field length
            $fr .= $name;
            // end of "local file header" segment
            // no "file data" segment for path

            // "data descriptor" segment (optional but necessary if archive is not served as file)
            $fr .= pack("V",$crc);     //crc32
            $fr .= pack("V",$c_len);   //compressed filesize
            $fr .= pack("V",$unc_len); //uncompressed filesize

            // add this entry to array
            $this -> datasec[] = $fr;
            $new_offset = strlen(implode("", $this->datasec));

            // now add to central record
            $cdrec = "\x50\x4b\x01\x02";
            $cdrec .="\x00\x00";         // version made by
            $cdrec .="\x0a\x00";         // version needed to extract
            $cdrec .="\x00\x00";         // gen purpose bit flag
            $cdrec .="\x00\x00";         // compression method
            $cdrec .="\x00\x00\x00\x00"; // last mod time & date
            $cdrec .= pack("V",0);       // crc32
            $cdrec .= pack("V",0);       //compressed filesize
            $cdrec .= pack("V",0);       //uncompressed filesize
            $cdrec .= pack("v", strlen($name) ); //length of filename
            $cdrec .= pack("v", 0 );     //extra field length
            $cdrec .= pack("v", 0 );     //file comment length
            $cdrec .= pack("v", 0 );     //disk number start
            $cdrec .= pack("v", 0 );     //internal file attributes
            $ext = "\x00\x00\x10\x00";
            $ext = "\xff\xff\xff\xff";
            $cdrec .= pack("V", 16 );    //external file attributes  - 'directory' bit set

            $cdrec .= pack("V", $this -> old_offset ); //relative offset of local header
            $this -> old_offset = $new_offset;

            $cdrec .= $name;
            // optional extra field, file comment goes here
            // save to array
            $this -> ctrl_dir[] = $cdrec;
        }


        function add_file($data, $name)
        {
            $name = str_replace("\\", "/", $name);

            $fr = "\x50\x4b\x03\x04";
            $fr .= "\x14\x00";    // ver needed to extract
            $fr .= "\x00\x00";    // gen purpose bit flag
            $fr .= "\x08\x00";    // compression method
            $fr .= "\x00\x00\x00\x00"; // last mod time and date

            $unc_len = strlen($data);
            $crc = crc32($data);
            $zdata = gzcompress($data);
            $zdata = substr( substr($zdata, 0, strlen($zdata) - 4), 2); // fix crc bug
            $c_len = strlen($zdata);
            $fr .= pack("V",$crc); // crc32
            $fr .= pack("V",$c_len); //compressed filesize
            $fr .= pack("V",$unc_len); //uncompressed filesize
            $fr .= pack("v", strlen($name) ); //length of filename
            $fr .= pack("v", 0 ); //extra field length
            $fr .= $name;
            // end of "local file header" segment

            // "file data" segment
            $fr .= $zdata;

            // "data descriptor" segment (optional but necessary if archive is not served as file)
            $fr .= pack("V",$crc);     //crc32
            $fr .= pack("V",$c_len);   //compressed filesize
            $fr .= pack("V",$unc_len); //uncompressed filesize

            // add this entry to array
            $this -> datasec[] = $fr;

            $new_offset = strlen(implode("", $this->datasec));

            // now add to central directory record
            $cdrec = "\x50\x4b\x01\x02";
            $cdrec .="\x00\x00";    // version made by
            $cdrec .="\x14\x00";    // version needed to extract
            $cdrec .="\x00\x00";    // gen purpose bit flag
            $cdrec .="\x08\x00";    // compression method
            $cdrec .="\x00\x00\x00\x00"; // last mod time & date
            $cdrec .= pack("V",$crc); // crc32
            $cdrec .= pack("V",$c_len); //compressed filesize
            $cdrec .= pack("V",$unc_len); //uncompressed filesize
            $cdrec .= pack("v", strlen($name) ); //length of filename
            $cdrec .= pack("v", 0 );  //extra field length
            $cdrec .= pack("v", 0 );  //file comment length
            $cdrec .= pack("v", 0 );  //disk number start
            $cdrec .= pack("v", 0 );  //internal file attributes
            $cdrec .= pack("V", 32 ); //external file attributes - 'archive' bit set

            $cdrec .= pack("V", $this -> old_offset ); //relative offset of local header
            $this -> old_offset = $new_offset;

            $cdrec .= $name;
            $this -> ctrl_dir[] = $cdrec;
        }

        function file()
        {
            // dump out file
            $data = implode("", $this -> datasec);
            $ctrldir = implode("", $this -> ctrl_dir);

            return
                $data.
                $ctrldir.
                $this -> eof_ctrl_dir.
                pack("v", sizeof($this -> ctrl_dir)).     // total # of entries "on this disk"
                pack("v", sizeof($this -> ctrl_dir)).     // total # of entries overall
                pack("V", strlen($ctrldir)).              // size of central dir
                pack("V", strlen($data)).                 // offset to start of central dir
                "\x00\x00";                               // .zip file comment length
        }
    }

    $zipfile = new zipfile();
    $zipfile -> add_dir("photopost/");

    if ( is_numeric($cat) )
    {
       $query = "SELECT id,userid,cat,bigimage,storecat FROM {$Globals['pp_db_prefix']}photos WHERE cat=$cat";
    }
    else
    {
       $query = "SELECT p.id,p.userid,p.cat,p.bigimage,p.storecat FROM {$Globals['pp_db_prefix']}favorites f, {$Globals['pp_db_prefix']}photos p WHERE f.userid='{$User['userid']}' AND f.photo=p.id";
    }

    $queryv = ppmysql_query($query, $link);

    while ( $row = mysql_fetch_row($queryv) )
     {
        list( $id, $tuserid, $thecat, $bigimage, $storecat ) = $row;

        if ( $storecat != 0 )
        {
            $thecat = $storecat;
        }

        $is_private = is_image_private( $thecat );

        if ( $is_private == "no" )
        {
            $filename = "{$Globals['origfull']}$thecat/$bigimage";
            $filesize = filesize( $filename );

            $fp = fopen($filename,"r");
            $filedata = fread($fp,$filesize);

            $zipfile -> add_file($filedata, "photopost/$bigimage");
        }
    }

    // the next three lines force an immediate download of the zip file:
    header("Content-type: application/x-zip-compressed");
    header("Content-disposition: attachment; filename=photopost.zip");

    echo $zipfile -> file();
}

//
// SHOWALBUMS
//
// Give an index of the albums
//

if ( $action == "showalbums" )
{
    // Init some variables
    if ( !isset($si) )
    {
        $si = null;
    }

    if ( !isset($cat) || empty($cat) )
    {
        $cat = "all";
    }

    authenticate();

    if ( $Globals['ppboards'] == "closed" && $User['adminedit'] != 1 )
    {
        diewell( $Globals['closedmsg'] );
    }

	  $perpage1x = $Globals['thumbcols'];
    $perpage3x = ($perpage1x * 3);
    $perpage4x = ($perpage1x * 4);
    $perpage5x = ($perpage1x * 5);
    $perpage6x = ($perpage1x * 6);
  
    if ( $perpage )
    {
        if ( $perpage > 90 ) {
            $perpage = 90;
        }
  
        if ($perpage < $perpage1x) {
            $perpage = $perpage1x;
        }
    }
    else
    {
        if ( isset($ppperpage) )
        {
            $perpage = $ppperpage;
        }
        else
        {
            $perpage = ($Globals['thumbcols'] * $Globals['thumbrows']);
        }
    }
  
    if ( isset($page) && $page > 0 )
    {
        $startnumb = ($page*$perpage)-$perpage+1;
    }
    else
    {
        $page = 1;
        $startnumb = 1;
    }


    // do the sort box //
    $sortoptions = null;
    $sortdefault= null;
    $catrows= null;

    if ( empty($sort) )
    {
        $sortparam = 1;
    }
    else
    {
        $sortparam = $sort;
    }

    if ( $sortparam == 1 )
    {
        $sortdefault = "<option selected=\"selected\" value=\"1\">{$Globals['pp_lang']['user']}</option>";
        $sortoptions = "<option value=\"2\">{$Globals['pp_lang']['albumname']}</option>";
        $sortcode = "ORDER BY p.user";
        $sortextra = ( isset($sl) ? " AND p.user LIKE '$sl%' " : "" );
        $skey = "p.user";
    }
    else
    {
        $sortdefault = "<option selected=\"selected\" value=\"2\">{$Globals['pp_lang']['albumname']}</option>";
        $sortoptions = "<option value=\"1\">{$Globals['pp_lang']['user']}</option>";
        $sortcode = "ORDER BY c.catname";
        $sortextra = ( isset($sl) ? "AND c.catname LIKE '$sl%'" : "" );
        $skey = "c.catname";
    }

    $sort = "<select onchange=\"submit();\" name=\"sort\" style=\"font-size: 9pt; background: FFFFFF;\">$sortdefault$sortoptions</select>";
    // end sort box //

    $phrase= null;

    if ( !empty($si) )
    {
        $sterms = trim($si);
        $searchterms = explode(" ", $sterms);
        $scount=0;
        $totalterms = count($searchterms);
        $totalterms++;

        foreach ($searchterms as $key)
        {
            $scount++;

            if ($scount > 1)
            {
                    $phrase .= " AND ";
            }

            $phrase .= "($skey LIKE '%$key%')";
        }

        if ( $phrase != "" )
        {
            $phrase = "AND ($phrase)";
        }
    }

    $subalbums = null;
    $albums = null;
    $subcats= null;
    $seemore = null;
    $searchterms = $si;
    $numcols = $Globals['thumbcols'];
    $pwidth = intval(100 / $numcols);
    $thecatname = "{$Globals['pp_lang']['allalbums']}";
    $cols = $Globals['thumbcols'];

    printheader( $cat, $thecatname );
    $childnav = "<a href=\"{$Globals['maindir']}/\">{$Globals['pp_lang']['home']}</a> &raquo; {$Globals['pp_lang']['persalbums']}";

    topmenu();

    $arows = ppmysql_query("SELECT c.id,c.catname,c.description,c.photos,p.userid,p.user,p.bigimage,p.approved,p.width,p.height,
                     p2.bigimage, p2.cat, p2.storecat, p2.userid
              FROM {$Globals['pp_db_prefix']}categories c
              LEFT JOIN {$Globals['pp_db_prefix']}photos p ON p.id=c.lastphoto
              LEFT JOIN {$Globals['pp_db_prefix']}photos p2 ON p2.id=c.thumbnail
              WHERE ( c.cattype='a' AND c.photos > 0 AND c.private = 'no' $sortextra $phrase) $sortcode", $link);
    $rowcnt = mysql_num_rows($arows);

    $x = 0;
    $cc = 0;

    while ( list( $subid, $subalbumname, $subalbumdesc, $albphotos, $ppuser, $ppusername, $bigimage, $approved, $iwidth, $iheight, $catthimg, $catthcat, $catstoreid, $catthuid ) = mysql_fetch_row($arows) )
    {
        $cc++;

        if ($cc >= $startnumb)
        {
            if ($cc < ($startnumb+$perpage))
            {
                $albumlink = construct_newppurl( "showgallery.php", array('cat' => $subid) );

                if ( $catstoreid != 0 )
                {
                    $catthcat = $catstoreid;
                }

                if ( !empty($catthimg) )
                {
                    $thumbrc = get_imagethumb( $catthimg, $catthcat, $catthuid, 1 );
                    $thiscat = $catthcat;
                    $theuserid = $catthuid;
                }
                else
                {
                    $thumbrc = get_imagethumb( $bigimage, $subid, $ppuser, $approved );
                    $thiscat = $subid;
                    $theuserid = $ppuser;
                }

                $albums['username'][$x]= $ppusername;
                $albums['thumb'][$x]   = $thumbrc;
                $albums['thumbtag'][$x]= $thumbtag;
                $albums['desc'][$x]    = ( empty($subalbumdesc) ? "" : "<br />$subalbumdesc" );
                $albums['name'][$x]    = $subalbumname;
                $albums['photos'][$x]  = $albphotos;
                $albums['link'][$x]    = $albumlink;
                $albums['private'][$x] = $isprivate;
                $albums['width'][$x]   = $iwidth;
                $albums['height'][$x]  = $iheight;
                $albums['thumbnail'][$x]= get_thumbtmpl( $subid, $thumbrc, $iheight, $iwidth, $thumbtag, $thiscat, $albumlink );

                $albums['albumcount']++;
                $x++;
            }
            else
            {
                break;
            }
        }
    }
    ppmysql_free_result( $arows );

    pagesystem($rowcnt, "misc", "showalbums");

    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );

    $noresults= null;

    if ( $albums['albumcount'] == 0 )
    {
            $noresults .= "<span class=\"{$Style['medium']}\">{$Globals['pp_lang']['noalbums']}<br /></span>";
    }

    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/showalbums.tmpl" );

    printfooter();
}

//
// Order Photos
//
// Used to order photos
//

if ( $action == "orderphotos" )
{
    // Override as we don't want spidering of the Page links

    authenticate();

    if ( $User['userid'] < 1 )
    {
        diewell( $Globals['pp_lang']['nologin'] );
    }

    topmenu();

    if ( empty($ppaction) )
    {
        $sortoptions = null;
        $sortcode= null;
        $posternav= null;
        $catdefault = null;
        $nocat=0;
        $catdisp = "<select onChange=\"submit();\" name=\"cat\">";

        if ( empty($cat) || !is_numeric($cat) )
        {
            $cat = 500;
        }

        $selected = $cat;
        $firstcat = catmoveopt(0, 0, 0, $User['userid']);
        $catdisp .= $catoptions;

        $resultb = ppmysql_query("SELECT id,catname,thumbs,cattype,parent,thumbnail,sortorder FROM {$Globals['pp_db_prefix']}categories WHERE id=$cat LIMIT 1", $link);
        list( $subid, $subcatname, $subthumbs, $cattype, $catparent, $thumbnail, $catsortorder ) = mysql_fetch_row($resultb);
        ppmysql_free_result( $resultb );

        if ( $cattype == "c" )
        {
            diewell( $Globals['pp_lang']['nosort'] );
        }

        if ( $catparent != $User['userid'] && $User['adminedit'] != 1 )
        {
            diewell( $Globals['pp_lang']['noperm'] );
        }

        if ( empty($sort) )
        {
            $sortparam = ( isset($catsortorder) && $catsortorder > 0 ? $catsortorder : 1 );
        }
        else
        {
            $sortparam = $sort;
        }

        $sort = $sortparam;
        $sortoptions = null;
        $sortcode = null;
        $posternav = null;

        $resultc = ppmysql_query("SELECT * FROM {$Globals['pp_db_prefix']}sort", $link);

        while ( list($sortid, $sortname, $sortc) = mysql_fetch_row($resultc) )
        {
            if ($sort != $sortid)
            {
                $sortoptions .= "<option value = $sortid>$sortname</option>";
            }
            else
            {
                $sortdefault = "<option selected value=\"$sortid\">$sortname</option>";
                $sortcode = "$sortc";
            }
        }
        ppmysql_free_result($resultc);

        $sortselect = "<select onchange=\"submit();\" name=\"sort\" class=\"bginput\">$sortdefault$sortoptions</select>";

        if ( !empty($thumb) )
        {
            if ( $cat > 0 && $thumb != $thumbnail )
            {
                $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET thumbnail=$thumb WHERE id=$cat", $link);
                $thumbnail = $thumb;
            }
        }

        $catdefault = "<option selected value=\"$subid\">$subcatname</option>";

        if (!isset($s)) $s = null;

        $perpage1x = $Globals['thumbcols'];
        $perpage3x = ($perpage1x * 3);
        $perpage4x = ($perpage1x * 4);
        $perpage5x = ($perpage1x * 5);
        $perpage6x = ($perpage1x * 6);

        if ( isset($perpage) )
        {
            if ($perpage > $perpage6x)
            {
                $perpage = $perpage6x;
            }

            if ($perpage < $perpage1x)
            {
                $perpage = $perpage1x;
            }
        }
        else
        {
            if ( isset($ppperpage) )
            {
                $perpage = $ppperpage;
            }
            else
            {
                $perpage = $perpage3x;
            }
        }

        if ( isset($page) && $page > 0 )
        {
            $startnumb = ($page*$perpage)-$perpage+1;
        }
        else
        {
            $page = 1;
            $startnumb = 1;
        }

        $numcols = $Globals['thumbcols'];
        $pwidth = intval(100 / $numcols);

        printheader( 0, $Globals['pp_lang']['ordertitle'] );

        $photocount = 0;
        $cntresults = 0;

        $queryz = ppmysql_query("SELECT id,user,userid,cat,title,bigimage,disporder,storecat FROM {$Globals['pp_db_prefix']}photos WHERE cat=$cat $sortcode", $link);
        $rowcnt = mysql_num_rows($queryz);
        pagesystem($rowcnt, "misc", "orderphotos");

        while ( list($id,$tuser,$tuserid,$tcat,$title,$bigimage,$dispo,$storecat) = mysql_fetch_row($queryz))
        {
            $cntresults++;

            if ($cntresults >= $startnumb)
            {
                if ($cntresults < ($startnumb+$perpage))
                {
                    $photocount++;

                    $theext = get_ext( $bigimage );
                    $filename = str_replace( $theext, "", $bigimage );
                    $tcat = ( $storecat == 0 ? $tcat : $storecat );
                    if ( $dispo == 99999 )
                    {
                        $dispo = 0;
                    }

                    $titlearray[$photocount] = $title;
                    $imgtag[$photocount] = get_imagethumb( $bigimage, $tcat, $tuserid, 1 );

                    $theimage[$photocount] = "{$Globals['datadir']}/$cat/$bigimage";

                    $disparray[$photocount] = $dispo;
                    $filearray[$photocount] = $filename;
                    $idarray[$photocount] = $id;

                    if ( $thumbnail == $id )
                    {
                        $selarray[$photocount] = "<span class=\"{$Style['small']}\">{$Globals['pp_lang']['thumb']}</span>";
                    }
                    else
                    {
                        $selarray[$photocount] = "<span class=\"{$Style['small']}\"><a href=\"{$Globals['maindir']}/misc.php?action=orderphotos&amp;cat=$cat&amp;thumb=$id&amp;sort=$sortparam&amp;page=$page\">{$Globals['pp_lang']['makethumb']}</a></span>";
                    }
                }
                else
                {
                    break;
                }
            }
        }
        ppmysql_free_result( $queryz );

        if ( $notcat == 1 )
        {
            $submitmsg = "<br />{Globals['pp_lang']['nothumbs']}<br /><br />";
        }
        elseif ($cntresults == 0)
        {
            $submitmsg = "<br />{$Globals['pp_lang']['nophotos']}<br /><br />";
        }
        else
        {
            $submitmsg = "<br />{$Globals['pp_lang']['setposition']}<br /><br /><input type=\"submit\" value=\"{$Globals['pp_lang']['submit']}\">";
        }

        if ( !empty($posternav) )
        {
            $posternav = "<br />$posternav<br /><br />";
        }

        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );
        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/orderphotos.tmpl" );

        printfooter();
        exit;
    }

    if ($ppaction == "dochanges")
    {
        typecast_wc('order', INT);
        typecast_wc('id', INT);

        $totalphotos = $thecount;

        for ($i = 1; $i <= $totalphotos; $i++) {
            unset($appkey);

            $torder = "order$i";
            $tpid = "id$i";
            $pid = ${$tpid};
            $neworder = ${$torder};

            if ( $pid > 0 ) {
                if ( $neworder == 0 ) $neworder = 99999;
                $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET disporder=$neworder WHERE id=$pid", $link);
            }
        }

        forward( "misc.php?action=orderphotos&s=$s&cat=$cat", $Globals['pp_lang']['complete'] );
    }
}

//
// SORTPHOTOS
//
// Used from the Profile page to allow a user to manage their photos
// on a per category basis
//

if ( $action == "sortphotos" )
{
    // Override as we don't want spidering of the Page links

    authenticate();

    if ( $User['userid'] < 1 )
    {
        diewell( $Globals['pp_lang']['nologinsort'] );
    }

    if ( $Globals['userdel'] == "no" )
    {
        diewell( $Globals['pp_lang']['disabled'] );
    }

    topmenu();

    if ( empty($ppaction) )
    {
        if ( isset($page) && $page > 0 )
        {
            $startnumb = ($page*$perpage)-$perpage+1;
        }
        else
        {
            $page = 1;
            $startnumb = 1;
        }

        $catdefault = null;
        if ( $cat == "notcat" || !is_numeric($cat) )
        {
            $cat = 0;
            $notcat = 1;
        }

        if ( !empty($cat) ) {
            $resultb = ppmysql_query("SELECT id,catname,thumbs,cattype,sortorder FROM {$Globals['pp_db_prefix']}categories WHERE id=$cat LIMIT 1", $link);
            while ( list( $subid, $subcatname, $subthumbs, $cattype, $catsortorder ) = mysql_fetch_row($resultb) )
            {
                if ( $cattype == "c" )
                {
                    if ( $CatPerms['ugview'][$subid] != 1 )
                    {
                        $catdefault = "<option selected value=\"$subid\">$subcatname</option>";
                    }
                }
            }
            ppmysql_free_result( $resultb );
        }
        else
        {
            $cat = 0;

            if ( $CatPerms['ugview'][500] != 1 )
            {
                $resultb = ppmysql_query("SELECT id,catname,thumbs,sortorder FROM {$Globals['pp_db_prefix']}categories WHERE id=500 LIMIT 1", $link);
                list( $subid, $subcatname, $subthumbs, $catsortorder ) = mysql_fetch_row($resultb);
                ppmysql_free_result( $resultb );

                $catdefault = "<option selected value=\"$subid\">$subcatname</option>";
            }
        }

        $catdisp = "<select onChange=\"submit();\" name=\"cat\">";
        $sortoptions = null;
        $sortcode= null;
        $posternav= null;

        if ( empty($sort) )
        {
            $sortparam = ( isset($catsortorder) && $catsortorder > 0 ? $catsortorder : 1 );
        }
        else
        {
            $sortparam = $sort;
        }

        $resultc = ppmysql_query("SELECT * FROM {$Globals['pp_db_prefix']}sort", $link);
        while ( list($sortid, $sortname, $sortc) = mysql_fetch_row($resultc) )
        {
            if ( $sortparam == $sortid )
            {
                $sortoptions .= "<option value = $sortid>$sortname</option>";
            }
            else {
                $sortdefault = "<option selected value=\"$sortid\">$sortname</option>";
                $sortcode = "$sortc";
            }
        }
        ppmysql_free_result($resultc);

        $sortselect = "<select onchange=\"submit();\" name=\"sort\" class=\"bginput\">$sortdefault$sortoptions</select>";
        // end sort box //

        $selected = $cat;
        catmoveopt(0);

        $catdisp .= $catoptions;

        if (!isset($s))
        {
            $s = null;
        }

        $perpage1x = $Globals['thumbcols'];
        $perpage3x = ($perpage1x * 3);
        $perpage4x = ($perpage1x * 4);
        $perpage5x = ($perpage1x * 5);
        $perpage6x = ($perpage1x * 6);

        if ( isset($perpage) )
        {
            if ($perpage > $perpage6x)
            {
                $perpage = $perpage6x;
            }

            if ($perpage < $perpage1x)
            {
                $perpage = $perpage1x;
            }
        }
        else
        {
            if ( isset($ppperpage) )
            {
                $perpage = $ppperpage;
            }
            else
            {
                $perpage = $perpage3x;
            }
        }

        if ( isset($page) && $page > 0 )
        {
            $startnumb = ($page*$perpage)-$perpage+1;
        }
        else
        {
            $page = 1;
            $startnumb = 1;
        }

        $numcols = $Globals['thumbcols'];
        $pwidth = intval(100 / $numcols);

        printheader( 0, $Globals['pp_lang']['photoadmin'] );

        $count = 0;
        $albums = null;
        $photocount = 0;
        $cntresults = 0;

        $queryz = ppmysql_query("SELECT id,user,userid,cat,storecat,storeid,date,title,description,keywords,bigimage,width,height,filesize,views,medwidth,medheight,medsize,approved FROM {$Globals['pp_db_prefix']}photos WHERE cat=$cat AND userid='{$User['userid']}' AND approved=1 $sortcode", $link);
        $rowcnt = mysql_num_rows($queryz);

        pagesystem( $rowcnt, "misc", "sortphotos" );

        while ( list($id,$tuser,$tuserid,$tcat,$storecat,$storeid,$date,$title,$desc,$keywords,$bigimage,$width,$height,$filesize,$views,$medwidth,$medheight,$medsize,$approved) = mysql_fetch_row($queryz))
        {
            $cntresults++;
            $filesize = $filesize/1024;
            $filesize = sprintf("%1.1f", $filesize);
            $filesize = $filesize."{$Globals['pp_lang']['kb']}";

           if ($cntresults >= $startnumb)
           {
                if ($cntresults < ($startnumb+$perpage))
                {
                    $photocount++;
                    $count++;
                    $storecat = ( $storecat == 0 ? $tcat : $storecat );

                    $extracat = null;
                    $result2 = ppmysql_query("SELECT p.id,c.catname FROM {$Globals['pp_db_prefix']}photos p
                        LEFT JOIN {$Globals['pp_db_prefix']}categories c ON c.id=p.cat
                        WHERE p.storeid=$id", $link);

                    while ( list( $exid, $excat ) = mysql_fetch_row($result2) )
                    {
                        $extracat .= "$excat<br />";
                    }
                    ppmysql_free_result( $result2 );

                    $theext = get_ext( $bigimage );
                    $filename = str_replace( $theext, "", $bigimage );
                    $ppdate = formatppdate( $date );

                    if ($Globals['bigsave'] == "yes")
                    {
                        if ($filesize != "0")
                        {
                            if ($medsize > 0)
                            {
                                $medsize = $medsize/1024;
                                $medsize = sprintf("%1.1f", $medsize);
                                $medsize = $medsize."{$Globals['pp_lang']['kb']}";
                                $ilink   = $Globals['datadir']."/$storecat/medium/$bigimage";
                                $biglink = $Globals['datadir']."/$storecat/$bigimage";
                                $fsizedisp = "<a href=\"{$Globals['datadir']}/$storecat/medium/$bigimage\" target=\"_blank\">$medsize</a>, <a
                                    href=\"{$Globals['datadir']}/$storecat/$bigimage\" target=\"_blank\">$filesize</a>";
                            }
                            else
                            {
                                $ilink = $Globals['datadir']."/$storecat/$bigimage";
                                $fsizedisp = "<a href=\"{$Globals['datadir']}/$storecat/$bigimage\" target=\"_blank\">$filesize</a>";
                            }
                        }
                    }
                    else
                    {
                        $fsizedisp = "{$Globals['pp_lang']['na']}";
                    }

                    $theimage = "{$Globals['datadir']}/$storecat/$bigimage";
                    $imgtag = get_imagethumb( $bigimage, $storecat, $tuserid, 1 );

                    $result = ppmysql_query("SELECT id,catname,thumbs FROM {$Globals['pp_db_prefix']}categories WHERE id=$tcat LIMIT 1", $link);
                    list( $subid, $subcatname, $subthumbs ) = mysql_fetch_row($result);
                    ppmysql_free_result( $result );

                    $catdefhide = "<input type=\"hidden\" name=\"catdef$photocount\" value=\"$subid\">";
                    $catoptions = null;
                    $selected = $subid;
                    catmoveopt(0);

                    $deletecheck = null;
                    $approvecheck = null;
                    $holdcheck = null;

                    if ( isset($defdel) )
                    {
                        $deletecheck = "checked=\"checked\"";
                        $approvecheck = null;
                    }
                    elseif ( isset($defapp) )
                    {
                        $approvecheck = "checked=\"checked\"";
                    }
                    else
                    {
                        $holdcheck = "checked=\"checked\"";
                        $approvecheck = null;
                    }

                    $albums .= "<tr>
                                <td class=\"{$Style['tddetails']}\" valign=\"middle\" align=\"center\" width=\"125\">
                                    <a href=\"{$Globals['maindir']}/showphoto.php?photo=$id&amp;cat=$cat\" target=\"_blank\">$imgtag</a>
                                    <br /><span class=\"{$Style['small']}\">$filename</span>
                                </td>
                                <td class=\"{$Style['tddetails']}\" align=\"center\">
                                    $title<br />$ppdate<br />$fsizedisp<br /><br />
                                    <select name=\"category$photocount\" class=\"bginput\">$catoptions</select>";

                    if ( $extracat != "" )
                    {
                        $albums .= "<br />{$Globals['pp_lang']['extracats']}:<br /><span class=\"{$Style['small']}\">$extracat</span>";
                    }

                    $albums .= "</td>
                                <td class=\"{$Style['tddetails']}\" align=\"center\">
                                    <input type=\"hidden\" name=\"theimage$photocount\" value=\"$bigimage\">
                                    <input type=\"hidden\" name=\"id$photocount\" value=\"$id\">
                                    <input type=\"hidden\" name=\"origcat$photocount\" value=\"$subid\">
                                    <input type=\"hidden\" name=\"tuserid$photocount\" value=\"$tuserid\">
                                    <input name=\"approve$photocount\" value=\"delete\" $deletecheck type=\"radio\">
                                </td>
                                <td class=\"{$Style['tddetails']}\" align=\"center\">
                                    <input name=\"approve$photocount\" $holdcheck value=\"approve\" type=\"radio\">
                                </td>
                                $catdefhide
                                </td></tr>";
                }
                else
                {
                    break;
                }
            }
        }
        ppmysql_free_result( $queryz );

        if ($cntresults == 0)
        {
            $submitmsg = "<br />{$Globals['pp_lang']['noalbphotos']}<br /><br />";
        }
        elseif ($notcat == 1)
        {
            $submitmsg = "<br />{$Globals['pp_lang']['noalbthumbs']}<br /><br />";
        }
        else
        {
            $submitmsg = "<input type=\"submit\" value=\"{$Globals['pp_lang']['submit']}\">";
        }

        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );
        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/sortphotos.tmpl" );

        printfooter();
        exit;
    }

    if ($ppaction == "dochanges")
    {
        typecast_wc('approve', STRING);
        typecast_wc('category', INT);
        typecast_wc('catdef', INT);
        typecast_wc('origcat', INT);
        typecast_wc('tuserid', INT);
        typecast_wc('theimage', STRING);
        typecast_wc('id', INT);

        $totalphotos=$thecount;

        for ($i = 1; $i <= $totalphotos; $i++)
        {
            unset($appkey);

            $tappkey = "approve$i";
            $catkey = "category$i";
            $catdefkey = "catdef$i";
            $origcat = "origcat$i";
            $tuserid = "tuserid$i";
            $theimage = "theimage$i";
            $tpid = "id$i";

            $pid = ${$tpid};
            $appkey = ${$tappkey};

            $result = ppmysql_query("SELECT userid FROM {$Globals['pp_db_prefix']}photos WHERE id=$pid LIMIT 1", $link);
            list( $owner ) = mysql_fetch_row($result);
            if ( $owner != $User['userid'] && $User['adminedit'] != 1 )
            {
                diewell( $Globals['pp_lang']['noperm'] );
            }

            if ( $pid > 0 )
            {
                if ($appkey == "approve")
                {
                    $newcatid=${$catkey};
                    $catdef=${$catdefkey};
                    $origcat=${$origcat};
                    $tuserid=${$tuserid};
                    $theimage=${$theimage};

                    if ($newcatid == "notcat")
                    {
                        diewell("#$i: {$Globals['pp_lang']['badcat']}");
                    }

                    if ( $origcat != $newcatid )
                    {
                        move_image( $origcat, $newcatid, $tuserid, $theimage );
                        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET cat=$newcatid WHERE id=$pid", $link);
                        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}comments SET cat=$newcatid WHERE photo=$pid", $link);
                        $origcat = $newcatid;
                    }

                    ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET approved=1 WHERE id=$pid OR storeid=$pid", $link);
                    adminlog( "Approved ID #$pid" );

                }
                elseif ($appkey == "delete")
                {
                    $resulta = ppmysql_query("SELECT userid,cat,title,bigimage,medsize FROM {$Globals['pp_db_prefix']}photos WHERE id=$pid", $link);
                    list( $uid, $dcat, $title, $filename, $medsize ) = mysql_fetch_row($resulta);
                    ppmysql_free_result( $resulta );

                    if ( is_numeric($uid) )
                    {
                        remove_all_files( $filename, $medsize, $uid, $dcat );
                    }
                    else
                    {
                        diewell($Globals['pp_lang']['nopic']);
                    }

                    inc_user_posts( "minus", $uid );

                    $resulta = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}photos WHERE id=$pid", $link);
                    $resulta = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}photos WHERE storeid=$pid", $link);
                    $resulta = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}comments WHERE photo=$pid", $link);
                    $resulta = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}exif WHERE photoid=$pid", $link);
                    $resulta = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}notify WHERE photo=$pid", $link);

                    upgradecategories($dcat);
                    adminlog( "Deleted photo ID #$pid" );
                }
            }
        }

        forward( "misc.php?action=sortphotos&s=$s&cat=$cat&page=$page&perpage=$perpage&sort=$sort", $Globals['pp_lang']['sortcomp'] );
    }
}

?>