<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

define( 'THIS_SCRIPT', "member" );
require "pp-inc.php";

$PATH_INFO = findenv("PATH_INFO");
if ( isset($PATH_INFO) && $Globals['spider'] != "none" )
{
    $id = 0;
    $test = explode('/', substr($PATH_INFO,1));

    for( $i = 0; $i < count($test); $i++ )
    {
        if( $i % 2 == 0 )
        {
            if ( $Globals['spider'] == "seo" )
            {
                if ( $test[$i] == "uid" )
                {
                    // Do a 301 search engine friendly forward
                    $id = (int)$test[$i+1];
                }
            }
            else
            {
                // Using "spider" URLs
                $_REQUEST[$test[$i]] = $test[$i+1];
            }
        }
    }

    if ( $Globals['spider'] == "seo" && strstr($PATH_INFO, "?") )
    {
        // Was "normal" URLs, but want an SEO, so do a 301 search engine friendly forward
        // http://www.website.com/member.php?uid=1
        $id = (int)$_GET['uid'];
	typecast($_REQUEST, array('protype' => INT, 'ppaction' => STRING));
        $protype = (int)$_GET['protype'];
    }

    if ( $id > 0 && empty($ppaction) )
    {
        list( , $username ) = get_userinfo(0, $id);
        header ('HTTP/1.1 301 Moved Permanently');
        header ('Location: '. $location);
        header ('Location: '. construct_newppurl( "member.php", array('uid' => $id, 'username' => $username, 'protype' => $protype) ) );
        exit;
    }
}


function ago($timestamp)
{
   $difference = time() - $timestamp;

   if( $difference < 60 )
       return $difference." {$Globals['pp_lang']['secago']}";
   else
   {
       $difference = round($difference / 60);

       if( $difference < 60 )
           return $difference." {$Globals['pp_lang']['minago']}";
       else
       {
           $difference = round($difference / 60);

           if( $difference < 24 )
               return $difference." {$Globals['pp_lang']['hoursago']}";
           else
           {
               $difference = round($difference / 24);

               if( $difference < 7 )
                   return $difference." {$Globals['pp_lang']['daysago']}";
               else
               {
                   $difference = round($difference / 7);
                   return $difference." {$Globals['pp_lang']['weeksago']}";
               }
           }
       }
   }
}

typecast($_REQUEST, array('uid' => INT, 'ppaction' => STRING, 'verifykey' => INT, 'protype' => INT, 'resend' => STRING,
                          'delete' => STRING, 'showall' => INT, 'iname' => STRING, 'iemail' => STRING,
                          'iname' => STRING, 'iemail' => STRING, 'imessage' => STRING));
typecast($_POST, array('editemail' => STRING, 'editemailconfirm' => STRING, 'editbio' => STRING, 'editbirthday' => STRING,
                       'edithomepage' => STRING, 'editicq' => STRING, 'editaim' => STRING, 'edityahoo' => STRING,
                       'edityear' => STRING, 'editday' => STRING, 'editmonth' => STRING, 'edithobbies' => STRING,
                       'editoccupation' => STRING, 'editinterests' => STRING, 'editlocation' => STRING, 'inemail' => STRING,
                       'do' => STRING, 'oldpassword' => STRING, 'newpassword' => STRING,
                       'cnewpassword' => STRING, 'email' => STRING, 'emailconfirm' => STRING, 'bio' => STRING,
                       'birthday' => STRING, 'homepage' => STRING, 'icq' => STRING, 'aim' => STRING,
                       'yahoo' => STRING, 'year' => STRING, 'hobbies' => STRING, 'occupation' => STRING,
                       'location' => STRING, 'edittitle' => STRING, 'editsig' => STRING, 'mature' => STRING, 'offset' => INT));

typecast_wc('delsub', STRING);
typecast_wc('delnot', STRING);

authenticate();

if ( $Globals['ppboards'] == "closed" && $User['adminedit'] != 1 )
{
    diewell( $Globals['closedmsg'] );
}

if ( empty($ppaction) )
{
    $ppaction = "profile";
}

// If not for someone else, then for me...
if ( $uid == 0 )
{
    $uid = $User['userid'];
}

if ( $uid == $User['userid'] )
{
    $query = "SELECT COUNT(*) FROM {$Globals['pp_db_prefix']}subscriptions WHERE isactive='yes'";
    $resultz = ppmysql_query($query,$link);
    $subcheck = mysql_num_rows($resultz);
}

// Reset password
if ( $ppaction == "rpwd" && $Globals['vbversion'] == "photopost" )
{
    list( $dbkey, $email, $dbuser ) = ppmysql_query_onerow("SELECT joindate,email,username FROM {$Globals['pp_db_prefix']}users WHERE userid=$uid", $link);

    if ( $verifykey == $dbkey )
     {
        $newpass = gen_password();
        $npass = md5($newpass);

        $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}users SET password='$npass' WHERE userid=$uid", $link);
        include("{$Globals['PP_PATH']}/languages/$pplang.php");

        $mail_from = "From: {$Globals['adminemail']}";
        $letter = $Globals['pp_lang']['epassnew'];
        $letter = stripslashes($letter);
        $subject = $Globals['pp_lang']['epassrsub'];

        mail( $email, $subject, $letter, $mail_from );

        if ( isset($adminreset) )
        {
            diewell( $Globals['pp_lang']['ureset'] );
        }

        forward( "index.php", $Globals['pp_lang']['preset'] );
    }
    else
    {
        forward( "index.php", $Globals['pp_lang']['nourlmatch'] );
    }
    exit;
}

//
// View a user's profile
//

if ( $Globals['showavatar'] == "yes" )
{
    list( $cuname, $cuhomep, $cuposts, $cutitle, $cureg, $culoc, $cuavatar, $usig ) = get_profiledata( $uid );
}

$msgtext = null;
if ( $ppaction == "sendpm" )
{
    if ( $uid && $imessage && $iname )
    {
        send_ppmsg( $uid, $imessage, $User['userid'], 'm' );

        $msgtext = get_string( "msgsent", $iname );
    }
    else
    {
        $msgtext = $Globals['pp_lang']['nomsg'];
    }

    // Now drop them down to messages
    $ppaction = "profile";
    $protype = 6;
    $uid = $User['userid'];
}

if ( $ppaction == "message" )
{
    if ( $delete == "all" )
    {
        ppmysql_query( "UPDATE {$Globals['pp_db_prefix']}messages SET status=1 WHERE userid=$uid", $link );
    }
    else
    {
        $delete = (int)$delete;
        if ( $delete )
        {
            ppmysql_query( "UPDATE {$Globals['pp_db_prefix']}messages SET status=1 WHERE msgid=$delete", $link );
        }
    }

    // Now drop them down to messages
    $ppaction = "profile";
    $protype = 6;
}

$invitemsg = null;
if ( $ppaction == "invite" && $User['userid'] > 0 )
{
    if ( $resend )
    {
        list( $icode, $omessage, $oname, $iemail ) = ppmysql_query_onerow( "SELECT code,message,name,email FROM {$Globals['pp_db_prefix']}invites WHERE code='$resend' AND status < 9 LIMIT 1", $link );

        if ( $icode )
        {
            $iname = $oname;
            $imessage = $omessage;

            list( , , $temail ) = get_userinfo( "", $User['userid'] );

            $letter = get_string( "invitemsg", $iname ) . "!\n\n$imessage\n\n";
            $letter .= "{$Globals['pp_lang']['tojoin']}\n\n";

            $letter .= "{$Globals['maindir']}/register.php?invite=$icode\n\n";

            $email_from = "From: {$Globals['adminemail']}";
            $subject = get_string( "invitesub", $User['username'] );

            mail( $iemail, $subject, $letter, $email_from );

            $invitemsg  = get_string( "inviteresend", $iname, $iemail );
        }
    }
    elseif ( $delete )
    {
        ppmysql_query( "DELETE FROM {$Globals['pp_db_prefix']}invites WHERE code='$delete'", $link );

        $tuser = $User['userid'];

        ppmysql_query( "UPDATE {$Globals['pp_db_prefix']}users SET invites=(invites-1) WHERE userid=$tuser", $link );

    }
    elseif ( $iemail && $iname && $imessage )
    {
        list( $userid ) = ppmysql_query_onerow( "SELECT userid FROM {$Globals['pp_db_prefix']}users WHERE email='$iemail' LIMIT 1", $link );

        if ( $userid )
        {
            // Already a user
            $invitemsg = get_string( "invitexist", $iemail);
        }
        else
        {
            list( $icode, $omessage, $oname ) = ppmysql_query_onerow( "SELECT code,message,name FROM {$Globals['pp_db_prefix']}invites WHERE email='$iemail' AND status < 9 LIMIT 1", $link );

            $tuser = $User['userid'];

            if ( $icode )
            {
                $iname = $oname;
                $imessage = $omessage;
                $invitemsg  = get_string( "inviteresend", $iname, $iemail );
            }
            else
            {
                $tdate = time();

                do
                {
                    $icode = gen_password();

                    $scode = ppmysql_query( "INSERT INTO {$Globals['pp_db_prefix']}invites (code,email,name,message,datestamp,referer) VALUES ('$icode', '$iemail', '$iname', '$imessage', $tdate, $tuser)", $link );
                    $lastid = mysql_insert_id($link);
                } while ( !$lastid );

                $invitemsg = get_string( "invitesent", $iname, $iemail );
            }

            list( , , $temail ) = get_userinfo( "", $tuser );

            $letter = get_string( "invitemsg", $iname ) . "\n\n$imessage\n\n";
            $letter .= $Globals['pp_lang']['tojoin'] ."\n\n";
            $letter .= "{$Globals['maindir']}/register.php?invite=$icode\n\n";

            $email_from = "From: {$Globals['adminemail']}";
            $subject = get_string( "invitesub", $User['username'] );

            mail( $iemail, $subject, $letter, $email_from );

            ppmysql_query( "UPDATE {$Globals['pp_db_prefix']}users SET invites=(invites+1) WHERE userid=$tuser", $link );
        }
    }
    else
    {
        $invitemsg = $Globals['pp_lang']['invitebad'];
    }

    // Now drop them down below
    $ppaction = "profile";
    $protype = 5;
}

if ( $ppaction == "profile" )
{
    $buddylist = null;
    if ( $User['userid'] && ($User['userid'] != $uid) )
    {
        // Buddy?

        list( $isbuddy ) = ppmysql_query_onerow("SELECT id FROM {$Globals['pp_db_prefix']}buddies WHERE userid={$User['userid']} AND buddy=$uid", $link);

        if ( $isbuddy )
        {
            $buddylist = "<span id=\"buddy\"><a title=\"{$Globals['pp_lang']['addbuddy']}\" href=\"javascript:sendInfoReq('delbuddy','$uid');\">{$Globals['pp_lang']['remfrombuddy']}</a></span>";
        }
        else
        {
            $buddylist = "<span id=\"buddy\"><a title=\"{$Globals['pp_lang']['rembuddy']}\" href=\"javascript:sendInfoReq('addbuddy','$uid');\">{$Globals['pp_lang']['addtobuddy']}</a></span>";
        }
    }

    if ( !$protype )
    {
        $userprofile = null;
        list( $userid,$username,$utitle,$usig,$uavatar,$usergroupid,$homepage,$icq,$aim,$yahoo,$joindate,$posts,$birthday,$location,$interests,$occupation,$bio,$offset ) = ppmysql_query_onerow("SELECT userid,username,title,signature,avatar,usergroupid,homepage,icq,aim,yahoo,joindate,posts,birthday,location,interests,occupation,bio,offset FROM {$Globals['pp_db_prefix']}users WHERE userid=$uid LIMIT 1", $link);


        // get the users profile information
        list( $userid, $username, $email, $password, $temppass, $groups, $offset, $sessionid ) = get_userinfo( "", $uid );
        $userprofile = get_profilelink( $uid, $username );

        $interests = convert_returns(convert_markups($interests));
        $bio = convert_returns(convert_markups($bio));
    }
    elseif ( $protype == 3 )
    {
        $userprofile = null;
        // get the users profile information
        list( $userid, $username, $email, $password, $temppass, $groups, $offset, $sessionid ) = get_userinfo( "", $uid );
        $userprofile = get_profilelink( $uid, $username );

        list( $totalviews, $diskuse, $totalphotos ) = ppmysql_query_onerow("SELECT SUM(views), SUM(filesize), count(*) FROM {$Globals['pp_db_prefix']}photos WHERE userid=$uid", $link);

        list( $posttotal ) = ppmysql_query_onerow("SELECT count(*) FROM {$Globals['pp_db_prefix']}comments WHERE userid=$uid", $link);

        $userlink = construct_newppurl( "showgallery.php", array('ppuser' => $uid, 'username' => $username ) );
        $totalviews = number_format( $totalviews );
        $totalphotos = number_format( $totalphotos );
        $posttotal = number_format( $posttotal );
        $diskspace = $diskuse/1048576;
        $diskspace = number_format( $diskspace, 1 ) . "{$Globals['pp_lang']['megabytes']}";

        $resulta = ppmysql_query("SELECT p.id,p.title,p.userid,p.cat,p.approved,p.storecat,p.bigimage,p.ismature FROM {$Globals['pp_db_prefix']}photos p LEFT JOIN {$Globals['pp_db_prefix']}categories c ON p.cat=c.id WHERE p.userid=$uid AND c.password='' ORDER BY p.date DESC", $link);
        while ( list( $phoid, $photitle, $puser, $pcat, $papproved, $pstorecat, $pbigimage, $pmature ) = mysql_fetch_row($resulta) )
        {
            $is_private = is_image_private( $pcat );
            if ( $pmature == 1 && !$User['userid'] )
            {
                $is_private = "no";
            }

            if ( $is_private == "no" )
            {
                break;
            }
        }

        if ( !empty($pbigimage) )
        {
            if ( $pstorecat )
            {
                $pcat = $pstorecat;
            }

            $mthumb = get_imagethumb($pbigimage, $pcat, $puser, $papproved);
        }
        else
        {
            $mthumb = null;
            $photitle = null;
        }

        if ( empty($photitle) )
        {
            $photitle = $Globals['pp_lang']['never'];
        }
        else
        {
            $photitle = "<a href=\"{$Globals['maindir']}/showphoto.php?photo=$phoid\">$mthumb<br />$photitle</a>";
        }

        list( $comid, $comment ) = ppmysql_query_onerow("SELECT photo,comment FROM {$Globals['pp_db_prefix']}comments WHERE userid=$uid AND comment != '' ORDER BY date DESC LIMIT 1", $link);

        if ($comid > 0 )
        {
            list($comphoid, $comphotitle) = ppmysql_query_onerow("SELECT id,title FROM {$Globals['pp_db_prefix']}photos WHERE id='$comid' ORDER BY date DESC LIMIT 1", $link);

            $comment = convert_returns(convert_markups($comment));
            $comphotitle = "<a href=\"{$Globals['maindir']}/showphoto.php?photo=$comphoid\">$comphotitle</a><br />$comment";
        }
        else
        {
            $comphotitle = $Globals['pp_lang']['never'];
        }

        $catsub = null;
        $notifysub = null;
        $submitcheck = 0;

        if ( $uid == $User['userid'] || $User['adminedit'] == 1 )
        {
            // Now get their subscriptions
            $resulta = ppmysql_query("SELECT n.id,n.photo,n.type,c.id,c.catname,p.id,p.title FROM {$Globals['pp_db_prefix']}notify n
                      LEFT JOIN {$Globals['pp_db_prefix']}categories c ON c.id=n.photo
                      LEFT JOIN {$Globals['pp_db_prefix']}photos p ON p.id=n.photo
                      WHERE n.userid=$uid", $link);

            $catsub = "<tr><td class=\"{$Style['tddetails']}\" colspan=\"2\"><span class=\"small\">{$Globals['pp_lang']['nosub']}</span></td></tr>";
            $notifysub = "<tr><td class=\"{$Style['tddetails']}\" colspan=\"2\"><span class=\"small\">{$Globals['pp_lang']['nonotify']}</span></td></tr>";

            while ( list( $notifyid, $notifycat, $notifytype, $catid, $catname, $photoid, $phototitle ) = mysql_fetch_row($resulta) )
            {
                if ( $notifytype == 1 ) {
                    $catrows .= "<tr><td width=\"25\" class=\"{$Style['tddetails']}\" align=\"center\"><input type=\"checkbox\" name=\"delsub$notifyid\" value=\"delsub-$notifyid\" /></td>
                                 <td class=\"{$Style['tddetails']}\" align=\"left\">
                                 <a href=\"{$Globals['maindir']}/showgallery.php?cat=$notifycat\">$catname</a></td></tr>";
                }
                else
                {
                    $notifyrows .= "<tr><td width=\"25\" class=\"{$Style['tddetails']}\" align=\"center\"><input type=\"checkbox\" name=\"delnot$notifyid\" value=\"delnot-$notifyid\" /></td>
                                    <td class=\"{$Style['tddetails']}\" align=\"left\">
                                    <a href=\"{$Globals['maindir']}/showphoto.php?photo=$photoid\">$phototitle</a></td></tr>";
                }
                $submitcheck = 1;
           }

            if ( $catrows != "" )
                $catsub = "$catrows<tr><td align=\"left\" class=\"{$Style['tddetails']}\" colspan=\"2\"><input type=\"submit\" value=\"{$Globals['pp_lang']['unsubscribe']}\" /></td></tr>";

            if ( $notifyrows != "" )
                $notifysub = "$notifyrows<tr><td align=\"left\" class=\"{$Style['tddetails']}\" colspan=\"2\"><input type=\"submit\" value=\"{$Globals['pp_lang']['unsubscribe']}\" /></td></tr>";
        }
    }
    elseif ( $protype == 1 || $protype == 4 )
    {
        list( $userid, $username ) = get_userinfo( "", $uid );
    }
    elseif ( $protype == 5 && $User['userid'] == $uid )
    {
        // Invites

        list( $userid, $username ) = get_userinfo( "", $uid );

        $resulta = ppmysql_query("SELECT invites,accepts FROM {$Globals['pp_db_prefix']}users WHERE userid=$uid LIMIT 1", $link);
        list( $invites, $accepts ) = mysql_fetch_row($resulta);

        $finvites = number_format( $invites );
        $faccepts = number_format( $accepts );

        // Outstanding invites
        $outstand = array();
        $x = 0;
        $statusa = array( $Globals['pp_lang']['invitesent'], $Globals['pp_lang']['remidersent'], null, null, null, null, null, null, null, $Globals['pp_lang']['accepted'] );

        $oinvites = ppmysql_query("SELECT name,code,email,datestamp,status FROM {$Globals['pp_db_prefix']}invites WHERE referer=$uid AND status < 9 ORDER BY datestamp DESC", $link);
        while ( $oresult = mysql_fetch_assoc($oinvites) )
        {
            $outstand[$x][name] = $oresult[name];
            $outstand[$x][email] = $oresult[email];
            $outstand[$x][code] = $oresult[code];

            $outstand[$x][date] = ago($oresult[datestamp]);

            $outstand[$x][status] = $statusa[$oresult[status]];
            $x++;
        }

        $acptd = null;
        $oinvites = ppmysql_query("SELECT i.name,i.uid,u.username FROM {$Globals['pp_db_prefix']}invites i
                                          LEFT JOIN {$Globals['pp_db_prefix']}users u ON (u.userid=i.uid)
                                          WHERE i.referer=$uid AND i.status=9 ORDER BY i.datestamp DESC LIMIT 20", $link);
        while ( $oresult = mysql_fetch_assoc($oinvites) )
        {
            $acptd .= ( $acptd ? ", " : "" ) . "{$oresult['name']} as <a href=\"". construct_newppurl( "member.php", array('uid' => $oresult['uid'], 'username' => $oresult['username']) ) ."\">$oresult[username]</a>";
        }
    }
    elseif ( $protype == 6 && $User['userid'] == $uid )
    {
        // Messages
        $userid = $User['userid'];
        $username = $User['username'];

        $statusa = array( $Globals['pp_lang']['new'], $Globals['pp_lang']['read'] );

        $x = 0;
        $messages = array();

        $limitq = ( $showall ? null : "LIMIT 15" );

        $msgs = ppmysql_query("SELECT msgid,datestamp,message,type,photo FROM {$Globals['pp_db_prefix']}messages WHERE userid=$uid AND status=0 ORDER BY datestamp DESC $limitq", $link);
        while ( $msg = mysql_fetch_assoc($msgs) )
        {
            if ( $msg['type'] == "m" )
            {
                list( $tid, $tname ) = get_userinfo( "", $msg['photo'] );

                $msg[datestamp] = $msg[datestamp] + ($User['offset'] * 3600) + ($Globals['gmtoffset'] * 3600);

                $messages[$x] = "{$Globals['pp_lang']['from']}: <a href=\"". construct_newppurl( "member.php", array('uid' => $tid, 'username' => $tname) ) ."\">$tname</a> [ ". strftime( "%B %d %I:%m%p", $msg[datestamp]) . " ] [ <a href=\"{$Globals['maindir']}/member.php?uid=$tid&amp;protype=7\">{$Globals['pp_lang']['reply']}</a> ]<br /><br />";
                $messages[$x] .= convert_returns(convert_markups($msg['message']));
            }
            else
            {
                $msg[datestamp] = $msg[datestamp] + ($User['offset'] * 3600) + ($Globals['gmtoffset'] * 3600);

                $messages[$x] = strftime( "%B %d %I:%m%p", $msg[datestamp]) . ": ";
                $messages[$x] .= convert_returns(convert_markups($msg['message']));
            }

            $msgid[$x] = $msg['msgid'];

            $x++;
        }
    }
    elseif ( $protype == 7 && $User['userid'] )
    {
        $username = $User['username'];
        list( $userid, $sendname ) = get_userinfo( "", $uid );
    }
    elseif ( $protype == 8 && $User['userid'] )
    {
        // Buddy List
        $userid = $User['userid'];
        $username = $User['username'];

        $buddies = array();

        $buds = ppmysql_query("SELECT b.buddy,u.userid,u.username,u.laston,o.date FROM {$Globals['pp_db_prefix']}buddies b
                                      LEFT JOIN {$Globals['pp_db_prefix']}users u ON (u.userid=b.buddy)
                                      LEFT JOIN {$Globals['pp_db_prefix']}iponline o ON (o.uid=b.buddy)
                                      WHERE b.userid=$userid ORDER BY u.username", $link);
        while ( $bud = mysql_fetch_assoc($buds) )
        {
            $online = $laston = null;
            if ( $bud['date'] > 0 )
            {
                $tdiff = time() - $bud['date'];
                if ( $tdiff < 1200 )
                {
                    // Online if in last 20 minutes
                    $online = "[ <b>online</b> ] ";
                }
                elseif ( $bud['laston'] )
                {
                    $bud['laston'] = $bud['laston'] + ($User['offset'] * 3600) + ($Globals['gmtoffset'] * 3600);
                    $laston = " [ {$Globals['pp_lang']['lastseen']}: ". strftime( "%B %d %I:%m%p", $bud['laston']) ." ]";
                }
            }
            else
            {
                if ( $bud['laston'] )
                {
                    $bud['laston'] = $bud['laston'] + ($User['offset'] * 3600) + ($Globals['gmtoffset'] * 3600);
                    $laston = " [ {$Globals['pp_lang']['lastseen']}: ". strftime( "%B %d %I:%m%p", $bud['laston']) ." ]";
                }
            }

            $resulta = ppmysql_query("SELECT p.id,p.title,p.userid,p.cat,p.approved,p.storecat,p.bigimage FROM {$Globals['pp_db_prefix']}photos p LEFT JOIN {$Globals['pp_db_prefix']}categories c ON p.cat=c.id WHERE p.userid={$bud['userid']} AND c.password='' ORDER BY p.date DESC LIMIT 5", $link);
            while ( list( $phoid, $photitle, $puser, $pcat, $papproved, $pstorecat, $pbigimage ) = mysql_fetch_row($resulta) )
            {
                if ( is_image_private($pcat) == "no" )
                {
                    break;
                }
            }

            if ( !empty($pbigimage) )
            {
                if ( $pstorecat )
                {
                    $pcat = $pstorecat;
                }

                $mthumb = get_imagethumb($pbigimage, $pcat, $puser, $papproved);
            }
            else
            {
                $mthumb = null;
                $photitle = null;
            }

            if ( empty($photitle) )
            {
                $photitle = $Globals['pp_lang']['noimage'];
            }
            else
            {
                $photitle = "<a href=\"{$Globals['maindir']}/showphoto.php?photo=$phoid\">$mthumb<br />$photitle</a>";
            }

            $resulta = ppmysql_query("SELECT photo,comment FROM {$Globals['pp_db_prefix']}comments WHERE userid={$bud['userid']} AND comment != '' ORDER BY date DESC LIMIT 1", $link);
            list( $comid, $comment ) = mysql_fetch_row($resulta);

            $comphotitle = null;
            if ($comid > 0 )
            {
                $resulta = ppmysql_query("SELECT id,title FROM {$Globals['pp_db_prefix']}photos WHERE id='$comid' ORDER BY date DESC LIMIT 1", $link);
                list($comphoid, $comphotitle) = mysql_fetch_row($resulta);

                $comment = convert_returns(convert_markups($comment));
                $comphotitle = "</td></tr><tr><td class=\"{$Style['tddetails']}\" align=\"left\" colspan=\"2\">{$Globals['pp_lang']['lcommenton']}: [ <a href=\"{$Globals['maindir']}/showphoto.php?photo=$comphoid\">$comphotitle</a> ]<br /><br />$comment</td>";
            }

            $buddies[] = "<td class=\"{$Style['tddetails']}\" align=\"left\" width=\"80%\"><a href=\"". construct_newppurl( "member.php", array('uid' => $bud['buddy'], 'username' => $bud['username']) ) ."\">{$bud['username']}</a> {$online}{$laston}</td><td class=\"{$Style['tddetails']}\" align=\"center\" width=\"20%\">$photitle</td>$comphotitle";
        }
    }
    else
    {
        list( $userid, $username ) = get_userinfo( "", $uid );

        // Grab the most recent comments
        $queryz = ppmysql_query("SELECT c.cat,c.photo,c.comment,p.bigimage,p.cat,p.storecat,p.userid,p.width,p.height
                                  FROM {$Globals['pp_db_prefix']}comments c
                                  LEFT JOIN {$Globals['pp_db_prefix']}photos p ON p.id=c.photo
                                  WHERE c.comment != '' AND c.userid=$uid ORDER BY c.date DESC LIMIT 10", $link);

        $numfound = 0;
        $compal = $usercoms = array();

        while ( list($usercoms['cat'], $usercoms['lcphoto'], $comcomment, $thumbimg, $thumbcat, $storecat, $thumbuid, $thumbw, $thumbh ) = mysql_fetch_row($queryz))
        {
            if ( $storecat != 0 )
            {
                $thumbcat = $storecat;
            }

            if ( $CatPerms['ugview'][$thumbcat] == 0 )
            {
                // Clean up html conversions
                $comcomment = un_htmlspecialchars($comcomment);

                // Strip out BB codes
                $comcomment = preg_replace("#\[.*/?\]#siU", "", $comcomment);

                $usercoms['cat'] = $thumbcat;
                $usercoms['comment'] = ( strlen($comcomment) > 100 ? substr($comcomment,0,100)."..." : $comcomment );
                $usercoms['thumblink'] = get_imagethumb( $thumbimg, $thumbcat, $thumbuid, 1, 0, 1, $thumbw, $thumbh );

                // Rotated? We need unrotated...
                if ( $Globals['rotatel'] > 0 || $Globals['rotatep'] > 0 )
                {
                    $usercoms['thumblink'] = str_replace("/thumbs/", "/mini/", $usercoms['thumblink']);
                }

                if ( $Globals['spider'] == "yes" )
                {
                    $usercoms['link'] = "{$Globals['maindir']}/showphoto.php/photo/{$usercoms['lcphoto']}/cat/{$usercoms['cat']}";
                }
                else
                {
                    $usercoms['link'] = "{$Globals['maindir']}/showphoto.php?photo={$usercoms['lcphoto']}&amp;cat={$usercoms['cat']}";
                }

                $compal['comment'][] = $usercoms['comment'];
                $compal['thumblink'][] = $usercoms['thumblink'];
                $compal['link'][] = $usercoms['link'];

                $numfound++;
            }
        }

        $comsfound = $numfound;

        // Grab the most recent comments
        $queryz = ppmysql_query("SELECT c.username,c.userid,c.cat,c.photo,c.comment,p.bigimage,p.cat,p.storecat,p.userid,p.width,p.height
                                  FROM {$Globals['pp_db_prefix']}comments c
                                  LEFT JOIN {$Globals['pp_db_prefix']}photos p ON p.id=c.photo
                                  WHERE c.comment != '' AND p.userid=$uid ORDER BY c.date DESC LIMIT 10", $link);

        $usercoms = $phopal = array();

        while ( list($usercoms['username'], $usercoms['userid'], $usercoms['cat'], $usercoms['lcphoto'], $comcomment, $thumbimg, $thumbcat, $storecat, $thumbuid, $thumbw, $thumbh ) = mysql_fetch_row($queryz))
        {
            if ( $storecat != 0 )
            {
                $thumbcat = $storecat;
            }

            if ( $CatPerms['ugview'][$thumbcat] == 0 )
            {
                // Clean up html conversions
                $comcomment = un_htmlspecialchars($comcomment);

                // Strip out BB codes
                $comcomment = preg_replace("#\[.*/?\]#siU", "", $comcomment);

                $usercoms['cat'] = $thumbcat;
                $usercoms['comment'] = ( strlen($comcomment) > 100 ? substr($comcomment,0,100)."..." : $comcomment );
                $usercoms['thumblink'] = get_imagethumb( $thumbimg, $thumbcat, $thumbuid, 1, 0, 1, $thumbw, $thumbh );

                // Rotated? We need unrotated...
                if ( $Globals['rotatel'] > 0 || $Globals['rotatep'] > 0 )
                {
                    $usercoms['thumblink'] = str_replace("/thumbs/", "/mini/", $usercoms['thumblink']);
                }

                if ( $Globals['spider'] == "yes" )
                {
                    $usercoms['link'] = "{$Globals['maindir']}/showphoto.php/photo/{$usercoms['lcphoto']}/cat/{$usercoms['cat']}";
                }
                else
                {
                    $usercoms['link'] = "{$Globals['maindir']}/showphoto.php?photo={$usercoms['lcphoto']}&amp;cat={$usercoms['cat']}";
                }

                $phopal['comment'][] = $usercoms['comment'];
                $phopal['thumblink'][] = $usercoms['thumblink'];
                $phopal['link'][] = $usercoms['link'];
                $phopal['username'][] = $usercoms['username'];
                $phopal['userid'][] = $usercoms['userid'];

                $numfound++;
            }
        }

        $phocfound = $numfound;
    }

    printheader( 0, $Globals['pp_lang']['memprofile'], 0, "yes", null, $uid );
    topmenu();

    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/profile.tmpl" );

    printfooter();
    exit;
}

//
// User wants to unsubscribe from notifications
//

if ( $ppaction == "unsubscribe" )
{
    $whichand = null;

    if ( $User['adminedit'] != 1 )
    {
        $whichand = "AND userid='{$User['userid']}'";
    }

    foreach($_POST as $id=>$setting)
    {
        $name = explode("-", $setting);
        $notifyid = intval($name[1]);

        if ( $notifyid > 0 ) {
            $whichvar = $name[0];

            if ( $whichvar == "delsub" || $whichvar == "delnot" )
            {
                $resulta = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}notify WHERE id=$notifyid $whichand", $link);
            }
        }
    }

    forward( "member.php", $Globals['pp_lang']['subupdated'] );
    exit;
}


if ( $ppaction == "forgot" && $Globals['vbversion'] == "photopost" )
{
    if ( $do == "process" )
    {
        $resultb = ppmysql_query("SELECT username,userid,joindate FROM {$Globals['pp_db_prefix']}users WHERE email='$inemail'", $link);
        $checkrows = mysql_num_rows($resultb);

        if ($checkrows > 0)
        {
            while( list( $dbuser, $dbuid, $joindate ) = mysql_fetch_row($resultb) ) {
                include("{$Globals['PP_PATH']}/languages/$pplang.php");

                $email_from = "From: {$Globals['adminemail']}";
                $letter = $Globals['pp_lang']['epassres'];
                $letter = stripslashes($letter);
                $subject = $Globals['pp_lang']['epasssub2'];

                mail( $inemail, $subject, $letter, $email_from );
            }

            forward( "index.php", $Globals['pp_lang']['checke'] );
            exit;
        }
        else
        {
            $message = "{$Globals['pp_lang']['noaddr']}";
        }
    }

    printheader( 0, $Globals['pp_lang']['memberpassadmin'] );
    topmenu();

    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/forgotpass.tmpl" );
    printfooter();
    exit;
}


if ( $ppaction == "chgpass" && $Globals['vbversion'] == "photopost" )
{
    if ( $gologin == 1 )
    {
        login( "{$Globals['maindir']}/member.php?ppaction=chgpass" );
        exit;
    }

    if ( $do == "process" )
    {
        $reason = null;

        if ( empty($oldpassword) )
        {
            $reason .= "<li>{$Globals['pp_lang']['blankpass']}";
            $stop = 1;
        }

        if ( empty($newpassword) )
        {
            $reason .= "<li>{$Globals['pp_lang']['blankpass2']}";
            $stop = 1;
        }

        if ( empty($cnewpassword) )
        {
            $reason .= "<li>{$Globals['pp_lang']['confirmblank']}";
            $stop = 1;
        }

        if ( $newpassword != $cnewpassword )
        {
            $reason .= "<li>{$Globals['pp_lang']['nopassmatch']}";
            $stop = 1;
        }

        if ( $newpassword )
        {
            $pwdstrlen = strlen($newpassword);
            if ( $pwdstrlen < 4 )
            {
                $reason .= "<li>{$Globals['pp_lang']['fourchars']}";
                $stop = 1;
            }
        }

        $resulta = ppmysql_query("SELECT password FROM {$Globals['pp_db_prefix']}users WHERE userid={$User['userid']} LIMIT 1", $link);
        list( $dbpwd ) = mysql_fetch_row($resulta);

        $oldpassword = md5($oldpassword);
        if ( $oldpassword != $dbpwd )
        {
            $reason .= "<li>{$Globals['pp_lang']['oldwrong']}";
            $stop = 1;
        }

        if ($stop == 1)
        {
            diewell($reason);
        }

        $newpassword = md5($newpassword);
        $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}users SET password='$newpassword' WHERE userid={$User['userid']}", $link);
        forward( "index.php", $Globals['pp_lang']['passchanged'] );
        exit;
    }

    printheader( 0, $Globals['pp_lang']['memberoassadmin'] );
    topmenu();

    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/changepass.tmpl" );
    printfooter();
    exit;
}

// Edit a user's profile (form)

if ( $ppaction == "edit" )
{
    if ( $gologin == 1 )
    {
        login( "{$Globals['maindir']}/member.php?ppaction=edit" );
        exit;
    }

    if ( $User['adminedit'] == 1 )
    {
        if ( $uid == 0 )
        {
            $uid = $User['userid'];
        }
    }
    else
     {
        $uid = $User['userid'];
    }

    $months = array($Globals['pp_lang']['month1'],$Globals['pp_lang']['month2'],$Globals['pp_lang']['month3'],$Globals['pp_lang']['month4'],
        $Globals['pp_lang']['month5'],$Globals['pp_lang']['month6'],$Globals['pp_lang']['month7'],$Globals['pp_lang']['month8'],
        $Globals['pp_lang']['month9'],$Globals['pp_lang']['month10'],$Globals['pp_lang']['month11'],$Globals['pp_lang']['month12']);

    $resulta = ppmysql_query("SELECT username,usergroupid,title,signature,mature,homepage,icq,aim,yahoo,joindate,posts,birthday,location,interests,occupation,bio,email,offset FROM {$Globals['pp_db_prefix']}users WHERE userid=$uid LIMIT 1", $link);
    list($username,$usergroupid,$utitle,$usig,$mature,$homepage,$icq,$aim,$yahoo,$joindate,$posts,$birthday,$location,$interests,$occupation,$bio,$email,$offset) = mysql_fetch_row($resulta);

    // get the users profile information
    list( $userid, $username, $email, $password, $temppass, $groups, $offset, $sessionid ) = get_userinfo( "", $uid );

    if ( !$userid )
    {
        diewell( $Globals['pp_lang']['nofind'] );
    }

    $birth = explode( "-", $birthday );
    $bmon = intval($birth[1]);
    $bday = intval($birth[2]);
    $byear = $birth[0];

    if ( $bmon != "" )
    {
        $bmonsel = "<option value=\"$bmon\">".$months[$bmon-1]."</option>";
    }
    else
    {
        $bmonsel = "<option value=\"-1\"></option>";
    }

    if ( $bday != "" )
    {
        $bdaysel = "<option value=\"$bday\">$bday</option>";
    }
    else
    {
        $bdaysel = "<option value=\"-1\"></option>";
    }

    if ( $byear == "" )
    {
        $byear = null;
    }

    if ( $byear == "0000" )
    {
        $byear = null;
    }

    list($jsec,$jmin,$jhour,$jmday,$jmon,$jyear,$jwday,$jyday,$jisdst) = localtime($joindate);
    $jmon++;
    $jyear=1900+$jyear;

    if ( $Globals['vbversion'] == "photopost" )
    {
        $resulta = ppmysql_query("SELECT groupname FROM {$Globals['pp_db_prefix']}usergroups WHERE groupid=$usergroupid", $link);
        list( $usergroup ) = mysql_fetch_row($resulta);
    }

    if ( $mature )
    {
        $maturesel = "<option selected=\"selected\" value=\"no\">{$Globals['pp_lang']['no']}</option><option value=\"yes\">{$Globals['pp_lang']['yes']}</option>";
    }
    else
    {
        $maturesel = "<option value=\"no\">{$Globals['pp_lang']['no']}</option><option value=\"yes\" selected=\"selected\">{$Globals['pp_lang']['yes']}</option>";
    }

    $julian = time();
    $cclock = formatpptime( $julian );
    $ppdate = formatppdate( $julian );
    $ttime = "$ppdate $cclock";

    printheader( 0, $Globals['pp_lang']['memprofile'] );
    topmenu();

    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/editprofile.tmpl" );
    printfooter();
    exit;
}

// Process a user's edit, forward to profile display

if ( $ppaction == "processedit" )
{
    if ( $gologin == 1 )
    {
        login( "{$Globals['maindir']}/member.php?ppaction=edit" );
        exit;
    }

    if ($User['adminedit'] == 0 || !is_numeric($uid) )
    {
        if ($uid != $User['userid'])
        {
            diewell( $Globals['pp_lang']['noeditperm'] );
        }
    }

    $testname = $_FILES['theimage']['name'][0];
    $realsize = $_FILES['theimage']['size'][0];

    if ( $realsize )
    {
        // We got something
        include "{$Globals['PP_PATH']}/image-inc.php";

        // Remove old avatar
        $oa = ppmysql_query("SELECT avatar FROM {$Globals['pp_db_prefix']}users WHERE userid=$uid LIMIT 1", $link );
        list ($oavatar) = mysql_fetch_row($oa);

        if ( $oavatar )
        {
            @unlink( "{$Globals['datafull']}avatars/$oavatar" );
        }

        // Process new one
        $realname = fixfilenames( $testname );
        $outfilename = "{$User['userid']}$realname";

        $filepath = "{$Globals['datafull']}avatars";
        $filedir = "$filepath/$outfilename";

        $infile = "{$Globals['datafull']}avatars/$realname";
        $outfile = "{$Globals['datafull']}avatars/$outfilename";
        handleupload($filepath, 0);

        $resize_worked = resize_jpeg($infile, $outfile, 120, 120);
        @unlink( $infile );

        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}users SET avatar='$outfilename' WHERE userid=$uid LIMIT 1", $link );
    }

    $email = $editemail;
    $emailconfirm = $editemailconfirm;
    $bio = fixstring( $editbio );
    $birthday="$edityear-$editmonth-$editday";
    $homepage = fixstring($edithomepage);
    $icq = fixstring( $editicq );
    $aim = fixstring( $editaim );
    $yahoo = fixstring( $edityahoo );
    $year = fixstring( $edityear );
    $hobbies = fixstring( $editinterests );
    $occupation = fixstring( $editoccupation );
    $location = fixstring( $editlocation );
    $editttitle = fixstring( $edittitle );
    $editsig = fixstring( $editsig );

    $maturec = ( $mature == "yes" ? 0 : 1 );

    if ( !$year )
    {
        $year = "0000";
    }

    if ( !$month )
    {
        $month = "0";
    }
    if ( !$day )
    {
        $day = "0";
    }

    $msg = $Globals['pp_lang']['profileupdated'];

    if ( $Globals['vbversion'] == "photopost" )
    {
        if ($email != $emailconfirm)
        {
            diewell($Globals['pp_lang']['noemailmatch']);
        }

        if ( !valid_email($email) )
        {
            diewell($Globals['pp_lang']['emailbad']);
        }

        if ($Globals['emailverify'] == "yes")
        {
            // Check to see if user changed email. Verify it if needed.
            $resulta = ppmysql_query("SELECT email,username FROM {$Globals['pp_db_prefix']}users WHERE userid=$uid LIMIT 1", $link);
            list( $emaildb, $dbuser ) = mysql_fetch_row($resulta);

            if ($email != $emaildb)
            {
                $genpass = gen_password();
                $newpass = md5($genpass);

                include("{$Globals['PP_PATH']}/languages/$pplang.php");
                $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}users SET password='$newpass' WHERE userid=$uid", $link);

                $email_from = "From: {$Globals['adminemail']}";
                $letter = $Globals['pp_lang']['enewemail'];
                $letter = stripslashes($letter);
                $subject = $Globals['pp_lang']['enewesub'];

                mail( $email, $subject, $letter, $email_from );
                $msg .= "<br />{$Globals['pp_lang']['checke']}";
            }
        }
    }

    // Write input data to db
    //$resulta = mysql_query("SELECT userid FROM {$pp_db_prefix}users WHERE userid=$uid LIMIT 1", $link);
    //list ( $checkid ) = mysql_fetch_row($resulta);

    //if ( $checkid )
    //{
        $resultb = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}users SET email='$email',homepage='$homepage',icq='$icq',aim='$aim',yahoo='$yahoo',birthday='$birthday',
                                    interests='$hobbies',occupation='$occupation',bio='$bio',location='$location',
                                    mature=$maturec,title='$editttitle',signature='$editsig',offset='$offset'
                                    WHERE userid=$uid", $link);
    //}
    //else
    //{
    //    $resultb = ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}users (userid,email,title,signature,homepage,icq,aim,yahoo,birthday,interests,occupation,bio,location,mature,title,signature,offset)
    //                                VALUES ($uid, '$email', '$edittitle', '$editsig', '$homepage', '$icq', '$aim', '$yahoo', '$birthday',
    //                                '$hobbies', '$occupation', '$bio', '$location', $maturec, '$editttitle', '$editsig', '$offset')", $link);
    //}

    forward( "member.php?uid=$uid", $msg );
    exit;
}

diewell( $Globals['pp_lang']['errorscript'] );

?>
