<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

if ( isset($argv[0]) && is_numeric($argv[0]) )
{
    header("Location: {$Globals['maindir']}/showphoto.php?photo={$argv[0]}");
    exit;
}

define( 'THIS_SCRIPT', "ppindex" );
require "pp-inc.php";

$PATH_INFO = findenv("PATH_INFO");
if ( isset($PATH_INFO) && $Globals['spider'] != "none" )
{
    $id = 0;
    $test = explode('/', substr($PATH_INFO,1));

    for( $i = 0; $i < count($test); $i++ )
    {
        if( $i % 2 == 0 )
        {
            if ( $Globals['spider'] == "seo" )
            {
                if ( $test[$i] == "cat" )
                {
                    // Do a 301 search engine friendly forward
                    $id = (int)$test[$i+1];
                }
            }
            else
            {
                // Using "spider" URLs
                $_REQUEST[$test[$i]] = $test[$i+1];
            }
        }
    }

    if ( $Globals['spider'] == "seo" && strstr($PATH_INFO, "?") )
    {
        // Was "normal" URLs, but want an SEO, so do a 301 search engine friendly forward
        // http://www.website.com/index.php?cat=504
        $id = (int)$_GET['cat'];
    }

    if ( $id > 0 )
    {
        header ('HTTP/1.1 301 Moved Permanently');
        header ('Location: '. $location);
        header ('Location: '. construct_newppurl( "index.php", array('cat' => $id) ) );
        exit;
    }

}

if ( file_exists("{$Globals['maindir']}/install.php") || file_exists("{$Globals['maindir']}/upgrade.php") )
{
    diewell( "For security reasons, please remove the install.php and upgrade.php scripts from the PhotoPost directory before proceeding." );
}

typecast($_REQUEST, array('page' => INT, 'cat' => INT));
typecast($_COOKIE, array('ppcollapse' => STRING));

// Init variables
if ( empty($page) ) $page = 1;

authenticate();

if ( $Globals['ppboards'] == "closed" && $User['adminedit'] != 1 )
{
    diewell( $Globals['closedmsg'] );
}

$tablehead = $Globals['seoindex'];

if ( $cat > 0 )
{
    if ($CatPerms['ugview'][$cat] == 1 )
    {
        diewell( $Globals['pp_lang']['noview'] );
    }

    if ( trim($CatPerms['catpass'][$cat]) && $User['adminedit'] != 1 )
    {
        if ( !isset($catp) ) $catp = null;

        if ( $catp != $CatPerms['catpass'][$cat] )
        {
            get_password( $cat );
            exit;
        }
    }

    $ctitleq = ppmysql_query("SELECT id,theme,sortorder,frames,intro,introtitle,introcopy FROM {$Globals['pp_db_prefix']}categories WHERE id=$cat", $link);
    $catinfo = mysql_fetch_array($ctitleq);

    if ( !preg_match("/([\<])([^\>]{1,})*([\>])/i", $catinfo['introtitle']) ) {
        $catinfo['introtitle'] = preg_replace("/(\r\n|\r|\n)/i","<br />", $catinfo['introtitle']);
    }

    if ( !preg_match("/([\<])([^\>]{1,})*([\>])/i", $catinfo['introcopy']) ) {
        $catinfo['introcopy'] = preg_replace("/(\r\n|\r|\n)/i","<br />", $catinfo['introcopy']);
    }

    // Nonstandard theme
    if ( $catinfo['theme'] )
    {
        $Globals['theme'] = $catinfo['theme'];
        if ( is_dir( "{$Globals['PP_PATH']}/stylesheets/{$Globals['theme']}" ) )
        {
            $Globals['idir'] = "{$Globals['maindir']}/stylesheets/{$Globals['theme']}";
        }
    }

    // Non standard frames
    if ( !empty($catinfo['frames']) )
    {
        unset( $Globals['thumbstd'] );
        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/{$catinfo['frames']}.tmpl" );
    }

    if ( $User['userid'] > 0 && $Globals['displaynew'] == "yes" )
    {
        ppmysql_query("REPLACE INTO {$Globals['pp_db_prefix']}laston VALUES($cat,{$User['userid']},$lasttimeon)", $link);
    }

    $tablehead = $CatPerms['catname'][$cat];
    childsub($cat);
    $childnav = "<span class=\"{$Style['small']}\"><a href=\"{$Globals['maindir']}/\">{$Globals['pp_lang']['home']}</a> $childnav</span>";
    $searchcat = $cat;
}
else
{
    if ( $User['username'] && $User['username'] != "Unregistered" )
    {
        $childnav = "{$Globals['pp_lang']['welcomeuser']} {$User['username']}";
    }
    else
    {
        $childnav = "{$Globals['pp_lang']['welcome']} {$Globals['galleryname']}!";
    }
    $searchcat = "all";
}

topmenu();
printheader( $cat, $tablehead );

// Let's go!
$count = $catdepth = $cptotal = $posttotal = $totalviews = $diskspace = 0;
$catrows = $nextbutton = $prevbutton = null;
catrow($cat);

if ( $posternav )
{
    if ( $page < $pages )
    {
        $nextpage = $page + 1;
        $nextbutton = "&nbsp;<a href=\"" . construct_newppurl( "index.php", array('cat' => $cat, 'page' => $nextpage) ) ."\">&raquo;</a>";
    }
    if ( $page > 1 )
    {
        $prevpage = $page - 1;
        $prevbutton = "<a href=\"" . construct_newppurl( "index.php", array('cat' => $cat, 'page' => $prevpage) ) ."\">&laquo;</a>&nbsp;";
    }

    $posternav = "$prevbutton$posternav$nextbutton";
}

if ( !$updatecache )
{
    // We're reading from the cache
    $cache = unserialize( $cacheq['statscache'] );
}
else
{
    if ( $Globals['statspal'] == "yes" )
    {
        get_statscache();
    }

    if ( $Globals['topposterspal'] == "yes" )
    {
        get_posterscache();
    }

    if ( $Globals['ratingspal'] == "yes" )
    {
        get_ratingcache();
    }

    if ( $Globals['undercat'] == "yes" )
    {
        // Lets get the Recent Comments
        $numcompal = ($Globals['numcompal'] + 5);
        $queryz = ppmysql_query("SELECT c.username,c.userid,c.cat,c.photo,c.comment,p.title,p.bigimage,p.cat,p.storecat,p.userid,p.width,p.height
                                  FROM {$Globals['pp_db_prefix']}categories a
		                  LEFT JOIN {$Globals['pp_db_prefix']}comments c ON a.id=c.cat
                                  LEFT JOIN {$Globals['pp_db_prefix']}photos p ON p.id=c.photo
                                  WHERE comment != '' AND a.password = '' ORDER BY c.date DESC LIMIT $numcompal", $link);

        $numfound = 0;

        while ( list($cache['comments']['username'][$numfound], $cache['comments']['userid'][$numfound], $cache['comments']['cat'][$numfound], $cache['comments']['lcphoto'][$numfound], $comcomment, $title, $thumbimg, $thumbcat, $storecat, $thumbuid, $thumbw, $thumbh ) = mysql_fetch_row($queryz))
        {
            if ( $storecat != 0 )
            {
                $thumbcat = $storecat;
            }

            // Clean up html conversions
            $comcomment = un_htmlspecialchars($comcomment);

            // Strip out BB codes
            $comcomment = preg_replace("#\[.*/?\]#siU", "", $comcomment);

            $cache['comments']['cat'][$numfound] = $thumbcat;
            $cache['comments']['comment'][$numfound] = ( strlen($comcomment) > 100 ? substr($comcomment,0,100)."..." : $comcomment );
            $cache['comments']['thumblink'][$numfound] = get_imagethumb( $thumbimg, $thumbcat, $thumbuid, 1, 0, 1, $thumbw, $thumbh );

            // Rotated? We need unrotated...
            if ( $Globals['rotatel'] > 0 || $Globals['rotatep'] > 0 )
            {
                $cache['comments']['thumblink'][$numfound] = str_replace("/thumbs/", "/mini/", $cache['comments']['thumblink'][$numfound]);
            }

            $cache['comments']['link'][$numfound] = construct_newppurl( "showphoto.php", array('photo' => $cache['comments']['lcphoto'][$numfound], 'cat' => $cache['comments']['cat'][$numfound], 'title' => $title) );

            if ( $numfound == $Globals['numcompal'] )
            {
                break;
            }

            $numfound++;
        }
    }

    if ( $Globals['cachetimeout'] > 0 )
    {
        // Let's update the cache
        $slashcache = addslashes(serialize($cache));

        // Next update in settings.cachetimeout minutes
        $nextupdate = $lasttimeon + ($Globals['cachetimeout'] * 60);

        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}cache SET timestamp=$nextupdate,statscache='$slashcache' WHERE id=1", $link);
    }
}

if ( $Globals['undercat'] == "yes" )
{
    // Process the Recent Comments array (if needed)
    $numfound = 0;
    $compal = array();

    for ( $x = 0; $x < count($cache['comments']['comment']); $x++ )
    {
        $thumbcat = $cache['comments']['cat'][$x];

        if ( $CatPerms['ugview'][$thumbcat] == 0 )
        {
            $compal[$numfound]['comment'] = $cache['comments']['comment'][$x];
            $compal[$numfound]['thumblink'] = $cache['comments']['thumblink'][$x];
            $compal[$numfound]['link'] = $cache['comments']['link'][$x];
            $compal[$numfound]['username'] = $cache['comments']['username'][$x];
            $compal[$numfound]['userid'] = $cache['comments']['userid'][$x];
            $compal[$numfound]['memberlink'] = "<a href=\"". construct_newppurl( "member.php", array('uid' => $cache['comments']['userid'][$x], 'username' => $cache['comments']['username'][$x]) ) ."\">{$cache['comments']['username'][$x]}</a>";

            $numfound++;

            if ( $numfound == $Globals['numcompal'] ) {
                break;
            }
        }
    }
}

$whoonline = null;
if ( $Globals['onlinepal'] == "yes" )
{
    // Lets get Who is Online
    $whoonline = get_whoonline();
}

//
// Generate the page
//

if ( !$cat )
{
    $cat = "all";
}

$showsearch = true;
if ( $cat == 500 || ($Globals['searchreg'] == "yes" && $User['userid'] == 0) )
{
    $showsearch = false;
}

include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );

if ( $Globals['sidebar'] == "left" && $Globals['sidebar_index'] == "yes" )
{
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/sidebar_leftopen.tmpl" );
}

if ( $Globals['sidebar'] == "right" && $Globals['sidebar_index'] == "yes" )
{
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/sidebar_rightopen.tmpl" );
}

if ( $Globals['news'] == "yes" && $page == 1 )
{
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/announce.tmpl" );
}

if ( $Globals['mostrecent'] == "yes" && $Globals['recentdefault'] == "no" && $page == 1 )
{
    display_gallery("latest");
}

include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/indexhead.tmpl" );

if ( $catinfo['intro'] == "yes" && $page == 1 )
{
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/catintro.tmpl" );
}

$whichgallery = ( $Globals['pplayout'] == "no" ? "categall" : "categories" );
include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/$whichgallery.tmpl" );

if ( $Globals['mostrecent'] == "yes" && $Globals['recentdefault'] == "yes" && $page == 1 )
{
    display_gallery("latest");
}

if ( $Globals['dispopular'] == "yes" && $page == 1 )
{
    display_gallery("most_views");
}

if ( $Globals['disrandom'] == "yes" && $page == 1 )
{
    display_gallery("random");
}

if ( $Globals['undercat'] == "yes" )
{
    if ($Globals['sidebar_index'] == "no" || $Globals['sidebar'] == "off" )
    {
        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/undercat.tmpl" );
    }
    else
    {
        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/undercat-sidebar.tmpl" );
    }
}
elseif ( $Globals['statspal'] == "yes" )
{
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/indexstats.tmpl" );
}

if ( $Globals['sidebar'] == "left" && $Globals['sidebar_index'] == "yes" )
{
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/sidebar_leftclose.tmpl" );
}

if ( $Globals['sidebar'] == "right" && $Globals['sidebar_index'] == "yes" )
{
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/sidebar_rightclose.tmpl" );
}

printfooter();

?>
