<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

function handleupload( $location = "data", $i = 0, $filename = "" )
{
    global $Globals, $_FILES, $User, $category, $wasuploaded, $upuserid;

    $wasuploaded = "no";
    $realname = $_FILES['theimage']['name'][$i];

    if ( $realname != "none" && $realname != "" )
    {
        $tmpname = $_FILES['theimage']['tmp_name'][$i];

        if (is_uploaded_file($tmpname) )
        {
            // Hard-coded restricted extensions
            if ( stristr($realname, ".php") || stristr($realname, ".cgi") || stristr($realname, ".pl") )
            {
                @unlink($tmpname);
                diewell( "Illegal file type [$tmpname]" );
            }

            $realname = fixfilenames( $realname );

            if ( $location != "data" )
            {
                $dst_file = "$location/{$realname}";
            }
            else
            {
                if ( empty($filename) )
                {
                    $dst_file = "{$Globals['origfull']}$category/$realname";
                }
                else
                {
                    $dst_file = "{$Globals['origfull']}$category/$filename";
                }
            }

            // Only move if an acceptible type
            if ( is_image($realname) || is_multimedia($realname) || ($Globals['allowzip'] == "yes" && strtolower(substr($realname,strlen($realname) - 4,4)) == ".zip") )
            {
                $check = move_uploaded_file($tmpname, $dst_file);

                if ( !$check )
                {
                    @unlink($tmpname);
                    diewell( "Unable to move file [$tmpname] -> [$dst_file]" );
                }

                @chmod ($dst_file, 0666);
            }
            else
            {
                @unlink($tmpname);
            }
        }
        else
        {
            diewell( "$realname: {$Globals['pp_lang']['nofile']}" );
        }
    }

    $wasuploaded = "yes";

    return( $dst_file );
}

function fs_exec( $syscmd )
{
    global $return;

    // set this to NT if the default doesnt work for you and you are running on an NT server
    $OS = "any";

    if ( $OS == "any" )
    {
        exec( $syscmd, $return, $retval );
    }
    else
    {
        exec( "cmd.exe /c $syscmd", $return, $retval );
    }

    return( $retval );
}


function resize_jpeg( $image_file_path, $new_image_file_path, $max_width=480, $max_height=1600 )
{
    global $Globals;

    $return_val = 1;

    $image_stats = getimagesize( $image_file_path );
    $FullImage_width = $image_stats[0];
    $FullImage_height = $image_stats[1];
    $img_type = $image_stats[2];

    switch( $img_type )
    {
        case 1: $src_img = ImageCreateFromGif($image_file_path); break;
        case 2: $src_img = ImageCreateFromJpeg($image_file_path); break;
        case 3: $src_img = ImageCreateFromPng($image_file_path); break;
        default:
        {
            unlink( $image_file_path );
            diewell("($img_type): {$Globals['pp_lang']['imgnotsup']}");
        }
    }

    if ( !$src_img )
    {
        unlink( $image_file_path );
        diewell("{$Globals['pp_lang']['createrror']}: [$image_file_path]");
    }

    $ratio =  ( $FullImage_width > $max_width ) ? (real)($max_width / $FullImage_width) : 1 ;
    $new_width = ((int)($FullImage_width * $ratio));    //full-size width
    $new_height = ((int)($FullImage_height * $ratio));    //full-size height

    $ratio =  ( $new_height > $max_height ) ? (real)($max_height / $new_height) : 1 ;
    $new_width = ((int)($new_width * $ratio));    //mid-size width
    $new_height = ((int)($new_height * $ratio));    //mid-size height

    if ( $new_width == $FullImage_width && $new_height == $FullImage_height )
    {
        copy ( $image_file_path, $new_image_file_path );
        @chmod ($new_image_file_path, 0666);
    }

    if ( $Globals['usegd'] == 2 )
    {
        $full_id = ImageCreate( $new_width, $new_height );
        ImageCopyResized( $full_id, $src_img, 0,0, 0,0, $new_width, $new_height, $FullImage_width, $FullImage_height );
    }
    else
    {
        $full_id = ImageCreateTrueColor( $new_width, $new_height );
        ImageCopyResampled( $full_id, $src_img, 0,0, 0,0, $new_width, $new_height, $FullImage_width, $FullImage_height );
    }

    switch( $img_type )
    {
        case 1: $return_val = ImageGIF( $full_id, $new_image_file_path ); break;
        case 2: $return_val = ImageJPEG( $full_id, $new_image_file_path, $Globals['imgquality'] ); break;
        case 3: $return_val = ImagePNG( $full_id, $new_image_file_path ); break;
        default: diewell( $Globals['pp_lang']['imgnotsup'] );
    }

    ImageDestroy( $full_id );

    return ($return_val) ? TRUE : FALSE ;
}

function gdwatermark($srcfilename, $watermark)
{
    global $Globals, $CatPerms;

    $imageInfo = getimagesize($srcfilename);
    $width = $imageInfo[0];
    $height = $imageInfo[1];

    $logoinfo = getimagesize($watermark);
    $logowidth = $logoinfo[0];
    $logoheight = $logoinfo[1];

    if( $Globals['gravity'] == "Center" )
    {
        $horizmargin = ( $width / 2 ) - ( $logowidth / 2 );
        $vertmargin = ( $height / 2 ) - ( $logoheight / 2 );
    }
    elseif( $Globals['gravity'] == "NorthWest" )
    {
        // top left
        $horizmargin = 0;
        $vertmargin = 0;
    }
    elseif( $Globals['gravity'] == "NorthEast" )
    {
        // top right
        $horizmargin = $width - $logowidth;
        $vertmargin = 0;
    }
    elseif( $Globals['gravity'] == "SouthWest" )
    {
        // bottom left
        $horizmargin = 0;
        $vertmargin = $height - $logoheight;
    }
    elseif( $Globals['gravity'] == "North" )
    {
        // top middle
        $horizmargin = ( ( $width - $logowidth ) / 2 );
        $vertmargin = 0;
    }
    elseif( $Globals['gravity'] == "East" )
    {
        // middle right
        $horizmargin = $width - $logowidth;
        $vertmargin = ( $height / 2 ) - ( $logoheight / 2 );
    }
    elseif( $Globals['gravity'] == "South" )
    {
        // bottom middle
        $horizmargin = ( ( $width - $logowidth ) / 2 );
        $vertmargin = $height - $logoheight;
    }
    elseif( $Globals['gravity'] == "West" )
    {
        // middle left
        $horizmargin = 0;
        $vertmargin = ( $height / 2 ) - ( $logoheight / 2 );
    }
    else
    {
        // bottom right
        $horizmargin = $width - $logowidth;
        $vertmargin = $height - $logoheight;
    }

    $photoImage = ImageCreateFromJPEG($srcfilename);
    ImageAlphaBlending($photoImage, true);

    $logoImage = ImageCreateFromPNG($watermark);
    $logoW = ImageSX($logoImage);
    $logoH = ImageSY($logoImage);

    ImageCopy($photoImage, $logoImage, $horizmargin, $vertmargin, 0, 0, $logoW, $logoH);
    ImageJPEG($photoImage, $srcfilename, 90);

    ImageDestroy($photoImage);
    ImageDestroy($logoImage);
}


function create_thumb( $realname, $filepath, $thecat, $thevideo="" )
{
    global $Globals, $User, $imagewidth, $imageheight, $thumbnail, $resizeorig, $CatPerms, $upuserid;

    //
    // NEW RESIZE CODE
    //
    $previewwidth = $Globals['previewwidth'];

    if ( $filepath == "default" )
    {
        $filepath = "{$Globals['idir']}/video.gif";
    }

    $image_stats = getimagesize( $filepath );
    $imagewidth = $image_stats[0];
    $imageheight = $image_stats[1];
    $img_type = $image_stats[2];

    // Create thumbnails
    $filenoext = get_filename( $realname );
    if ( $thevideo == "" )
    {
        $thumbnail = "$realname";
        $outthumb = "{$Globals['datafull']}$thecat/thumbs/$thumbnail";
    }
    elseif ( $thevideo == "rebuildthumbnail" )
    {
        $outthumb = "{$Globals['datafull']}$thecat/thumbs/$realname";
    }
    else
    {
        $filenoext = get_filename( $thevideo );
        $thumbnail = "{$filenoext}.jpg";
        $outthumb = "{$Globals['datafull']}$thecat/thumbs/$thumbnail";
    }

    // Lets make a thumbnail
    if ( file_exists( $outthumb ) )
    {
        @unlink( $outthumb );
    }

    // Image is smaller than out preview, so leave it alone
    //if ( $imagewidth < $previewwidth && $imageheight < $previewwidth )
    //{
    //    copy ( $filepath, $outthumb );
    //    return;
    //}

    if ( $Globals['uniform'] == "no" )
    {
        if ( $imageheight < $imagewidth )
        {
            $scaleFactor = $imagewidth / $previewwidth;
            $newheight = round( $imageheight / $scaleFactor );
            $newwidth = $previewwidth;
        }
        else
        {
            $scaleFactor = $imageheight / $previewwidth;
            $newwidth = round( $imagewidth / $scaleFactor );
            $newheight = $previewwidth;
        }
    }
    else
    {
        $newwidth = $Globals['uniwidth'];
        $newheight = $Globals['uniheight'];
    }

    if ( $Globals['usegd'] != 0 )
    {
        $resize_worked = resize_jpeg($filepath, $outthumb, $newwidth, $newheight);
    }
    else
    {
        copy ( $filepath, $outthumb );
        @chmod ($outthumb, 0666);

        // watermark thumbnail before resizing
        // uncomment if you want your thumbnails to have watermarks
        //if ( $CatPerms['uganno']{$thecat} != 1 && $Globals['annotate'] == "yes") {
        //    // stamp the image
        //    watermark( $outthumb, $thecat );
        //}

        $minih = $miniw = 0;
        // if image is taller than wider, then portrait

        if ( $imageheight < $imagewidth )
        {
            $rotaten = ( $Globals['rotatel'] > 0 ? "-rotate {$Globals['rotatel']}" : "" );

            if ( $newwidth > 50 && $newheight > 50 )
            {
                $unsharpn = "-unsharp 10";
            }
            else {
                $unsharpn = null;
            }

            $minih = $Globals['minis'];
            $miniw = $Globals['minil'];
        }
        else
        {
            $rotaten = ( $Globals['rotatep'] > 0 ? "-rotate {$Globals['rotatep']}" : "" );

            if ( $newwidth > 50 && $newheight > 50 )
            {
                $unsharpn = "-unsharp 10";
            }
            else
            {
                $unsharpn = null;
            }

            $minih = $Globals['minil'];
            $miniw = $Globals['minis'];
        }

        if( !stristr(PHP_OS, "win") )
        {
            $shellthumb = escapeshellarg($outthumb);
        }
        else
        {
            $shellthumb = $outthumb;
        }

        // Uniform thumbnails
        if ( $Globals['uniform'] == "yes" && $Globals['uniwidth'] && $Globals['uniheight'] )
        {
            $syscmd = "\"{$Globals['mogrify_command']}\" -thumbnail {$newwidth}x{$newheight}^ -quality {$Globals['imgquality']} -gravity center -extent {$newwidth}x{$newheight} $rotaten $unsharpn $shellthumb";
            //$syscmd = "\"{$Globals['mogrify_command']}\" -strip -resize \"{$newwidth}x\" -resize \"x{$newheight}<\" -gravity center -crop {$newwidth}x{$newheight}+0+0 -quality {$Globals['imgquality']} $rotaten $unsharpn $shellthumb";
            $newwidth = $Globals['uniwidth'];
            $newheight = $Globals['uniheight'];
        }
        else
        {
            $syscmd = "\"{$Globals['mogrify_command']}\" +profile \"*\" -size {$newwidth}x{$newheight} -quality {$Globals['imgquality']} -geometry {$newwidth}x{$newheight} $rotaten $unsharpn $shellthumb";
        }

        $retval = fs_exec($syscmd);

        // create the mini
        if ( $Globals['rotatel'] > 0 || $Globals['rotatep'] > 0 )
        {
            $minithumb = str_replace("/thumbs/","/mini/",$outthumb);
            @unlink($minithumb);
            copy ( $filepath, $minithumb );
            $syscmd = "\"{$Globals['mogrify_command']}\" -strip -resize \"{$miniw}x\" -resize \"x{$minih}<\" -gravity center -crop {$miniw}x{$minih}+0+0 -quality {$Globals['imgquality']} $minithumb";
            $retval = fs_exec($syscmd);
        }

        $checkfile = "{$Globals['datafull']}$thecat/thumbs/{$filenoext}.mgk";
        if ( $retval != 0 || file_exists($checkfile) )
        {
            if ( !file_exists($checkfile) )
            {
                @unlink( $outthumb );
                @unlink( $minithumb );
                @unlink( $filepath );

                diewell("Error creating thumbnail! Error code: $retval<br /><br />Command:<br /><br />$syscmd" );
            }

            @unlink($outthumb);
            copy( $checkfile, $outthumb );
            @unlink($checkfile);

            // check mini
            if ( $rotaten > 0 )
            {
                @unlink($minithumb);
                $checkfile = "{$Globals['datafull']}$thecat/mini/{$filenoext}.mgk";
                @copy( $checkfile, $minithumb );
                @unlink($checkfile);
            }
        }
    }

    return;
}

function watermark( $filepath, $cat=500, $catwater )
{
    global $Globals, $CatPerms;

    // GD1 cannot use watermarks; just return
    if ( $Globals['usegd'] == 2 )
    {
        return;
    }

    $agravity = $Globals['gravity'];

    if ( $catwater )
    {
        $water_image = $catwater;
    }
    else
    {
        $water_image = $Globals['watermark'];
    }

    // need to execute this command after images:
    // composite -compose over -gravity southeast eblogo.jpg jess.jpg jesslogo.jpg

    if ( $Globals['usegd'] != 0 )
    {
        if ( strstr(strtolower($filepath),".jpg") )
        {
            $retval = gdwatermark( $filepath, $water_image );
        }
    }
    else
    {
        $composite_cmd = str_replace( "mogrify", "composite", $Globals['mogrify_command'] );
        if( !stristr(PHP_OS, "win") )
        {
            $shellpath = escapeshellarg($filepath);
        }
        else
        {
            $shellpath = $filepath;
        }

        $stampcmd = "\"$composite_cmd\" -compose over -gravity $agravity $water_image $shellpath $shellpath";
        $retval = fs_exec($stampcmd);

        if ( $retval != 0 )
        {
            diewell("Error creating watermarked original! Error code: $retval<br /><br />Command: $stampcmd");
        }
    }

    return;
}

function readexifinfo($file, $origfile)
{
    global $Globals, $return;

    $return = array();
    $system_cmd = "{$Globals['jhead_command']} -exonly $file";
    $status = fs_exec($system_cmd);

    $exifinfo = array();

    if ( $status == 0 )
    {
        while (list($key,$value) = each ($return))
        {
            $explodeReturn = explode(':', $value, 2);
            if ( trim($explodeReturn[0]) == "File name" )
            {
                $explodeReturn[1] = $origfile;
            }

            if ($exifinfo[trim($explodeReturn[0])])
            {
                $exifinfo[trim($explodeReturn[0])] .= "<br />" . trim($explodeReturn[1]);
            }
            else
            {
                $exifinfo[trim($explodeReturn[0])] = trim($explodeReturn[1]);
            }
        }
    }

    return ($exifinfo);
}

function gd_rotate_jpeg( $source, $angle )
{
    global $Globals;

    $image_stats = getimagesize($source);
    $tot_x = $image_stats[0];
    $tot_y = $image_stats[1];
    $img_type = $image_stats[2];

    switch ($img_type)
    {
        case 1: $file = ImageCreateFromGif($source); break;
        case 2: $file = ImageCreateFromJpeg($source); break;
        case 3: $file = ImageCreateFromPng($source); break;
        default: diewell( "Sorry, this image type ($img_type) is not supported." );
    }

    switch ($angle)
    {
        case 90: // flip dimensions 90
            if ($Globals['usegd'] == 1) $result = ImageCreateTrueColor($tot_y, $tot_x);
            else $result = ImageCreate($tot_y, $tot_x);

            for($src_x = 0; $src_x < $tot_x; $src_x++)
            {
                for( $src_y = 0; $src_y < $tot_y; $src_y++ )
                {
                    $dst_x = $tot_y - ($src_y + 1);
                    $dst_y = $src_x;
                    ImageCopy($result, $file, $dst_x, $dst_y, $src_x, $src_y, 1, 1);
                }
            }
            break;

        case 180: // flip dimensions 180
            if ($Globals['usegd'] == 1) $result = ImageCreateTrueColor($tot_x, $tot_y);
            else $result = ImageCreate($tot_x, $tot_y);

            for( $src_x = 0; $src_x < $tot_x; $src_x++ )
            {
                for($src_y = 0; $src_y < $tot_y; $src_y++)
                {
                    $dst_x = $tot_x - ($src_x + 1);
                    $dst_y = $tot_y - ($src_y + 1);
                    ImageCopy($result, $file, $dst_x, $dst_y, $src_x, $src_y, 1, 1);
                }
            }
            break;

        case 270: // flip dimensions 270
            if ( $Globals['usegd'] == 1 ) $result = ImageCreateTrueColor($tot_y, $tot_x);
            else $result = ImageCreate($tot_y, $tot_x);

            for( $src_x = 0; $src_x < $tot_x; $src_x++ )
            {
                for($src_y = 0; $src_y < $tot_y; $src_y++)
                {
                    $dst_x = $src_y;
                    $dst_y = $tot_x - ($src_x + 1);
                    ImageCopy($result, $file, $dst_x, $dst_y, $src_x, $src_y, 1, 1);
                }
            }
            break;

        case 'flop': // mirror image vertically
            if ($Globals['usegd'] == 1) $result = ImageCreateTrueColor($tot_x, $tot_y);
            else $result = ImageCreate($tot_x, $tot_y);

            for($src_x = 0; $src_x < $tot_x; $src_x++)
            {
                for($src_y = 0; $src_y < $tot_y; $src_y++)
                {
                    $dst_x = $tot_x - ($src_x + 1);
                    $dst_y = $src_y;
                    ImageCopy($result, $file, $dst_x, $dst_y, $src_x, $src_y, 1, 1);
                }
            }
            break;

        case 'flop270': // mirror image vertically
            if ($Globals['usegd'] == 1) $result = ImageCreateTrueColor($tot_x, $tot_y);
            else $result = ImageCreate($tot_x, $tot_y);

            for($src_x = 0; $src_x < $tot_x; $src_x++)
            {
                for($src_y = 0; $src_y < $tot_y; $src_y++)
                {
                    $dst_x = $tot_x - ($src_x + 1);
                    $dst_y = $src_y;
                    ImageCopy($result, $file, $dst_x, $dst_y, $src_x, $src_y, 1, 1);
                }
            }

            for( $src_x = 0; $src_x < $tot_x; $src_x++ )
            {
                for($src_y = 0; $src_y < $tot_y; $src_y++)
                {
                    $dst_x = $src_y;
                    $dst_y = $tot_x - ($src_x + 1);
                    ImageCopy($result, $file, $dst_x, $dst_y, $src_x, $src_y, 1, 1);
                }
            }
            break;

        case 'flip':
            if ($Globals['usegd'] == 1) $result = ImageCreateTrueColor($tot_x, $tot_y);
            else $result = ImageCreate($tot_x, $tot_y);

            for( $src_x = 0; $src_x < $tot_x; $src_x++ )
            {
                for( $src_y = 0; $src_y < $tot_y; $src_y++ )
                {
                    $dst_x = $src_x;
                    $dst_y = $tot_y - ($src_y + 1);
                    ImageCopy($result, $file, $dst_x, $dst_y, $src_x, $src_y, 1, 1);
                }
            }
            break;

        case 'flip270':
            if ($Globals['usegd'] == 1) $result = ImageCreateTrueColor($tot_x, $tot_y);
            else $result = ImageCreate($tot_x, $tot_y);

            // 270
            for( $src_x = 0; $src_x < $tot_x; $src_x++ )
            {
                for($src_y = 0; $src_y < $tot_y; $src_y++)
                {
                    $dst_x = $src_y;
                    $dst_y = $tot_x - ($src_x + 1);
                    ImageCopy($result, $file, $dst_x, $dst_y, $src_x, $src_y, 1, 1);
                }
            }

            // flip
            for( $src_x = 0; $src_x < $tot_x; $src_x++ )
            {
                for( $src_y = 0; $src_y < $tot_y; $src_y++ )
                {
                    $dst_x = $src_x;
                    $dst_y = $tot_y - ($src_y + 1);
                    ImageCopy($result, $file, $dst_x, $dst_y, $src_x, $src_y, 1, 1);
                }
            }
            break;

        default:
    }

    // actual output
    switch ($img_type)
    {
        case 1: ImageGIF($result, $source);    break;
        case 2: ImageJPEG($result, $source, 80); break;
        case 3: ImagePNG($result, $source);    break;
        default: diewell( "Unsupported filetype selected" );
    }

    ImageDestroy($result);
}

function process_image( $realname, $filepath, $thecat, $thevideo=0, $replace=0 )
{
    global $Globals, $User, $Style, $link, $db_link, $CatPerms;
    global $usergroup, $title, $desc, $keywords, $optone, $opttwo;
    global $extra1, $extra2, $extra3, $extra4, $extra5, $extra6;
    global $keywords, $notify, $rating, $comments, $resizeorig, $allowprint, $upuserid;
    global $mature;

    $julian = time();

    $filenoext = get_filename( $realname );
    $theext    = get_ext( $realname );
    $outfilename = "$realname";

    if ( $thevideo == 0 )
    {
        $image_stats = getimagesize( $filepath );
        $imagewidth = $image_stats[0];
        $imageheight = $image_stats[1];

        $resizeorig = 0;
        $maxwidth = $Globals['maxwidth'];
        $maxheight = $Globals['maxheight'];

        // Too big?
        if ( $imagewidth > $maxwidth )
        {
            if ( $Globals['resizeorig'] == "yes" )
            {
                $resizeorig = 1;
            }
            else
            {
                @unlink($realname);
                diewell( $Globals['pp_lang']['toowide'] );
            }
        }

        if ( $imageheight > $maxheight )
        {
            if ( $Globals['resizeorig'] == "yes")
            {
                $resizeorig = 1;
            }
            else
            {
                @unlink($realname);
                diewell( $Globals['pp_lang']['tootall'] );
            }
        }

        // Too small?
        if ( ($Globals['minwidth'] > 0 && $imagewidth < $Globals['minwidth']) || ($Globals['minheight'] > 0 && $imageheight < $Globals['minheight']) )
        {
            @unlink($realname);
            diewell( $Globals['pp_lang']['toosmall'] );
        }

        // before we do any resizing, get the EXIF information (if any)
        $exifinfo  = null;
        if ( $Globals['showexif'] == "yes" )
        {
            $exifinfo = readexifinfo( $filepath, $realname );
        }

        if ( $Globals['jpegtran'] != "" )
        {
            // Only do this on JPGs
            if ( strstr(strtolower($filepath),".jpg") && file_exists($Globals['jpegtran']) )
            {
                $syscmd = "\"{$Globals['jpegtran']}\" -copy none $filepath";
                $retval = fs_exec($syscmd);

                if ( $retval == 0 )
                {
                    // Now we have to move the temp file to the original
                    @chmod ($filepath, 0666);
                }
                else
                {
                    @unlink( $filepath );
                    @unlink( $tmpfile );

                    diewell( "Problem running JPEGTRAN:<br /><br />$syscmd<br /><br />Error Code: $retval" );
                }
            }
        }

        // Resizing
        if ( $resizeorig == 1 )
        {
            $newheight = $imageheight;
            $newwidth = $imagewidth;

            if ( $newwidth > $maxwidth )
            {
                $scaleFactor = $newwidth / $maxwidth;
                $newheight = round( $newheight / $scaleFactor );
                $newwidth = $maxwidth;
            }

            if ( $newheight > $maxheight )
            {
                $scaleFactor = $newheight / $maxheight;
                $newwidth = round( $newwidth / $scaleFactor );
                $newheight = $maxwidth;
            }

            if ( $Globals['usegd'] != 0 )
            {
                $resize_worked = resize_jpeg($filepath, $filepath, $newwidth, $newheight);
            }
            else
            {
                if( !stristr(PHP_OS, "win") )
                {
                    $shellpath = escapeshellarg($filepath);
                }
                else
                {
                    $shellpath = $filepath;
                }

                $syscmd = "\"{$Globals['mogrify_command']}\" -quality {$Globals['imgquality']} -geometry {$newwidth}x{$newheight} $shellpath";

                // call ImageMagick mogrify to resize the original down
                $retval = fs_exec($syscmd);

                $checkfile = "{$Globals['datafull']}$thecat/{$filenoext}.mgk";
                if ( $retval != 0 || file_exists($checkfile) )
                {
                    if ( !file_exists($checkfile) )
                    {
                        @unlink( $outthumb );
                        @unlink( $filepath );

                        diewell("{$Globals['pp_lang']['errororig']}<br /><br />Command:<br /><br />$syscmd<br /><br />Error code: $retval");
                    }

                    @unlink($filepath);
                    copy( $checkfile, $filepath );
                    @unlink($checkfile);
                }
            }
        }

        // Watermark
        $watermarked = "no";
        if ( $Globals['annotate'] == "yes" )
        {
            $dbcat = ( $CatPerms['cattype'][$thecat] == "a" ? 500 : $thecat );

            $row = ppmysql_query_one("SELECT watermark,ugnoanno FROM {$Globals['pp_db_prefix']}categories where id=$dbcat", $link);

            $uganno = 1;

            foreach( $User['usergroups'] AS $usergroup )
            {
                $allnoanno = explode( ",", $row['ugnoanno'] );
                if ( !in_array( $usergroup, $allnoanno ) )
                {
                    $uganno = 0;
                }
            }

            if ( $uganno != 1 )
            {
                // stamp the image
                watermark( $filepath, $thecat, $row['watermark'] );
                $watermarked = "yes";
            }
        }

        $imagesize = @filesize( $filepath );
        //##// end resize original and/or annotate original ###

        //##// create a medium sized graphic if the graphic is too big ###
        $createmed = 0;
        $biggraphic = $Globals['biggraphic'];

        if ( $Globals['bigsave'] == "yes" && $biggraphic > 0 )
        {
            if ( $imagewidth > $biggraphic || $imageheight > $biggraphic ) $createmed = 1;
        }

        if ( $createmed == 1 )
        {
            $medfile = "{$Globals['datafull']}$thecat/medium/$realname";

            if ( $imageheight > $imagewidth )
            {
                $scaleFactor = $imageheight / $biggraphic;
                $medwidth = round( $imagewidth / $scaleFactor );
                $medheight = $biggraphic;
            }
            else
            {
                $scaleFactor = $imagewidth / $biggraphic;
                $medheight = round( $imageheight / $scaleFactor );
                $medwidth = $biggraphic;
            }

            if ( $Globals['usegd'] != 0 )
            {
                $resize_worked = resize_jpeg($filepath, $medfile, $medwidth, $medheight);
            }
            else
            {
                copy( $filepath, $medfile );
                @chmod ($medfile, 0666);

                if( !stristr(PHP_OS, "win") )
                {
                    $shellmed = escapeshellarg($medfile);
                }
                else
                {
                    $shellmed = $medfile;
                }

                $syscmd = "\"{$Globals['mogrify_command']}\" -quality {$Globals['imgquality']} -geometry {$medwidth}x{$medheight} $shellmed";

                // call ImageMagick mogrify to create the medium image
                $retval = fs_exec($syscmd);

                $checkfile = "{$Globals['datafull']}$thecat/medium/{$filenoext}.mgk";
                if ( $retval != 0 || file_exists($checkfile) )
                {
                    if ( !file_exists($checkfile) )
                    {
                        @unlink( $outthumb );
                        @unlink( $filepath );
                        @unlink( $medium );

                        diewell("{$Globals['pp_lang']['errormed']}<br /><br />Error code: $retval<br />Command:<br /><br />$syscmd");
                    }

                    @unlink($medium);
                    copy( $checkfile, $medfile );
                    @unlink($checkfile);
                }
            }

            // get the proper stats
            $image_stats = @getimagesize( $medfile );
            $medwidth = $image_stats[0];
            $medheight = $image_stats[1];
            $medsize = @filesize( $medfile );

            if ( !$medwidth )
             {
               $fd = @fopen($medfile,"r");
               $image_string = fread($fd,filesize($medfile));
               $im = @ImageCreateFromString($image_string);

               if ( !$im )
               {
                  @unlink( $outthumb );
                  @unlink( $filepath );
                  @unlink( $medium );
                  diewell( "{$Globals['pp_lang']['readformat']}: $medfile" );
               }

               $medwidth = ImageSX($im);
               $medheight = ImageSY($im);
               ImageDestroy($im);
            }
        }
        else
        {
            $medwidth = 0;
            $medheight = 0;
            $medsize = 0;
        }
        //##// end medium sized ###

        $imagesize = @filesize( $filepath );
        $image_stats = getimagesize( $filepath );
        $imagewidth = $image_stats[0];
        $imageheight = $image_stats[1];

        // PHP has an error that it wont return values for some types of JPGs,
        // so this work around will manually figure it out.
        if ( !$imagewidth )
        {
           $fd = @fopen($filepath, "r");
           $image_string = fread( $fd,filesize($filepath) );
           $im = @ImageCreateFromString($image_string);

           if ( !$im )
           {
              @unlink( $outthumb );
              @unlink( $filepath );
              @unlink( $medium );
              diewell( "{$Globals['pp_lang']['readformat']}: $filepath" );
           }

           $imagewidth = ImageSX($im);
           $imageheight = ImageSY($im);
           ImageDestroy($im);
        }
    }
    else
    {
        if ( file_exists($Globals['ffmpeg']) )
        {
            $vidwidth = $Globals['previewwidth'];
            $vidheight1 = ( $Globals['previewwidth'] / 4 );
            $vidheight2 = round( $vidheight1 * 3 );
            $vidheight3 = $vidheight2;

            if ($vidheight2 % 2)
            {
                $vidheight3 = $vidheight2 + 1;
            }

            $filenoext = get_filename( $realname );
            $thumbnail = "{$filenoext}.jpg";
            $outthumb = "{$Globals['datafull']}$thecat/thumbs/$thumbnail";
            $syscmd = "\"{$Globals['ffmpeg']}\" -i $filepath -t 0.001 -ss 4 -vframes 1 -f mjpeg -s {$vidwidth}x{$vidheight3} $outthumb";
            $status = exec($syscmd);
        }

        $imagesize = @filesize( $filepath );
        $medwidth = 0;
        $medheight = 0;
        $medsize = 0;
        $imageheight = 0;
        $imagewidth = 0;
    }

    $moderate = ( $User['usemod'] == 0 ? 1 : 0 );

    if ( $upuserid != 0 )
    {
        list( $tmpid, $tmpuname, $tmail ) = get_userinfo("", $upuserid);
        $User['username'] = $tmpuname;
    }

    if ( empty($title) )
    {
        $title = $filenoext;
    }

    $iuser = addslashes( $User['username'] );
    $ipaddr = findenv("REMOTE_ADDR");

    $allowprint = ( $allowprint == "no" ? "no" : "yes" );
    $allowr = ( $rating == "no" ? 0 : 1 );
    $allowc = ( $comments == "no" ? 0 : 1 );
    $ismature = ( $mature == "yes" ? 1 : 0 );

    if ( $replace > 0 )
    {
        $query = "UPDATE {$Globals['pp_db_prefix']}photos SET bigimage='$realname',width=$imagewidth,height=$imageheight,filesize=$imagesize,approved=$moderate,lastpost=$julian,medsize=$medsize,medwidth=$medwidth,medheight=$medheight WHERE id=$replace";
        $resulta = ppmysql_query($query, $link);

        if ( $exifinfo != "" && count($exifinfo) > 6 )
	    {
	        $storeexif = addslashes(serialize($exifinfo));
	        $resultc = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}exif SET exifinfo='$storeexif' WHERE photoid='$replace'", $link);
	    }

        return;
    }

    $query = "INSERT INTO {$Globals['pp_db_prefix']}photos (id,user,userid,cat,date,title,description,ismature,keywords,bigimage,width,height,filesize,medwidth,medheight,medsize,approved,lastpost,
        watermarked,allowprint,extra1,extra2,extra3,extra4,extra5,extra6,ipaddress,allowrate,allowcoms)
        values(NULL,'$iuser', $upuserid, $thecat, $julian, '$title', '$desc', $ismature, '$keywords', '$realname', $imagewidth, $imageheight, $imagesize,
        $medwidth, $medheight, $medsize, $moderate, $julian, '$watermarked','$allowprint','$extra1','$extra2','$extra3','$extra4','$extra5','$extra6','$ipaddr','$allowr','$allowc')";

    $resulta = ppmysql_query($query, $link);
    $lastphotoid = mysql_insert_id( $link );

    if ( empty($lastphotoid) )
    {
        diewell( $Globals['pp_lang']['uploaderror'] );
    }

    if ( $upuserid > 0 )
    {
        $resultc = ppmysql_query("INSERT IGNORE INTO {$Globals['pp_db_prefix']}users (userid,lastphoto,lastdate) VALUES ($upuserid,0,0)", $link);
    }

    if ( $moderate == 1 )
    {
        $row = ppmysql_query_one("SELECT thumbnail FROM {$Globals['pp_db_prefix']}categories where id=$thecat", $link);

        $morestuff = "";

        if ( $row['thumbnail'] == 0 )
        {
            $morestuff = ",thumbnail=$lastphotoid";
        }

        $resultb = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}users SET lastphoto=$lastphotoid, lastdate=$julian WHERE userid=$upuserid", $link);
        $resultb = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET photos=(photos+1),lastphoto=$lastphotoid{$morestuff} WHERE id=$thecat", $link);
    }

    upgradecategories($thecat);

    if ( $Globals['memformat'] == "yes" & $thecat != 500 )
    {
         upgradecategories(500);
    }

    if ( $optone > 0 && ($optone != $thecat) )
    {
        $query2 = "INSERT INTO {$Globals['pp_db_prefix']}photos (id,user,userid,cat,storecat,storeid,date,title,description,ismature,keywords,bigimage,width,height,filesize,medwidth,medheight,medsize,approved,lastpost,watermarked,allowprint,extra1,extra2,extra3,extra4,extra5,extra6,allowrate,allowcoms)
            values(NULL,'$iuser', $upuserid, '$optone', '$thecat', '$lastphotoid', $julian, '$title', '$desc', $ismature, '$ikeywords', '$realname', $imagewidth, $imageheight, $imagesize,
            $medwidth, $medheight, $medsize, $moderate, 0, '$watermarked','$allowprint','$extra1','$extra2','$extra3','$extra4','$extra5','$extra6','$allowr','$allowc')";
        $resultb = ppmysql_query($query2, $link);

        $result2b = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET photos=(photos+1),lastphoto=$lastphotoid WHERE id='$optone'", $link);

        upgradecategories($optone);
    }

    if ( $opttwo > 0 && ($opttwo != $thecat && $opttwo != $optone) )
    {
        $query3 = "INSERT INTO {$Globals['pp_db_prefix']}photos (id,user,userid,cat,storecat,storeid,date,title,description,ismature,keywords,bigimage,width,height,filesize,medwidth,medheight,medsize,approved,lastpost,watermarked,allowprint,extra1,extra2,extra3,extra4,extra5,extra6,allowrate,allowcoms)
            values(NULL,'$iuser', $upuserid, '$opttwo', '$thecat', '$lastphotoid', $julian, '$title', '$desc', $ismature, '$ikeywords', '$realname', $imagewidth, $imageheight, $imagesize,
            $medwidth, $medheight, $medsize, $moderate, 0, '$watermarked','$allowprint','$extra1','$extra2','$extra3','$extra4','$extra5','$extra6','$allowr','$allowc')";
        $resultac= ppmysql_query($query3, $link);

        $result3b = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET photos=(photos+1),lastphoto=$lastphotoid WHERE id='$opttwo'", $link);

        upgradecategories($opttwo);
    }

    if ( $replace > 0 )
    {
	    if ( $exifinfo != "" && count($exifinfo) > 6 )
	    {
	        $storeexif = addslashes(serialize($exifinfo));
	        $resultc = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}exif SET exinfo='$storeexif' WHERE photoid='$replace'", $link);
	    }
	}
    else
    {
	    if ( $exifinfo != "" && count($exifinfo) > 6 )
	    {
	        $storeexif = addslashes(serialize($exifinfo));
	        $resultc = ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}exif (photoid,exifinfo) values( $lastphotoid, '$storeexif' )", $link);
	        $resultd = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET exifinfo=1 WHERE id=$lastphotoid", $link);
	    }
    }

    // Send an email notification to admin if required
    if ( $Globals['uploadnotify'] == "yes" && $User['adminedit'] != 1 )
    {
        include "{$Globals['PP_PATH']}/languages/{$Globals['pplang']}.php";

        $letter = $Globals['pp_lang']['euplimg'];
        $letter = stripslashes($letter);
        $subject = $Globals['pp_lang']['euplsub'];

        $send_to = $Globals['adminemail'];
        $from_email = "From: {$Globals['adminemail']}";
        mail( $send_to, $subject, $letter, $from_email );
    }

    if ($Globals['ppostcount'] == "yes")
    {
        inc_user_posts();
    }

    if ($Globals['usenotify'] == "yes" && $User['userid'] > 0 )
    {
        // Notify any users who signed up for notification from this category
        if ( $moderate == 1 )
        {
            $resulta = ppmysql_query("SELECT userid FROM {$Globals['pp_db_prefix']}notify WHERE photo=$thecat AND type=1", $link);
            while ( list($nuserid) = mysql_fetch_row($resulta) )
            {
                if ( $nuserid > 0 )
                {
                    list( $tuserid, $tusername, $tmail ) = get_userinfo( "", $nuserid);

                    include "{$Globals['PP_PATH']}/languages/{$Globals['pplang']}.php";

                    $letter = $Globals['pp_lang']['subnotify'];
                    $subject = $Globals['pp_lang']['emsubscr'];

                    $send_to = $tmail;
                    $from_email = "From: {$Globals['adminemail']}";
                    mail( $send_to, $subject, $letter, $from_email );
                }
            }
        }

        if ( $notify == "yes" )
        {
            $resulta = ppmysql_query("SELECT id FROM {$Globals['pp_db_prefix']}photos WHERE userid=$upuserid AND bigimage='$realname'", $link);
            list( $photoid ) = mysql_fetch_row($resulta);

            $resulta = ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}notify (id,userid,photo) values(NULL,$upuserid,$photoid)", $link);
        }
    }

    // Notify buddies
    if ( $Globals['usemsg'] == "yes" )
    {
        $resulta = ppmysql_query("SELECT userid FROM {$Globals['pp_db_prefix']}buddies WHERE buddy=$upuserid", $link);
        while ( list($nuserid) = mysql_fetch_row($resulta) )
        {
            $msgtext = get_string( "uploadmsg", "<a href=\"{$Globals['maindir']}/member.php?uid=$upuserid\">$iuser</a>", "<a href=\"{$Globals['maindir']}/showphoto.php?photo=$lastphotoid\">$title</a>" );
            send_ppmsg( $nuserid, $msgtext, $lastphotoid, 'c' );
        }
    }

    // Let's update the category cache
    update_catcache();

    return( $lastphotoid );
}

?>
