<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Chuck Scannell (http://www.omegatron.net)                      //
//                         Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2008, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

// this will return an array like:
// list( $userid, $username, $email, $password, $temppass, $groups, $offset, $sessionid ) = get_userinfo( $user, $userid );

function upgradesubscriber( $usergroup, $userid = 0 ) 
{
    global $Globals, $db_link;

    if ( !empty($usergroup) && !empty($userid) )
    {
    	$resulta = ppmysql_query("UPDATE {$Globals['dprefix']}user SET user_group_id='$usergroup' WHERE user_id='$userid'",$db_link);
    }

    return;
}

function get_userinfo( $authuser, $userid=0 ) {
    global $Globals, $db_link;

    if ( $userid != 0 ) {
        $query = "SELECT u.user_id,u.username,u.email,a.remember_key,u.user_group_id,u.timezone,u.style_id,u.secondary_group_ids,a.data
            FROM {$Globals['dprefix']}user AS u
            LEFT JOIN {$Globals['dprefix']}user_authenticate AS a ON a.user_id=u.user_id
            WHERE u.user_id='$userid'";
    }
    else {
        $query = "SELECT u.user_id,u.username,u.email,a.remember_key,u.user_group_id,u.timezone,u.style_id,u.secondary_group_ids,a.data
            FROM {$Globals['dprefix']}user AS u
            LEFT JOIN {$Globals['dprefix']}user_authenticate AS a ON a.user_id=u.user_id
            WHERE u.username='$authuser'";
    }

    $queryv = ppmysql_query($query,$db_link);
    $results = mysql_fetch_array($queryv);

    $mgroups = $results['user_group_id'];

    if ( $results['secondary_group_ids'] )
    {
        $mgroups .= ",{$results['secondary_group_ids']}";
    }

    $username = array(
                    $results['user_id'],            // userid
                    $results['username'],          // username
                    $results['email'],             // email
                    $results['remember_key'],          // password
                    null,                          // temppassword
                    $mgroups,                      // groups
                    $results['timezone'],    // timeoffset
                    $results['style_id'],       // session id
                    $results['data'],       // data
                 );

    return $username;
}


//
// For each BB, get the total number of users
//

function get_totalusers() {
    global $Globals, $db_link;

    $query = "SELECT * FROM {$Globals['dprefix']}user";
    $queryv = ppmysql_query($query, $db_link);
    $totalusers = mysql_num_rows($queryv);

    return( $totalusers );
}

//
// For each BB, get the link to the profile page for that user
//

function get_profilelink( $tuserid, $tusername="" ) {
    global $Globals, $db_link, $postreply, $privatelink;

    $profilelink = "{$Globals['vbulletin']}/index.php?members/$tuserid";
    $postreply = "<span class=\"{$Style['medium']}\"><b>{$Globals['pp_lang']['postreply']}</b></span>";

    return( $profilelink );
}

//
// Get a list of users and ids as an option list
//

function useropts() {
    global $Globals, $db_link;

    $useropts = "";

    $query = "SELECT user_id,username FROM {$Globals['dprefix']}user ORDER BY username";

    $queryv = ppmysql_query($query,$db_link);
    while ( list( $userid, $username ) = mysql_fetch_row($queryv) ) {
        $useropts .= "<option value=\"$userid\">$username</option>";
    }
    ppmysql_free_result($rows);

    return( $useropts );
}

//
// Increment or decrement the user post in the users database
//

function inc_user_posts( $type = "plus", $userid = 0 ) {
    global $Globals, $db_link, $User;

    if ( $userid == 0 ) $usernum = $User['userid'];
    else $usernum = $userid;

    if ( $type == "plus" ) {
        $do_inc = "+1";
    }
    else {
        $do_inc = "-1";
    }

    $query = "UPDATE {$Globals['dprefix']}user SET message_count=message_count$do_inc WHERE user_id=$usernum";
    $resulta = ppmysql_query($query,$db_link);

    return;
}


function get_profiledata( $cuserid ) {
    global $Globals, $db_link;
    global $cuser, $clocation, $ctitle, $cposts, $regdate, $isonline, $hpage, $postline, $profilelink, $privatelink;

    $regdate = ""; $ctitle = ""; $cposts = ""; $chomepage = ""; $cuser = $Globals['pp_lang']['unreg']; $postline = "";
    $hpage = "";

    if ($cuserid != 0) {

        $query = "SELECT a.username,p.homepage,a.message_count,a.custom_title,a.register_date,p.location,a.avatar_date,p.signature FROM {$Globals['dprefix']}user a
		  LEFT JOIN {$Globals['dprefix']}user_profile p ON p.user_id=a.user_id
                  WHERE a.user_id=$cuserid LIMIT 1";
        $results = ppmysql_query($query,$db_link);
        list( $cuser, $chomepage, $cposts, $ctitle, $regdate, $clocation, $uavatar, $csig ) = mysql_fetch_row($results);
        ppmysql_free_result( $results );

        $postline = "<a href=\"$profilelink\" target=\"_blank\"><img src=\"{$Globals['idir']}/profile.gif\" border=\"0\" alt=\"{$Globals['pp_lang']['seeprofile']}\" /></a>";

        $chomepage = str_replace("http://", "", $chomepage);
        if ($chomepage != "" ) {
            $hpage = "<a href=\"http://$chomepage\" target=\"_blank\"><img src=\"{$Globals['idir']}/home.gif\" alt=\"{$Globals['pp_lang']['visithome']}\" border=\"0\" /></a>";
        }

        $userprofile[0] = $cuser;                   // Username
        $userprofile[1] = $chomepage;               // Homepage
        $userprofile[2] = $cposts;                  // Total Posts
        $userprofile[3] = $ctitle;                  // Title
        $userprofile[4] = $regdate;                 // Registered Date
        $userprofile[5] = "$clocation";                  // Location

        if ($uavatar > 0 ) {
            $userprofile[6] = "<img src=\"{$Globals['vbulletin']}/data/avatars/m/0/$cuserid.jpg?$uavatar\" alt=\"avatar\" border=\"0\" />";  // Avatar
        }
        else {
            $userprofile[6] = "";  // Avatar
        }

        $userprofile[7] = nl2br($csig); // Signature
    }

    $postline .= "$hpage<!--PhotoPost, copyright All, Enthusiast, Inc.--></td>";

    return( $userprofile );
}

function setlogin( $password ) {
    global $Globals, $User, $db_link, $globalsalt, $_SERVER;

    $remember_key = sha1($globalsalt . $User['password']);
    $cookpass = intval($User['userid']) . ',' . $remember_key;

    setcookie( "{$Globals['cookieprefix']}user", $cookpass, time()+31536000,"{$Globals['cookie_path']}", $Globals['domain_path'],0 );

    return;
}

function logout() {
    global $Globals;

    setcookie( "{$Globals['cookieprefix']}user", "", "0","{$Globals['cookie_path']}", $Globals['domain_path'] );
    setcookie( "{$Globals['cookieprefix']}session","","0","{$Globals['cookie_path']}", $Globals['domain_path'] );

    return;
}


function get_regcode() {
    global $Globals;

    $regtext = " &middot; <a href=\"{$Globals['vbulletin']}/index.php?login\">{$Globals['pp_lang']['register']}</a>";

    return($regtext);
}

function get_logincode() {
    global $Globals, $User, $db_link;

    if ( $Globals['forumstyle'] == "yes" )
    {
        $stylec = ppmysql_query("SELECT option_value FROM {$Globals['dprefix']}option WHERE option_id='defaultStyleId'",$db_link);
        list( $defaultstyle ) = mysql_fetch_row($stylec);

        $User['stylesheet'] = $defaultstyle;
    }

    $links[0] = "{$Globals['maindir']}/misc.php?action=login&login=yes";
    $links[1] = "{$Globals['maindir']}/misc.php?action=logout";

    return($links);
}

function authenticate( $authuser="", $chkpassword="" ) {
    global $Globals, $User, $password, $link, $db_link, $globalsalt;
    global $phoedit, $gologin, $bbuserid, $bbpassword;
    global $up_k, $disk_k, $cedit, $usergroup;
    global $CatPerms, $ueditpho, $ueditposts, $exclude_cat;
    global $PHPSESSID, $cookiename;
    $cookieuser = $Globals['cookieprefix']."user";
    $cookiehash = $Globals['cookieprefix']."session";

    $xencookie = $_COOKIE["$cookieuser"];
    $xensession = $_COOKIE["$cookiehash"];

    // Init some variables
    $User = array();
    $User['uploads'] = 0;
    $User['userid'] = 0;
    $User['nopost'] = 1;
    $User['adminedit'] = 0;
    $User['moderator'] = 0;
    $User['albums'] = 0;
    $User['uploadlimit'] = 0;

    $gologin = 1; $usergroup = 0; $checkpass = 0;
    $ueditpho = 0; $ueditposts = 0;
    $diskspace = 0; $uploadsize = 0;
    $md5cookpass="";

    // If we arent passing variables, set them to what was passed in the URL
    if ( $authuser == "" ) {
        if ($xencookie) {

            $parts = explode(",", $xencookie);

            $cookuser = $parts[0];
            $cookpass = $parts[1];

            list( $userid, $username, $email, $dbpassword, $md5temppass, $usergroups, $offset, $numstyle, $checkdb ) = get_userinfo( "", $cookuser );

        }
        elseif ( $xensession ) {

            $query = "SELECT session_data FROM {$Globals['dprefix']}session WHERE session_id = '$xensession'";
            $results = ppmysql_query($query,$db_link);
            list( $session_data) = mysql_fetch_row($results);
            $session_data = unserialize($session_data);

            $query2 = "SELECT user_id FROM {$Globals['dprefix']}session_activity WHERE ip = '{$session_data['ip']}'";
            $results = ppmysql_query($query2,$db_link);
            list( $cookuser) = mysql_fetch_row($results);
            list( $userid, $username, $email, $dbpassword, $md5temppass, $usergroups, $offset, $numstyle, $checkdb ) = get_userinfo( "", $cookuser );
        }
    }
    else {
        $cookuser = addslashes($authuser);

        list( $userid, $username, $email, $dbpassword, $md5temppass, $usergroups, $offset, $numstyle, $checkdb ) = get_userinfo( $cookuser );

        $dbhash = unserialize($checkdb);
        $finalhash = $dbhash['hash'];
        $hashFunc = $dbhash['hashFunc'];
        $salt = $dbhash['salt'];

        if ( $hashFunc == "sha256" ) {
            $userHash = hash('sha256',hash('sha256', $password) . $salt);
        }
        else
        {
            $userHash = sha1(sha1($password) . $salt);
        }
    }

    $remember_key = sha1($globalsalt . $dbpassword);
    $finalpass = intval($cookuser) . ',' . $remember_key;

    if ( ($xensession) && !empty($session_data) && $cookuser ) {
        $checkpass = 1;
    }
    elseif ($cookpass) {
        if ($remember_key == $cookpass) {
            $checkpass = 1;
        }
    }
    elseif (!empty($finalhash)) {
        if ($userHash == $finalhash) {
            $checkpass = 1;
        }

        // just to be sure, lets see if they have a temp pass for verification and do the same checks
        if ( $md5temppass != "" && $checkpass != 1 ) {
            if ( $md5cookpass == $md5temppass ) $checkpass = 1;
        }
    }

    if ( $Globals['forumstyle'] == "yes" )
    {
        $stylec = ppmysql_query("SELECT option_value FROM {$Globals['dprefix']}option WHERE option_id='defaultStyleId'",$db_link);
        list( $defaultstyle ) = mysql_fetch_row($stylec);

    }
    if ( $nunmstyle == 0 )
    {
        $User['stylesheet'] = $defaultstyle;
    }
    else
    {
        $User['stylesheet'] = $numstyle;
    }

    //print "($checkpass : $finalpass : $cookpass) $userid - $username - $email - $dbpassword - $md5temppass - $usergroups - $offset - $numstyle - $sessionid - $finalhash - $hashFunc - $salt - $userHash  - {$data['ip']} - $xensession";
    //exit;

    if ( $checkpass == 1 )
    {
        $gologin=0; $User['nopost']=0;
        $User['userid'] = $userid;
        $User['username'] = $username;
        $User['email'] = $email;
        $User['offset'] = $offset;
        $User['password'] = $dbpassword;
        $User['stylesheet'] = $numstyle;
    }
    else
    {
        $usergroups = "1";
    }

    $vbgroups = explode( ",", $usergroups);
    $CatPerms = array();

    set_user_perms( $vbgroups );

    return( $gologin );
}

function import_user_groups()
{
    global $Globals, $db_link, $link;

    $query = "SELECT groupid, groupname, cpaccess, uploads, comments, diskspace, uploadsize, uplimit, editpho, editposts, modaccess, useralbums, reqmod, canassign FROM {$Globals['pp_db_prefix']}usergroups";
    $resultcur = ppmysql_query($query, $link);
    $currentGroups = array();

    while ( list($groupid, $groupname, $cpaccess, $uploads, $comments, $diskspace, $uploadsize, $uplimit, $editpho, $editposts, $modaccess, $useralbums, $reqmod, $canassign) = mysql_fetch_row( $resultcur ) ) {
        $currentGroups[$groupid]['groupid'] = $groupid;
        $currentGroups[$groupid]['groupname'] = $groupname;
        $currentGroups[$groupid]['cpaccess'] =  $cpaccess;
        $currentGroups[$groupid]['uploads'] =  $uploads;
        $currentGroups[$groupid]['comments'] =  $comments;
        $currentGroups[$groupid]['diskspace'] =  $diskspace;
        $currentGroups[$groupid]['uploadsize'] =  $uploadsize;
        $currentGroups[$groupid]['uplimit'] =  $uplimit;
        $currentGroups[$groupid]['editpho'] =  $editpho;
        $currentGroups[$groupid]['editposts'] =  $editposts;
        $currentGroups[$groupid]['modaccess'] =  $modaccess;
        $currentGroups[$groupid]['useralbums'] =  $useralbums;
        $currentGroups[$groupid]['reqmod'] =  $reqmod;
        $currentGroups[$groupid]['canassign'] =  $canassign;
    }

    $query = "SELECT user_group_id,title FROM {$Globals['dprefix']}user_group";
    $readug = ppmysql_query($query,$db_link);
    $newGroups = array();

    while ( list($gid, $title ) = mysql_fetch_row( $readug ) ) {
        $newGroups[$gid] = $gid;
        if ( $gid == 3 ) {
            $cancontrol = 1;
        }
        else {
            $cancontrol = 0;
        }

        if ( !array_key_exists($gid,$currentGroups) ) {
            $currentGroups[$gid]['groupid'] = $gid;
            $currentGroups[$gid]['groupname'] = $title;
            $currentGroups[$gid]['cpaccess'] =  $cancontrol;
            $currentGroups[$gid]['uploads'] =  0;
            $currentGroups[$gid]['comments'] = 0;
            $currentGroups[$gid]['diskspace'] =  0;
            $currentGroups[$gid]['uploadsize'] = 0;
            $currentGroups[$gid]['uplimit'] = 0;
            $currentGroups[$gid]['editpho'] =  0;
            $currentGroups[$gid]['editposts'] =  0;
            $currentGroups[$gid]['modaccess'] =  0;
            $currentGroups[$gid]['useralbums'] =  0;
            $currentGroups[$gid]['reqmod'] =  0;
            $currentGroups[$gid]['canassign'] =  0;
        }
    }
    ppmysql_free_result( $readug );

    foreach ($currentGroups as $currentGroup) {
        $gid = $currentGroup['groupid'];
        if ( !array_key_exists($gid, $newGroups)) {
            unset($currentGroups[$gid]);
        }
    }

    $query = "DELETE FROM {$Globals['pp_db_prefix']}usergroups";
    $resulta = ppmysql_query($query, $link);


    foreach ($currentGroups as $currentGroup) {
        $gid = $currentGroup['groupid'];
        $name = addslashes($currentGroup['groupname']);
        $cpaccess = $currentGroup['cpaccess'];
        $uploads = $currentGroup['uploads'];
        $comments =    $currentGroup['comments'];
        $diskspace = $currentGroup['diskspace'];
        $uploadsize = $currentGroup['uploadsize'];
        $uploadlimit = $currentGroup['uplimit'];
        $editpho = $currentGroup['editpho'];
        $editposts = $currentGroup['editposts'];
        $modaccess = $currentGroup['modaccess'];
        $useralbums = $currentGroup['useralbums'];
        $reqmod = $currentGroup['reqmod'];
        $canassign = $currentGroup['canassign'];

        $query="INSERT INTO {$Globals['pp_db_prefix']}usergroups (groupid,groupname,modaccess,cpaccess,uploads,uplimit,comments,diskspace,uploadsize,editpho,editposts,useralbums,reqmod,canassign)
                VALUES('$gid','$name','$modaccess','$cpaccess','$uploads','$uplimit','$comments','$diskspace','$uploadsize','$editpho','$editposts','$useralbums','$reqmod','$canassign')";
        $setug = ppmysql_query($query,$link);
    }

}

function init_user_groups() {
    global $link, $pp_db_prefix;

    $query = "CREATE TABLE {$pp_db_prefix}usergroups (groupid int(5) NOT NULL auto_increment, groupname varchar(50) NOT NULL default '', cpaccess smallint(3) NOT NULL default '0', modaccess smallint(3) NOT NULL default '0', uploads smallint(3) NOT NULL default '1', comments smallint(3) NOT NULL default '1', diskspace int(10) default NULL, uploadsize int(10) default NULL, uplimit INT(5) DEFAULT '0' NOT NULL, editpho int(3) NOT NULL default '0', editposts int(3) NOT NULL default '0', useralbums int(3) NOT NULL default '0',reqmod INT(3) DEFAULT '0' NOT NULL, canassign INT(3) DEFAULT '0' NOT NULL, PRIMARY KEY (groupid)) TYPE=MyISAM;";
    $setup = mysql_query($query,$link);

    return($setup);
}


function convert_markups($markup)
{
    global $Globals;

    return ( ppconvert_markups($markup) );
}


function get_forum_style()
{
    global $Globals, $User;

    if ( $Globals['forumstyle'] == "yes" )
    {
        return ( "<link rel=\"stylesheet\" href=\"{$Globals['vbulletin']}/css.php?css=xenforo,form,public&style={$User['stylesheet']}\" type=\"text/css\" />" );
    }

    return( "<link rel=\"stylesheet\" href=\"{$Globals['maindir']}/stylesheets/{$Globals['theme']}.css\" type=\"text/css\" />" );
}


//
// Style references
//

if ( $Globals['forumstyle'] == "yes" ) {
    $Style['onbody'] = "onbody";
    $Style['tableborders'] = "";
    $Style['tablesurround'] = "";
    $Style['tddetails'] = "secondaryContent";
    $Style['tdbackground'] = "windowbg2";
    $Style['tdnothumbs'] = "titlebg";
    $Style['menubar'] = "nodeInfo categoryNodeInfo categoryStrip subHeading";
    $Style['menubarnb'] = "";
    $Style['catcolumn'] = "nodeInfo forumNodeInfo";
    $Style['photocol'] = "nodeInfo forumNodeInfo";
    $Style['commentscol'] = "nodeLastPost secondaryContent";
    $Style['lastphocol'] = "nodeLastPost secondaryContent";
    $Style['lastcommcol'] = "nodeInfo forumNodeInfo";
    $Style['small'] = "smalltext";
    $Style['medium'] = "normaltext";
    $Style['large'] = "largetext";
    $Style['welcome'] = "normaltext";
    $Style['lighttable'] = "secondaryContent";
    $Style['alternatetable'] = "secondaryContent";
    $Style['formboxes'] = "input";
    $Style['blockquote'] = "quote";
}

?>