<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

// this will return an array like:
// list( $userid, $username, $email, $password, $temppass, $groups, $offset, $sessionid, $fstyle ) = get_userinfo( $user, $userid );

if ( empty($Globals['dprefix']) ) $Globals['dprefix'] = "wowbb_";

function upgradesubscriber( $usergroup, $userid = 0 )
{
    global $Globals, $db_link;

    if ( !empty($usergroup) && !empty($userid) )
    {
    	$resulta = ppmysql_query("UPDATE {$Globals['dprefix']}users SET user_group_id='$usergroup' WHERE user_id='$userid'",$db_link);
    }

    return;
}

function get_userinfo( $authuser, $userid=0 ) {
    global $Globals, $db_link;

    $tuser = addslashes($authuser);
    $userid = (int)$userid;

    if ( $userid != 0 ) {
        $query = "SELECT user_id,user_name,user_email,user_password,user_group_id,user_theme FROM {$Globals['dprefix']}users WHERE user_id=$userid";
    }
    else {
        $query = "SELECT user_id,user_name,user_email,user_password,user_group_id,user_theme FROM {$Globals['dprefix']}users WHERE user_name='$tuser'";
    }
    $queryv = ppmysql_query($query,$db_link);
    $results = mysql_fetch_array($queryv);

    $username[0] = $results['user_id'];       // userid
    $username[1] = $results['user_name'];     // username
    $username[2] = $results['user_email'];        // email
    $username[3] = $results['user_password'];     // password
    $username[4] = $results['user_temppass'];     // temppassword
    $username[5] = $results['user_group_id'];       // groups
    $username[6] = $results['user_theme'];    // stylesheet

    ppmysql_free_result($queryv);

    return $username;
}

//
// For each BB, get the total number of users
//

function get_totalusers() {
    global $Globals, $db_link;

    $query = "SELECT * FROM {$Globals['dprefix']}users";

    $queryv = ppmysql_query($query, $db_link);
    $totalusers = mysql_num_rows($queryv);

    return( $totalusers );
}

//
// For each BB, get the link to the profile page for that user
//

function get_profilelink( $tuserid, $tusername="" ) {
    global $Globals, $db_link, $postreply, $privatelink;

    $profilelink = "{$Globals['vbulletin']}/view_user.php?id=$tuserid";
    $postreply = "<span class=\"{$Style['medium']}\"><b>{$Globals['pp_lang']['postreply']}</b></span>";

    return( $profilelink );
}

//
// Get a list of users and ids as an option list
//

function useropts() {
    global $Globals, $db_link;

    $useropts = "";

    $query = "SELECT user_id,user_name FROM {$Globals['dprefix']}users ORDER BY user_name";
    $queryv = ppmysql_query($query,$db_link);
    while ( list( $userid, $username ) = mysql_fetch_row($queryv) ) {
        $useropts .= "<option value=\"$userid\">$username</option>";
    }
    ppmysql_free_result($rows);

    return( $useropts );
}

//
// Increment or decrement the user post in the users database
//

function inc_user_posts( $type = "plus", $userid = 0 ) {
    global $Globals, $db_link, $User;

    if ( $userid == 0 ) $usernum = $User['userid'];
    else $usernum = $userid;

    if ( $type == "plus" ) $do_inc = "+1";
    else $do_inc = "-1";

    $query = "UPDATE {$Globals['dprefix']}users SET user_posts=user_posts$do_inc WHERE user_id=$usernum";
    $resulta = ppmysql_query($query,$db_link);

    return;
}


function get_profiledata( $cuserid ) {
    global $Globals, $db_link;
    global $cuser, $clocation, $ctitle, $cposts, $regdate, $ugallery, $isonline, $hpage, $postline, $profilelink, $privatelink;

    $regdate = ""; $ctitle = ""; $cposts = ""; $chomepage = ""; $cuser = $Globals['pp_lang']['unreg']; $postline = "";
    $hpage = ""; $ugallery="";
    $userprofile = array("Anonymous","","","","","","","","","");

    if ($cuserid > 1) {
        $query = "SELECT user_name,user_homepage,user_posts,user_joined,user_region,user_avatar,user_signature FROM {$Globals['dprefix']}users WHERE user_id=$cuserid LIMIT 1";
        $results = ppmysql_query($query,$db_link);
        list( $cuser, $chomepage, $cposts, $regdate, $uloc, $uavatar, $usig ) = mysql_fetch_row($results);
        ppmysql_free_result( $results );

        $postline = "<a href=\"$profilelink\" target=\"_blank\"><img src=\"{$Globals['idir']}/profile.gif\" border=\"0\" alt=\"{$Globals['pp_lang']['seeprofile']}\" /></a>";

        $chomepage = str_replace("http://", "", $chomepage);
        if ($chomepage != "" ) {
            $hpage = "<a href=\"http://$chomepage\" target=\"_blank\"><img src=\"{$Globals['idir']}/home.gif\" alt=\"{$Globals['pp_lang']['visithome']}\" border=\"0\" /></a>";
        }

        $userprofile[0] = $cuser;                   // Username
        $userprofile[1] = $chomepage;               // Homepage
        $userprofile[2] = $cposts;                  // Total Posts
        $userprofile[3] = $ctitle;                  // Title
        $userprofile[4] = $regdate;                 // Registered Date
        $userprofile[5] = $uloc;                    // Location
        $userprofile[6] = ( !empty($uavatar) && $uavatar != "http://" ? "<img src=\"{$Globals['vbulletin']}/$uavatar\" />" : "" ); // Avatar
        $userprofile[7] = nl2br($usig); // Signature
    }

    $regdate = strtotime($regdate);
    $ugallery = "<a href=\"" . construct_newppurl( "showgallery.php", array('ppuser' => $cuserid, 'username' => $cuser) ) . "\"><img alt=\"{$Globals['pp_lang']['visitgallery']}\" border=\"0\" src=\"{$Globals['idir']}/gallery.gif\" /></a>";
    $postline .= "$hpage<!--PhotoPost, copyright All, Enthusiast, Inc.-->$ugallery</td>";

    return( $userprofile );
}

function setlogin( $password ) {
    global $Globals, $User, $db_link;

    $cookie_contents = array(
        $User['username'],
        $User['password'],
        $User['user_time_zone]'],
        $User['last_visited_topics'],
        $User['pm_ids'],
        $User['last_visited_forums'] );

    // Clear last visited topics if no space left
    if (strlen(implode("||", $cookie_contents)) > 3900)
    $cookie_contents[3] = "";

    setcookie( "{$Globals['smfcookie']}", implode("||", $cookie_contents) . "||", time()+2592000,"{$Globals['cookie_path']}", $Globals['domain_path'] );

    return;
}

function logout() {
    global $Globals;

    setcookie( "{$Globals['smfcookie']}", "", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );

    return;
}

function get_regcode() {
    global $Globals;

    $regtext = " &middot; <a href=\"{$Globals['vbulletin']}/login.php?register=1\">{$Globals['pp_lang']['register']}</a>";

    return($regtext);
}

function get_logincode() {
    global $Globals, $User;

    if ( $Globals['vbversion'] == "wowbb" && $Globals['forumstyle'] == "yes" )
    {
        $User['stylesheet'] = $Globals['threads'];
    }

    $links[0] = "{$Globals['vbulletin']}/login?out=1";
    $links[1] = "{$Globals['vbulletin']}/login.php?register=1";

    return($links);
}

function authenticate( $authuser="", $chkpassword="" ) {
    global $Globals, $User, $password, $link, $db_link;
    global $postid, $phoedit, $gologin;
    global $up_k, $disk_k, $cedit;
    global $diskspace, $uploadsize, $usergroups, $bbuserinfo;
    global $CatPerms, $ueditpho, $ueditposts, $exclude_cat;

    $smfcookname = $Globals['smfcookie'];
    $smfcookie = $_COOKIE[$smfcookname];

    // Init some variables
    $User = array();
    $User['uploads'] = 0;
    $User['userid'] = 0;
    $User['nopost'] = 1;
    $User['adminedit'] = 0;
    $User['moderator'] = 0;
    $User['albums'] = 0;
    $User['uploadlimit'] = 0;

    $gologin = 1; $usergroups = ""; $checkpass = 0;
    $ueditpho = 0; $ueditposts = 0;
    $diskspace = 0; $uploadsize = 0;
    $md5cookpass="";

    // If we arent passing variables, set them to what was passed in the URL
    if ( $authuser == "" )
    {
        if ( $smfcookie )
        {
            $parts = explode("||", $smfcookie);

            $cookuser    = $parts[0];
            $md5cookpass = $parts[1];

            list( $userid, $username, $email, $dbpassword, $md5temppass, $usergroups, $fstyle ) = get_userinfo( $cookuser );
        }
    }
    else
    {
        $cookuser = addslashes($authuser);
        $md5cookpass = md5($chkpassword);

        list( $userid, $username, $email, $dbpassword, $md5temppass, $usergroups, $fstyle ) = get_userinfo( $cookuser );
    }


    if ( $md5cookpass == $dbpassword ) $checkpass = 1;

    // just to be sure, lets see if they have a temp pass for verification and do the same checks
    if ( $md5temppass != "" && $checkpass != 1 )
    {
        if ( $md5cookpass == $md5temppass ) $checkpass = 1;
    }

    if ( $checkpass == 1 )
    {
        $gologin=0; $User['nopost']=0;
        $User['userid'] = $userid;
        $User['username'] = $username;
        $User['email'] = $email;
        $User['password'] = $dbpassword;
        $User['stylesheet'] = $fstyle;
    }
    else
    {
        // This assumes that "Guests" is 1
        $usergroups = "1";
    }

    // If they don't have a stylesheet pref we use the default
    if ( !$fstyle || $fstyle == "usedefault" || $User['userid'] == 0 )
    {
        $User['stylesheet'] = $Globals['threads'];
    }

    $vbgroups = explode( ",", $usergroups);
    $CatPerms = array();

    set_user_perms( $vbgroups );

    return( $gologin );
}

function import_user_groups() {
    global $Globals, $db_link, $link;

    $query = "SELECT groupid, groupname, cpaccess, uploads, comments, diskspace, uploadsize, uplimit, editpho, editposts, modaccess, useralbums, reqmod, canassign FROM {$Globals['pp_db_prefix']}usergroups";
    $resultcur = ppmysql_query($query, $link);
    $currentGroups = array();

    while ( list($groupid, $groupname, $cpaccess, $uploads, $comments, $diskspace, $uploadsize, $uplimit, $editpho, $editposts, $modaccess, $useralbums, $reqmod, $canassign) = mysql_fetch_row( $resultcur ) ) {
        $currentGroups[$groupid]['groupid'] = $groupid;
        $currentGroups[$groupid]['groupname'] = $groupname;
        $currentGroups[$groupid]['cpaccess'] =  $cpaccess;
        $currentGroups[$groupid]['uploads'] =  $uploads;
        $currentGroups[$groupid]['comments'] =  $comments;
        $currentGroups[$groupid]['diskspace'] =  $diskspace;
        $currentGroups[$groupid]['uploadsize'] =  $uploadsize;
        $currentGroups[$groupid]['uplimit'] =  $uplimit;
        $currentGroups[$groupid]['editpho'] =  $editpho;
        $currentGroups[$groupid]['editposts'] =  $editposts;
        $currentGroups[$groupid]['modaccess'] =  $modaccess;
        $currentGroups[$groupid]['useralbums'] =  $useralbums;
        $currentGroups[$groupid]['reqmod'] =  $reqmod;
        $currentGroups[$groupid]['canassign'] =  $canassign;
    }

    $query = "SELECT user_group_id, user_group_name, admin_rights FROM {$Globals['dprefix']}user_groups";
    $readug = ppmysql_query($query, $db_link);
    $newGroups = array();

    while ( list($gid, $title, $cancontrol ) = mysql_fetch_row( $readug ) ) {
          if ( $cancontrol == 3 ) $cpaccess = 1;
           else $cancontrol=0;
        $newGroups[$gid] = $gid;
        if ( !array_key_exists($gid,$currentGroups) ) {
            $currentGroups[$gid]['groupid'] = $gid;
            $currentGroups[$gid]['groupname'] = $title;
            $currentGroups[$gid]['cpaccess'] =  $cpaccess;
            $currentGroups[$gid]['uploads'] =  0;
            $currentGroups[$gid]['comments'] = 0;
            $currentGroups[$gid]['diskspace'] =  0;
            $currentGroups[$gid]['uploadsize'] = 0;
            $currentGroups[$gid]['uplimit'] = 0;
            $currentGroups[$gid]['editpho'] =  0;
            $currentGroups[$gid]['editposts'] =  0;
            $currentGroups[$gid]['modaccess'] =  0;
            $currentGroups[$gid]['useralbums'] =  0;
            $currentGroups[$gid]['reqmod'] =  0;
            $currentGroups[$gid]['canassign'] =  0;
        }

    }
    ppmysql_free_result( $readug );

    foreach ($currentGroups as $currentGroup) {
        $gid = $currentGroup['groupid'];
        if ( !array_key_exists($gid, $newGroups)) {
            unset($currentGroups[$gid]);
        }
    }

    $query = "DELETE FROM {$Globals['pp_db_prefix']}usergroups";
    $resulta = ppmysql_query($query, $link);

    foreach ($currentGroups as $currentGroup) {
        $gid = $currentGroup['groupid'];
        $name = addslashes($currentGroup['groupname']);
        $cpaccess = $currentGroup['cpaccess'];
        $uploads = $currentGroup['uploads'];
        $comments =    $currentGroup['comments'];
        $diskspace = $currentGroup['diskspace'];
        $uploadsize = $currentGroup['uploadsize'];
        $uploadlimit = $currentGroup['uplimit'];
        $editpho = $currentGroup['editpho'];
        $editposts = $currentGroup['editposts'];
        $modaccess = $currentGroup['modaccess'];
        $useralbums = $currentGroup['useralbums'];
        $reqmod = $currentGroup['reqmod'];
        $canassign = $currentGroup['canassign'];

        $query = "INSERT INTO {$Globals['pp_db_prefix']}usergroups (groupid,groupname,modaccess,cpaccess,uploads,uplimit,comments,diskspace,uploadsize,editpho,editposts,useralbums,reqmod,canassign) VALUES('$gid','$name','$modaccess','$cpaccess','$uploads','$uplimit','$comments','$diskspace','$uploadsize','$editpho','$editposts','$useralbums','$reqmod','$canassign')";
        $setug = ppmysql_query($query,$link);
    }
}


function init_user_groups()
{
    global $link, $pp_db_prefix;

    $setup = mysql_query("CREATE TABLE {$pp_db_prefix}usergroups (groupid int(5) NOT NULL auto_increment, groupname varchar(50) NOT NULL default '', cpaccess smallint(3) NOT NULL default '0', modaccess smallint(3) NOT NULL default '0', uploads smallint(3) NOT NULL default '1', comments smallint(3) NOT NULL default '1', diskspace int(10) default NULL, uploadsize int(10) default NULL, uplimit INT(5) DEFAULT '0' NOT NULL, editpho int(3) NOT NULL default '0', editposts int(3) NOT NULL default '0', useralbums int(3) NOT NULL default '0',reqmod INT(3) DEFAULT '0' NOT NULL, canassign INT(3) DEFAULT '0' NOT NULL, PRIMARY KEY (groupid)) TYPE=MyISAM", $link);
    return($setup);
}


function convert_markups($markup)
{
    global $Globals;

    return ( ppconvert_markups($markup) );
}

function get_forum_style()
{
    global $Globals, $User;

    if ( $Globals['forumstyle'] == "yes" )
    {
        return( "<link rel=\"stylesheet\" href=\"{$Globals['vbulletin']}/themes/{$User['stylesheet']}/style_sheet.css\" type=\"text/css\" />" );
    }

    return( "<link rel=\"stylesheet\" href=\"{$Globals['maindir']}/stylesheets/{$Globals['theme']}.css\" type=\"text/css\" />" );
}


//
// Style references
//

if ( $Globals['forumstyle'] == "yes" ) {
    $Style['onbody'] = "";
    $Style['tableborders'] = "";
    $Style['tablesurround'] = "textarea";
    $Style['tddetails'] = "inside";
    $Style['tdbackground'] = "inside";
    $Style['tdnothumbs'] = "category";
    $Style['selectedrow'] = "inside";
    $Style['menubar'] = "selectedrow";
    $Style['menubarnb'] = "";
    $Style['catcolumn'] = "inside";
    $Style['photocol'] = "inside";
    $Style['commentscol'] = "inside";
    $Style['lastphocol'] = "inside";
    $Style['lastcommcol'] = "inside";
    $Style['small'] = "font-size: 8pt;";
    $Style['medium'] = "font-size: 10pt;";
    $Style['large'] = "font-size: 12pt;";
    $Style['welcome'] = "selectedrow";
    $Style['inside'] = "inside";
    $Style['alternatetable'] = "category";
    $Style['formboxes'] = "textarea";
    $Style['blockquote'] = "textarea";
}

?>
